/*
27.05.02 - w opcji RAPORT FISKALNY DOBOWY wylaczono poprzedzajace : raport
           zmianowy i wyplata gotowki
02.04.03 - zmiana if len(_asys)<21  na if len(_asys)<19 ; jesli w drukarce 
           zaprogramowano tylko 2 niezerowe stawki to LBFSTRQ zwraca 19 tokenow
07.04.03 - LAT_MAZ() w POZ_DRU()
21.10.03 - _typ=3 dla drukarek Wiking z wersj oprogramowanie >2
28.01.04 - _typ=4 dla drukarek DUO PRO wer. 39.1
18.05.05 - wylaczenie posylania DLE     
01.09.15 - zmiany w obsudze komonikacji (biblioteka HBCom z XHarbour) 
07.09.17 - bez komunikatu o zakoczeniu transakcji z bdem

*/
//!
#include "comped.ch"
#include "inkey.ch"
#include "box.ch"
#include "setcurs.ch"
#include "error.ch"
#include "hbcom.ch"                                                  //01.09.15

#define ESC chr(27)
#define ENQ chr(5)
#define CR chr(13)
#define LF chr(10)
#define FF chr(12)
#define BEL chr(7)
#define CAN chr(18)

#define PRN_T  5000

*******************************************************************************
FUNCTION INIT_DR(_info)

DEFAULT _info to .t.

if _priorytet=11.or.;
   (val(subs(_wersja,82,1))>0.and.val(subs(_wersja,82,1))<>val(numer_stan))

  RETURN NIL
endi

LF_TXT()

inkey(0.01)

HB_COMCLOSE(_port_dru)    //01.09.15

IF ! hb_comOpen( _port_dru )                                         //01.09.15
  if _info
     QKE( "Nie mona otworzy portu (1) !")
  endif
  BREAK     
ELSE
  
  IF ! hb_comInit( _port_dru, 9600, "N", 8, 1 )
     if _info
       QKE( "Nie mona zainicjowa portu !")
     endif
    BREAK  
  endif
     
ENDIF
   
/*                                                                   //01.09.15
COM_CLOSE(_port_dru)  
COM_OPEN(_port_dru,1000)
COM_SOFT(_port_dru,.T.)

if !COM_INIT(_port_dru,9600,"N",8,1)
  if _info
     QKE( "Nie mona zainicjowa portu !")
  endi
  BREAK
endif
*/                                                                   //01.09.15

*----------------- posanie numeru kasy i kodu operatora do drukarki fisdkalnej
// brak implementacji w DP300
*------------------------------------------------------------------------------
//COM_DTR(_port_dru,.T.)                                             //01.09.15
RETU NIL
*******************************************************************************
FUNCTION SEND_DRU(lancuch,timeout,_info)
// posyanie acucha po jednym znaku z badaniem XOFF przed kadym znakiem
local _i ,nresult                                                    //01.09.15

DEFAULT _info to .t.

SEND_TXT(lancuch)                                             //07.11.15 BAFPOL

if _priorytet=11.or.;
   (val(subs(_wersja,82,1))>0.and.val(subs(_wersja,82,1))<>val(numer_stan))

  RETURN NIL
endi

nResult := hb_comSend( _port_dru, lancuch, len( lancuch ), 3000 )    //01.09.15
IF nResult != len( lancuch )
       if _info
          QKE("Przekroczony czas nadawania !")
       endif
                  
       BREAK
endif       

/*    
                                                               //01.09.15
for _i:=1 to len(lancuch)
  WAITPERIOD(timeout*100)
  if  !COM_SOFT_R(_port_dru)   
    COM_SEND(_port_dru,subs(lancuch,_i,1))
  else
//  do while  WAITPERIOD() .and. ISBIT(COM_SMODE(_port_dru),2); endd //22.03.14 xhb
    do while  WAITPERIOD() .and. COM_SOFT_R(_port_dru); endd
    if !WAITPERIOD() 
       if _info
          QKE("Przekroczony czas nadawania !")
       endi
       COM_SFLUSH(_port_dru)
       BREAK
    else
      COM_SEND(_port_dru,subs(lancuch,_i,1))
    endif
  endif
next
*/                                                                   //01.09.15

RETU NIL

*******************************************************************************
FUNCTION HC(_h)       // konwersja zapisu hexadecym. na znak ASCII np. HC("0F")
RETURN chr(CTON(_h,16))

*******************************************************************************
FUNCTION VAT_DRU(v,stawki)                        // znaki stawki podatkowej ST
// parametr stawki jest 5-bajtowym cigiem uzyskanym funkcj DAJ_STAWKI()
local _r,_tvat,_poz

_tvat:=chr(val(v)) ; _poz:=at(_tvat,stawki)

// UWAGA ! megavat moe miec stawki VAT (_tvat) : "23", "12", " 8", " 0", "zw"
//         jeli drukarka nie miaaby zaprogramowanej ktrej z tych stawek
//         to _poz=0 i f-cja VAT_DRU() zwrci "A" czyli do drukarki pjdzie
//         towar z VAT 22%  !!!! 22.09.96

if     v="zw"
  _r:="Z"
elseif _poz>=1 .and. _poz<=5
  _r:=chr(64+_poz)
else
   TONE(220,5)
   QKE("Drukarka nie ma zaprogramowanej stawki "+v+" !!")
*   BREAK
  _r:="x"  // wymuszenie bdu
  
endif
RETU _r

*******************************************************************************
FUNCTION DAJ_STAWKI()
local _chksum,dokasy,_s,_i,_tn,asys:={},_liczba_stawek
/*
*/

if _priorytet=11.or.;
   (val(subs(_wersja,82,1))>0.and.val(subs(_wersja,82,1))<>val(numer_stan))

  RETURN _s:=chr(7)+chr(22)+chr(8)+chr(23)+chr(0)             //10.04.13 BAFPOL
endi

INIT_DR()
_chksum:=CHECKSUM("1#e")
dokasy:=ESC+"P1#e"+_chksum+ESC+"\" // przeczenie na softwarow obsug bdw
SEND_DRU(dokasy,_time_tra)

_chksum:=CHECKSUM("0#s")
dokasy:=ESC+"P0#s"+_chksum+ESC+"\" // status 
SEND_DRU(dokasy,_time_tra)
_s:=READ_DRU2(,_time_tra)

_liczba_stawek:=(NUMAT("/",_s)-2)/2
_liczba_stawek:=round(_liczba_stawek,0)-1

TOKENINIT(@_s,";/")
do while !TOKENEND()
  _tn:=TOKENNEXT(_s)
  aadd(asys,_tn)
enddo
_chksum:=CHECKSUM("0#e")
dokasy:=ESC+"P0#e"+_chksum+ESC+"\"  //komunikaty o bdach na wywietlaczu
SEND_DRU(dokasy,_time_tra)
inkey(0.01)
HB_COMCLOSE(_port_dru)                                               //01.09.15
if len(asys)<13
   QKE("ODEBRANO NIEKOMPLETN INFORMACJ O STANIE DRUKARKI !")
   BREAK
endi
_s:=""
for _i:=1 to _liczba_stawek
  _s:=_s+chr(val(asys[9+_i]))
next
if _s==repl(chr(0),_liczba_stawek)
  QKE("BLD ODCZYTU STAWEK VAT Z DRUKARKI FISKALNEJ !")
  BREAK
endi
RETURN _s

*******************************************************************************
FUNCTION READ_DRU(dlugosc,timeout)
// odebranie acucha o dlugoci - dlugosc
local _ret:="",cString:=space(dlugosc) ,nresult                      //01.09.15

if _priorytet=11.or.;
   (val(subs(_wersja,82,1))>0.and.val(subs(_wersja,82,1))<>val(numer_stan))

  RETURN ""
endi

nResult := hb_comRecv( _port_dru, @cString, dlugosc, 3000)           //01.09.15

if  nresult<>dlugosc
     QKE("Przekroczony czas odbioru !")
     BREAK
endif

/*                                                                   //01.09.15
WAITPERIOD(timeout*100)
do while ( !COM_COUNT(_port_dru)=dlugosc    .and.  WAITPERIOD());   enddo
if ! WAITPERIOD()
   QKE("Przekroczony czas odbioru !")
   BREAK
endif
do while COM_COUNT(_port_dru)>0
  _ret:=_ret+COM_READ(_port_dru,1)
enddo
*/                                                                   //01.09.15

_ret:=cString                                                        //01.09.15
READ_TXT(_ret)

RETU _ret

*******************************************************************************
FUNCTION READ_DRU2(mnoznik,timeout,_info)
// odebranie acucha o dlugoci - dlugosc
local _ret:=""   ,cString:=" "                                       //01.09.15

DEFAULT mnoznik TO 1
DEFAULT _info to .t.

if _priorytet=11.or.;
   (val(subs(_wersja,82,1))>0.and.val(subs(_wersja,82,1))<>val(numer_stan))

  RETURN ""
endi

/*                                                                   //01.09.15
WAITPERIOD(timeout*100*mnoznik)
do while ( !COM_COUNT(_port_dru)>1 .and.  WAITPERIOD());   enddo

WAITPERIOD(timeout*100*mnoznik)
do while  !(subs(_ret,-2,2)==ESC+"\") .and.  WAITPERIOD()
  _ret:=_ret+COM_READ(_port_dru,1)
enddo
if ! WAITPERIOD()
   if _info
      QKE("Przekroczony czas odbioru !")
   endi
   BREAK
endif
*/                                                                   //01.09.15

//altd()
do while  !(subs(_ret,-2,2)==ESC+"\")                                //01.09.15
   cString:=" "
   nResult := hb_comRecv( _port_dru, @cString, 1, 3000)
   if  nresult<>1
     QKE("Przekroczony czas odbioru !")
     BREAK
   endif
   
  _ret+=cString
enddo



READ_TXT(_ret)

RETU _ret

*******************************************************************************
FUNCTION ST_CH(x)
// funkcja zamienia lacuch cyfr x na cig znakw o kodach 
// odpowiadajcych cyfrom "230" -> chr(2)+chr(3)+chr(0)
local i,_ret:=""
for i:=1 to len(x)
  _ret:=_ret+chr(val(subs(x,i,1)))
next
RETURN _ret

*******************************************************************************
FUNCTION ZNAK(_z)       
local _r:=row(),_c:=col(),_l:=0,_znaki:={}
*   ͻ    ͻ ͻ    ͻ ͻ ͻ ͻ  
*        ͼ  ͹ ͹ ͻ ͻ    ͹ ͹  
*   ͼ     ͼ    ͼ ͼ    ͼ ͼ     

aadd(_znaki,{"0","ͻ"," ","ͼ",4})
aadd(_znaki,{"1","  ","  ","  ",4})
aadd(_znaki,{"2","ͻ","ͼ","",4})
aadd(_znaki,{"3","ͻ"," ͹","ͼ",4})
aadd(_znaki,{"4"," ","͹","  ",4})
aadd(_znaki,{"5","","ͻ","ͼ",4})
aadd(_znaki,{"6","ͻ","ͻ","ͼ",4})
aadd(_znaki,{"7","ͻ","  ","  ",4})
aadd(_znaki,{"8","ͻ","͹","ͼ",4})
aadd(_znaki,{"9","ͻ","͹","ͼ",4})
aadd(_znaki,{"-","   ","","   ",4})
aadd(_znaki,{"+","   ","","   ",4})
aadd(_znaki,{"*","   ","","   ",4})
aadd(_znaki,{" ","   ","   ","   ",4})
aadd(_znaki,{".","   ","   ","  ",4})
aadd(_znaki,{",","   ","   ","  ",4})


_l:=ascan(_znaki,{|x| x[1]=_z })

if _l>0
  if _r>22.or._c>80-_znaki[_l][5]; tone(880,0.5); RETURN NIL;  endi
//  if _znaki[_l][5]=0.and._c>0; _c:=_c-1; endi
  devpos(_r,  _c); devout(_znaki[_l][2])
  devpos(_r+1,_c); devout(_znaki[_l][3])
  devpos(_r+2,_c); devout(_znaki[_l][4])
  devpos(_r,_c+_znaki[_l][5])  // +if(_znaki[_l][5]=0,1,0))
endi
RETURN NIL

*******************************************************************************
FUNCTION TEKST(_t)
local _i
for _i:=1 to len(_t); ZNAK(subs(_t,_i,1)); next
RETURN NIL

*******************************************************************************
FUNCTION SEND_TXT(_s)
local _t:="",_i,_a

if _send_txt

  for _i:=1 to len(_s)
    if (_a:=asc(subs(_s,_i,1))) < 32
      _t:=_t+"chr("+ltrim(str(_a))+")"
    else
      _t:=_t+subs(_s,_i,1) //+" "         //07.11.15 BAFPOL
    endi
  next
  FWriteLn( nhandle_s,_t)
endi
RETURN NIL

*******************************************************************************
FUNCTION CMD_TXT(_s)
local _t:="",_i,_a
for _i:=1 to len(_s)
  if (_a:=asc(subs(_s,_i,1))) < 32
    _t:=_t+"chr("+ltrim(str(_a))+")"
  else
    _t:=_t+subs(_s,_i,1)
  endi
next
RETURN _t

*******************************************************************************
FUNCTION READ_TXT(_s)
local _t:="",_i,_a
if _send_txt                                                  //07.11.15 BAFPOL

  for _i:=1 to len(_s)
    if (_a:=asc(subs(_s,_i,1))) < 32
      _t:=_t+"chr("+ltrim(str(_a))+") "
    else
      _t:=_t+subs(_s,_i,1)+" "
    endi
  next
  FWriteLn( nhandle_r,_t)
endi
RETURN NIL

*******************************************************************************
FUNCTION LF_TXT()
local st:=val(subs(_wersja,82,1))
if _send_txt                                                  //07.11.15 BAFPOL
  FWriteLn( nhandle_s,"")
endi
RETURN NIL

*******************************************************************************
FUNCTION DRU_OK(_transakcja)                      // badanie gotowoci drukarki
                                            // nie stosowa wewntrz transakcji
local _ret:=1, dokasy:="",_chksum:="",_s:="",asys:={},_b
local _blady:={;
     "01 - NIE ZAINICJOWANY ZEGAR RTC",;
     "02 - BD BAJTU KONTROLNEGO ROZKAZU",;
     "03 - ZA LICZBA PARAMETRW ROZKAZU",;
     "04 - BD PARAMETRW ROZKAZU",;
     "05 - BD OPERACJI Z ZEGAREM RTC",;
     "06 - BD OPERACJI Z MODUEM FISKALNYM",;
     "07 - DATA DRUKARKI WCZENIEJSZA NI DATA ZAPISU DO PAMICI FISKALNEJ ",;
     "08 - NIEZEROWE LICZNIKI (TOTALIZERY) DRUKARKI",;
     "09 - BD OPERACJI WEJCIA/WYJCIA LUB BD DRUKARKI",;
     "10 - ZMIANA CZASU WYKRACZA POZA ZAKRES  30 MIN TEJ SAMEJ DOBY",;
     "11 - BD LICZBY STAWEK PTU LUB BD WARTOCI STAWEK PTU",;
     "12 - BDNY NAGWEK (ZA DUGI LUB NIEDOZWOLONE ZNAKI)",;
     "13 - PRBA FISKALIZACJI URZDZENIA ZAFISKALIZOWANEGO",;
     "14 - PRBA POSANIA NAGLWKA DO URZDZENIA ZAFISKALIZOWANEGO",;
     "15 - BDNE DODATKOWE LINIE NAGWKA (ZA DUGIE LUB NIEDOZWOLONE ZNAKI)",;
     "16 - BDNA NAZWA POZYCJI (PUSTA LUB ZA DUGA)",;
     "17 - BDNE OZNACZENIE ILOCI POZYCJI (PUSTE LUB ZA DUGIE)",;
     "18 - BRAK LUB BDNE OZNACZENIE STAWKI PTU POZYCJI",;
     "19 - BD CENY POZYCJI (SYNTAKTYKA, ZAKRES LUB BRAK)",;
     "20 - BD WARTOCI BRUTTO POZYCJI (SYNTAKTYKA, ZAKRES LUB BRAK)",;
     "21 - SEKWENCJA POZYCJI PARAGONU ODEBRANA POZA TRYBEM TRANSAKCJI",;
     "22 - BD OPERACJI STORNO POZYCJI",;
     "23 - BDNA LICZBA POZYCJI PARAGONU",;
     "24 - PRZEPENIENIE BUFORA DRUKARKI",;
     "25 - BDNY KOD TERMINALA/KASJERA (DUGO LUB FORMAT)",;
     "26 - BD KWOTY WPATY",;
     "27 - BDNA SUMA CAKOWITA TOTAL",;
     "28 - PRZEPENIENIE TOTALIZERA",;
     "29 - DANIE ZAKOCZENIA TRANSAKCJI POZA TRYBEM TRANSAKCJI",;
     "30 - BD KWOTY WPATY LUB WYPATY Z KASY",;
     "31 - PRZEKROCZENIE ZAKRESU GOTWKI W KASIE",;
     "32 - UJEMNA WARTO GOTWKI W KASIE PO WYPACIE (WYZEROWANIE KASY)",;
     '33 - BD NAPISU "ZMIANA" W RAPORCIE KASY/ZMIANY',;
     '34 - BD NAPISU "KASJER" W RAPORCIE KASY/ZMIANY',;
     "35 - ZEROWY STAN TOTALIZERW PRZY PRBIE RAPORTU DOBOWEGO",;
     "36 - ISTNIEJE JU ZAPIS RAPORTU DOBOWEGO Z T DAT",;
     "37 - OPERACJA PRZERWANA Z KLAWIATURY",;
     "38 - BD NAZWY PODCZAS KONTROLI BAZY DANYCH",;
     "39 - BD OZNACZENIA STAWKI PTU PODCZAS KONTROLI BAZY DANYCH";     
      }



DEFAULT _transakcja TO .f.

if _priorytet=11.or.;
   (val(subs(_wersja,82,1))>0.and.val(subs(_wersja,82,1))<>val(numer_stan))

  RETU 0
endi

BEGIN SEQUENCE

if _transakcja.and._test_daty
  if date()<>(_d_dru:=DATA_DRU(_test_daty)).and.!empty(_d_dru)
    TONE(220,5)
    QKE("Data komputera nie jest zgodna z dat drukarki fiskalnej ",;
        "           lub bd komunikacji z drukark !             ")
    _ret:=2
    BREAK
  endi
  if empty(_d_dru)
    _ret:=1
    BREAK
  endi
endi

INIT_DR() 

_chksum:=CHECKSUM("1#e")
dokasy:=ESC+"P1#e"+_chksum+ESC+"\"             // softwarow obsuga bdw
SEND_DRU(dokasy,_time_tra)

_chksum:=CHECKSUM("0#s")
dokasy:=ESC+"P0#s"+_chksum+ESC+"\"     
SEND_DRU(dokasy,_time_tra) 
_s:=READ_DRU2(,_time_tra)

TOKENINIT(@_s,";/")
do while !TOKENEND()
  _tn:=TOKENNEXT(_s)
  aadd(asys,_tn)
enddo

_chksum:=CHECKSUM("0#e")
dokasy:=ESC+"P0#e"+_chksum+ESC+"\"  //komunikaty o bdach na wywietlaczu
SEND_DRU(dokasy,_time_tra)
inkey(0.01)
HB_COMCLOSE(_port_dru)                                               //01.09.15

if len(asys)<4
   QKE("ODEBRANO NIEKOMPLETN INFORMACJ O STANIE DRUKARKI !")
   BREAK
endi

if (_b:=subs(asys[1],6))<>"0"
  TONE(440,0.5)

  if val(_b)<=len(_blady)
    QKE(_blady[val(_b)])
  else
    QKE("BD WYKONANIA ROZKAZU LUB BD KOMUNIKACJI Z DRUKARK FISKALN")
  endi

  _ret:=2
  BREAK
endi

if subs(asys[3],1,1)="1"             // ostatnia transakcja nie jest zakoczona

    INIT_DR()
    _chksum:=CHECKSUM("0$e")         // anulowanie transakcji
    dokasy:=ESC+"P0$e"+_chksum+ESC+"\"
    SEND_DRU(dokasy,_time_tra)
    tone(220,4)
    QKE("Anulowano niedokoczon transakcj !")               //25.03.15 BAFPOL
    _ret:=0
    BREAK
endi

if _transakcja .and. subs(asys[4],1,1)="0"
  TONE(440,0.5)
//  QKE("Uwaga : Ostatnia transakcja zostaa zakoczona z bdem !") //07.09.17
  _ret:=0
  BREAK
endi
_ret:=0

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15

RETU _ret

*******************************************************************************
FUNCTION POZ_DRU(_poz,_nazwa,_ilosc,_vat,_cena,_wartosc,_stawki)
local _r:="",_nmaz:=""

if upper(chr(145))=chr(144)
  _nmaz:=_nazwa
elseif upper(chr(169))=chr(168)
  _nmaz:=LAT_MAZ(_nazwa)
endif

/*                                                            //25.03.15 BAFPOL
_r:=ltrim(str(_poz,2,0))+;        
      "$l"+;
      padr(_nmaz,40)+;
      CR+;
      padl(FR(transform(_ilosc,_format_ilo)),10)+;
      CR+;
      VAT_DRU(_vat,_stawki)+;
      "/"+;
      padl(FR(transform(_cena,_format_cen)),11)+;
      "/"+;
      padl(FR(transform(_wartosc,_format_war)),11)+;
      "/"
*/

_r:=ltrim(str(_poz,3,0))+;                                    //25.03.15 BAFPOL
      "$l"+;
      padr(_nmaz,40)+;
      CR+;
      str(_ilosc,10,3)+;
      CR+;
      VAT_DRU(_vat,_stawki)+;
      "/"+;
      str(_cena,9,2)+;
      "/"+;
      str(_wartosc,9,2)+;
      "/"

RETURN _r

*******************************************************************************
FUNCTION FR(_s)   // 1. usuwa kropki i spacje 2. zamienia  przecinki na kropki 
_s:=ltrim(_s)
RETURN strtran(strtran(_s,"."),",",".")

*******************************************************************************
FUNCTION ODBLOK_DRU()
local _tex:=  '۲  ODBLOKOWANIE DRUKARKI  '
local dokasy,_chksum

cls
@ 0,0 say _tex

QKE("Przydziel drukark fiskaln !")

BEGIN SEQUENCE
INIT_DR()  
_chksum:=CHECKSUM("0$e")
dokasy:=CAN+ESC+"P0$e"+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)

_chksum:=CHECKSUM("0#e")
dokasy:=ESC+"P0#e"+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
RETURN NIL

*******************************************************************************
FUNCTION SEND_CMD(lancuch,timeout) // nie moe by stotsowana do rozkazw
                            // ktrych realizacja trwa duej od timeout-u !
local _nrb:=0,_chksum,dokasy,_s,_s1,_s2,asys:={}
local _blady:={;
     "01 - NIE ZAINICJOWANY ZEGAR RTC",;
     "02 - BD BAJTU KONTROLNEGO ROZKAZU",;
     "03 - ZA LICZBA PARAMETRW ROZKAZU",;
     "04 - BD PARAMETRW ROZKAZU",;
     "05 - BD OPERACJI Z ZEGAREM RTC",;
     "06 - BD OPERACJI Z MODUEM FISKALNYM",;
     "07 - DATA DRUKARKI WCZENIEJSZA NI DATA ZAPISU DO PAMICI FISKALNEJ ",;
     "08 - NIEZEROWE LICZNIKI (TOTALIZERY) DRUKARKI",;
     "09 - BD OPERACJI WEJCIA/WYJCIA LUB BD DRUKARKI",;
     "10 - ZMIANA CZASU WYKRACZA POZA ZAKRES  30 MIN TEJ SAMEJ DOBY",;
     "11 - BD LICZBY STAWEK PTU LUB BD WARTOCI STAWEK PTU",;
     "12 - BDNY NAGWEK (ZA DUGI LUB NIEDOZWOLONE ZNAKI)",;
     "13 - PRBA FISKALIZACJI URZDZENIA ZAFISKALIZOWANEGO",;
     "14 - PRBA POSANIA NAGLWKA DO URZDZENIA ZAFISKALIZOWANEGO",;
     "15 - BDNE DODATKOWE LINIE NAGWKA (ZA DUGIE LUB NIEDOZWOLONE ZNAKI)",;
     "16 - BDNA NAZWA POZYCJI (PUSTA LUB ZA DUGA)",;
     "17 - BDNE OZNACZENIE ILOCI POZYCJI (PUSTE LUB ZA DUGIE)",;
     "18 - BRAK LUB BDNE OZNACZENIE STAWKI PTU POZYCJI",;
     "19 - BD CENY POZYCJI (SYNTAKTYKA, ZAKRES LUB BRAK)",;
     "20 - BD WARTOCI BRUTTO POZYCJI (SYNTAKTYKA, ZAKRES LUB BRAK)",;
     "21 - SEKWENCJA POZYCJI PARAGONU ODEBRANA POZA TRYBEM TRANSAKCJI",;
     "22 - BD OPERACJI STORNO POZYCJI",;
     "23 - BDNA LICZBA POZYCJI PARAGONU",;
     "24 - PRZEPENIENIE BUFORA DRUKARKI",;
     "25 - BDNY KOD TERMINALA/KASJERA (DUGO LUB FORMAT)",;
     "26 - BD KWOTY WPATY",;
     "27 - BDNA SUMA CAKOWITA TOTAL",;
     "28 - PRZEPENIENIE TOTALIZERA",;
     "29 - DANIE ZAKOCZENIA TRANSAKCJI POZA TRYBEM TRANSAKCJI",;
     "30 - BD KWOTY WPATY LUB WYPATY Z KASY",;
     "31 - PRZEKROCZENIE ZAKRESU GOTWKI W KASIE",;
     "32 - UJEMNA WARTO GOTWKI W KASIE PO WYPACIE (WYZEROWANIE KASY)",;
     '33 - BD NAPISU "ZMIANA" W RAPORCIE KASY/ZMIANY',;
     '34 - BD NAPISU "KASJER" W RAPORCIE KASY/ZMIANY',;
     "35 - ZEROWY STAN TOTALIZERW PRZY PRBIE RAPORTU DOBOWEGO",;
     "36 - ISTNIEJE JU ZAPIS RAPORTU DOBOWEGO Z T DAT",;
     "37 - OPERACJA PRZERWANA Z KLAWIATURY",;
     "38 - BD NAZWY PODCZAS KONTROLI BAZY DANYCH",;
     "39 - BD OZNACZENIA STAWKI PTU PODCZAS KONTROLI BAZY DANYCH";     
      }

_chksum:=CHECKSUM("1#e")
dokasy:=ESC+"P1#e"+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)          // przeczenie na softwarow obsug bw

SEND_DRU(lancuch,timeout)           // waciwy rozkaz

_chksum:=CHECKSUM("0#s")            // sprawdzenie kodu bdu
dokasy:=ESC+"P0#s"+_chksum+ESC+"\"     
SEND_DRU(dokasy,_time_tra)
_s:=READ_DRU2(,_time_tra)
TOKENINIT(@_s,";/")
do while !TOKENEND()
 _tn:=TOKENNEXT(_s)
 aadd(asys,_tn)
enddo
_chksum:=CHECKSUM("0#e")
dokasy:=ESC+"P0#e"+_chksum+ESC+"\"  //komunikaty o bdach na wywietlaczu
SEND_DRU(dokasy,_time_tra)
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
if len(asys)<1
   QKE("ODEBRANO NIEKOMPLETN INFORMACJ O STANIE DRUKARKI !")
   BREAK
endi

_nrb:=val(subs(asys[1],6))
if _nrb>0

  _s1:=padr("BD NUMER "+trans0(_nrb,2)+" !",20)  // na LED
  _s2:=spac(20)
  _s:=FF+_s1+CR+LF+_s2
  dokasy:=ESC+"P2$d"+_s+ESC+"\"
  SEND_DRU(dokasy,_time_tra)

  if _nrb<=len(_blady)
    QKE(_blady[_nrb])
  else
    QKE("BD WYKONANIA ROZKAZU LUB BD KOMUNIKACJI Z DRUKARK FISKALN")
  endi

  _s1:=spac(20)  // kasuj LED
  _s2:=spac(20)
  _s:=FF+_s1+CR+LF+_s2
  dokasy:=ESC+"P2$d"+_s+ESC+"\"
  SEND_DRU(dokasy,_time_tra)

endi

_chksum:=CHECKSUM("0#e")
dokasy:=ESC+"P0#e"+_chksum+ESC+"\"  // komunikaty o bdach na wywietlacz
SEND_DRU(dokasy,_time_tra)

RETURN NIL

*******************************************************************************
FUNCTION BLEDY()
cls
@ 0,0 to 24,79 double
@ 2,5 say "                 WYKAZ BDW DRUKARKI FISKALNEJ DF-301"
@  4,4 say "01 - NIE ZAINICJOWANY ZEGAR RTC"
@  5,4 say "02 - BD BAJTU KONTROLNEGO ROZKAZU"
@  6,4 say "03 - ZA LICZBA PARAMETRW ROZKAZU"
@  7,4 say "04 - BD PARAMETRW ROZKAZU"
@  8,4 say "05 - BD OPERACJI Z ZEGAREM RTC"
@  9,4 say "06 - BD OPERACJI Z MODUEM FISKALNYM"
@ 10,4 say "07 - DATA DRUKARKI WCZENIEJSZA NI DATA ZAPISU DO PAMICI FISKALNEJ "
@ 11,4 say "08 - NIEZEROWE LICZNIKI (TOTALIZERY) DRUKARKI"
@ 12,4 say "09 - BD OPERACJI WEJCIA/WYJCIA LUB BD DRUKARKI"
@ 13,4 say "10 - ZMIANA CZASU WYKRACZA POZA ZAKRES  30 MIN TEJ SAMEJ DOBY"
@ 14,4 say "11 - BD LICZBY STAWEK PTU LUB BD WARTOCI STAWEK PTU"
@ 15,4 say "12 - BDNY NAGWEK (ZA DUGI LUB NIEDOZWOLONE ZNAKI"
@ 16,4 say "13 - PRBA FISKALIZACJI URZDZENIA ZAFISKALIZOWANEGO"
@ 17,4 say "14 - PRBA POSANIA NAGLWKA DO URZDZENIA ZAFISKALIZOWANEGO"
@ 18,4 say "15 - BDNE DODATKOWE LINIE NAGWKA (ZA DUGIE LUB NIEDOZWOLONE ZNAKI"
@ 19,4 say "16 - BDNA NAZWA POZYCJI (PUSTA LUB ZA DUGA)"
@ 20,4 say "17 - BDNE OZNACZENIE ILOCI POZYCJI (PUSTE LUB ZA DUGIE)"
@ 21,4 say "18 - BRAK LUB BDNE OZNACZENIE STAWKI PTU POZYCJI"
@ 22,4 say "19 - BD CENY POZYCJI (SYNTAKTYKA, ZAKRES LUB BRAK)"
inkey(0)
@ 1,1 clea to 23,78

@  2,4 say "20 - BD WARTOCI BRUTTO POZYCJI (SYNTAKTYKA, ZAKRES LUB BRAK)"
@  3,4 say "21 - SEKWENCJA POZYCJI PARAGONU ODEBRANA POZA TRYBEM TRANSAKCJI"
@  4,4 say "22 - BD OPERACJI STORNO POZYCJI"
@  5,4 say "23 - BDNA LICZBA POZYCJI PARAGONU"
@  6,4 say "24 - PRZEPENIENIE BUFORA DRUKARKI"
@  7,4 say "25 - BDNY KOD TERMINALA/KASJERA (DUGO LUB FORMAT)"
@  8,4 say "26 - BD KWOTY WPATA"
@  9,4 say "27 - BDNA SUMA CAKOWITA TOTAL"
@ 10,4 say "28 - PRZEPENIENIE TOTALIZERA"
@ 11,4 say "29 - DANIE ZAKOCZENIA TRANSAKCJI POZA TRYBEM TRANSAKCJI"
@ 12,4 say "30 - BD KWOTY WPATY LUB WYPATY Z KASY"
@ 13,4 say "31 - PRZEKROCZENIE ZAKRESU GOTWKI W KASIE"
@ 14,4 say "32 - UJEMNA WARTO GOTWKI W KASIE PO WYPACIE (WYZEROWANIE KASY)"
@ 15,4 say '33 - BD NAPISU "ZMIANA" W RAPORCIE KASY/ZMIANY'
@ 16,4 say '34 - BD NAPISU "KASJER" W RAPORCIE KASY/ZMIANY'
@ 17,4 say "35 - ZEROWY STAN TOTALIZERW PRZY PRBIE RAPORTU DOBOWEGO"
@ 18,4 say "36 - ISTNIEJE JU ZAPIS RAPORTU DOBOWEGO Z T DAT"
@ 19,4 say "37 - OPERACJA PRZERWANA Z KLAWIATURY"
@ 20,4 say "38 - BD NAZWY PODCZAS KONTROLI BAZY DANYCH"
@ 21,4 say "39 - BD OZNACZENIA STAWKI PTU PODCZAS KONTROLI BAZY DANYCH"     

inkey(0)
RETURN NIL

*******************************************************************************
FUNCTION TEST_DF301()
local dokasy:="", _wybor,_kwota:=0,_strkwota,_strcheck,_checksum,_status
local _tex:='۲  TEST  ',asys:={},_tn,_s:="",_i,;
      _data_od,_data_do,_data:=date(),_czas:="  :  ",;
      _s1:="",_s2:="",_s3:="",_s4:="",_s5:="",_s6:="",_b,;
      _cza:="",_rok,_mie,_dzi,_god,_min
local _liczba_stawek
local _wp,_typ:=0
priv _ss1,_ss2,_ss3,_ss4,_ss5,_ss6
cls
@ 0,0 say _tex

DO WHILE .T.

@ 1,0 clea to 24,79
BEGIN SEQUENCE

_wp:=0
@ 1+_wp ,0 prompt "1.  INFORMACJE SYSTEMOWE"
@ 2+_wp, 0 prompt "2.  STATUS JEDNOBAJTOWY"
@ 3+_wp ,0 prompt "3.  TEST GOTOWOCI DRUKARKI I WYDRUKU PARAGONU"
@ 4+_wp ,0 prompt "4.  WYBR TRYBU OBSUGI BDW"
*@ 5+_wp ,0 prompt "5.  BDNA SEKWENCJA"
@ 5+_wp ,0 prompt "5.  TYP DRUKARKI I WERSJA OPROGRAMOWANIA"
@ 6+_wp ,0 prompt "6.  ANULOWANIE TRANSAKCJI" 
@ 7+_wp ,0 prompt "7.  POWRT DO PTLI GWNEJ"  
@ 8+_wp ,0 prompt "8.  WPISANIE NAGLWKA" 
@ 9+_wp ,0 prompt "9.  USTAWIENIE DATY I CZASU"
@ 10+_wp,0 prompt "10. ODCZYT DATY I CZASU"
@ 11+_wp,0 prompt "11. WYWIETLENIE DATY I CZASU"
@ 12+_wp,0 prompt "12. WYWIETLANIE OPERACJI KASOWYCH"
@ 13+_wp,0 prompt "13. WYWIETLENIE KOMUNIKATU"
@ 14+_wp,0 prompt "14. SKASOWANIE KOMUNIKATU"
@ 15+_wp,0 prompt "15. OTWARCIE SZUFLADY"
@ 16+_wp,0 prompt "16. SYGNA  - BEL"
@ 17+_wp,0 prompt "17. WPATA DO KASY"
@ 18+_wp,0 prompt "18. WYPATA Z KASY"
@ 19+_wp,0 prompt "19. STAN KASY"
@ 20+_wp,0 prompt "20. RAPORT KASY/ZMIANY"
@ 21+_wp,0 prompt "21. RAPORT OKRESOWY" 
@ 22+_wp,0 prompt "22. RAPORT DOBOWY"
@ 23+_wp,0 prompt "23. KONTROLA BAZY DANYCH" 
@ 24+_wp,0 prompt "24. ODCZYT STAWEK VAT" 

menu to _wybor
@ 1,0 clear to 24,79
if _wybor=0; BREAK; endif

INIT_DR()
do case

  *----------------------------------------------------------------------------
  case _wybor=1
    @ 1,0 say "1. INFORMACJE SYSTEMOWE  - #s"
    asys:={}
    _chksum:=CHECKSUM("1#e")
    dokasy:=ESC+"P1#e"+_chksum+ESC+"\"             // softwarow obsuga bdw
    SEND_DRU(dokasy,_time_tra)
    _chksum:=CHECKSUM("0#s")
    dokasy:=ESC+"P0#s"+_chksum+ESC+"\"     
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)
    _s:=READ_DRU2(,_time_tra)

    _liczba_stawek:=(NUMAT("/",_s)-2)/2
    _liczba_stawek:=round(_liczba_stawek,0)-1

    TOKENINIT(@_s,";/")
    do while !TOKENEND()
      _tn:=TOKENNEXT(_s)
      aadd(asys,_tn)
    enddo
    _chksum:=CHECKSUM("0#e")
    dokasy:=ESC+"P0#e"+_chksum+ESC+"\"   //komunikaty o bdach na wywietlaczu
    SEND_DRU(dokasy,_time_tra)
    if len(asys)<19                                                  //02.04.03
      QKE("ODEBRANO NIEKOMPLETN INFORMACJ O STANIE DRUKARKI !")
      inkey(0.01)
      HB_COMCLOSE(_port_dru)    //01.09.15
      BREAK
    endi
    @ 3,0 say "CMD (2) = "+(_b:=subs(asys[1],6))+ " - ostatni rozkaz wykonany "+;
              if(_b="0","prawidowo","bdnie ("+_b+")")
    @ 4,0 say "FSK (3) = "+(_b:=subs(asys[2],1,1))+ " - drukarka w trybie "+;
              if(_b="0","szkoleniowym","fiskalnym")
    @ 5,0 say "PAR (1) = "+(_b:=subs(asys[3],1,1))+ " - drukarka w trybie "+;
              if(_b="1",'"transakcja"','"nie transakcja"')
    @ 6,0 say "TRF (0) = "+(_b:=subs(asys[4],1,1))+ " - ostatnia transakcja"+;
              " zakoczona "+ if(_b="1","prawidowo","bdnie")
    @ 9,0 say "Format kwot : "+(_b:=subs(asys[5],1,1))+;
               if(_b="1","- po denominacji","- przed denominacj")
    @ 10,0 say "Liczba zerowa RAM : "+(_b:=asys[6])
    @ 11,0 say "Data ostatniego zapisu : "+asys[9]+"."+asys[8]+"."+asys[7]




    @ 12,0 say "Stawki VAT :"+" A = "+asys[10]+;
                              " B = "+asys[11]+;
                              " C = "+asys[12]+;
                              " D = "+asys[13]+;
         if(_liczba_stawek>=5," E = "+asys[14],"")+;
         if(_liczba_stawek=6 ," F = "+asys[15],"")
    @ 13,0 say "Liczba paragonw : "+(_b:=asys[14+_liczba_stawek-4])
    @ 14,0 say "Warto brutto w stawce A : "+(_b:=asys[15+_liczba_stawek-4])
    @ 15,0 say "Warto brutto w stawce B : "+(_b:=asys[16+_liczba_stawek-4])
    @ 16,0 say "Warto brutto w stawce C : "+(_b:=asys[17+_liczba_stawek-4])
    @ 17,0 say "Warto brutto w stawce D : "+(_b:=asys[18+_liczba_stawek-4])
    if _liczba_stawek>=5
      @ 18,0 say "Warto brutto w stawce E : "+(_b:=asys[19+_liczba_stawek-4])
    endi
    if _liczba_stawek=6
      @ 19,0 say "Warto brutto w stawce F : "+(_b:=asys[20+_liczba_stawek-4])
    endi
    @ 18+_liczba_stawek-4,0 say "Warto brutto w stawce Z : "+(_b:=asys[19+2*(_liczba_stawek-4)])
    @ 19+_liczba_stawek-4,0 say "Stan gotwki w kasie :      "+(_b:=asys[20+2*(_liczba_stawek-4)])
    @ 20+_liczba_stawek-4,0 say "Numer unikatowy :           "+(_b:=subs(asys[21+2*(_liczba_stawek-4)],1,11))

  *----------------------------------------------------------------------------
  case _wybor=2
    @ 1,0 say "2. STATUS JEDNOBAJTOWY  - ENQ"
    _chksum:=CHECKSUM("1#e")
    dokasy:=ESC+"P1#e"+_chksum+ESC+"\"             // softwarow obsuga bdw
    SEND_DRU(dokasy,_time_tra)
    @ 23,0 say "Sekwencja : "+ENQ
    SEND_DRU(ENQ,_time_tra)
    _status:=READ_DRU(1,_time_tra)
    _bst:=padl(NTOC(ASC(_status),2),8,"0")
    @ 4,0 say "Bajt statusu : "+ _bst
    @ 5,0 say "FSK (3) = "+(_b:=subs(_bst,5,1))+ " - drukarka w trybie "+;
              if(_b="0","szkoleniowym","fiskalnym")
    @ 6,0 say "CMD (2) = "+(_b:=subs(_bst,6,1))+ " - ostatni rozkaz wykonany "+;
              if(_b="1","prawidowo","bdnie")
    @ 7,0 say "PAR (1) = "+(_b:=subs(_bst,7,1))+ " - drukarka w trybie "+;
              if(_b="1",'"transakcja"','"nie transakcja"')
    @ 8,0 say "TRF (0) = "+(_b:=subs(_bst,8,1))+ " - ostatnia transakcja"+;
              " zakoczona "+ if(_b="1","prawidowo","bdnie")
    _chksum:=CHECKSUM("0#e")
    dokasy:=ESC+"P0#e"+_chksum+ESC+"\"   //komunikaty o bdach na wywietlaczu
    SEND_DRU(dokasy,_time_tra)

  *----------------------------------------------------------------------------
  case _wybor=3
    @ 1,0 say "3. TEST DRUKARKI  - funkcja DRU_OK() i wydruk paragonu"
    @ 2,0 say "Wynik testu gotowoci drukarki : ";
               +if(DRU_OK()=0,"GOTOWA","BRAK GOTOWOCI")

    if QTN("Wydruk paragonu ?")
      
      INIT_DR()  // bo w DRU_OK() jest HB_COMCLOSE()                 //01.09.15

      dokasy:=ESC+"P1;1$hCOMPED"+CR+"95"+ESC+"\"        // pocztek transakcji
      SEND_DRU(dokasy,_time_tra)
      wait "Pocztek transakcji. Nacinij klawisz ..."

      dokasy:=ESC+"P1$lNAZWA TOWARU                            "+CR+;
         "1               "+CR+"Z/0.01/0.01/8B"+ESC+"\"    // linijka paragonu
      SEND_DRU(dokasy,_time_tra)
      wait "Linijka paragonu. Nacinij klawisz ..."

      dokasy:=ESC+"P1;0$e01A"+CR+"0.01/0.01/C9"+ESC+"\"        // koniec transakcji
      SEND_DRU(dokasy,_time_tra)
      wait "Koniec transakcji. Nacinij klawisz ..."

    endi

  *----------------------------------------------------------------------------
  case _wybor=4
    @ 1,0 say "4. WYBR TRYBU OBSUGI BDW  - #e LBSERM"
    _i:=0
    @ 2,0  say "Tryb :" get _i pict "9" range 0,1
    @ 2,10 say "( 0 - sprztowy, 1 - programowy )"
    set cursor on; read; set cursor off
    if lastkey()=K_ESC; BREAK; endi
    if _i=0
      // tryb komunikatw o bdach na wywietlaczu
      _chksum:=CHECKSUM("0#e")
      dokasy:=ESC+"P0#e"+_chksum+ESC+"\"
    else
      // tryb programowej obsugi bdw
      _chksum:=CHECKSUM("1#e")
      dokasy:=ESC+"P1#e"+_chksum+ESC+"\"
    endi
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)

  *----------------------------------------------------------------------------
/*
  case _wybor=5
    @ 1,0 say "5. BDNA SEKWENCJA"
    dokasy:=ESC+"P0#t"+"00"+ESC+"\"
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)
*/
  case _wybor=5
    @ 1,0 say "5.  TYP DRUKARKI I WERSJA OPROGRAMOWANIA - #v"

    _typ:=DAJ_TYP()
    @ 1,col()+2 say "*"+str(_typ,2)+"*"

    if _typ=0
      QKE("Sekwencja tylko dla drukarek z homologacj 2001 ")
    else
      INIT_DR()
      asys:={}
      _chksum:=CHECKSUM("1#e")
      dokasy:=ESC+"P1#e"+_chksum+ESC+"\"             // softwarow obsuga bdw
      SEND_DRU(dokasy,_time_tra)
  
      _chksum:=CHECKSUM("#v")
      dokasy:=ESC+"P#v"+_chksum+ESC+"\"     
      @ 23,0 say "Sekwencja : "+dokasy
      SEND_DRU(dokasy,_time_tra)
      _s:=READ_DRU2(,_time_tra)
      TOKENINIT(@_s,"/")
      do while !TOKENEND()
        _tn:=TOKENNEXT(_s)
        aadd(asys,_tn)
      enddo
      _chksum:=CHECKSUM("0#e")
      dokasy:=ESC+"P0#e"+_chksum+ESC+"\"   //komunikaty o bdach na wywietlaczu
       SEND_DRU(dokasy,_time_tra)
      if len(asys)<2
        QKE("ODEBRANO NIEKOMPLETN INFORMACJ O STANIE DRUKARKI !")
        inkey(0.01)
        HB_COMCLOSE(_port_dru)    //01.09.15
        BREAK
      endi
      @ 3,0 say "Typ :                   "+subs(asys[1],6)+str(_typ,4)
      @ 4,0 say "Wersja oprogramowania : "+subs(asys[2],1)
    endi
  *----------------------------------------------------------------------------
  case _wybor=6
    @ 1,0 say "6. ANULOWANIE TRANSAKCJI  - $e LBTREXIT" 
    _chksum:=CHECKSUM("0$e")
    dokasy:=ESC+"P0$e"+_chksum+ESC+"\"
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)

  *----------------------------------------------------------------------------
  case _wybor=7
    @ 1,0 say "7. POWRT DO PTLI GWNEJ  - CAN i $e" 
    _chksum:=CHECKSUM("0$e")
    dokasy:=CAN+ESC+"P0$e"+_chksum+ESC+"\"
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)

  *----------------------------------------------------------------------------
  case _wybor=8
    @ 1,0 say "8. WPISANIE NAGLWKA  - $f LBSETHDR" 
    _s1:=spac(40); _s2:=spac(40); _s3:=spac(40)
    _s4:=spac(40); _s5:=spac(40); _s6:=spac(40)

    do while .t.
      @ 2,0  say "Nagwek :" get _s1 pict repl("X",40)
      @ 3,0  say "          " get _s2 pict repl("X",40)
      @ 4,0  say "          " get _s3 pict repl("X",40)
      @ 5,0  say "          " get _s4 pict repl("X",40)
      @ 6,0  say "          " get _s5 pict repl("X",40)
      @ 7,0  say "          " get _s6 pict repl("X",40)
      set cursor on; read; set cursor off
      if lastkey()=K_ESC; BREAK; endi
      
      _i:=len(rtrim(_s1)+rtrim(_s2)+rtrim(_s3)+;
              rtrim(_s4)+rtrim(_s5)+rtrim(_s6))+5
       if _i>217
         QKE("Przekroczono maksymaln liczb 217 znakw !")
       else
    *     if QTN("Akceptacja nagwka ?")
           exit
    *     endi
       endi
     endd       

     _s:=""
     _ss:={_s1,_s2,_s3,_s4,_s5,_s6}
     for _i:=1 to 6
       _ss[_i]:=rtrim(strtran(_ss[_i],"[",chr(14)))
       _ss[_i]:=rtrim(strtran(_ss[_i],"]",chr(20)))
       _s:=_s+_ss[_i]+CR
     next
     do while subs(_s,-2,2)==CR+CR 
       _s:=subs(_s,1,len(_s)-1)
     enddo
     _s:="0$f"+_s+CHR(255)
     _chksum:=CHECKSUM(_s)
     dokasy:=ESC+"P"+_s+_chksum+ESC+"\"+BEL
     @ 20,0 say "Sekwencja : "+subs(dokasy,1,68)
     @ 21,0 say "            "+subs(dokasy,69,68)
     @ 22,0 say "            "+subs(dokasy,137,68)
     @ 23,0 say "            "+subs(dokasy,205,68)
     SEND_DRU(dokasy,_time_tra)

  *----------------------------------------------------------------------------
  case _wybor=9
    @ 1,0 say "9. USTAWIENIE DATY I CZASU  - $c LBSETCK"
    @ 2,0 say "Data i czas : " get _data
    @ 2,25 get _czas pict "99:99" vali val(subs(_czas,1,2))<=24;
                              .and.val(subs(_czas,1,2))>=0;
                              .and.val(subs(_czas,4,2))<=59;
                              .and.val(subs(_czas,4,2))>=0
    set curs on; read; set curs off
    if lastkey()=K_ESC; BREAK; endi

    _s1:=dtoc(_data)
    _s:=subx(_s1,7,2)+";"+subx(_s1,4,2)+";"+subx(_s1,1,2)+";"+;
        subx(_czas,1,2)+";"+subx(_czas,4,2)+";"+"0"+"$c"
    _chksum:=CHECKSUM(_s)
    dokasy:=ESC+"P"+_s+_chksum+ESC+"\"
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)

  *----------------------------------------------------------------------------
  case _wybor=10
    @ 1,0 say "10. ODCZYT DATY I CZASU  - #c LBSENDCK"
    _czas:=""
    _chksum:=CHECKSUM("#c")
    dokasy:=ESC+"P#c"+_chksum+ESC+"\"
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)

//05.01.00

_czas+=READ_DRU2(1,_time_tra)  //29.10.96

//05.01.00
_czas:=subs(_czas,6)
_rok:=subs(_czas,1,at(";",_czas)-1)
_czas:=subs(_czas,at(";",_czas)+1)
_mie:=subs(_czas,1,at(";",_czas)-1)
_czas:=subs(_czas,at(";",_czas)+1)
_dzi:=subs(_czas,1,at(";",_czas)-1)
_czas:=subs(_czas,at(";",_czas)+1)
_god:=subs(_czas,1,at(";",_czas)-1)
_czas:=subs(_czas,at(";",_czas)+1)
_min:=subs(_czas,1,at(";",_czas)-1)

    @ 5,0 say "Data i czas :  "+;
      padl(_dzi,2,"0")+"."+padl(_mie,2,"0")+"."+padl(_rok,2,"0")+"  "+;
      padl(_god,2,"0")+":"+padl(_min,2,"0")

  *----------------------------------------------------------------------------
  case _wybor=11
    @ 1,0 say "11. WYWIETLENIE DATY I CZASU  - $d LBDSP"
    _chksum:=CHECKSUM("3$d")
    dokasy:=ESC+"P3$d"+_chksum+ESC+"\"
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)

  *----------------------------------------------------------------------------
  case _wybor=12
    @ 1,0 say "12. WYWIETLANIE OPERACJI KASOWYCH  - $d LBDSP"
    _chksum:=CHECKSUM("4$d")
    dokasy:=ESC+"P4$d"+_chksum+ESC+"\"
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)

  *----------------------------------------------------------------------------
  case _wybor=13
    @ 1,0 say "13. WYWIETLENIE KOMUNIKATU  - $d LBDSP"
    _s1:=spac(20); _s2:=spac(20)
    @ 2,0  say "Komunikat :" get _s1 pict repl("X",20)
    @ 3,0  say "           " get _s2 pict repl("X",20)
    set cursor on; read; set cursor off
    if lastkey()=K_ESC; BREAK; endi
    _s:=FF+_s1+CR+LF+_s2
    dokasy:=ESC+"P2$d"+_s+ESC+"\"
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)

  *----------------------------------------------------------------------------
  case _wybor=14
    @ 1,0 say "14. SKASOWANIE KOMUNIKATU  - $d LBDSP"
    _s:=FF
    dokasy:=ESC+"P2$d"+_s+ESC+"\"
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)

  *----------------------------------------------------------------------------
  case _wybor=15
    @ 1,0 say "15. OTWARCIE SZUFLADY  - $d LBDSP"
    _chksum:=CHECKSUM("1$d")
    dokasy:=ESC+"P1$d"+_chksum+ESC+"\"
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)

  *----------------------------------------------------------------------------
  case _wybor=16
    @ 1,0 say "16. SYGNA  - BEL"
    @ 23,0 say "Sekwencja : "+BEL
    SEND_DRU(BEL,_time_tra)

  *----------------------------------------------------------------------------
  case _wybor=17
    _kwota:=0
    @ 1,0 say "17. WPATA DO KASY  - #i LBINCCSH"
    @ 2,0 say "Kwota :" get _kwota pict "99999999.99" valid _kwota>=0
    set cursor on; read; set cursor off
    if lastkey()=K_ESC; BREAK; endi
    _strkwota:=ltrim(transform(_kwota,"99999999.99"))
    _strcheck:="0#i"+_strkwota+"/"
    _chksum:=CHECKSUM(_strcheck)
    dokasy:=ESC+"P0#i"+_strkwota+"/"+_chksum+ESC+"\"
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)

  *----------------------------------------------------------------------------
  case _wybor=18
    _kwota:=0
    @ 1,0 say "18. WYPATA Z KASY  - #d LBDECCSH"
    @ 2,0 say "Kwota :" get _kwota pict "99999999.99" valid _kwota>=0
    set cursor on; read; set cursor off
    if lastkey()=K_ESC; BREAK; endi
    _strkwota:=ltrim(transform(_kwota,"99999999.99"))
    _strcheck:="0#d"+_strkwota+"/"
    _chksum:=CHECKSUM(_strcheck)
    dokasy:=ESC+"P0#d"+_strkwota+"/"+_chksum+ESC+"\"
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)

  *----------------------------------------------------------------------------
  case _wybor=19
    @ 1,0 say "19. STAN KASY  - #t LBCSHSTS"
    _chksum:=CHECKSUM("0#t")
    dokasy:=ESC+"P0#t"+_chksum+ESC+"\"
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)

  *----------------------------------------------------------------------------
  case _wybor=20
    @ 1,0 say "20. RAPORT KASY/ZMIANY  - #k LBCSHREP"
    _i:=0
    _s:=spac(32)
    @ 2,0  say "Zmiana :" get _i pict "@Z 99" range 1,99
    @ 3,0  say "Kasjer :" get _s pict "@! "+repl("X",32)
    set cursor on; read; set cursor off
    if lastkey()=K_ESC; BREAK; endi
    _chksum:=CHECKSUM("0#k"+str(_i,2)+CR+alltrim(_s)+CR)
    dokasy:=ESC+"P0#k"+str(_i,2)+CR+alltrim(_s)+CR+_chksum+ESC+"\"
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)

  *----------------------------------------------------------------------------
  case _wybor=21
    @ 1,0 say "21. RAPORT OKRESOWY  - #o LBFSKREP" 
    _data_od:=date()-day(date())+1
    _data_do:=date()
    @ 2,0 say "Okres raportu : " get _data_od ;
                        valid _data_od <= date().and.DODATY(_data_od,@_data_do)
    @ 2,26 say "-" get _data_do;
                        valid _data_do <= date().and._data_do>=_data_od
    set curs on; read; set curs off
    if lastkey()=K_ESC; BREAK; endif
    _s1:=dtoc(_data_od)
    _s2:=dtoc(_data_do)
    _s:=subx(_s1,7,2)+";"+subx(_s1,4,2)+";"+subx(_s1,1,2)+";"+;
        subx(_s2,7,2)+";"+subx(_s2,4,2)+";"+subx(_s2,1,2)+"#o"
    _chksum:=CHECKSUM(_s)
                   
    dokasy:=ESC+"P"+_s+_chksum+ESC+"\"
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)

  *----------------------------------------------------------------------------
  case _wybor=22
    @ 1,0 say "22. RAPORT DOBOWY  - #r LBDAYREP"
    _chksum:=CHECKSUM("0#r")
    dokasy:=ESC+"P0#r"+_chksum+ESC+"\"
    @ 23,0 say "Sekwencja : "+dokasy
    SEND_DRU(dokasy,_time_tra)
 
  *----------------------------------------------------------------------------
  case _wybor=23
    @ 1,0 say "23. KONTROLA BAZY DANYCH  - #b LBDBREP" 
    _s1:=spac(40)
    _s2:=spac(1)
    @ 2,0 say "Nazwa :     " get _s1 pict "@! "+repl("X",40) 
    @ 3,0 say "Stawka VAT :" get _s2 pict "@! A" vali _s2$"ABCDZ "
    set curs on; read; set curs off
    if lastkey()=K_ESC; BREAK; endif

    _s:="0#b"
    _chksum:=CHECKSUM(_s)
    dokasy:=ESC+"P"+_s+_chksum+ESC+"\"
    _s:="1#b"+alltrim(_s1)+CR+_s2+"/"
    _chksum:=CHECKSUM(_s)
    dokasy:=dokasy+ESC+"P"+_s+_chksum+ESC+"\"
/*
    *--------- kolejna pozycja
    _s:="1#b"+alltrim(_s1)+CR+_s2+"/"
    _chksum:=CHECKSUM(_s)
    dokasy:=dokasy+ESC+"P"+_s+_chksum+ESC+"\"
    *---------
*/
    _s:="2#b"
    _chksum:=CHECKSUM(_s)
    dokasy:=dokasy+ESC+"P"+_s+_chksum+ESC+"\"
    SEND_DRU(dokasy,_time_tra)
    @ 23,0 say "Sekwencja : "+dokasy

  *----------------------------------------------------------------------------
  case _wybor=24
*    @ 1,0 say "24. ZMIANA STAWEK VAT  - $p LBSETPTU"
    @ 1,0 say "24. ODCZYT STAWEK VAT  - $p LBSETPTU"

    *-------------------------------------------------------- odczyt stawek VAT
    asys:={}
    _chksum:=CHECKSUM("1#e")
    dokasy:=ESC+"P1#e"+_chksum+ESC+"\"             // softwarow obsuga bdw
    SEND_DRU(dokasy,_time_tra)

    _chksum:=CHECKSUM("0#s")
    dokasy:=ESC+"P0#s"+_chksum+ESC+"\"     
    SEND_DRU(dokasy,_time_tra)
    _s:=READ_DRU2(,_time_tra)

    _liczba_stawek:=(NUMAT("/",_s)-2)/2
    _liczba_stawek:=round(_liczba_stawek,0)-1

    TOKENINIT(@_s,";/")
    do while !TOKENEND()
      _tn:=TOKENNEXT(_s)
      aadd(asys,_tn)
    enddo
    _chksum:=CHECKSUM("0#e")
    dokasy:=ESC+"P0#e"+_chksum+ESC+"\"   //komunikaty o bdach na wywietlaczu
    SEND_DRU(dokasy,_time_tra)
    if len(asys)<19                                                  //02.04.03
      QKE("ODEBRANO NIEKOMPLETN INFORMACJ O STANIE DRUKARKI !")
      inkey(0.01)
      HB_COMCLOSE(_port_dru)    //01.09.15
      BREAK
    endi
    _ss1:=str(val(asys[10]),2)
    _ss2:=str(val(asys[11]),2)
    _ss3:=str(val(asys[12]),2)
    _ss4:=str(val(asys[13]),2)
    if _liczba_stawek>=5
      _ss5:=str(val(asys[14]),2)
    endi
    if _liczba_stawek=6
      _ss6:=str(val(asys[15]),2)
    endi
    *------------------------------------------------ koniec odczytu stawek VAT
    @ 2,0 say "Stawka A : " + _ss1 //pict "99" //vali SS()
    @ 3,0 say "Stawka B : " + _ss2 //pict "99" //vali SS()
    @ 4,0 say "Stawka C : " + _ss3 //pict "99" //vali SS()
    @ 5,0 say "Stawka D : " + _ss4 //pict "99" //vali SS()
    if _liczba_stawek>=5
      @ 6,0 say "Stawka E : " + _ss5 //pict "99" //vali SS()
    endi
    if _liczba_stawek=6
      @ 7,0 say "Stawka F : " + _ss6 //pict "99" //vali SS()
    endi
    inkey(0)

/*
    set curs on; read; set curs off
    if lastkey()=K_ESC; BREAK; endi
    
    if _ss1==str(val(asys[10]),2).and.;
             _ss2==str(val(asys[11]),2).and.;
             _ss3==str(val(asys[12]),2).and.;
             _ss4==str(val(asys[13]),2)
      QKE("Nie zaproponowano zmiany stawek VAT !")

    elseif QTN("Akceptacja nowych stawek VAT ?")
      _ss1:=alltrim(_ss1)
      _ss2:=alltrim(_ss2)
      _ss3:=alltrim(_ss3)
      _ss4:=alltrim(_ss4)

      _s:="0$p"+_ss1+"/"+_ss2+"/"+_ss3+"/"+_ss4+"/"
      _chksum:=CHECKSUM(_s)
      dokasy:=ESC+"P"+_s+_chksum+ESC+"\"
      @ 23,0 say "Sekwencja : "+dokasy
      SEND_DRU(dokasy,_time_tra)
    endi
*/
  *----------------------------------------------------------------------------
endcase
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15

@ 24,0 say "KONIEC"
inkey(0)

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
if lastkey()=K_ESC; exit; endi
ENDD
RETURN NIL

*******************************************************************************
FUNCTION SUBX(s,m,n)
local t
t:=subs(s,m,n)
if subs(t,1,1)="0"; t:=subs(t,2); endi
RETURN T

*******************************************************************************
FUNCTION SS()  
local _s:=Eval(MemVarBlock(readvar()))
_s:=str(val(_s),len(_s))
Eval(MemVarBlock(readvar()),_s)
RETURN .t.

*******************************************************************************
FUNCTION STA_DRU(_info)
local _tex:=  '۲  STAN DRUKARKI  '
local _chkdsk,dokasy,_s,_tn,asys:={},_liczba_stawek

DEFAULT _info to .t.

if _info
   cls
   @ 0,0 say _tex
endi

BEGIN SEQUENCE

INIT_DR(_info)
_chksum:=CHECKSUM("1#e")
dokasy:=ESC+"P1#e"+_chksum+ESC+"\" // przeczenie na softwarow obsug bdw
SEND_DRU(dokasy,_time_tra,_info)

_chksum:=CHECKSUM("0#s")
dokasy:=ESC+"P0#s"+_chksum+ESC+"\" // status   
SEND_DRU(dokasy,_time_tra,_info)
_s:=READ_DRU2(,_time_tra,_info)

_liczba_stawek:=(NUMAT("/",_s)-2)/2
_liczba_stawek:=round(_liczba_stawek,0)-1

TOKENINIT(@_s,";/")
do while !TOKENEND()
  _tn:=TOKENNEXT(_s)
  aadd(asys,_tn)
enddo
_chksum:=CHECKSUM("0#e")
dokasy:=ESC+"P0#e"+_chksum+ESC+"\"  //komunikaty o bdach na wywietlaczu
SEND_DRU(dokasy,_time_tra,_info)
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
if len(asys)<19                                                  //02.04.03
   if _info
      QKE("ODEBRANO NIEKOMPLETN INFORMACJ O STANIE DRUKARKI !")
   endi
   BREAK
endi

if _info
  @ 2,0 say "CMD (2) = "+(_b:=subs(asys[1],6))+ " - ostatni rozkaz wykonany "+;
                if(_b="0","prawidowo","bdnie ("+_b+")")
  @ 3,0 say "FSK (3) = "+(_b:=subs(asys[2],1,1))+ " - drukarka w trybie "+;
                if(_b="0","szkoleniowym","fiskalnym")
  @ 4,0 say "PAR (1) = "+(_b:=subs(asys[3],1,1))+ " - drukarka w trybie "+;
                if(_b="1",'"transakcja"','"nie transakcja"')
  @ 5,0 say "TRF (0) = "+(_b:=subs(asys[4],1,1))+ " - ostatnia transakcja"+;
                " zakoczona "+ if(_b="1","prawidowo","bdnie")
  @ 6,0 say "Format kwot : "+(_b:=subs(asys[5],1,1))+;
                 if(_b="1","- po denominacji","- przed denominacj")
  @ 7,0 say "Liczba zerowa RAM : "+(_b:=asys[6])
  @ 8,0 say "Data ostatniego zapisu : "+asys[9]+"."+asys[8]+"."+asys[7]

  @ 12,0 say "Stawki VAT :"+" A = "+asys[10]+;
                            " B = "+asys[11]+;
                            " C = "+asys[12]+;
                            " D = "+asys[13]+;
       if(_liczba_stawek>=5," E = "+asys[14],"")+;
       if(_liczba_stawek=6 ," F = "+asys[15],"")
  @ 13,0 say "Liczba paragonw : "+(_b:=asys[14+_liczba_stawek-4])
  @ 14,0 say "Warto brutto w stawce A : "+(_b:=asys[15+_liczba_stawek-4])
  @ 15,0 say "Warto brutto w stawce B : "+(_b:=asys[16+_liczba_stawek-4])
  @ 16,0 say "Warto brutto w stawce C : "+(_b:=asys[17+_liczba_stawek-4])
  @ 17,0 say "Warto brutto w stawce D : "+(_b:=asys[18+_liczba_stawek-4])
  if _liczba_stawek>=5
    @ 18,0 say "Warto brutto w stawce E : "+(_b:=asys[19+_liczba_stawek-4])
  endi
  if _liczba_stawek=6
    @ 19,0 say "Warto brutto w stawce F : "+(_b:=asys[20+_liczba_stawek-4])
  endi
  @ 18+_liczba_stawek-4,0 say "Warto brutto w stawce Z : "+(_b:=asys[19+2*(_liczba_stawek-4)])
  @ 19+_liczba_stawek-4,0 say "Stan gotwki w kasie :      "+(_b:=asys[20+2*(_liczba_stawek-4)])
  @ 20+_liczba_stawek-4,0 say "Numer unikatowy :           "+(_b:=subs(asys[21+2*(_liczba_stawek-4)],1,11))
  inkey(0)
endi



END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15

RETU NIL

*******************************************************************************
FUNCTION RAPORT_STA()
local _tex:=  '۲  STATUS DRUKARKI  '
local _chkdsk,dokasy,_s

cls
@ 0,0 say _tex

BEGIN SEQUENCE
INIT_DR()

_chksum:=CHECKSUM("1#e")
dokasy:=ESC+"P1#e"+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)          // przeczenie na softwarow obsug bw
SEND_DRU(ENQ,_time_tra)
_status:=READ_DRU(1,_time_tra)

_bst:=padl(NTOC(ASC(_status),2),8,"0")
@ 2,0 say "Bajt statusu : "+ _bst
@ 3,0 say "FSK (3) = "+(_b:=subs(_bst,5,1))+ " - drukarka w trybie "+;
              if(_b="0","szkoleniowym","fiskalnym")
@ 4,0 say "CMD (2) = "+(_b:=subs(_bst,6,1))+ " - ostatni rozkaz wykonany "+;
              if(_b="1","prawidowo","bdnie")
@ 5,0 say "PAR (1) = "+(_b:=subs(_bst,7,1))+ " - drukarka w trybie "+;
              if(_b="1",'"transakcja"','"nie transakcja"')
@ 6,0 say "TRF (0) = "+(_b:=subs(_bst,8,1))+ " - ostatnia transakcja"+;
              " zakoczona "+ if(_b="1","prawidowo","bdnie")
    
_chksum:=CHECKSUM("0#e")
dokasy:=ESC+"P1#e"+_chksum+ESC+"\"         // trybu komunikatw na wywietlaczu
SEND_DRU(dokasy,_time_tra)

inkey(0)

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
RETU NIL

*******************************************************************************
FUNCTION WPL_KAS()
local _tex:=  '۲  WPATA GOTWKI DO KASY  '
local dokasy,_chksum,_s,_kwota:=0

cls
@ 0,0 say _tex

BEGIN SEQUENCE

@ 2,0 say "Kwota wpaty :" get _kwota pict "99999999.99" valid _kwota>=0
set cursor on; read; set cursor off
if lastkey()=K_ESC; BREAK; endi

QKE("Przydziel drukark fiskaln !")
INIT_DR()  

_kwota:=ltrim(transform(_kwota,"99999999.99"))
_s:="0#i"+_kwota+"/"
_chksum:=CHECKSUM(_s)
dokasy:=ESC+"P"+_s+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
RETURN NIL

*******************************************************************************
FUNCTION WYP_KAS()
local _tex:=  '۲  WYPLATA GOTWKI Z KASY  '
local dokasy,_chksum,_s,_kwota:=0

cls
@ 0,0 say _tex

BEGIN SEQUENCE

@ 2,0 say "Kwota wypaty :" get _kwota pict "99999999.99" valid _kwota>=0
set cursor on; read; set cursor off
if lastkey()=K_ESC; BREAK; endi

QKE("Przydziel drukark fiskaln !")

INIT_DR()  
_kwota:=ltrim(transform(_kwota,"99999999.99"))
_s:="0#d"+_kwota+"/"
_chksum:=CHECKSUM(_s)
dokasy:=ESC+"P"+_s+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
RETURN NIL

*******************************************************************************
FUNCTION BKAS()
local _tex:=  '۲  BIECY STAN KASY  '
local dokasy,_chksum

cls
@ 0,0 say _tex

QKE("Przydziel drukark fiskaln !")

BEGIN SEQUENCE
INIT_DR()  
_chksum:=CHECKSUM("0#t")
dokasy:=ESC+"P0#t"+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
RETURN NIL

*******************************************************************************
FUNCTION DATA_CZAS()
local _tex:=  '۲  ODCZYT DATY I CZASU  '
local _chkdsk,dokasy,_czas:="",_rok,_mie,_dzi,_god,_min

cls
@ 0,0 say _tex

BEGIN SEQUENCE

INIT_DR()
_chksum:=CHECKSUM("#c")
dokasy:=ESC+"P#c"+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)
/*
do while !(right(_czas,2)==chr(K_ESC)+"\")
  _czas+=READ_DRU(1,_time_tra)
enddo
*/
_czas+=READ_DRU2(1,_time_tra)  //29.10.96

//05.01.00
_czas:=subs(_czas,6)
_rok:=subs(_czas,1,at(";",_czas)-1)
_czas:=subs(_czas,at(";",_czas)+1)
_mie:=subs(_czas,1,at(";",_czas)-1)
_czas:=subs(_czas,at(";",_czas)+1)
_dzi:=subs(_czas,1,at(";",_czas)-1)
_czas:=subs(_czas,at(";",_czas)+1)
_god:=subs(_czas,1,at(";",_czas)-1)
_czas:=subs(_czas,at(";",_czas)+1)
_min:=subs(_czas,1,at(";",_czas)-1)

@ 2,0 say "Data i czas :  "+;
      padl(_dzi,2,"0")+"."+padl(_mie,2,"0")+"."+padl(_rok,2,"0")+"  "+;
      padl(_god,2,"0")+":"+padl(_min,2,"0")

*------- wyswietlenie
_chksum:=CHECKSUM("3$d")
dokasy:=ESC+"P3$d"+_chksum+ESC+"\"
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15

inkey(0)
END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
RETU NIL

*******************************************************************************
FUNCTION USTAW_ZEGAR()
local _tex:=  '۲  PRZESTAWIENIE ZEGARA  ',_korekta:=0,;
      _data:=date(),_czas:="  :  "

cls
@ 0,0 say _tex
@ 2,0 say "Uwaga : Zegar mona przestawi jeden raz o co najwyej   30 minut"
@ 3,0 say "        w obrbie tej samej doby i przy wyzerowanych totalizerach."

_data:=DATA_DRU(.t.)
inkey(0.01)
_czas:=CZAS_DRU(.t.)

@ 5,0 say "Data wedug drukarki : "+dtoc(_data)
@ 6,0 say "Czas wedug drukarki : "+_czas

@ 5,40 say "Data wedug PC : "+dtoc(date())
@ 6,40 say "Czas wedug PC : "+subs(time(),1,5)

@ 7,0 say "Nowy czas drukarki :  " get _czas pict "99:99";
                              vali val(subs(_czas,1,2))<=24;
                              .and.val(subs(_czas,1,2))>=0;
                              .and.val(subs(_czas,4,2))<=59;
                              .and.val(subs(_czas,4,2))>=0
set curs on; read; set curs off
if lastkey()=K_ESC; RETURN NIL; endi

BEGIN SEQUENCE
INIT_DR()
_s1:=dtoc(_data)
_s:=subs(_s1,7,2)+";"+subs(_s1,4,2)+";"+subs(_s1,1,2)+";"+;
        subs(_czas,1,2)+";"+subs(_czas,4,2)+";"+"0"+"$c"
_chksum:=CHECKSUM(_s)
dokasy:=ESC+"P"+_s+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)

inkey(0.5)

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
RETURN NIL

*******************************************************************************
FUNCTION DATA_DRU(_test)
local _date:=ctod(""),_chksum,dokasy,_czas:="",_rok,_mie,_dzi,_god,_min

DEFAULT _test TO .f.

if !_test; RETURN _date; endi

BEGIN SEQUENCE
INIT_DR()
_chksum:=CHECKSUM("#c")
dokasy:=ESC+"P#c"+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)
/*
do while !(right(_czas,2)==chr(K_ESC)+"\")
  _czas+=READ_DRU(1,_time_tra)
enddo
*/
_czas+=READ_DRU2(1,_time_tra) //29.10.96

//05.01.00
_czas:=subs(_czas,6)
_rok:=subs(_czas,1,at(";",_czas)-1)
_czas:=subs(_czas,at(";",_czas)+1)
_mie:=subs(_czas,1,at(";",_czas)-1)
_czas:=subs(_czas,at(";",_czas)+1)
_dzi:=subs(_czas,1,at(";",_czas)-1)

_date:= ctod(padl(_dzi,2,"0")+"."+padl(_mie,2,"0")+"."+padl(_rok,2,"0"))

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
RETURN _date

*******************************************************************************
FUNCTION CZAS_DRU(_test)
local _chksum,dokasy,_czas:="",_rok,_mie,_dzi,_god,_min

DEFAULT _test TO .f.

if !_test; RETURN _czas; endi

BEGIN SEQUENCE
INIT_DR()
_chksum:=CHECKSUM("#c")
dokasy:=ESC+"P#c"+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)
/*
do while !(right(_czas,2)==chr(K_ESC)+"\")
  _czas+=READ_DRU(1,_time_tra)
enddo
*/
_czas+=READ_DRU2(1,_time_tra)  //29.10.96

//05.01.00
_czas:=subs(_czas,6)
_rok:=subs(_czas,1,at(";",_czas)-1)
_czas:=subs(_czas,at(";",_czas)+1)
_mie:=subs(_czas,1,at(";",_czas)-1)
_czas:=subs(_czas,at(";",_czas)+1)
_dzi:=subs(_czas,1,at(";",_czas)-1)
_czas:=subs(_czas,at(";",_czas)+1)
_god:=subs(_czas,1,at(";",_czas)-1)
_czas:=subs(_czas,at(";",_czas)+1)
_min:=subs(_czas,1,at(";",_czas)-1)

_czas:=padl(_god,2,"0")+":"+padl(_min,2,"0")

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
RETURN _czas

*******************************************************************************
FUNCTION STAWKI_VAT()
local _tex:=  '۲  STAWKI VAT  '
local _chkdsk,dokasy,_s,_tn,asys:={},_liczba_stawek

cls
@ 0,0 say  _tex

BEGIN SEQUENCE

INIT_DR()
_chksum:=CHECKSUM("1#e")
dokasy:=ESC+"P1#e"+_chksum+ESC+"\" // przeczenie na softwarow obsug bdw
SEND_DRU(dokasy,_time_tra)

_chksum:=CHECKSUM("0#s")
dokasy:=ESC+"P0#s"+_chksum+ESC+"\" // status    
SEND_DRU(dokasy,_time_tra)
_s:=READ_DRU2(,_time_tra)


_liczba_stawek:=(NUMAT("/",_s)-2)/2
_liczba_stawek:=round(_liczba_stawek,0)-1

TOKENINIT(@_s,";/")

do while !TOKENEND()
  _tn:=TOKENNEXT(_s)
  aadd(asys,_tn)
enddo
_chksum:=CHECKSUM("0#e")
dokasy:=ESC+"P0#e"+_chksum+ESC+"\"  //komunikaty o bdach na wywietlaczu
SEND_DRU(dokasy,_time_tra)
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
if len(asys)<13
   QKE("ODEBRANO NIEKOMPLETN INFORMACJ O STANIE DRUKARKI !")
   BREAK
endi

@ 2,0 say "Stawka A : "+asys[10]+"%"
@ 3,0 say "Stawka B : "+asys[11]+"%"
@ 4,0 say "Stawka C : "+asys[12]+"%"
@ 5,0 say "Stawka D : "+asys[13]+"%"
if _liczba_stawek>=5
  @ 6,0 say "Stawka E : "+asys[14]+"%"
endi
if _liczba_stawek=6
  @ 7,0 say "Stawka F : "+asys[15]+"%"
endi

inkey(0)
END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
RETU NIL

*******************************************************************************
FUNCTION NAZWY_STAWKI()
local _tex:=  '۲  WYDRUK KONTROLNY NAZW I STAWEK VAT  '
local _chkdsk,dokasy,_s,_s1,_s2,_stawki

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use("TOW","R"); BREAK; endif
set index to TOW_IN,TOW_NA

go top
@ 1,0 say "Zaznacz kontrolowane indeksy klawiszem INSERT. "
_zaznaczone:={}
CPEDIT  POZ: 2,,,               ;
        DEF: "TOW"                ;
        POZWER: "V1"              ;
        POZSLAD: spac(1)+subs(NAZWA_TOW,1,30) ;
        PION: ,,,                 ;
        INDEXY: {"indeks","nazwa"}  ;
        ODTWORZ:.f.               

if len(_zaznaczone)>0
   set filter to ascan(_zaznaczone,recn())>0
   QKE("Przydziel drukark fiskaln !")
else
   QKE("Brak zaznaczonych indeksw !")
   BREAK
endif
go top

_stawki:=DAJ_STAWKI()

INIT_DR()

_s:="0#b"
_chksum:=CHECKSUM(_s)
dokasy:=ESC+"P"+_s+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)

do while !eof()

  _s1:=subs(NAZWA_TOW,1,40)
  _s2:=VAT_DRU(VAT,_stawki)

  _s:="1#b"+alltrim(_s1)+CR+_s2+"/"
  _chksum:=CHECKSUM(_s)
  dokasy:=ESC+"P"+_s+_chksum+ESC+"\"
  SEND_DRU(dokasy,_time_tra)
  skip
endd

_s:="2#b"
_chksum:=CHECKSUM(_s)
dokasy:=ESC+"P"+_s+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15

RETU NIL

*******************************************************************************
FUNCTION NAZWY_STA2()                             // do wsppracy z MEGAVAT-em
local _tex:=  '۲  KONTROLA NAZW I STAWEK VAT  '
local _chkdsk,dokasy,_s,_s1,_s2,_stawki


cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use("TOW","S"); BREAK; endi
set index to TOW_IN, TOW_NA, TOW_GR, TOW_SW

_ainde:=if(_indeks_sww="T",{"indeks","nazwa","grupa",},;
                          {"indeks","nazwa","grupa","SWW"})

_wer:="V7|V_OPISY_TOW().and.V_OPAKOWANIA().and.V_INDEKS_SWW().and.V_ZESTAW()"+;
       ".and.V_ILOSC_JM().and.V_KAU().and.V_KONCES()"  //09.01.99

go top
@ 1,0 say "Zaznacz kontrolowane indeksy klawiszem INSERT. "
_zaznaczone:={}

CPEDIT  POZ: 2,,,               ;
        DEF: "TOW"                ;
        POZWER: _wer              ;
        POZSLAD: spac(1)+subs(NAZWA_TOW,1,30)+spac(1)+OPIS_TOW;
             +spac(2)+spac(5)+JM ;                
        PION: ,,,                 ;
        INDEXY: _ainde            ;
        ODTWORZ:.f.               

if len(_zaznaczone)>0
   set filter to ascan(_zaznaczone,recn())>0
   QKE("Przydziel drukark fiskaln !")
else
   QKE("Brak zaznaczonych indeksw !")
   BREAK
endif
go top

_stawki:=DAJ_STAWKI()

INIT_DR()

_s:="0#b"
_chksum:=CHECKSUM(_s)
dokasy:=ESC+"P"+_s+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)

do while !eof()

  _s1:=subs(NAZWA_TOW,1,40)
  _s2:=VAT_DRU(VAT,_stawki)

  _s:="1#b"+alltrim(_s1)+CR+_s2+"/"
  _chksum:=CHECKSUM(_s)
  dokasy:=ESC+"P"+_s+_chksum+ESC+"\"
  SEND_DRU(dokasy,_time_tra)
  skip
endd

_s:="2#b"
_chksum:=CHECKSUM(_s)
dokasy:=ESC+"P"+_s+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15

inkey(1)
RETU NIL

*******************************************************************************
*******************************************************************************
FUNCTION NR_PAR()
local dokasy,_chksum,_nr:=0,asys:={},_s,_tn,_liczba_stawek

if _priorytet=11.or.;
  (val(subs(_wersja,82,1))>0.and.val(subs(_wersja,82,1))<>val(numer_stan))
  RETURN "00000"
endi

BEGIN SEQUENCE
INIT_DR()

_chksum:=CHECKSUM("1#e")
dokasy:=ESC+"P1#e"+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)        // przeczenie na softwarow obsug bdw

_chksum:=CHECKSUM("0#s")
dokasy:=ESC+"P0#s"+_chksum+ESC+"\" // status       
SEND_DRU(dokasy,_time_tra)
_s:=READ_DRU2(,_time_tra)

_liczba_stawek:=(NUMAT("/",_s)-2)/2
_liczba_stawek:=round(_liczba_stawek,0)-1

TOKENINIT(@_s,";/")
do while !TOKENEND()
  _tn:=TOKENNEXT(_s)
  aadd(asys,_tn)
enddo
_chksum:=CHECKSUM("0#e")
dokasy:=ESC+"P0#e"+_chksum+ESC+"\"  //komunikaty o bdach na wywietlaczu
SEND_DRU(dokasy,_time_tra)
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
if len(asys)<14
   QKE("ODEBRANO NIEKOMPLETN INFORMACJ O STANIE DRUKARKI !")
   BREAK
endi
// _nr:=val(asys[14])
_nr:=val(asys[14+_liczba_stawek-4])

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
RETURN trans0(_nr,5)

*******************************************************************************
FUNCTION SZUFLA_ON()
local dokasy,_chksum

if _priorytet=11.or.;
   (val(subs(_wersja,82,1))>0.and.val(subs(_wersja,82,1))<>val(numer_stan))

  RETURN NIL
endi

BEGIN SEQUENCE
INIT_DR()  
_chksum:=CHECKSUM("1$d")
dokasy:=ESC+"P1$d"+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
RETURN NIL

*******************************************************************************
FUNCTION SZUFLA()
local _tex:=  '۲  OTWARCIE SZUFLADY  '
cls
@ 0,0 say _tex

SZUFLA_ON(1)
inkey(1)

RETURN NIL

*******************************************************************************
FUNCTION ZEGAR_ON()
local _tex:=  '۲  WCZENIE ZEGARA  '
local dokasy,_chksum

cls
@ 0,0 say _tex

BEGIN SEQUENCE

INIT_DR()  
_chksum:=CHECKSUM("3$d")
dokasy:=ESC+"P3$d"+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15

inkey(1)
RETURN NIL

*******************************************************************************
FUNCTION ZEGAR_OFF()
local _tex:=  '۲  WYCZENIE ZEGARA  '
local dokasy,_chksum

cls
@ 0,0 say _tex

BEGIN SEQUENCE
INIT_DR()  

_chksum:=CHECKSUM("4$d")
dokasy:=ESC+"P4$d"+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15

inkey(1)
RETURN NIL

*******************************************************************************
FUNCTION READ_PAR()
local _tex:=  '۲  ODCZYT NUMERU OSTATNIEGO PARAGONU  ',_nr:=""
local dokasy,_chksum
cls
@ 0,0 say _tex

BEGIN SEQUENCE
_nr:=NR_PAR()  
@ 2,0 say "Numer ostatniego paragonu : "+_nr
inkey(0)

END SEQUENCE
RETURN NIL

*******************************************************************************
FUNCTION UNIKAT()
local _tex:=  '۲  ODCZYT NUMERU UNIKATOWEGO  ',_nr:=""
local dokasy,_chksum,_s,_tn,asys:={},_liczba_stawek
cls
@ 0,0 say _tex

BEGIN SEQUENCE
INIT_DR()
_chksum:=CHECKSUM("1#e")
dokasy:=ESC+"P1#e"+_chksum+ESC+"\" // przeczenie na softwarow obsug bdw
SEND_DRU(dokasy,_time_tra)

_chksum:=CHECKSUM("0#s")
dokasy:=ESC+"P0#s"+_chksum+ESC+"\" // status    
SEND_DRU(dokasy,_time_tra)
_s:=READ_DRU2(,_time_tra)


_liczba_stawek:=(NUMAT("/",_s)-2)/2
_liczba_stawek:=round(_liczba_stawek,0)-1

TOKENINIT(@_s,";/")
do while !TOKENEND()
  _tn:=TOKENNEXT(_s)
  aadd(asys,_tn)
enddo
_chksum:=CHECKSUM("0#e")
dokasy:=ESC+"P0#e"+_chksum+ESC+"\"  //komunikaty o bdach na wywietlaczu
SEND_DRU(dokasy,_time_tra)
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
if len(asys)<13
   QKE("ODEBRANO NIEKOMPLETN INFORMACJ O STANIE DRUKARKI !")
   BREAK
endi
@ 2,0 say "Numer unikatowy : "+(_b:=subs(asys[21+2*(_liczba_stawek-4)],1,11))
inkey(0)

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
RETURN NIL

*******************************************************************************
FUNCTION DATA_CZAS2()
local _tex:=  '۲  USTAWIENIE ZEGARA PO KASOWANIU CMOS  '
cls
@ 0,0 say _tex
QKE("Brak implementacji dla drukarki DF-301 !")
RETU NIL

*******************************************************************************
FUNCTION RAPORT_BLO()
local _tex:=  '۲  WYDRUK WYKAZU TOWARW ZABLOKOWANYCH  '
cls
@ 0,0 say _tex
QKE("Brak implementacji dla drukarki DF-301 !")
RETU NIL

*******************************************************************************
FUNCTION PONOW_PAR()
local _tex:=  '۲  PONOWIENIE WYDRUKU PARAGONU  '
cls
@ 0,0 say _tex
QKE("Brak implementacji dla drukarki DF-301 !")
RETU NIL

*******************************************************************************
FUNCTION WYSUW()
local _tex:=  '۲  USTAWIENIE LICZBY WYSUWANYCH LINII DOKUMENTU  '
cls
@ 0,0 say _tex
QKE("Brak implementacji dla drukarki DF-301 !")
RETU NIL

*******************************************************************************
FUNCTION RAPORT_OKR(typ)
local _tex1:=  '۲  RAPORT FISKALNY OKRESOWY  ',;
      _tex2:=  '۲  RAPORT OKRESOWY CZNY  '
local _data_od,_data_do,dokasy,_chksum,_s,_s1,_s2

DEFAULT typ TO 1

cls
@ 0,0 say if(typ=1,_tex1,_tex2)

if typ<>1
  QKE("Brak implementacji dla drukarki DF-301 !")
  RETU NIL
endi

BEGIN SEQUENCE

_data_od:=date()-day(date())+1
_data_do:=date()
@ 1,0 say "Okres raportu : " get _data_od ;
                        valid _data_od <= date().and.DODATY(_data_od,@_data_do)
@ 1,26 say "-" get _data_do;
                        valid _data_do <= date().and._data_do>=_data_od
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endif

INIT_DR()

_s1:=dtoc(_data_od)
_s2:=dtoc(_data_do)
_s:=subs(_s1,7,2)+";"+subs(_s1,4,2)+";"+subs(_s1,1,2)+";"+;
        subs(_s2,7,2)+";"+subs(_s2,4,2)+";"+subs(_s2,1,2)+"#o"
_chksum:=CHECKSUM(_s)
dokasy:=ESC+"P"+_s+_chksum+ESC+"\"

SEND_DRU(dokasy,_time_tra)


END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
RETU NIL

*******************************************************************************
FUNCTION RAPORT_FIS()
local _tex:=  '۲  RAPORT FISKALNY DOBOWY  '
local _chkdsk,dokasy,_czas,_s,tn,asys:={},_stan:="0",_i

cls
@ 0,0 say _tex

BEGIN SEQUENCE

if !(DRU_OK()=0.and.QTN("Zapis danych do pamici fiskalnej ?").and. HA(_haslo))
  BREAK
endif


*----------------------------------------------------- raport stanu kasy/zmiany
/*

_i:=0
_s:=spac(32)
@ 2,0  say "Zmiana :" get _i pict "@Z 99" range 1,99
@ 3,0  say "Kasjer :" get _s pict "@! "+repl("X",32)
set cursor on; read; set cursor off
if lastkey()=K_ESC; BREAK; endi

QKE("Przydziel drukark fiskaln !")

INIT_DR()
_chksum:=CHECKSUM("0#k"+str(_i,2)+CR+alltrim(_s)+CR)
dokasy:=ESC+"P0#k"+str(_i,2)+CR+alltrim(_s)+CR+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)

*------------------------------------------------------------ odczyt stanu kasy
_chksum:=CHECKSUM("1#e")
dokasy:=ESC+"P1#e"+_chksum+ESC+"\" // przeczenie na softwarow obsug bdw
SEND_DRU(dokasy,_time_tra)

_chksum:=CHECKSUM("0#s")
dokasy:=ESC+"P0#s"+_chksum+ESC+"\" // status        
SEND_DRU(dokasy,_time_tra)
_s:=READ_DRU2(,_time_tra)
TOKENINIT(@_s,";/")
do while !TOKENEND()
  _tn:=TOKENNEXT(_s)
  aadd(asys,_tn)
enddo
_chksum:=CHECKSUM("0#e")
dokasy:=ESC+"P0#e"+_chksum+ESC+"\"  //komunikaty o bdach na wywietlaczu
SEND_DRU(dokasy,_time_tra)
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
if len(asys)<19                                                  //02.04.03
   QKE("ODEBRANO NIEKOMPLETN INFORMACJ O STANIE DRUKARKI !")
   BREAK
endi
_stan:=asys[20]

*--------------------------------------------------------------- wypata z kasy
if val(_stan)<>0

  INIT_DR()
  _s:="0#d"+_stan+"/"
  _chksum:=CHECKSUM(_s)
  dokasy:=ESC+"P"+_s+_chksum+ESC+"\"
  SEND_DRU(dokasy,_time_tra)
  HB_COMCLOSE(_port_dru)      //01.09.15
endi

*---------------------------------------------------------------- raport dobowy
*/

QKE("Raport fiskalny wymaga potwierdzenia z klawiatury drukarki !")

INIT_DR()  

_chksum:=CHECKSUM("1#e")
dokasy:=ESC+"P1#e"+_chksum+ESC+"\" // przeczenie na softwarow obsug bdw
SEND_DRU(dokasy,_time_tra)

_chksum:=CHECKSUM("0#r")
dokasy:=ESC+"P0#r"+_chksum+ESC+"\"
SEND_DRU(dokasy,_time_tra)

END SEQUENCE
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15
RETU NIL

*******************************************************************************
FUNCTION CONFIG_PAR()
local _tex:='۲  KONFIGURACJA PARAGONW  '
local _gru_par:=" "                                           //25.03.15 BAFPOL

cls
@ 0,0 say _tex
QKE("Opcja dozwolona tylko przed wprowadzeniem danych uytkowych !")
if !(_priorytet>=9.and.HA(_haslo))
 QKE("Brak uprawnie !")
 retu NIL
endi

_use("CONFIG","E!")

_gru_par:=subs(WERSJA,160,1)

@ 2,0 say  "Port drukarki :     " get PORT_DRU pict "9" range 1,4
@ 3,0 say  "Zwoka transmisji : " get TIME_TRA range 0,99
@ 3,24 say "sec"

@ 4,0 say "Test daty drukarki :" get TEST_DATY pict "@! A" ;
                                                vali TEST_DATY$"TN "

if fieldpos("LINIA1")>0.and.fieldpos("LINIA2")>0.and.fieldpos("LINIA3")>0
  @ 7,0 say "Dodatkowe linie w nagwku paragonu :"
  @ 8,0  get LINIA1
  @ 9,0  get LINIA2
  @ 10,0 get LINIA3
endi

if fieldpos("LICZBA_POZ")>0
//  if LICZBA_POZ=0; repl LICZBA_POZ with 90; endi            //25.03.15 BAFPOL
  @ 12,0 say "Maksymalna liczba pozycji paragonu :" get LICZBA_POZ pict "99"
endi
                                                              //25.03.15 BAFPOL
@ 13,0 say "Grupowanie pozycji paragonu (G/ ) :" get _gru_par pict "@! A" vali _gru_par$"G "

@ 15,0 say "Typ POSNET :" get TYP_POSNET                      //25.03.15
set curs on; read; set curs off

repl CONFIG->WERSJA with subs(CONFIG->WERSJA,1,159)+_gru_par+;//25.03.15 BAFPOL
                         subs(CONFIG->WERSJA,161) 
_wersja:=CONFIG->WERSJA
_time_tra:=  if(empty(TIME_TRA),5,TIME_TRA)
_port_dru:=if(empty(PORT_DRU),1,PORT_DRU)  
_test_daty:=if(TEST_DATY=="T",.t.,.f.)
_liczba_poz:=LICZBA_POZ                                       //25.03.15 BAFPOL

repl TIME_TRA with _time_tra,;
     PORT_DRU with _port_dru,;
     TEST_DATY with if(_test_daty,"T","N")
use
RETURN NIL

****************************************************************************

FUNCTION CHECKSUM(s)
local i,n:=len(s),bb:=255
for i:=1 to n
 bb:=NUMXOR(bb,asc(subs(s,i,1)))
next   
RETU NTOC(bb,16,2,"0")

****************************************************************************
FUNCTION DAJ_TYP()
local _chksum,dokasy,_typ:=0,_i,_tn,asys:={},_s,_nr_unikat:="",_liczba_stawek,;
      _sel:=select()
if _priorytet=11.or.;
   (val(subs(_wersja,82,1))>0.and.val(subs(_wersja,82,1))<>val(numer_stan))

  RETURN _typ:=0
endi

sele 0
_use("CONFIG","R!")
if fieldpos("TYP_POSNET")>0 .and. TYP_POSNET>0
  _typ:=TYP_POSNET
   CpClose(CONFIG)

   sele (_sel)
   RETURN _typ
endi  
CPClose(CONFIG)

sele (_sel)
INIT_DR()
_chksum:=CHECKSUM("1#e")
dokasy:=ESC+"P1#e"+_chksum+ESC+"\" // przeczenie na softwarow obsug bdw
SEND_DRU(dokasy,_time_tra)

_chksum:=CHECKSUM("0#s")
dokasy:=ESC+"P0#s"+_chksum+ESC+"\" // status    
SEND_DRU(dokasy,_time_tra)
_s:=READ_DRU2(,_time_tra)

_liczba_stawek:=(NUMAT("/",_s)-2)/2
_liczba_stawek:=round(_liczba_stawek,0)-1

TOKENINIT(@_s,";/")

do while !TOKENEND()
  _tn:=TOKENNEXT(_s)
  aadd(asys,_tn)
enddo

if len(asys)>=19                                                        //02.04.03

  _nr_unikat:=subs(asys[21+2*(_liczba_stawek-4)],1,11)
  if ISALPHA(subs(_nr_unikat,3))
    _typ:=1
    asys:={}
    _chksum:=CHECKSUM("#v")
    dokasy:=ESC+"P#v"+_chksum+ESC+"\"     
    SEND_DRU(dokasy,_time_tra)
    _s:=READ_DRU2(,_time_tra)
    TOKENINIT(@_s,"/")
    do while !TOKENEND()
      _tn:=TOKENNEXT(_s)
      aadd(asys,_tn)
    enddo
    if len(asys)<2
      QKE("ODEBRANO NIEKOMPLETN INFORMACJ O STANIE DRUKARKI !")
      inkey(0.01)
      HB_COMCLOSE(_port_dru)    //01.09.15
      RETURN 0
    endi

    if "Wiking"$subs(asys[1],6) .and.  subs(asys[2],1)>"02"
       _typ:=3
    endi
    if "39.1"$subs(asys[2],1)
      _typ=4
    endi
  else
    _typ:=0
  endi
else
  _nr_unikat:=""
  _typ:=0
endi

_chksum:=CHECKSUM("0#e")
dokasy:=ESC+"P0#e"+_chksum+ESC+"\"  //komunikaty o bdach na wywietlaczu
SEND_DRU(dokasy,_time_tra)
inkey(0.01)
HB_COMCLOSE(_port_dru)    //01.09.15

RETURN _typ
*******************************************************************************
FUNCTION DAJ_FIS()
local _timet:=_time_tra,_dd

if _priorytet>10.or.subs(_wersja,84,1)="N" ; RETURN NIL; endi

_time_tra:=5

for _i:=1 to 2

  BEGIN SEQUENCE

  QPC(1,"Prosz czeka - test drukarki fiskalnej.")
  STA_DRU(.F.)                                       // "przepycha"  drukark
  QPC(0,"Prosz czeka - test drukarki fiskalnej.")

  END SEQUENCE
next

_time_tra:=_timet
RETURN NIL
*******************************************************************************
 