*******************************************************************************
#include "comped.ch"
#include "pscript.ch"
#include "inkey.ch"
#include "setcurs.ch"
#include "achoice.ch"
#include "fileio.ch"
#include "directry.ch"
#include "box.ch"

#include "memoedit.ch"                                               //23.10.19
#include "getexit.ch"
#include "hbXml.ch"                                          

#define K_PLUS 43
#define K_MINUS 45

#define CR    Chr(13)                                                //23.10.19
#define LF    Chr(10)
#define CRLF  CR + LF

static _data_beg:=NIL, _data_end:=NIL
*******************************************************************************
*                                   V_LAPT
*******************************************************************************
FUNCTION CONFIG_L()                                         //08.11.2015 BAFPOL
local _tex:='۲  KONFIGURACJA MODUU ZAMWIE  '

cls
@ 0,0 say _tex
QKE("Opcja dozwolona tylko przed wprowadzeniem danych uytkowych")
if !(_priorytet>=9.and.HA(_haslo))
 QKE("Brak uprawnie !")
 RETURN NIL
endi

sele 0
_use("CONFIG","E!")
@ 1, 0 say "Folder wymiany danych :   " get GDZIE_DAN pict "@!" 
@ 2, 0 say "Stanowisko zapisu faktur: " get STANOW_ZAM  pict "99" vali SP();
        .and.(empty(STANOW_ZAM).or.;
        file(".\#"+trans0(val(STANOW_ZAM),2)+"\PARADRUK.DBF"))
@ 3,0 say  "E-mail centrali :         " get MAIL_CE pict "@! "+repl("X",40)
@ 4,0 say  "E-mail serwisu :          " get MAIL_SE pict "@! "+repl("X",40)
@ 5,0 say  "Drugi adres FTP (T/N) :   " get FTP2 pict "@! A" vali FTP2$"TN "
@ 6,0 say  "Nazr serwisowy (T/N) :   " get SERWIS pict "@! A";
                                                             vali SERWIS$"TN "
set curs on; read; set curs off

if !empty(STANOW_ZAM); repl STANOW_ZAM with trans0(val(STANOW_ZAM),2); endi

_konto_ph:="00000"
_gdzie_mv :=".\"
_st_zam:=STANOW_ZAM
_nr_kasy:=1   //NR_KASY
_szuflada:=1  //SZUFLADA
_serwis:=SERWIS                                                 
_tmp_ftp:=(FTP2="T")                                            
_gdzie_dan:=uppe(alltrim(GDZIE_DAN))
_mail_se  :=alltrim(lowe(MAIL_SE))
_mail_ce  :=alltrim(lowe(MAIL_CE))
use

RETURN NIL

*******************************************************************************
FUNCTION CREA_BAZY()
loca _astru:={}

_astru:={}
aadd(_astru,{"INDEKS    ","C",20,0})
aadd(_astru,{"NAZWA_TOW ","C",30,0})
aadd(_astru,{"OPIS_TOW  ","C",20,0})
aadd(_astru,{"KOD_PAS   ","N",13,0})
aadd(_astru,{"GRUPA_TOW ","C",3,0})
aadd(_astru,{"OPAKOWANIE","N",7,1})
aadd(_astru,{"JM        ","C",4,0})
aadd(_astru,{"VAT       ","C",2,0})
aadd(_astru,{"STAN      ","N",10,3})
aadd(_astru,{"STAN_PH   ","N",10,3})
aadd(_astru,{"CENA_1    ","N",9,2})
aadd(_astru,{"CENA_2    ","N",9,2})
aadd(_astru,{"CENA_3    ","N",9,2})
aadd(_astru,{"CENA_ZAK  ","N",12,2})
aadd(_astru,{"NR_KON    ","C",5,0})
aadd(_astru,{"SWW       ","C",20,0})
aadd(_astru,{"OPAK_ZWR  ","C",1,0})
aadd(_astru,{"USLUGA    ","C",3,0})
aadd(_astru,{"STAN_MIN  ","N",10,3})
dbcreate(_sc+"TOW",_astru)

_astru:={}  
aadd(_astru,{"NR_KON    ","C",5,0})
aadd(_astru,{"GRUPA_KON ","C",2,0})
aadd(_astru,{"ID_KON    ","C",15,0})
aadd(_astru,{"NAZWA_KON ","C",60,0})
aadd(_astru,{"NAZWA_KON2","C",60,0})
aadd(_astru,{"SKROT     ","C",15,0})
aadd(_astru,{"KOD       ","C",6,0})
aadd(_astru,{"MIASTO    ","C",20,0})
aadd(_astru,{"ADRES     ","C",30,0})
aadd(_astru,{"TELEFON   ","C",20,0})
aadd(_astru,{"KONTO     ","C",5,0})
aadd(_astru,{"KREDYT    ","C",1,0})
aadd(_astru,{"WN_ODB    ","N",12,2})
aadd(_astru,{"MA_ODB    ","N",12,2})
aadd(_astru,{"MA_DOS    ","N",12,2})
aadd(_astru,{"WN_DOS    ","N",12,2})
aadd(_astru,{"CENNIK    ","C",1,0})
aadd(_astru,{"RABAT_KON ","N",4,1})
aadd(_astru,{"LIMIT     ","N",12,2})
aadd(_astru,{"UWAGI     ","C",74,0})
aadd(_astru,{"DNI       ","N",3,0})
aadd(_astru,{"BLOKADA   ","C",1,0})
aadd(_astru,{"SZEF      ","C",36,0})
aadd(_astru,{"PRACOWNIK ","C",36,0})
aadd(_astru,{"MAIL      ","C",36,0})
aadd(_astru,{"PLATNIK   ","C", 5,0})
aadd(_astru,{"NR_POP    ","C",5,0})
aadd(_astru,{"PUNKTY_RA ","N",5,0})                             
aadd(_astru,{"PUNKTY_OK ","N",5,0})                 
aadd(_astru,{"CW        ","C",1,0})                             
dbcreate(_sc+"KON",_astru)

_astru:={}  
aadd(_astru,{"DOKUMENT  ","C",14,0})   //FA-99999/99/99
aadd(_astru,{"DATA_DOK  ","D", 8,0})
aadd(_astru,{"NR_MAG    ","C", 3,0})
aadd(_astru,{"WART_ZAK  ","N",12,2})
aadd(_astru,{"WART_BRU  ","N",12,2})
aadd(_astru,{"KOREKTA   ","C",14,0})   //FK-99999/99/99
aadd(_astru,{"KONTO     ","C", 5,0})
aadd(_astru,{"NR_KON    ","C", 5,0})
aadd(_astru,{"GRUPA_KON ","C", 2,0})
aadd(_astru,{"ID_KON    ","C",15,0})
aadd(_astru,{"NAZWA_KON ","C",60,0})
aadd(_astru,{"KOD       ","C", 6,0})
aadd(_astru,{"MIASTO    ","C",20,0})
aadd(_astru,{"ADRES     ","C",30,0})
aadd(_astru,{"WN        ","N",12,2})
aadd(_astru,{"DATA_PLA  ","D", 8,0})
aadd(_astru,{"DATA_ZAP  ","D", 8,0})
aadd(_astru,{"DNI_PO    ","C", 4,0})
aadd(_astru,{"RODZAJ_DOK","C", 2,0})
aadd(_astru,{"SERIA_FAK ","C", 2,0})
aadd(_astru,{"ROK_DOK   ","C", 4,0})
aadd(_astru,{"NR_DOK    ","C", 5,0})
aadd(_astru,{"RABAT     ","N", 5,1})                                 //16.05.15
aadd(_astru,{"UWAGI     ","C",40,0})                         
dbcreate(_sc+"SPR_N",_astru)

_astru:={}                                                   
aadd(_astru,{"DOKUMENT  ","C",14,0})
aadd(_astru,{"DATA_DOK  ","D",8,0})
aadd(_astru,{"NR_KON    ","C",5,0})
aadd(_astru,{"INDEKS    ","C",20,0})
aadd(_astru,{"VAT       ","C",2,0})
aadd(_astru,{"ILOSC     ","N",10,3})
aadd(_astru,{"CENA_SPR  ","N",12,2})
aadd(_astru,{"MARZA     ","N", 7,2})                                 //15.05.16
dbcreate(_sc+"SPR_P",_astru)

RETURN NIL

*******************************************************************************
FUNCTION CREA_ALL()                                           //08.11.15 BAFPOL
loca _astru:={}

_astru:={}
aadd(_astru,{"INDEKS    ","C",20,0})
aadd(_astru,{"NAZWA_TOW ","C",30,0})
aadd(_astru,{"OPIS_TOW  ","C",20,0})
aadd(_astru,{"KOD_PAS   ","N",13,0})
aadd(_astru,{"GRUPA_TOW ","C",3,0})
aadd(_astru,{"OPAKOWANIE","N",7,1})
aadd(_astru,{"JM        ","C",4,0})
aadd(_astru,{"VAT       ","C",2,0})
aadd(_astru,{"STAN      ","N",10,3})
aadd(_astru,{"STAN_PH   ","N",10,3})
aadd(_astru,{"CENA_1    ","N",9,2})
aadd(_astru,{"CENA_2    ","N",9,2})
aadd(_astru,{"CENA_3    ","N",9,2})
aadd(_astru,{"CENA_ZAK  ","N",12,2})
aadd(_astru,{"NR_KON    ","C",5,0})
aadd(_astru,{"SWW       ","C",20,0})
aadd(_astru,{"OPAK_ZWR  ","C",1,0})
aadd(_astru,{"USLUGA    ","C",3,0})
aadd(_astru,{"STAN_MIN  ","N",10,3})
dbcreate(_sc+"TOW_A",_astru)

RETURN NIL

*******************************************************************************
FUNCTION DAJ_TOW_H()
TOW_H->INDEKS    :=TOW->INDEKS
TOW_H->NAZWA_TOW :=TOW->NAZWA_TOW
TOW_H->OPIS_TOW  :=TOW->OPIS_TOW
TOW_H->KOD_PAS   :=TOW->KOD_PAS
TOW_H->GRUPA_TOW :=TOW->GRUPA_TOW
TOW_H->OPAKOWANIE:=TOW->OPAKOWANIE
TOW_H->JM        :=TOW->JM
TOW_H->VAT       :=TOW->VAT
//TOW_H->STAN      :=TOW->NIL
//TOW_H->STAN_PH   :=TOW->NIL
TOW_H->CENA_1    :=TOW->CENA_1
TOW_H->CENA_2    :=TOW->CENA_2
TOW_H->CENA_3    :=TOW->CENA_3
TOW_H->CENA_ZAK  :=TOW->CENA_ZAK
TOW_H->NR_KON    :=TOW->NR_KON
TOW_H->SWW       :=TOW->SWW
TOW_H->OPAK_ZWR  :=TOW->OPAK_ZWR
TOW_H->USLUGA    :=TOW->USLUGA
RETURN NIL

*******************************************************************************
FUNCTION DAJ_TOW_A()
TOW_A->INDEKS    :=TOW->INDEKS
TOW_A->NAZWA_TOW :=TOW->NAZWA_TOW
TOW_A->OPIS_TOW  :=TOW->OPIS_TOW
TOW_A->KOD_PAS   :=TOW->KOD_PAS
TOW_A->GRUPA_TOW :=TOW->GRUPA_TOW
TOW_A->OPAKOWANIE:=TOW->OPAKOWANIE
TOW_A->JM        :=TOW->JM
TOW_A->VAT       :=TOW->VAT
//TOW_A->STAN      :=TOW->NIL
//TOW_A->STAN_PH   :=TOW->NIL
TOW_A->CENA_1    :=TOW->CENA_1
TOW_A->CENA_2    :=TOW->CENA_2
TOW_A->CENA_3    :=TOW->CENA_3
TOW_A->CENA_ZAK  :=TOW->CENA_ZAK
TOW_A->NR_KON    :=TOW->NR_KON
TOW_A->SWW       :=TOW->SWW
TOW_A->OPAK_ZWR  :=TOW->OPAK_ZWR
TOW_A->USLUGA    :=TOW->USLUGA
RETURN NIL

*******************************************************************************
FUNCTION POUFNE()
local _tex:='۲  KONFIGURACJA POCZTY E-MAIL I FTP  '
local _astru:={},_pin:=PIN(),_has:=spac(6),_wybor:=0
local _ftp_open,_ftp_login,_ftp_pass,_ftp_path,;
      _ftp_open2:=spac(40),_ftp_logi2:=spac(40),_ftp_pass2:=spac(40),;
      _ftp_path2:=spac(40),;                                         //07.09.16
      _mail_from,_mail_host,_mail_port,_mail_user,_mail_pass 

local _wariant:=1                                                    //15.09.19

cls
@ 0,0 say _tex
@ 1,0 say "Haso   :" get _has pict "@! XXXXXX"
@ 2,0 say "Wariant :" get _wariant pict "@Z 9" range 1,2             //15.09.19
set curs on; read; set curs off 
@ 1,0 clea to 2,79


/*
UWAGA : Alternatywne wysyanie poczty za pomoc HB_SendMail() w TEST_MAIL()
*/

_ftp_open  :=padr("ftp.bafix.pl",40)                                 //15.10.12
_ftp_login :=padr("comped",40)
if _has=PIN().or._operator="(C)"
  _ftp_pass  :=padr("c1926_m82_D73",40)
else
  _ftp_pass  :=spac(40)
endi
_ftp_path  :=padr("bafix.beep.pl",40)     

if _wariant=2                                                       //15.09.19
  _mail_from :=padr("comped@wp.pl",40)   //SMTPSENT -f
  _mail_host :=padr("smtp.wp.pl",40)     //SMTPSENT -h
  _mail_port :=padr("587",40)            //SMTPSENT -p
  _mail_user :=padr("comped@wp.pl",40)   //SMTPSENT -lu
  if _priorytet>9.or._operator="(C)"
    _mail_pass :=padr("zsiwi1989",40)    //SMTPSENT -lp
  else
    _mail_pass :=spac(40)                //SMTPSENT -lp
  endi
else
  _mail_from :=padr("megavat@bafpol.pl",40)  //SMTPSENT -f             //24.01.18
  _mail_host :=padr("smtp.bafpol.pl",40)     //SMTPSENT -h
  _mail_port :=padr("587",40)                //SMTPSENT -p
  _mail_user :=padr("megavat",40)            //SMTPSENT -lu
  if _priorytet>9.or._operator="(C)"
    _mail_pass :=padr("MegaVat_Baf2018",40)  //SMTPSENT -lp
  else
    _mail_pass :=spac(40)                    //SMTPSENT -lp
  endi
endi

sele 0
if !file(_gdzie_lap+"CONFIG.DBT")
  _astru:={}
  aadd(_astru,{"MAIL_FROM ","C",40,0})
  aadd(_astru,{"MAIL_HOST ","C",40,0})
  aadd(_astru,{"MAIL_PORT ","C",40,0})
  aadd(_astru,{"MAIL_USER ","C",40,0})
  aadd(_astru,{"MAIL_PASS ","C",40,0})
  aadd(_astru,{"FTP_OPEN  ","C",40,0})
  aadd(_astru,{"FTP_LOGIN ","C",40,0})
  aadd(_astru,{"FTP_PASS  ","C",40,0})
  aadd(_astru,{"FTP_PATH  ","C",40,0})
  aadd(_astru,{"FTP_OPEN2 ","C",40,0})

  aadd(_astru,{"FTP_LOGIN2","C",40,0})                               //12.01.12
  aadd(_astru,{"FTP_PASS2 ","C",40,0})
  aadd(_astru,{"FTP_PATH2 ","C",40,0})
  dbcreate("CONFIG.DBT",_astru)
endi
_use(_gdzie_lap+"CONFIG.DBT","E!","CNF")
if lastrec()=0
  appe blan
endi

do while .t.

  @  1,0 say "MAIN FTP:"
  @  2,0 say "FTP_OPEN  : " get _ftp_open  pict repl("X",40)
  @  3,0 say "FTP_LOGIN : " get _ftp_login pict repl("X",40)
  @  4,0 say "FTP_PASS  : " get _ftp_pass  pict repl("X",40)
  @  5,0 say "FTP_PATH  : " get _ftp_path  pict repl("X",40)

  @  6,0 say "SERVICE FTP:"
  @  7,0 say "FTP_OPEN2 : " get _ftp_open2 pict repl("X",40)
  @  8,0 say "FTP_LOGIN2: " get _ftp_logi2 pict repl("X",40)
  @  9,0 say "FTP_PASS2 : " get _ftp_pass2 pict repl("X",40)
  @ 10,0 say "FTP_PATH2 : " get _ftp_path2 pict repl("X",40)

  @ 11,0 say "SERVICE E-MAIL:"
  @ 12,0 say "MAIL_FROM : " get _mail_from pict repl("X",40)
  @ 13,0 say "MAIL_HOST : " get _mail_host pict repl("X",40)
  @ 14,0 say "MAIL_PORT : " get _mail_port pict repl("X",40)
  @ 15,0 say "MAIL_USER : " get _mail_user pict repl("X",40)
  @ 16,0 say "MAIL_PASS : " get _mail_pass pict repl("X",40)

  set curs on; read; set curs off

  _wybor:=HorizMenu(18,0,"",{"POPRAWA","AKCEPTACJA","REZYGNACJA"},1)
  @ 11,0

  if _wybor=1; loop; endi
  if _wybor=2.and.HA(_haslo)
    CNF->MAIL_FROM :=CRYPT(_mail_from,"COMPED")
    CNF->MAIL_HOST :=CRYPT(_mail_host,"COMPED")
    CNF->MAIL_PORT :=CRYPT(_mail_port,"COMPED")
    CNF->MAIL_USER :=CRYPT(_mail_user,"COMPED")
    CNF->MAIL_PASS :=CRYPT(_mail_pass,"COMPED")
    CNF->FTP_OPEN  :=CRYPT(_ftp_open ,"COMPED")
    CNF->FTP_LOGIN :=CRYPT(_ftp_login,"COMPED")
    CNF->FTP_PASS  :=CRYPT(_ftp_pass ,"COMPED")
    CNF->FTP_PATH  :=CRYPT(_ftp_path ,"COMPED")
    CNF->FTP_OPEN2 :=CRYPT(_ftp_open2,"COMPED")
    CNF->FTP_LOGIN2:=CRYPT(_ftp_logi2,"COMPED")
    CNF->FTP_PASS2 :=CRYPT(_ftp_pass2,"COMPED")
    CNF->FTP_PATH2 :=CRYPT(_ftp_path2,"COMPED")

    tone(880,2)
    close data
    QK("Utworzono plik CONFIG.DBT")
    exit
  endi
  tone(220,2)
  close data
  QK("Nie utworzono pliku CONFIG.DBT")
  exit
endd
close data
RETURN NIL

/*
SMTPSend v3.24 (WinXP)
(c) copyright DataEnter, Michael Kocum 1993-2003

Error: No recipients address! Use -t
SMTPSend uses the following switches:

-f<Address>          Senders address
-t<Address>          Recipients address
-c<Address>          CC address
-b<Address>          BCC address
-h<Host>             Send message to host
-p<Port>             Port (default is port 25)
-s<Subject>          Subject of the message
-a<AttachFile>       File(s) to attach to the message (wildcards allowed)
-i<ImportFile>       File(s) to import into message body (wildcards allowed)
-1                   Enable Single-To mode
-v                   Verbose mode (show message transfer)
-g<SMTPFile>         Send a raw RFC 821/822 file (ignores -c,-a,-i,-s,-r)

Press any key or ESC to cancel...

-lu<User>            SMTP authentication user
-lp<Password>        SMTP authentication password
s-lCA<File>           TLS CA-Certificate PEM file

-n                   Force normal SMTP (do not use ESMTP)
-dNFSD               DSN Never, Failure, Success, Delay
-os<Flag>            SMTP options
-mfH                 Message format HTML
-mhL                 Message header line
-mRR                 Enable Read Receipt
-@<ArgFile>          Read additional arguments from a file (-@FILE.EXT)

Example:
smtpsend -fcomped@wp.pl -tmmpop@wp.pl -tmpop@comped.com.pl -hsmtp.wp.pl
         -p587 -imail.txt -lucomped@wp.pl -lpzsiwi -aDANE_04.ARJ
         -sDane handlowe PH 04
*/

*******************************************************************************
FUNCTION DAJ_POUFNE()

dele file msentz.bat                                //kasowanie danych poufnych
dele file msent.bat
dele file fsent.scr
dele file fread.scr
dele file fsentz.scr
dele file freadz.scr

sele 0
if !file(_gdzie_lap+"CONFIG.DBT")
  QKE("UWAGA : Brak pliku konfiguracyjnego "+_gdzie_lap+"CONFIG.DBT")
elseif _use(_gdzie_lap+"CONFIG.DBT","R")
  _mail_from :=alltrim(CRYPT(MAIL_FROM,"COMPED"))
  _mail_host :=alltrim(CRYPT(MAIL_HOST,"COMPED"))
  _mail_port :=alltrim(CRYPT(MAIL_PORT,"COMPED"))
  _mail_user :=alltrim(CRYPT(MAIL_USER,"COMPED"))
  _mail_pass :=alltrim(CRYPT(MAIL_PASS,"COMPED"))
  _ftp_open  :=alltrim(CRYPT(FTP_OPEN ,"COMPED"))
  _ftp_login :=alltrim(CRYPT(FTP_LOGIN,"COMPED"))
  _ftp_pass  :=alltrim(CRYPT(FTP_PASS ,"COMPED"))
  _ftp_path  :=alltrim(CRYPT(FTP_PATH ,"COMPED"))
  _ftp_open2 :=alltrim(CRYPT(FTP_OPEN2,"COMPED"))
  _ftp_logi2 :=alltrim(CRYPT(FTP_LOGIN2,"COMPED"))
  _ftp_pass2 :=alltrim(CRYPT(FTP_PASS2,"COMPED"))
  _ftp_path2 :=alltrim(CRYPT(FTP_PATH2,"COMPED"))
  use
else
  _mail_from :=""
  _mail_host :=""
  _mail_port :=""
  _mail_user :=""
  _mail_pass :=""
  _ftp_open  :=""
  _ftp_login :=""
  _ftp_pass  :=""
  _ftp_path  :=""
  _ftp_open2 :=""
  _ftp_logi2 :=""
  _ftp_pass2 :=""
  _ftp_path2 :=""
endi

RETURN NIL

*******************************************************************************
//FUNCTION OTWORZ()                                              //22.09.16 TMP

*******************************************************************************
FUNCTION EXPORT_HAN(_auto)                                           //09.08.16
local _tex:='۲  UTWORZENIE I EKSPORT DANYCH HANDLOWYCH  '
loca _sel:=select(),_kat,getlist:={},;
     _ndysk:=0,_tdysk:="",_k,_astru:={}
loca prevhandler:=errorblock(),_sci:=subs(_sc,1,len(_sc)-1),;
     _oldcolor:=set(_SET_COLOR),_oldcursor,_screen,;
     apom:={},apom_k:={},apom_u:={},_erc1,_erc2,_erc3
loca _fi:=.f.,_data_od:=date()-360,_data_do:=date(),_key_fa:=""      //10.09.19
loca _wyb_ph:=1,_akont:={}
loca _err:=.t.

priv _nr_mag:=_mag_zam, _mag_ph:=spac(3)                             //16.12.13
priv _mail_ph:=""
priv _kat_dan:=alltrim(_gdzie_dan)
priv _kat_mag:=alltrim(_gdzie_mv)
priv _kat_kon:=alltrim(_gdzie_fir)
priv _konto:=spac(5)

DEFAULT _auto to .F.                                                 //09.08.16

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use("SL_KONT","R"); BREAK; endif
set index to ("SL_KONT")
set filt to AKTYWNY="T"
go top

if !_auto
  _wyb_ph:=HorizMenu(1,0,"Eksport do PH :",;
                 {"WSZYSTKICH","WYBRANYCH","WSKAZANEGO"},2)
endi

if _wyb_ph=0.or.lastkey()=K_ESC; BREAK; endi
@ 1,0

if _wyb_ph=3
  @ 1,0 say "Przedstawiciel handlowy : " get _konto pict "@K 99999";
             when SLGET("SL_KONT","SL_KONT","V1",1,1,{"konto"},,.f.);
             vali (empty(_konto).or.SZ().and.SL("SL_KONT","SL_KONT","V1",1,1));
                  .and.SLGET() 
  set curs on; read; set curs off
  if lastkey()=K_ESC; BREAK; endi

  @ 1,34
  if !val(_konto)>0                                                   //15.10.12
    SL_KONT->(dbseek(_konto))
    _mag_ph:=SL_KONT->NR_MAG
    @ 1,34 say SL_KONT->OPIS_KONTA
  endi
elseif _wyb_ph=1
  @ 1,0 say "Wszyscy aktywni przedstawiciele handlowi."

elseif _wyb_ph=2
  @ 1,0 say "Zaznacz konta przestawicieli klawiszem Ins :"

  sele SL_KONT
  go top
  CPEDIT  POZ: 2,,23,             ;
        DEF: "SL_KONT"            ;
        POZWER: "V3"              ;
        PION: ,,,                 ;
        INDEXY: {"konto"}         ;
        ODTWORZ:.t.

  if len(_zaznaczone)=0
    QK("Nie wybrano przedstawicieli"); BREAK 
  endi

  for _i:=1 to len(_zaznaczone)
    dbgoto(_zaznaczone[_i])
    aadd(_akont,{SL_KONT->KONTO,0})
  next
  @ 1,0
  @ 1,0 say "Wybrani przedstawiciele handlowi ("+alltrim(str(len(_akont)))+")."
endi

if val(_konto)>0                                                
  aadd(_akont,{_konto,0})
elseif _wyb_ph=1
  SL_KONT->(dbeval({|| aadd(_akont,{KONTO,0})},;
                   {|| val(KONTO)>0.and.!AKTYWNY="N"}))      
endi

if !_auto
  @ 2,0 say  "Faktury z okresu :        " get _data_od vali _data_od<=date()
  @ 2,col()+1 say "-" get _data_do vali _data_od<=_data_do
  set curs on; read; set curs off
  if lastkey()=K_ESC; BREAK; endi
endi

@ 2,0 say "Faktury z okresu :         "+dtoc(_data_od)+" - "+dtoc(_data_do)
@ 3,0 say "Zapis danych do folderu :  "+alltrim(_kat_dan)
@ 4,0 say "Katalog Megavatu :         "+alltrim(_kat_mag)
@ 5,0 say "Katalog sownika firm :    "+alltrim(_kat_kon)

@ 18,0 clear to 24,79

_k:=alltrim(_kat_dan)
_k:=if(subs(_k,-1,1)="\",subs(_k,1,len(_k)-1),_k)
if subs(_k,2,1)=":"; _tdysk:= subs(_k,1,1); else; _tdysk:=DISKNAME(); endi
_ndysk = ASC(upper(_tdysk)) - 64 

if !DIR_EXIST(_k); QKE("Bdny katalog zapisu danych !"); BREAK; endi

if !_auto
  _exp:=HorizMenu(6,0,"Eksport danych :",;
        {"FTP","E-MAIL","FTP i E-MAIL","REZYGNACJA"},3)
else
  _exp:=3
endi

if _exp=4
  BREAK
endi

*-------------------------------------------------------------- //czc wsplna
QPC(1)

dele file (_sc+"TOW_A")

CREA_ALL()  //plik _sc+"TOW_A"

sele 0
if !_use(_kat_mag+"TOW","R"); BREAK; endi
set index to (_kat_mag+"TOW_IN")

sele 0
if !_use(_sc+"TOW_A","E"); BREAK; endi
index on INDEKS to (_sc+"TOW_A")

sele 0
if !_use(_kat_mag+"MAG"+_nr_mag,"R","MAG"); BREAK; endi
set index to (_kat_mag+"M"+_nr_mag+"_IP")

go top
do while !eof()
  
  if STAN=0.and.DATA_DOS<date()-360       //na stanie lub dostawy z 12 m-cy
    skip; loop
  endi 
  
  TOW_A->(dbseek(MAG->INDEKS))
  if TOW_A->(eof())
    TOW->(dbseek(s_i(MAG->INDEKS)))

    TOW_A->(dbappend())

    DAJ_TOW_A()
  
    TOW_A->STAN:=0      
    TOW_A->CENA_ZAK:=0            
  endi    
  TOW_A->STAN+=MAG->(STAN-STAN_B)   
  TOW_A->STAN_MIN+=MAG->(STAN-STAN_B)   //old

  sele MAG
  skip
endd

QPC(0)
*------------------------------------------------------------------------------

for _i:=1 to len(_akont)

  BEGIN SEQUENCE

  CLOSE DATA

  dele file (_sc+"DATA_AKT.DBF")
  dele file (_sc+"UPUSTY.DBF")
  dele file (_sc+"SPR_N.DBF")
  dele file (_sc+"SPR_P.DBF")
  dele file (_sc+"KON.DBF")
  dele file (_sc+"TOW.DBF")
  dele file (_sc+"SL_JM.DBF")
  dele file (_sc+"SL_G_TOW.DBF")
  dele file (_sc+"SL_G_KON.DBF")
  dele file (_sc+"DANE.ARJ")


  _konto:=_akont[_i][1]

  *QK("Generowanie "+"DANE_"+trans0(val(_konto),2)+".ARJ")

  QPC(1)

  _dane:="DANE_"+trans0(val(_konto),2)+".ARJ"
  dele file (_kat_dan+_dane)

  sele 0
  if !_use("SL_KONT","R"); BREAK; endif
  set index to ("SL_KONT")

  CREA_BAZY()

  SL_KONT->(dbseek(_konto))
  _mag_ph:=SL_KONT->NR_MAG
  @ 1,0
  @ 1,0 say "Dane dla przedstawiciela : "+_konto
  @ 1,33 say SL_KONT->OPIS_KONTA
  CPClose(SL_KONT)
  @ 6,0 

  if empty(_mag_ph)
    @ 6,0 say "Towary z magazynu :        "+_nr_mag                  //15.10.12
  else
    @ 6,0 say "Towary z magazynw :       "+_nr_mag
    @ 6,col()+1 say "i "+_mag_ph
  endi

  inkey(1)

  sele 0
  _astru:={}  
  dele file (_sc+"DATA_AKT.DBF")
  aadd(_astru,{"DATA","D",8,0})
  aadd(_astru,{"CZAS","C",5,0})
  dbcreate(_sc+"DATA_AKT",_astru)
  _use(_sc+"DATA_AKT","E!")
  appe blan
  repl DATA with date(),;
       CZAS with time()
  use 

  sele 0
  if !_use(_kat_mag+"SL_JM","R"); BREAK; endi
  copy to (_sc+"SL_JM")
  use

  sele 0
  if !_use(_kat_mag+"SL_G_TOW","R"); BREAK; endi
  copy to (_sc+"SL_G_TOW")
  use

  sele 0
  if !_use(_kat_mag+"SL_G_KON","R"); BREAK; endi
  copy to (_sc+"SL_G_KON")
  use


  sele 0
  if !_use(_kat_mag+"TOW","R"); BREAK; endi
  set index to (_kat_mag+"TOW_IN")

  sele 0
  if !_use(_sc+"TOW","E","TOW_H"); BREAK; endi
  index on INDEKS to (_sc+"TOW_H")

  sele 0
  if !_use(_kat_mag+"MAG"+_nr_mag,"R","MAG"); BREAK; endi
  set index to (_kat_mag+"M"+_nr_mag+"_IP")


  if !empty(_mag_ph)

    sele 0
    if !_use(_kat_mag+"MAG"+_mag_ph,"R","MAG_PH"); BREAK; endi
    set index to (_kat_mag+"M"+_mag_ph+"_IP")
  endi

  sele 0
  if !_use(_kat_mag+"UPUSTY","R"); BREAK; endif
  set index to (_kat_mag+"UPUSTY_K"),(_kat_mag+"UPUSTY_T")
  apom_u:={}
  for i:=1 to fcount(); aadd(apom_u,i); next
  copy stru to (_sc+"UPUSTY")

  sele 0
  if !_use(_kat_mag+"ZAP","R"); BREAK; endif
  set index to (_kat_mag+"ZAP_FA")

  sele 0
  if !_use(_kat_mag+"KON_TXT","R"); BREAK; endi                      //31.12.13
  set index to (_kat_mag+"KON_TXT")

  sele 0
  if !_use(_kat_kon+"FIRMY","R","KON"); BREAK; endi                  //06.12.13
  set index to (_kat_kon+"FIRMY_NR"), (_kat_kon+"FIRMY_NA"),;
               (_kat_kon+"FIRMY_NI"), (_kat_kon+"FIRMY_AD")


  
  sele 0
  _use(_sc+"KON","E!","KON_H")
  index on NR_KON to (_sc+"KON_NR") 
  
  sele KON
  do while !eof()
    if empty(_konto)
      if empty(KONTO).and.NR_KON<>"00000"; skip; loop; endi 
    else
      if !(NR_KON="00000".or.KONTO==_konto); skip; loop; endi 
    endi
  
    KON_H->(dbappend())
    KON_H->NR_KON    :=NR_KON
    KON_H->GRUPA_KON :=GRUPA_KON
    KON_H->ID_KON    :=ID_KON
    KON_H->NAZWA_KON :=NAZWA_KON
    KON_H->NAZWA_KON2:=NAZWA_KON2
    KON_H->SKROT     :=SKROT
    KON_H->KOD       :=KOD
    KON_H->MIASTO    :=MIASTO
    KON_H->ADRES     :=ADRES
    KON_H->TELEFON   :=TELEFON
    KON_H->KONTO     :=KONTO
    KON_H->KREDYT    :=KREDYT
    KON_H->WN_ODB    :=WN_ODB
    KON_H->MA_ODB    :=MA_ODB
    KON_H->WN_DOS    :=WN_DOS
    KON_H->MA_DOS    :=MA_DOS
    KON_H->CENNIK    :=CENNIK
    KON_H->RABAT_KON :=RABAT_KON
    KON_H->LIMIT     :=LIMIT
    KON_H->UWAGI     :=UWAGI
    KON_H->DNI       :=DNI
    KON_H->BLOKADA   :=BLOKADA

    if KON_H->(fieldpos("CW")>0).and.KON->(fieldpos("CW")>0)         //30.08.15
      KON_H->CW:=KON->CW
    endi

    sele KON
    skip
  endd
  close KON

  sele 0
  _use(_sc+"SPR_P","E!","SPR_P_H")                                  //16.07.12

  sele 0
  _use(_sc+"SPR_N","E!","SPR_N_H")

  sele 0
  if !_use(_kat_mag+"SPR_P","R"); BREAK; endi
  set index to (_kat_mag+"SPR_P_NR")

  sele 0
  if !_use(_kat_mag+"SPR_N","R"); BREAK; endi
  set rela to NR_KON into KON_H
  go top
  do while !eof()

    if empty(KON_H->NR_KON); skip; loop; endi                        //14.06.15

    KON_H->PUNKTY_RA+=SPR_N->PUNKTY                                  //14.06.15
    if SPR_N->WN=0
      KON_H->PUNKTY_OK+=SPR_N->PUNKTY
    endi

    if !(WN<>0.or.DATA_DOK>=_data_od.and.DATA_DOK<=_data_do)         //14.06.15
      skip; loop
    endi

    SPR_N_H->(dbappend())
  
    SPR_N_H->DOKUMENT  :=RODZAJ_DOK+"-"+NR_DOK+"/"+SERIA_FAK+"/"+subs(ROK_DOK,3,2)
    SPR_N_H->DATA_DOK  :=DATA_DOK
    SPR_N_H->NR_MAG    :=NR_MAG
    SPR_N_H->WART_ZAK  :=0             //WART_ZAK
    SPR_N_H->WART_BRU  :=WART_ZAP
    SPR_N_H->KOREKTA   :=RODZAJ_KOR+"-"+NR_KOR+"/"+SERIA_KOR+"/"+subs(ROK_KOR,3,2)
    SPR_N_H->KONTO     :=KONTO
    SPR_N_H->NR_KON    :=NR_KON
    SPR_N_H->GRUPA_KON :=GRUPA_KON
    SPR_N_H->ID_KON    :=ID_KON
    SPR_N_H->NAZWA_KON :=NAZWA_KON
    SPR_N_H->KOD       :=KOD
    SPR_N_H->MIASTO    :=MIASTO
    SPR_N_H->ADRES     :=ADRES
    SPR_N_H->WN        :=WN
    SPR_N_H->DATA_PLA  :=DATA_PLA
    SPR_N_H->DATA_ZAP  :=ctod("")
    SPR_N_H->UWAGI     :=UWAGI                                   
    SPR_N_H->RABAT     :=RABAT                                       //16.05.15
        
    if fieldpos("RODZAJ_DOK")>0
      SPR_N_H->RODZAJ_DOK:=RODZAJ_DOK
      SPR_N_H->SERIA_FAK :=SERIA_FAK
      SPR_N_H->ROK_DOK   :=ROK_DOK
      SPR_N_H->NR_DOK    :=NR_DOK
    endi
  
    if WN=0
      _kiedy:=ctod("")
  
      sele ZAP
      klucz:=SPR_N->(RODZAJ_DOK+SERIA_FAK+ROK_DOK+NR_DOK)
      dbseek(klucz)
      dbeval({|| _kiedy:=max(_kiedy,DATA_ZAP)},,;
            {|| RODZAJ_DOK+SERIA_FAK+ROK_FAK+NR_FAK==klucz})
      SPR_N_H->DATA_ZAP:=_kiedy
    endi
  
    SPR_N_H->DNI_PO :=SPR_N_H->(if(empty(DATA_ZAP),;
                                   str(min(9999,date()-DATA_PLA),4),;
                                   str(min(9999,DATA_ZAP-DATA_PLA),4)))
    sele SPR_N
    skip
  endd

  *---------------------------------------------------------------  //16.07.12
  sele SPR_N_H                                                    
  go top
  do while !eof()
    _key_fa:=SPR_N_H->(subs(DOKUMENT,1,2)+;                   //FA-99999/99/99
                       subs(DOKUMENT,10,2)+;
                       "20"+subs(DOKUMENT,13,2)+;
                       subs(DOKUMENT,4,5))
    
    sele SPR_P
    dbseek(_key_fa)
    do while !eof().and.RODZAJ_DOK+SERIA_FAK+ROK_DOK+NR_DOK==_key_fa

      SPR_P_H->(dbappend())
      SPR_P_H->DOKUMENT  :=RODZAJ_DOK+"-"+NR_DOK+"/"+SERIA_FAK+;
                           "/"+subs(ROK_DOK,3,2)
      SPR_P_H->DATA_DOK  :=DATA_DOK
      SPR_P_H->NR_KON    :=NR_KON
      SPR_P_H->INDEKS    :=INDEKS
      SPR_P_H->VAT       :=VAT
      SPR_P_H->ILOSC     :=ILOSC
      SPR_P_H->CENA_SPR  :=CENA_SPR
          SPR_P_H->MARZA     :=MARZA                                     //15.05.16

      skip
    endd
  
    sele SPR_N_H
    skip
  endd 
  *---------------------------------------------------------------------------
  
  sele UPUSTY
  set rela to NR_KON into KON_H
  copy to (_sc+"UPUSTY") for KON_H->NR_KON<>" ".or.NR_KON="00000"

  sele KON_TXT                                                       //31.12.13
  set rela to NR_KON into KON_H 
  copy to (_sc+"KON_TXT") for KON_H->NR_KON<>" ".or.NR_KON="00000"


  CPClose(SPR_N)                                                     //16.07.12
  CPClose(SPR_P)
  CPClose(SPR_N_H)                                                   //16.07.12
  CPClose(SPR_P_H)                                                   //16.07.12
  CPClose(KON)
  CPClose(KON_TXT)                                                   //31.12.13
  CPClose(KON_H)
  CPClose(ZAP)
  CPClose(UPUSTY)

  sele TOW_H                                                  //08.11.15 BAFPOL
  appe from (_sc+"TOW_A")                       

/*                                                            //08.11.15 BAFPOL
  sele MAG
  go top
  do while !eof()
  
    if STAN=0.and.DATA_DOS<date()-360       //na stanie lub dostawy z 12 m-cy
      skip; loop
    endi 
  
    TOW_H->(dbseek(MAG->INDEKS))
    if TOW_H->(eof())
      TOW->(dbseek(s_i(MAG->INDEKS)))
  
      TOW_H->(dbappend())
      DAJ_TOW_H()
    
      TOW_H->STAN:=0      
      TOW_H->CENA_ZAK:=0            
    endi    
    TOW_H->STAN+=MAG->(STAN-STAN_B)   

    TOW_H->STAN_MIN+=MAG->(STAN-STAN_B)   //old

    sele MAG
    skip
  endd
*/

  if !empty(_mag_ph)

    sele MAG_PH
    go top
    do while !eof()

      TOW_H->(dbseek(MAG_PH->INDEKS))
      if TOW_H->(eof())
        TOW->(dbseek(s_i(MAG_PH->INDEKS)))

        TOW_H->(dbappend())
        DAJ_TOW_H()
    
        TOW_H->STAN_PH:=0        
        TOW_H->CENA_ZAK:=0         
      endi    
      TOW_H->STAN   +=MAG_PH->(STAN-STAN_B)   
      TOW_H->STAN_PH+=MAG_PH->(STAN-STAN_B)   

      sele MAG_PH
      skip
    endd
  endi

  TOW_H->(dbseek("00000"))                                           //08.01.16
  if TOW_H->(!found())
    TOW_H->(dbappend())
  endi
  TOW_H->INDEKS:="00000"                                             //08.01.16
  TOW_H->NAZWA_TOW:="UWAGI DO ZAMWIENIA"
  TOW_H->JM:=""
  TOW_H->VAT:=""
  TOW_H->OPIS_TOW:=""
 
  CPClose(TOW)
  CPClose(TOW_H)
  CPClose(MAG)
  CPClose(MAG_PH)
  CPClose(TOW_A)

  dele file (_sc+"DANE.ARJ")

  _screen:=savescreen(0,0,24,79)
  _oldcursor:=set(_SET_CURSOR,SC_NORMAL)
  tone(880,4)
  cls

  CLOS DATA

  if !file(_sc+"DATA_AKT.DBF").or.;
     !file (_sc+"UPUSTY.DBF").or.;
     !file (_sc+"SPR_N.DBF").or.;
     !file (_sc+"SPR_P.DBF").or.;
     !file (_sc+"KON.DBF").or.;
     !file (_sc+"TOW.DBF").or.;
     !file (_sc+"SL_JM.DBF").or.;
     !file (_sc+"SL_G_TOW.DBF").or.;
     !file (_sc+"SL_G_KON.DBF")

    dele file (_sc+"DATA_AKT.DBF")
    dele file (_sc+"UPUSTY.DBF")
    dele file (_sc+"SPR_N.DBF")
    dele file (_sc+"SPR_P.DBF")
    dele file (_sc+"KON.DBF")
    dele file (_sc+"TOW.DBF")
    dele file (_sc+"SL_JM.DBF")
    dele file (_sc+"SL_G_TOW.DBF")
    dele file (_sc+"SL_G_KON.DBF")

    _akont[_i][2]:=1

  endi


*------------------------------------------------------------------------ //xHB
  if _akont[_i][2]<>0; BREAK; endi

  _erc1:=.f.                                                             
  _erc2:=.f.
  _erc3:=.f.
  _erc4:=.f.
  RUN ("arj a "+_sc+"dane "+;                                //xHB i dalsze RUN
                               _sc+"DATA_AKT.DBF "+;
                               _sc+"UPUSTY.DBF -e")
  RUN ("arj a "+_sc+"dane "+;                                        //16.07.12
                               _sc+"SPR_N.DBF "+;
                               _sc+"SPR_P.DBF -e")
  RUN ("arj a "+_sc+"dane "+;
                               _sc+"KON.DBF "+;
                               _sc+"TOW.DBF -e")

  RUN ("arj a "+_sc+"dane "+;
                               _sc+"SL_JM.DBF "+;
                               _sc+"SL_G_TOW.DB? "+;
                               _sc+"SL_G_KON.DBF  -e")
*------------------------------------------------------------------------------

  inkey(2)
  set(_SET_CURSOR,_oldcursor)
  set(_SET_COLOR,_oldcolor)
  restscreen(0,0,24,79,_screen)
  if _erc1.or._erc2.or._erc3.or._erc4

     _akont[_i][2]:=2
     QK("Wystpi bd wywoania programu kompresujcego !"); BREAK
     dele file (_sc+"DANE.ARJ")
  endi
  tone(880,4)

  errorblock({|e| DiskError(e,prevhandler)})
  *----------------------------------------------------------------------------
  _dane:="DANE_"+trans0(val(_konto),2)+".ARJ"

//  dele file (_kat_dan+_dane)
  if file (_sc+"DANE.ARJ")
    copy file (_sc+"DANE.ARJ") to (_kat_dan+_dane)
  endi 
  *----------------------------------------------------------------------------
  errorblock(prevhandler)

  if file(_kat_dan+_dane)
//    QK("Wykonano zapis pliku "+_dane+" do folderu "+_kat_dan+" !",,3)
  endi

  END SEQUENCE

  CLOSE DATA

  QPC(0)

next

cls

CLOS DATA
dele file (_sc+"TOW_A.DBF") 

for _i:=1 to len(_akont)

  CLOS DATA

  BEGIN SEQUENCE

  if _akont[_i][2]<>0; BREAK; endi

  _konto:=_akont[_i][1]
  _dane:="DANE_"+trans0(val(_konto),2)+".ARJ"
  _mail:=.f.

  if !file(_kat_dan+_dane); BREAK; endi

  if _exp=3.or._exp=2

    sele 0
    if !_use("SL_KONT","R"); BREAK; endif
    set index to ("SL_KONT")
    SL_KONT->(dbseek(_konto))
    if empty(SL_KONT->MAIL)
      tone(220,1)
      QK("UWAGA Brak adresu e-mail PH "+_konto+".")
      _mail:=.f.
    else
     _mail:=.t.
     _mail_ph :=rtrim(lowe(SL_KONT->MAIL))
    endi
  endi
  CPClose(SL_KONT)

  if _exp=3.or._exp=1


    if _serwis="T".and._tmp_ftp     //serwisowa lokalizacja FTP      //08.11.15

      *QK("Eksport "+"DANE_"+trans0(val(_konto),2)+".ARJ"+" na SERVICE FTP" )

      _plik:=fcreate("fsent.bat")
      fwriteln(_plik,"cls")
      fwriteln(_plik,"ftp -s:fsent.scr")
      fclose(_plik)

  
      _plik:=fcreate("fsent.scr")
      fwriteln(_plik,"open "+_ftp_open2)
      fwriteln(_plik,_ftp_logi2)
      fwriteln(_plik,_ftp_pass2)
      fwriteln(_plik,"cd "+_ftp_path2)
      fwriteln(_plik,"cd DANE_"+trans0(val(_konto),2))
      fwriteln(_plik,"binary")
      fwriteln(_plik,"put "+(_kat_dan+_dane)) 
      fwriteln(_plik,"quit")
      fclose(_plik)
  

      RUN fsent.bat  //xHB



      K_OFF()
      clear typeahead
      tone(880,2)
      inkey(3)
      
    endi

    *QK("Eksport "+"DANE_"+trans0(val(_konto),2)+".ARJ"+" na MAIN FTP" )

/* stara wersja                                                      //10.09.19
    _plik:=fcreate("fsent.bat")
    fwriteln(_plik,"cls")
    fwriteln(_plik,"ftp -s:fsent.scr")
    fclose(_plik)

    _plik:=fcreate("fsent.scr")
    fwriteln(_plik,"open "+_ftp_open)
    fwriteln(_plik,_ftp_login)
    fwriteln(_plik,_ftp_pass)
    fwriteln(_plik,"cd "+_ftp_path)
    fwriteln(_plik,"cd DANE_"+trans0(val(_konto),2))
    fwriteln(_plik,"binary")
    fwriteln(_plik,"put "+(_kat_dan+_dane)) 
    fwriteln(_plik,"quit")
    fclose(_plik)
    RUN fsent.bat  
*/

*-------------------------------------- nowa wersja (przykad FTP()) //10.09.19

//NEW_FTP(_user,_pass,_serv,_path1,_path2,_path3,_file1,_file2,_dest)
//QKE(_ftp_login+" "+_ftp_pass+" "+_ftp_open+" "+_ftp_path+" "+;
//                                               "DANE_"+trans0(val(_konto),2))

    NEW_FTP(_ftp_login,_ftp_pass,_ftp_open,;
            _ftp_path,"DANE_"+trans0(val(_konto),2),,_kat_dan+_dane,,"UPLOAD")

/* stara wersja                                                      //10.09.19
    dele file fsent.scr
    clear typeahead
*/
    K_OFF()
    clear typeahead
    tone(880,2)
    inkey(3)
  endi

  if _exp=3.or._exp=2.and._mail

    *QK("Eksport "+"DANE_"+trans0(val(_konto),2)+".ARJ"+" przez E-MAIL" )

    _plik:=fcreate("mail.txt")
    fwriteln(_plik,"Dane handlowe : PH "+trans0(val(_konto),2))
    fwriteln(_plik,"Data i godzina utworzenia : "+dtoc2(date())+"  "+;
                    subs(time(),1,5))
    fclose(_plik)

    if empty(_mail_se).or._serwis$" N"                               //15.10.12
     _cmd:='smtpsend -f'+_mail_from+' -t'+_mail_ph+;
     ' -h'+_mail_host+' -p'+_mail_port+' -imail.txt -lu'+_mail_user+;
     ' -lp'+_mail_pass+' -a'+_kat_dan+_dane+' -sDane handlowe PH '+trans0(val(_konto),2)
    else
     _cmd:='smtpsend -f'+_mail_from+' -t'+_mail_ph+' -t'+_mail_se+;
     ' -h'+_mail_host+' -p'+_mail_port+' -imail.txt -lu'+_mail_user+;
     ' -lp'+_mail_pass+' -a'+_kat_dan+_dane+' -sDane handlowe PH '+trans0(val(_konto),2)
    endi

    _plik:=fcreate("msent.bat")
    fwriteln(_plik,"cls")
    fwriteln(_plik,_cmd)
    fclose(_plik)
    cls

    RUN msent.bat  //xHB

    dele file msent.bat                                              //23.02.18

    K_OFF()
    clear typeahead
    tone(880,2)
    inkey(2)
  endi

  END SEQUENCE

next

END SEQUENCE

set(_SET_COLOR,_oldcolor)

sele  (_sel)
RETURN NIL

*******************************************************************************
FUNCTION CZYTAJ_ZAM()
local _tex:='۲  WCZYTANIE ZAMWIE Z FOLDERU POREDNIEGO  '
loca _sel:=select(),_kat,getlist:={},_ndysk:=0,_tdysk:="",_k
loca _sci:=subs(_sc,1,len(_sc)-1),;
     _oldcolor:=set(_SET_COLOR),_oldcursor,_screen,_erc1,_err:=.t.,_ile:=0
priv _kat_dan:=alltrim(_gdzie_dan),_kat_mag:=alltrim(_gdzie_mv)

cls
@ 0,0 say _tex

BEGIN SEQUENCE

if !QTN("Kontynuacja ?"); BREAK; endi

@ 1,0 say "Odczyt z folderu :" get _kat_dan pict "@!" when .f.
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

if !(file(_kat_dan+"EWIZAM.DBF").and.file(_kat_dan+"EWIZAM.DBT"))
  QKE("Brak plikw "+_kat_dan+"EWIZAM.DBF i "+_kat_dan+"EWIZAM.DBT")
  BREAK
endi

copy file (_kat_dan+"EWIZAM.DBF") to (_sc+"EWIZAM.DBF")
copy file (_kat_dan+"EWIZAM.DBT") to (_sc+"EWIZAM.DBT")

sele 0
if !_use(_gdzie_lap+"NR_ZAM","E"); BREAK; endi
set index to (_gdzie_lap+"NR_ZAM")  //ROK_ZAM+KONTO

sele 0
if !_use(_gdzie_lap+"EWIZAM","E"); BREAK; endi
set index to (_gdzie_lap+"EWIZ_SI"),;// KONTO+ROK(DATA_ZAM)+NR_ZAM+TYP+INDEKS
           (_gdzie_lap+"EWIZ_SN"),;// KONTO+ROK(DATA_ZAM)+NR_ZAM+TYP+NAZWA_TOW 
           (_gdzie_lap+"EWIZ_KS"),;// NR_KON+KONTO+ROK(DATA_ZAM)+NR_ZAM+TYP
           (_gdzie_lap+"EWIZ_DS"),;// dtos(DATA_ZAM)+SYMBOL()+TYP
           (_gdzie_lap+"EWIZ_TE")  // TYP+ETAP                  

EWIZAM->(dbsetorder(1))

_tabela:=.f.                                                         //27.02.15
if file("TABELA.DBF")

  sele 0
  if !_use(_gdzie_lap+"TABELA","E"); BREAK; endi
  index on INDEKS1 to (_sc+"TABELA")
  _tabela:=.t.
endi 

sele 0 
_use(_sc+"EWIZAM","E!","EWIZ_NEW")

if _tabela                                                           //27.02.15
  tone(880,2)
  set rela to INDEKS into TABELA
  repl all INDEKS with TABELA->INDEKS2, KOD_PAS with TABELA->KOD_PAS2;
       for TABELA->INDEKS2<>" "
  set rela to
endi
CPClose(TABELA)

set rela to KONTO+ROK(DATA_ZAM)+NR_ZAM into EWIZAM
copy to (_sc+"EWI_ROB") for EWIZAM->(eof())

go top 
do while !eof()                                     //aktualizacja NR_ZAM.DBF
  if TYP="N".and.!empty(NR_ZAM)
    NR_ZAM->(dbseek(ROK(EWIZAM->DATA_ZAM)+EWIZAM->KONTO))
    if NR_ZAM->(!found())
      NR_ZAM->(dbappend())
      NR_ZAM->KONTO:=EWIZAM->KONTO
      NR_ZAM->ROK_ZAM:=ROK(EWIZAM->DATA_ZAM)
    endi
    NR_ZAM->NR_ZAM:=max(NR_ZAM->NR_ZAM,val(EWIZAM->NR_ZAM))
  endi
  skip
endd
CPClose(EWIZ_NEW)

sele 0
_use(_sc+"EWI_ROB","E!")

sele EWI_ROB
count to _ile for TYP="N"
use

sele EWIZAM
dbsetorder(0)
_lre:=lastrec()
appe from (_sc+"EWI_ROB")
dbgoto(_lre+1)
if fieldpos("ILO_FAK")>0
  repl rest ILO_FAK with ILO_ZAM                                     //16.12.13
endi
dbgoto(_lre+1)
if fieldpos("ETAP")>0.and.fieldpos("MAGAZYN_PH")>0
  repl rest ETAP with "PH " for TYP="N".and.MAGAZYN_PH="T"
endi

END SEQUENCE
close data

QKE("Liczba wczytanych zamwie : "+ltrim(str(_ile,3)))

RETURN NIL

*******************************************************************************
FUNCTION ROK_ZA()
RETURN subs(dtos(DATA_ZAM),1,4)

*******************************************************************************
FUNCTION PH(_konto)
RETURN subs(trans0(val(_konto),5),4,2)

*******************************************************************************
FUNCTION SYMBOL()
RETURN  KONTO+ROK_ZA()+NR_ZAM

*******************************************************************************
FUNCTION NR_DOM(_konto,_data)
loca _sel:=sele(),_nr:=0

sele 0
_use(_gdzie_lap+"NR_ZAM","E!")
set index to (_gdzie_lap+"NR_ZAM")     //ROK_ZAM+KONTO
dbseek(ROK(_data)+_konto)
if !found()
  dbappend()
  repl KONTO with _konto, ROK_ZAM with ROK(_data)
endi
_nr:=NR_ZAM+1
repl NR_ZAM with NR_ZAM+1
CPclose(NR_ZAM)

sele (_sel)
RETURN trans0(_nr,4)

*******************************************************************************
FUNCTION INDEX_L(_ntx,_co)                                          //08.11.15
// _co : Z - zamowienia, C - CRM
local _tex,_apom,_zb,_i1,_k1,_i2,_k2,_i3,_k3,_i4,_k4,_i


DEFAULT _ntx TO .f.,;
        _co  TO " "                                   

cls
_tex:='۲  SORTOWANIE ZBIORW OBSUGI ZAMWIE  '
@ 0,0 say _tex

_total:=18
PASEK(,,'')

BEGIN SEQUENCE

if _ntx.and._co==" "
  _apom:=directory("*.NTX")     
  for _i:=1 to len(_apom); dele file (_apom[_i][1]); next
endi

_use(_gdzie_lap+"SL_PLA","E!")
if _priorytet=9; @ 23,0 say "SL_PLA"+spac(12); endi
inkey(0.2)
pack
inde on SPOSOB_PLA to (_gdzie_lap+"SL_PLA")
* PASEK(1,,"")
STOP_SORT()

_use(_gdzie_lap+"NR_ZAM","E!")
if _priorytet=9; @ 23,0 say "NR_ZAM"+spac(12); endi
inkey(0.2)
pack
inde on ROK_ZAM+KONTO to (_gdzie_lap+"NR_ZAM")
* PASEK(1,,"")
STOP_SORT()

if _co$" Z"
  _use(_gdzie_lap+"EWIZAM","E!")
  if _priorytet=9; @ 23,0 say "EWIZAM"+spac(12); endi
  inkey(0.2)
  *----------------------------------------------------- przesortowanie wg nazw
  pack
  repl all STATUS with "A" for STATUS="E"                            //24.02.14
  inde on SYMBOL()+NAZWA_TOW to (_sc+"EWIZAM_R")
  copy to (_sc+"EWIZAM_R")
  zap
  appe from (_sc+"EWIZAM_R")
  dele file (_sc+"EWIZAM_R.DBF")
  dele file (_sc+"EWIZAM_R.NTX")
  *-------------------------------------------------------
  inde on SYMBOL()+TYP+INDEKS              to (_gdzie_lap+"EWIZ_SI")
  inde on SYMBOL()+TYP+NAZWA_TOW           to (_gdzie_lap+"EWIZ_SN")
  inde on NR_KON+SYMBOL()+TYP              to (_gdzie_lap+"EWIZ_KS")
  inde on dtos(DATA_ZAM)+SYMBOL()+TYP      to (_gdzie_lap+"EWIZ_DS")
  inde on TYP+ETAP                         to (_gdzie_lap+"EWIZ_TE")
                                    // SYMBOL() = KONTO+ROK_ZA()+NR_ZAM
                                    // ROK_ZA() = subs(dtos(DATA_ZAM),1,4)
  use
  PASEK(1,,"")
  STOP_SORT()

  /*
  dbsetorder(1); dbseek(_konto+ROK(_data_zam)+_nr_zam+_typ+_indeks)
  dbsetorder(2); dbseek(_konto+ROK(_data_zam)+_nr_zam+_typ+_nazwa_tow)
  dbsetorder(3); dbseek(_nr_kon+konto+ROK(_data_zam)+_nr_zam+_typ)
  dbsetorder(4); dbseek(dtos(_data_zam)+konto+ROK(_data_zam)+_nr_zam+_typ)
  dbsetorder(5); dbseek(_typ+dtos(_data_zam)+konto)             
  */

  _use(_gdzie_lap+"EWIARC","E!")
  if _priorytet=9; @ 23,0 say "EWIARC"+spac(12); endi
  inkey(0.2)
  pack
  inde on SYMBOL()+TYP+INDEKS              to (_gdzie_lap+"EWIA_SI")
  inde on SYMBOL()+TYP+NAZWA_TOW           to (_gdzie_lap+"EWIA_SN")
  inde on NR_KON+SYMBOL()+TYP              to (_gdzie_lap+"EWIA_KS")
  inde on dtos(DATA_ZAM)+SYMBOL()+TYP      to (_gdzie_lap+"EWIA_DS")
  inde on TYP+ETAP                         to (_gdzie_lap+"EWIA_TE")
  use
  PASEK(1,,"")
  STOP_SORT()
endi

if _co$" Z".and.file(_gdzie_lap+"ZAM_N.DBF").and.file(_gdzie_lap+"ZAM_P.DBF")

  sele 0
  _use(_gdzie_lap+"ZAM_N","E!")
  if _priorytet=9; @ 23,0 say "ZAM_N"+spac(12); endi
  inkey(0.2)
  pack
  inde on KONTO+subs(dtos(DATA_ZAM),1,4)+NR_ZAM  to (_gdzie_lap+"ZAM_N_S")
  inde on dtos(DATA_MAG)+NR_KON                  to (_gdzie_lap+"ZAM_N_K")
  inde on OPE_MAG+DTOS(DATA_MAG)                 to (_gdzie_lap+"ZAM_N_O")
  use
  PASEK(1,,"")
  STOP_SORT()

  sele 0
  _use(_gdzie_lap+"ZAM_P","E!")
  if _priorytet=9; @ 23,0 say "ZAM_P"+spac(12); endi
  inkey(0.2)
  pack
  inde on KONTO+subs(dtos(DATA_ZAM),1,4)+NR_ZAM to (_gdzie_lap+"ZAM_P_S")
  use
  PASEK(1,,"")
  STOP_SORT()

endi

if _co$" C"
  _use(_gdzie_lap+"CRM","E!")                            
  if _priorytet=9; @ 23,0 say "CRM"+spac(12); endi
  inkey(0.2)
  pack
  index on KONTO+dtos(DATA)        to (_gdzie_lap+"CRM_PH")
  index on NR_KON+dtos(DATA)       to (_gdzie_lap+"CRM_KO")
  index on TYP+dtos(DATA)          to (_gdzie_lap+"CRM_TY")
  index on TYP+dtos(TERMIN)+GODZ_T to (_gdzie_lap+"CRM_TE") for KONTO=_konto_ph
  index on KONTO+TIMEDATE          to (_gdzie_lap+"CRM_KT")
  PASEK(1,,"")
  STOP_SORT()

  _use(_gdzie_lap+"SL_CRM","E!")                                                //08.09.12
  if _priorytet=9; @ 23,0 say "SL_CRM"+spac(12); endi
  inkey(0.2)
  pack
  index on NR       to (_gdzie_lap+"SL_CRM_N")
  index on OPERACJA to (_gdzie_lap+"SL_CRM_O")
  * PASEK(1,,"")
  STOP_SORT()
endi

END SEQUENCE
close data
PASEK(,,"")

RETURN NIL

*******************************************************************************
FUNCTION IMPORT_FTP()       //wczytanie zamwie z FTP
local _tex:='۲  IMPORT ZAMWIE Z FTP DO FOLDERU POREDNIEGO  '
local _ser_ftp:=.f.
priv  _konto:=spac(5)

priv _kat_dan:=alltrim(_gdzie_dan)
priv _kat_mag:=alltrim(_gdzie_mv)

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use("SL_KONT","S"); BREAK; endi
set index to SL_KONT


@ 1,0 say "Konto : " get _konto pict "@K 99999";
      when SLGET("SL_KONT","SL_KONT","V1",1,1,{"konto"},,.f.);
      vali SZ().and.val(_konto)>0.and.SL("SL_KONT","SL_KONT","V1",1,1);
               .and.SLGET() 
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi
if !QTN("Wczytanie zamwie przedstawiciela "+_konto+" z FTP ?")
   BREAK
endi

CPClose(SL_KONT)

sele 0
if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endi
set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
             (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")

if file(_kat_dan+"EWIZAM.DBF")

  DAJ_FZAM()

  if !(QTN("Skasowa poprzednie zamwienia z folderu poredniego ?").and.;
       QTN("Jeste pewien ?").and.HA(_haslo))
    BREAK
  endi
endi
CPClose(KON)

dele file (_kat_dan+"EWIZAM.DBF")                                    //20.07.12
dele file (_kat_dan+"EWIZAM.DBT")

/* stara wersja                                                      //10.09.19
_plik:=fcreate("freadz.bat")
fwriteln(_plik,"cls")
fwriteln(_plik,"ftp -s:freadz.scr")
fclose(_plik)
  
_plik:=fcreate("freadz.scr")
fwriteln(_plik,"open "+_ftp_open)
fwriteln(_plik,_ftp_login)
fwriteln(_plik,_ftp_pass)
fwriteln(_plik,"cd "+_ftp_path)
fwriteln(_plik,"cd DANE_"+trans0(val(_konto),2))

fwriteln(_plik,"rename ewizam.dbf EWIZAM.DBF")                       //12.05.14
fwriteln(_plik,"rename ewizam.dbt EWIZAM.DBT")
fwriteln(_plik,"rename EWIZAM.dbf EWIZAM.DBF")
fwriteln(_plik,"rename EWIZAM.dbt EWIZAM.DBT")

fwriteln(_plik,"binary")
fwriteln(_plik,"get EWIZAM.DBF "+_kat_dan+"EWIZAM.DBF")
fwriteln(_plik,"binary")
fwriteln(_plik,"get EWIZAM.DBT "+_kat_dan+"EWIZAM.DBT")
fwriteln(_plik,"quit")
fclose(_plik)
  
//SWPRUNCMD("cmd <freadz.bat",0,"","")
RUN freadz.bat     //xHB
*/

NEW_FTP(_ftp_login,_ftp_pass,_ftp_open,;                             //10.09.19
        _ftp_path,"DANE_"+trans0(val(_konto),2),,;
        _kat_dan+"EWIZAM.DBF",_kat_dan+"EWIZAM.DBT","DOWNLOAD")

tone(880,1)
clear typeahead
inkey(3)


if _tmp_ftp.and.!(file(_kat_dan+"EWIZAM.DBF").and.file(_kat_dan+"EWIZAM.DBT");
  .and.filesize(_kat_dan+"EWIZAM.DBF")>0.and.filesize(_kat_dan+"EWIZAM.DBT")>0)
                                                    //serwisowa lokalizacja FTP

   dele file (_kat_dan+"EWIZAM.DBF")
   dele file (_kat_dan+"EWIZAM.DBT")

  _plik:=fcreate("freadz.bat")
  fwriteln(_plik,"cls")
  fwriteln(_plik,"ftp -s:freadz.scr")
  fclose(_plik)
  
  _plik:=fcreate("freadz.scr")
  fwriteln(_plik,"open "+_ftp_open2)
  fwriteln(_plik,_ftp_logi2)
  fwriteln(_plik,_ftp_pass2)
  fwriteln(_plik,"cd "+_ftp_path2)
  fwriteln(_plik,"cd DANE_"+trans0(val(_konto),2))
  fwriteln(_plik,"binary")
  fwriteln(_plik,"get EWIZAM.DBF "+_kat_dan+"EWIZAM.DBF")
  fwriteln(_plik,"binary")
  fwriteln(_plik,"get EWIZAM.DBT "+_kat_dan+"EWIZAM.DBT")
  fwriteln(_plik,"quit")
  fclose(_plik)
  
  //SWPRUNCMD("cmd <freadz.bat",0,"","")
  RUN freadz.bat  //xHB
  
  tone(880,1)
  clear typeahead
  inkey(3)

  _ser_ftp:=.t.
endi


K_OFF()
//dele file freadz.scr                                              //01.09.14
wait "Nacinij dowolny klawisz ..."

cls
@ 0,0 say _tex

if file (_kat_dan+"EWIZAM.DBF").and.file(_kat_dan+"EWIZAM.DBT")
  if filesize(_kat_dan+"EWIZAM.DBF")>0.and.filesize(_kat_dan+"EWIZAM.DBT")>0
     QKE("Pobrano zamwienia z "+if(_ser_ftp,"COMPED ","")+"FTP")
     BREAK
  endi
endi

dele file (_kat_dan+"EWIZAM.DBF")  
dele file (_kat_dan+"EWIZAM.DBT")


QKE("Nie pobrano zamwie z FTP")
END SEQUENCE

RETURN NIL

*******************************************************************************
FUNCTION DTOC2(_d)
loca _s:=dtos(_d)
RETURN subs(_s,7,2)+"."+subs(_s,4,2)+"."+str(year(_d),4)

*******************************************************************************
FUNCTION KOLORY()
local _ret:={1,2}

if fieldpos("STAN_PH")>0.and.STAN_PH>0          ; _ret:={12,2}  //niebieskie
elseif fieldpos("STAN")>0.and.STAN=0            ; _ret:={9,2}   //czerwone
elseif fieldpos("WN_ODB")>0.and.;
       fieldpos("MA_ODB")>0.and.WN_ODB-MA_ODB>0 ; _ret:={10,2}  //magenta
elseif fieldpos("USLUGA")>0.and.USLUGA="+"      ; _ret:={10,2}  //magenta
elseif fieldpos("USLUGA")>0.and.USLUGA="!"      ; _ret:={11,2}  //ty
endi

/*
   _ret:={11,2}          //ty
   _ret:={9,2}           //czerwony                
   _ret:={10,2}          //magenta                
   _ret:={12,2}          //niebieski
   _ret:={1,2}           //zwyky    
*/
RETURN _ret

*******************************************************************************
FUNCTION KOLORY_WN()
local _ret:={1,2}
if WN>0.and.DATA_PLA<date(); _ret:={9,2}
elseif WN<0 ; _ret:={12,2}
endi
RETURN _ret

*******************************************************************************
FUNCTION DS(_d)
RETURN if(empty(_d),spac(8),dtoc(_d))

*******************************************************************************
FUNCTION PARAGON()
local _u:=_uwagi
if _faktura="F".and._uwagi="PARAGON"
  _uwagi:=ltrim(subs(_uwagi,8))
endi
if _faktura="P".and.!_uwagi="PARAGON"
  _uwagi:="PARAGON "+_uwagi
endi
if !empty(_uwagi)
  keyboard chr(K_END)
endi
RETURN .T.

*******************************************************************************
FUNCTION UWAGA()
RETURN padr(" "+UWAGI,74)

*******************************************************************************
FUNCTION DAJ_FZAM(_poz)    //tworzy NZAM.DBF z folderu przejciowego //09.01.20
loca _astru:={}, _sel:=select()
loca _aza:={}                                                        //09.01.19

priv _kat_dan:=alltrim(_gdzie_dan)

DEFAULT _poz TO .F.                                                  //09.01.20

BEGIN SEQUENCE

_astru:={}
aadd(_astru,{"DATA_ZAM  ","D", 8,0})
aadd(_astru,{"KONTO     ","C", 5,0})
aadd(_astru,{"NR_ZAM    ","C", 4,0})
aadd(_astru,{"NR_KON    ","C", 5,0})
aadd(_astru,{"NAZWA_KON ","C",40,0})
aadd(_astru,{"MIASTO    ","C",20,0})
aadd(_astru,{"ADRES     ","C",30,0})
aadd(_astru,{"TERMIN    ","N", 3,0})
aadd(_astru,{"PLATNOSC  ","C",10,0})
aadd(_astru,{"FAKTURA   ","C", 1,0})
aadd(_astru,{"UWAGI     ","C",70,0})
aadd(_astru,{"CENNIK    ","C", 1,0})
aadd(_astru,{"RABAT_N   ","N", 9,2})
aadd(_astru,{"WARTOSC   ","N",12,2})
aadd(_astru,{"OPE_ZAM   ","C", 3,0})                                 //02.12.13
aadd(_astru,{"ETAP      ","C", 3,0})                                 //02.12.13
aadd(_astru,{"MAGAZYN_PH","C", 1,0})                                 //16.12.13
aadd(_astru,{"KURIER    ","C", 1,0})                               
aadd(_astru,{"OPLATA    ","C", 1,0})                               
aadd(_astru,{"KUPONY    ","C", 1,0})                               
aadd(_astru,{"PACZKI    ","C",40,0})                                 //16.09.18
aadd(_astru,{"OPE_MAG   ","C", 3,0})                                 //14.03.14
aadd(_astru,{"DATA_MAG  ","D", 8,0})                         
aadd(_astru,{"TIME_MAG  ","C",12,0})                         
aadd(_astru,{"CW        ","C", 1,0})                                 //29.08.15
dbcreate(_sc+"NZAM",_astru)

sele 0
_use(_sc+"NZAM","E!")

sele select("EWIZAM")
if !_use(_kat_dan+"EWIZAM","R"); BREAK; endi
set filt to TYP="N"
dbeval({|| EWI_TO_NZAM()})
CPClose(EWIZAM)

sele NZAM
go top

if !_poz                                                             //09.01.20
  @ 2,0 clea to 24,79
  @ 3,0 say "UWAGA : W folderze porednim znajduj si zamwienia:"  //23.10.19
endi

_zaznaczone:={}

CPEDIT  POZ: if(_poz,1,4),,23,    ;                                  //09.01.20
        DEF: "NZAM"               ;
        POZWER: "V8"              ;                                  //18.03.14
        POZSLAD: " "+padr(UWAGI,76);
        PION: ,,,                 ;
        AKCJA: AKC_IMP(_poz)      ;                                  //09.01.20
        INDEXY: {} ;
        ODTWORZ:.f.

for _i:=1 to len(_zaznaczone)                                        //09.01.20
  dbgoto(_zaznaczone[_i])
  aadd(_aza,{DATA_ZAM,KONTO,NR_ZAM})
next 

END SEQUENCE

CPClose(NZAM)
CPClose(EWIZAM)

sele (_sel)
RETURN _aza                                                          //09.01.20

*******************************************************************************
FUNCTION EWI_TO_NZAM()
loca _termin:=0, _platnosc:="", _faktura:="", _uwagi:="", _cennik:="",; 
     _rabat:=0, _wartosc:=0, _ope_zam:=spac(3)                       //29.11.13

ODCZYT_OPI(@_termin,@_platnosc,@_faktura,@_uwagi,@_cennik,@_rabat,@_wartosc,; 
                                                 @_ope_zam)          //29.11.13

if fieldpos("KUPONY")>0                                              //23.06.15 
  if fieldpos("PACZKI")>0.and.fieldpos("OPE_MAG")>0;                 //18.12.13
     .and.fieldpos("DATA_MAG")>0.and.fieldpos("TIME_MAG")>0          //13.03.13
  
  
    APP_NAG(KONTO,DATA_ZAM,NR_ZAM,NR_KON,;                           //20.07.12
    _termin,_platnosc,_faktura,_uwagi,_cennik,_rabat,_wartosc,_ope_zam,;
    ETAP,MAGAZYN_PH,KURIER,OPLATA,KUPONY,PACZKI,OPE_MAG,DATA_MAG,TIME_MAG)  //13.01.14
  else
    APP_NAG(KONTO,DATA_ZAM,NR_ZAM,NR_KON,;                           //20.07.12
    _termin,_platnosc,_faktura,_uwagi,_cennik,_rabat,_wartosc,_ope_zam,;
    ETAP,MAGAZYN_PH,KURIER,OPLATA,KUPONY)                            //14.01.14
  endi
else
  if fieldpos("PACZKI")>0.and.fieldpos("OPE_MAG")>0;                 //18.12.13
     .and.fieldpos("DATA_MAG")>0.and.fieldpos("TIME_MAG")>0          //13.03.13
  
  
    APP_NAG(KONTO,DATA_ZAM,NR_ZAM,NR_KON,;                           //20.07.12
    _termin,_platnosc,_faktura,_uwagi,_cennik,_rabat,_wartosc,_ope_zam,;
    ETAP,MAGAZYN_PH,KURIER,OPLATA,"N",PACZKI,OPE_MAG,DATA_MAG,TIME_MAG)  //13.01.14
  else
    APP_NAG(KONTO,DATA_ZAM,NR_ZAM,NR_KON,;                           //20.07.12
    _termin,_platnosc,_faktura,_uwagi,_cennik,_rabat,_wartosc,_ope_zam,;
    ETAP,MAGAZYN_PH,KURIER,OPLATA,"N")                               //14.01.14
  endi
endi


RETURN NIL

*******************************************************************************
FUNCTION ODCZYT_OPI(_termin, _platnosc, _faktura, _uwagi, _cennik,_rabat,;
                   _wartosc,_ope_zam)                                //29.11.13
local _sel:=select(), _rek:=recn(), _ord:=indexord(), _linia:=""
local _konto_r:=spac(5), _data_z_r:=ctod(""), _nr_zam_r:=spac(4),;
      _nr_kon_r:=spac(5)

_linia:=EWIZAM->OPIS
TOKENINIT(@_linia,";",1)
_j:=0
do while !TOKENEND().and._j<12                                       //29.11.13
  _t:=TOKENNEXT(_linia)
  _j+=1

  do case
    case _j=1 // ; _konto_r :=trans0(val(_t),5)      
    case _j=2 // ; _data_z_r:=stod(_t) 
    case _j=3 // ; _nr_zam_r:=trans0(val(_t),4)
    case _j=4 // ; _nr_kon_r:=trans0(val(_t),5)

    case _j=5  ; _termin:=val(_t)
    case _j=6  ; _platnosc:=padr(_t,8)
    case _j=7  ; _faktura:=_t
    case _j=8  ; _uwagi:=padr(_t,70)
    case _j=9  ; _cennik:=padr(_t,1)
    case _j=10 ; _rabat:=val(_t)
    case _j=11 ; _wartosc:=val(_t)
    case _j=12 ; _ope_zam:=padr(_t,3)                                //29.11.13
  endc
endd // przeczytane tokeny

sele (_sel)
dbsetorder(_ord)
dbgoto(_rek)

RETURN NIL

*******************************************************************************
FUNCTION APP_NAG(_konto, _data_zam, _nr_zam, _nr_kon,;
         _termin, _platnosc, _faktura, _uwagi, _cennik, _rabat,;
         _wartosc,_ope_zam,_etap,_mag_ph,_kurier,_oplata,_kupony,_paczki,;
         _ope_mag,_data_mag,_time_mag )                              //14.03.14

local _sel:=select()

DEFAULT _paczki   TO "",;
        _ope_mag  TO "",;
        _time_mag TO "",;
        _data_mag to ctod("")   

KON->(dbseek(_nr_kon))

sele NZAM
appe blan
repl KONTO     with _konto,;
     DATA_ZAM  with _data_zam,;
     NR_ZAM    with _nr_zam,;
     NR_KON    with _nr_kon,;
     TERMIN    with _termin,;
     PLATNOSC  with _platnosc,;
     FAKTURA   with _faktura,;
     UWAGI     with _uwagi,;
     CENNIK    with _cennik,;
     RABAT_N   with _rabat,;
     WARTOSC   with _wartosc,;
     NAZWA_KON with KON->NAZWA_KON,;
     MIASTO    with KON->MIASTO,;
     ADRES     with KON->ADRES,;
     OPE_ZAM   with _ope_zam,;                                       //16.12.13
     ETAP      with _etap,;   
     MAGAZYN_PH with _mag_ph,;
     KURIER    with _kurier,;
     KUPONY    with _kupony,;
     OPLATA    with _oplata,;
     PACZKI    with _paczki,;                                        //14.01.14
     OPE_MAG   with _ope_mag,;                                       //14.03.14
     DATA_MAG  with _data_mag,;
     TIME_MAG  with _time_mag

if fieldpos("CW")>0.and.KON->(fieldpos("CW")>0)                      //30.08.15
  repl CW with KON->CW
endi

sele (_sel)
RETURN NIL

*******************************************************************************
FUNCTION ZZAM()
local _tex:='۲  ZESTAWIENIE ZAMWIE  '
local _astru:={}
priv _konto:=spac(5), _nr_kon:=spac(5), _data_zam:=ctod(""), _termin:=0,;
     _platnosc:=spac(8),_faktura:=" ",_uwagi:=spac(70),_cennik:=" ",;
     _rabat:=0, _wartosc:=0
priv _data_od:=date(),_data_do:=date()
priv _etap_o:=spac(3)                                                //16.03.14
priv _arch                                                           //03.10.17

cls
@ 0,0 say _tex

BEGIN SEQUENCE

_arch:=(HorizMenu(1,0,"Zamwienia :",{"AKTYWNE","ARCHIWALNE"},1)=2)

//_data_od:=if(_arch,stod(str(year(date()),4)+"0101"),date()-3)
_data_od:=if(_arch,stod(str(year(date()),4)+"0101"),ctod(""))        //15.10.12
_data_do:=date()

@ 1,35 say  "Dane z okresu :" get _data_od vali _data_od<=date()
@ 1,col()+1 say "-" get _data_do vali _data_od<=_data_do
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

QPC(1)

_astru:={}
aadd(_astru,{"DATA_ZAM  ","D", 8,0})
aadd(_astru,{"KONTO     ","C", 5,0})
aadd(_astru,{"NR_ZAM    ","C", 4,0})
aadd(_astru,{"NR_KON    ","C", 5,0})
aadd(_astru,{"NAZWA_KON ","C",40,0})
aadd(_astru,{"MIASTO    ","C",20,0})
aadd(_astru,{"ADRES     ","C",30,0})
aadd(_astru,{"TERMIN    ","N", 3,0})
aadd(_astru,{"PLATNOSC  ","C",10,0})
aadd(_astru,{"FAKTURA   ","C", 1,0})
aadd(_astru,{"UWAGI     ","C",70,0})
aadd(_astru,{"CENNIK    ","C", 1,0})
aadd(_astru,{"RABAT_N   ","N", 9,2})
aadd(_astru,{"WARTOSC   ","N",12,2})
aadd(_astru,{"OPE_ZAM   ","C", 3,0})
aadd(_astru,{"ETAP      ","C", 3,0})                                 //02.12.13
aadd(_astru,{"MAGAZYN_PH","C", 1,0})                                 //16.12.13
aadd(_astru,{"KURIER    ","C", 1,0})                               
aadd(_astru,{"OPLATA    ","C", 1,0})                               
aadd(_astru,{"KUPONY    ","C", 1,0})                               
aadd(_astru,{"PACZKI    ","C",40,0})                                 //16.09.18
aadd(_astru,{"STATUS    ","C", 1,0})                                 //03.03.14
aadd(_astru,{"OPE_MAG   ","C", 3,0})                                 //14.03.14
aadd(_astru,{"DATA_MAG  ","D", 8,0})                         
aadd(_astru,{"TIME_MAG  ","C",12,0})                         
aadd(_astru,{"CW        ","C", 1,0})                                 //29.08.15
aadd(_astru,{"REZERWACJA","C", 1,0})                                 //09.11.17

dbcreate(_sc+"NZAM",_astru)

sele 0
_use(_sc+"NZAM","E!")

sele 0                                                               //09.11.17
_use(_gdzie_lap+"ZAM_N","R")
set index to (_gdzie_lap+"ZAM_N_S")   //KONTO+subs(dtos(DATA_ZAM),1,4)+NR_ZAM
//           (_gdzie_lap+"ZAM_N_K"),; //dtos(DATA_MAG)+NR_KON                  
//           (_gdzie_lap+"ZAM_N_O")   //OPE_MAG+DTOS(DATA_MAG)

sele 0
if !_use("BLOKADYF","R"); BREAK; endif
set index to ("BLOKF_D")   //dtos(DATA_BLO)+KONTO+NR_KON    
//           ("BLOKF_F"),; //NR_KON+s_i(INDEKS)+str(KLASA,3)
//           ("BLOKF_K"),; //KONTO+NR_KON+s_i(INDEKS)+str(KLASA,3) 
//           ("BLOKF_I"),; //s_i(INDEKS)+str(KLASA,3)+KONTO 
             

sele 0
if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endi
set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
             (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")

if !_arch

  sele 0
  if !_use(_gdzie_lap+"EWIZAM","S"); BREAK; endi
  set index to (_gdzie_lap+"EWIZ_SI"),; // SYMBOL()+TYP+INDEKS    
               (_gdzie_lap+"EWIZ_SN"),; // SYMBOL()+TYP+NAZWA_TOW 
               (_gdzie_lap+"EWIZ_KS"),; // NR_KON+SYMBOL()+TYP
               (_gdzie_lap+"EWIZ_DS"),; // dtos(DATA_ZAM)+SYMBOL()+TYP
               (_gdzie_lap+"EWIZ_TE")   // TYP+ETAP                                 //14.08.14
else

  sele 0
  if !_use(_gdzie_lap+"EWIARC","S","EWIZAM"); BREAK; endi
  set index to (_gdzie_lap+"EWIA_SI"),; // SYMBOL()+TYP+INDEKS    
               (_gdzie_lap+"EWIA_SN"),; // SYMBOL()+TYP+NAZWA_TOW 
               (_gdzie_lap+"EWIA_KS"),; // NR_KON+SYMBOL()
               (_gdzie_lap+"EWIA_DS"),; // dtos(DATA_ZAM)+SYMBOL()
               (_gdzie_lap+"EWIA_TE")   // TYP+ETAP                                 //14.08.14
endi

sele 0
if !_use("MAG001","R","MAG"); BREAK; endi                            //01.12.15
set index to M001_IP0

sele 0
if !_use("TOW","S"); BREAK; endi
set index to TOW_IN, TOW_NA, TOW_GR, TOW_SW

sele 0
if !_use("SL_G_TOW","S"); BREAK; endi
set index to SL_G_TOW, SL_G_TON

sele EWIZAM
dbsetorder(4)
dbseek(dtos(_data_od),.t.)
do while DATA_ZAM<=_data_do.and.!eof()
  if TYP<>"N"; skip; loop; endi
  EWI_TO_NZAM()
  
  sele EWIZAM
  skip
endd

sele NZAM
if lastrec()=0
  QKE("Brak "+if(_arch,"archiwalnych ","aktywnych ")+"zamwie.")
  BREAK
endi

set rela to KONTO+subs(dtos(DATA_ZAM),1,4)+NR_ZAM into ZAM_N         //09.11.17
repl all OPE_MAG  with if(empty(OPE_MAG),ZAM_N->OPE_MAG,OPE_MAG),;   //19.11.17
         DATA_MAG with ZAM_N->DATA_MAG,;
         TIME_MAG with ZAM_N->TIME_MAG
set rela to dtos(DATA_ZAM)+KONTO+NR_KON into BLOKADYF   
repl all REZERWACJA with "T" for BLOKADYF->NR_KON<>" "
set rela to dtos(DATA_ZAM-1)+KONTO+NR_KON into BLOKADYF   
repl all REZERWACJA with "T" for BLOKADYF->NR_KON<>" "
set rela to
CPClose(ZAM_N)
CPClose(BLOKADYF)


EWIZAM->(dbsetorder(1))
set rela to SYMBOL()+"N" into EWIZAM                                 //18.03.14
index on KONTO+NR_KON+dtos(DATA_ZAM) to (_sc+"NAG_K") 
index on EWIZAM->ETAP+KONTO+NR_KON   to (_sc+"NAG_E")                //18.03.14
index on dtos(DATA_ZAM)+KONTO+NR_KON to (_sc+"NAG_D")
index on NR_KON+dtos(DATA_ZAM)       to (_sc+"NAG_F")                //03.10.17

                                      // dtos(DATA_ZAM)+KONTO+ROK_ZA()+NR_ZAM
                                      // SYMBOL() = KONTO+ROK_ZA()+NR_ZAM
                                      // ROK_ZA() = subs(dtos(DATA_ZAM),1,4)
set index to (_sc+"NAG_K"),(_sc+"NAG_E"),(_sc+"NAG_D"),;
             (_sc+"NAG_F")                                           //03.10.17

QPC(0)

go top
@ 24,1 say "Space - podgld pozycji zamwienia"
CPEDIT  POZ: 2,,23,               ;
        DEF: "iNZAM"              ;
        POZWER: "V10"             ;                                  //09.11.17
        POZSLAD: " "+padr(UWAGI,76);
        PION: ,,,                 ;
        INDEXY: {"konto","etap","data","firma"} ;                    //03.10.17
        EDYCJA: !_arch.and."ETAP"$CPNazwa()    ;                     //31.08.16
        AKCJA: POZ_ZAM_L(KONTO,DATA_ZAM,NR_ZAM)      ;
        KOLORUJ: KOLORY_E2()      ;                                  //02.12.13
        SIEC: REKORD              ;
        ODTWORZ:.f.

//      EDYCJA: _priorytet>=9.and.!_arch.and."ETAP"$CPNazwa()    ;   //31.08.16

@ 24,0

//UWAGA: zmian EWIZAM->ETAP lepiej by byo wykonywa na zablokowanym rekordzie
//         EWIZAM a nie pliku roboczego 

EWIZAM->(dbsetorder(1))                                              //28.02.14

/*
FBLOK()
dbeval({|| EWIZAM->(dbseek(NZAM->(SYMBOL()))),;
           if(EWIZAM->(found().and.dbrlock(recn())),;
             (EWIZAM->ETAP:=ETAP(NZAM->ETAP),;                       //17.06.14
              if(EWIZAM->(fieldpos("STATUS")>0),EWIZAM->STATUS:="",NIL),;
              EWIZAM->(dbrunlock(recn()))),NIL)})
*/

if len(_zaznaczone)>0; set filter to ascan(_zaznaczone,recn())>0; endif
go top

CPDRUK  DEF: "NZAM"            ;
        WERSJA: "V1"               ; 
        TYTUL: "ZESTAWIENIE ZAMWIE"+if(_arch," ARCHIWALNYCH","")+;
               " okres "+dtoc(_data_od)+" - "+dtoc(_data_do);
        WARIANT: 5

END SEQUENCE
close data

RETURN NIL

*******************************************************************************
FUNCTION WE_ETAP()       //ETAP$"   ,PH ,K  ,M  ,G  ,X  , nn"        //16.03.14

if !_operator$_we_etap; RETURN .F.; endi                             //31.08.16

ILE_ZAM_KON()                                                        //03.10.17

/*                                                                   //26.06.20
if subs(EWIZAM->ETAP,1,1)$"PKMGX"
  if !HA("BAFPOL"); RETURN .F.; endi
endi
*/

if !EWIZAM->(rlock()); RETURN .F.; endi

/*                                                                   //26.06.20
if empty(EWIZAM->ETAP)
  EWIZAM->ETAP:=" 22"
endi
*/

RETURN .T.

*******************************************************************************
FUNCTION WA_ETAP()
/*                                                                   //26.02.20 
if val(EWIZAM->ETAP)>0; repl EWIZAM->ETAP with " "+str(val(EWIZAM->ETAP),2)
endi
*/

/*                                                                   //30.03.14
if subs(EWIZAM->ETAP,1,1)$"MGKP".and.!HA(_haslo)           
  RETURN .F.
endi
*/

/*                                                                   //26.06.20
if EWIZAM->ETAP="   ".or.EWIZAM->ETAP="PH ".or.;                     //17.03.14
   (subs(EWIZAM->ETAP,1,1)$"KMGX ".and.;
     (subs(EWIZAM->ETAP,2,2)="  ".or.;                               //03.06.20
       (subs(EWIZAM->ETAP,2,2)>="10".and.subs(EWIZAM->ETAP,2,2)<="40")))
*/

if EWIZAM->ETAP$"   |PH |G  |M  |K  |X  ".or.;                       //29.06.20
   (EWIZAM->ETAP>="010".and.EWIZAM->ETAP<="319")

  dbrunlock()
  CPSwiezyRekord()
  RETURN .T.
endi

RETURN .F.

*******************************************************************************
FUNCTION WY_ETAP()                                                   //17.03.14
dbrunlock()
RETURN .T.

*******************************************************************************
FUNCTION DAJ_KONTO(_konto)
if _ktory_rekord>0
  go _ktory_rekord  
  _ktory_rekord:=0
  _konto:=KONTO
endi                                                                
for _i:=1 to len(GetList); GetList[_i]:display(); next 
RETURN .t.

*******************************************************************************
FUNCTION SKASUJ_ZAM()                                                //10.08.13
local _tex:='۲  SKASOWANIE ZAMWIE ARCHIWALYCH  ',;
      _data_do:=stod(str(year(date()),4)+"0101")


cls
@ 0,0 say _tex

BEGIN SEQUENCE

@ 1,0 say "Skasowanie zamwi archiwalnych do dnia :" get _data_do 
set curs on; read; set curs off

sele 0
if !_use(_gdzie_lap+"EWIARC","E"); BREAK; endi
set index to (_gdzie_lap+"EWIA_SI"),; // SYMBOL()+TYP+INDEKS    
             (_gdzie_lap+"EWIA_SN"),; // SYMBOL()+TYP+NAZWA_TOW 
             (_gdzie_lap+"EWIA_KS"),; // NR_KON+SYMBOL()
             (_gdzie_lap+"EWIA_DS"),; // dtos(DATA_ZAM)+SYMBOL()
             (_gdzie_lap+"EWIA_TE")   // TYP+ETAP                                   //14.08.14

if QTN("Skasowa dane archiwalne zamwie do dnia "+dtoc(_data_do)+" ?").and.;
                                                    HA(_haslo)

 QPC(1)
 dele all for DATA_ZAM<=_data_do
 pack
 QPC(0)
 close data

 QK("Skasowano zamwienia archiwalne do dnia "+dtoc(_data_do))
endi

END SEQUENCE
close data
RETURN NIL

*******************************************************************************
FUNCTION DAJ_OPE()
local _ope:=spac(3)

RETURN _ope

*******************************************************************************
FUNCTION DO_FAK_TXT(_nr_kon)

if empty(_nr_kon); RETURN NIL; endi

KON->(dbsetorder(1))
KON->(dbseek(_nr_kon))

sele FAK_TXT

appe blan; repl LINIA with "|F"+KON->NR_KON
appe blan; repl LINIA with "|N"+KON->NAZWA_KON
appe blan; repl LINIA with "|2"+KON->NAZWA_KON2
appe blan; repl LINIA with "|A"+KON->ADRES
appe blan; repl LINIA with "|K"+KON->KOD
appe blan; repl LINIA with "|M"+KON->MIASTO
RETURN NIL

*******************************************************************************
FUNCTION OPE_ZAM(_ali)                                               //02.12.13
local _t:=OPIS
DEFAULT _ali TO "NZAM"

RETURN subs(_t,ATTOKEN(_t,";",12),3)  //12-ty token to _ope_zam

*******************************************************************************
FUNCTION KOLORY_E()                                                  //02.12.13
local _ret:={1,2}

if     fieldpos("ETAP")>0.and.val(ETAP)>0  ; _ret:={11,2}  //te
elseif fieldpos("ETAP")>0.and.ETAP="M"   ; _ret:={ 9,2}  //czerwone  //16.03.14
elseif fieldpos("ETAP")>0.and.ETAP="G"   ; _ret:={12,2}  //niebieskie
endi

/*
   _ret:={11,2}          //ty
   _ret:={9,2}           //czerwony                
   _ret:={10,2}          //magenta                
   _ret:={12,2}          //niebieski
   _ret:={1,2}           //zwyky    
*/
RETURN _ret

*******************************************************************************
FUNCTION KOLORY_E2()
local _ret:={1,2}

if     EWIZAM->(fieldpos("ETAP")>0.and.val(ETAP)>0)  ; _ret:={11,2}  //te
elseif EWIZAM->(fieldpos("ETAP")>0.and.ETAP="M")   ; _ret:={ 9,2}  //czerwone 
elseif EWIZAM->(fieldpos("ETAP")>0.and.ETAP="G")   ; _ret:={12,2}  //niebieskie
endi

/*
   _ret:={11,2}          //ty
   _ret:={9,2}           //czerwony                
   _ret:={10,2}          //magenta                
   _ret:={12,2}          //niebieski
   _ret:={1,2}           //zwyky    
*/
RETURN _ret

*******************************************************************************
FUNCTION ILO_FAK()
repl ILO_FAK with ILO_ZAM
RETURN .T.

*******************************************************************************
FUNCTION INV()                                                       //12.01.14
loca _t:=""
RETURN ""   //wyczone

if _rest[NCUR]==_hor
    col:=_hor:colPos
    row:=_hor:rowPos
    rec:=_hor:rowCount
//  _t:=_hor:cargo[NVAR][col]       //nazwa
    _t:=padr(ltrim(str(rec)),10)
endi   
RETURN _t

*******************************************************************************
FUNCTION OPI(_x)       //tmp                                         //05.03.14
local _sel:=select(), _rek:=recn(), _ord:=indexord(), _linia:="", _y:=""
local _ter:="",_pla:="",_fak:="",_uwa:="",_cen:="",_rab:="",_war:="",_ope:=""
local _kon:=spac(5), _dat:=ctod(""), _nrz:=spac(4),_nrk:=spac(5)
/* _x :
_termin    T
_platnosc  P
_faktura   F
_uwagi     U
_cennik    C
_rabat     R
_wartosc   W
_ope_zam   O
*/

if !_x$"TPFUCRWO"; RETURN ""; endi

_linia:=EWIZAM->OPIS
TOKENINIT(@_linia,";",1)
_j:=0
do while !TOKENEND().and._j<12                                       //29.11.13
  _t:=TOKENNEXT(_linia)
  _j+=1

  do case
    case _j=1 // ; _kon:=trans0(val(_t),5)      
    case _j=2 // ; _dat:=stod(_t) 
    case _j=3 // ; _nrz:=trans0(val(_t),4)
    case _j=4 // ; _nrk:=trans0(val(_t),5)
    case _j=5    ; _ter:=val(_t)
    case _j=6    ; _pla:=padr(_t,8)
    case _j=7    ; _fak:=_t
    case _j=8    ; _uwa:=padr(_t,70)
    case _j=9    ; _cen:=padr(_t,1)
    case _j=10   ; _rab:=val(_t)
    case _j=11   ; _war:=val(_t)
    case _j=12   ; _ope:=padr(_t,3)                           
  endc
endd // przeczytane tokeny

do case
 case _x="T"; _y:=_ter
 case _x="P"; _y:=_pla
 case _x="F"; _y:=_fak
 case _x="U"; _y:=_uwa
 case _x="C"; _y:=_cen
 case _x="R"; _y:=_rab
 case _x="W"; _y:=_war
 case _x="0"; _y:=_ope
endc

sele (_sel)
dbsetorder(_ord)
dbgoto(_rek)

RETURN _y

*******************************************************************************
FUNCTION POZ_ZAM_L(_konto,_data_zam,_nr_zam)                         //16.03.14
loca _lk:=lastkey(),_sel:=sele(),_r:=row(),_c:=col(),_ocolor:=SET(_SET_COLOR)
loca _screen:=savescreen(0,0,24,79)

loca _ewi_or:=EWIZAM->(indexord()),_ewi_re:=EWIZAM->(recn())

if _lk=K_SPACE

  SET(_SET_COLOR,_ekra_blo)
  @ 24,0

  sele EWIZAM
  dbsetorder(2)
  dbseek(_konto+ROK(_data_zam)+_nr_zam+"P")
  copy to (_sc+"ZAM_RP") while _konto+ROK(_data_zam)+_nr_zam+"P"==;
                                KONTO+ROK( DATA_ZAM)+ NR_ZAM+"P";
                         for   INDEKS="00000"                        //08.01.16

  dbseek(_konto+ROK(_data_zam)+_nr_zam+"P")
  copy to (_sc+"ZAM_RP2") while _konto+ROK(_data_zam)+_nr_zam+"P"==;
                               KONTO+ROK( DATA_ZAM)+ NR_ZAM+"P";
                         for   !INDEKS="00000"                       //08.01.16

  sele 0
  _use(_sc+"ZAM_RP","E!","EWIPOZ")
  appe from (_sc+"ZAM_RP2")

  go top
  CPEDIT POZ: 2,,18,         ;
         DEF: "LEWIZAM"     ;
         POZWER: if(ETAP="G".or.STATUS="A","V1","V8")      ;         //20.05.14
         POZSLAD: SLAD_ZAM_L() ;
         PION: ,,,         ;
         INDEXY: {""} ;
         KOLORUJ: KOLORY_B()       ;                                 //16.03.14
         AKCJA: AKC_ZAM2L(.f.) ;
         ODTWORZ: .f.
  @ 18,0 clea to 24,79

  CPClose(EWIPOZ)
endi

EWIZAM->(dbsetorder(_ewi_or))
EWIZAM->(dbgoto(_ewi_re))

sele (_sel)

SET(_SET_COLOR,_ocolor) 
devpos(_r,_c)
restscreen(0,0,24,79,_screen)

RETURN NIL

*******************************************************************************
FUNCTION SLAD_ZAM_L(_arch,_edycja)                                   //16.03.14
loca _l:=0

DEFAULT _arch   TO .F.,; 
        _edycja TO .F.

@ 18,0,23,79 BOX B_DOUBLE
@ 19,1 clea to 22,78
@ 18,0  say chr(204)
@ 18,79 say chr(185)

_l:=mlcount(OPIS,75)

if !empty(INDEKS)
  if _edycja
    @ 23,4 say " Spacja - edycja "
  elseif _l>4
    @ 23,4 say " Spacja - odczyt "
  endi
endi
if _l>4
  @ 23,73 say "(+)"
else
  @ 23,73 say repl(chr(205),3)
endi
keyboard chr(K_ESC)
MEMOEDIT(OPIS,19,2,22,77,.f.)
* set curs off
RETURN " "+s_i(INDEKS)+" "+padr(NAZWA_TOW,_len_naz)+spac(2)+;
     padr(OPIS_TOW,_len_opi)+spac(3)+;
     if(_arch,"",transform(STAN_OGL(INDEKS),_format_ilo))            //30.11.15

*******************************************************************************
FUNCTION ILOZAM()
local _zam:=0,_or_ewi:=EWIZAM_R->(indexord()),_re_ewi:=EWIZAM_R->(recn()),;
      _ind:=INDEKS

EWIZAM_R->(dbsetorder(1))
if EWIZAM_R->(dbseek(_ind))
  _zam:=EWIZAM_R->ILO_ZAM
endi

EWIZAM_R->(dbsetorder(_or_ewi))
EWIZAM_R->(dbgoto(_re_ewi))

RETURN _zam

*******************************************************************************
FUNCTION WEJZAM(_p)                                                  //12.01.14
local   GetList:={},_wie:=cprow(),_kol:=cpcol(),_rek:=recn(),bsaveTab,;
        _zam:=0,_or_ewi:=EWIZAM_R->(indexord()),_re_ewi:=EWIZAM_R->(recn()),;
        _ind:=INDEKS,_o:=0

DEFAULT _p TO .f.                                                    //12.01.14

BEGIN SEQUENCE

if _p; _o:=_len_naz+len(transform(0,_format_ilo))+7; endi            //12.01.14

bsaveTab:=SetKey(K_TAB,{|| NIL })

EWIZAM_R->(dbsetorder(1))
if EWIZAM_R->(dbseek(_ind))
  _zam:=EWIZAM_R->ILO_ZAM
endi

if !_p                                                               //12.01.14
  _ocolor:=set(_SET_COLOR)
  setcolor("I")  
  @ _wie,_kol-(_len_naz+len(transform(0,_format_ilo))+7);
              say padr(TOW->NAZWA_TOW,_len_naz)
  set(_SET_COLOR,_ocolor)
endi

@ _wie,_kol+_o get _zam pict _format_ilo                             //12.01.14
set curs on; read ; set curs off
SetKey(K_TAB,bsaveTab)
if lastkey()=K_ESC; BREAK; endi

if !EWIZAM_R->(dbseek(_ind))
  EWIZAM_R->(RBLOK())
  EWIZAM_R->(dbappend())
  EWIZAM_R->TYP:="P"
  EWIZAM_R->NR_KON:=_nr_kon
  EWIZAM_R->KONTO:=_konto
  EWIZAM_R->INDEKS:=_ind
  EWIZAM_R->(INDEKS_ZAML())                                          //30.11.15
endi
EWIZAM_R->(RBLOK())
EWIZAM_R->ILO_ZAM:=_zam
EWIZAM_R->(dbunlock())
END SEQUENCE 

EWIZAM_R->(dbsetorder(_or_ewi))
EWIZAM_R->(dbgoto(_re_ewi))

devpos(_wie,_kol)
dbgoto(_rek)
CPSwiezyRekord()

RETURN .F.

*******************************************************************************
FUNCTION DOD_POZ(_ali)
loca _l:=mlcount((_ali)->OPIS,75),_tekst:=(_ali)->OPIS
_tekst:=strtran(_tekst,";",",")
_tekst:=memotran(_tekst,";",";")

TOKENINIT(@_tekst,";",1)
_j:=0
do while !TOKENEND()
  _t:=TOKENNEXT(_tekst)
  _j+=1
  @ prow()+if(_j=1,0,1), 9 say _t
endd // przeczytane tokeny
RETURN "P"

*******************************************************************************
FUNCTION PTOI_L()
local _tow_rec:=TOW->(recn()),_tow_ord:=TOW->(indexord()),_ind:=INDEKS
if len(rtrim(_ind))>6

   TOW->(dbsetorder(4))
   TOW->(dbseek(val(_ind)))
   if TOW->(found()).and.TOW->KOD_PAS<>0
     repl INDEKS with TOW->INDEKS
   endi

   CPSwiezyrekord()
   TOW->(dbgoto(_tow_rec))
   TOW->(dbsetorder(_tow_ord))
endi

RETURN .T.

*******************************************************************************
FUNCTION STAN_OGL(_ind)                                              //30.11.15
loca _stan001:=0,_sel:=sele()

DEFAULT _ind to ""
if empty(_ind).and.fieldpos("INDEKS")>0
  _ind:=s_i(INDEKS)
else
  _ind:=s_i(_ind)
endi

sele MAG
dbseek(_ind)
sum STAN to _stan001 while s_i(INDEKS)=_ind
/*
@ 24,0 say ">"+_ind+"<>"+s_i(INDEKS)+"<"+;
            str(_stan001,6,2)+" "+MAG->INDEKS+" "+MAG->(indexkey())
*/

sele (_sel)
RETURN _stan001

*******************************************************************************
FUNCTION OPAK()
local _toword:=TOW->(indexord()),_towrec:=TOW->(recn()),_opak:=0,;
      _ind:=INDEKS
TOW->(dbsetorder(1))
if TOW->(dbseek(_ind))
  _opak:=TOW->OPAKOWANIE
endi
TOW->(dbgoto(_towrec))
TOW->(dbsetorder(_toword))
RETURN _opak

*******************************************************************************
FUNCTION CENA_TAB_L(_cen,_szukaj)
local  _spacgru:=if(subs(_wersja,81,1)=="G",spac(3),spac(2))
DEFAULT _cen TO 0, _szukaj TO .t.
if !subs(_wersja,16,1)$"RU"
  RETURN 0
endi
if _cen>0; RETURN _cen; endi
if UPUSTY->(dbseek(EWIZAM->NR_KON+_spacgru+EWIZAM->INDEKS)).and.UPUSTY->CENA>0
    RETURN UPUSTY->CENA
elseif UPUSTY->(dbseek("00000"+_spacgru+EWIZAM->INDEKS)).and.UPUSTY->CENA>0
    RETURN UPUSTY->CENA
endi
RETURN 0

*******************************************************************************
FUNCTION BONA_L(_cen,_szukaj,_upusty)                       // przeliczenie cen
    // dla _upusty=.t. chwilowo w EWIZAM->MARZA rabat pobrany z tabeli upustw
local c_t:=0

DEFAULT _cen    TO  0 , _szukaj TO .T.,;
        _upusty TO .F.

if _ktory_rekord>0  // po F8 na polu CENA
  TO_R->(dbgoto(_ktory_rekord))
  c_t:=if(TO_R->CENNIK="B",TO_R->CENA*100/(100+val(EWIZAM->VAT)),TO_R->CENA)
  repl EWIZAM->CENA with c_t
endif

if !subs(_wersja,16,1)="R".and.!_upusty
  if subs(_wersja,36,1)=="2"
    repl EWIZAM->CENA_SPR with ;
         EWIZAM->CENA*100/(100+_rabat)*_mnoznik
  else
    repl EWIZAM->CENA_SPR with ;
         EWIZAM->CENA*(100-_rabat)/100*_mnoznik
  endif

elseif subs(_wersja,16,1)="R"  // tu dziaa tabela upustw i rabaty pozycyjne

  _cena_tab:=CENA_TAB_L(_cen,_szukaj)

  if _cena_tab<>0
    repl EWIZAM->CENA_SPR with _cena_tab

    if subs(_wersja,36,1)=="2"  // wyliczanie od tylu pola CENA
      repl EWIZAM->CENA with EWIZAM->CENA_SPR*;
           (100+min(_rabat+EWIZAM->MARZA,100))/;
           100/_mnoznik
    else
      repl EWIZAM->CENA with EWIZAM->CENA_SPR/;
        (100-min(_rabat+EWIZAM->MARZA,100))*100/_mnoznik

    endif
  else
    if subs(_wersja,36,1)=="2"
      repl EWIZAM->CENA_SPR with EWIZAM->CENA*100/;
           (100+min(_rabat+EWIZAM->MARZA,100))*_mnoznik
    else
      repl EWIZAM->CENA_SPR with EWIZAM->CENA*;
           (100-min(_rabat+EWIZAM->MARZA,100))/100*_mnoznik
    endif
  endi

elseif _upusty   // tu dziaa tabela upustw i mare pozycyjne ale tylko raz

  _cena_tab:=CENA_TAB_L(_cen,_szukaj)

  if _cena_tab<>0
    repl EWIZAM->CENA_SPR with _cena_tab
    if subs(_wersja,36,1)=="2"           // wyliczanie od tylu pola CENA
      repl EWIZAM->CENA with EWIZAM->CENA_SPR*;
           (100+min(_rabat,100))/100/_mnoznik
    else
      repl EWIZAM->CENA with EWIZAM->CENA_SPR/;
        (100-min(_rabat,100))*100/_mnoznik
    endi
  else
    if subs(_wersja,36,1)=="2"
      repl EWIZAM->CENA with EWIZAM->CENA_CEN*100/;
           (100+EWIZAM->MARZA)*_mnoznik
      repl EWIZAM->CENA_SPR with EWIZAM->CENA*100/;
           (100+min(_rabat,100))*_mnoznik
    else
      repl EWIZAM->CENA with EWIZAM->CENA_CEN*;
           (100-EWIZAM->MARZA)/100*_mnoznik
      repl EWIZAM->CENA_SPR with EWIZAM->CENA*;
           (100-min(_rabat,100))/100*_mnoznik
    endi
  endi
  CENS_MAR_L(.f.)
endi

RETURN .T.

*******************************************************************************
FUNCTION CENS_MAR_L(_p)
local _mar:=0,_c_z:=CENA_ZAK,_c_s

if subs(_wersja,36,1)=="2"
  _c_s:=CENA*100/(100+_rabat)
else
  _c_s:=CENA*(100-_rabat)/100
endif

if subs(_wersja,16,1)="R"
  RETURN .T.                  // dla rabatw pozycyjnych nie jest liczona mara
endi
DEFAULT _p TO .t.

if !subs(_wersja,16,1)$"TU"
  RETURN .T.
endi

if _typ_mar="2"
  _mar:=if(_c_s>0,(_c_s-_c_z)/_c_s*100,0)
else
  _mar:=if(_c_z>0,(_c_s-_c_z)/_c_z*100,0)
endi
repl MARZA with iif(abs(_mar)<999,_mar,0)
if _p
  CPSwiezyRekord()
endi
RETURN .T.

*******************************************************************************
FUNCTION MAR_CENS_L()
local _cen:=0,_c_z:=CENA_ZAK,_r:=_rabat

if subs(_wersja,16,1)="R"
  BONA_L()
  RETURN .T.
endi

if !subs(_wersja,16,1)$"TU"
  RETURN .T.
endi

if _typ_mar="2"
  _cen:=if(MARZA<>100,_c_z/(1-MARZA/100),0)
else
  _cen:=MARZA*_c_z/100+_c_z
endi

repl CENA with _cen,;
     CENA_SPR with _cen

if _r<>0.and._r<>100
  repl CENA with _cen*100/(100-_r),;
       CENA_SPR with CENA*(100-_r)/100
endi

CPSwiezyRekord()
RETURN .T.

*******************************************************************************
FUNCTION WE_SL_TO_L()
local _sele :=select(),_astru:={},_in:=INDEKS,;
      _tow_or:=TOW->(indexord())                                     //16.07.12

BEGIN SEQUENCE

TOW->(dbsetorder(1))
TOW->(dbseek(s_i(_in))) 

//QKE(TOW->(indexkey())+"  "+TOW->INDEKS+subs(TOW->NAZWA_TOW,1,10))

sele select("TO_R")
use

sele 0
_astru:={}
aadd(_astru,{"CENNIK"     ,"C",1,0})
aadd(_astru,{"CENA"       ,"N",9,2})
dbcreate (_sc+"TO_R",_astru)

_use(_sc+"TO_R","E!")
appe blank
repl CENNIK with _ceny_1, CENA with TOW->CENA_1
appe blank
repl CENNIK with _ceny_2, CENA with TOW->CENA_2
appe blank
repl CENNIK with _ceny_3, CENA with TOW->CENA_3

END SEQUENCE

sele (_sele)
TOW->(dbsetorder(_tow_or))
RETURN .T.

*******************************************************************************
FUNCTION WY_SL_TO_L()

close TO_R
dele file (_sc+"TO_R.DBF")
RETURN 0

*******************************************************************************
FUNCTION INDEKS_LZA(_nr_kon)
local _toword:=TOW->(indexord()),_towrec:=TOW->(recn()),_ret:=.f.,;
      _spacgru:=spac(2),_indeks:=INDEKS

TOW->(dbsetorder(1))
if TOW->(dbseek(s_i(_indeks)))

  repl NAZWA_TOW with TOW->NAZWA_TOW,;
       OPIS_TOW  with TOW->OPIS_TOW,;
       KOD_PAS   with TOW->KOD_PAS,;
       JM        with TOW->JM,;
       VAT       with TOW->VAT,;
       CENA_ZAK  with TOW->CENA_ZAK

  _ncena:=0
/*                                                                  //23.10.19
  do case 
    case _cennik="1".or.(_cennik="2".and.TOW->CENA_2=0).or.;        //14.09.12
                        (_cennik="3".and.TOW->CENA_3=0)
      repl CENA with ;
            if(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
    case _cennik="2"
      repl CENA with ;
            iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
    case _cennik="3"
      repl CENA with ;
            iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
  endc
*/
  _ncena:=0                                                      //23.10.19
  do case 
    case _cennik="1".or.(_cennik="2".and.TOW->CENA_2=0).or.;        
                        (_cennik="3".and.TOW->CENA_3=0)
      _ncena:=if(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
    case _cennik="2"
      _ncena:=if(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
    case _cennik="3"
      _ncena:=if(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
  endc
  if !empty(CENA).and.CENA<>_ncena
    if QTN("Zmiana ceny z "+alltrim(str(CENA,9,2))+ " na "+;
                          alltrim(str(_ncena,9,2))+" ?")
      repl CENA with _ncena
    endi
  else
      repl CENA with _ncena
  endi

  repl CENA_CEN with CENA,;
       CENA_SPR with if(subs(_wersja,36,1)=="2",;
                        CENA*100/(100+_rabat),CENA*(100-_rabat)/100)
/*
  if subs(_wersja,16,1)$"TU"                              // mare na fakturach
    CENS_MAR(.f.)
  endi
  if subs(_wersja,16,1)="R"                                  // rabat pozycyjny
    repl MARZA with 0  
  endi

  _spacgru:=if(subs(_wersja,81,1)=="G",spac(3),spac(2))
  if UPUSTY->(dbseek(_nr_kon+_spacgru+_indeks));
               .and.UPUSTY->CENA>0              
     repl EWIZAM->MARZA with 0
     BONA(UPUSTY->CENA,,subs(_wersja,16,1)=="U")
  elseif UPUSTY->(dbseek("00000"+_spacgru+_indeks));
                 .and.UPUSTY->CENA>0
     repl EWIZAM->MARZA with 0
     BONA(UPUSTY->CENA,,subs(_wersja,16,1)=="U")
  elseif UPUSTY->(dbseek(_nr_kon+_spacgru+_indeks))
     repl EWIZAM->MARZA with UPUSTY->UPUST
     BONA(,,subs(_wersja,16,1)=="U")
  elseif UPUSTY->(dbseek("00000"+_spacgru+_indeks))
     repl EWIZAM->MARZA with UPUSTY->UPUST
     BONA(,.f.,subs(_wersja,16,1)=="U")
  elseif _znaki_upu>0.and.UPUSTY->(dbseek(_nr_kon+_spacgru+;
                                      subs(_indeks,1,_znaki_upu)));
                      .and.len(rtrim(UPUSTY->INDEKS))=_znaki_upu
     repl EWIZAM->MARZA with UPUSTY->UPUST
     BONA(,.f.,subs(_wersja,16,1)=="U")
  elseif _znaki_upu>0.and.UPUSTY->(dbseek("00000"+_spacgru+;
                                      subs(_indeks,1,_znaki_upu)));
                      .and.len(rtrim(UPUSTY->INDEKS))=_znaki_upu
    repl EWIZAM->MARZA with UPUSTY->UPUST
    BONA(,.f.,subs(_wersja,16,1)=="U")
  elseif UPUSTY->(dbseek(_nr_kon+TOW->GRUPA_TOW))
    repl EWIZAM->MARZA with UPUSTY->UPUST
    BONA(,.f.,subs(_wersja,16,1)=="U")
  elseif UPUSTY->(dbseek("00000"+TOW->GRUPA_TOW))
    repl EWIZAM->MARZA with UPUSTY->UPUST
    BONA(,.f.,subs(_wersja,16,1)=="U")
  endi
*/

  CpSwiezyRekord()
  _ret:=.t.
endi
TOW->(dbgoto(_towrec))
TOW->(dbsetorder(_toword))

RETURN _ret

*******************************************************************************
FUNCTION NOWY_REK()
if empty(INDEKS).and.!eof()
  RETURN .F.
endi
RETURN .T.

*******************************************************************************
FUNCTION EZAM()                       
local _tex:='۲  EDYCJA ZAMWIE  '
local _astru:={},_wybor:=0, _err:=.f.,_nowe:=.f.
local _centrala:=(val(_konto_ph)=0)                                  //16.12.13
priv _data_zam:=date(),_nazwa_kon:="", _miasto:="",_adres:="",;
     _konto:=_konto_ph,_nr_kon:=spac(5),_wartosc:=0,_cennik:=" "
priv _rabat,_termin:=0,_faktura:="F",_platnosc:="PRZELEW ",_uwagi:=spac(70),;
     _data_zam:=date(), _rok_zam:=ROK(date())
priv _nr_rec, _ktory_rekord:=0,_arch:=.f.
priv _ope_zam:=_operator, _platnik:=spac(5)
priv _mag_ph:=" ",_oplata:=" ",_kurier:=" ",_kupony:=" "
priv _czy_ed:=.f.,_lr:=-1  //na potrzeby funkcji SORT_M() (?) //16.11.15 BAFPOL

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use(_gdzie_lap+"SL_PLA","R"); BREAK; endi
set index to (_gdzie_lap+"SL_PLA")

sele 0
if !_use("MAG001","R","MAG"); BREAK; endi                     //18.11.15 BAFPOL
set index to M001_IP0


sele 0
if !_use("TOW","S"); BREAK; endi                              //16.11.15 BAFPOL
set index to TOW_IN, TOW_NA, TOW_GR, TOW_SW
set order to 2

sele 0
if !_use("SL_G_TOW","R"); BREAK; endi                                //24.02.14
set index to SL_G_TOW, SL_G_TON

sele 0
if !_use("UPUSTY","R"); BREAK; endi
set index to UPUSTY_K,UPUSTY_T
set order to 2

sele 0
if !_use(_gdzie_lap+"EWIZAM","S"); BREAK; endi                                  //11.10.13
set index to (_gdzie_lap+"EWIZ_SI"),; // SYMBOL()+TYP+INDEKS    
             (_gdzie_lap+"EWIZ_SN"),; // SYMBOL()+TYP+NAZWA_TOW 
             (_gdzie_lap+"EWIZ_KS"),; // NR_KON+SYMBOL()+TYP
             (_gdzie_lap+"EWIZ_DS"),; // dtos(DATA_ZAM)+SYMBOL()+TYP
             (_gdzie_lap+"EWIZ_TE")   // TYP+ETAP                                   //14.08.14
                                    // SYMBOL() = KONTO+ROK_ZA()+NR_ZAM
                                    // ROK_ZA() = subs(dtos(DATA_ZAM),1,4)

sele 0
if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endi
set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
             (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")


sele 0
if !_use("SL_KONT","R"); BREAK; endi                                 //24.02.14
set index to SL_KONT

_nowe:=(HorizMenu(1,0,"Zamw. :",{"NOWE","KONTYN."},1)=1)
_data_zam:=if(_nowe,date(),ctod(""))
_konto:=if(val(_konto_ph)>0,_konto_ph,"00000")// spac(5))            //11.10.13
if !_nowe                                                            //23.10.19
  _konto:=spac(5)
endi
_nr_kon:=spac(5)

@ 1,25 say "Konto : " get _konto pict "@K 99999" when (_konto_ph=spac(5).or.;
                      _konto_ph="00000").and.;                       //09.09.16
                     SLGET("SL_KONT","SL_KONT","V1",1,1,{"konto"},,.f.);
      vali SZ().and.SL("SL_KONT","SL_KONT","V1",1,1).and.SLGET() 
@ 1,41 say "Data :" get _data_zam vali if(_nowe,!empty(_data_zam),.t.);
                                            .and._data_zam<=date()
if !_nowe; APOSTROF(); endi
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

if empty(_data_zam)
  @ 1,41
  @ 1,41 say "Rok :" get _rok_zam pict "9999";
         vali _rok_zam>="2012".and.val(_rok_zam)<=year(date())
  set curs on; read; set curs off
  if lastkey()=K_ESC; BREAK; endi
else
  _rok_zam:=ROK(_data_zam)
endi

@ 2,0 say "Firma : " get _nr_kon pict "@K 99999";
      when SLGET("KON","KON","V1",1,1,;
                   {"numer","nazwa","NIP","miasto i ulica"}); 
      vali if(_nowe,.f.,.t.).and.empty(_nr_kon).or.;
            SZ().and.SL("KON","KON","V1",1,1).and.KON_OK_L(_nr_kon).and.SLGET() 
if !_nowe; APOSTROF(); endi
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

if !empty(_nr_kon)
  KON->(dbseek(_nr_kon))
  @ 2,16 say alltrim(KON->NAZWA_KON)+;
             if(empty(KON->MIASTO),"",", "+alltrim(KON->MIASTO))+;
             if(empty(KON->ADRES),"",", "+alltrim(KON->ADRES))
  _platnik:=if(KON->(fieldpos("PLATNIK")>0),KON->PLATNIK,spac(5))    //29.11.13
endi

if !_nowe
  _ile_akt:=0

  if !empty(_konto).and.!empty(_data_zam).and.!empty(_nr_kon)

    sele EWIZAM
    dbsetorder(3)
    dbseek(_nr_kon+_konto+ROK(_data_zam))
    _ile:=0
    do while NR_KON+KONTO+ROK(DATA_ZAM)==_nr_kon+_konto+ROK(_data_zam).and.;
             !eof()
      if DATA_ZAM=_data_zam.and.TYP="N"                              //11.03.15
        _ile_akt++
        _nr_zam:=NR_ZAM
      endi
      skip
    endd
    if _ile_akt=0
      if QKE("Nie ma takiego aktywnego zamwienia.")
        BREAK
      endi
    elseif _ile_akt=1
      //znane _konto, _data_zam, _nr_kon i odczytany _nr_zam
    endi
  endi

  if _ile_akt<>1

    DAJ_NZAM(_konto,_nr_kon,_data_zam,_rok_zam)           //utworzenie NZAM.DBF

    sele NZAM
    if lastrec()=0
      QKE("Brak aktywnych zamwie.")
      BREAK
    endi
    index on SYMBOL()        to (_sc+"NAG_S")   // KONTO+ROK_ZA()+NR_ZAM
    index on NR_KON+SYMBOL() to (_sc+"NAG_KS")  // NR_KON+KONTO+ROK_ZA()+NR_ZAM
    index on dtos(DATA_ZAM)+SYMBOL() to (_sc+"NAG_DS")
                                         // dtos(DATA_ZAM)+KONTO+ROK_ZA()+NR_ZAM
                                         // SYMBOL() = KONTO+ROK_ZA()+NR_ZAM
                                         // ROK_ZA() = subs(dtos(DATA_ZAM),1,4)
    set index to (_sc+"NAG_S"),(_sc+"NAG_KS"),(_sc+"NAG_DS")
  
    _nr_zam:=spac(4)
    @ 3,0 say "Zam.nr :" get _nr_zam pict "@K 9999";
          when SLGET("NZAM","NZAM","V4",1,1,{"konto","firma","data"},,.f.);
          vali SZ().and.EXIST(_konto+_rok_zam+_nr_zam,"NZAM",1).and.SLRGET()
    set curs on; read; set curs off
    if lastkey()=K_ESC; BREAK; endi
  
    NZAM->(dbsetorder(1))
    NZAM->(dbseek(_konto+_rok_zam+_nr_zam))
    _data_zam:=NZAM->DATA_ZAM
  endi
  //znane _konto, _data_zam, _nr_zam wybranego zamwienia

//!!!

  sele EWIZAM
  if! EWIZAM->(FLOCK())                                              //11.03.14
    QK("Plik zamwie blokowany przez innego uytkownika lub aplikacj.")
    BREAK
  endi                                           //17.01.14

  dbsetorder(1)
  dbseek(_konto+ROK(_data_zam)+_nr_zam+"N")

  if EWIZAM->STATUS="E"                                              //17.01.14
    EWIZAM->(dbunlock())
    QK("Zamwienie edytowane na innym stanowisku.")
    BREAK
  endi
  EWIZAM->STATUS:="E"

  _nr_kon  :=NZAM->NR_KON
  _termin  :=NZAM->TERMIN
  _platnosc:=NZAM->PLATNOSC
  _faktura :=NZAM->FAKTURA
  _uwagi   :=NZAM->UWAGI
  _cennik  :=NZAM->CENNIK
  _rabat :=NZAM->RABAT_N
  _wartosc :=NZAM->WARTOSC
  _ope_zam :=NZAM->OPE_ZAM                                           //29.11.13
  _mag_ph  :=NZAM->MAGAZYN_PH
  _kurier  :=NZAM->KURIER
  _kupony  :=NZAM->KUPONY
  _oplata  :=NZAM->OPLATA

else //_nowe ; wprowadzone _konto, _data_zam, _nr_kon

  if! EWIZAM->(FLOCK())                                              //11.03.14
    QK("Plik zamwie blokowany przez innego uytkownika lub aplikacj.")
    BREAK
  endi                                           //17.01.14
  
  _nr_zam:=NR_DOM(_konto,_data_zam)
  @ 3,0 say "Zam.nr :" get _nr_zam pict "@K 9999" when .f.
  read
  
  KON->(dbseek(_nr_kon))
  _termin  :=KON->DNI
  _platnosc:="PRZELEW "
  _faktura :="F"
  if !empty(KON->UWAGI)                                              //04.12.13
    _uwagi:=padr(KON->(ltrim(if("DOST"$UWAGI,UWAGI,"DOSTAWA: "+UWAGI))),70)
  else
    _uwagi:=spac(70)
  endi

//  _cennik  :="1"  //if(empty(KON->CENNIK),"1",KON->CENNIK)
  _cennik  :=if(empty(KON->CENNIK),"1",KON->CENNIK)                //19.03.15

  _rabat :=0
  _wartosc :=0
  _ope_zam:=_operator                                                //29.11.13
  _platnik:=if(KON->(fieldpos("PLATNIK")>0),KON->PLATNIK,spac(5))    //29.11.13
  _termin:=if(KON->(fieldpos("DNI")>0),KON->DNI,0)                   //23.06.14
endi

KON->(dbseek(_nr_kon))
_nazwa_kon:=KON->NAZWA_KON
_adres:=alltrim(KON->ADRES)
_miasto:=alltrim(KON->MIASTO)
_platnik:=if(KON->(fieldpos("PLATNIK")>0),KON->PLATNIK,spac(5))      //29.11.13

if _centrala
  _mag_ph:="N"
endi

// zbdne wywietlenie kontrolne
@ 1,25 say "Konto : "  get _konto pict "99999" when .f.
@ 1,41
@ 1,41 say "Data :"    get _data_zam when .f.

@ 2,0  say "Firma : "  get _nr_kon pict "99999" when .f.
@ 2,16 say alltrim(_nazwa_kon)+;
           if(empty(_miasto),"",", "+alltrim(_miasto))+;
           if(empty(_adres),"",", "+alltrim(_adres))
@ 3,0  say "Nr zam.:"  get _nr_zam when .f.
@ 3,16 say "Cennik :"  get _cennik pict "9" when .f.
@ 3,28 say "Termin :"  get _termin pict "@Z 99" when .f.
@ 3,41 say "Zapata :" get _platnosc pict "XXXXXXXX" when .f.
@ 3,61 say "Dokument (F/P) :" get _faktura pict "@! X" when .f.
//@ ?,? say "Rabat :" get _rabat pict "@E 99.9" when .f.
@ 4,0 say "Uwagi : " get _uwagi pict "@! "+repl("X",70) when .f.

@ 1, 71 say "Op.:" get _ope_zam pict "XXX" when .f.                  //29.11.13
@ 1, 58 say "Pat.:" get _platnik pict "99999" when .f.              //29.11.13

@ 5,0 say "Kurier ?" get _kurier pict "@! A" when .f.
@ 5,col()+2 say "Opata ?" get _oplata pict "@! A" when .f.
@ 5,col()+2 say "Kupony ?" get _kupony pict "@! A" when .f.
@ 5,col()+2 say "Magazyn PH ?" get _mag_ph pict "@! A" when .f.

read

// QK("Edycja pozycji zamwienia.")

* ------------------------- waciwa edycja nowego lub istniejcego zamwienia

sele EWIZAM
if _nowe
  ZAPIS_OPI(_konto, _data_zam, _nr_zam, _nr_kon,;   //te tworzy rekord TYP="N"
      _termin, _platnosc, _faktura, _uwagi, _cennik, _rabat, _wartosc,;
                     _mag_ph, _kurier, _oplata, _kupony,"E")         //24.02.14
endi

sele EWIZAM
dbsetorder(2)
dbseek(_konto+ROK(_data_zam)+_nr_zam+"P")
copy to (_sc+"EWIZAM_R") while _konto+ROK(_data_zam)+_nr_zam+"P"==;
                               KONTO+ROK( DATA_ZAM)+ NR_ZAM+"P"

dbseek(_konto+ROK(_data_zam)+_nr_zam)

dbeval({|| EWIZAM->STATUS:="E"},,;                                   //24.02.14
       {|| _konto+ROK(_data_zam)+_nr_zam==;         
                            KONTO+ROK( DATA_ZAM)+ NR_ZAM})

//!!!
EWIZAM->(dbunlock())                                          //17.01.14 BAFPOL

sele 0
_use(_sc+"EWIZAM_R","E!")

if _konto="00099"                                                    //23.10.19
  index on padr(OPIS,3) to (_sc+"ROB")
  copy to (_sc+"ROB")
  zap
  appe from (_sc+"ROB")
  dele file (_sc+"ROB.DBF")
  dele file (_sc+"ROB.DBT")
  dele file (_sc+"ROB.NTX")
endi

inde on INDEKS    to (_sc+"EWIR_I")
inde on NAZWA_TOW to (_sc+"EWIR_N")
set index to (_sc+"EWIR_I"),(_sc+"EWIR_N")

TOW->(dbgotop())

DO WHILE .T.

  sele EWIZAM
  _wartosc:=0  
  _platnosc:=padr(_platnosc,8)

  *----------------------------- edycja nowego lub reedycja nagwka zamwienia

  @ 3,16 say "Cennik :"  get _cennik pict "9"  vali _cennik$"1234"
  @ 3,28 say "Termin :"  get _termin pict "@Z 99"
  @ 3,41 say "Zapata :" get _platnosc pict "XXXXXXXX";
              when SLGET("SL_PLA","SL_PLAL","V1",1,1,{"patno"},,.f.);
              vali EXIST(_platnosc,"SL_PLA",1).and.SLGET() 

  @ 3,61 say "Dokument (F/P) :" get _faktura pict "@! X";
              vali _faktura$"FP".and.PARAGON() 
  //@ ?,? say "Rabat :" get _rabat pict "@E 99.9" when .f.
  @ 4,0 say "Uwagi : " get _uwagi pict "@! "+repl("X",70)

  @ 5,0 say "Kurier ?" get _kurier pict "@! A" vali _kurier$"TN"
  @ 5,col()+2 say "Opata ?" get _oplata pict "@! A" vali _oplata$"TN"
  @ 5,col()+2 say "Kupony ?" get _kupony pict "@! A" vali _kupony$"TN"
  @ 5,col()+2 say "Magazyn PH ?" get _mag_ph pict "@! A" ;
                                 when !_centrala vali _mag_ph$"TN"

  set curs on; read; SLGET(); set curs off

  * sele EWIZAM_R
  * dbeval({|| RBLOK(),BONA(),dbunlock()})
  * dbeval({|| RBLOK(),CENS_MAR(.f.),dbunlock()})
 
  @ 23,0 clea to 24,79

  sele EWIZAM_R
  dbsetorder(0)
  go top
  CPEDIT POZ: 6,,18,       ;
         DEF: "LEWIZAM"     ;
         POZWER: "V1"      ;
         POZSLAD: SLAD_ZAM_L() ;
         PION: ,,,         ;
         INDEXY: {"indeks","nazwa"} ;
         EDYCJA: .T.       ;
         DODAWANIE: .T.    ;
         CZYDODAC: NOWY_REK() ;
         KASOWANIE: .T.    ;
         KOLORUJ: KOLORY() ;
         AKCJA: AKC_ZAML()  ;
         ODTWORZ: .f.      ;
         SIEC: REKORD

 _start:=.f.
  @ 18,0 clea to 24,79

  _w_net:=0; _w_bru:=0
  _lp:=0
  _brak_ind:=0                   //23.10.19

/*                                                                   //23.10.19
  dbeval({|| if(INDEKS=" ",(RBLOK(),dbdelete(),dbunlock()),;         //23.10.12
                (_lp+=1,;
                 _w_net+=zaokr(ILO_ZAM*CENA,2),;
                 _w_bru+=zaokr(ILO_ZAM*CENA*(1+val(VAT)/100),2)))})
*/

  dbeval({|| if(ILO_ZAM=0.and.!INDEKS="00000",;
                           (RBLOK(),dbdelete(),dbunlock()),;         //23.10.12
                (_lp+=1,;
                 _w_net+=zaokr(ILO_ZAM*CENA,2),;
                 _w_bru+=zaokr(ILO_ZAM*CENA*(1+val(VAT)/100),2)))})

  _brak_ind:=0                                                       //22.10.12
  count to _brak_ind for empty(INDEKS)
  if _brak_ind>0
    QKE("UWAGA: NALEY UZUPENI INDEKSY!")
  endi

  @ 21,0  say "Warto netto zamwienia: " +transform(_w_net,_format_war)
  @ 22,0  say "Warto brutto zamwiena :" +transform(_w_bru,_format_war)
  @ 21,47 say "Liczba pozycji zamwienia : "+str(_lp,3)
  
  _wybor:=0
  do while _wybor=0
    _wybor:=HorizMenu(24,0,"",{"POPRAWA","AKCEPTACJA","SKASOWANIE"},1)
    if _wybor=3.and.!(QTN("Skasowa zamwienie ?").and.HA("BAFPOL"))
      tone(220,2)
      _wybor:=1
    endi
  endd
  @ 18,0 clea to 24,79
  if _wybor=1; loop;  endi
  if _wybor=3; zap;  endi
  exit
endd

//!!!

EWIZAM->(FBLOK())                                                    //11.03.14

ZAPIS_OPI(_konto, _data_zam, _nr_zam, _nr_kon,; 
      _termin, _platnosc, _faktura, _uwagi, _cennik, _rabat, _w_net,;
                            _mag_ph, _kurier, _oplata, _kupony, "A")           //11.03.14

if EWIZAM_R->(lastrec())=0

  sele EWIZAM
  dbsetorder(1) // SYMBOL()+TYP+INDEKS    
  dbseek(_konto+ROK(_data_zam)+_nr_zam+"N")

  ODCZYT_OPI(@_termin,@_platnosc,@_faktura,@_uwagi,@_cennik,;
                                               @_rabat,@_wartosc)
  _uwagi:="ZAMWIENIE ANULOWANE"

  ZAPIS_OPI(_konto, _data_zam, _nr_zam, _nr_kon,; 
      _termin, _platnosc, _faktura, _uwagi, _cennik, _rabat, _wartosc,;
                            _mag_ph, _kurier, _oplata, _kupony,"X")           //11.03.14

  dbseek(_konto+ROK(_data_zam)+_nr_zam+"P")

  dele while _konto+ROK(_data_zam)+_nr_zam+"P"==;
              KONTO+ROK( DATA_ZAM)+ NR_ZAM+"P"

  CPClose(EWIZAM)  

  CPClose(EWIZAM)  
  CPClose(EWIZAM_R)  
  BREAK
endi

sele EWIZAM_R
repl all TYP with "P",;
         DATA_ZAM with _data_zam
go top
do while !eof()


//if empty(INDEKS); skip; loop; endi                                 //23.10.19
  if ILO_ZAM=0; skip; loop; endi

  if !_konto="00099"                                                 //23.10.19
    EWIZAM->(dbsetorder(1))  // SYMBOL()+TYP+INDEKS    
    EWIZAM->(dbseek(_konto+ROK(_data_zam)+_nr_zam+"P"+EWIZAM_R->INDEKS))
  
    if EWIZAM->(!found())
      EWIZAM->(dbappend())
      EWIZAM->KONTO:=_konto
      EWIZAM->DATA_ZAM:=_data_zam
      EWIZAM->NR_ZAM:=_nr_zam
      EWIZAM->INDEKS    := EWIZAM_R->INDEKS
      EWIZAM->NAZWA_TOW := EWIZAM_R->NAZWA_TOW
      EWIZAM->OPIS_TOW  := EWIZAM_R->OPIS_TOW
      EWIZAM->KOD_PAS   := EWIZAM_R->KOD_PAS
      EWIZAM->JM        := EWIZAM_R->JM
      EWIZAM->VAT       := EWIZAM_R->VAT
      EWIZAM->CENA_ZAK  := EWIZAM_R->CENA_ZAK
    endi
    EWIZAM->ILO_ZAM :=EWIZAM_R->ILO_ZAM
    EWIZAM->ILO_FAK :=EWIZAM_R->ILO_ZAM                              
    
    EWIZAM->CENA_SPR:=EWIZAM_R->CENA_SPR
    EWIZAM->CENA_CEN:=EWIZAM_R->CENA_CEN
    EWIZAM->CENA    :=EWIZAM_R->CENA
    EWIZAM->OPIS    :=EWIZAM_R->OPIS
    EWIZAM->TYP     :="P"
    EWIZAM->STATUS  :="A"         //aktywny
    EWIZAM->NR_KON:=_nr_kon
 
  else

    _ilp:=subs(EWIZAM_R->OPIS,1,at(chr(13),EWIZAM_R->OPIS)-1)

    sele EWIZAM
    dbsetorder(1)  // SYMBOL()+TYP+INDEKS    
    dbseek(_konto+ROK(_data_zam)+_nr_zam+"P")

    loca for subs(EWIZAM->OPIS,1,at(chr(13),EWIZAM->OPIS)-1)==_ilp;
         while  KONTO+rok( DATA_ZAM)+ NR_ZAM+"P"==;
               _konto+ROK(_data_zam)+_nr_zam+"P".and.!eof()
  
    if EWIZAM->(!found())
      EWIZAM->(dbappend())
      EWIZAM->KONTO:=_konto
      EWIZAM->DATA_ZAM:=_data_zam
      EWIZAM->NR_ZAM:=_nr_zam
      EWIZAM->INDEKS    := EWIZAM_R->INDEKS
      EWIZAM->NAZWA_TOW := EWIZAM_R->NAZWA_TOW
      EWIZAM->OPIS_TOW  := EWIZAM_R->OPIS_TOW
      EWIZAM->KOD_PAS   := EWIZAM_R->KOD_PAS
      EWIZAM->JM        := EWIZAM_R->JM
      EWIZAM->VAT       := EWIZAM_R->VAT
      EWIZAM->CENA_ZAK  := EWIZAM_R->CENA_ZAK
    elseif empty(EWIZAM->INDEKS)
      EWIZAM->INDEKS    := EWIZAM_R->INDEKS
    endi
    EWIZAM->ILO_ZAM :=EWIZAM_R->ILO_ZAM
    EWIZAM->ILO_FAK :=EWIZAM_R->ILO_ZAM                              
    EWIZAM->CENA_SPR:=EWIZAM_R->CENA_SPR
    EWIZAM->CENA_CEN:=EWIZAM_R->CENA_CEN
    EWIZAM->CENA    :=EWIZAM_R->CENA
    EWIZAM->OPIS    :=EWIZAM_R->OPIS
    EWIZAM->TYP     :="P"
    EWIZAM->STATUS  :="A"         //aktywny
    EWIZAM->NR_KON:=_nr_kon
  endi

  sele EWIZAM_R
  skip
endd
CPClose(EWIZAM_R)

sele EWIZAM
dbsetorder(1)

dbseek(_konto+ROK(_data_zam)+_nr_zam+"P")                            //24.02.14
dele while _konto+ROK(_data_zam)+_nr_zam+"P"==KONTO+ROK( DATA_ZAM)+ NR_ZAM+"P";
     for STATUS="E"       //usunicie pozostaosci po skasowanych indeksach

dbsetorder(2)
dbseek(_konto+ROK(_data_zam)+_nr_zam+"P")
copy to (_sc+"ZAM_R") while _konto+ROK(_data_zam)+_nr_zam+"P"==;
                            KONTO+ROK( DATA_ZAM)+ NR_ZAM+"P"
close EWIZAM

sele 0
_use(_sc+"ZAM_R","E!")
repl all ILO_FAK with 0                                              //03.12.13
go top
if lastrec()>0
  CPDRUK DEF: "LEWIZAM"     ;
       WERSJA: "V2"  ;
       NAGLOWEK: NAG_ZAML(_nazwa_kon,_miasto,_adres,;
                         _platnik,_ope_zam,_nr_kon) ;                //29.11.13
       STOPKA: STO_ZAM(_uwagi,_faktura,_w_net,_termin,,;
                                  _mag_ph,_kurier,_oplata,_kupony);  //06.12.13
       DODATEK: DOD_POZ("ZAM_R") ;
       WARIANT: 6         
endi

END SEQUENCE
clos data

RETURN NIL

*******************************************************************************
FUNCTION PZAM(_co)
loca _tex1:='۲  PRZEGLDANIE ZAMWIE  ',;               //_co=1
     _tex2:='۲  ZAMIANA ZAMWIENIA NA FAKTUR  ',;       //_co=2
     _tex3:='۲  ARCHIWIZACJA ZAMWIENIA AKTYWNEGO  ',;   //_co=3
     _tex4:='۲  POBRANIE ZAMWIENIA ARCHIWALNEGO  ',;    //_co=4
     _tex5:='۲  ZMIANA FIRMY NA ZAMWIENU AKTYWNYM  '    //_co=5

loca _nazwa_kon:="", _astru:={}, _err:=.f.,_arch:=.f.,_l:=0,;
     _etap:=spac(3)                                                  //16.03.14
priv _nr_kon:=spac(5)
priv _nr_rec, _ktory_rekord:=0
priv _konto:=spac(5),_nr_kon:=spac(5),_data_zam:=date(),_nr_zam:=spac(4),;
     _termin:=0,_platnosc:=spac(8),_faktura:=" ",_uwagi:=spac(70),;
     _cennik:=" ",_rabat:=0,_wartosc:=0,_rok_zam:=ROK(date())
priv _paczki:="",_ope_mag:="",_time_mag:="",_data_mag:=ctod("")      //14.03.14
priv _stz:=trans0(_st_zam,2)
priv _kat_mag:=alltrim(_gdzie_mv)

priv _nag_poz:="",_len_ind:=0,_len_jed:=0,_len_ilo:=0,_len_uwa:=0,;  //22.06.12
     _len_nrp:=0,_len_lin:=0
priv _platnik:="XXXXX",_ope_zam:="   "                               //29.11.13
priv _mag_ph:=" ",_kurier:=" ",_oplata:=" ",_kupony:=" "             //17.12.13
priv _nr_mph:="001"                                                  //29.03.14

DEFAULT _co TO 1

cls
do case
  case _co=1; @ 0,0 say _tex1
  case _co=2; @ 0,0 say _tex2
  case _co=3; @ 0,0 say _tex3
  case _co=4; @ 0,0 say _tex4
  case _co=5; @ 0,0 say _tex5
endc

/*                                          Rok :  9999
Dane : AKTYWNE  ARCHIWALNE  Konto :  99999  Data : 99.99.99
Firma :  99999  XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX, XXXXXXXXXXXXXXXXXXXXX
Nr zam.: 99999  Cennik : 9  Termin : 99  Zaplata : XXXXXXXX  Dokument (F/P) : X
Uwagi :  XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
0123456789012345678901234567890123456789012345678901234567890123456789012345678
          1         2         3         4         5         6         7
*/

BEGIN SEQUENCE

if _co=2.or._co=3.or._co=5                                           //20.07.12
  _arch:=.f.
  @ 1,0 say "Dane : AKTYWNE"
elseif _co=4
  _arch:=.t.
  @ 1,0 say "Dane : ARCHIW."
elseif _co=1
  _arch:=(HorizMenu(1,0,"Dane :",{"AKTYWNE","ARCHIW."},1)=2)
else
  BREAK
endi

sele 0
if !_use("TOW","S"); BREAK; endi
set index to TOW_IN, TOW_NA, TOW_GR, TOW_SW


sele 0
if !_use("MAG001","R","MAG"); BREAK; endi                            //30.11.15
set index to M001_IP0

sele 0
if !_use("SL_G_TOW","S"); BREAK; endi
set index to SL_G_TOW, SL_G_TON

sele 0
if !_use("UPUSTY","R"); BREAK; endi
set index to UPUSTY_K,UPUSTY_T
set order to 2

if !_arch

  sele 0
  if !_use(_gdzie_lap+"EWIZAM","S"); BREAK; endi
  set index to (_gdzie_lap+"EWIZ_SI"),; // SYMBOL()+TYP+INDEKS    
               (_gdzie_lap+"EWIZ_SN"),; // SYMBOL()+TYP+NAZWA_TOW 
               (_gdzie_lap+"EWIZ_KS"),; // NR_KON+SYMBOL()+TYP
               (_gdzie_lap+"EWIZ_DS"),; // dtos(DATA_ZAM)+SYMBOL()+TYP
               (_gdzie_lap+"EWIZ_TE")   // TYP+ETAP                                 //14.08.14
                         // SYMBOL()=KONTO+ROK_ZA()+NR_ZAM
else

  sele 0
  if !_use(_gdzie_lap+"EWIARC","S","EWIZAM"); BREAK; endi
  set index to (_gdzie_lap+"EWIA_SI"),; // SYMBOL()+TYP+INDEKS    
               (_gdzie_lap+"EWIA_SN"),; // SYMBOL()+TYP+NAZWA_TOW 
               (_gdzie_lap+"EWIA_KS"),; // NR_KON+SYMBOL()
               (_gdzie_lap+"EWIA_DS"),; // dtos(DATA_ZAM)+SYMBOL()
               (_gdzie_lap+"EWIA_TE")   // TYP+ETAP                                 //14.08.14
endi

sele 0
if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endi
set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
             (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")

sele 0
if !_use("SL_KONT","S"); BREAK; endi
set index to SL_KONT

//_data_zam:=if(val(_konto_ph)=0.or._arch,ctod(""),date())
_data_zam:=ctod("")                                                  //15.10.12
_konto:=if(val(_konto_ph)>0,_konto_ph,"     ")                       //15.10.12
_nr_kon:=spac(5)

@ 1,25 say "Konto : " get _konto pict "@K 99999";                    //15.10.12
       when SLGET("SL_KONT","SL_KONT","V1",1,1,{"konto"},,.f.);
       vali (empty(_konto).or.SZ().and.SL("SL_KONT","SL_KONT","V1",1,1));
            .and.SLGET() 
APOSTROF()

/*                                                                   //14.08.14
@ 1,41 say "Data :" get _data_zam vali _data_zam<=date()
APOSTROF()
*/
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi


if empty(_data_zam)
  @ 1,41
  @ 1,41 say "Rok :" get _rok_zam pict "9999";
         vali _rok_zam>="2012".and.val(_rok_zam)<=year(date())
  set curs on; read; set curs off
  if lastkey()=K_ESC; BREAK; endi
else
  _rok_zam:=ROK(_data_zam)
endi

@ 2,0 say "Firma : " get _nr_kon pict "@K 99999";
      when SLGET("KON","KON","V1",1,1,;
                   {"numer","nazwa","NIP","miasto i ulica"},,.f.); 
      valid empty(_nr_kon).or.;
            SZ().and.SL("KON","KON","V1",1,1).and.KON_OK_L(_nr_kon).and.SLGET() 
APOSTROF()
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

if !empty(_nr_kon)
  KON->(dbseek(_nr_kon))
  @ 2,16 say alltrim(KON->NAZWA_KON)+;
             if(empty(KON->MIASTO),"",", "+alltrim(KON->MIASTO))+;
             if(empty(KON->ADRES),"",", "+alltrim(KON->ADRES))
  _platnik:=if(KON->(fieldpos("PLATNIK")>0),KON->PLATNIK,spac(5))    //29.11.13
endi

SL_KONT->(dbseek(_konto))                                            //29.03.14
_nr_mph:=if(!empty(SL_KONT->NR_MAG),SL_KONT->NR_MAG,"001")


sele EWIZAM
dbsetorder(5)
dbseek("N")

if empty(_konto)
  if empty(_nr_kon)
    copy to (_sc+"NZAM_R") while TYP="N" for ROK_ZA()=_rok_zam
  else
    copy to (_sc+"NZAM_R") while TYP="N" for ROK_ZA()=_rok_zam.and.;
                                             NR_KON=_nr_kon
  endi
else
  if empty(_nr_kon)
    copy to (_sc+"NZAM_R") while TYP="N" for ROK_ZA()=_rok_zam.and.;
                                             KONTO=_konto
  else
    copy to (_sc+"NZAM_R") while TYP="N" for ROK_ZA()=_rok_zam.and.;
                                             NR_KON=_nr_kon.and.;
                                             KONTO=_konto
  endi
endi

sele 0                                                               //14.08.14
_use(_sc+"NZAM_R","E!")
index on KONTO+ROK_ZA()+NR_ZAM to (_sc+"NZAM_RS")
index on DATA_ZAM               to (_sc+"NZAM_RD")
index on NR_KON                 to (_sc+"NZAM_RK")
set index to (_sc+"NZAM_RS"),(_sc+"NZAM_RD"),(_sc+"NZAM_RK")


/*                                                                   //14.08.14
DAJ_NZAM(_konto,_nr_kon,_data_zam,_rok_zam)                   //tworzy NZAM.DBF

sele NZAM
if lastrec()=0
  QKE("Brak zamwie")
  BREAK
endi
EWIZAM->(dbsetorder(1))                                              //18.03.14
set rela to SYMBOL()+"N" into EWIZAM                             
index on SYMBOL()         to (_sc+"NAG_S")     // KONTO+ROK_ZA()+NR_ZAM
index on NR_KON+SYMBOL()  to (_sc+"NAG_KS")    // NR_KON+KONTO+ROK_ZA()+NR_ZAM
index on dtos(DATA_ZAM)+SYMBOL() to (_sc+"NAG_DS")
                                      // dtos(DATA_ZAM)+KONTO+ROK_ZA()+NR_ZAM
                                      // SYMBOL() = KONTO+ROK_ZA()+NR_ZAM
                                      // ROK_ZA() = subs(dtos(DATA_ZAM),1,4)
index on EWIZAM->ETAP+NR_KON  to (_sc+"NAG_EK") //for !empty(ETAP)   //18.03.14
set index to (_sc+"NAG_S"),(_sc+"NAG_KS"),(_sc+"NAG_DS"),(_sc+"NAG_EK")
*/

DO WHILE .T.  //dla _co=1                                            //20.05.14

_nr_zam:=spac(4)
//if _co=2; NZAM->(dbsetorder(4)); endi                              //14.08.14

@ 3,0 clea to 24,79                                                  //20.05.14

sele 0                                                               //20.05.14
if file(_gdzie_lap+"ZAM_N.DBF").and._use(_gdzie_lap+"ZAM_N","R")
  set index to (_gdzie_lap+"ZAM_N_S")  //KONTO+subs(dtos(DATA_ZAM),1,4)+NR_ZAM
  
  sele NZAM_R                                                        //14.08.14 
  set rela to KONTO+subs(dtos(DATA_ZAM),1,4)+NR_ZAM into ZAM_N additive
endi

sele NZAM_R                                                          //14.08.14
set rela to NR_KON into KON                                          //14.08.14

@ 3,0 say "Nr zam.:" get _nr_zam pict "@K 9999";
       when SLRGET("NZAM_R","NZAM","V9",1,;                          //20.05.14
                      {"konto","firma","data","etap"},,.f.);          //14.08.14
       vali lastkey()=K_UP.or.SZ().and.DAJ_KONTO(@_konto).and.;
            EXIST(_konto+_rok_zam+_nr_zam,"NZAM_R",1).and.SLRGET()
/*                                                                   //14.08.14
       when SLRGET("NZAM_R","NZAM","V9",1,;                          
                      {"konto","firma","data","etap"},"UWAGI()",.f.);
*/


set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

CPClose(NZAM)                                                        //14.08.14
DAJ_NZAM2(_konto,_rok_zam,_nr_zam)                                   //14.08.14
EWIZAM->(dbsetorder(1))                                           

sele NZAM
if !(_nr_zam=NR_ZAM.and._konto=KONTO.and.ROK_ZA()=_rok_zam)
   QKE("Brak zamwienia"); BREAK
endi
set rela to SYMBOL()+"N" into EWIZAM                             
dbskip(0)
CPClose(ZAM_N)

_konto   :=NZAM->KONTO
_data_zam:=NZAM->DATA_ZAM
_nr_kon  :=NZAM->NR_KON
_termin  :=NZAM->TERMIN
_platnosc:=NZAM->PLATNOSC
_faktura :=NZAM->FAKTURA
_uwagi   :=NZAM->UWAGI
_cennik  :=NZAM->CENNIK
_rabat   :=NZAM->RABAT_N
_wartosc :=NZAM->WARTOSC
_ope_zam :=NZAM->OPE_ZAM                                             //29.11.13
_kurier  :=NZAM->KURIER                                              //17.12.13
_kupony  :=NZAM->KUPONY                                              //17.12.13
_mag_ph  :=NZAM->MAGAZYN_PH
_oplata  :=NZAM->OPLATA
_paczki  :=if(NZAM->(fieldpos("PACZKI"))>0,NZAM->PACZKI,spac(40))    //16.09.18
_ope_mag :=NZAM->OPE_MAG                                             //13.03.13
_data_mag:=NZAM->DATA_MAG
_time_mag:=NZAM->TIME_MAG
_etap    :=if(NZAM->(fieldpos("ETAP")>0),NZAM->ETAP,spac(3))         //16.03.14

if _co=2.and.!_etap="G"                                              //16.04.14
  if !(QTN("Zamiana na faktur zamwienia nieoznaczonego jako gotowe ?");
                                                      .and.HA("BAFPOL"))
    tone(220,2)
    QK("Nie zamieniono zamwienia na faktur !")
    BREAK
  endi
endi

if !(_mag_ph="T".or._etap="PH")                                      //30.02.14
  _nr_mph:="001"
endi

if _co<>1                                                            //20.05.14
  CPClose(NZAM)
endi

KON->(dbseek(_nr_kon))
_nazwa_kon:=KON->NAZWA_KON
_adres:=alltrim(KON->ADRES)
_miasto:=alltrim(KON->MIASTO)
_platnik:=if(KON->(fieldpos("PLATNIK")>0),KON->PLATNIK,spac(5))      //29.11.13

@ 1,25 say "Konto : "  get _konto pict "99999" when .f.
@ 1,41
@ 1,41 say "Data :"    get _data_zam when .f.
@ 2,0  say "Firma : "  get _nr_kon pict "99999" when .f.
@ 2,16 say alltrim(_nazwa_kon)+;
           if(empty(_miasto),"",", "+alltrim(_miasto))+;
           if(empty(_adres),"",", "+alltrim(_adres))
@ 3,0  say "Nr zam.:"  get _nr_zam when .f.
@ 3,16 say "Cennik :"  get _cennik pict "9" when .f.
@ 3,28 say "Termin :"  get _termin pict "@Z 99" when .f.
@ 3,41 say "Zapata :" get _platnosc pict "XXXXXXXX" when .f.
@ 3,61 say "Dokument (F/P) :" get _faktura pict "@! X" when .f.
//@ ?,? say "Rabat :" get _rabat pict "@E 99.9" when .f.
@ 4,0 say "Uwagi : " get _uwagi pict "@! "+repl("X",70) when .f.

@ 5,0 say "Kurier ?" get _kurier pict "@! A" when .f.
@ 5,col()+2 say "Opata ?" get _oplata pict "@! A" when .f.
@ 5,col()+2 say "Kupony ?" get _kupony pict "@! A" when .f.
@ 5,col()+2 say "Magazyn PH ?" get _mag_ph pict "@! A" when .f.


@ 1, 71 say "Op.:" get _ope_zam pict "XXX" when .f.                  //29.11.13
@ 1, 58 say "Pat.:" get _platnik pict "99999" when .f.              //29.11.13

read

sele EWIZAM
dbsetorder(2)
dbseek(_konto+ROK(_data_zam)+_nr_zam+"P")
copy to (_sc+"ZAM_R") while _konto+ROK(_data_zam)+_nr_zam+"P"==;
                             KONTO+ROK( DATA_ZAM)+ NR_ZAM+"P"
if _co<>1                                                            //20.05.14
  close EWIZAM    
endi

sele 0
_use(_sc+"ZAM_R","E!","EWIPOZ")

if _konto="00099"                                                    //23.10.19
  index on padr(OPIS,3) to (_sc+"ROB")
  copy to (_sc+"ROB")
  zap
  appe from (_sc+"ROB")
//  dele file (_sc+"ROB.DBF")
  dele file (_sc+"ROB.DBT")
  dele file (_sc+"ROB.NTX")
endi

set filt to TYP<>"N"
index on NAZWA_TOW to (_sc+"ZAM_R")

_w_net:=0; _w_bru:=0; _lp:=0
/*                                                                   //23.10.19
dbeval({|| if(TYP="P".and.INDEKS=" ",(RBLOK(),dbdelete(),dbunlock()),;
           (_lp+=1,;
            _w_net+=zaokr(ILO_ZAM*CENA_SPR,2),;
            _w_bru+=zaokr(ILO_ZAM*CENA_SPR*(1+val(VAT)/100),2)))})
*/
dbeval({|| if(TYP="P".and.!INDEKS="00000".and.ILO_ZAM=0,;
                                     (RBLOK(),dbdelete(),dbunlock()),;
           (_lp+=1,;
            _w_net+=zaokr(ILO_ZAM*CENA_SPR,2),;
            _w_bru+=zaokr(ILO_ZAM*CENA_SPR*(1+val(VAT)/100),2)))})

_brak_ind:=0                                                       //22.10.12
count to _brak_ind for empty(INDEKS)
if _brak_ind>0.and._co<>5
  QKE("UWAGA: NALEY UZUPENI INDEKSY!")
endi

sele EWIPOZ
go top
CPEDIT POZ: 6,,18,         ;
         DEF: "LEWIZAM"    ;
         POZWER: "V1"      ;
         POZSLAD: SLAD_ZAM_L() ;
         PION: ,,,         ;
         INDEXY: {"nazwa"} ;
         AKCJA: AKC_ZAM3L() ;                                        //16.04.14
         ODTWORZ: .f.

@ 18,0 clea to 24,79

@ 19,0  say "Warto netto zamwienia: " +transform(_w_net,_format_war)
@ 20,0  say "Warto brutto zamwiena :" +transform(_w_bru,_format_war)
@ 19,47 say "Liczba pozycji zamwienia : "+str(_lp,3)

if _co=1.and.lastrec()>0

  _len_nrp:=3
  _len_ind:=max(len(s_i(INDEKS)),6)
  _len_naz:=_len_naz
  _len_opi:=_len_opi
  _len_jed:=4
  _len_ilo:=len(transform(0,_format_ilo))
  _len_uwa:=8

  _len_lin:=_len_nrp+2+_len_ind+2+_len_naz+2+_len_opi+2+;
            _len_jed+2+_len_ilo+2+_len_uwa

  _nag_poz:=padr("Lp",_len_nrp+1)+;
            padr("Indeks",_len_ind+1)+;
            padr("Nazwa towaru",_len_naz+2)+;
            padr("Opis",_len_opi+2)+;
            padr("Jm",_len_jed+6)+;
            padr("Ilo",_len_ilo+2)+;
            padr("Uwagi",_len_uwa)

  sele 0
  _astru:={}
  dele file (_sc+"LINIE.DBF")
  aadd(_astru,{"LINIA"     ,"C",_len_lin,0})
  dbcreate (_sc+"LINIE",_astru)
  _use(_sc+"LINIE","E!")

  sele EWIPOZ
  _nrl:=0
  loca for s_i(INDEKS)=="00000"                                      //08.01.16
  if found()
    _nrl+=1
    LINIE->(dbappend())
    LINIE->LINIA:=str(_nrl,3)+" "+;
                  s_i(INDEKS)+"  "+;
                  padr(NAZWA_TOW,_len_naz+1)+"  "+;
                  padr(OPIS_TOW,_len_opi)+"  "+;
                  padr(JM,4)+" "+;
                  transform(ILO_ZAM,_format_ilo)+"  "+;
                  spac(8)
    APP_POZ()
    LINIE->(dbappend())
  endi

  set filt to !s_i(INDEKS)=="00000"                                  //08.01.16
  go top
  do while !eof()
   _nrl+=1
    LINIE->(dbappend())
    LINIE->LINIA:=str(_nrl,3)+" "+;
                  s_i(INDEKS)+"  "+;
                  padr(NAZWA_TOW,_len_naz)+"  "+;
                  padr(OPIS_TOW,_len_opi)+"  "+;
                  padr(JM,4)+" "+;
                  transform(ILO_ZAM,_format_ilo)+"  "+;
                  spac(8)
    APP_POZ()
    LINIE->(dbappend())
 
    skip
  endd

  sele LINIE
  go top         
  CPDRUK DEF: "LIN_POZ"  ;
       WERSJA: "V1"  ; 
       NAGLOWEK: NAG_ZAML(_nazwa_kon,_miasto,_adres,;
                         _platnik,_ope_zam,_nr_kon) ;                //29.11.13
       STOPKA: STO_ZAM(_uwagi,_faktura,_w_net,_termin,_arch,;
                                 _mag_ph,_kurier,_oplata,_kupony);   //06.12.13
       WARIANT: 7
         
  CPClose(LINIE)

  sele EWIPOZ
endi

if _co<>1                                                            //20.05.14
  exit
else
  CPClose(EWIPOZ)
  CPClose(LINIE)
  dele file (_sc+"ZAM_R.DBF")
  dele file (_sc+"ZAM_R.DBT")
  dele file (_sc+"ZAM_R.NTX")
  dele file (_sc+"LINIE.DBF")
  keyboard chr(K_ENTER)
endi

ENDD                                                                 //20.05.14

CPClose(NZAM)
CPClose(TOW)
@ 24,0

if _brak_ind>0.and._co=2                                             //23.10.19
 BREAK
endi

if _co=2.and.HorizMenu(24,0,"Zamiana zamwienia "+;
      if(_arch,"archiwalnego","aktywnego")+" na faktur :",{"TAK","NIE"},1)=1;
      .and.HA(_haslo)

  //zamwienie otwarte w _sc+"ZAM_R" alias "EWIPOZ", otwarty KON
  //znane : _konto,_data_zam,_termin,_platnosc,_faktura,_uwagi, _cennik,  
  //        _rabat,_wartosc,_nazwa_kon,_adres,_miasto,
  //        _ope_zam                                                //29.11.13

  CPClose(KON)
  _stz:=trans0(val(_st_zam),2)                                      //20.07.12
  @ 24,53 say "Stanowisko zapisu :" get _stz pict "@K 99";
          vali SZ().and.!" "$_stz.and.file(_kat_mag+"#"+_stz+"\PARADRUK.DBF")
  set curs on; read; set curs off
  if lastkey()=K_ESC; BREAK; endi

  _ok_w:=WCZYTAJ_MV(_nr_zam,_nr_kon,_konto,_data_zam,_termin,;
     _platnosc,_faktura,_cennik,_rabat,_uwagi,_arch,_stz,_ope_zam,_platnik,;
     _mag_ph,_kurier,_oplata,_kupony,_paczki,_ope_mag,_data_mag,_time_mag,;
     _etap,_nr_mph)                                                  //29.03.14

  if !_ok_w                                                          //14.03.14
    BREAK
  endi
  CPClose(EWIZAM)

  if !_arch  //archiwizacja

    BEGIN SEQUENCE
    
    _aok:=.t.                                                        //14.03.14

    sele 0
    if !_use(_gdzie_lap+"EWIZAM","F"); _aok:=.f.; BREAK; endi
    set index to (_gdzie_lap+"EWIZ_SI"),; // SYMBOL()+TYP+INDEKS    
                 (_gdzie_lap+"EWIZ_SN"),; // SYMBOL()+TYP+NAZWA_TOW 
                 (_gdzie_lap+"EWIZ_KS"),; // NR_KON+SYMBOL()+TYP
                 (_gdzie_lap+"EWIZ_DS"),; // dtos(DATA_ZAM)+SYMBOL()+TYP
                 (_gdzie_lap+"EWIZ_TE")   // TYP+ETAP                               //14.08.14

    sele 0
    if !_use(_gdzie_lap+"EWIARC","F"); _aok:=.f.;  BREAK; endi
    set index to (_gdzie_lap+"EWIA_SI"),; // SYMBOL()+TYP+INDEKS    
                 (_gdzie_lap+"EWIA_SN"),; // SYMBOL()+TYP+NAZWA_TOW 
                 (_gdzie_lap+"EWIA_KS"),; // NR_KON+SYMBOL()
                 (_gdzie_lap+"EWIA_DS"),; // dtos(DATA_ZAM)+SYMBOL()
                 (_gdzie_lap+"EWIA_TE")   // TYP+ETAP                               //14.08.14

    END SEQUENCE
   
    if !_aok                                                         //14.03.14
      close data
      QKE("Zbir archiwalny zamwie jest chwilowo niedostpny.",;
          " Wykonaj samodzielnie archiwizacj tego zamwienia. ")
      BREAK
    endi

    dbsetorder(1)
    dbseek(_konto+ROK(_data_zam)+_nr_zam)
    dele while _konto+ROK(_data_zam)+_nr_zam==;
                KONTO+ROK( DATA_ZAM)+ NR_ZAM
 
    sele EWIZAM
    dbsetorder(2)
    dbseek(_konto+ROK(_data_zam)+_nr_zam)
    copy to (_sc+"ZAM_A") while _konto+ROK(_data_zam)+_nr_zam==;
                                 KONTO+ROK( DATA_ZAM)+ NR_ZAM
     
    sele EWIARC
    appe from (_sc+"ZAM_A")
  
    sele EWIZAM
    dbseek(_konto+ROK(_data_zam)+_nr_zam)
    dele while _konto+ROK(_data_zam)+_nr_zam==;
                KONTO+ROK( DATA_ZAM)+ NR_ZAM

    close data
    tone(880,2)
    QKE('Wykonano archiwizacj zamwienia.')
  endi
endi

if _co=3.and.HorizMenu(24,0,"Archiwizacja zamwienia aktywnego :",;
                             {"TAK","NIE"},1)=1 .and.HA(_haslo)

  sele 0
  if !_use(_gdzie_lap+"EWIZAM","F"); BREAK; endi
  set index to (_gdzie_lap+"EWIZ_SI"),; // SYMBOL()+TYP+INDEKS    
               (_gdzie_lap+"EWIZ_SN"),; // SYMBOL()+TYP+NAZWA_TOW 
               (_gdzie_lap+"EWIZ_KS"),; // NR_KON+SYMBOL()+TYP
               (_gdzie_lap+"EWIZ_DS"),; // dtos(DATA_ZAM)+SYMBOL()+TYP
               (_gdzie_lap+"EWIZ_TE")   // TYP+ETAP                                 //14.08.14

  sele 0
  if !_use(_gdzie_lap+"EWIARC","F"); BREAK; endi
  set index to (_gdzie_lap+"EWIA_SI"),; // SYMBOL()+TYP+INDEKS    
               (_gdzie_lap+"EWIA_SN"),; // SYMBOL()+TYP+NAZWA_TOW 
               (_gdzie_lap+"EWIA_KS"),; // NR_KON+SYMBOL()
               (_gdzie_lap+"EWIA_DS"),; // dtos(DATA_ZAM)+SYMBOL()
               (_gdzie_lap+"EWIA_TE")   // TYP+ETAP                                 //14.08.14

  dbsetorder(1)
  dbseek(_konto+ROK(_data_zam)+_nr_zam)
  dele while _konto+ROK(_data_zam)+_nr_zam==;
                KONTO+ROK( DATA_ZAM)+ NR_ZAM
 
  sele EWIZAM
  dbsetorder(2)
  dbseek(_konto+ROK(_data_zam)+_nr_zam)
  copy to (_sc+"ZAM_A") while _konto+ROK(_data_zam)+_nr_zam==;
                               KONTO+ROK( DATA_ZAM)+ NR_ZAM
     
  sele EWIARC
  appe from (_sc+"ZAM_A")
  
  sele EWIZAM
  dbseek(_konto+ROK(_data_zam)+_nr_zam)
  dele while _konto+ROK(_data_zam)+_nr_zam==;
              KONTO+ROK( DATA_ZAM)+ NR_ZAM

  close data
  tone(880,2)
  QKE('Wykonano archiwizacj zamwienia aktywnego.')
endi

if _co=4.and.HorizMenu(24,0,"Utworzenie zamwienia aktywnego z archiwalnego :",;
                             {"TAK","NIE"},1)=1 .and.HA(_haslo)

  sele 0
  if !_use(_gdzie_lap+"EWIZAM","F"); BREAK; endi
  set index to (_gdzie_lap+"EWIZ_SI"),; // SYMBOL()+TYP+INDEKS    
               (_gdzie_lap+"EWIZ_SN"),; // SYMBOL()+TYP+NAZWA_TOW 
               (_gdzie_lap+"EWIZ_KS"),; // NR_KON+SYMBOL()+TYP
               (_gdzie_lap+"EWIZ_DS"),; // dtos(DATA_ZAM)+SYMBOL()+TYP
               (_gdzie_lap+"EWIZ_TE")   // TYP+ETAP                  //14.08.14
                                        // SYMBOL()==KONTO+ROK_ZA()+NR_ZAM

  dbsetorder(2)                                                      //26.06.17
  dbseek(_konto+ROK(_data_zam)+_nr_zam)
  if found()
    tone(220,1)
    QK("Procedur przerwano. Wskazane zamwienie jest aktywne.") 
    BREAK
  endi

  sele 0
  if !_use(_gdzie_lap+"EWIARC","F"); BREAK; endi
  set index to (_gdzie_lap+"EWIA_SI"),; // SYMBOL()+TYP+INDEKS    
               (_gdzie_lap+"EWIA_SN"),; // SYMBOL()+TYP+NAZWA_TOW 
               (_gdzie_lap+"EWIA_KS"),; // NR_KON+SYMBOL()
               (_gdzie_lap+"EWIA_DS"),; // dtos(DATA_ZAM)+SYMBOL()
               (_gdzie_lap+"EWIA_TE")   // TYP+ETAP                  //14.08.14

  dbsetorder(2)
  dbseek(_konto+ROK(_data_zam)+_nr_zam)
  copy to (_sc+"ZAM_A") while _konto+ROK(_data_zam)+_nr_zam==;
                               KONTO+ROK( DATA_ZAM)+ NR_ZAM

  dbsetorder(2)                                                      //26.06.17
  dbseek(_konto+ROK(_data_zam)+_nr_zam)
  dele all while _konto+ROK(_data_zam)+_nr_zam==;
                               KONTO+ROK( DATA_ZAM)+ NR_ZAM

/*                                                                   //26.06.17
  _data_zam:=date()
  _nr_zam:=NR_DOM(_konto,_data_zam)
*/

  sele 0
  _use(_sc+"ZAM_A","E")
  repl all ETAP with  "   "                                          //26.06.17
//         DATA_ZAM with _data_zam,;
//         NR_ZAM   with _nr_zam

//repl all ILO_FAK with max(ILO_FAK,ILO_ZAM)                         //20.05.14
  use

  sele EWIZAM
  appe from (_sc+"ZAM_A")
  
  close data
  tone(880,2)
  QKE("Pobrano z archiwum zamwienie "+_nr_zam+"/"+_konto+"/"+ROK(_data_zam))
endi

@ 22,0 clea to 24,70
if _co=5.and.HorizMenu(22,0,"Zmiana numeru firmy zamwienia aktywnego :",;
                             {"TAK","NIE"},1)=1 .and.HA(_haslo)
  @ 23,0 say "Nowa firma :" get _nr_kon pict "@K 99999";
      when SLGET("KON","KON","V1",1,1,;
                   {"numer","nazwa","NIP","miasto i ulica"}); 
      vali SZ().and.SL("KON","KON","V1",1,1).and.KON_OK_L(_nr_kon).and.SLGET() 
  set curs on; read; set curs off
  if lastkey()=K_ESC; BREAK; endi

  KON->(dbseek(_nr_kon))
  @ 23,20 say alltrim(KON->NAZWA_KON)+;
             if(empty(KON->MIASTO),"",", "+alltrim(KON->MIASTO))+;
             if(empty(KON->ADRES),"",", "+alltrim(KON->ADRES))

  if !HorizMenu(24,0,"Kontynuacja ?",{"TAK","NIE"},2)=1; BREAK; endi

  sele 0
  if !_use(_gdzie_lap+"EWIZAM","F"); BREAK; endi
  set index to (_gdzie_lap+"EWIZ_SI"),; // SYMBOL()+TYP+INDEKS    
               (_gdzie_lap+"EWIZ_SN"),; // SYMBOL()+TYP+NAZWA_TOW 
               (_gdzie_lap+"EWIZ_KS"),; // NR_KON+SYMBOL()+TYP
               (_gdzie_lap+"EWIZ_DS"),; // dtos(DATA_ZAM)+SYMBOL()+TYP
               (_gdzie_lap+"EWIZ_TE")   // TYP+ETAP                                 //14.08.14

  dbsetorder(1)
  dbseek(_konto+ROK(_data_zam)+_nr_zam+"N")                                  //23.10.19
  repl NR_KON with _nr_kon while _konto+ROK(_data_zam)+_nr_zam+"N"==;
                                  KONTO+ROK( DATA_ZAM)+ NR_ZAM+TYP
  dbseek(_konto+ROK(_data_zam)+_nr_zam+"P")
  repl NR_KON with _nr_kon while _konto+ROK(_data_zam)+_nr_zam+"P"==;
                                  KONTO+ROK( DATA_ZAM)+ NR_ZAM+TYP


  tone(880,2)
  close data

  QKE("Zmieniono dane na zamwieniu "+_nr_zam+"/"+_konto+"/"+ROK(_data_zam))
endi

END SEQUENCE
clos data
dele file (_sc+"ZAM_A.DBF")
//dele file (_sc+"ZAM_R.DBF")
dele file (_sc+"ZAM_A.DBT")
//dele file (_sc+"ZAM_R.DBT")
dele file (_sc+"ZAM_R.NTX")
*dele file (_sc+"NZAM.DBF")
dele file (_sc+"NAG_DS.NTX")
dele file (_sc+"NAG_KS.NTX")
dele file (_sc+"NAG_S.NTX")
dele file (_sc+"SFA_N_R.DBF")
dele file (_sc+"SFA_P_R.DBF")
dele file (_sc+"SPA_N_R.DBF")
dele file (_sc+"SPA_P_R.DBF")
dele file (_sc+"FAK_TXT.DBF")

RETURN NIL

*******************************************************************************
FUNCTION DAJ_NZAM(_konto,_nr_kon,_data_zam,_rok_zam)          //tworzy NZAM.DBF
loca _astru:={}, _sel:=select(), _ord:=indexord(), _rek:=recn()

_astru:={}
aadd(_astru,{"DATA_ZAM  ","D", 8,0})
aadd(_astru,{"KONTO     ","C", 5,0})
aadd(_astru,{"NR_ZAM    ","C", 4,0})
aadd(_astru,{"NR_KON    ","C", 5,0})
aadd(_astru,{"NAZWA_KON ","C",40,0})
aadd(_astru,{"MIASTO    ","C",20,0})
aadd(_astru,{"ADRES     ","C",30,0})
aadd(_astru,{"TERMIN    ","N", 3,0})
aadd(_astru,{"PLATNOSC  ","C",10,0})
aadd(_astru,{"FAKTURA   ","C", 1,0})
aadd(_astru,{"UWAGI     ","C",70,0})
aadd(_astru,{"CENNIK    ","C", 1,0})
aadd(_astru,{"RABAT_N   ","N", 9,2})
aadd(_astru,{"WARTOSC   ","N",12,2})
aadd(_astru,{"OPE_ZAM   ","C", 3,0})                               
aadd(_astru,{"ETAP      ","C", 3,0})                               
aadd(_astru,{"MAGAZYN_PH","C", 1,0})                                 //16.12.13
aadd(_astru,{"KURIER    ","C", 1,0})                               
aadd(_astru,{"OPLATA    ","C", 1,0})                               
aadd(_astru,{"KUPONY    ","C", 1,0})                               
aadd(_astru,{"PACZKI    ","C",40,0})                                 //16.09.18
aadd(_astru,{"OPE_MAG   ","C", 3,0})                                 //14.03.14
aadd(_astru,{"DATA_MAG  ","D", 8,0})                         
aadd(_astru,{"TIME_MAG  ","C",12,0})                         
aadd(_astru,{"CW        ","C", 1,0})                                 //29.08.15
dbcreate(_sc+"NZAM",_astru)

sele 0
_use(_sc+"NZAM","E!")

sele EWIZAM

do case
  case !empty(_data_zam)
    dbsetorder(4)
    
    dbseek(dtos(_data_zam))
    do while dtos(DATA_ZAM)==dtos(_data_zam).and.!eof()
      if TYP="P"; skip; loop; endi
      if !empty(_konto).and.KONTO<>_konto; skip; loop; endi
      if !empty(_nr_kon).and.NR_KON<>_nr_kon; skip; loop; endi
      EWI_TO_NZAM()

      sele EWIZAM
      skip
    endd

  case empty(_data_zam).and.!empty(_konto)
    dbsetorder(1); dbseek(_konto)
    do while KONTO==_konto.and.!eof()
      if TYP="P"; skip; loop; endi
      if year(DATA_ZAM)<>val(_rok_zam); skip; loop; endi             //16.01.13
      if !empty(_nr_kon).and.NR_KON<>_nr_kon; skip; loop; endi
      EWI_TO_NZAM()

      sele EWIZAM
      skip
    endd

  case empty(_data_zam).and.!empty(_nr_kon)
    dbsetorder(3); dbseek(_nr_kon)
    do while NR_KON==_nr_kon.and.!eof()
      if TYP="P"; skip; loop; endi
      if year(DATA_ZAM)<>val(_rok_zam); skip; loop; endi             //16.01.13
      if !empty(_konto).and.KONTO<>_konto; skip; loop; endi
      EWI_TO_NZAM()

      sele EWIZAM
      skip
    endd

  othe
    dbsetorder(4); go top
    do while !eof()
      if TYP="P"; skip; loop; endi
      if year(DATA_ZAM)<>val(_rok_zam); skip; loop; endi             //16.01.13
      EWI_TO_NZAM()

      sele EWIZAM
      skip
    endd

endc

sele (_sel)
dbsetorder(_ord)
dbgoto(_rek)

RETURN NIL

*******************************************************************************
FUNCTION DAJ_NZAM2(_konto,_rok_zam,_nr_zam)    //tworzy NZAM.DBF (jeden rekord)
loca _astru:={}, _sel:=select(), _ord:=indexord(), _rek:=recn()

_astru:={}
aadd(_astru,{"DATA_ZAM  ","D", 8,0})
aadd(_astru,{"KONTO     ","C", 5,0})
aadd(_astru,{"NR_ZAM    ","C", 4,0})
aadd(_astru,{"NR_KON    ","C", 5,0})
aadd(_astru,{"NAZWA_KON ","C",40,0})
aadd(_astru,{"MIASTO    ","C",20,0})
aadd(_astru,{"ADRES     ","C",30,0})
aadd(_astru,{"TERMIN    ","N", 3,0})
aadd(_astru,{"PLATNOSC  ","C",10,0})
aadd(_astru,{"FAKTURA   ","C", 1,0})
aadd(_astru,{"UWAGI     ","C",70,0})
aadd(_astru,{"CENNIK    ","C", 1,0})
aadd(_astru,{"RABAT_N   ","N", 9,2})
aadd(_astru,{"WARTOSC   ","N",12,2})
aadd(_astru,{"OPE_ZAM   ","C", 3,0})                               
aadd(_astru,{"ETAP      ","C", 3,0})                               
aadd(_astru,{"MAGAZYN_PH","C", 1,0})                                 //16.12.13
aadd(_astru,{"KURIER    ","C", 1,0})                               
aadd(_astru,{"OPLATA    ","C", 1,0})                               
aadd(_astru,{"KUPONY    ","C", 1,0})                               
aadd(_astru,{"PACZKI    ","C",40,0})                                 //16.09.18
aadd(_astru,{"OPE_MAG   ","C", 3,0})                                 //14.03.14
aadd(_astru,{"DATA_MAG  ","D", 8,0})                         
aadd(_astru,{"TIME_MAG  ","C",12,0})                         
aadd(_astru,{"CW        ","C", 1,0})                                 //29.08.15
dbcreate(_sc+"NZAM",_astru)

sele 0
_use(_sc+"NZAM","E!")

sele EWIZAM
dbsetorder(1)
dbseek(_konto+_rok_zam+_nr_zam+"N")

EWI_TO_NZAM()

sele (_sel)
dbsetorder(_ord)
dbgoto(_rek)

RETURN NIL

*******************************************************************************
FUNCTION AKC_ZAML()
loca _ocolor:=setcolor(),_sel:=select(),_astru:={},getlist:={}
priv _o_rek:=0

if lastkey()<>K_F8.and.lastkey()<>K_SPACE
   RETURN NIL
endi

BEGIN SEQUENCE

if lastkey()=K_F8                                                    //30.11.15

  set colo to _slow_blo

  sele TOW
  keyboard chr(K_CTRL_HOME)+repl(chr(K_RIGHT),4)

  CPEDIT  POZ: 3,,23,      ;
          DEF: "TOWL"      ;                                         //30.11.15
          POZWER: "V2"      ;
          POZSLAD: " "+transform(INDEKS,_format_ind)+"  "+;
                   subs(NAZWA_TOW,1,30)+"  "+subs(OPIS_TOW,1,25)+;
                   INV()    ;                                        //12.01.14
          KOLOR: _slow_blo  ;
          PION: ,,,         ;
          INDEXY: {"indeks","nazwa","grupa","kod paskowy"} ;
          EDYCJA: .T.       ;
          AKCJA: DAJ_ORE(.t.) ;
          KOLORUJ: KOLORY() ;
          ZACHOWAJ: 2       ;
          SIEC: REKORD      ;                                 //16.11.15 BAFPOL
          ODTWORZ:.T.

  if _o_rek>0
    dbgoto(_o_rek)
  endi

  keyboard chr(K_CTRL_HOME)+chr(K_CTRL_PGUP)+chr(K_CTRL_PGDN)


elseif lastkey()=K_SPACE.and.rlock().and.!empty(INDEKS)

  tone(880,0.5)
  @ 23,4 say " Ctrl W - zapis "
  @ 23,58 say " Esc - rezygnacja "
  set curs on
  repl OPIS with MEMOEDIT(OPIS,19,2,22,77,.t.)
  set curs off
  @ 23,4 say repl(chr(205),74)
  @ 23,4 say " Spacja - edycja "
  tone(440,0.5)
  dbunlock()

endi
  
END SEQUENCE

sele (_sel)
setcolor(_ocolor)

RETURN NIL

*******************************************************************************
FUNCTION AKC_ZAM2L(_edycja)                                          //16.03.14
loca _ocolor:=setcolor(),_sel:=select(),_astru:={},getlist:={}
priv _o_rek:=0

DEFAULT _edycja TO .F.

if lastkey()<>K_SPACE; RETURN NIL; endi

BEGIN SEQUENCE

SET(_SET_COLOR,_ekra_blo)
@ 24,0
SET(_SET_COLOR,_edit_blo)

if lastkey()=K_SPACE.and.!empty(INDEKS).and.if(_edycja,rlock(),.t.)

  tone(880,1)

  if _edycja
    @ 23,4 say  " Ctrl W - zapis "+repl(chr(205),14)
    @ 23,58 say " Esc - rezygnacja "
  else
    @ 23,4 say repl(chr(205),72)
    @ 23,58 say " Esc - koniec "
  endi

  _l:=mlcount(OPIS,75)
  @ 23,73 say repl(chr(205),3)
  if _edycja
    repl OPIS with MEMOEDIT(OPIS,19,2,22,77,_edycja)
  else
    MEMOEDIT(OPIS,19,2,22,77,_edycja)
  endi

  @ 23,4 say repl(chr(205),74)                                       //16.04.14
  if _edycja
    @ 23,4 say " Spacja - edycja "
  else
    @ 23,4 say " Spacja - odczyt "
  endi

  tone(440,0.5)
  dbunlock()
endi
  
END SEQUENCE

sele (_sel)
setcolor(_ocolor)

RETURN NIL

*******************************************************************************
FUNCTION AKC_ZAM3L()                                                 //16.04.14
loca _ocolor:=setcolor(),_sel:=select(),getlist:={}

if lastkey()<>K_SPACE
   RETURN NIL
endi

BEGIN SEQUENCE

if lastkey()=K_SPACE.and.!empty(INDEKS)

  tone(880,0.5)
  @ 23,4 say repl(chr(205),30)
  @ 23,58 say " Esc - koniec"

  set curs on
  repl OPIS with MEMOEDIT(OPIS,19,2,22,77,.f.)
  set curs off
  @ 23,4 say repl(chr(205),74)
  @ 23,4 say " Spacja - odczyt "
  tone(440,0.5)
endi
  
END SEQUENCE

sele (_sel)
setcolor(_ocolor)

RETURN NIL

*******************************************************************************
FUNCTION WCZYTAJ_MV(_nr_zam,_nr_kon,_konto,_data_zam,_termin,_platnosc,;
     _faktura,_cennik,_rabat,_uwagi,_arch,_stz,_ope_zam,_platnik,;
     _mag_ph,_kurier,_oplata,_kupony,_paczki,;                //03.03.14
     _ope_mag,_data_mag,_time_mag,_etap,_nr_mph)                     //29.03.14
                                                       //z EWIPOZ posortowanego
loca _sel:=select(),_err:=.t.,_rm,_ro,_rs,_cz,_dd
loca _wart_n__:=0,_wart_n_0:=0,_wart_n_1:=0,_wart_n_2:=0,_wart_n_3:=0,;
                  _wart_n_4:=0,_wart_n_5:=0,_wart_n_6:=0,_wart_n_7:=0,;
     _wart_v_1:=0,_wart_v_2:=0,_wart_v_3:=0,;           
     _wart_v_4:=0,_wart_v_5:=0,_wart_v_6:=0,_wart_v_7:=0,;
     _wart_n_spr:=0,_wart_v_spr:=0,;
     _wart_zak:=0,_wart_b:=0,_wart_k:=0
loca _st:="#01"                                                      //20.07.12
loca _zmiana:=.f.                                                    //29.11.13

priv _mv:=alltrim(_gdzie_mv)
priv _kat_dan:=alltrim(_gdzie_dan)
priv _kat_mag:=alltrim(_gdzie_mv)
priv _kat_kon:=alltrim(_gdzie_fir)

priv _seria_fak:="01",_seria_par:="09"                               //09.11.15


BEGIN SEQUENCE

DEFAULT _stz     TO "01",;
        _platnik TO spac(5),;                                        //29.11.13
        _paczki  TO spac(12)                                         //03.03.14

_zmiana:=(!empty(_platnik).and.!_platnik==_nr_kon)                   //29.11.13

_rok_dok:=str(year(_data_zam),4)
_data_dok:=_data_zam
_rodz_dok:=if(_faktura$"TF","FA","PA")

sele select("EWIZAM")
if !_use(_gdzie_lap+"EWIZAM","S"); BREAK; endi
set index to (_gdzie_lap+"EWIZ_SI"),; // SYMBOL()+TYP+INDEKS    
             (_gdzie_lap+"EWIZ_SN"),; // SYMBOL()+TYP+NAZWA_TOW 
             (_gdzie_lap+"EWIZ_KS"),; // NR_KON+SYMBOL()+TYP
             (_gdzie_lap+"EWIZ_DS"),; // dtos(DATA_ZAM)+SYMBOL()+TYP
             (_gdzie_lap+"EWIZ_TE")   // TYP+ETAP                                   //14.08.14

_firany:=""                                                          //14.09.14
if fieldpos("FIRANY")>0
  dbseek(_konto+ROK(_data_zam)+_nr_zam+"N")
  _firany:=FIRANY
endi

sele select("KON")
if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endi
set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
             (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")

sele 0
if !_use("TOW","R"); BREAK; endi
set index to TOW_IN,TOW_NA,TOW_GR,TOW_SW

sele select("UPUSTY")                   
if !_use("UPUSTY","R"); BREAK; endi
set index to UPUSTY_K,;  //NR_KON
             UPUSTY_T    //NR_KON+GRUPA_TOW+INDEKS+DOSTAWCA
set order to 2

sele select("MAG")                                                   //30.11.15
if !_use("MAG"+_nr_mph,"S","MAG"); BREAK; endi                       //26.04.13
set rela to s_i(INDEKS) into TOW
set inde to ("M"+_nr_mph+"_IP"), ("M"+_nr_mph+"_N"),;
            ("M"+_nr_mph+"_IP0"),("M"+_nr_mph+"_N0")

sele 0
if !_use("QSPR_N","R"); BREAK; endi
copy stru to (_sc+"S"+_rodz_dok+"_N_R")
use

sele 0
if !_use("QSPR_P","R"); BREAK; endi
copy stru to (_sc+"S"+_rodz_dok+"_P_R")
use

sele 0
if !_use(_sc+"S"+_rodz_dok+"_N_R","E","SPR_N_R"); BREAK; endi

sele 0
if !_use(_sc+"S"+_rodz_dok+"_P_R","E","SPR_P_R"); BREAK; endi

sele 0
if !_use("FAK_TXT","R"); BREAK; endi
copy stru to (_sc+"FAK_TXT")
use                                                                  //29.11.13

sele 0                                                               //29.11.13
if !_use(_sc+"FAK_TXT","E"); BREAK; endi

_rm:=0
_wart_n__:=0; _wart_n_0:=0; _wart_n_1:=0; _wart_n_2:=0; _wart_n_3:=0
_wart_n_4:=0; _wart_n_5:=0; _wart_n_6:=0; _wart_n_7:=0   

_wart_v_1:=0; _wart_v_2:=0; _wart_v_3:=0
_wart_v_4:=0; _wart_v_5:=0; _wart_v_6:=0; _wart_v_7:=0
_wart_n_spr:=0; _wart_v_spr:=0
_wart_zak:=0; _wart_b:=0; _wart_k:=0
 
sele EWIPOZ   //tylko rekordy pozycji
go top
do  while !eof()
  _rs:=0

  _ile:=EWIPOZ->ILO_ZAM                                              //03.12.13
  if (EWIPOZ->(fieldpos("ETAP")>0).and.EWIPOZ->ETAP="G  ");
                                   .or.EWIPOZ->STATUS="A"            //20.05.14
   _ile:=EWIPOZ->ILO_FAK                                             //03.12.13
  endi

  if EWIPOZ->INDEKS="00000"                                          //08.01.16
    _ile:=0
  endi

  KON->(dbseek(if(_zmiana,_platnik,_nr_kon)))                        //29.11.13
  _rabat:=KON->RABAT_KON

  
  sele MAG
  dbseek(s_i(EWIPOZ->INDEKS))
  if found(); _rm:=MAG->(recn()); endi

  if _ile=0.and.MAG->(found())                                       //18.12.13
    SPR_P_R->(dbappend())
    SPR_P_R->INDEKS:=EWIPOZ->INDEKS
    SPR_P_R->CENA_ZAK:=MAG->CENA_ZAK
    SPR_P_R->DATA_DOS:=MAG->DATA_DOS
    SPR_P_R->ILOSC:=0
    SPR_P_R->ZNAK:=-1
/*                                                                   //11.03.15
    SPR_P_R->CENA_SPR:=EWIPOZ->CENA_SPR          
    SPR_P_R->BONIFIKATA:=EWIPOZ->CENA_SPR*100/(100-_rabat)
    SPR_P_R->MARZA:=EWIPOZ->RABAT
    SPR_P_R->CENA_CEN_S:=EWIPOZ->CENA_CEN
*/

    SPR_P_R->NR_KON:=EWIPOZ->NR_KON     
    SPR_P_R->GRUPA_TOW:=TOW->GRUPA_TOW
    SPR_P_R->NAZWA_TOW:=TOW->NAZWA_TOW
    SPR_P_R->OPIS_TOW:=TOW->OPIS_TOW
    SPR_P_R->JM:=TOW->JM
    SPR_P_R->VAT:=TOW->VAT
    SPR_P_R->RODZAJ_DOK:=_rodz_dok //"FA"                            //22.06.12
    SPR_P_R->SERIA_FAK:=if(_faktura$"FT",_seria_fak,_seria_par)      //16.12.13
    SPR_P_R->NR_MAG:=_nr_mph                                         //26.04.13
    SPR_P_R->ROK_DOK:=_rok_dok
    SPR_P_R->NR_DOK:="B"
    SPR_P_R->DATA_DOK:=_data_dok
  endi

  sele MAG  
  do while _ile>0.and.s_i(EWIPOZ->INDEKS)==s_i(MAG->INDEKS).and.!eof()
    _cz:=CENA_ZAK
    _dd:=DATA_DOS
    _rm:=MAG->(recn())

    if STAN<=0; skip; loop; endi
    _ro:=if(_ile>STAN,STAN,_ile)

    if subs(_wersja,77,1)="B"
      MAG->(RBLOK())
      repl MAG->STAN_B with MAG->STAN_B+_ro
      MAG->(dbunlock())
    endi

*   EWIPOZ->ILO_BLO+=_ro

    SPR_P_R->(dbappend())
    _rs:=SPR_P_R->(recn())
    SPR_P_R->INDEKS:=EWIPOZ->INDEKS
    SPR_P_R->CENA_ZAK:=CENA_ZAK
    SPR_P_R->DATA_DOS:=DATA_DOS
    SPR_P_R->ILOSC:=_ro
    SPR_P_R->ZNAK:=-1

/*                                                                   //11.03.15
    SPR_P_R->CENA_SPR:=EWIPOZ->CENA_SPR
    SPR_P_R->BONIFIKATA:=EWIPOZ->CENA_SPR*100/(100-_rabat)
    SPR_P_R->MARZA:=EWIPOZ->RABAT
    SPR_P_R->CENA_CEN_S:=EWIPOZ->CENA_CEN
*/

    SPR_P_R->NR_KON:=EWIPOZ->NR_KON     
    SPR_P_R->GRUPA_TOW:=TOW->GRUPA_TOW
    SPR_P_R->NAZWA_TOW:=TOW->NAZWA_TOW
    SPR_P_R->OPIS_TOW:=TOW->OPIS_TOW
    SPR_P_R->JM:=TOW->JM
    SPR_P_R->VAT:=TOW->VAT
    SPR_P_R->RODZAJ_DOK:=_rodz_dok //"FA"                            //22.06.12
    SPR_P_R->SERIA_FAK:=if(_faktura$"FT",_seria_fak,_seria_par)      //16.12.13
    SPR_P_R->NR_MAG:=_nr_mph                                         //26.04.13
    SPR_P_R->ROK_DOK:=_rok_dok
    SPR_P_R->NR_DOK:="B"
    SPR_P_R->DATA_DOK:=_data_dok
    _ile:=_ile-_ro

    sele MAG
    skip
  endd

  if _ile>0                                           // odnotowanie brakw
    QKE("Fakturowana ilo towarw mniejsza od przygotowanej.",;
        "             Zweryfikuj pozycje faktury !           ") 
    EWIPOZ->BRAK:=_ile
  endi

// _rm - rekord z indeksem w magazynie   
// _rs - rekord z indeksem w pozycjach zapisu

  if _rm>0.and._ile>0.and._rs>0

    MAG->(dbgoto(_rm))
    if subs(_wersja,77,1)="B"
      repl MAG->STAN_B with MAG->STAN_B+_ile
    endi
*   EWIPOZ->ILO_BLO+=_ile
    EWIPOZ->BRAK:=_ile
    SPR_P_R->(dbgoto(_rs))
    SPR_P_R->ILOSC+=_ile

  elseif _rm>0.and._ile>0.and._rs=0

    MAG->(dbgoto(_rm))
    if subs(_wersja,77,1)="B"
      MAG->(RBLOK())
      repl MAG->STAN_B with MAG->STAN_B+_ile
      MAG->(dbunlock())
    endi
*   EWIPOZ->ILO_BLO+=_ile
    EWIPOZ->BRAK:=_ile
  
    SPR_P_R->(dbappend())
    SPR_P_R->INDEKS:=EWIPOZ->INDEKS
    SPR_P_R->CENA_ZAK:=_cz
    SPR_P_R->DATA_DOS:=_dd
    SPR_P_R->ILOSC:=_ile
    SPR_P_R->ZNAK:=-1

/*                                                                   //11.03.15
    SPR_P_R->CENA_SPR:=EWIPOZ->CENA_SPR
    SPR_P_R->BONIFIKATA:=EWIPOZ->CENA_SPR*100/(100-_rabat)
    SPR_P_R->MARZA:=EWIPOZ->RABAT
    SPR_P_R->CENA_CEN_S:=EWIPOZ->CENA_CEN
*/
    SPR_P_R->NR_KON:=EWIPOZ->NR_KON     
    SPR_P_R->GRUPA_TOW:=TOW->GRUPA_TOW
    SPR_P_R->NAZWA_TOW:=TOW->NAZWA_TOW
    SPR_P_R->OPIS_TOW:=TOW->OPIS_TOW
    SPR_P_R->JM:=TOW->JM
    SPR_P_R->VAT:=TOW->VAT
  
    SPR_P_R->RODZAJ_DOK:=_rodz_dok //"FA"                            //22.06.12

    SPR_P_R->SERIA_FAK:=_seria_fak
    SPR_P_R->NR_MAG:=_nr_mph                                         //26.04.13
    SPR_P_R->ROK_DOK:=_rok_dok
    SPR_P_R->NR_DOK:="B"
    SPR_P_R->DATA_DOK:=_data_dok
  endi

  sele EWIPOZ
  skip
endd

KON->(dbseek(if(_zmiana,_platnik,_nr_kon)))                          //29.11.13

_cenniki:="1234"                                                      //11.03.15
_nr_cen_spr:=_cennik_spr
if KON->(fieldpos("CENNIK"))>0.and.KON->CENNIK$_cenniki
  _nr_cen_spr:=KON->CENNIK
elseif "#"$KON->UWAGI.and.;
       subs(KON->UWAGI,at("#",KON->UWAGI)+1,1)$_cenniki
  _nr_cen_spr:=subs(KON->UWAGI,at("#",KON->UWAGI)+1,1)
endi

*------------------------------------------------------------------- //11.03.15
sele SPR_P_R
_nr_pro:=spac(5)                                               
_sel_tow:=select("TOW")                                        
go top
do while !eof()
  TOW->(dbseek(SPR_P_R->(s_i(INDEKS))))

  _pom_cs1:= Eval(memvarblock("_ceny_"+_nr_cen_spr))           //"B" lub "N"
  _pom_cs2:= Eval(fieldwblock("CENA_"+_nr_cen_spr,_sel_tow))   // cena z TOW

  if _pom_cs2=0                                            //27.03.14 BAFPOL
    _pom_cs1:=_ceny_1
    _pom_cs2:=TOW->CENA_1
  endi 

  repl SPR_P_R->CENA_CEN_S with;
    if(_pom_cs1="N",_pom_cs2,_pom_cs2/(1+val(SPR_P_R->VAT)/100))
  repl SPR_P_R->CENA_BRU with;
    if(_pom_cs1="B",_pom_cs2,_pom_cs2*(1+val(SPR_P_R->VAT)/100))
  repl  SPR_P_R->CENA_DET  with if(subs(_wersja,36,1)=="2",;
            SPR_P_R->CENA_BRU*100/(100+SPR_N_R->(RABAT+PREMIA))*_mnoznik,;
            SPR_P_R->CENA_BRU*(100-SPR_N_R->(RABAT+PREMIA))/100*_mnoznik)
  repl SPR_P_R->BONIFIKATA with SPR_P_R->CENA_CEN_S,;
       SPR_P_R->CENA_SPR   with if(subs(_wersja,36,1)=="2",;
           SPR_P_R->CENA_CEN_S*100/(100+SPR_N_R->(RABAT+PREMIA))*_mnoznik,;
           SPR_P_R->CENA_CEN_S*(100-SPR_N_R->(RABAT+PREMIA))/100*_mnoznik)
  if subs(_wersja,16,1)="R"                                  // rabat pozycyjny
    repl SPR_P_R->MARZA with 0
  endi

  UPU_FAK()

  sele SPR_P_R
  skip
endd
*------------------------------------------------------------------------------

sum zaokr(ILOSC*CENA_ZAK,2),;
    if(VAT="zw", zaokr(ILOSC*CENA_SPR,2),0),;
    if(VAT=" 0", zaokr(ILOSC*CENA_SPR,2),0),;
    if(VAT=_vat1,zaokr(ILOSC*CENA_SPR,2),0),;
    if(VAT=_vat2,zaokr(ILOSC*CENA_SPR,2),0),;
    if(VAT=_vat3,zaokr(ILOSC*CENA_SPR,2),0),;
    if(VAT=_vat4,zaokr(ILOSC*CENA_SPR,2),0),;
    if(VAT=_vat5,zaokr(ILOSC*CENA_SPR,2),0),;
    if(VAT=_vat6,zaokr(ILOSC*CENA_SPR,2),0),;
    if(VAT=_vat7,zaokr(ILOSC*CENA_SPR,2),0),;
    zaokr((BONIFIKATA-CENA_SPR)*ILOSC,2),;
    if(CENA_CEN_S=0,zaokr((BONIFIKATA-CENA_SPR)*ILOSC,2),;
                    zaokr((CENA_CEN_S-CENA_SPR)*ILOSC,2)) ;
  to _wart_zak,_wart_n__,_wart_n_0,_wart_n_1,_wart_n_2,_wart_n_3,;
                         _wart_n_4,_wart_n_5,_wart_n_6,_wart_n_7,;
     _wart_b,_wart_k

if "."$_format_ilo
  _wart_zak:=zaokr(_wart_zak,2)
  _wart_n__:=zaokr(_wart_n__,2)
  _wart_n_0:=zaokr(_wart_n_0,2)
  _wart_n_1:=zaokr(_wart_n_1,2)
  _wart_n_2:=zaokr(_wart_n_2,2)
  _wart_n_3:=zaokr(_wart_n_3,2)
  _wart_n_4:=zaokr(_wart_n_4,2)
  _wart_n_5:=zaokr(_wart_n_5,2)
  _wart_n_6:=zaokr(_wart_n_6,2)
  _wart_n_7:=zaokr(_wart_n_7,2)
endi
_wart_v_1:=zaokr(_wart_n_1*val(_vat1)/100,2)
_wart_v_2:=zaokr(_wart_n_2*val(_vat2)/100,2)
_wart_v_3:=zaokr(_wart_n_3*val(_vat3)/100,2)
_wart_v_4:=zaokr(_wart_n_4*val(_vat4)/100,2)
_wart_v_5:=zaokr(_wart_n_5*val(_vat5)/100,2)
_wart_v_6:=zaokr(_wart_n_6*val(_vat6)/100,2)
_wart_v_7:=zaokr(_wart_n_7*val(_vat7)/100,2)
_wart_n_spr:=_wart_n__+_wart_n_0+_wart_n_1+_wart_n_2+_wart_n_3+;
             _wart_n_4+_wart_n_5+_wart_n_6+_wart_n_7
_wart_v_spr:=_wart_v_1+_wart_v_2+_wart_v_3+;
             _wart_v_4+_wart_v_5+_wart_v_6+_wart_v_7
  
sele SPR_N_R
appe blan
repl RODZAJ_DOK with _rodz_dok,; //"FA"                              //22.06.12
     SERIA_FAK  with _seria_fak,;
     NR_MAG     with _nr_mph,;                                       //26.04.13
     ROK_DOK    with _rok_dok,;
     NR_DOK     with "Z",;
     EXPORT     with "K",;
     KONTO      with _konto,;                                        //29.11.13
     NR_KON     with if(_zmiana,_platnik,_nr_kon),;                  //29.11.13
     DATA_DOK   with _data_dok,;
     WART_ZAK   with _wart_zak,;
     CENNIK_S   with _nr_cen_spr,; //_cennik_spr
     AUTO       with "G",;
     NAZWA_KON  with KON->NAZWA_KON,;
     ID_KON     with KON->ID_KON,;
     ADRES      with KON->ADRES,;
     MIASTO     with KON->MIASTO,;
     RABAT      with _rabat,;
     OPERATOR   with if(_konto="00000",_ope_zam,"P"+PH(_konto))      //29.11.13

if fieldpos("FIRANY")>0                                              //14.09.14
  repl FIRANY with _firany
//  QKE(subs(FIRANY,1,60))
endi

if fieldpos("ETAP")>0                                                //16.03.14
  repl ETAP with _etap
endi

if fieldpos("PACZKI")>0  
  repl PACZKI with _paczki                                      
endi
if fieldpos("OPE_MAG")>0                                             //14.03.14
  repl OPE_MAG with _ope_mag
endi
if fieldpos("DATA_MAG")>0  
  repl DATA_MAG with _data_mag
endi
if fieldpos("TIME_MAG")>0  
  repl TIME_MAG with _time_mag                                      
endi
if fieldpos("NR_ZAM")>0  
  repl NR_ZAM with _nr_zam                                      
endi
if fieldpos("REALIZACJA")>0                                          //19.03.14
  repl REALIZACJA with rtrim(_ope_mag+"/"+_paczki)
endi

repl TERMIN with _termin, DATA_PLA with _data_dok+_termin,;          //24.07.14
     SPOSOB_PLA with _platnosc

if _zmiana                                                           //29.11.13
    KON->(dbseek(_nr_kon))

    repl UWAGI with if(_konto="00000",_ope_zam,"P"+PH(_konto))+"/"+;
         _nr_kon+" "+if(!empty(KON->MIASTO),alltrim(KON->MIASTO),"")+;
                    if(!empty(KON->ADRES) ,", "+alltrim(KON->ADRES),"")
else
  repl UWAGI with _uwagi                                             //29.03.14
endi

repl SPR_N_R->WART_ZAK   with _wart_zak,;  
     SPR_N_R->WART_NET_  with _wart_n__, SPR_N_R->WART_NET0 with _wart_n_0,;
     SPR_N_R->WART_NET1  with _wart_n_1, SPR_N_R->WART_VAT1 with _wart_v_1,;
     SPR_N_R->WART_NET2  with _wart_n_2, SPR_N_R->WART_VAT1 with _wart_v_2,;
     SPR_N_R->WART_NET3  with _wart_n_3, SPR_N_R->WART_VAT1 with _wart_v_3,;
     SPR_N_R->WART_NET4  with _wart_n_4, SPR_N_R->WART_VAT1 with _wart_v_4,;
     SPR_N_R->BONIFIKATA with _wart_b,   SPR_N_R->RABAT_NET with _wart_k,; 
     SPR_N_R->WART_ZAP   with _wart_n_spr+_wart_v_spr
/*
     SPR_N_R->WART_NET5  with _wart_n_5, SPR_N_R->WART_VAT1 with _wart_v_5,;
     SPR_N_R->WART_NET6  with _wart_n_6, SPR_N_R->WART_VAT1 with _wart_v_6,;
     SPR_N_R->WART_NET7  with _wart_n_7, SPR_N_R->WART_VAT1 with _wart_v_7,;
*/

if _zmiana                                                           //29.11.13
  DO_FAK_TXT(_nr_kon)
endi

close SPR_N_R
close SPR_P_R
close FAK_TXT

_st:="#"+_stz                                                     //20.07.12
*----------------------------------------------------------------------------
if !subs(_wersja,77,1)$"Bb"
  _zapisal:=.f.
  for i:=0 to 99        
    _nr:=trans0(i,2)
    if !file(_mv+_st+"\"+"S"+_rodz_dok+"_NR"+_nr+".DBF").and.;
       !file(_mv+_st+"\"+"S"+_rodz_dok+"_PR"+_nr+".DBF")
      _zapisal:=.t. 

      copy file (_sc+"S"+_rodz_dok+"_N_R.DBF");
                         to (_mv+_st+"\"+"S"+_rodz_dok+"_NR"+_nr+".DBF")

      if file (_sc+"S"+_rodz_dok+"_N_R.DBT")                         //14.09.14
        copy file (_sc+"S"+_rodz_dok+"_N_R.DBT");
                           to (_mv+_st+"\"+"S"+_rodz_dok+"_NR"+_nr+".DBT")
      endi

      copy file (_sc+"S"+_rodz_dok+"_P_R.DBF");
                         to (_mv+_st+"\"+"S"+_rodz_dok+"_PR"+_nr+".DBF")
      copy file (_sc+"FAK_TXT.DBF");
                         to (_mv+_st+"\"+"FAK_TX"+_nr+".DBF")
      exit
    endi
  next
  if !_zapisal
    QKE(" Nie dokonano zapisu  faktury. ",;
        "Wyczerpany limit zapisw (100).")
  endi     
else
  _zapisal:=.f.
  for i:=0 to 999           
    _nr:=trans0(i,3)
    if !file(_mv+"#00\flaga"+_nr).and.;
       !file(_mv+"#00\"+"S"+_rodz_dok+"_N"+_nr+".DBF").and.;
       !file(_mv+"#00\"+"S"+_rodz_dok+"_P"+_nr+".DBF")

      _flaga:=fcreate(_mv+"#00\flaga"+_nr) 
      fclose(_flaga)
      _zapisal:=.t. 

      copy file (_sc+"S"+_rodz_dok+"_N_R.DBF");
                            to (_mv+"#00\"+"S"+_rodz_dok+"_N"+_nr+".DBF")

      if file(_sc+"S"+_rodz_dok+"_N_R.DBT")                          //14.09.14
        copy file (_sc+"S"+_rodz_dok+"_N_R.DBT");
                              to (_mv+"#00\"+"S"+_rodz_dok+"_N"+_nr+".DBT")
      endi

      copy file (_sc+"S"+_rodz_dok+"_P_R.DBF");
                            to (_mv+"#00\"+"S"+_rodz_dok+"_P"+_nr+".DBF")
      if file(_sc+"FAK_TXT.DBF") 
        copy file (_sc+"FAK_TXT.DBF");
                            to (_mv+"#00\"+"FAK_T"+_nr+".DBF")
      endi

      dele file (_sc+"S"+_rodz_dok+"_N_R.DBF") 
      dele file (_sc+"S"+_rodz_dok+"_P_R.DBF") 
      dele file (_sc+"FAK_TXT.DBF") 
      dele file (_mv+"#00\flaga"+_nr) 
      exit
    endi
  next
  if !_zapisal
    QKE(" Nie dokonano zapisu  faktury. ",;
        "Wyczerpany limit zapisw (1000).")
  endi 
endi

CPClose(SPR_N_R)
CPClose(SPR_P_R)
CPClose(FAK_TXT)

@ 24,0

if !_zapisal
  BREAK
endi

sele EWIZAM
dbsetorder(1)
dbseek(_konto+ROK(_data_zam)+_nr_zam+"N")
RBLOK()
repl ETAP with "A"
dbrunlock()

_err:=.f.
  
END SEQUENCE
close data                                                    

if !_err
  tone(880,2)
  QK('Przetworzono zamwienie na "zapis" faktury .')
else
  tone(220,2)
  QKE("Nie przetworzono danych z zamwienia !")
endi


RETURN !_err                                                         //14.03.14

*******************************************************************************
FUNCTION ZAPIS_OPI(_konto, _data_zam, _nr_zam, _nr_kon,;
                   _termin, _platnosc, _faktura, _uwagi, _cennik, _rabat,;
                   _wartosc,_mag_ph,_kurier,_oplata,_kupony,_status)         //24.02.14
loca _sel:=select()

DEFAULT _wartosc TO 0,;
        _status  TO "A"                                             //24.02.14

//QK("Zapis naglwka ")

sele EWIZAM
dbsetorder(1) // SYMBOL()+TYP+INDEKS => KONTO+ROK(DATA_ZAM)+NR_ZAM+TYP+INDEKS  
dbseek(_konto+ROK(_data_zam)+_nr_zam+"N")

if !found()
   dbappend()  // jest FLOCK()                                       //24.02.14
//   APPE_BLOK()
endi

//RBLOK()                                                            //24.02.14
repl KONTO      with _konto,;                                        //16.12.13
     DATA_ZAM   with _data_zam,;
     NR_ZAM     with _nr_zam,;
     TYP        with "N",;
     STATUS     with _status,;                                       //24.02.14
     NR_KON     with _nr_kon,;
     INDEKS     with "OPIS",;
     MAGAZYN_PH with _mag_ph,;
     KURIER     with _kurier,;
     KUPONY     with _kupony,;
     OPLATA     with _oplata

if fieldpos("ETAP")>0.and._mag_ph="T"                                //31.12.13
  repl ETAP with "PH"
endi

repl OPIS with _konto+";"+;                              // 1. konto
               dtos(_data_zam)+";"+;                     // 2. data zamwienia
               _nr_zam+";"+;                             // 3. numer zamwienia
               _nr_kon+";"+;                             // 4. firma
                ltrim(str(_termin))+";"+;                // 5. termin
                padr(strtran(_platnosc,";",","),8)+";"+; // 6. patno
                _faktura+";"+;                           // 7. faktura
                alltrim(strtran(_uwagi,";",","))+";"+;   // 8. uwagi
                alltrim(_cennik)+";"+;                   // 9. cennik
                ltrim(str(_rabat,6,1))+";"+;             // 10. rabat
                ltrim(str(_wartosc,9,2))+";"+;           // 11. warto netto
                _operator                                // 12. operator
                                                                     //29.11.13

//DBRUNLOCK(recn())                                                  //24.02.14

sele (_sel)
RETURN NIL

*******************************************************************************
FUNCTION DAJ_ORE(_ore)                                                 //BAFPOL
loca _l:=lastkey()
if _ore.and._l=K_CTRL_RET.or._l=K_ENTER.or._l=K_ESC
  _o_rek:=recn()
endi
RETURN NIL

*******************************************************************************
FUNCTION KON_OK_L(_nr_kon)
KON->(dbseek(_nr_kon))

if KON->LIMIT<>0.and.KON->LIMIT<1.01
  QKE("Klient zablokowany przez central.")
endi
if KON->LIMIT<>0.and.KON->(WN_ODB-MA_ODB>LIMIT)
  QKE("Przekroczony limit zaduenia.")
endi
RETURN .T.

*******************************************************************************
FUNCTION SLAD_F8()
RETURN TOW->(" "+s_i(INDEKS)+" "+NAZWA_TOW+spac(2)+OPIS_TOW)

*******************************************************************************
FUNCTION CENA_NET()
local _cn:=0
do case
  case _cennik="1"
    _cn:=if(_ceny_1="B",TOW->(zaokr(CENA_1/(1+val(VAT)/100),2)),TOW->CENA_1)
  case _cennik="2"
    _cn:=if(_ceny_2="B",TOW->(zaokr(CENA_2/(1+val(VAT)/100),2)),TOW->CENA_2)
  case _cennik="3"
    _cn:=if(_ceny_3="B",TOW->(zaokr(CENA_3/(1+val(VAT)/100),2)),TOW->CENA_3)
endc
RETURN _cn

*******************************************************************************
FUNCTION CENA_BRU2()
local _cb:=0
do case
  case _cennik="1"
    _cb:=if(_ceny_1="N",TOW->(zaokr(CENA_1*(1+val(VAT)/100),2)),TOW->CENA_1)
  case _cennik="2"
    _cb:=if(_ceny_2="N",TOW->(zaokr(CENA_2*(1+val(VAT)/100),2)),TOW->CENA_2)
  case _cennik="3"
    _cb:=if(_ceny_3="N",TOW->(zaokr(CENA_3*(1+val(VAT)/100),2)),TOW->CENA_3)
endc
RETURN _cb

*******************************************************************************
FUNCTION NAG_ZAML(_nazwa_kon,_miasto,_adres,_platnik,_ope_zam,_nr_kon)
local _l:=""

DEFAULT _platnik TO spac(5),;
        _ope_zam TO spac(3)

@ prow()+1,0 say " BAFPOL Wrocaw "+dtoc(date())+" "+subs(time(),1,5)

_l:="ZAMWIENIE "+_nr_kon+"/"+trans0(val(_konto),2)+"/"+dtoc(date())
@ prow(),63 say _l

if !empty(_ope_zam)                                                  //29.11.13
 @ prow()+1,63 say "OPERATOR   "+_ope_zam
else
 @ prow()+1,64 say ""
endi

_l:=alltrim(alltrim(_nazwa_kon)+if(!empty(_miasto),", "+alltrim(_miasto),"")+;
                                if(!empty(_adres) ,", "+alltrim(_adres),""))
@ prow()+2,0 say " Zamawiajcy : "+_nr_kon+"  "+_l                  //29.11.13

if !empty(_platnik)

  if sele("KON")>0.and.KON->(dbseek(_platnik)).and.;
     KON->(fieldpos("PLATNIK")>0).and.KON->NR_KON=_platnik

     @ prow()+1,0 say " Patnik :     "+_platnik+"  "+;
      alltrim(alltrim(KON->NAZWA_KON)+if(!empty(KON->MIASTO),", "+;
              alltrim(KON->MIASTO),"")+if(!empty(KON->ADRES) ,", "+;
              alltrim(KON->ADRES),""))
  else
     @ prow()+1,0 say " Patnik :     "+_platnik
  endi

endi

RETURN NIL

*******************************************************************************
FUNCTION RAP_OMA()
loca _tex:='۲  RAPORT O KOMPLETACJI ZAMWIE  '
loca _astru:={}, _err:=.f.,_aop:={}
priv _data_od:=stod(str(year(date()),4)+"0101"),_data_do:=date()    

_data_od:=date()                                                     //27.05.14

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use(_gdzie_lap+"ZAM_N","R"); BREAK; endi
set index to (_gdzie_lap+"ZAM_N_S"),;  //KONTO+subs(dtos(DATA_ZAM),1,4)+NR_ZAM
             (_gdzie_lap+"ZAM_N_K"),;  //dtos(DATA_MAG)+NR_KON
             (_gdzie_lap+"ZAM_N_O")    //OPE_MAG+DTOS(DATA_MAG)

sele 0
if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endi
set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
             (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")


sele 0
_use (_gdzie_lap+"SL_OPE","R")
copy to (_sc+"SL_OPE")
use

sele 0
_use (_sc+"SL_OPE","E!")
index on KOD to (_sc+"SL_OPE")

@ 1,0 say "Okres :" get _data_od vali _data_od<=date()
@ 1,col()+1 say "-" get _data_do vali _data_od<=_data_do
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

_rap:=HorizMenu(2,0,"Raport :",;
                   {"SZCZEGOWY","DZIENNY","OKRESOWY"},1)
if _rap=0; BREAK; endi


_astru:={}
aadd(_astru,{"DATA_ZAM  ","D",8,0})
aadd(_astru,{"KONTO     ","C",5,0})
aadd(_astru,{"NR_ZAM    ","C",4,0})
aadd(_astru,{"NR_KON    ","C",5,0})
aadd(_astru,{"OPE_MAG   ","C",3,0})
aadd(_astru,{"NAZWISKO  ","C",20,0})
aadd(_astru,{"DATA_MAG  ","D",8,0})
aadd(_astru,{"TIME_MAG  ","C",5,0})
aadd(_astru,{"ILO_ZAM   ","N",11,1})                                 //27.05.14
aadd(_astru,{"ILO_FAK   ","N",11,1})
aadd(_astru,{"ILO_SKA   ","N",11,1})
aadd(_astru,{"ILE_FAK   ","N",6,0})
aadd(_astru,{"ILE_POZ   ","N",6,0})                                  //27.05.14
aadd(_astru,{"PROC_SKA  ","N",7,1})
aadd(_astru,{"PROC_BRA  ","N",7,1})
aadd(_astru,{"ILE_SKA   ","N",6,0})                                  //27.05.14
dbcreate(_sc+"RAP_OMA",_astru)

sele 0
_use(_sc+"RAP_OMA","E!")
index on dtos(DATA_MAG)+OPE_MAG to (_sc+"RAP_DO")
index on OPE_MAG+dtos(DATA_MAG) to (_sc+"RAP_OD")
set index to (_sc+"RAP_DO"),(_sc+"RAP_OD")
repl all NAZWISKO with _aop[ascan(_aop,{|o| o[1]=OPE_MAG})][2]

sele ZAM_N
apom:={}
for i:=1 to fcount(); aadd(apom,i); next
dbsetorder(2)
dbseek(dtos(_data_od),.t.)
dbeval({|| POLCOPY(ZAM_N,RAP_OMA),RAP_OMA->ILE_FAK:=1},,;
       {|| DATA_MAG<=_data_do})

sele RAP_OMA
repl all PROC_SKA with if(ILE_POZ<>0,100*ILE_SKA/ILE_POZ,0),;        //27.05.14
         PROC_BRA with max(if(ILO_ZAM<>0,100*(ILO_ZAM-ILO_FAK)/ILO_ZAM,0),;
                           -9999)
if _rap=1

  sele RAP_OMA 
  set rela to OPE_MAG into SL_OPE
  dbsetorder(1)
  go top
  CPEDIT POZ: 3,,23,               ;
         DEF: "RAP_OMA"            ;
         POZWER: "V2"              ;
         PION: ,,,                 ;
         INDEXY: {"data","operator"} ;
         ODTWORZ:.f.

  if len(_zaznaczone)>0
    set filter to ascan(_zaznaczone,recn())>0
  endif
  go top
  CPDRUK  DEF: "RAP_OMA"                 ;
          WERSJA: "VR"               ;
          TYTUL: "RAPORT SZCZEGOWY O KOMPLETACJI "+dtoc(_data_od)+"-";
                                                    +dtoc(_data_do);
          WARIANT: 14         


elseif _rap=2

  sele RAP_OMA 
  dbsetorder(1)
  total on dtos(DATA_MAG)+OPE_MAG;                                   //27.05.14
        fiel ILO_ZAM,ILO_FAK,ILO_SKA,ILE_FAK,ILE_POZ,ILE_SKA to (_sc+"RAP_DZI")

  sele 0
  _use(_sc+"RAP_DZI","E!")
  set rela to OPE_MAG into SL_OPE
  index on dtos(DATA_MAG)+OPE_MAG to (_sc+"DZI_DO")
  index on OPE_MAG+dtos(DATA_MAG) to (_sc+"DZI_OD")
  set index to (_sc+"DZI_DO"),(_sc+"DZI_OD")

  repl all PROC_SKA with if(ILE_POZ<>0,100*ILE_SKA/ILE_POZ,0),;      //27.05.14
           PROC_BRA with max(if(ILO_ZAM<>0,100*(ILO_ZAM-ILO_FAK)/ILO_ZAM,0),;
                           -9999)
  go top
  CPEDIT POZ: 3,,23,               ;
         DEF: "RAP_OMA"            ;
         POZWER: "V3"              ;
         PION: ,,,                 ;
         INDEXY: {"data","operator"} ;
         ODTWORZ:.f.

  if len(_zaznaczone)>0
    set filter to ascan(_zaznaczone,recn())>0
  endif
  go top
  CPDRUK  DEF: "RAP_OMA"                 ;
          WERSJA: "VR"               ;
          TYTUL: "RAPORT Z DZIENNEJ KOMPLETACJI ZAMWIE "+;
                                dtoc(_data_od)+"-"+dtoc(_data_do);
          WARIANT: 14         

elseif _rap=3

  sele RAP_OMA 
  dbsetorder(2)
  total on OPE_MAG;                                                  //27.05.14
        fiel ILO_ZAM,ILO_FAK,ILO_SKA,ILE_FAK,ILE_POZ,ILE_SKA to (_sc+"RAP_OKR")

  sele 0
  _use(_sc+"RAP_OKR","E!")
  index on OPE_MAG to (_sc+"OKR_O")
  set rela to OPE_MAG into SL_OPE

  repl all PROC_SKA with if(ILE_POZ<>0,100*ILE_SKA/ILE_POZ,0),;      //27.05.14
           PROC_BRA with max(if(ILO_ZAM<>0,100*(ILO_ZAM-ILO_FAK)/ILO_ZAM,0),;
                           -9999)
  go top
  CPEDIT POZ: 3,,23,               ;
         DEF: "RAP_OMA"            ;
         POZWER: "V4"              ;
         PION: ,,,                 ;
         INDEXY: {"operator"} ;
         ODTWORZ:.f.

  if len(_zaznaczone)>0
    set filter to ascan(_zaznaczone,recn())>0
  endif
  go top
  CPDRUK  DEF: "RAP_OMA"                 ;
          WERSJA: "VR"               ;
          TYTUL: "RAPORT OKRESOWY Z KOMPLETACJI ZAMWIE "+;
                                    dtoc(_data_od)+"-"+dtoc(_data_do);
          WARIANT: 14         

endi

END SEQUENCE
close data

RETURN NIL

*******************************************************************************
FUNCTION INDEKS_ZAML(_nr_kon)
local _toword:=TOW->(indexord()),_towrec:=TOW->(recn()),_ret:=.f.,;
      _spacgru:=spac(2),_indeks:=INDEKS

TOW->(dbsetorder(1))
if TOW->(dbseek(s_i(_indeks)))

  repl NAZWA_TOW with TOW->NAZWA_TOW,;
       OPIS_TOW  with TOW->OPIS_TOW,;
       KOD_PAS   with TOW->KOD_PAS,;
       JM        with TOW->JM,;
       VAT       with TOW->VAT,;
       CENA_ZAK  with TOW->CENA_ZAK

  do case 
    case _cennik="1".or.(_cennik="2".and.TOW->CENA_2=0).or.;        //14.09.12
                        (_cennik="3".and.TOW->CENA_3=0)
      repl CENA with ;
            if(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
    case _cennik="2"
      repl CENA with ;
            iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
    case _cennik="3"
      repl CENA with ;
            iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
  endc
  repl CENA_CEN with CENA,;
       CENA_SPR with if(subs(_wersja,36,1)=="2",;
                        CENA*100/(100+_rabat),CENA*(100-_rabat)/100)

  CpSwiezyRekord()
  _ret:=.t.
endi
TOW->(dbgoto(_towrec))
TOW->(dbsetorder(_toword))

RETURN _ret

*******************************************************************************
FUNCTION WERK()
loca _sel:=select(), _nip:=strtran(ID_KON,"-"),_nrk:=NR_KON,_are:={} //23.09.16

if updated().and.NIP_OK(_nip).and.!empty(NR_KON).and.NR_KON<>"00000";
            .and.!empty(_nip)

  BEGIN SEQUENCE

  sele 0                                                      //09.10.14 BAFPOL
  if !_use("BLOKADYF","S","BLOF"); BREAK; endi                    
  set index to BLOKF_F,; //NR_KON+s_i(INDEKS)+str(KLASA,3)
               BLOKF_K,; //KONTO+NR_KON+s_i(INDEKS)+str(KLASA,3) 
               BLOKF_I,; //s_i(INDEKS)+str(KLASA,3)+KONTO 
               BLOKF_D   //dtos(DATA_BLO)+KONTO+NR_KON    

  QK("Weryfikacja klientw z numerem 00000")

 
  dbsetorder(1)                                                      //23.09.16
  dbseek("00000")
  do while NR_KON="00000".and.!eof()
    if alltrim(strtran(NIP,"-"))==alltrim(_nip)
      aadd(_are,recn())
    endi
    skip
  endd
  dbsetorder(0)
  for _i:=1 to len(_are)
    dbgoto(_are[_i])
    if rlock()
      repl NR_KON with _nrk
    endi
  next


/* wariant wolniejszy                                                //23.09.16
  dbsetorder(0)
  QPC(1)
  repl all NR_KON with _nrk for NR_KON="00000".and.;
           alltrim(strtran(NIP,"-"))==alltrim(_nip).and.rlock()
  QPC(0)
*/
  END SEQUENCE

  CPClose(BLOF)
endi
sele (_sel)

RETURN .T.

*******************************************************************************
FUNCTION NIP_OK(_nip)
local _wagi:={6,5,7,2,3,4,5,6,7},_chk:=0,i,_liczby:=.t.,_ok:=.T.

_nip:=alltrim(charrem("-",_nip))

if empty(_nip); RETURN .T.; endi

if len(_nip)=10
  for i:=1 to 10
    if !subs(_nip,i,1)$"0123456789"
      _liczby:=.f.
      exit
    endi
  next
  if _liczby
    for i:=1 to 9
      _chk:=_chk+(_wagi[i]*val(subs(_nip,i,1)))
    next
    _chk:=_chk%11
  endi
endi

if (len(_nip)<>10.or.!_liczby.or._chk<>val(subs(_nip,10,1)))
  _ok:=.F.
endi
RETURN _ok

*******************************************************************************
FUNCTION PREZE()                                              //02.10.16 BAFPOL
loca _tex:='۲  PRZEGLDANIE REZERWACJI FIRAN  '
loca _nazwa_kon:="", _astru:={}, _err:=.f.
loca _ekran:=savescreen(0,0,24,79),_sel:=select()
loca GetList:={},_cursor:=setcursor(),_ocolo:=SET(_SET_COLOR,_ekra_blo),;
      _r:=row(),_c:=col(),_old_esc:=set(_SET_ESCAPE,.t.)

priv _nr_kon:=spac(5),_data_od:=ctod(""),_data_do:=ctod("")    
priv _nr_rec, _ktory_rekord:=0
priv _konto:=spac(5),_indeks:=s_i(spac(20))

setkey(K_ALT_F,{|| NIL })                            

cls
@ 0,0 say 'PRZEGLDANIE REZERWACJI FIRAN'
showtime()

BEGIN SEQUENCE

sele 0
if !_use("BLOKADYF","R","RBLOKADY"); BREAK; endif
set index to ("BLOKF_F"),; //NR_KON+s_i(INDEKS)+str(KLASA,3)
             ("BLOKF_K"),; //KONTO+NR_KON+s_i(INDEKS)+str(KLASA,3) 
             ("BLOKF_I"),; //s_i(INDEKS)+str(KLASA,3)+KONTO 
             ("BLOKF_D")   //dtos(DATA_BLO)+KONTO+NR_KON    
sele 0
if !_use("TOW","R","RTOW"); BREAK; endi
set index to TOW_IN, TOW_NA, TOW_GR, TOW_SW

sele 0
if empty(_gdzie_fir)
  _use("KON","S!","RKON")
  set index to KON_NR, KON_NA, KON_NI, KON_AD
else
  _use(_gdzie_fir+"FIRMY","S!","RKON")
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi

sele 0
if !_use("SL_KONT","R","RSL_KONT"); BREAK; endi
set index to SL_KONT

_indeks:=s_i(spac(20))
_konto:=spac(5)
_nr_kon:=spac(5)


if fieldpos("INDEKS")>0.and.!empty(INDEKS)
  _indeks:=s_i(INDEKS)
elseif select("SPR_P_R")>0.and.!empty(SPR_P_R->INDEKS)
  _indeks:=SPR_P_R->(s_i(INDEKS))
elseif select("DOKP_R")>0.and.!empty(DOKP_R->INDEKS)
  _indeks:=DOKN_P->(s_i(INDEKS))
endi

/*
if fieldpos("KONTO")>0.and.!empty(KONTO)
  _konto:=KONTO
elseif select("SPR_N_R")>0.and.!empty(SPR_N_R->KONTO)
  _konto:=SPR_N_R->KONTO
elseif select("DOKN_R")>0.and.!empty(DOKN_R->KONTO)
  _konto:=DOKN_R->KONTO
endi

if fieldpos("NR_KON")>0.and.!empty(NR_KON)
  _nr_kon:=NR_KON
elseif select("SPR_N_R")>0.and.!empty(SPR_N_R->NR_KON)
  _nr_kon:=SPR_N_R->NR_KON
elseif select("DOKN_R")>0.and.!empty(DOKN_R->NR_KON)
  _nr_kon:=DOKN_R->NR_KON
endi
*/

if _konto="00000"; _konto:="     "; endi

@ 1,0 say "Indeks :" get _indeks   pict _format_ind ;
          when SLGET("RTOW","TOW","V1",1,1,;
            {"indeks","nazwa","grupa",ORD4()},,.f.,BEZBLOK);
          vali (empty(_indeks).or.;
                RTOW->(dbseek(s_i(_indeks))).and.RTOW->FIRANA="T").and.SLGET()

@ 1,col()+2 say "Konto :" get _konto pict "@K 99999";                    
      when SLGET("RSL_KONT","SL_KONT","V1",1,1,{"konto"},,.f.);
      vali (empty(_konto).or.SZ().and.SL("RSL_KONT","SL_KONT","V1",1,1));
           .and.SLGET() 
@ 1,col()+2 say "Daty rezerwacji :" get _data_od vali _data_od<=date()
@ 1,col()+1 say "-" get _data_do vali _data_od<=_data_do.and.;
                                      year(_data_od)=year(_data_do)
@ 2,0 say "Firma : " get _nr_kon pict "@K 99999";
      when SLGET("RKON","KON","V1",1,1,;
                   {"numer","nazwa","NIP","miasto i ulica"},,.f.); 
      valid empty(_nr_kon).or.;
            SZ().and.SL("RKON","KON","V1",1,1).and.SLGET() 
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

if !empty(_indeks)
  if !RTOW->(dbseek(s_i(_indeks)))
    _indeks:=s_i(spac(20))
  endi
endi

if !empty(_nr_kon)
  RKON->(dbseek(_nr_kon))
  @ 2,16 say alltrim(RKON->NAZWA_KON)+;
             if(empty(RKON->MIASTO),"",", "+alltrim(RKON->MIASTO))+;
             if(empty(RKON->ADRES),"",", "+alltrim(RKON->ADRES))
endi

sele RBLOKADY
if _indeks=s_i(spac(20))
  if !empty(_konto)
    if !empty(_nr_kon)
      set filt to KONTO=_konto.and.NR_KON=_nr_kon
    else
      set filt to KONTO=_konto
    endi
  elseif !empty(_nr_kon)
    set filt to NR_KON=_nr_kon
  endi
else
  if !empty(_konto)
    if !empty(_nr_kon)
      set filt to KONTO=_konto.and.NR_KON=_nr_kon.and.s_i(INDEKS)=_indeks
    else
      set filt to KONTO=_konto.and.s_i(INDEKS)=_indeks
    endi
  elseif !empty(_nr_kon)
    set filt to NR_KON=_nr_kon.and.s_i(INDEKS)=_indeks
  else
    set filt to s_i(INDEKS)=_indeks
  endi
endi  

sele RBLOKADY
go top
if !empty(_data_od).or.!empty(_data_do)
  copy to (_sc+"RBLOKADY") for DATA_ZAM>=_data_od.and.DATA_ZAM<=_data_do
else
  copy to (_sc+"RBLOKADY")
endi
Cpclose(RBLOKADY)

sele 0
_use(_sc+"RBLOKADY","E!")
index on KONTO+NR_KON+s_i(INDEKS)+str(KLASA,3) to (_sc+"TBLO")
total on KONTO+NR_KON+s_i(INDEKS)+str(KLASA,3) fiel REZERWACJA to (_sc+"TBLO")
set index to
 
sele 0
_use(_sc+"TBLO","E!")
index on KONTO+NR_KON+s_i(INDEKS)+str(KLASA,3) to (_sc+"TBLO")

sele RBLOKADY
set rela to KONTO+NR_KON+s_i(INDEKS)+str(KLASA,3) into TBLO
dele for TBLO->REZERWACJA=0
set rela to
pack
CPClose(TBLO)

index on NR_KON+s_i(INDEKS)+str(KLASA,3)       to (_sc+"BLOKF_F")
index on KONTO+NR_KON+s_i(INDEKS)+str(KLASA,3) to (_sc+"BLOKF_K")
index on s_i(INDEKS)+str(KLASA,3)+KONTO        to (_sc+"BLOKF_I")
index on dtos(DATA_BLO)+KONTO+NR_KON           to (_sc+"BLOKF_D")   
set index to (_sc+"BLOKF_F"),(_sc+"BLOKF_K"),(_sc+"BLOKF_I"),(_sc+"BLOKF_D")
set rela to NR_KON into RKON
set rela to s_i(INDEKS) into RTOW additive

go top
CPEDIT  POZ: 3,,23,               ;
        DEF: "RBLOKADY"           ;
        POZWER: "V1"              ;
        POZSLAD: padr(" "+NR_KON+" "+alltrim(RKON->NAzWA_KON)+", "+;
                  alltrim(RKON->MIASTO),76);
        PION: ,,,                 ;
        INDEXY: {"firma","konto","indeks","data"};
        ODTWORZ:.F.

END SEQUENCE

CPClose(RTOW)
CPClose(RKON)
CPClose(RSL_KONT)
CPClose(RBLOKADY)
SLGET()

//QKE("Kontynuacja")

restscreen(0,0,24,79,_ekran)

set curs off
set(_SET_CURSOR,_cursor)
getlist:={}
set(_SET_ESCAPE,_old_esc)
devpos(_r,_c)
SET(_SET_COLOR,_ocolo)

if "MENU"==procname(3)
   SHOWTIME(4,70,.f.,_ekra_blo)
endif

sele (_sel)

setkey(K_ALT_F ,{|| PREZE(.t.)} )           
RETURN NIL

*******************************************************************************
FUNCTION EKON_BAF()                                           //24.07.17 BAFPOL
local _tex:='۲  WERYFIKACJA SOWNIKA KONTRAHENTW  ',_selekcja,;
      _miasto:=spac(20),apom:={},i
local _maxgr:=99,_nr_g_kon:=spac(20)
priv  akon:={},_szab_n:=spac(36),_konto:=spac(5),_tdat:=""

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use("SL_KONT","S"); BREAK; endi
set index to ("SL_KONT")

sele 0                                                        //30.04.14 BAFPOL
if !_use("SL_PLA","S"); BREAK; endi
set index to SL_PLA

sele 0
if empty(_gdzie_fir)
  if !_use("KON","S"); BREAK; endi
  set index to KON_NR, KON_NA, KON_NI, KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","S","KON"); BREAK; endi
  set index to (_gdzie_fir+"FIRMY_NR"), (_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"), (_gdzie_fir+"FIRMY_AD")
endi

*------------------------------------------------------------------------------
if !flock()
  tone(220,2)
  QK("Opcja wymaga chwilowego penego dostpu do sownika kontrahentw.")
  BREAK
endi

QPC(1)

if empty(_gdzie_fir)
  index on KONTO     to KON_KO
  index on GRUPA_KON to KON_GR
  set index to KON_NR, KON_NA, KON_NI, KON_AD, KON_KO, KON_GR 
else
  index on KONTO     to (_gdzie_fir+"FIRMY_KO")
  index on GRUPA_KON to (_gdzie_fir+"FIRMY_GR")
  set index to (_gdzie_fir+"FIRMY_NR"), (_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"), (_gdzie_fir+"FIRMY_AD"),;
               (_gdzie_fir+"FIRMY_KO"), (_gdzie_fir+"FIRMY_GR")
endi
dbunlock()

sele 0
if !_use("DOK001N","R"); BREAK; endi
set index to ("D001N_RD")
go top
_data_od:=DATA_DOK
dbseek("OK001")
do while RODZAJ_DOK="OK".and.!eof()
  if !empty(DATA_DOK); _data_od:=DATA_DOK; endi
  skip
endd
_tdat:="Obrt brutto;od "+dtoc(_data_od)

CPClose(DOK001N)

sele 0
if !_use("SPR_N","R"); BREAK; endi
set index to SPR_N_KO //NR_KON+RODZAJ_DOK+SERIA_FAK+ROK_DOK+NR_DOK

_nr_kon:=chr(255)+spac(4)
_data_fak:=ctod("")
_obrot:=0

go top
do while !eof()
  if DATA_DOK<_data_od; skip; loop; endi
  if !NR_KON==_nr_kon
    KON->(dbseek(_nr_kon))
    if !KON->(eof())
      if KON->(rlock())
        KON->DATA_FAK:=_data_fak
        KON->OBROT   :=_obrot
      endi
      KON->(dbunlock())
    endi
    _nr_kon:=NR_KON
    _data_fak:=ctod("")
    _obrot:=0
  endi
  _data_fak:=max(DATA_DOK,_data_fak)
  _obrot   +=WART_ZAP
  skip
endd

QPC(0)

*------------------------------------------------------------------------------

if fieldpos("BANK")>0

  sele 0
  if !_use("BANKI","R"); BREAK; endi
  set inde to BANKI
endi

* KON_NR -> NR_KON
* KON_NA -> NAZWA_KON
* KON_NI -> strtran(ID_KON,"-")
* KON_AD -> rtrim(MIASTO)+','+ADRES
* KON_KO -> KONTO       (TMP)
* KON_GR -> GRUPA_KON   (TMP)

sele KON
go top
CPEDIT  POZ: 1,,23,               ;
        DEF: "KON"                ;
        POZWER: "V11|V_OPE().and.V_KONCES().and.V_MAXOP()";                  //@
        POZSLAD: " "+NR_KON+"  "+subs(NAZWA_KON,1,40);
        PION: ,,23,                 ;
        PIONWER: "V11|V_OPE().and.V_KONCES()"               ;
        PIONSLAD: NR_KON+"  "+subs(alltrim(NAZWA_KON),1,40);
                            +space(60-len(subs(alltrim(NAZWA_KON),1,40)));
        INDEXY: {"numer","nazwa","NIP","miasto, ulica","konto","grupa"}  ;
        EDYCJA: .T. ;
        ODTWORZ:.F. ;
        SIEC: REKORD

if len(_zaznaczone)>0
  set filter to ascan(_zaznaczone,recn())>0
endif

go top
CPDRUK  DEF: "KON"                 ;
        WERSJA: "VR"               ;
        TYTUL: "SOWNIK KONTRAHENTW";
        WARIANT: 20


END SEQUENCE
close data
dele file (_sc+"KON_ROB.DBF")
dele file (_sc+"KON_ROBN.NTX")
dele file (_sc+"KON_ROBM.NTX")
RETURN NIL

*******************************************************************************
FUNCTION ILE_ZAM_KON()
local _sel:=sele(),_ord,_rek,_kon,_l:=0

BEGIN SEQUENCE

if sele("NZAM")=0.or.empty(OrdName(4)); BREAK; endi

_ord:=NZAM->(indexord())
_rek:=NZAM->(recn())
_kon:=NZAM->(NR_KON)

if empty(NR_KON); BREAK; endi

sele NZAM
dbsetorder(4)
dbseek(_kon)
count to _l while NR_KON==_kon

sele (_sel)
NZAM->(dbsetorder(_ord))
NZAM->(dbgoto(_rek))
 
if _l>1
 QK("Liczba zamwie firmy "+_kon+" : "+alltrim(str(_l)))
endi
  
END SEQUENCE
RETURN .T.

*******************************************************************************
FUNCTION TEST_MAIL()
cls

QKE("Test poczty HB_SendMail()")

/* 
  //OK. 23.02.2018:
  cServer   :="smtp.wp.pl"             //alltrim(SERW_SMTP)
  nPort     :=587                      //PORT_SMTP
  cFrom     :="comped@wp.pl"           //alltrim(ADRES_MAIL)
  aTo       :={"mpop@comped.com.pl"}   //{_tmail}   
  cBody     :="Test"
  cSubject  :="Test poczty"
  aFiles    :={"CONFIG.DBF"}           //{_tpdf}
  cUser     :="comped@wp.pl"           //alltrim(USER_POP)
  cPass     :="*s****9**"              //CRYPT(left(HASLO_POP,NHASLO),"ZSIWI")
  cPopServer:="pop3.wp.pl"             //alltrim(SERW_POP)  
*/

  //QK. 23.02.2018:
  cServer   :="smtp.bafpol.pl"         //alltrim(SERW_SMTP)
  nPort     :=587                      //PORT_SMTP
  cFrom     :="megavat@bafpol.pl"      //alltrim(ADRES_MAIL)
  aTo       :={"mpop@comped.com.pl"}   //{_tmail}   
  cBody     :="Test"
  cSubject  :="Test poczty"
  aFiles    :={"CONFIG.DBF"}           //{_tpdf}
  cUser     :="megavat"                //alltrim(USER_POP)
  cPass     :="MegaVat_Baf2018"        //CRYPT(left(HASLO_POP,NHASLO),"ZSIWI")
  cPopServer:=""                       //alltrim(SERW_POP)   (moe byc pusty)


  if HB_SendMail(cServer,nPort,cFrom,aTo,,,cBody,cSubject,aFiles,cUser,cPass,;
                 cPopServer,,,.t.,,,)
    tone(880,2)
    QKE("Wysano poczt za pomoc HB_SendMail().") 
  else
    tone(220,2)
    QKE("Nie wysano poczty za pomoc HB_SendMail().") 
  endi

QKE("Test poczty SMTPSEND.EXE")

//OK.23.02.18 :
_mail_from :=padr("megavat@bafpol.pl",40)  //SMTPSENT -f       
_mail_host :=padr("smtp.bafpol.pl",40)     //SMTPSENT -h
_mail_to   :="mpop@comped.com.pl"          //SMTPSENT -t
_mail_port :=padr("587",40)                //SMTPSENT -p
_mail_user :=padr("megavat",40)            //SMTPSENT -lu
_mail_pass :=padr("MegaVat_Baf2018",40)  //SMTPSENT -lp


/*
//OK, 23.02.18 :
_mail_from :="comped@wp.pl"        //SMTPSENT -f
_mail_to   :="mpop@comped.com.pl"  //SMTPSENT -t
_mail_host :="smtp.wp.pl"          //SMTPSENT -h
_mail_port :="587"                 //SMTPSENT -p
_mail_user :="comped@wp.pl"        //SMTPSENT -lu
_mail_pass :="*s****9**"           //SMTPSENT -lp
*/

_cmd:='smtpsend '+;
      ' -f'+_mail_from+;
      ' -t'+_mail_to+;
      ' -h'+_mail_host+;
      ' -p'+_mail_port+;
      ' -i'+"smtp.txt"+;
      ' -lu'+_mail_user+;
      ' -lp'+_mail_pass+;
      ' -a'+".\CONFIG.DBF"+;
      ' -s'+"Test poczty"

_plik:=fcreate("msent.bat")
fwriteln(_plik,"cls")
fwriteln(_plik,_cmd)
fclose(_plik)

RUN msent.bat

wait

RETURN NIL

*******************************************************************************
*                                   23.08.2018                                *
*******************************************************************************
FUNCTION IMPORT_CRM(_ftp)                      
local _tex1:='۲  IMPORT I PRZETWORZENIE DANYCH CRM Z FTP  ',;
  _tex2:='۲  PRZETWORZENIE DANYCH CRM POBRANYCH Z POCZTY E-MAIL  '
local _ser_ftp:=.f.,_od, _do
priv  _konto:=spac(5),_akont:={},_bkont:={}

priv _kat_dan:=alltrim(_gdzie_dan)
priv _kat_kon:=alltrim(_gdzie_fir)                                   //23.08.18

DEFAULT _ftp TO .T.

cls
@ 0,0 say if(_ftp,_tex1,_tex2)

if !_ftp
  @ 3,0 say "Uwaga: Zalecanym sposobem aktualizacji bazy CRM jest pobranie danych"
  @ 4,0 say "       bezporednio z FTP wraz z automatycznym ich przetworzeniem."
  @ 5,0 say "       W przypadku pobrania danych z zacznikw poczty elektronicznej"
  @ 6,0 say "       naley odebrane pliki zapisa wczeniej do folderu "+_gdzie_dan
  @ 7,0 say "       i nastpnie uruchomi t opcj programu."
endi

BEGIN SEQUENCE

sele 0                                                               //23.08.18
/*
if !_use("KON","S"); BREAK; endi
set index to KON_NR,KON_NA,KON_NI,KON_AD
*/
if !_use(_kat_kon+"FIRMY","R","KON"); BREAK; endi                
set index to (_kat_kon+"FIRMY_NR"), (_kat_kon+"FIRMY_NA"),;
             (_kat_kon+"FIRMY_NI"), (_kat_kon+"FIRMY_AD")

sele 0
if !_use(_gdzie_lap+"CRM","S"); BREAK; endi                          //23.08.18
set index to (_gdzie_lap+"CRM_PH"),;  //KONTO+dtos(DATA)
             (_gdzie_lap+"CRM_KO"),;  //NR_KON+dtos(DATA)
             (_gdzie_lap+"CRM_TY"),;  //TYP+dtos(DATA)
             (_gdzie_lap+"CRM_TE"),;  //TYP+dtos(TERMIN)+GODZ_T for KONTO=_konto_ph
             (_gdzie_lap+"CRM_KT")    //KONTO+TIMEDATE
//set rela to NR_KON into KON
dbsetorder(0)

sele 0
if !_use("SL_KONT","R"); BREAK; endif
set index to ("SL_KONT")


@ 1,25 say "(puste pole - wszystkie konta)"
@ 1,0 say "Import danych PH :" get _konto pict "@K 99999";
    when SLGET("SL_KONT","SL_KONT","V1",1,1,{"konto"},,.f.);
    vali empty(_konto).or.SZ().and.SL("SL_KONT","SL_KONT","V1",1,1).and.SLGET()
set curs on; read; set curs off
if lastkey()=K_ESC.or.!QTN("Wczytanie danych CRM ?"); BREAK; endi

_akont:={}                                             //nadawca
if empty(_konto)
  SL_KONT->(dbeval({|| aadd(_akont,KONTO)},;
                   {|| !AKTYWNY="N"}))          
else
  aadd(_akont,_konto)
endi

_bkont:={}                                             //odbiorca
if val(_konto_ph)>0.and. _konto_ph$_konta_ce
  aadd(_bkont,_konto_ph)
  aadd(_bkont,"00000")
elseif val(_konto_ph)>0
  aadd(_bkont,_konto_ph)
elseif val(_konto_ph)=0
  aadd(_bkont,"00000")
endi

if len(_akont)=1
  cls
else
  QPC(1)
endi

for _i:=1 to len(_akont)
  for _j:=1 to len(_bkont)
  
    _od:=_akont[_i]
    _do:=_bkont[_j]


    if _ftp                                              //odczyt z ftp do DANE

      if len(_akont)>1
        @ 24,0 say "Odczyt pliku "+NCRM(_od,_do)+"...              "
      endi

      dele file (_kat_dan+NCRM(_od,_do)+".DBF")
      dele file (_kat_dan+NCRM(_od,_do)+".DBT")
  
      _plik:=fcreate("freadc.bat")
//      fwriteln(_plik,"cls")
      if len(_akont)>1
        fwriteln(_plik,"@ftp -s:freadc.scr >NUL")
      else
        fwriteln(_plik,"@ftp -s:freadc.scr")
      endi

      fclose(_plik)
       
      _plik:=fcreate("freadc.scr")
      fwriteln(_plik,"open "+_ftp_open)
      fwriteln(_plik,_ftp_login)
      fwriteln(_plik,_ftp_pass)
      fwriteln(_plik,"cd "+_ftp_path)
      fwriteln(_plik,"cd DANE_"+trans0(val(_akont[_i]),2))
      fwriteln(_plik,"binary")
      fwriteln(_plik,"get "+NCRM(_od,_do)+".DBF "+;
                   _kat_dan+NCRM(_od,_do)+".DBF")

      fwriteln(_plik,"get "+NCRM(_od,_do)+".dbf "+;                  //01.09.15
                   _kat_dan+NCRM(_od,_do)+".DBF")

      fwriteln(_plik,"binary")

      fwriteln(_plik,"get "+NCRM(_od,_do)+".DBT "+;
                   _kat_dan+NCRM(_od,_do)+".DBT")


      fwriteln(_plik,"get "+NCRM(_od,_do)+".dbt "+;
                   _kat_dan+NCRM(_od,_do)+".DBT")

      fwriteln(_plik,"quit")
      fclose(_plik)
    
//    SWPRUNCMD("cmd <freadc.bat",0,"","")
      RUN freadc.bat     //xHB
    
//      tone(880,1)
      clear typeahead

      if len(_akont)=1
        inkey(10)      
        cls
      endi

    endi

                                                                //odczyt z DANE
    if !file(_kat_dan+NCRM(_od,_do)+".DBF").or.;
       !file(_kat_dan+NCRM(_od,_do)+".DBT").or.;
       filesize(_kat_dan+NCRM(_od,_do)+".DBF")<=0

      dele file (_kat_dan+NCRM(_od,_do)+".DBF")
      dele file (_kat_dan+NCRM(_od,_do)+".DBT")
    else

      if len(_akont)>1
        @ 24,0 say "Aktualizacja "+NCRM(_od,_do)+"...              "
        inkey(1)
      endi

      ODCZYT_CRM(_kat_dan+NCRM(_od,_do))
    endi

  next
next

@ 24,0 say padr("Koniec",80)
inkey(3)
@ 24,0
  
K_OFF()
dele file freadc.scr
inkey(5)

//wait "Nacinij dowolny klawisz ..."

if len(_akont)>1
  QPC(0)
else
  cls
  @ 0,0 say if(_ftp,_tex1,_tex2)
endi


_lp:=0
for _i:=1 to len(_akont)
  for _j:=1 to len(_bkont)

    _od:=_akont[_i]
    _do:=_bkont[_j]

    if filesize(_kat_dan+NCRM(_od,_do)+".DBF")<=0
      dele file (_kat_dan+NCRM(_od,_do)+".DBF")
      dele file (_kat_dan+NCRM(_od,_do)+".DBT")
    endi
    if file(_kat_dan+NCRM(_od,_do)+".DBF"); _lp++; endi
  next
next

if val(_konto_ph)=0
  if _ftp
    QKE("Pobrano z FTP dane CRM od "+alltrim(str(_lp))+" nadawcw.")
  else
    QKE("Przetworzono dane CRM "+alltrim(str(_lp))+" nadawcw.")
  endi
else
  if _lp=0
    QKE("Brak nowych danych CRM lub bd odczytu.")
  else
    if _ftp
      QKE("Pobrano z FTP dane CRM.")
    else
      QKE("Przetworzono dane CRM.")
    endi
  endi
endi

END SEQUENCE

RETURN NIL

*******************************************************************************
FUNCTION NCRM0(_od,_do)
RETURN "CRM"+trans0(val(subs(_od,4,2)),2)+"_"+trans0(val(subs(_do,4,2)),2)

*******************************************************************************
FUNCTION NCRM(_od,_do)                                               //01.09.15
RETURN "CRM"+subs(_od,4,2)+"_"+subs(_do,4,2)

*******************************************************************************
FUNCTION ODCZYT_CRM(_crm)
local _sel:=select(),_key,_zmiana:=.f., _stary,_nowy

BEGIN SEQUENCE

if filesize(_crm+".DBF")<=0
  dele file (_crm+".DBF")
  dele file (_crm+".DBT")
  BREAK
endi

KON->(FBLOK())
CRM->(FBLOK())

sele select("CRM_I")
_use(_crm,"F","CRM_I")
go top
do while !eof()
                                                                     //30.08.15
  if CRM_I->DATA<ctod("01.08.2015")                          //OD SIERPNIA 2015
    skip; loop
  endi   

  BEGIN SEQUENCE         

  _zmiana:=.f.
  if val(CRM_I->NR_KON)=0.and.!CRM_I->NR_KON=="00000"


    KON->(dbsetorder(3))

    _nip:=alltrim(strtran(CRM_I->ID_KON,"-"))

    if !empty(_nip).and.KON->(dbseek(_nip))

      sele KON
      loca for val(NR_KON)>0 while alltrim(strtran(KON->ID_KON,"-"))==;
                                   alltrim(_nip)

      if KON->(found())

        _stary:=CRM_I->NR_KON
        _nowy :=KON->NR_KON
        CRM_I->NR_KON:=_nowy

        _zmiana:=.t.    // firma istnieje w bazie podstawowej
                        // modyfikujemy tylko CRM (podmieniamy numer firmy)
      endi
   
      sele CRM_I
      if _zmiana; BREAK; endi
    endi
  endi

  KON->(dbsetorder(1))
  if !empty(CRM_I->NR_KON).and.!KON->(dbseek(CRM_I->NR_KON)).and.KON->(flock())
    KON->(dbappend())
    KON->NR_KON     := CRM_I->NR_KON                        
    KON->ID_KON     := CRM_I->ID_KON
    KON->NAZWA_KON  := CRM_I->NAZWA_KON
    KON->NAZWA_KON2 := CRM_I->NAZWA_KON2
    KON->KOD        := CRM_I->KOD
    KON->MIASTO     := CRM_I->MIASTO
    KON->ADRES      := CRM_I->ADRES
    KON->TELEFON    := CRM_I->TELEFON
    KON->UWAGI      := CRM_I->UWAGI
    KON->(dbunlock())
  endi

  END SEQUENCE


  if _zmiana

    sele CRM
    dbsetorder(0)
    repl all NR_KON with _nowy for NR_KON=_stary

    sele KON
    dbsetorder(1)
    dbseek(_stary)
    if rlock(); dbdelete(); dbunlock(); endi
  endi
 
  _key:=CRM_I->(KONTO+TIMEDATE)

  CRM->(dbsetorder(5))
  CRM->(dbseek(_key))
  if CRM->(found())
    if CRM_I->TYP$"ZX" 
      CRM->TYP:=CRM_I->TYP
    endi
  else
    dele file (_sc+"CRM_P.DBF") 
    dele file (_sc+"CRM_P.DBT") 
    copy next 1 to (_sc+"CRM_P") 
 
    sele CRM
    appe from (_sc+"CRM_P.DBF") 
  endi

  sele CRM_I
  skip
endd 

END SEQUENCE

KON->(dbunlock())
CRM->(dbunlock())
CPClose(CRM_I)

sele (_sel)
RETURN NIL

*******************************************************************************
FUNCTION ED_TYP()           
local GetList:={},_wie:=cprow(),_kol:=cpcol(),;
      _stary:=TYP,_nowy:=TYP

if _stary=" "
  @ _wie,_kol get _nowy picture "@! A" vali _nowy$" AWZ".or.TYP_INFO()
elseif _stary="A"
  @ _wie,_kol get _nowy picture "@! A" vali _nowy$"AZX".or.TYP_INFO()
elseif _stary="W"
  @ _wie,_kol get _nowy picture "@! A" vali _nowy$"AWZX".or.TYP_INFO()
elseif _stary$"Z"
  @ _wie,_kol get _nowy picture "@! A" vali _nowy$"X".or.TYP_INFO()
elseif _stary$"X"
  @ _wie,_kol get _nowy picture "@! A" when TYP_INFO()
endi
set cursor on; read ; set cursor off
if lastkey()=K_ESC; _nowy:=_stary; endi

if !_nowy==_stary
  repl TYP with _nowy
  if TYP="W"; repl PRYWATNE with "T"; endi
  if TYP="A"; repl PRYWATNE with " "; endi
endi
devpos(_wie,_kol)
CPSwiezyRekord()
RETURN .F.

*******************************************************************************
FUNCTION TYP_INFO()
QKE(;
  "Dozwolone wartoci: A - aktywny, W - wasny, Z - zamknity, X - skasowany",;
  "Dozwolone zamiany:  A na Z lub X,  W na A, Z lub X,  Z na X,  X bez zmian")
RETURN .F.

*******************************************************************************
FUNCTION ESL_CRM()                                                   //23.08.18
local _tex:='۲  EDYCJA SOWNIKA ZDARZE MODUU CRM  '

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use(_gdzie_lap+"SL_CRM","S"); BREAK; endi                     //23.08.18
set index to (_gdzie_lap+"SL_CRM_N"),;         //NR
             (_gdzie_lap+"SL_CRM_O")           //OPERACJA

go top
CPEDIT  POZ: 1,,23,               ;
        DEF: "SL_CRM"             ;
        POZWER: "V1"              ;
        PION: ,,,                 ;
        INDEXY: {"nr","operacja"} ;
        EDYCJA: .T. ;
        DODAWANIE: .T.            ;
        KASOWANIE: empty(OPERACJA).or.HA("BAFPOL")   ;
        SIEC: REKORD              ;
        ODTWORZ:.f.

dbeval({|| if(rlock(),(dbdelete(),dbunlock()),NIL)},{|| empty(OPERACJA)})

go top
CPDRUK  DEF: "SL_CRM"               ;
        WERSJA: "V1"              ;
        TYTUL: "SOWNIK OPERACJI CRM";
        WARIANT: 4

END SEQUENCE
close data
RETURN NIL

*******************************************************************************
FUNCTION ECRM()                                                      //23.08.18
local _tex:='۲  EDYCJA DANYCH MODUU CRM (Customer Relationship Management)  '
                                           
local _astru:={},_wybor:=0, _err:=.f.

priv _data_ope:=date(),_nazwa_kon:="", _miasto:="",_adres:="",;
     _konto:=_konto_ph,_nr_kon:=spac(5),_nr_rec, _ktory_rekord:=0,_arch:=.f.
priv _kat_kon:=_gdzie_fir                                            //23.08.18

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use(_kat_kon+"FIRMY","R","KON"); BREAK; endi                    //23.08.18
set index to (_kat_kon+"FIRMY_NR"), (_kat_kon+"FIRMY_NA"),;
             (_kat_kon+"FIRMY_NI"), (_kat_kon+"FIRMY_AD")

sele 0
if !_use("SL_KONT","S"); BREAK; endi
set index to SL_KONT

sele 0
if !_use(_gdzie_lap+"SL_CRM","S"); BREAK; endi
set index to (_gdzie_lap+"SL_CRM_N"),(_gdzie_lap+"SL_CRM_O")

sele 0
if !_use(_gdzie_lap+"CRM","S"); BREAK; endi  
set index to (_gdzie_lap+"CRM_PH"),;          //KONTO+dtos(DATA)
             (_gdzie_lap+"CRM_KO"),;          //NR_KON+dtos(DATA)
             (_gdzie_lap+"CRM_TY"),;          //TYP+dtos(DATA)
             (_gdzie_lap+"CRM_TE"),;          //TYP+dtos(TERMIN)+GODZ_T for KONTO=_konto_ph
             (_gdzie_lap+"CRM_KT")            //KONTO+TIMEDATE

set rela to NR_KON into KON
go bott
skip -10

CPEDIT POZ: 1,,18,       ;
       DEF: "CRM"        ;
       POZWER: "V1"      ;
       POZSLAD: SLAD_CRM() ;   
       PION: ,,,         ;
       INDEXY: {"konto i data","firma i data",;
                "typ i data","typ i termin","termin"} ;
       EDYCJA: TYP$" W".or.CPNazwa()="TYP" ;
       DODAWANIE: .T.    ;
       CZYDODAC: QTN("Nowy wiersz ?").and.NOWY_CRM() ;
       KASOWANIE: TYP$" W";
       KOLORUJ: KOLORY_CRM() ;
       AKCJA: AKC_CRM()  ;
       ODTWORZ: .f.      ;
       SIEC: REKORD

@ 18,0 clea to 24,79

dbsetorder(3)
if dbseek(" ")
  loca for empty(OPERACJA) while TYP=" "
  if found().and.HorizMenu(24,0,"Skasowa wiersze z nieokrelon operacj ?",;
                                                         {"TAK","NIE"},2)=1
     do while TYP=" ".and.!eof()
       if empty(OPERACJA).and.rlock(); dbdelete(); dbunlock(); endi
       skip
     endd
  endi
endi

dbsetorder(3)
if dbseek(" ")
  if found().and.;
     HorizMenu(24,0,"Oznaczy operacje z nieokrelonym typem jako aktywne ?",;
              {"TAK","NIE"},2)=1
     do while !eof()
       dbseek(" ")
       if found()
         if rlock()
           repl TYP with "A"; dbunlock()
         else
           exit
         endi
       endi
     endd    
  endi
endi

ALERT_CRM()

END SEQUENCE
close data


RETURN NIL

*******************************************************************************
FUNCTION NOWY_CRM()                                                  //23.08.18
if empty(DATA).and.!eof()
  RETURN .F.
endi
RETURN .T.

*******************************************************************************
FUNCTION KOLORY_CRM()
local _ret:={1,2}

if KONTO==_konto_ph.and.!TYP$"ZX".and.!empty(TERMIN)
  do case
    case TERMIN=date()+1 ; _ret:={12,2}
    case TERMIN=date()   ; _ret:={11,2}  
    case TERMIN<date()   ; _ret:={9,2}
  endc
endi

/*
   _ret:={11,2}          //ty
   _ret:={9,2}           //czerwony                
   _ret:={10,2}          //magenta                
   _ret:={12,2}          //niebieski
   _ret:={1,2}           //zwyky    
*/
RETURN _ret

*******************************************************************************
FUNCTION KOLORY_POZ()
RETURN if(NR=0,{12,2},{1,2})

*******************************************************************************
FUNCTION SLAD_CRM(_edycja)
loca _l:=0

DEFAULT _edycja TO .T.

@ 18,0,23,79 BOX B_DOUBLE
@ 19,1 clea to 22,78
@ 18,0  say chr(204)
@ 18,79 say chr(185)

if _edycja.and.TYP$" W"
  @ 23,4 say " Spacja - edycja "
else
  @ 23,4 say " Spacja - odczyt "
endi

_l:=mlcount(OPIS,75)
if _l>4
  @ 23,73 say "(+)"
else
  @ 23,73 say repl(chr(205),3)
endi
keyboard chr(K_ESC)
MEMOEDIT(OPIS,19,2,22,77,.f.)
* set curs off
if empty(NR_KON)
  RETURN spac(76)
endi
RETURN " "+padr(rtrim(KON->NAZWA_KON)+", "+alltrim(KON->MIASTO)+;
           if(empty(KON->ADRES),"",", "+KON->ADRES),76)

*******************************************************************************
FUNCTION OPE()
loca _row:=row(),_col:=col(),_rek:=recn()
if empty(DATA)
  repl DATA with date()
endi
if empty(TIMEDATE)
  repl TIMEDATE with subs(dtos(date()),3,6)+subs(strtran(time(),":"),1,6)
endi
repl OPERATOR with _operator,;
     KONTO with if(empty(_konto_ph),"00000",_konto_ph)
dbgoto(_rek)
CPSwiezyRekord()
RETURN .T.

*******************************************************************************
FUNCTION AKC_CRM(_edycja)
loca _ocolor:=setcolor(),_sel:=select(),getlist:={}

DEFAULT _edycja TO .T.

if lastkey()<>K_SPACE
  RETURN NIL
endi

BEGIN SEQUENCE
 
if lastkey()=K_SPACE.and.rlock().and.!empty(CRM->OPERACJA)

  _edycja:=_edycja.and.CRM->TYP$" W"
  
  tone(880,0.5)
  if _edycja
    @ 23,4 say  " Ctrl W - zapis "+repl(chr(205),14)
    @ 23,58 say " Esc - rezygnacja "
  else
    @ 23,4 say repl(chr(205),30)
    @ 23,58 say " Esc - koniec"
  endi

  set curs on
  repl OPIS with MEMOEDIT(OPIS,19,2,22,77,_edycja)
  set curs off
  @ 23,4 say repl(chr(205),74)
  if _edycja
    @ 23,4 say " Spacja - edycja "
  else
    @ 23,4 say " Spacja - odczyt "
  endi
  tone(440,0.5)
  dbunlock()
endi

  
END SEQUENCE

sele (_sel)
setcolor(_ocolor)

RETURN NIL

*******************************************************************************
FUNCTION WE_DATA()
if empty(DATA).or.TYP=" "; RETURN .T.
elseif TYP=" "; RETURN QTN("Zmiana daty ?")
endi
RETURN .F.

*******************************************************************************
FUNCTION WAR_DATA()
if DATA<date()-7
  QK("Dozwolone daty po "+dtoc(date()-8))
endi
RETURN .T.

*******************************************************************************
FUNCTION LINIA_CRM()
RETURN padr(MEMOLINE(OPIS,76),76)

*******************************************************************************
FUNCTION RET2()
cls
QKE("Opcja w opracowaniu")
RETURN NIL

*******************************************************************************
FUNCTION ALERT_CRM()
loca _sel:=sele()

_alert_crm:=0

if !file(_gdzie_lap+"CRM_TY.NTX"); RETURN NIL; endi                  //23.08.18


sele select("CRM")                                                  //23.08.18
if !_use(_gdzie_lap+"CRM","S"); BREAK; endi                         //23.08.18
set index to (_gdzie_lap+"CRM_PH"),;          //KONTO+dtos(DATA)
             (_gdzie_lap+"CRM_KO"),;          //NR_KON+dtos(DATA)
             (_gdzie_lap+"CRM_TY"),;          //TYP+dtos(DATA)
             (_gdzie_lap+"CRM_TE"),;          //TYP+dtos(TERMIN)+GODZ_T for KONTO=_konto_ph
             (_gdzie_lap+"CRM_KT")            //KONTO+TIMEDATE
set order to 4

dbseek("A20000101",.t.)
if TYP="A".and.!empty(TERMIN).and.TERMIN<date(); _alert_crm:=3; endi
dbseek("W20000101",.t.)
if TYP="W".and.!empty(TERMIN).and.TERMIN<date(); _alert_crm:=3; endi

dbseek("A"+dtos(date()))
if _alert_crm=0.and.TYP="A".and.TERMIN=date(); _alert_crm:=2; endi
dbseek("W"+dtos(date()))
if _alert_crm=0.and.TYP="W".and.TERMIN=date(); _alert_crm:=2; endi

dbseek("A"+dtos(date()+1))
if _alert_crm=0.and.TYP="A".and.TERMIN=date()+1; _alert_crm:=1; endi
dbseek("W"+dtos(date()+1))
if _alert_crm=0.and.TYP="W".and.TERMIN=date()+1; _alert_crm:=1; endi

CPClose(ALERT)

sele (_sel)
RETURN NIL

*******************************************************************************
FUNCTION DISP_CRM()
local _ocolor:=SETCOLOR(),_w:=4, _k:=42

if _alert_crm>0
  do case
    case _alert_crm=3; setcolor("R/N+")
    case _alert_crm=2; setcolor("GR+/N+")
    case _alert_crm=1; setcolor("B/N+")
  endc
  @ _w,_k+4 say "CRM"
  setcolor(_ocolor)
else
  @ _w,_k+4 say ""
endi

RETURN NIL

*******************************************************************************
FUNCTION PCRM(_auto)                       
local _tex:='۲  PRZEGLDANIE DANYCH MODUU CRM  '
local _astru:={},_wybor:=0, _err:=.f.
loca _ocolor:=SETCOLOR(),_sel:=sele(),_okno:=savescreen(0,0,24,79)

priv _data_od:=date()-14,_data_do:=date()
priv _data_ope:=date(),_nazwa_kon:="", _miasto:="",_adres:="",;
     _nr_rec, _ktory_rekord:=0,_arch:=.f.
priv _konto:=spac(5),_nr_kon:=spac(5),_operacja:=spac(38),_war:=".t."
priv _kat_kon:=_gdzie_fir                                            //23.08.18

DEFAULT _auto TO .f.

BEGIN SEQUENCE

sele 0
if file(_gdzie_lap+"CRM_TY.NTX").and._use("EDIT","E")                //23.08.18
  index on BAZA to EDIT
  use
else
  BREAK
endi

if _auto.and._alert_crm=0; BREAK; endi

cls
if !_auto
  @ 0,0 say _tex
else
  @ 0,0 say '۲  WPISY MODUU CRM WYMAGAJCE UWAGI  '
  @ 1,0 say "Dane dla konta "+_konto_ph+;
            " przeterminowane i z terminem do dnia "+dtoc(date()+1)+":"
endi


if !_use(_kat_kon+"FIRMY","R","KON"); BREAK; endi                    //23.08.18
set index to (_kat_kon+"FIRMY_NR"), (_kat_kon+"FIRMY_NA"),;
             (_kat_kon+"FIRMY_NI"), (_kat_kon+"FIRMY_AD")


sele 0
if !_use("SL_KONT","S"); BREAK; endi
set index to SL_KONT

sele 0
if !_use(_gdzie_lap+"SL_CRM","S"); BREAK; endi                       //23.08.18
set index to (_gdzie_lap+"SL_CRM_N"),;         //NR 
             (_gdzie_lap+"SL_CRM_O")           //OPERACJA


sele 0
if !_use(_gdzie_lap+"CRM","S"); BREAK; endi                         //23.08.18
set index to (_gdzie_lap+"CRM_PH"),;          //KONTO+dtos(DATA)
             (_gdzie_lap+"CRM_KO"),;          //NR_KON+dtos(DATA)
             (_gdzie_lap+"CRM_TY"),;          //TYP+dtos(DATA)
             (_gdzie_lap+"CRM_TE"),;          //TYP+dtos(TERMIN)+GODZ_T for KONTO=_konto_ph
             (_gdzie_lap+"CRM_KT")            //KONTO+TIMEDATE
set rela to NR_KON into KON

if !_auto
  _wybor:=HorizMenu(1,0,"Operacje : ",{"PILNE","AKTYWNE","WSZYSTKIE"},1)
else
  _wybor:=1
endi

if _wybor=0; BREAK; endi

_konto :=spac(5)
_nr_kon:=spac(5)
_operacja:=spac(38)
_war:=".t."

if _wybor=2.or._wybor=3

  @ 1,40 say "Konto :" get _konto pict "@K 99999";
        when SLGET("SL_KONT","SL_KONT","V1",1,1,{"konto"},,.f.);
        vali (empty(_konto).or.SZ().and.SL("SL_KONT","SL_KONT","V1",1,1));
             .and.SLGET().and.if(SL_KONT->(dbseek(_konto)),;
                        (devpos(1,54),devout(SL_KONT->OPIS_KONTA),.t.),.t.) 

  @ 2,0 say "Okres :" get _data_od vali _data_od<=date()
  @ 2,col()+1 say "-" get _data_do vali _data_od<=_data_do

  @ 2,29 say "Operacja :" get _operacja pict "@!K "+repl("X",38);
        when SLGET("SL_CRM","SL_CRM","V1",2,1,{"nr","operacja"},,.f.);
        vali (empty(_operacja).or.EXIST(_operacja,"SL_CRM",2)).and.SLGET()

  @ 3,0 say "Firma :" get _nr_kon pict "@K N9999";
        when SLGET("KON","KON","V1",1,1,{"numer","nazwa","NIP","adres"},,.f.);
        vali (empty(_nr_kon).or.SL("KON","KON","V1",1,1)).and.SLGET() 
 
  set curs on; read; set curs off
  if lastkey()=K_ESC; BREAK; endi

  KON->(dbseek(_nr_kon))
  if KON->(found()); @ 3,15 say KON->NAZWA_KON; endi

  _war:="DATA>=_data_od.and.DATA<=_data_do"
  if !_nr_kon=spac(5);  _war:=_war+".and.NR_KON=_nr_kon"; endi
  if !_konto =spac(5);  _war:=_war+".and.KONTO =_konto"; endi
  if !empty(_operacja); _war:=_war+".and.OPERACJA=_operacja"; endi
endi
_bwar:=COMPILE(_war)

if _wybor<>3

  if _wybor=1
    set order to 4
    dbseek("A20000101",.t.)
    copy to (_sc+"CRM_A") while TYP="A" for TERMIN<=date()+1
    dbseek("W20000101",.t.)
    copy to (_sc+"CRM_W") while TYP="W" for TERMIN<=date()+1

  elseif _wybor=2

    set order to 3
    dbseek("A")  
    copy to (_sc+"CRM_A") while TYP="A" for Eval(_bwar)  
  
    dbseek("W")
    copy to (_sc+"CRM_W") while TYP="W" for Eval(_bwar)
  endi

  close CRM

  sele 0
  _use(_sc+"CRM_A","E!","CRM")
  appe from (_sc+"CRM_W")
  index on KONTO+dtos(DATA)     to (_sc+"CRM_PH")
  index on NR_KON+dtos(DATA)    to (_sc+"CRM_KO")
  index on TYP+dtos(DATA)       to (_sc+"CRM_TY")
  index on TYP+dtos(TERMIN)     to (_sc+"CRM_TE") for KONTO=_konto_ph
  index on KONTO+TIMEDATE       to (_sc+"CRM_KT")
  set index to (_sc+"CRM_PH"),;          //KONTO+dtos(DATA)
               (_sc+"CRM_KO"),;          //NR_KON+dtos(DATA)
               (_sc+"CRM_TY"),;          //TYP+dtos(DATA)
               (_sc+"CRM_TE"),;          //TYP+dtos(TERMIN)+GODZ_T for KONTO=_konto_ph
               (_sc+"CRM_KT")            //KONTO+TIMEDATE
  set rela to NR_KON into KON
else
  set filt to Eval(_bwar)
endi

sele CRM

if _wybor=1
  dbsetorder(4)
else
  dbsetorder(3)
endi

go top
CPEDIT POZ: 2+if(_wybor=1,0,2),,18,           ;
       DEF: "iCRM"       ;
       POZWER: "V1"      ;
       POZSLAD: SLAD_CRM(.f.) ;
       PION: ,,,         ;
       INDEXY: {"konto i data","firma i data",;
                "typ i data","typ i termin","termin"} ;
       KOLORUJ: KOLORY_CRM() ;
       AKCJA: AKC_CRM(.f.) ;
       ODTWORZ: .f.  

@ 18,0 clea to 24,79

if _auto; BREAK; endi

if len(_zaznaczone)>0
  set filter to ascan(_zaznaczone,recn())>0
endif
go top
CPDRUK  DEF: "CRM"                   ;
        WERSJA: "VR"                 ;
        TYTUL: "WPISY MODUU CRM" ;
        WARIANT: 2         

END SEQUENCE
close data
setcolor(_ocolor)
sele (_sel)

if _auto
  restscreen(0,0,24,79,_okno)
endi

RETURN NIL

*******************************************************************************
FUNCTION GODZ_OK()
if GODZ_T="  :  "; repl GODZ_T with "     "; endi
if empty(GODZ_T).or.GODZ_T="  :  "; RETURN .T.; endi
if !empty(subs(GODZ_T,1,3)).and.empty(subs(GODZ_T,4,2))
  repl GODZ_T with subs(GODZ_T,1,3)+"00"
endi
RETURN subs(GODZ_T,3,1)=":";
                        .and.subs(GODZ_T,1,2)>="00".and.subs(GODZ_T,1,2)<="23";
                        .and.subs(GODZ_T,4,2)>="00".and.subs(GODZ_T,4,2)<="59"

*******************************************************************************
FUNCTION KONTO_OK()
RETURN empty(KONTO).or.!" "$KONTO.and.subs(KONTO,1,3)="000".and.;
       subs(KONTO,4,2)>="00".and.;
       subs(KONTO,4,2)<="25"         //ze wzgldu na CRM i numery firm wlasnych
                                     //od A do Z

*******************************************************************************
FUNCTION KON_TMP()
local _k:=asc(subs(NR_KON,1,1))
RETURN _k>=65.and._k<=90.or.chr(_k)=" "

*******************************************************************************
FUNCTION DAJ_TMP(_sr)
local _or:=indexord(),_re:=recn(),_nr:=spac(5)

DEFAULT _sr TO .f.

if subs(NR_KON,1,1)=" "
  KON->(dbsetorder(1))
  KON->(dbseek(chr(asc(_ckon)+1),.t.))
  KON->(dbskip(-1))
  if subs(KON->NR_KON,1,1)=_ckon
    _nr:=_ckon+trans0(val(subs(KON->NR_KON,2,4))+1,4)
  else
    _nr:=_ckon+"0001"
  endi
  KON->(dbgoto(_re))
  KON->(dbsetorder(_or))
  repl NR_KON with _nr
endi
if subs(NR_KON,1,1)=_ckon
  repl NR_KON with _ckon+trans0(val(subs(NR_KON,2,4)),4)
endi
if val(subs(NR_KON,1,1))>0
  repl NR_KON with trans0(val(NR_KON),5)
endi
if _sr
  CPSwiezyRekord()
endi
RETURN .T.

*******************************************************************************
FUNCTION EXPORT_CRM()
local _tex:='۲  EKSPORT DANYCH MODUU CRM  ',_exp,_astru:={}
priv _konto:=_konto_ph
priv _data_od:=date()-14,_data_do:=date()
priv _kat_dan:=alltrim(_gdzie_dan)
priv _kat_kon:=alltrim(_gdzie_fir)                                   //23.08.18

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use(_kat_kon+"FIRMY","R","KON"); BREAK; endi                    //23.08.18
set index to (_kat_kon+"FIRMY_NR"), (_kat_kon+"FIRMY_NA"),;
             (_kat_kon+"FIRMY_NI"), (_kat_kon+"FIRMY_AD")

sele 0
if !_use("SL_KONT","R"); BREAK; endif
set index to ("SL_KONT")

@ 1,0 say "Dane z okresu :" get _data_od vali _data_od<=date()
@ 1,col()+1 say "-" get _data_do vali _data_od<=_data_do

if val(_konto_ph)=0
    _konto:=spac(5)
    @ 2,0 say "Dane dla przedstawiciela :" get _konto pict "@K 99999";
          when SLGET("SL_KONT","SL_KONT","V1",1,1,{"konto"},,.f.);
          vali SZ().and.SL("SL_KONT","SL_KONT","V1",1,1).and.SLGET() 
    APOSTROF()
else
  _konto="00000"
endi

set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi


_astru:={}
aadd(_astru,{"DATA      ","D",8,0})
aadd(_astru,{"TIMEDATE  ","C",12,0})
aadd(_astru,{"KONTO     ","C",5,0})
aadd(_astru,{"OPERACJA  ","C",38,0})
aadd(_astru,{"OPIS      ","M",10,0})
aadd(_astru,{"TERMIN    ","D",8,0})
aadd(_astru,{"GODZ_T    ","C",5,0})
aadd(_astru,{"NR_KON    ","C",5,0})
aadd(_astru,{"TYP       ","C",1,0})
aadd(_astru,{"ADRESAT   ","C",5,0})
aadd(_astru,{"PRYWATNE  ","C",1,0})
aadd(_astru,{"OPERATOR  ","C",3,0})

aadd(_astru,{"ID_KON    ","C",15,0})    //dla centrali i firm PH
aadd(_astru,{"NAZWA_KON ","C",60,0})
aadd(_astru,{"NAZWA_KON2","C",60,0})
aadd(_astru,{"KOD       ","C",6,0})
aadd(_astru,{"MIASTO    ","C",20,0})
aadd(_astru,{"ADRES     ","C",30,0})
aadd(_astru,{"TELEFON   ","C",36,0})
aadd(_astru,{"UWAGI     ","C",74,0})
aadd(_astru,{"SZEF      ","C",36,0})
aadd(_astru,{"PRACOWNIK ","C",36,0})
aadd(_astru,{"MAIL      ","C",36,0})

dbcreate(_kat_dan+NCRM(_konto_ph,_konto)+".DBF",_astru)              //01.09.15

sele 0
if !_use(_gdzie_lap+"CRM","R"); BREAK; endi
set index to (_gdzie_lap+"CRM_TY")  //TYP+dtos(DATA)


dbseek("A"+dtos(_data_od),.t.)
copy to (_sc+"CRM_TYPA") while DATA<=_data_do.and.TYP="A" for WAR_EXP()

dbseek("Z"+dtos(_data_od),.t.)
copy to (_sc+"CRM_TYPZ") while DATA<=_data_do.and.TYP="Z" for WAR_EXP()

dbseek("X"+dtos(_data_od),.t.)
copy to (_sc+"CRM_TYPX") while DATA<=_data_do.and.TYP="X" for WAR_EXP()


sele 0
if !_use(_kat_dan+NCRM(_konto_ph,_konto)+".DBF","E"); BREAK; endif
appe from (_sc+"CRM_TYPA")
appe from (_sc+"CRM_TYPZ")
appe from (_sc+"CRM_TYPX")
set rela to NR_KON into KON
set filt to val(NR_KON)=0.and.!empty(NR_KON)

repl all ID_KON     with KON->ID_KON,;
         NAZWA_KON  with KON->NAZWA_KON,;
         NAZWA_KON2 with KON->NAZWA_KON2,;
         KOD        with KON->KOD,;
         MIASTO     with KON->MIASTO,;
         ADRES      with KON->ADRES,;
         TELEFON    with KON->TELEFON,;
         UWAGI      with KON->UWAGI
use
CPClose(KON)



_exp:=HorizMenu(24,0,"Eksport danych CRM :",;
                     {"FTP","E-MAIL","FTP i E-MAIL","KONIEC"},1)

@ 24,0

if _exp=3.or._exp=1

  *------------------------------------------------------- wersja z ftp windows
  _plik:=fcreate("fsentc.bat")
  fwriteln(_plik,"cls")
  fwriteln(_plik,"ftp -s:fsentc.scr")
  fclose(_plik)

  _plik:=fcreate("fsentc.scr")
  fwriteln(_plik,"open "+_ftp_open)
  fwriteln(_plik,_ftp_login)
  fwriteln(_plik,_ftp_pass)
  fwriteln(_plik,"cd "+_ftp_path)
  fwriteln(_plik,"cd DANE_"+trans0(val(if(val(_konto_ph)=0,_konto,;
                                                           _konto_ph)),2))
  fwriteln(_plik,"binary")
  fwriteln(_plik,"put "+_kat_dan+NCRM(_konto_ph,_konto)+".DBF")
  fwriteln(_plik,"binary")
  fwriteln(_plik,"put "+_kat_dan+NCRM(_konto_ph,_konto)+".DBT")
  fwriteln(_plik,"quit")
  fclose(_plik)

//  SWPRUNCMD("cmd <fsentc.bat",0,"","")
  RUN  fsentc.bat        //xHB

  dele file fsentc.scr
  *----------------------------------------------------------------------------

/* wersja xHB z KONCEPT_FTP(1)                                            //xhb
   KONCEPT_FTP(1)      
*/

  inkey(2)
  tone(880,1)
  K_OFF()
  cls
endi



if _exp=3.or._exp=2

  _plik:=fcreate("mailc.txt")
  fwriteln(_plik,"Dane :  "+NCRM(_konto_ph,_konto))
  fwriteln(_plik,"Okres : "+dtoc(_data_od)+" - "+dtoc(_data_do))
  fwriteln(_plik,'Zalaczniki nalezy zapisac do folderu '+_kat_dan)
  fclose(_plik)

  if empty(_mail_se)
    _cmd:='smtpsend -f'+_mail_from+' -t'+_mail_ce+;
    ' -h'+_mail_host+' -p'+_mail_port+' -imailz.txt -lu'+_mail_user+;
    ' -lp'+_mail_pass+' -a'+_kat_dan+NCRM(_konto_ph,_konto)+".DBF"+;
                      ' -a'+_kat_dan+NCRM(_konto_ph,_konto)+".DBT"+;
    ' -sDane '+NCRM(_konto_ph,_konto)
  else
    _cmd:='smtpsend -f'+_mail_from+' -t'+_mail_ce+' -t'+_mail_se+;
    ' -h'+_mail_host+' -p'+_mail_port+' -imailz.txt -lu'+_mail_user+;
    ' -lp'+_mail_pass+' -a'+_kat_dan+NCRM(_konto_ph,_konto)+".DBF"+;
                      ' -a'+_kat_dan+NCRM(_konto_ph,_konto)+".DBT"+;
    ' -sDane '+NCRM(_konto_ph,_konto)
  endi
  _plik:=fcreate("msentc.bat")
  fwriteln(_plik,"cls")
  fwriteln(_plik,_cmd)
  fclose(_plik)

//  SWPRUNCMD("cmd <msentc.bat",0,"","")
  RUN msentc.bat      
 
//  dele file msentc.bat                                             //23.02.18

  clear typeahead
  inkey(3)
  tone(880,2)
  cls
  K_OFF()
endi

inkey(0.5)   //kasuje bufor klawiatury

END SEQUENCE
RETURN NIL

*******************************************************************************
FUNCTION WAR_EXP()
if val(_konto_ph)>0
  RETURN !PRYWATNE="T".and.;
       (KONTO=_konto_ph.or.!empty(ADRESAT).and.!ADRESAT==_konto_ph)
endi
RETURN !PRYWATNE="T".and.KONTO=_konto_ph.and.ADRESAT=_konto

*******************************************************************************
FUNCTION INDEX_CRM()

loca _tex:='۲  SORTOWANIE PLIKW CRM  '

cls
@ 0,0 say _tex

_total:=2
PASEK(,,'')

if QTN("Sortowanie plikw CRM ?")

  sele 0
  _use(_gdzie_lap+"CRM","E!")                                                     //08.09.12
  if _priorytet=9; @ 23,0 say "CRM"+spac(12); endi
  inkey(0.2)
  pack
  index on KONTO+dtos(DATA)        to (_gdzie_lap+"CRM_PH")
  index on NR_KON+dtos(DATA)       to (_gdzie_lap+"CRM_KO")
  index on TYP+dtos(DATA)          to (_gdzie_lap+"CRM_TY")
  index on TYP+dtos(TERMIN)+GODZ_T to (_gdzie_lap+"CRM_TE") for KONTO=_konto_ph
  index on KONTO+TIMEDATE          to (_gdzie_lap+"CRM_KT")
  PASEK(1,,"")
  STOP_SORT()

  _use(_gdzie_lap+"SL_CRM","E!")                                                //08.09.12
  if _priorytet=9; @ 23,0 say "SL_CRM"+spac(12); endi
  inkey(0.2)
  pack
  index on NR       to (_gdzie_lap+"SL_CRM_N")
  index on OPERACJA to (_gdzie_lap+"SL_CRM_O")
  * PASEK(1,,"")
  STOP_SORT()

endi
CLOS DATA
RETURN NIL

*******************************************************************************
FUNCTION HCRM(_firma)                       
local _tex:='۲  HISTORIA KONTAKTW Z KLIENTEM  '
local _wybor:=0, _err:=.f.
loca _ocolor:=SETCOLOR(),_sel:=sele(),_okno:=savescreen(0,0,24,79)
priv _data_od:=ctod(""),_data_do:=date()
priv _nazwa_kon:="", _miasto:="",_adres:=""
priv _konto:=spac(5),_nr_kon:=spac(5),_operacja:=spac(38)
priv _nag_poz:=;
  "Data      Opis                                           Termin          PH"

priv _kat_kon:=_gdzie_fir                                            //23.08.18

DEFAULT _firma TO spac(5)

BEGIN SEQUENCE

if empty(_firma)
  cls
  @ 0,0 say _tex
endi

sele sele("KON_CRM")                                                 //23.08.18
if !_use(_kat_kon+"FIRMY","R","KON_CRM"); BREAK; endi                
set index to (_kat_kon+"FIRMY_NR"), (_kat_kon+"FIRMY_NA"),;
             (_kat_kon+"FIRMY_NI"), (_kat_kon+"FIRMY_AD")

sele sele("SLK_CRM")
if !_use("SL_KONT","R","SLK_CRM"); BREAK; endi
set index to SL_KONT

sele sele("SLO_CRM")
if !_use(_gdzie_lap+"SL_CRM","R","SLO_CRM"); BREAK; endi
set index to (_gdzie_lap+"SL_CRM_N"), (_gdzie_lap+"SL_CRM_O")

sele sele("CRM_CRM")
if !_use(_gdzie_lap+"CRM","R","CRM_CRM"); BREAK; endi
set index to (_gdzie_lap+"CRM_PH"),;          //KONTO+dtos(DATA)
             (_gdzie_lap+"CRM_KO"),;          //NR_KON+dtos(DATA)
             (_gdzie_lap+"CRM_TY"),;          //TYP+dtos(DATA)
             (_gdzie_lap+"CRM_TE"),;          //TYP+dtos(TERMIN)+GODZ_T for KONTO=_konto_ph
             (_gdzie_lap+"CRM_KT")            //KONTO+TIMEDATE
* set rela to NR_KON into KON

_konto :=spac(5)
_nr_kon:=_firma
_operacja:=spac(38)
_war:=".t."

if empty(_firma)

  @ 1,0 say "Firma :" get _nr_kon pict "@!K N9999";
        when SLGET("KON_CRM","KON","V1",1,1,{"numer","nazwa","NIP","adres"},,.f.);
        vali SK().and.SL("KON_CRM","KON","V1",1,1).and.SLGET()       //22.10.12
  set curs on; read; set curs off
  if lastkey()=K_ESC; BREAK; endi

  KON_CRM->(dbseek(_nr_kon))
  if KON_CRM->(found())
    @ 1,15 say padr(KON_CRM->NAZWA_KON,36)
    _nazwa_kon:=alltrim(KON_CRM->NAZWA_KON)
    _miasto   :=alltrim(KON_CRM->MIASTO)
    _adres    :=alltrim(KON_CRM->ADRES)
  endi

  @ 1,53 say "Okres :" get _data_od vali _data_od<=date()
  @ 1,col()+1 say "-" get _data_do vali _data_od<=_data_do

  @ 2,0 say "Konto :" get _konto pict "@K 99999";
        when SLGET("SLK_CRM","SL_KONT","V1",1,1,{"konto"},,.f.);
        vali (empty(_konto).or.SZ().and.SL("SLK_CRM","SL_KONT","V1",1,1));
             .and.SLGET().and.if(SLK_CRM->(dbseek(_konto)),;
                       (devpos(2,15),devout(SLK_CRM->OPIS_KONTA),.t.),.t.) 
  set curs on; read; set curs off
  if lastkey()=K_ESC; BREAK; endi

  @ 2,42 get _operacja pict "@!K "+repl("X",38);
        when SLGET("SLO_CRM","SL_CRM","V1",2,1,{"nr","operacja"},,.f.);
        vali (empty(_operacja).or.EXIST(_operacja,"SLO_CRM",2)).and.SLGET()
 
  set curs on; read; set curs off
  if lastkey()=K_ESC; BREAK; endi
else
  KON_CRM->(dbseek(_firma))
  if KON_CRM->(found())
    @ 1,15 say padr(KON_CRM->NAZWA_KON,36)
    _nazwa_kon:=alltrim(KON_CRM->NAZWA_KON)
    _miasto   :=alltrim(KON_CRM->MIASTO)
    _adres    :=alltrim(KON_CRM->ADRES)
  endi
endi

POZ_CRM(_nr_kon,_data_od,_data_do,_konto,_operacja)

sele POZ_CRM
index on dtos(DATA)+TIMEDATE+str(NR,3)          to (_sc+"CRM_DA")
index on KONTO+dtos(DATA)+TIMEDATE+str(NR,3)    to (_sc+"CRM_PH")
index on OPERACJA+dtos(DATA)+TIMEDATE+str(NR,3) to (_sc+"CRM_OP")
set index to (_sc+"CRM_DA"),(_sc+"CRM_PH"),(_sc+"CRM_OP")
set rela to KONTO into SLK_CRM

if !empty(_firma)
 setcolor(_edit_blo)
 @ 0,0
 @ 0,2 say padc(alltrim(_nazwa_kon)+;
           if(!empty(_miasto),", "+alltrim(_miasto),"")+;
           if(!empty(_adres),", "+alltrim(_adres),""),77)
endi

go top
CPEDIT POZ: if(empty(_firma),3,1),,if(empty(_firma),23,24), ;
       DEF: "iCRM"       ;
       POZWER: "V2"      ;
       PION: ,,,         ;
       INDEXY: {"data","konto","operacja"} ;
       KOLORUJ: KOLORY_POZ() ;
       ODTWORZ: .f.  
//     POZSLAD: SLAD_POZ() ;

if empty(_firma)
  if len(_zaznaczone)>0
    set filter to ascan(_zaznaczone,recn())>0
  endif
  go top
  CPDRUK  DEF: "CRM"                   ;
          WERSJA: "VR"                 ;
          TYTUL: "HISTORIA KONTAKTW Z FIRM "+_nr_kon+" "+_nazwa_kon ;
          WARIANT: 2         
endi

END SEQUENCE

CPClose(KON_CRM)
CPClose(SLK_CRM)
CPClose(SLO_CRM)
CPClose(CRM_CRM)
*CPClose(POZ_CRM)

setcolor(_ocolor)

sele (_sel)
if !empty(_firma)
  restscreen(0,0,24,79,_okno)
endi

RETURN NIL

*******************************************************************************
FUNCTION SLAD_POZ()
RETURN padr(" "+if(empty(DATA),spac(8),dtoc(DATA))+" "+OPERACJA+"    "+;
       SLK_CRM->OPIS_KONTA,77)

*******************************************************************************
FUNCTION POZ_CRM(_nr_kon,_data_od,_data_do,_konto,_operacja)
loca _astru:={},_sel:=select(),_war:=".t.",_linia:="",;
     _re_crm:=CRM_CRM->(recn()),_or_crm:=CRM_CRM->(indexord())

BEGIN SEQUENCE

CPClose(POZ_CRM)

sele 0
_astru:={}
aadd(_astru,{"DATA      ","D",8,0})
aadd(_astru,{"LINIA     ","C",76,0})
aadd(_astru,{"KONTO     ","C",5,0})
aadd(_astru,{"OPERACJA  ","C",38,0})
aadd(_astru,{"TERMIN    ","D",8,0})
aadd(_astru,{"NR_KON    ","C",5,0})
aadd(_astru,{"TYP       ","C",1,0})
aadd(_astru,{"PRYWATNE  ","C",1,0})
aadd(_astru,{"ADRESAT   ","C",5,0})
aadd(_astru,{"NR        ","N",3,0})
aadd(_astru,{"TIMEDATE  ","C",12,0})
dbcreate(_sc+"POZ_CRM",_astru)

sele 0
_use(_sc+"POZ_CRM","E!")

_war:="DATA>=_data_od.and.DATA<=_data_do.and.TYP$'AZW'"
if !_konto =spac(5);  _war:=_war+".and.KONTO =_konto"; endi
if !empty(_operacja)
   _war:=_war+".and.alltrim(OPERACJA)=alltrim(_operacja)"
endi
_bwar:=COMPILE(_war)

sele CRM_CRM
dbsetorder(2)    //NR_KON+dtos(DATA)
dbseek(_nr_kon+dtos(_data_od),.t.)
do while NR_KON==_nr_kon.and.DATA<=_data_do.and.!eof()

  if !Eval(_bwar); skip; loop; endi

  POZ_CRM->(dbappend())
  POZ_CRM->NR        :=0
  POZ_CRM->DATA      :=CRM_CRM->DATA
  POZ_CRM->LINIA     :=CRM_CRM->(DTOC(DATA)+"  "+OPERACJA+spac(9)+;
                       if(empty(TERMIN),spac(14),dtoc(TERMIN)+" "+GODZ_T)+;
                       "  "+subs(KONTO,4,2))
  POZ_CRM->KONTO     :=CRM_CRM->KONTO
  POZ_CRM->OPERACJA  :=CRM_CRM->OPERACJA
  POZ_CRM->TERMIN    :=CRM_CRM->TERMIN
  POZ_CRM->NR_KON    :=CRM_CRM->NR_KON
  POZ_CRM->TYP       :=CRM_CRM->TYP
  POZ_CRM->ADRESAT   :=CRM_CRM->ADRESAT
  POZ_CRM->PRYWATNE  :=CRM_CRM->PRYWATNE
  POZ_CRM->TIMEDATE  :=CRM_CRM->TIMEDATE

  for _lp=1 to MLCOUNT(OPIS,76)
    _linia:=CRM_CRM->(MEMOLINE(OPIS,76,_lp))
    if !empty(_linia)
      POZ_CRM->(dbappend())
      POZ_CRM->NR        :=_lp
      POZ_CRM->DATA      :=CRM_CRM->DATA
      POZ_CRM->LINIA     :=_linia
      POZ_CRM->KONTO     :=CRM_CRM->KONTO
      POZ_CRM->OPERACJA  :=CRM_CRM->OPERACJA
      POZ_CRM->TIMEDATE  :=CRM_CRM->TIMEDATE
    endi
  next
  skip
endd

END SEQUENCE

sele (_sel)
CRM_CRM->(dbsetorder(_or_crm))
CRM_CRM->(dbgoto(_re_crm))
RETURN NIL

*******************************************************************************
FUNCTION CRM_TXT()
loca _tex:=;
     '۲  INSTRUKCJA OBSUGI MODUU CRM  ',;
     _portdru,_wybor
cls
@ 1,0 say _tex

TB_PLIK("crm.mem")

@ 24,0
_wybor:=HorizMenu(24,0,"WYDRUK :",{"LPT1","LPT2","LPT3","KONIEC"},4)
if _wybor=1.or._wybor=2.or._wybor=3
  _portdru:=if(_wybor=1,"LPT1",if(_wybor=2,"LPT2","LPT3"))
  DRUKUJ_PLIK("crm.mem",_portdru)
endi

RETURN NIL

*******************************************************************************
FUNCTION SK()     
local _s:=Eval(MemVarBlock(readvar()))
if val(_s)>0
  _s:=strtran(str(val(_s),len(_s))," ","0")
  Eval(MemVarBlock(readvar()),_s)
elseif val(_s)=0.and.val(subs(_s,2))>0
  _s:=subs(_s,1,1)+strtran(str(val(subs(_s,2)),len(subs(_s,2)))," ","0")
  Eval(MemVarBlock(readvar()),_s)
endi
RETURN .T.

*******************************************************************************
FUNCTION KCRM()                       
local _tex:='۲  KASOWANIE DANYCH MODUU CRM  '
local  _err:=.t.
local _sel:=sele()

priv _data_od:=ctod(""),_data_do:=ctod("")
priv _konto:=spac(5)
priv _kat_kon:=_gdzie_fir                                            //23.08.18

BEGIN SEQUENCE

cls
@ 0,0 say _tex

sele 0
if !_use(_kat_kon+"FIRMY","R","KON"); BREAK; endi                
set index to (_kat_kon+"FIRMY_NR"), (_kat_kon+"FIRMY_NA"),;
             (_kat_kon+"FIRMY_NI"), (_kat_kon+"FIRMY_AD")

sele 0
if !_use("SL_KONT","R"); BREAK; endi
set index to SL_KONT

sele 0
if !_use(_gdzie_lap+"CRM","E"); BREAK; endi                         //23.08.18
set index to (_gdzie_lap+"CRM_PH"),;          //KONTO+dtos(DATA)
             (_gdzie_lap+"CRM_KO"),;          //NR_KON+dtos(DATA)
             (_gdzie_lap+"CRM_TY"),;          //TYP+dtos(DATA)
             (_gdzie_lap+"CRM_TE"),;          //TYP+dtos(TERMIN)+GODZ_T for KONTO=_konto_ph
             (_gdzie_lap+"CRM_KT")            //KONTO+TIMEDATE
set rela to NR_KON into KON

@ 1,0 say "Konto :" get _konto pict "@K 99999";
        when SLGET("SL_KONT","SL_KONT","V1",1,1,{"konto"},,.f.);     //30.08.15
        vali (empty(_konto).or.SZ().and.SL("SL_KONT","SL_KONT","V1",1,1));
            .and.SLGET().and.if(SL_KONT->(dbseek(_konto)),;
                        (devpos(1,54),devout(SL_KONT->OPIS_KONTA),.t.),.t.) 
@ 2,0 say "Okres :" get _data_od vali _data_od<=date()
@ 2,col()+1 say "-" get _data_do vali _data_od<=_data_do

set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

sele CRM                                                             //30.08.15
if empty(_konto)
  set filt to DATA>=_data_od.and.DATA<=_data_do
else
  set filt to  KONTO==_konto.and.DATA>=_data_od.and.DATA<=_data_do
endi
go top
CPEDIT POZ: 3,,18,           ;
       DEF: "CRM"       ;
       POZWER: "V1"      ;
       POZSLAD: SLAD_CRM(.f.) ;
       PION: ,,,         ;
       INDEXY: {"konto i data","firma i data",;
                "typ i data","typ i termin","termin"} ;
       KOLORUJ: KOLORY_CRM() ;
       ODTWORZ: .f.  

//       AKCJA: AKC_CRM(.f.) ;

@ 18,0 clea to 24,79


if QTN("Skasowa wybrane wpisy moduu CRM ?").and.HA("BAFPOL")

  set order to 0
  if empty(_konto)                                                   //30.08.15
     dele all for DATA>=_data_od.and.DATA<=_data_do
  else
     dele all for KONTO==_konto.and.DATA>=_data_od.and.DATA<=_data_do
  endi
  pack

  set filt to 
  copy to CRM_OLD
  zap
  appe from CRM_OLD
  _err:=.f.
endi

END SEQUENCE
close data

if _err
  QKE("Nie skasowano wpisw CRM")
else
   QKE("Skasowano wskazane wpisy CRM")
endi

sele (_sel)
RETURN NIL

*******************************************************************************
FUNCTION TB_PLIK(_pp)
loca _ocolo:=SET(_SET_COLOR,_ekra_blo),_w:=row(),_k:=col(),;
     _ocurs:=setcursor()
max_line_len:=275

@ 24,0 say "ALT_F - wyszukiwanie tekstu, ALT_R - kontynuacja"
FileBrowse(_pp,2,,23)
@ 24,0
* tb27(_pp,2)
SET(_SET_COLOR,_ocolo)
devpos(_w,_k)
setcursor(_ocurs)
RETURN NIL

*******************************************************************************
FUNCTION DirList( oFtp, aFiles, cIndent )                      //FTP //10.09.19
   // Recurses through all directories and lists files
LOCAL aFile

FOR EACH aFile IN aFiles
  IF aFile[F_NAME] == "." .OR. aFile[F_NAME] == ".."
    LOOP
  ENDIF

  ? cIndent, aFile[F_NAME]

  IF aFile[F_ATTR][1] == "d"
    oFtp:cwd( aFile[F_NAME] )
    DirList( oFtp, oFtp:listFiles(), cIndent+"   " )
    oFtp:cwd( ".." )
  ENDIF
NEXT
RETURN .T.

*******************************************************************************
FUNCTION FtpProgress( nSent, nTotal, oFtp )                    //FTP //10.09.19
                         // Displays a progress bar during file upload/download
      LOCAL cProgress
      LOCAL nRow := Row(), nCol := Col()

      cProgress := Replicate( Chr(178), Int( MaxCol()*nSent/nTotal ) )
      SetPos( MaxRow()-1, 0 )

      ?? oFtp:oUrl:cFile
      ?  PadR( cProgress, MaxCol() )

      SetPos( nRow, nCol )
RETURN .T.

*******************************************************************************
PROCEDURE FTP() //przykad                                     //FTP //10.09.19
LOCAL oFtp, cRoot

//    LOCAL cUSBStick := "ftp://anonymous:guest@192.168.178.1"
      LOCAL cUSBStick := "ftp://maciek@comped.com.pl:Serwis49@comped.com.pl"

      CLS

      oFtp := TIpClientFtp():new( cUSBStick )

      // function for displaying progress bar
      oFtp:exGauge := ( @FtpProgress() )

      IF .NOT. oFtp:open()
         ? oFtp:lastErrorMessage()
         QUIT
      ENDIF

      aFiles := oFtp:listFiles()
      cRoot  := aFiles[1,1]

      ? oFtp:cwd( "ABC"    ), oFtp:cReply

/*
      ? oFtp:cwd( cRoot    ), oFtp:cReply
      ? oFtp:mkd( "newdir" ), oFtp:cReply
      ? oFtp:cwd( "newdir" ), oFtp:cReply
*/



      ? oFtp:uploadFile( "MV_BAF_XHB.ZIP" )  , oFtp:cReply

/*
      ? oFtp:uploadFile( "testftp.exe" )  , oFtp:cReply

      oFtp:cwd( ".." )
      Dirlist( oFtp, aFiles, "" )
      oFtp:cwd( cRoot + "/newdir"  )

      ? oFtp:downloadFile( "testftp.prg" ), oFtp:cReply

      ? oFtp:dele( "testftp.exe" ), oFtp:cReply
      ? oFtp:dele( "testftp.prg" ), oFtp:cReply

      ? oFtp:cwd( ".." ), oFtp:cReply

      ? oFtp:rmd( "newdir" ), oFtp:cReply
*/

      oFtp:close()

RETURN NIL

*******************************************************************************
FUNCTION NEW_FTP(_user,_pass,_serv,_path1,_path2,_path3,_file1,_file2,_dest,;
                 _copy,_to)                                          //15.09.19
LOCAL oFtp, cRoot
LOCAL cUSBStick
LOCAL _j

DEFAULT _path1  TO "",;
        _path2  TO "",;
        _path3  TO "",;
        _dest   TO "",;
        _file1  TO "",;                                              //10.09.19
        _file2  TO "",;
        _copy  TO "",;
        _to     TO ""


BEGIN SEQUENCE

if !_dest="TEST"
  cls
  ?_dest+" "+_file1+" "+_file2
endi

//cUSBStick := "ftp://maciek@comped.com.pl:Serwis49@comped.com.pl"
//cUSBStick := "ftp://comped:c1926_m82_D73@ftp.bafix.pl"
//_path1:="bafix.beep.pl"

_alog:=DIRECTORY("ftp*.log")
if len(_alog)>25
  for _j:=0 TO len(_alog)
    dele file ftp.log
    dele file ("FTP"+ltrim(str(_j,2))+".log")
  next
endi

cUSBStick := "ftp://"+_user+":"+_pass+"@"+_serv

oFtp := TIpClientFtp():new( cUSBStick,.t.)

if !oFtp:open()  
   ?"FTP error "                        
   ? oFtp:lastErrorMessage()
   BREAK
else
   ?"FTP open "
   aFiles := oFtp:listFiles()
   cRoot  := aFiles[1,1]
   ?? cRoot
endi

oFtp:close()
inkey(2)

if ! oFtp:open()  //jeszcze raz
   ? oFtp:lastErrorMessage()
   BREAK
endi

if !empty(_dest).and.!empty(_path1)
  ? oFtp:cwd( _path1 ), oFtp:cReply
endi
if !empty(_dest).and.!empty(_path2)
  ? oFtp:cwd( _path2 ), oFtp:cReply
endi
if !empty(_dest).and.!empty(_path3)
  ? oFtp:cwd( _path3 ), oFtp:cReply
endi

if uppe(_dest)="U"

  if !empty(_file1)
    ? oFtp:uploadFile( _file1 ) , oFtp:cReply
   endi
  if !empty(_file2)
    ? oFtp:uploadFile( _file2 ) , oFtp:cReply
  endi

  if !empty(_copy).and.!empty(_to)
      ? oFtp:downloadFile( _to, _copy) , oFtp:cReply
  endi

elseif uppe(_dest)="D"
  if !empty(_file1)
    ? oFtp:downloadFile( _file1 ) , oFtp:cReply
  endi
  if !empty(_file2)
    ? oFtp:downloadFile( _file2 ) , oFtp:cReply
  endi
endi
oFtp:close()

END SEQUENCE

inkey(3)

RETURN NIL

*******************************************************************************
FUNCTION WER_FTP()
local _tex:='۲  SPRAWDZENIE CZNOCI Z FTP  '
local _tmp_pass,_i

cls
@ 0,0 say _tex

/*
NEW_FTP(_user,_pass,_serv,_path1,_path2,_path3,_file1,_file2,_dest)

*/
?"SERVER:"+_ftp_open
?"LOGIN: "+_ftp_login

_tmp_pass:=""
for _i:=1 to len(_ftp_pass)
  _tmp_pass+=if(int(_i/2)*2=_i,subs(_ftp_pass,_i,1),"*")
next
?"PASS:  "+_tmp_pass

NEW_FTP(_ftp_login,_ftp_pass,_ftp_open,_ftp_path,,,,,"TEST")

WAIT "Nacinij klawisz..."
RETURN NIL

*******************************************************************************
FUNCTION ZAM_OK()                                                    //23.10.19
local _konto,_data_zam,_nr_zam
local _sel:=sele(),_rek:=recn(),_ret:=.t.
local _ewi_or:=EWIZAM->(indexord()),_ewi_re:=EWIZAM->(recn()),_puste:=0

_konto   :=EWIZAM->KONTO
_data_zam:=EWIZAM->DATA_ZAM
_nr_zam  :=EWIZAM->NR_ZAM

sele EWIZAM
dbsetorder(2)
dbseek(_konto+ROK(_data_zam)+_nr_zam+"P")
copy to XXX  while _konto+ROK(_data_zam)+_nr_zam+"P"==;
                   KONTO+ROK( DATA_ZAM)+ NR_ZAM+"P"

dbseek(_konto+ROK(_data_zam)+_nr_zam+"P")
count to _puste while _konto+ROK(_data_zam)+_nr_zam+"P"==;
                      KONTO+ROK( DATA_ZAM)+ NR_ZAM+"P";
                for   INDEKS="     ".or.empty(NR_KON)
if _puste>0
  _ret:=.f.
  QK("Zamwienie niekompletne!")
endi

EWIZAM->(dbsetorder(_ewi_or))
EWIZAM->(dbgoto(_ewi_re))

sele (_sel)
dbgoto(_rek)
RETURN _ret

*******************************************************************************
********************************   SKLEP  *************************************
*******************************************************************************
FUNCTION LISTA()                                                     //23.10.19
local _ftp_open  :="ftp.bafix.pl",;
      _ftp_login :="strona_bafpol",;
      _ftp_pass  :="sBaf_2019",;
      _ftp_path1:="bafpol.pl",;
      _ftp_path2:="zamowienia"
local _axml:={},_linia:=""

dele file LISTA.TXT

_plik:=fcreate("flist.bat")
fwriteln(_plik,"cls")
fwriteln(_plik,"ftp -s:flist.scr")
fclose(_plik)

_plik:=fcreate("flist.scr")
fwriteln(_plik,"open "+_ftp_open)
fwriteln(_plik,_ftp_login)
fwriteln(_plik,_ftp_pass)
fwriteln(_plik,"cd "+_ftp_path1)
fwriteln(_plik,"cd "+_ftp_path2)
fwriteln(_plik,"binary")
fwriteln(_plik,"dir *.xml LISTA.TXT")
fwriteln(_plik,"quit")
fclose(_plik)

RUN  flist.bat >NUL  
dele file flist.scr

if file("LISTA.TXT").and.(_nfile:=FOpen("LISTA.TXT"))>0
  Fseek(_nfile,0,0)
  _ln:=0
  do while FReadLn(_nfile,@_linia,500)
    if ".xml"$_linia.and.":"$_linia
       _linia:=alltrim(subs(_linia,at(":",_linia)+3))
       aadd(_axml,_linia)
    endi
  endd
  FClose(_nfile)
endi

dele file LISTA.TXT

RETURN _axml

*******************************************************************************
FUNCTION WCZYTAJ_SKL()
local _ftp_open  :="ftp.bafix.pl",;
      _ftp_login :="strona_bafpol",;
      _ftp_pass  :="sBaf_2019",;
      _ftp_path1:="bafpol.pl",;
      _ftp_path2:="zamowienia"
local _axml:={},_astru:={}

cls

BEGIN SEQUENCE

_axml:=LISTA()

sele 0
if !_use(_gdzie_mv+"TOW","R"); BREAK; endi
set index to (_gdzie_mv+"TOW_IN")

sele 0
if !_use(_gdzie_fir+"FIRMY","R"); BREAK; endi
set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
             (_gdzie_fir+"FIRMY_AD"),(_gdzie_fir+"FIRMY_NI")
dbsetorder(4)

sele 0
_astru:={}
dele file (_sc+"EWIZAM.DBF")
aadd(_astru,{"LP        ","N",3,0})
aadd(_astru,{"DATA_ZAM  ","D",8,0})
aadd(_astru,{"KONTO     ","C",5,0})
aadd(_astru,{"NR_KON    ","C",5,0})
aadd(_astru,{"NR_ZAM    ","C",4,0})
aadd(_astru,{"STATUS    ","C",1,0})
aadd(_astru,{"TYP       ","C",1,0})
aadd(_astru,{"INDEKS    ","C",20,0})
aadd(_astru,{"NAZWA_TOW ","C",40,0})
aadd(_astru,{"JM        ","C",4,0})
aadd(_astru,{"ILO_ZAM   ","N",10,3})
aadd(_astru,{"CENA      ","N",9,2})
aadd(_astru,{"OPIS_TOW  ","C",20,0})
aadd(_astru,{"KOD_PAS   ","N",13,0})
aadd(_astru,{"VAT       ","C",2,0})
aadd(_astru,{"CENA_ZAK  ","N",9,2})
aadd(_astru,{"CENA_SPR  ","N",9,2})
aadd(_astru,{"CENA_CEN  ","N",9,2})
aadd(_astru,{"RABAT     ","N",6,1})
aadd(_astru,{"OPIS      ","M",10,0})
aadd(_astru,{"BRAK      ","N",6,0})
aadd(_astru,{"CZAS      ","C",5,0})
aadd(_astru,{"ETAP      ","C",3,0})
aadd(_astru,{"MAGAZYN_PH","C",1,0})
aadd(_astru,{"KURIER    ","C",1,0})
aadd(_astru,{"OPLATA    ","C",1,0})
aadd(_astru,{"ILO_FAK   ","N",10,3})
aadd(_astru,{"SKAN      ","C",3,0})
aadd(_astru,{"PACZKI    ","C",14,0})
aadd(_astru,{"OPE_MAG   ","C",3,0})
aadd(_astru,{"DATA_MAG  ","D",8,0})
aadd(_astru,{"TIME_MAG  ","C",5,0})
aadd(_astru,{"KUPONY    ","C",1,0})
dbcreate(_sc+"EWIZAM.DBF",_astru)

sele 0
if !_use(_sc+"EWIZAM","E"); BREAK; endi

QPC(1)

_plik:=fcreate("fread.bat")
fwriteln(_plik,"cls")
fwriteln(_plik,"ftp -s:fread.scr")
fclose(_plik)

_plik:=fcreate("fread.scr")
fwriteln(_plik,"open "+_ftp_open)
fwriteln(_plik,_ftp_login)
fwriteln(_plik,_ftp_pass)
fwriteln(_plik,"cd "+_ftp_path1)
fwriteln(_plik,"cd "+_ftp_path2)
fwriteln(_plik,"binary")
for _i:=1 to len(_axml)
  fwriteln(_plik,"get "+_axml[_i]+" .\POBRANE\"+_axml[_i])
next
fwriteln(_plik,"quit")
fclose(_plik)

RUN  fread.bat >NUL
dele file fread.scr

QPC(0)


_ile_zam=0
for _i:=1 to len(_axml)
  if !file(strtran(".\POBRANE\"+_axml[_i],".xml","arc.xml"))

    _ile_zam+=1

    cls
    QK("Zapis zamwienia "+_axml[_i]+" do systemu fakturowania.")

    CLS    
    XML_TO_EZAM(_axml[_i])

    RenameFile(".\POBRANE\"+_axml[_i],;
               strtran(".\POBRANE\"+_axml[_i],".xml","arc.xml"))
  else
    DeleteFile(".\POBRANE\"+_axml[_i])
  endi
next

if _ile_zam=0
  QKE("Brak nowych zamwie.")
  dele file (_kat_dan+"EWIZAM.DBF")                                
  dele file (_kat_dan+"EWIZAM.DBT")
  BREAK
endi


_plik:=fcreate("fdele.bat")
fwriteln(_plik,"cls")
fwriteln(_plik,"ftp -s:fdele.scr")
fclose(_plik)

_plik:=fcreate("fdele.scr")
fwriteln(_plik,"open "+_ftp_open)
fwriteln(_plik,_ftp_login)
fwriteln(_plik,_ftp_pass)
fwriteln(_plik,"cd "+_ftp_path1)
fwriteln(_plik,"cd "+_ftp_path2)
fwriteln(_plik,"binary")
for _i:=1 to len(_axml)
  fwriteln(_plik,"delete "+_axml[_i])
next
fwriteln(_plik,"quit")
fclose(_plik)

//RUN  fdele.bat  >NUL
dele file fdele.scr

END SEQUENCE

CPClose(EWIZAM)

RETURN _ile_zam

*******************************************************************************
FUNCTION XML_TO_EZAM(_xml)
local _astru:={},tdata:="",tnazwa:="",tdigits:="1234567890"
local _idz:="",_reference:="",_message:="",_payment:="",_date:="",;
      _nr_kon:="00000",_idp:=""                                      //23.10.19
local _uwagi_kon:=""                                                 //09.01.19

local _firstname:="",_lastname:="",_company:="",_vat_number:="",_phone:="",;
      _phone_mobile:="",_address:="",_city:="",_postcode:="",_country:=""


nhandle1:=FOpen(".\POBRANE\"+_xml)
oXmlDoc:= TXmlDocument():new(nhandle1)

oXmlNode1 :=oXmlDoc:findFirst("id")
if !oXmlNode1=NIL.and.!oXmlNode1:cData=NIL
  _idz       :=ISO_LAT(oXmlNode1:cData)
endi

oXmlNode1 :=oXmlDoc:findFirst("reference")
if !oXmlNode1=NIL.and.!oXmlNode1:cData=NIL
  _reference:=ISO_LAT(oXmlNode1:cData)
endi

oXmlNode1 :=oXmlDoc:findFirst("message")
if !oXmlNode1=NIL.and.!oXmlNode1:cData=NIL
  _message  :=ISO_LAT(oXmlNode1:cData)
endi

oXmlNode1 := oXmlDoc:findFirst("payment_method")
if !oXmlNode1=NIL.and.!oXmlNode1:cData=NIL
  _payment:=ISO_LAT(oXmlNode1:cData)
endi
do case                                                              //23.10.19
 case "PRZEL"$upper(_payment); _payment:="PRZELEW"
 case "ODBIO"$upper(_payment); _payment:="POBRANIE"
 othe; _payment:="GOTWKA"
endc

oXmlNode1 := oXmlDoc:findFirst("date_add")
if !oXmlNode1=NIL.and.!oXmlNode1:cData=NIL
  _date:=ISO_LAT(oXmlNode1:cData)
endi

oXmlNode1 := oXmlDoc:findFirst("total_tax_excluded")
if !oXmlNode1=NIL.and.!oXmlNode1:cData=NIL
  _total:=oXmlNode1:cData
endi

oXmlNode1 := oXmlDoc:findFirst("vat_number")                         //09.01.20
if !oXmlNode1=NIL.and.!oXmlNode1:cData=NIL
  _vat_number:=oXmlNode1:cData
endi

_nip:=alltrim(strtran(strtran(_vat_number,"PL"),"-"))
if !empty(_nip).and.FIRMY->(dbseek(_nip)).and.val(FIRMY->NR_KON)>0
  _uwagi_kon:=alltrim(FIRMY->UWAGI)
endi

_idz:=trans0(val(_idz),4)

sele EWIZAM
appe blan

repl KONTO      with "00099",;
     DATA_ZAM   with stod(strtran(_date,"-")),;
     NR_ZAM     with ltrim(_idz),;
     STATUS     with "A",;
     TYP        with "N",;
     MAGAZYN_PH with "N",;
     KURIER     with "N",;
     OPLATA     with "N",;
     KUPONY     with "N",;
     INDEKS     with "OPIS",;
     NR_KON     with _nr_kon
     
repl OPIS with "00099"+";"+;                             // 1. konto
               strtran(_date,"-")+";"+;                  // 2. data zamwienia
               ltrim(_idz)+";"+;                         // 3. numer zamwienia
               "00000"+";"+;                             // 4. firma
               "0"+";"+;                                 // 5. termin
                padr(strtran(_payment,";",","),8)+";"+;  // 6. patno
                "F"+";"+;                                // 7. faktura
                if(empty(_uwagi_kon),"",_uwagi_kon+" ")+;            //09.01.20
                alltrim(strtran(_message,";",","))+";"+; // 8. uwagi
                "1"+";"+;                                // 9. cennik
                "0.0"+";"+;                              // 10. rabat
                ltrim(_total)+";"+;                      // 11. warto netto
                "P99"                             // 12. operator    //14.01.20

oXmlNode1 := oXmlDoc:findFirst("delivery_address")
oXmlIter := TXmlIterator():new( oXmlNode1 )
do while .t.
  oXmlNode1:= oXmlIter:next()
  if oXmlNode1=NIL
    exit
  endi
  if !oXmlNode1:cData=NIL.and.!oXmlNode1:cData=NIL
    tnazwa:=oXmlNode1:cName
    tdata :=oXmlNode1:cData
  endi

  do case
    case tnazwa="vat_number"  ;_vat_number  :=tdata
    case tnazwa="firstname"   ;_firstname   :=tdata
    case tnazwa="lastname"    ;_lastname    :=tdata
    case tnazwa="company"     ;_company     :=tdata
    case tnazwa="phone"       ;_phone       :=tdata
    case tnazwa="phone_mobile";_phone_mobile:=tdata
    case tnazwa="address"     ;_address     :=tdata
    case tnazwa="city"        ;_city        :=tdata
    case tnazwa="postcode"    ;_postcode    :=tdata
    case tnazwa="country"     ;_country     :=tdata
  endc
endd


_nip:=alltrim(strtran(strtran(_vat_number,"PL"),"-"))
_nr_kon:="00000"
if !empty(_nip).and.FIRMY->(dbseek(_nip)).and.val(FIRMY->NR_KON)>0
  _nr_kon:=FIRMY->NR_KON
  _uwagi_kon:=alltrim(FIRMY->UWAGI)
  EWIZAM->NR_KON:=_nr_kon
endi

sele EWIZAM
repl NR_KON     with _nr_kon                                         //23.10.19

appe blan
repl KONTO      with "00099",;
     DATA_ZAM   with stod(strtran(_date,"-")),;
     NR_ZAM     with ltrim(_idz),;
     STATUS     with "A",;
     NR_KON     with _nr_kon,;
     TYP        with "P",;
     ILO_ZAM    with 1.0,;
     ILO_FAK    with 1.0,;
     INDEKS     with "00000",;
     NAZWA_TOW  with "- UWAGI DO ZAMWIENIA -"

repl OPIS with trans0(0,3)+"/UWAGI"+_idp+CRLF+;
               alltrim(ISO_LAT(_message))+CRLF+;
               "Dane adresowe:"+CRLF+;
               "NIP:     "+_vat_number+CRLF+;
               "NAZWA:   "+ISO_LAT(alltrim(_firstname)+" "+alltrim(_lastname))+CRLF+;
               "FIRMA:   "+ISO_LAT(_company)+CRLF+;
               "TELEFON: "+_phone+"  "+_phone_mobile+CRLF+;
               "ADRES:   "+ISO_LAT(_address)+CRLF+;
               "MIASTO:  "+ISO_LAT(_postcode+" "+_city)
  
//? "Produkty:"

oXmlNode1 := oXmlDoc:findFirst("product")
     
_lp:=0
do while oXmlNode1 <> NIL

  EWIZAM->(dbappend())
  _lp+=1

  EWIZAM->KONTO    := "00099"
  EWIZAM->DATA_ZAM := stod(strtran(_date,"-"))
  EWIZAM->NR_ZAM   := ltrim(_idz)
  EWIZAM->STATUS   := "A"
  EWIZAM->NR_KON   := _nr_kon
  EWIZAM->TYP      := "P"

  _reference :=""
  _name      :=""
  _quantity  :=""
  _price_tax_excluded     :=""
  _price_tax_included     :=""
  _idp       :=""                                                    //23.10.19
          
  oXmlIter := TXmlIterator():new( oXmlNode1 )
  do while .t.

    oXmlNode1:= oXmlIter:next()
    if oXmlNode1=NIL
      exit
    endi

    tnazwa:= oXmlNode1:cName
    tdata:= if(oXmlNode1:cData<>NIL,ISO_LAT(oXmlNode1:cData),"")

    if "id"==alltrim(tnazwa)                                         //23.10.19
      _idp:=alltrim(tdata)
    endi

    if "reference"$tnazwa
      _reference:=tdata
    endi

    if "name"$tnazwa
      _name:=tdata
    endi

    if "quantity"$tnazwa
      _quantity:=tdata
    endi

    if "price_tax_excluded"==alltrim(tnazwa)                         //23.10.19
      _price_tax_excluded:=tdata
    endi

    if "price_tax_included"==alltrim(tnazwa)
      _price_tax_included:=tdata
    endi

  endd

  if !empty(_reference)
    TOW->(dbseek(s_i(_reference)))
  else
    TOW->(dbgobottom())
    TOW->(dbskip())
  endi

  EWIZAM->LP:=_lp    
  EWIZAM->INDEKS     :=_reference

  if !empty(_reference)
    EWIZAM->JM         :=TOW->JM
    EWIZAM->KOD_PAS    :=TOW->KOD_PAS                                //21.11.19
  else
    EWIZAM->JM         :="?"
  endi

  if !empty(EWIZAM->INDEKS).and.!empty(TOW->NAZWA_TOW)               //23.10.19
    EWIZAM->NAZWA_TOW  :=TOW->NAZWA_TOW                             
  else
    EWIZAM->NAZWA_TOW  :=_name
  endi

  EWIZAM->ILO_ZAM    :=val(_quantity)*if(TOW->WSP_S<>0,TOW->WSP_S,1)
  EWIZAM->ILO_FAK    :=val(_quantity)*if(TOW->WSP_S<>0,TOW->WSP_S,1)
  EWIZAM->CENA       :=val(_price_tax_excluded)/if(TOW->WSP_S<>0,TOW->WSP_S,1)
  EWIZAM->CENA_CEN   :=val(_price_tax_excluded)/if(TOW->WSP_S<>0,TOW->WSP_S,1)
  EWIZAM->CENA_SPR   :=val(_price_tax_excluded)/if(TOW->WSP_S<>0,TOW->WSP_S,1)

  EWIZAM->VAT        :=str(zaokr(100*(val(_price_tax_included)-val(_price_tax_excluded))/;
                           val(_price_tax_excluded),2),2)

  EWIZAM->OPIS    :=trans0(_lp,3)+"/"+_idp+CRLF+_name+CRLF+;
                  "Sklep: "+alltrim(str(val(_quantity),10,3))+" * "+;
                  alltrim(str(val(_price_tax_excluded),9,2))+" z   "+;
                  if(empty(_reference),;
                  "Hurtownia: ? * ? z   Wsp.: ?",;
                  "Hurtownia: "+alltrim(str(EWIZAM->ILO_ZAM,10,3))+" * "+;
                  alltrim(str(EWIZAM->CENA,9,2))+" z   Wsp.: "+;
                  if(TOW->WSP_S<>0,alltrim(str(TOW->WSP_S,7,3)),"1.000"))
                  
  oXmlNode1 := oXmlDoc:findNext()
endd

Fclose(nhandle1)

RETURN NIL

*******************************************************************************
FUNCTION ISO_LAT(_s)
local _n,_i
local aiso:=;   //ISO 8859-2
      {177,230,234,179,241,243,182,188,191,161,198,202,163,209,211,166,172,175}
local a852:=;
      {165,134,169,136,228,162,152,171,190,164,143,168,157,227,224,151,141,189}

for _i:=1 to len(_s)
  _n:=ascan(aiso,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(a852[_n]))
  endi
next
RETURN _s    

*******************************************************************************
FUNCTION IMPORT_SKL()                            //wczytanie zamwie ze sklepu
local _tex:='۲  IMPORT ZAMWIE ZE SKLEPU DO FOLDERU POREDNIEGO  '
local _ser_ftp:=.f.,_ile:=0
priv  _konto:="00099"

priv _kat_dan:=alltrim(_gdzie_dan)
priv _kat_mag:=alltrim(_gdzie_mv)

cls
@ 0,0 say _tex

BEGIN SEQUENCE

if !QTN("Wczytanie zamwie ze sklepu internetowego ?")
   BREAK
endi

dele file (_sc+"EWIZAM.DBF")  
dele file (_sc+"EWIZAM.DBT")

if !DIR_EXIST(".\POBRANE")
  QKE("Brak folderu .\POBRANE")
  BREAK
endi

sele 0
if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endi
set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
             (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")

if file(_kat_dan+"EWIZAM.DBF")

  DAJ_FZAM()

  if !(QTN("Skasowa poprzednie zamwienia z folderu poredniego ?").and.;
       QTN("Jeste pewien ?").and.HA(_haslo))
    BREAK
  endi
endi
CPClose(KON)

dele file (_kat_dan+"EWIZAM.DBF")                                
dele file (_kat_dan+"EWIZAM.DBT")

_ile:=WCZYTAJ_SKL()
if _ile=0
  dele file (_kat_dan+"EWIZAM.DBF")                                
  dele file (_kat_dan+"EWIZAM.DBT")
elseif file (_sc+"EWIZAM.DBF").and.file(_sc+"EWIZAM.DBT")
  if filesize(_sc+"EWIZAM.DBF")>0.and.filesize(_sc+"EWIZAM.DBT")>0
    copy file (_sc+"EWIZAM.DBF") to (_kat_dan+"EWIZAM.DBF")
    copy file (_sc+"EWIZAM.DBT") to (_kat_dan+"EWIZAM.DBT")
  endi
endi

if file (_kat_dan+"EWIZAM.DBF").and.file(_kat_dan+"EWIZAM.DBT")
  if filesize(_kat_dan+"EWIZAM.DBF")>0.and.filesize(_kat_dan+"EWIZAM.DBT")>0
     QKE("Pobrano zamwienia ze sklepu internetowego.")
     BREAK
  endi
endi

QKE("Nie pobrano zamwie ze sklepu.")
END SEQUENCE

RETURN NIL

*******************************************************************************
FUNCTION P_IMPORT()         //przegldanie zaimportowanych zamwie   //09.01.20
local _tex:='۲  PRZEGLDANIE ZAMWIE ZAIMPORTOWANYCH DO FOLDERU POREDNIEGO  '
local _ser_ftp:=.f.,_ile:=0,_akas:={}

priv _kat_dan:=alltrim(_gdzie_dan)
priv _kat_mag:=alltrim(_gdzie_mv)

cls
@ 0,0 say _tex

BEGIN SEQUENCE

dele file (_sc+"EWIZAM.DBF")  
dele file (_sc+"EWIZAM.DBT")

sele 0
if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endi
set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
             (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")

if file(_kat_dan+"EWIZAM.DBF")

  @ 24,1 say "Space - podgld                               Ins - zaznaczenie do skasowania"
  _akas:=DAJ_FZAM(.t.)
  @ 24,0

  if len(_akas)>0.and.QTN("Skasowanie "+ltrim(str(len(_akas),3))+;
                          " zamwie z folderu poredniego ?").and.HA(_haslo)

    if _use(_kat_dan+"EWIZAM","F!","EWIKAS")
      for _i:=1 to len(_akas)

//      QKE(dtoc(_akas[_i][1])+" "+_akas[_i][2]+" "+_akas[_i][3])

        dele all for _akas[_i][1]=DATA_ZAM.and.;
                     _akas[_i][2]=KONTO.and.;
                     _akas[_i][3]=NR_ZAM 
      next

      QK("Skasowano wskazane zamwienia !")
    else
      QK("Nie skasowano wskazanych zamwie !")
    endi                
    CPClose(EWIKAS)
  endi

else
  QK("Brak zamwie w folderze porednim.")
  BREAK
endi
CPClose(KON)


END SEQUENCE

RETURN NIL

*******************************************************************************
FUNCTION AKC_IMP(_poz)
loca _ocolor:=setcolor(),_sel:=select(),_astru:={},getlist:={},_rek:=recn()

if lastkey()<>K_SPACE.or.!_poz
   RETURN NIL
else

  _d_zam:=DATA_ZAM
  _k_zam:=KONTO
  _n_zam:=NR_ZAM

  set colo to _slow_blo

  sele select("EWIZAM")
  if !_use(_kat_dan+"EWIZAM","R"); BREAK; endi
  set filt to TYP="P".and._d_zam=DATA_ZAM.and._k_zam=KONTO;
                     .and._n_zam=NR_ZAM.and.INDEKS<>"00000"
  copy to (_sc+"POZ_IMP")
  CPClose(EWIZAM)

  sele 0
  _use(_sc+"POZ_IMP","R!")
  CPEDIT  POZ: 2,12,23,    ;
          DEF: "EWIZAM"    ;                                
          POZWER: "V9"     ;
          RAMKA: R_GRUBA   ;
          KOLOR: _slow_blo  ;
          PION: ,,,         ;
          ODTWORZ: .T.
  CPClose(POZ_IMP)
  dele file (_sc+"POZ_IMP.DBF")
 
  sele (_sel)
  dbgoto(_rek)
  setcolor(_ocolor)

endi

RETURN NIL

*******************************************************************************
 