*******************************************************************************
*                                  V_MAIN                                     *
*******************************************************************************
/*
30.09.14 - parametry MAIN(nr,konto)
15.11.14 - STOP()
24.11.14 - korekta blokad cakowitych
27.02.15 - kasowanie rezerwacji z przegldania i zmiana firmy 0000 na inn
14.12.15 - wymuszenie kolorw w comped.mem
23.02.16 - _rest[NCUR]:RefreshCurrent() w v_edit.prg
02.10.16 - AFIRAN()
24.01.17 - kasowanie firany z FIRANY.DBF
*/

#include "comped.ch"
#include "inkey.ch"
#include "setcurs.ch"
#include "fileio.ch"              
#include "directry.ch"
#include "pscript.ch"
#include "box.ch"

#define K_PLUS 43
#define K_MINUS 45
#define CRLF chr(13)+chr(10)
#define K_PLUS  43  // +
#define K_MINUS 45  // -
#define K_STAR  42  // * 

#define B_GRUBA         ( Chr( 220 ) + Chr( 220 ) + Chr( 120 ) + Chr( 219 ) + ;
                          Chr( 223 ) + Chr( 223 ) + Chr( 223 ) + Chr( 219 ) )

REQUEST HB_LANG_PL852       
REQUEST HB_CODEPAGE_PL852   

*------------------------------------------------------------------------------
memvar _nazwa_prg,_firma_menu,_operator,_priorytet,_nazwisko,_bierny
memvar _hor1,_vert1,_rest1,_hor2,_vert2,_rest2,_hor3,_vert3,_rest3 

static _data_beg:=NIL, _data_end:=NIL

*******************************************************************************
FUNCTION MAIN(nr,konto)
        
local _newdbf:={},_d1,_d2,_d3,_lj,_plznaki
local _nr_ph:=0, _indeksuj:=.f.                               

set epoch to 1950 
set date germ

SETMODE(25,80)                                                            //xHB
SET(_SET_DELETED,.T.)

//UWAGA : Gdy upper(chr(169))<>chr(168) to program jest w standardzie MAZOVI

HB_SETCODEPAGE('PL852')                                                   //xHB
HB_LANGSELECT( 'PL852' )

STOP()  //stop gdy file("STOP")                                      //15.11.14

cls
//             "170124""161002","160223","151214"
public _d_lic:="150227",;//"141124","141115","140930", "140924",; 
       _inout:=.f.,;
       _noty:=.t.,; 
       _udocezak:=.t.,;
       _licencja:="M0B",;                                          //xHB MACIEK
       _dru_dok:=spac(15),;
       wer:="STANDARD",;
       desk                

public _alert
public _wersja:=""                                          

if upper(chr(145))=chr(144)
  _plznaki:="-900"
elseif upper(chr(169))=chr(168)
  _plznaki:="-852"
else
  _plznaki:="-000"
endi

*-------------------------------------------------- obrobka parametru wywolania
DEFAULT nr      TO "01",;
        konto   TO "00000"

public _konto_ph:=konto

if len(nr)>2;     RETURN NIL;     endif
if len(nr)=2
  if !(subs(nr,1,1)$"0123456789".and.subs(nr,2,1)$"0123456789")
    RETURN NIL  
  endif
else
  if !(nr$"0123456789");    RETURN NIL    
  else;                     nr:="0"+nr  
  endif
endif
*------------------------------------------------------------------------------
public numer_stan:=nr
public _hor1,_vert1,_rest1,_hor2,_vert2,_rest2,_hor3,_vert3,_rest3  
public _nazwa_prg:='OBSUGA REZERWACJI FIRAN',;  
       _operator:="OPE",;
       _nr_ope:=0,;
       _priorytet:=0,;
       _bierny:=" ",;
       _total:=0,;
       _nr_mag,;
       _stary:=.f. ,;                                  //praca w starym okresie
       _mnoznik:=1.0,;
       _nazwisko:=spac(22),;
       _szer:=.f.,;
       _max_wz:="9999:",;
       _centrala:=.t.                                               

priv  _ftp_open,_ftp_login,_ftp_pass,_ftp_path,;
      _ftp_open2,_ftp_logi2,_ftp_pass2,_ftp_path2,;                 
      _mail_from,_mail_host,_mail_port,_mail_user,_mail_pass

DAJ_POUFNE()                                                         //22.09.16

sele 0
_use ("SL_OPE","E!")
index on HASLO to SL_OPE_H
use

cls

sele 0
_use("CONFIG","R!")
public _kartoteka:=alltrim(KARTOTEKA),;
       _liczba_sta:=LICZBA_STA
use

if (val(nr) > _liczba_sta) .or. (val(nr)=0)
  QKE("Niedozwolone stanowisko")
  RETURN NIL
endif

public _sc  :=_kartoteka+"#"+nr+"\",; 
       _scl := _kartoteka+"#"+nr,;
       _data_akt:=ctod(""),;                                         //02.10.16
       _auto_akt:="N"

if !OPERATOR();   dele file (_sc+"FLAGA"); RETURN; endi

if (_ps:=PSInit())=0                                                      //xHB
    QK("PScript - OK !",,0.2)
else
    tone(220,2)
    QK("PScript "+str(_ps,3))
endi


if _use("CONFIG","E")
  repl ARCH_1   with "arj a ARC_RAMA.ARJ *.db? *.mem RAMA.EXE",;
       ARCH_2   with "dir ARC_RAMA.ARJ"
  use
endi

if !_use("STATUS","S"); BREAK; endi                                  
if fieldpos("DATA_LIC")=0.or.DATA_LIC<>_d_lic        
  _o_lic:=if(fieldpos("DATA_LIC")>0,DATA_LIC,spac(6))
  clos STATUS
  if !_d_lic==_o_lic
    if !UZG_WER(_o_lic); RETURN NIL; endi          
  endi
endi
CPClose(STATUS)

if !_use("STATUS","R"); BREAK; endi                                  //02.10.16
if fieldpos("DATA_AKT")>0
  _data_akt:=DATA_AKT
endi        
CPClose(STATUS)

public _wersja:=""

sele 0
_use("CONFIG","R!")
_wersja:=CONFIG->WERSJA                                              
public _liczba_sta:= LICZBA_STA,;
       _firma_menu:= alltrim(FIRMA_MENU),;
       _haslo:= iif(empty(HASLO)," !    ",HASLO),;
       _gdzie_mv :=uppe(alltrim(GDZIE_MV)),;
       _gdzie_fir:=uppe(alltrim(GDZIE_FIR)),;
       _gdzie_dan:=uppe(alltrim(GDZIE_DAN)),;
       _format_ind:= alltrim(FORMAT_IND),;
       _format_ilo:= alltrim(FORMAT_ILO),;
       _format_cen:= alltrim(FORMAT_CEN),;
       _format_war:= alltrim(FORMAT_WAR),;
       _forfak_ilo:= if(fieldpos("FORFAK_ILO")>0.and.!empty(FORFAK_ILO),;
                     alltrim(FORFAK_ILO),alltrim(FORMAT_ILO)),;
       _forfak_cen:= if(fieldpos("FORFAK_CEN")>0.and.!empty(FORFAK_CEN),;
                     alltrim(FORFAK_CEN),alltrim(FORMAT_CEN)),;
       _forfak_war:= if(fieldpos("FORFAK_WAR")>0.and.!empty(FORFAK_WAR),;
                     alltrim(FORFAK_WAR),alltrim(FORMAT_WAR)),;
       _format_sww:=  iif(fieldpos("FORMAT_SWW")>0.and.!empty(FORMAT_SWW),;
                          alltrim(FORMAT_SWW),"########"),;
       _len_naz:=  LEN_NAZ,;
       _len_opi:=LEN_OPI,;
       _opisy_tow:=  OPISY_TOW,;   // 2,3,6,7 to wydruk f-y i dok. wg nazw
       _opakowania:=  OPAKOWANIA,; // 1,3,5,7 kredytow udziela osoba >=9
       _firma:=  iif(fieldpos("FIRMA")>0, alltrim(FIRMA),""),;
       _vat1:=VAT1,;
       _vat2:=VAT2,;
       _vat3:=VAT3,;
       _vat4:=VAT4,;                                          
       _vat5:=VAT5,;
       _vat6:=VAT6,;
       _vat7:=VAT7,;
       _ekra_blo:=   "W/N, N/W, N/N",;
       _edit_blo:=   "W/N, N/W, N/N,,,,,W+/N",;
       _slow_blo:=   "W/N, N/W, N/N,,,,,W+/N",;
       _ceny_1:=  CENY_1,;
       _ceny_2:=  CENY_2,;
       _ceny_3:=  CENY_3,;
       _cena_1,;
       _cena_2,;
       _cena_3,;
       _znaki_upu:=iif(fieldpos("ZNAKI_UPU")>0,ZNAKI_UPU,0),;
       _cennik_spr:=CENNIK_SPR,;
       _typ_mar:=subs(WERSJA,13,1),;
       _magazyn:=MAGAZYN,;
       _dostawcy:=if(fieldpos("DOSTAWCY")>0,alltrim(DOSTAWCY),""),; 
       _stany   :=if(fieldpos("STANY")>0.and.STANY="N",.f.,.t.),;     
       _auto_akt:=if(fieldpos("AUTO_AKT")>0.and.AUTO_AKT="T","T","N")     

public _mail_ce  :=alltrim(lowe(MAIL_CE)),;
       _mail_se  :=alltrim(lowe(MAIL_SE)),;
       _serwis   :=SERWIS,;                                         
       _tmp_ftp  :=(FTP2="T"),;                                      
       _cena_1:=iif(_ceny_1="B","brutto","netto"),;
       _cena_2:=iif(_ceny_2="B","brutto","netto"),;
       _cena_3:=iif(_ceny_3="B","brutto","netto")

public _font_ps:=if(fieldpos("FONT_PS")>0.and.!empty(FONT_PS),;
                    alltrim(FONT_PS),"Lucida Console"),;
       _pl:=if(fieldpos("PL")>0.and.PL$"swlSWM ",PL," ")

clos CONFIG  

_vat:="zw| 0|"+_vat1+"|"+_vat2+"|"+_vat3+"|"+;                      
               _vat4+"|"+_vat5+"|"+_vat6+"|"+_vat7

if !DIR_EXIST(_scl)
  cls
  QKE("Uwaga! Bdna konfiguracja programu. Brak kartoteki "+;
       subs(_sc,1,len(_sc)-1))
elseif !file(_sc+"PARADRUK.DBF")
  copy file PARADRUK.DBF to (_sc+"PARADRUK.DBF")
  _use(_sc+"PARADRUK","E!")
  inde on WARIANT to (_sc+"PARADRUK")
  use
endif

TEST_WEJ()  // badanie czy ktos inny wszedl z tym samym parametrem

sele 0
if _use("SL_OPE","R")                                          
  loca for KOD=_operator
endi
CPClose(SL_OPE)

cls
_use("STATUS","F!")
if file (_sc+"ekran.mem")
  restore from (_sc+"ekran") additive
  _d1:=_ekra_blo
  _d2:=_slow_blo
  _d3:=_edit_blo
  restore from comped additive
  _ekra_blo:=_d1
  _slow_blo:=_d2
  _edit_blo:=_d3
else
  restore from comped additive
endi
clos STATUS

setcolor(_ekra_blo)  

priv apolaVR:={}   // macierz do pamietania kolejnosci przestawianych
                   // i kasowanych przed wydrukiem kolumn w wersji druku "VR"

priv _uwaga:="A     "

// set dele on                                                            //xHB

setkey(   K_F1 ,{|| Help("PROG")} ) 
setkey(   K_ALT_F1 ,{|| Help("CPEDIT")} )
set scoreboard off
set confirm on
Polskie(.t.)

INDEX_MENU(wer,_sc,_scl)

set key K_SH_F1 to EXE1()
set key K_SH_F2 to EXE2()

if _indeksuj                                                     
  INDEX()
endi

AFIRAN(.t.)                                                          //02.10.16

MENU(0)

set key K_SH_F1 to 
set key K_SH_F2 to 
set key K_ALT_K to
errorlevel(_nr_ope)
showtime()
close data
dele file (_sc+"FLAGA") 
dele file (_sc+"MENU.NTX") 

_ekra_blo:=  "W/N, N/W, N/N"                                  //14.12.15 BAFPOL
_edit_blo:=  "W/N, N/W, N/N,,,,,W+/N"
_slow_blo:=  "W/N, N/W, N/N,,,,,W+/N"
save to comped all like _ekra_blo
save to comped all like _edit_blo
save to comped all like _slow_blo

RETURN NIL

*******************************************************************************
FUNCTION INDEX(_ntx)
local _tex,_apom,_zb,_i

DEFAULT _ntx TO .f.

cls
_tex:='۲  SORTOWANIE ZBIORW  '
@ 0,0 say _tex

_total:=6
PASEK(,,'')

BEGIN SEQUENCE

if _use("STATUS","S").and.(fieldpos("DATA_LIC")=0.or.DATA_LIC<>_d_lic)
  _o_lic:=if(fieldpos("DATA_LIC")>0,DATA_LIC,spac(6))
  CPClose(STATUS)
  if !_d_lic==_o_lic
    UZG_WER()
  endi
endi

if _ntx.and._co==" "
  _apom:=directory("*.NTX")     
  for _i:=1 to len(_apom); dele file (_apom[_i][1]); next
endi

_use("EDIT","E!")
if _priorytet=9; @ 23,0 say "EDIT"+spac(12); endi
inde on BAZA to EDIT
PASEK(1,,"")
tone(880,0.5)
STOP_SORT()

_use("SL_OPE","E!")
if _priorytet>=9; @ 23,0 say "SL_OPE"+spac(12); endi
inkey(0.2)
pack
inde on HASLO to SL_OPE_H
* PASEK(1,,"")
STOP_SORT()
use


if !file(_sc+"PARADRUK.DBF")                      
  copy file PARADRUK.DBF to (_sc+"PARADRUK.DBF")
endi
_use(_sc+"PARADRUK","E!")                         
if _priorytet>=9; @ 23,0 say "PARADRUK"+spac(12); endi
inkey(0.2)
inde on WARIANT to (_sc+"PARADRUK")
PASEK(1,,"")
STOP_SORT()

sele 0
if file(_gdzie_mv+"FIRANY.DBF").and._use(_gdzie_mv+"FIRANY","E")
  if _priorytet>=9; @ 23,0 say "FIRANY"+spac(12); endi
  pack
  inde on s_i(INDEKS)+str(KLASA,3)              to FIRANY_I
  inde on padr(NAZWA_TOW,_len_naz)+str(KLASA,3) to FIRANY_N
  PASEK(1,,"")
  use
endi

sele 0
if file(_gdzie_mv+"BLOKADYF.DBF").and._use(_gdzie_mv+"BLOKADYF","E")  
  if _priorytet>=10; @ 23,0 say "BLOKADA"+spac(20); endi
  pack
  inde on NR_KON+s_i(INDEKS)+str(KLASA,3)       to BLOKF_F
  inde on KONTO+NR_KON+s_i(INDEKS)+str(KLASA,3) to BLOKF_K
  inde on s_i(INDEKS)+str(KLASA,3)+KONTO        to BLOKF_I
  inde on dtos(DATA_BLO)+KONTO+NR_KON           to BLOKF_D
endi

_use("SL_KONT","E!")
if _priorytet=9; @ 23,0 say "SL_KONT"+spac(12); endi 
inkey(0.2)
pack
inde on KONTO to SL_KONT
PASEK(1,,"")
STOP_SORT()


END SEQUENCE
close data
PASEK(,,"")
RETURN NIL

*******************************************************************************
FUNCTION ESL_OPE()
local _tex:='۲  EDYCJA SOWNIKA OPERATORW '

cls
@ 0,0 say _tex

sele 0
_use("SL_OPE","E!")
set index to SL_OPE_H
set orde to 0

go top
CPEDIT  POZ: 1,,23,               ;
        DEF: "SL_OPE"             ;
        POZWER: "V1"              ;
        PION: ,,,                 ;
        INDEXY: {}                ;
        EDYCJA: .T.               ;
        DODAWANIE: .t.            ;
        KASOWANIE: .t.            ;
        CZYDODAC:  .t.            ;
        ODTWORZ:.f.

dele all for empty(KOD).or.empt(HASLO)
pack

close data
RETURN

*******************************************************************************
FUNCTION UNIK_OPE()
local _re:=recn(), _kod:=KOD
loca for KOD=_kod.and.recn()<>_re
if found();  go _re;  RETU .f.
else;  go _re;  RETU .t.
endi

*******************************************************************************
FUNCTION CONFIG()
local _tex:='۲  KONFIGURACJA PODSTAWOWA '

cls
@ 0,0 say _tex
QKE("Opcja dozwolona tylko przed wprowadzeniem danych uytkowych")
if !(_priorytet>=9.and.HA(_haslo))
 QKE("Brak uprawnie !")
 retu NIL
endi

sele 0
_use("CONFIG","E!")
@ 2, 0 say  "Format indeksu :          " get FORMAT_IND pict "@!"
@ 3, 0 say  "Format iloci :           " get FORMAT_ILO pict "@!"
@ 4, 0 say  "Dugo nazwy :           " get LEN_NAZ pict "99"
@ 5, 0 say  "Opisy towarw ?           " get OPISY_TOW pict "@! A";
                                         vali OPISY_TOW$"T "
@  6, 0 say "Dugo opisu  :          " get LEN_OPI pict "99"
@  8, 0 say "Folder programu Megavat : " get GDZIE_MV  pict "@!" 
@  9, 0 say "Folder sownika firm :    " get GDZIE_FIR pict "@!" 
//@ 10, 0 say "Folder wymiany danych :   " get GDZIE_DAN pict "@!" 

//@ 12,0 say  "Konto przedstawiciela:    " get KONTO_PH pict "99999"
@ 13,0 say  "E-mail centrali :         " get MAIL_CE pict "@! "+repl("X",40)
@ 14,0 say  "E-mail przedstawiciela:   " get MAIL_SE pict "@! "+repl("X",40)
@ 14,col()+3 say "Aktywny (T/N) :"      get SERWIS pict "@! A";   
                                         vali SERWIS$"TN "
@ 15,0 say  "Drugi adres FTP (T/N) :   " get FTP2 pict "@! A";    
                                         vali FTP2$"TN "

@ 18, 0 say "Folder programu :         " get KARTOTEKA pict "@!" 
@ 19,0 say  "Archiwizacja danych :     " get ARCH_1
@ 20,27 get ARCH_2
@ 21,27 get ARCH_3
set curs on; read; set curs off

//_konto_ph:=KONTO_PH
_mail_ce  :=alltrim(lowe(MAIL_CE))
_mail_se  :=alltrim(lowe(MAIL_SE))
_serwis:=SERWIS                                                      //15.10.12
_tmp_ftp:=(FTP2="T")                                                 //15.10.12
_gdzie_mv :=uppe(alltrim(GDZIE_MV))
_gdzie_fir:=uppe(alltrim(GDZIE_FIR))
_gdzie_dan:=uppe(alltrim(GDZIE_DAN))
      
_format_ind:=  alltrim(FORMAT_IND)
_format_ilo:=  alltrim(FORMAT_ILO)
_format_cen:=  alltrim(FORMAT_CEN)
_format_war:=  alltrim(FORMAT_WAR)

_forfak_ilo:=_format_ilo
_forfak_cen:=_format_cen
_forfak_war:=_format_war
_forfak_ilo:= if(fieldpos("FORFAK_ILO")>0.and.!empty(FORFAK_ILO),;
                 alltrim(FORFAK_ILO),alltrim(FORMAT_ILO))
_forfak_cen:= if(fieldpos("FORFAK_CEN")>0.and.!empty(FORFAK_CEN),;
                 alltrim(FORFAK_CEN),alltrim(FORMAT_CEN))
_forfak_war:= if(fieldpos("FORFAK_WAR")>0.and.!empty(FORFAK_WAR),;
                 alltrim(FORFAK_WAR),alltrim(FORMAT_WAR))

_len_naz:=  LEN_NAZ
_len_opi:=LEN_OPI
_opisy_tow:=  OPISY_TOW
_opakowania:=  OPAKOWANIA
_kartoteka:=  alltrim(KARTOTEKA)
_nr_kasy:=1  //NR_KASY
_szuflada:=1  //SZUFLADA
use
_sc:=_kartoteka+"#"+numer_stan+"\"  // sciezka do folderu robo

if !file(_sc+"PARADRUK.DBF")                           //#23.10
  copy file PARADRUK.DBF to (_sc+"PARADRUK.DBF")
  _use(_sc+"PARADRUK","E!")
  inde on WARIANT to (_sc+"PARADRUK")
  use
endif

RETURN NIL

****************************************************************************
FUNCTION STOP_SORT()
if inkey()==K_ESC
  if QTN("Przerwa sortowanie ?")
    @ 23,0 clea to 23,40; close data; BREAK
  endif
endif
RETU NIL

*******************************************************************************
FUNCTION KOLORY()
local _ret:={1,2}

if .F.
 _ret:={9,2} 
endi

/*
   _ret:={11,2}          //ty
   _ret:={9,2}           //czerwony                
   _ret:={10,2}          //magenta                
   _ret:={12,2}          //niebieski
   _ret:={1,2}           //zwyky    
   _ret:={5,2}           //inwersja    
   _ret:={8,2}           //intensywny  
*/
RETURN _ret

*******************************************************************************
FUNCTION ROK(_data)
RETURN subs(dtos(_data),1,4)

*******************************************************************************
FUNCTION PH(_konto)
RETURN subs(trans0(val(_konto),5),4,2)

*******************************************************************************
FUNCTION UWAGI()
RETURN padr(" "+UWAGI,74)

*******************************************************************************
FUNCTION TOWAR()
loca _t:=s_i(INDEKS)+" "+padr(NAzWA_TOW,_len_naz)+" "+;
                         padr(OPIS_TOW, _len_opi)
RETURN strtran(strtran(_t,"   "," "),"  "," ")

*******************************************************************************
FUNCTION ESL_KONT()
local _tex:='۲  SOWNIK KONT PRZEDSTAWICIELI HANDLOWYCH  '

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use("SL_KONT","S"); BREAK; endi
set index to SL_KONT

go top
CPEDIT  POZ: 1,,23,               ;
        DEF: "SL_KONT"            ;
        POZWER: "V1"              ;
        PION: ,,,                 ;
        INDEXY: {"konto"}         ;
        EDYCJA: .T.               ;
        DODAWANIE: .T.            ;
        KASOWANIE: HA(_haslo)     ;
        SIEC: REKORD              ;
        ODTWORZ:.f.

dbeval({|| if(rlock(),(dbdelete(),dbunlock()),NIL)},{|| empty(MAIL)})

go top
CPDRUK  DEF: "SL_KONT"               ;
        WERSJA: "V1"              ;
        TYTUL: "SOWNIK KONT PRZEDSTAWICIELI HANDLOWYCH";
        WARIANT: 4

END SEQUENCE
close data
RETURN NIL

*******************************************************************************
FUNCTION KONTO_OK()
RETURN empty(KONTO).or.!" "$KONTO.and.subs(KONTO,1,3)="000".and.;
       subs(KONTO,4,2)>="00".and.;
       subs(KONTO,4,2)<="25"         //ze wzgldu na CRM i numery firm wlasnych
                                     //od A do Z

*******************************************************************************
FUNCTION SFIRAN()                                           
loca _tex:='۲  STAN MAGAZYNOWY FIRAN  '
priv _nr_mag:="001",_err:=.f.,_zmiana:=.f.

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use(_gdzie_mv+"TOW","R"); BREAK; endi
set index to (_gdzie_mv+"TOW_IN"),(_gdzie_mv+"TOW_NA")

sele 0
if !_use(_gdzie_mv+"MAG"+_nr_mag,"R","MAG"); BREAK; endif
set index to (_gdzie_mv+"M" + _nr_mag+"_IP0")

sele 0
if !_use(_gdzie_mv+"FIRANY","S"); BREAK; endi
set index to (_gdzie_mv+"FIRANY_I"),;        //s_i(INDEKS)+str(KLASA,3)
             (_gdzie_mv+"FIRANY_N")          //NAZWA_TOW+str(KLASA,3)
set rela to s_i(INDEKS) into TOW

go top
CPEDIT  POZ: 1,,23,                ;
        DEF: "FIRANY"              ;
        POZWER: "V1"               ;
        POZSLAD: " "+s_i(INDEKS)+" "+padr(NAzWA_TOW,_len_naz)+" "+;
                 padr(OPIS_TOW,_len_opi)+" "+JM+" "+str(MB(),4)+;
                 "  "+ZAKR() ;
        PION: ,,,                  ;
        INDEXY: {"indeks","nazwa"} ;
        KOLORUJ: KOLORY_FIR()      ;
        KASOWANIE: TOW->FIRANA<>"T".and.BLOKADA=0.and.HA("BAFPOL");  //24.01.17
        SIEC: REKORD               ;
        ODTWORZ:.f.

go top
CPDRUK  DEF: "FIRANY"             ;
        WERSJA: "V1"              ;
        TYTUL: "STAN MAGAZYNU FIRAN "+dtoc(date())+" "+subs(time(),1,5);
        WARIANT: 1

END SEQUENCE
close data
RETURN NIL

*******************************************************************************
FUNCTION MB()
loca _mb:=0,_ind:=s_i(INDEKS)

MAG->(dbseek(s_i(_ind)))
MAG->(dbeval({|| _mb+=STAN},,{|| s_i(INDEKS)=s_i(_ind) }))
RETURN _mb

*******************************************************************************
FUNCTION ZAKR()
loca _z:="    -    ",_s:=sele(),_r:=recn(),_o:=indexord(),;
     _s1:=0,_s2:=0,_ind:=s_i(INDEKS)

dbsetorder(1)
dbseek(_ind)
dbeval({|a,b| a:=if(KLASA=10,0,KLASA-5),;
                       b:=KLASA,;
                       _s1+=a*STAN, _s2+=b*STAN},,;
                {||s_i(INDEKS)=_ind})
_z:=str(_s1,4)+"-"+padr(ltrim(str(_s2,4)),4)
dbgoto(_r)
dbsetorder(_o)
if STAN<=0
  RETURN "["+_z+")"
endi
RETURN "("+_z+"]"

*******************************************************************************
FUNCTION KOLORY_FIR()
local _ret:={1,2}

if !ZAKR_OK()
  _ret:={10,2}          
endi                
RETURN _ret

*******************************************************************************
FUNCTION ZAKR_OK()
loca _r:=recn(),_o:=indexord(),_ind:=s_i(INDEKS),;
     _s1:=0,_s2:=0,_ok:=.f.,_s:=0

_s:=MB(_ind)

dbsetorder(1)
dbseek(s_i(_ind))
dbeval({|a,b| a:=if(KLASA=10,0,KLASA-5),;
                       b:=KLASA,;
                       _s1+=a*STAN, _s2+=b*STAN},,;
                {||s_i(INDEKS)=_ind})

if _s>=0
  _ok:=_s>_s1.and._s<=_s2
else
  _ok:=_s>=_s2.and._s<_s1
endi
dbsetorder(_o)
dbgoto(_r)

RETURN _ok

*******************************************************************************
FUNCTION ZAKR2()
loca _z:="    -    ",_s:=sele(),_r:=recn(),_o:=indexord(),;
     _s1:=0,_s2:=0,_ind:=s_i(INDEKS),_zl:=0,_ocolor:=setcolor(_ekra_blo)  

dbsetorder(2)
dbseek(_ind)
dbeval({|a,b| a:=if(KLASA=10,0,KLASA-5),;
                       b:=KLASA,;
                       _s1+=a*REZERWACJA, _s2+=b*REZERWACJA},,;
                {||s_i(INDEKS)=_ind})
_z:=str(_s1,4)+"-"+padr(ltrim(str(_s2,4)),4)

dbsetorder(2)
dbeval({|| _zl+=REZERWACJA*KLASA*TOW->CENA_1})

@ 23,0 say "Warto zarezerwowanych firan :";
             +transform(_zl,"@ZE 999,999.99")+" z"

setcolor(_ocolor)  

dbsetorder(_o)
dbgoto(_r)

if STAN<=0
  RETURN "["+_z+")"
endi
RETURN "("+_z+"]"

*******************************************************************************
FUNCTION RFIRAN()                                           
loca _tex:='۲  REZERWACJA FIRAN  '
loca _data:=date(),_czas:=time(),_kor:=2                             //24.11.14
priv _nr_mag:="001",_err:=.f.,_zmiana:=.f.,_konto:=_konto_ph,;
     _nr_kon:=space(5),_ato_ph:="",apom:={},_wart:=0,_uwagi:=spac(30),;
     _nip:=spac(15)                                                  //22.09.16

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use(_gdzie_mv+"TOW","R"); BREAK; endi
set index to (_gdzie_mv+"TOW_IN"),(_gdzie_mv+"TOW_NA")

sele 0
if !_use(_gdzie_mv+"MAG"+_nr_mag,"R","MAG"); BREAK; endif
set index to (_gdzie_mv+"M" + _nr_mag+"_IP0")

sele 0
if !_use(_gdzie_mv+"BLOKADYF","S"); BREAK; endif
set index to (_gdzie_mv+"BLOKF_F"),; //NR_KON+s_i(INDEKS)+str(KLASA,3)
             (_gdzie_mv+"BLOKF_K"),; //KONTO+NR_KON+s_i(INDEKS)+str(KLASA,3) 
             (_gdzie_mv+"BLOKF_I"),; //s_i(INDEKS)+str(KLASA,3)+KONTO 
             (_gdzie_mv+"BLOKF_D")   //dtos(DATA_BLO)+KONTO+NR_KON    

sele 0
if !_use(_gdzie_mv+"FIRANY","S"); BREAK; endi
set index to (_gdzie_mv+"FIRANY_I"),;        //s_i(INDEKS)+str(KLASA,3)
             (_gdzie_mv+"FIRANY_N")          //NAZWA_TOW+str(KLASA,3)
set rela to s_i(INDEKS) into TOW

sele 0
if !_use("SL_KONT","S"); BREAK; endi
set index to SL_KONT

sele 0
if !_use(_gdzie_fir+"FIRMY","S","KON"); BREAK; endi
set index to (_gdzie_fir+"FIRMY_NR"), (_gdzie_fir+"FIRMY_NA"),;
             (_gdzie_fir+"FIRMY_NI"), (_gdzie_fir+"FIRMY_AD")

@ 1,0 say "Konto :" get _konto pict "@K 99999";
      when SLGET("SL_KONT","SL_KONT","V1",1,1,{"konto"},,.f.);
           vali SZ().and.SL("SL_KONT","SL_KONT","V1",1,1).and.SLGET() 
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

sele SL_KONT
loca for KONTO==_konto
_ato_ph:=lowe(alltrim(MAIL))

sele KON
if _konto<>"00000"
  set filt to KONTO==_konto.or.NR_KON="00000"
  go top

endi

@ 1,15 say "Firma :" get _nr_kon pict "99999";
       when SLGET("KON","KON","V1",1,1,;
                    {"numer","nazwa","NIP","miasto i ulica"},,.f.,);
       vali !empty(_nr_kon).and.(SZ().and.SL("KON","KON","V1",1,1)).and.SLGET()
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

if _nr_kon="00000"
  @ 1,30 say "NIP :" get _nip vali !empty(_nip).and.NIP_OK(_nip)
  set curs on; read; set curs off
  if lastkey()=K_ESC; BREAK; endi
endi

set filt to 
KON->(dbseek(_nr_kon))
if _nr_kon<>"00000"
  @ 1,30 say alltrim(KON->NAZWA_KON)
  @ 2,30 say alltrim(KON->MIASTO)+", "+alltrim(KON->ADRES)
endi

@ 3,0 say "Uwagi :" get _uwagi pict "@!"
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

                                                                     //24.11.14
_kor:=HorizMenu(3,41,"Tylko firany dostpne ? ",{"TAK","NIE"},1)     //21.09.16

sele 0
_astru:={}
aadd(_astru,{"INDEKS    ","C",20,0})
aadd(_astru,{"NAZWA_TOW ","C",30,0})
aadd(_astru,{"OPIS_TOW  ","C",20,0})
aadd(_astru,{"JM        ","C", 4,0})
aadd(_astru,{"KLASA     ","N", 3,0})
aadd(_astru,{"STAN      ","N", 4,0})
aadd(_astru,{"BLOKADA   ","N", 4,0})
aadd(_astru,{"REZERWACJA","N", 4,0})
//aadd(_astru,{"NR_KON    ","C",20,0})
//aadd(_astru,{"KONTO     ","C",20,0})

dbcreate(_sc+"FIRANY_R",_astru)
_use(_sc+"FIRANY_R","E")

sele FIRANY
set order to 0

if _kor=1                                                            //21.09.16
  set filt to STAN-BLOKADA>0
endi

for i:=1 to fcount(); aadd(apom,i); next
go top
Dbeval({ ||POLCOPY(FIRANY,FIRANY_R)})
set filt to
set order to 1
go top

sele FIRANY_R
inde on padr(NAZWA_TOW,_len_naz)+str(KLASA,3) to (_sc+"FIRANY_N")
inde on s_i(INDEKS)+str(KLASA,3)              to (_sc+"FIRANY_I")
inde on s_i(INDEKS)+str(KLASA,3) to (_sc+"FIRANY_R") for REZERWACJA<>0
set index to (_sc+"FIRANY_N"),(_sc+"FIRANY_I"),(_sc+"FIRANY_R")
set rela to s_i(INDEKS) into TOW

do while .T.

  set filt to 
  go top
  CPEDIT  POZ: 4,,22,               ;
          DEF: "FIRANY"             ;
          POZWER: "V2"              ;
          POZSLAD: " "+s_i(INDEKS)+" "+padr(NAzWA_TOW,_len_naz)+" "+;
               padr(OPIS_TOW,_len_opi)+" "+JM+" "+str(MB(),4)+;
               "  "+ZAKR2() ;
          PION: ,,,                 ;
          INDEXY: {"nazwa","indeks","rezerwacja"};
          EDYCJA: CPNazwa()="REZERWACJA" ;
          DODAWANIE: .F.            ;
          KASOWANIE: .F.            ;
          ODTWORZ:.F.

  set filt to REZERWACJA<>0

  go top
  CPEDIT  POZ: 4,,22,               ;
          DEF: "FIRANY"             ;
          POZWER: "V2"              ;
          POZSLAD: " "+s_i(INDEKS)+" "+padr(NAzWA_TOW,_len_naz)+" "+;
               padr(OPIS_TOW,_len_opi)+" "+JM+" "+str(MB(),4)+;
               "  "+ZAKR2() ;
          PION: ,,,                 ;
          INDEXY: {"nazwa","indeks"};
          ODTWORZ:.F.

  _wyb:=HorizMenu(24,0,"",{"POPRAWA","AKCEPTACJA","REZYGNACJA"},1)
  @ 24,0

  if _wyb=3
    tone(220,2)
    QK("Nie dokonano rezerwacji")
    BREAK
  elseif _wyb=2.and.HA(_haslo);  exit
  endi  
  loop
endd

BLOKADYF->(FBLOK())
FIRANY->(FBLOK())
FIRANY->(dbsetorder(1))
_data:=date()
_czas:=time()

sele FIRANY_R
dbsetorder(3)
_wart:=0
dbeval({|| _wart+=REZERWACJA*KLASA*TOW->CENA_1 })

dbsetorder(1)
set filt to REZERWACJA<>0
go top
do while !eof()
 
  FIRANY->(dbseek(s_i(FIRANY_R->INDEKS)+str(FIRANY_R->KLASA,3)))
  FIRANY->BLOKADA+=FIRANY_R->REZERWACJA

  BLOKADYF->(dbappend())
  BLOKADYF->KONTO     :=_konto
  BLOKADYF->NR_KON    :=_nr_kon
  BLOKADYF->DATA_BLO  :=_data
  BLOKADYF->CZAS_BLO  :=_czas
  BLOKADYF->TYP       :="R"
  BLOKADYF->INDEKS    :=s_i(FIRANY_R->INDEKS)
  BLOKADYF->KLASA     :=FIRANY_R->KLASA
  BLOKADYF->REZERWACJA:=FIRANY_R->REZERWACJA
  BLOKADYF->UWAGI     :=_uwagi
  BLOKADYF->OPERATOR  :=_operator
  BLOKADYF->NIP       :=_nip                                         //22.09.16

  sele FIRANY_R
  skip
endd

FIRANY->(dbunlock())
BLOKADYF->(dbunlock())

KON->(dbseek(_nr_kon))

dele file (_sc+"REZERWACJA.TXT")
_plik:=fcreate(_sc+"REZERWACJA.TXT")

fwriteln(_plik,"REZERWACJA FIRAN :")
cbody:="REZERWACJA FIRAN :"+CRLF

fwriteln(_plik,LAT_WIN("Firma : "+_nr_kon+" "+alltrim(KON->NAZWA_KON)+", "+;
                         alltrim(KON->MIASTO)+", "+alltrim(KON->ADRES)))
cbody+=LAT_STD("Firma : "+_nr_kon+" "+alltrim(KON->NAZWA_KON)+", "+;
                         alltrim(KON->MIASTO)+", "+alltrim(KON->ADRES))+CRLF

fwriteln(_plik,"Konto : "+_konto)
cbody+="Konto : "+_konto+CRLF

fwriteln(_plik,"Data :  "+dtoc(date())+" "+subs(time(),1,5))
cbody+="Data :  "+dtoc(date())+" "+subs(time(),1,5)+CRLF

if !empty(_uwagi)
  fwriteln(_plik,"Uwagi : "+LAT_WIN(_uwagi)+CRLF)
  cbody+="Uwagi : "+LAT_WIN(_uwagi)+CRLF
endi

fwriteln(_plik,"")
cbody+=CRLF

fwriteln(_plik,LAT_WIN("Indeks / Nazwa firany / Klasa [mb] / Ilo [szt] / Warto [z]"))

sele FIRANY_R
set filt to REZERWACJA<>0
go top
do while !eof()
  fwriteln(_plik,LAT_WIN(s_i(INDEKS)+spac(2)+;
    alltrim(strtran(TOW->NAZWA_TOW,"/"," "))+" "+;
    alltrim(strtran(TOW->OPIS_TOW, "/"," "))+" /     "+str(KLASA,3)+" / "+;
    str(REZERWACJA,4)+" / "+ltrim(str(REZERWACJA*KLASA*TOW->CENA_1,12,2))  ))
  skip
endd
fwriteln(_plik,"")
fwriteln(_plik,LAT_WIN("Warto zarezerwowanych firan :"+;
                                  transform(_wart,"@ZE 999,999.99")+" z"))
fwriteln(_plik,"-koniec-")
fclose(_plik)

_kon_naz:=alltrim(KON->NAZWA_KON)                                    //21.09.16
_kon_mia:=alltrim(KON->MIASTO)
_kon_adr:=alltrim(KON->ADRES)

CLOS DATA                                                            //21.09.16

*------------------------------------------------------------------------------



/*                                                                   //22.09.16
*-----------------------------------------------------------------HB_SendMail()
BEGIN SEQUENCE

_tmail:=alltrim(_mail_se)
if empty(_tmail); BREAK; endi

sele 0
if !_use("CONFIG_M","R"); BREAK; endi                               
cServer:=alltrim(SERW_SMTP)
    nPort:=PORT_SMTP
    cFrom:=alltrim(ADRES_MAIL)
    aTo:={_tmail}   
//  cBody:="Tre maila"
    cSubject:="Rezerwacja firan dla "+;                              //21.09.16
               LAT_WIN(_nr_kon+" "+_kon_naz+", "+_kon_naz+", "+_kon_adr)
    aFiles:={_sc+"REZERWACJA.TXT"}                           //<---------------
    cUser:=alltrim(USER_POP)
    cPass:=CRYPT(left(HASLO_POP,NHASLO),"ZSIWI")
    cPopServer:=alltrim(SERW_POP)  
close CONFIG_M
if empty(cfrom) .or. empty(cUser) .or. empty(cPass) .or. empty(cPopServer)
  QKE("Konieczna konfiguracja poczty elektronicznej!")
  BREAK
endi 
//cBody:=hb_strtoutf8(cBody,"PL852")
if empty(_ato_ph)
  tone(440,.5)
  QK("Brak adresu e-mail - nie wysano poczty.")
  BREAK
endi 
   HB_SendMail( cServer, , cFrom,  aTo   , , , cBody, cSubject, aFiles, cUser, cPass, cPopServer, , ,,,,)
if HB_SendMail( cServer, , cFrom, _ato_ph, , , cBody, cSubject, aFiles, cUser, cPass, cPopServer, , ,,,,)
   tone(880,1)
   QK("Wysano e-mail",4)
endi
END SEQUENCE
*------------------------------------------------------------------------------
*/

//@@@
*------------------------------------------------------ SMTPSEND.EXE //22.09.16
BEGIN SEQUENCE

if empty(_ato_ph)
  tone(440,.5)
  QK("Brak adresu e-mail PH - nie wysano potwierdzenia.")
  BREAK
endi 

if empty(_mail_from).or.empty(_mail_host).or.empty(_mail_port).or.;
   empty(_mail_pass).or.empty(_mail_user)
   QK("Brak lub bdna konfiguracja poczty nadawcy - nie wysano potwierdzenia.")
   BREAK
endi

QK("Wysyanie potwierdzenia na adres "+_ato_ph+" ...")

_tresc:=_sc+"REZERWACJA.TXT"
_temat:=strtran("Rezerwacja firan dla "+;                         
        LAT_STD(_nr_kon+" "+_kon_naz+", "+_kon_mia+", "+_kon_adr),'"'," ")

_scr:=savescreen(0,0,24,79)  

cls
_cmd:='smtpsend -f'+_mail_from+' -t'+_ato_ph+;
      ' -h'+_mail_host+' -p'+_mail_port+' -i'+_tresc+' -lu'+_mail_user+;
      ' -lp'+_mail_pass+;                    //' -a'+_zalacznik+;
      ' -s'+_temat

_plik:=fcreate("msentz.bat")
fwriteln(_plik,"cls")
fwriteln(_plik,_cmd)
fclose(_plik)

RUN msentz.bat     
 
//dele file msentz.bat

clear typeahead
inkey(3)
cls
K_OFF()
restscreen(0,0,24,79,_scr)

END SEQUENCE
*------------------------------------------------------------------------------

tone(880,1)
QK("Wykonano rezerwacj firan dla klienta "+_nr_kon)

END SEQUENCE

close data
RETURN NIL


*******************************************************************************
FUNCTION PFIRAN()                                           
loca _tex:='۲  PRZEGLDANIE REZERWACJI FIRAN  '         //12.09.16
priv _nr_mag:="001",_err:=.f.,_zmiana:=.f.,_konto:=_konto_ph,;
     _nr_kon:=space(5),_ato_ph:="",apom:={},_wart:=0,_uwagi:=spac(30)

cls
@ 0,0 say _tex

if _konto="00000"
  _konto:="     "
endi

BEGIN SEQUENCE

sele 0
if !_use(_gdzie_fir+"FIRMY","S","KON"); BREAK; endi
set index to (_gdzie_fir+"FIRMY_NR"), (_gdzie_fir+"FIRMY_NA"),;
             (_gdzie_fir+"FIRMY_NI"), (_gdzie_fir+"FIRMY_AD")

sele 0
if !_use(_gdzie_mv+"TOW","R"); BREAK; endi
set index to (_gdzie_mv+"TOW_IN"),(_gdzie_mv+"TOW_NA")

sele 0
if !_use(_gdzie_mv+"MAG"+_nr_mag,"R","MAG"); BREAK; endif
set index to (_gdzie_mv+"M" + _nr_mag+"_IP0")

sele 0
if !_use(_gdzie_mv+"BLOKADYF","S"); BREAK; endif
set index to (_gdzie_mv+"BLOKF_F"),; //NR_KON+s_i(INDEKS)+str(KLASA,3)
             (_gdzie_mv+"BLOKF_K"),; //KONTO+NR_KON+s_i(INDEKS)+str(KLASA,3) 
             (_gdzie_mv+"BLOKF_I"),; //s_i(INDEKS)+str(KLASA,3)+KONTO 
             (_gdzie_mv+"BLOKF_D")   //dtos(DATA_BLO)+KONTO+NR_KON    
set rela to NR_KON into KON
set rela to s_i(INDEKS) into TOW additive

sele 0
if !_use("SL_KONT","S"); BREAK; endi
set index to SL_KONT

@ 1,0 say "Konto :" get _konto pict "@K 99999";
      when SLGET("SL_KONT","SL_KONT","V1",1,1,{"konto"},,.f.);
           vali (empty(_konto).or.(SZ().and.SL("SL_KONT","SL_KONT","V1",1,1)));
                  .and.SLGET() 
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

sele KON
if !_konto$"00000,     "
  set filt to KONTO==_konto.or.NR_KON="00000"
  go top
endi

@ 1,15 say "Firma :" get _nr_kon pict "99999";
       when SLGET("KON","KON","V1",1,1,;
                    {"numer","nazwa","NIP","miasto i ulica"},,.f.,);
       vali (empty(_nr_kon).or.(SZ().and.SL("KON","KON","V1",1,1))).and.SLGET()
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

set filt to 
KON->(dbseek(_nr_kon))
@ 1,30 say alltrim(KON->NAZWA_KON)
@ 2,30 say alltrim(KON->MIASTO)+", "+alltrim(KON->ADRES)

sele BLOKADYF

if !empty(_konto)
  if !empty(_nr_kon)
    set filt to KONTO=_konto.and.NR_KON=_nr_kon
  else
    set filt to KONTO=_konto
  endi
elseif !empty(_nr_kon)
  set filt to NR_KON=_nr_kon
endi

go top
CPEDIT  POZ: 2,,23,               ;
        DEF: "BLOKADY"            ;
        POZWER: "V1"              ;
        POZSLAD: padr(" "+NR_KON+" "+alltrim(KON->NAzWA_KON)+", "+;
                  alltrim(KON->MIASTO),76);
        PION: ,,,                 ;
        INDEXY: {"firma","konto","indeks","data"};
        EDYCJA: CPNAZWA()="NR_KON".and.NR_KON="00000";               //27.02.15
        KASOWANIE: HA("BAFPOL");
        SIEC: REKORD;
        ODTWORZ:.F.

/*
        POZSLAD: " "+s_i(INDEKS)+" "+padr(TOW->NAzWA_TOW,_len_naz)+" "+;
               padr(TOW->OPIS_TOW,_len_opi)+" "+TOW->JM;

*/

END SEQUENCE
close data

*******************************************************************************
FUNCTION STOP()                                                      //15.11.14
if file("STOP").or.file("STOP.TXT")
 cls
 ?"Trwa serwis oprogramowania"
 ?"Maciej Popkiewicz - Comped"
 ?"tel.: 603953501, 717940497"
 ?""
 inkey(10)
 QUIT
endi
RETURN NIL

*******************************************************************************
*******************************************************************************
FUNCTION POUFNE()
local _tex:='۲  KONFIGURACJA POCZTY E-MAIL  '
local _astru:={},_pin:=PIN(),_has:=spac(6),_wybor:=0
local _ftp_open,_ftp_login,_ftp_pass,_ftp_path,;
      _ftp_open2,_ftp_logi2,_ftp_pass2,_ftp_path2

cls
@ 0,0 say _tex
@ 1,0 say "Haso : " get _has pict "@! XXXXXX"
set curs on; read; set curs off
@ 1,0


if _has=PIN()
  _mail_from :=padr("comped@wp.pl",40)   //SMTPSENT -f
  _mail_host :=padr("smtp.wp.pl",40)     //SMTPSENT -h
  _mail_port :=padr("587",40)            //SMTPSENT -p
  _mail_user :=padr("comped@wp.pl",40)   //SMTPSENT -lu
  _mail_pass :=padr("zsiwi",40)        //SMTPSENT -lp
else
  _mail_from :=padr(_mail_from,40)
  _mail_host :=padr(_mail_host,40)
  _mail_port :=padr(_mail_port,40)
  _mail_user :=padr(_mail_user,40)
  _mail_pass :=spac(40)           
endi

sele 0
if !file("CONFIG.DBT")
  _astru:={}
  aadd(_astru,{"MAIL_FROM ","C",40,0})
  aadd(_astru,{"MAIL_HOST ","C",40,0})
  aadd(_astru,{"MAIL_PORT ","C",40,0})
  aadd(_astru,{"MAIL_USER ","C",40,0})
  aadd(_astru,{"MAIL_PASS ","C",40,0})
  dbcreate("CONFIG.DBT",_astru)
endi
_use("CONFIG.DBT","E!","CNF")
if lastrec()=0
  appe blan
endi

do while .t.

  @ 1,0 say "MAIL_FROM : " get _mail_from pict repl("X",40)
  @ 2,0 say "MAIL_HOST : " get _mail_host pict repl("X",40)
  @ 3,0 say "MAIL_PORT : " get _mail_port pict repl("X",40)
  @ 4,0 say "MAIL_USER : " get _mail_user pict repl("X",40)
  @ 5,0 say "MAIL_PASS : " get _mail_pass pict repl("X",40)
  set curs on; read; set curs off

  _wybor:=HorizMenu(7,0,"",{"POPRAWA","AKCEPTACJA","REZYGNACJA"},1)
  @ 7,0

  if _wybor=1; loop; endi
  if _wybor=2.and.HA(_haslo)
    CNF->MAIL_FROM :=CRYPT(_mail_from,"COMPED")
    CNF->MAIL_HOST :=CRYPT(_mail_host,"COMPED")
    CNF->MAIL_PORT :=CRYPT(_mail_port,"COMPED")
    CNF->MAIL_USER :=CRYPT(_mail_user,"COMPED")
    CNF->MAIL_PASS :=CRYPT(_mail_pass,"COMPED")

    tone(880,2)
    close data
    QK("Utworzono plik CONFIG.DBT")
    exit
  endi
  tone(220,2)
  close data
  QK("Nie utworzono pliku CONFIG.DBT")
  exit
endd
close data
RETURN NIL

/*
SMTPSend v3.24 (WinXP)
(c) copyright DataEnter, Michael Kocum 1993-2003

Error: No recipients address! Use -t
SMTPSend uses the following switches:

-f<Address>          Senders address
-t<Address>          Recipients address
-c<Address>          CC address
-b<Address>          BCC address
-h<Host>             Send message to host
-p<Port>             Port (default is port 25)
-s<Subject>          Subject of the message
-a<AttachFile>       File(s) to attach to the message (wildcards allowed)
-i<ImportFile>       File(s) to import into message body (wildcards allowed)
-1                   Enable Single-To mode
-v                   Verbose mode (show message transfer)
-g<SMTPFile>         Send a raw RFC 821/822 file (ignores -c,-a,-i,-s,-r)

Press any key or ESC to cancel...

-lu<User>            SMTP authentication user
-lp<Password>        SMTP authentication password
s-lCA<File>           TLS CA-Certificate PEM file

-n                   Force normal SMTP (do not use ESMTP)
-dNFSD               DSN Never, Failure, Success, Delay
-os<Flag>            SMTP options
-mfH                 Message format HTML
-mhL                 Message header line
-mRR                 Enable Read Receipt
-@<ArgFile>          Read additional arguments from a file (-@FILE.EXT)

Example:
smtpsend -fcomped@wp.pl -tmmpop@wp.pl -tmpop@comped.com.pl -hsmtp.wp.pl
         -p587 -imail.txt -lucomped@wp.pl -lpzsiwi -aDANE_04.ARJ
         -sDane handlowe PH 04
*/

*******************************************************************************
FUNCTION DAJ_POUFNE()

dele file msentz.bat                                //kasowanie danych poufnych
dele file msent.bat
dele file fsent.scr
dele file fread.scr
dele file fsentz.scr
dele file freadz.scr

sele 0
if !file("CONFIG.DBT")
  QKE("UWAGA : Brak pliku konfiguracyjnego CONFIG.DBT")
  _mail_from :=spac(40)
  _mail_host :=spac(40)
  _mail_port :=spac(40)
  _mail_user :=spac(40)
  _mail_pass :=spac(40)
elseif _use("CONFIG.DBT","R")
  _mail_from :=alltrim(CRYPT(MAIL_FROM,"COMPED"))
  _mail_host :=alltrim(CRYPT(MAIL_HOST,"COMPED"))
  _mail_port :=alltrim(CRYPT(MAIL_PORT,"COMPED"))
  _mail_user :=alltrim(CRYPT(MAIL_USER,"COMPED"))
  _mail_pass :=alltrim(CRYPT(MAIL_PASS,"COMPED"))
  use
else
  _mail_from :=spac(40)
  _mail_host :=spac(40)
  _mail_port :=spac(40)
  _mail_user :=spac(40)
  _mail_pass :=spac(40)
endi

RETURN NIL

*******************************************************************************
FUNCTION NIP_OK(_nip)
local _wagi:={6,5,7,2,3,4,5,6,7},_chk:=0,i,_liczby:=.t.,_ok:=.T.

_nip:=alltrim(charrem("-",_nip))

if empty(_nip); RETURN .T.; endi

if len(_nip)=10
  for i:=1 to 10
    if !subs(_nip,i,1)$"0123456789"
      _liczby:=.f.
      exit
    endi
  next
  if _liczby
    for i:=1 to 9
      _chk:=_chk+(_wagi[i]*val(subs(_nip,i,1)))
    next
    _chk:=_chk%11
  endi
endi

if (len(_nip)<>10.or.!_liczby.or._chk<>val(subs(_nip,10,1)))
  QK("Bdny NIP")
  _ok:=.F.
endi
RETURN _ok

*******************************************************************************
FUNCTION AFIRAN(_auto)                                               //02.10.16
loca _tex:='۲  AKTUALIZACJA ZBIORU REZERWACJI FIRAN  '        
priv _nr_mag:="001",_err:=.f.,_zmiana:=.f.,_konto:=space(5),;
     _nr_kon:=space(5),_ato_ph:="",apom:={},_wart:=0,_uwagi:=spac(30),;
     _data_zbi:=date()-7,_data_prz:=date()-7,_ablo:={},_zbi:=0,_prz:=0,;
     _azbi:={},_aprz:={}

DEFAULT _auto TO .F.


cls
if !_auto
  @ 0,0 say _tex
endi

BEGIN SEQUENCE

if _auto
  if !(_auto_akt="T".and._data_akt<date()-7)
    BREAK
  endi
  _zbi:=1 //TAK
  _prz:=1 //TAK
  QK("Aktualizacja rezerwacji firan")
endi

sele 0
if !_use(_gdzie_mv+"FIRANY","S"); BREAK; endi 
set index to (_gdzie_mv+"FIRANY_I"),;        //s_i(INDEKS)+str(KLASA,3)
             (_gdzie_mv+"FIRANY_N")          //NAZWA_TOW+str(KLASA,3)

sele 0
if !_use(_gdzie_fir+"FIRMY","S","KON"); BREAK; endi
set index to (_gdzie_fir+"FIRMY_NR"), (_gdzie_fir+"FIRMY_NA"),;
             (_gdzie_fir+"FIRMY_NI"), (_gdzie_fir+"FIRMY_AD")

sele 0
if !_use(_gdzie_mv+"TOW","R"); BREAK; endi
set index to (_gdzie_mv+"TOW_IN"),(_gdzie_mv+"TOW_NA")

sele 0
if !_use(_gdzie_mv+"MAG"+_nr_mag,"R","MAG"); BREAK; endif
set index to (_gdzie_mv+"M" + _nr_mag+"_IP0")

sele 0
if !_use(_gdzie_mv+"BLOKADYF","S"); BREAK; endi
set index to (_gdzie_mv+"BLOKF_F"),; //NR_KON+s_i(INDEKS)+str(KLASA,3)
             (_gdzie_mv+"BLOKF_K"),; //KONTO+NR_KON+s_i(INDEKS)+str(KLASA,3) 
             (_gdzie_mv+"BLOKF_I"),; //s_i(INDEKS)+str(KLASA,3)+KONTO 
             (_gdzie_mv+"BLOKF_D")   //dtos(DATA_BLO)+KONTO+NR_KON    
set rela to NR_KON into KON
set rela to s_i(INDEKS) into TOW additive

sele 0
if !_use("SL_KONT","S"); BREAK; endi
set index to SL_KONT

if !_auto 
  @ 1,0 say "Konto :" get _konto pict "@K 99999";
        when SLGET("SL_KONT","SL_KONT","V1",1,1,{"konto"},,.f.);
             vali (empty(_konto).or.(SZ().and.SL("SL_KONT","SL_KONT","V1",1,1)));
                    .and.SLGET() 
  set curs on; read; set curs off
  if lastkey()=K_ESC; BREAK; endi

  sele KON
  if !empty(_konto).and._konto<>"00000"
    set filt to KONTO==_konto
    go top
  endi

  @ 1,15 say "Firma :" get _nr_kon pict "99999";
         when SLGET("KON","KON","V1",1,1,;
                      {"numer","nazwa","NIP","miasto i ulica"},,.f.,);
         vali (empty(_nr_kon).or.(SZ().and.SL("KON","KON","V1",1,1))).and.SLGET()
  set curs on; read; set curs off
  if lastkey()=K_ESC; BREAK; endi
  set filt to 
  
  if !empty(_nr_kon)  //.and._nr_kon<>"00000"
    KON->(dbseek(_nr_kon))
    @ 1,30 say alltrim(KON->NAZWA_KON)
    @ 2,30 say alltrim(KON->MIASTO)+", "+alltrim(KON->ADRES)
  endi

  _zbi:=HorizMenu(3,0,"Likwidacja rezerwacji zbilansowanych ? ",;
                    {"TAK","NIE"},2)
  if _zbi=1
    @ 3,37
    @ 3,37 say "do dnia" get _data_zbi vali _data_zbi<=date()-7
    @ 3,54 say "(max do "+dtoc(date()-7)+")"
    set curs on; read; set curs off
    if lastkey()=K_ESC; BREAK; endi
  endi

  _prz:=HorizMenu(4,0,"Likwidacja rezerwacji przedatowanych ? ",;
                      {"TAK","NIE"},2)
  if _prz=1
    @ 4,37
    @ 4,37 say "do dnia" get _data_prz vali _data_prz<=date()-7
    @ 4,54 say "(max do "+dtoc(date()-7)+")"
    set curs on; read; set curs off
    if lastkey()=K_ESC; BREAK; endi
  endi

  if _zbi<>1.and._prz<>1
    QK("Nie wykonano aktualizacji")
    BREAK
  endi

endi

if !_auto
  QPC(1)
endi

sele BLOKADYF
if !empty(_konto)
  if !empty(_nr_kon)
    set filt to KONTO=_konto.and.NR_KON=_nr_kon
  else
    set filt to KONTO=_konto
  endi
elseif !empty(_nr_kon)
  set filt to NR_KON=_nr_kon
endi

go top
do while !eof()
  if (_l:=ascan(_ablo,{|a| a[1]=KONTO+NR_KON+str(KLASA,3)+s_i(INDEKS)}))=0
     aadd(_ablo, {KONTO+NR_KON+str(KLASA,3)+s_i(INDEKS),ctod(""),0})
     _l:=len(_ablo)
  endi
  _ablo[_l][2]:=max(_ablo[_l][2],DATA_BLO)
  _ablo[_l][3]:=_ablo[_l][3]+REZERWACJA
  skip
endd

/*
go top
do while !eof()
  _l:=ascan(_ablo,{|a| a[1]=KONTO+NR_KON+str(KLASA,3)+s_i(INDEKS)})
  rlock()
  repl NIP with dtoc(_ablo[_l][2])
  dbunlock()
  skip
endd
*/

_aprz:={}
_azbi:={}
if _prz=1
  for _i:=1 to len(_ablo)
    if _ablo[_i][2]<=_data_prz
      aadd(_aprz,{_ablo[_i][1],_ablo[_i][2],_ablo[_i][3]})
    endi
  next
endi
if _zbi=1
  for _i:=1 to len(_ablo)
    if _ablo[_i][2]<=_data_zbi.and._ablo[_i][3]=0
      aadd(_azbi,{_ablo[_i][1],_ablo[_i][2],_ablo[_i][3]})
    endi
  next
endi

sele BLOKADYF
go top
do while !eof()
  
  if _prz=1.and.(_l:=ascan(_aprz,;
                {|a| a[1]=KONTO+NR_KON+str(KLASA,3)+s_i(INDEKS)}))>0
    if rlock()
      repl NIP with dtoc(_aprz[_l][2])+str(_aprz[_l][3],4)
      dbdelete(); dbunlock()
    endi
  endi

  if _zbi=1.and.(_l:=ascan(_azbi,;
         {|a| a[1]=KONTO+NR_KON+str(KLASA,3)+s_i(INDEKS)}))>0

    if rlock()
      repl NIP with dtoc(_azbi[_l][2])+str(_azbi[_l][3],4)
      dbdelete(); dbunlock()
    endi
  endi

  skip
endd

sele BLOKADYF
set filt to
copy to (_sc+"BLOF") for !dele()
CPClose(BLOKADYF)

sele 0
_use(_sc+"BLOF","E!")
index on s_i(INDEKS)+str(KLASA,3) to (_sc+"BLOF")
total on s_i(INDEKS)+str(KLASA,3) fiel REZERWACJA to (_sc+"BLOF_T")
CPClose(BLOF)

sele 0
_use(_sc+"BLOF_T","E!")
index on    s_i(INDEKS)+str(KLASA,3) to (_sc+"BLOF")

sele FIRANY
set rela to s_i(INDEKS)+str(KLASA,3) into BLOF_T
go top
do while !eof()
  if rlock()
    repl BLOKADA with BLOF_T->REZERWACJA
    dbunlock()
  endi
  skip
endd

CPClose(FIRANY)
CPClose(BLOF_T)
dele file (_sc+"BLOF.DBF")
dele file (_sc+"BLOF_T.DBF")
dele file (_sc+"BLOF.NTX")

sele 0
if _use(_gdzie_mv+"BLOKADYF","E")
  set index to (_gdzie_mv+"BLOKF_F"),; //NR_KON+s_i(INDEKS)+str(KLASA,3)
               (_gdzie_mv+"BLOKF_K"),; //KONTO+NR_KON+s_i(INDEKS)+str(KLASA,3) 
               (_gdzie_mv+"BLOKF_I"),; //s_i(INDEKS)+str(KLASA,3)+KONTO 
               (_gdzie_mv+"BLOKF_D")   //dtos(DATA_BLO)+KONTO+NR_KON    
  pack
endi
use

if !_auto
  QPC(0)
endi

clos data

if _auto                                                             //02.10.16

  sele 0
  if _use("STATUS","F")
    repl DATA_AKT with date()-7
  endi
  use
endi

if !_auto
  QK("Wykonano aktualizacj rezerwacji firan.")
endi

END SEQUENCE
clos data

RETURN NIL

*******************************************************************************
