#include "comped.ch"
#include "inkey.ch"
#include "setcurs.ch"
#include "fileio.ch"              
#include "directry.ch"
#include "pscript.ch"

#xtranslate FTell(<fHandle>) => FSeek(<fHandle>, 0, FS_RELATIVE)
#xtranslate :fileHandle   => :cargo\[1\]
#xtranslate :fileLine     => :cargo\[2\]
#xtranslate :lineOffset   => :cargo\[3\]

#define FILE_BRWS_NUM_IVARS 3

#command @ <row>, <col> GET <var>                                ;
                        [<clauses,...>]                          ;
                        PASSWORD                                 ;
                        [<moreClauses,...>]                      ;
                                                                 ;
      => @ <row>, <col> GET <var>                                ;
                        [<clauses>]                              ;
                        SEND reader := {|oGet|                   ;
                                        GetPassword(oGet) }      ;
                        [<moreClauses>]

static max_line_len:=0,_k_tab:=.f.
static _data_beg:=NIL, _data_end:=NIL

******************************  do przeleww  *********************************
#define  PICA       ( chr(18) + chr(27) + chr(80) )  
#define  ELITE      ( chr(18) + chr(27) + chr(77) )  
#define  PICA_COND  ( chr(15) + chr(27) + chr(80) )  
#define  ELITE_COND ( chr(15) + chr(27) + chr(77) )  
#define  KOD_RESET  ( chr(27) + chr(64) )

#define  PICA_I       ( chr(18) )  
#define  ELITE_I      ( chr(27) + chr(58) )
#define  PICA_COND_I  ( chr(18) + chr(15) )    
#define  ELITE_COND_I ( chr(27) + chr(58) + chr(15) )

#define  PICA_HP       (  chr(27) + chr(40) + chr(115) + "10.0" + chr(72) )
*                          chr(27) + chr(40) + "s4102T" )  
#define  PICA_COND_HP  chr(27) + chr(40) + chr(115) + "17" + chr(72)
#define  ELITE_COND_HP  ( ;
                          chr(27) + chr(40) + "s20H" )

*                          chr(27) + chr(40) + "s4102T" )  

#define  ELITE_HP          ( ;
                          chr(27) + chr(40) + "s12H" )
*                          chr(27) + chr(40) + "s4102T" )  

#define ENLARGE_ON  chr(27)+"W1"   // ESC/P + IBM
#define ENLARGE_OFF chr(27)+"W0"

#define DRAFT chr(27)+"x0"
#define DRAFT_HP chr(27)+"(s1Q"

#define CR    Chr(13)
#define LF    Chr(10)
#define CRLF  CR + LF

*******************************************************************************
FUNCTION UZG_WER()                                                
local _ret:=.f., _astru:={},_uzg:=.f.

tone(200,1) 
QPC(1," Prosz czeka. Aktualizacja wersji programu ... ")

BEGIN SEQUENCE

inkey(5)

sele 0
_use("CONFIG","R!")
public _format_ind:= alltrim(FORMAT_IND)

sele 0
_use("STATUS","R!")
_uzg:=(fieldpos("DATA_LIC")=0.or.len(DATA_LIC)<6)
CPClose(STATUS)
if _uzg
  _astru:={}
  aadd(_astru,{"DATA_LIC  ","C",6,0})
  dbcreate(_sc+"STATUS",_astru)
  _use(_sc+"STATUS","E!")
  appe from STATUS
  copy to STATUS
  CPClose(STATUS)
  dele file (_sc+"STATUS.DBF")
endi

if _use("STATUS","F").and.fieldpos("DATA_LIC")>0
  repl DATA_LIC with _d_lic
  CPClose(STATUS)
  _ret:=.T.
endi

END SEQUENCE
clos data
QPC(0," Prosz czeka. Aktualizacja wersji programu ... ")

if HorizMenu(24,0,"Wykona sortowanie kartotek ?",{"TAK","NIE"},1)=1
  cls
  sele 0
  _use("CONFIG","R!")
  _wersja:= CONFIG->WERSJA
  _gdzie_mv :=uppe(alltrim(GDZIE_MV))
  _gdzie_fir:=uppe(alltrim(GDZIE_FIR))
  _gdzie_dan:=uppe(alltrim(GDZIE_DAN))
  _format_ind:= alltrim(FORMAT_IND)
  _format_ilo:= alltrim(FORMAT_ILO)
  _format_cen:= alltrim(FORMAT_CEN)
  _format_war:= alltrim(FORMAT_WAR)
  _len_naz:=LEN_NAZ
  use
  
  INDEX()
endi

RETURN _ret

*******************************************************************************
FUNCTION ZAOKR(x,m)
local cstr,nStr,znak:=1
local nRound
if .f. //m=2
  if x<0; znak:=-1; x:=-x; endi
  cstr:=str(x,15,4)
  if subs(cstr,14,1)>="5"
    x+=0.005
  endi
  nround:=val(str(x,15,2))
  if znak=-1; nround:=-nround; endi
elseif m>=0 
  nRound:=round(x,m)
  nStr:=val(str(x,15,m))
  RETU if(x<0,min(nStr,nRound),max(nStr,nRound))
end
RETURN nRound

*******************************************************************************
FUNCTION SKOCZ()
RETURN if(KEY(chr(24)+chr(13)),0,0)

*******************************************************************************
FUNCTION MAZ_LAT(_s)
local _n,_i

static amaz:=;
      {134,141,145,146,164,162,158,166,167,143,149,144,156,165,163,152,160,161}
static a852:=;
      {165,134,169,136,228,162,152,171,190,164,143,168,157,227,224,151,141,189}

if upper(chr(169))=chr(168)      // program w LATIN
  RETURN _s              
endi

for _i:=1 to len(_s)
  _n:=ascan(amaz,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(a852[_n]))
  endi
next
RETURN _s    

*******************************************************************************
FUNCTION LAT_MAZ(_s)
local _n,_i
static amaz:=;
      {134,141,145,146,164,162,158,166,167,143,149,144,156,165,163,152,160,161}
static a852:=;
      {165,134,169,136,228,162,152,171,190,164,143,168,157,227,224,151,141,189}
for _i:=1 to len(_s)
  _n:=ascan(a852,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(amaz[_n]))
  endi
next
RETURN _s    

*******************************************************************************
FUNCTION ARCH()
local _tex:= '۲  ARCHIWIZACJA DANYCH  ',;
      _erc1:=.f.,_erc2:=.f.,_erc3:=.f.,_w:=1,_cmd1,_cmd2,_cmd3
local _scl:= _kartoteka+"#"+numer_stan

cls
@ 0,0 say _tex

if !_use("CONFIG","R!")
  QKE("Nie wykonano archiwizacji !")
  RETURN NIL
endi
if fieldpos("ARCH_1")=0.or.empty(ARCH_1)
  QKE("Bd konfiguracji. Nie wykonano archiwizacji !")
  RETURN NIL
endi
_cmd1:=alltrim(ARCH_1)
_cmd2:=alltrim(ARCH_2)
_cmd3:=alltrim(ARCH_3)
use

cls
/*                                                                        //xHB
_erc1:=!SWPRUNCMD(_cmd1,0,"",_scl)
if !empty(_cmd2)
  _erc2:=!SWPRUNCMD(_cmd2,0,"",_scl)
endi
if !empty(_cmd3)
  _erc3:=!SWPRUNCMD(_cmd3,0,"",_scl)
endi
*/

_erc1:=.f.
_erc2:=.f.
_erc3:=.f.
RUN(_cmd1)
if !empty(_cmd2)
  RUN(_cmd2)
endi
if !empty(_cmd3)
  RUN(_cmd3)
endi

if _erc1.or._erc2.or._erc3
  cls
  QKE("Bd operacji systemowej. Nie wykonano archiwizacji !")
else
  TONE(880,8)
  @ 24,0
  devpos(24,0)
  wait "Nacinij dowolny klawisz ..."
endi
cls
RETURN NIL

*******************************************************************************
FUNCTION FOX()
local _erc:=.f.,_scl:=_kartoteka+"#"+numer_stan

cls
? "Powrt do programu podstawowego poleceniem QUIT."
wait "Nacinij dowolny klawisz ..."
cls
set cursor on
RUN fox.exe

set cursor off
cls
TONE(880,8)
@ 24,0
devpos(24,0)
wait "Nacinij dowolny klawisz ..."
cls
RETURN NIL

*******************************************************************************
FUNCTION FOX32()
local _erc:=.f.,_scl:=_kartoteka+"#"+numer_stan

cls
? "Powrt do programu podstawowego poleceniem QUIT."
wait "Nacinij dowolny klawisz ..."
cls
set cursor on
RUN FOX32.EXE

set cursor off
cls
TONE(880,8)
@ 24,0
devpos(24,0)
wait "Nacinij dowolny klawisz ..."
cls
RETURN NIL

*******************************************************************************
FUNCTION FReadLn(fHandle, cBuffer, nMaxLine)

LOCAL cLine, nEol, nNumRead, nSavePos

  cLine   := Space(nMaxLine)
  cBuffer := ""

  // Save current file position for later seek
  nSavePos := FTell(fHandle)

  nNumRead := FRead(fHandle, @cLine, nMaxLine)

  IF (nEol := At(CRLF, SubStr(cLine, 1, nNumRead))) == 0
    cBuffer := cLine                     // Line overflow or eof
  ELSE
    cBuffer := SubStr(cLine, 1, nEol - 1)  // Copy up to eol

    // Now position file to next line (skip lf) ...
    FSeek(fHandle, nSavePos + nEol + 1, FS_SET)

  ENDIF

RETURN nNumRead != 0        // If last read didn't suceed, eof

*******************************************************************************
FUNCTION INDEX_MENU(wer,_sc,_scl)

sele 0
_use ("MENU","E!")
#ifdef POSNET
 wer:="POSNET"
#endi
#ifdef FP600
 wer:="FP600"
#endi

if DIR_EXIST(_scl)
  inde on OPCJA to (_sc+"MENU") for PRIORYTET<=_priorytet;
                   .and.(empty(UWAGI).or.wer$UWAGI)
else
  inde on OPCJA to MENU for PRIORYTET<=_priorytet;
                   .and.(empty(UWAGI).or.wer$UWAGI)
endi

clos MENU
RETURN NIL

*******************************************************************************
FUNCTION DAJ_REKXY()                                         // akcja do SLRX()
local _lk:=lastkey(),_osele:=select()

BEGIN SEQUENCE
_zaz:=aclone(_zaznaczone)
if lastkey()=K_CTRL_RET.or.lastkey()=K_ENTER
  _ktory_rekord:=recn()
  keyboard chr(K_ESC)+chr(K_DOWN)
endi

END SEQUENCE
sele (_osele)
RETU NIL

*******************************************************************************
FUNCTION MAZ_STD(_s)
local _n,_i
static amaz:=;
      {134,141,145,146,164,162,158,166,167,143,149,144,156,165,163,152,160,161}
static astd:=;
      { 97, 99,101,108,110,111,115,122,122, 65, 67, 69, 76, 78, 79, 83, 90, 90}
for _i:=1 to len(_s)
  _n:=ascan(amaz,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(astd[_n]))
  endi
next
RETURN _s    

*******************************************************************************
FUNCTION LAT_STD(_s)
local _n,_i
static a852:=;
      {165,134,169,136,228,162,152,171,190,164,143,168,157,227,224,151,141,189}
static astd:=;
      { 97, 99,101,108,110,111,115,122,122, 65, 67, 69, 76, 78, 79, 83, 90, 90}
for _i:=1 to len(_s)
  _n:=ascan(a852,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(astd[_n]))
  endi
next
RETURN _s    

*******************************************************************************
FUNCTION PL(_t,_pl)
if upper(chr(145))=chr(144) //900
  RETURN if(_pl="L",MAZ_LAT(_t),if(_pl="S",MAZ_STD(_t),_t))
elseif upper(chr(169))=chr(168) //852
  RETURN if(_pl="M",LAT_MAZ(_t),if(_pl="S",LAT_STD(_t),_t))
endi
RETURN _t

*******************************************************************************
/*
ESC/P :
#define CON_E1 chr(15)                 // condensed
#define CON_E0 chr(18)                 // cancel condensed
#define PICA_E chr(18)+chr(27)+chr(80) // pica (cancel condensed, cancel elite)
#define ELIT_E chr(18)+chr(27)+chr(77) // elite (cancel condensed, set elite)
#define PICC_E chr(18)+chr(27)+chr(80)+chr(15)  // pica condensed
#define ELIC_E chr(18)+chr(27)+chr(77)+chr(15)  // elite condensed
#define RESE_E chr(27)+chr(64)          // reset
#define CAE_E1 chr(27)+chr(73)+chr(49)  // cod area expansion
#define CAE_E0 chr(27)+chr(73)+chr(48)
#define ITA_E1 chr(27)+chr(52)          // italic
#define ITA_E0 chr(27)+chr(53)
#define UND_E1 chr(27)+chr(45)+chr(49)  // underlining
#define UND_E0 chr(27)+chr(45)+chr(48)
#define DET_E1 chr(27)+chr(57)          // detektor papieru
#define DET_E0 chr(27)+chr(56) 
#define DOU_E1 chr(27)+chr(71)          // double strike
#define DOU_E0 chr(27)+chr(72)
#define HEI_E1 chr(27)+chr(119)+chr(49) // double height     
#define HEI_E0 chr(27)+chr(119)+chr(48)
#define WID_E1 chr(27)+chr(87)+chr(49)  // double width (expanded)
#define WID_E0 chr(27)+chr(87)+chr(48)
#define EMP_E1 chr(27)+chr(69)          // emphasized 
#define EMP_E0 chr(27)+chr(70) 
#define L216_E chr(27)+chr(51)+chr(n)   // line spacing n/216 cal 

IBM :
#define RESE_I chr(27)+chr(64)          // reset
#define CON_I1 chr(15)                  // condensed
#define CON_I0 chr(18)                  // cancel condensed
#define PICA_I chr(18)                  // pica (cancel condensed)
#define ELIT_I chr(27)+chr(58)          // elite
#define PICC_I chr(18)+chr(15)         // pica condensed
#define ELIC_I chr(27)+chr(58)+chr(15) // elite condensed

#define DET_I1 chr(27)+chr(57)          // detektor papieru
#define DET_I0 chr(27)+chr(56) 
#define DOU_I1 chr(27)+chr(71)          // double strike
#define DOU_I0 chr(27)+chr(72)
#define HEI_I1 chr(27)+chr(119)+chr(49) // double height     
#define HEI_I0 chr(27)+chr(119)+chr(48)
#define WID_I1 chr(27)+chr(87)+chr(49)  // double width (expanded)
#define WID_I0 chr(27)+chr(87)+chr(48)
#define EMP_I1 chr(27)+chr(69)          // emphasized 
#define EMP_I0 chr(27)+chr(70) 
#define L216_I chr(27)+chr(51)+chr(n)   // line spacing n/216 cal 

HPPCL :
#define RESE_H chr(27)+"E"              // reset
#define ORIP_H chr(27)+"&l0O"          // portret
#define ORIL_H chr(27)+"&l1O"          // landscape
#define COUR_H chr(27)+"(s3T"          // curier
#define SPAF_H chr(27)+"(s0P"          // spacing fixed
#define SPAP_H chr(27)+"(s1P"          // spacing proportional
#define PICA_H chr(27)+"(s10.0H"                  // pica
#define ELIA_H chr(27)+"(s12H"+chr(27)+"(s4102T"  // elite
#define PICC_H chr(27)+"(s16.67H"                // pica condensed
#define ELCC_H chr(27)+"(s20H"+chr(27)+"(s4102T" // elite condensed
#define ITA_H1 chr(27)+"(s1S"          // italic
#define ITA_H0 chr(27)+"(s0S"
#define DOU_H1 chr(27)+"(s3B"          // double strike (bold)
#define DOU_H0 chr(27)+"(s0B" 
#define HEI_H1 chr(27)+"(s24V"         // double height ?
#define HEI_H0 chr(27)+"(s12V"
#define WID_H1 chr(27)+"(s5.0H"        // double width pica    
#define WID_H0 chr(27)+"(s10.0H"
#define EMP_H1 chr(27)+"(s3B"          // emphasized (bold)
#define EMP_H0 chr(27)+"(s0B"  
*/
*******************************************************************************
FUNCTION WPLAT_RAP(_d,_s)                   // dla kompatybilnosci z V_COMP.PRG
RETURN .T.

*******************************************************************************
FUNCTION INFO_LOG(_opis,_alia)
local _sele:=select()

DEFAULT _opis TO "",;
        _alia TO alias()

BEGIN SEQUENCE

if _priorytet>=10.or.!file("INFO_L_O.NTX"); BREAK; endi

sele 0
if !_use("INFO_LOG","S"); BREAK; endi
set index to INFO_L_T,INFO_L_O
APPE_BLOK()
repl DATA with date(),;
     CZAS with time(),;
     STANOWISKO  with numer_stan,;
     OPERATOR  with _operator,;
     OPIS with _opis
if !empty(_alia).and.(_alia)->(fieldpos("INDEKS"))>0
  repl INDEKS with (_alia)->INDEKS
endi
if !empty(_alia).and.(_alia)->(fieldpos("NR_MAG"))>0
  repl MAGAZYN with (_alia)->NR_MAG
endi
if !empty(_alia).and.(_alia)->(fieldpos("NR_KON"))>0
  repl FIRMA with (_alia)->NR_KON
endi
close INFO_LOG

END SEQUENCE

sele (_sele)
RETURN .t.

*******************************************************************************
FUNCTION TB_PLIK(_pp)
loca _ocolo:=SET(_SET_COLOR,_ekra_blo),_w:=row(),_k:=col(),;
     _ocurs:=setcursor()
max_line_len:=275

@ 24,0 say "ALT_F - wyszukiwanie tekstu, ALT_R - kontynuacja"
FileBrowse(_pp,2,,23)
@ 24,0
* tb27(_pp,2)
SET(_SET_COLOR,_ocolo)
devpos(_w,_k)
setcursor(_ocurs)
RETURN NIL

*******************************************************************************
FUNCTION S_I(_i)                                    //zamienia indeks na string
retu transform(_i,_format_ind)

*******************************************************************************
FUNCTION S_C(_i)                                       //zamienia cen na string
retu transform(_i,_format_cen)

*******************************************************************************
FUNCTION S_W(_i)                                   //zamienia wartosc na string
retu transform(_i,_format_war)

*******************************************************************************
FUNCTION S_S(_i)                                     //zamienia ilosc na string
retu transform(_i,_format_ilo)

*******************************************************************************
FUNCTION EXE1()                                                           //xHB
RETURN NIL

*******************************************************************************
FUNCTION EXE2()                                                           //xHB
RETURN NIL
*******************************************************************************
FUNCTION DAJ_PLI(_kat,_opi)                                
local _astru:={},_r:=NIL,_sel:=sele(),_color:=set(_SET_COLOR),_apli:={},_lin,;
      _pli:=""

BEGIN SEQUENCE

for _i:=1 to 50
  _lin:=MEMOLINE(_opi,76,_i)
  if subs(_lin,1,1)=="#".and.".PDF"$_lin
    _pli:=alltrim(subs(_lin,2,at(".PDF",_lin)+3))
    if file(_kat+_pli)
      aadd(_apli,_pli)
    endi
  endi
next

if len(_apli)=0
  QK("Brak plikw !")
  BREAK
endif

_astru:={}
aadd(_astru,{"NAZWA",  "C", 40,0}) 
aadd(_astru,{"DATA",   "D", 8,0})
aadd(_astru,{"CZAS",   "C", 8,0})
aadd(_astru,{"ROZMIAR","N", 8,0})
dbcreate(_sc+"PLIKI",_astru)

sele 0
_use(_sc+"PLIKI","E!")
inde on NAZWA to (_sc+"PLIKI_N")
inde on dtos(DATA)+CZAS to (_sc+"PLIKI_D")
set inde to  (_sc+"PLIKI_N"), (_sc+"PLIKI_D")


for _i:=1 to len(_apli)
  _pli:=DIRECTORY(_kat+_apli[_i])
  if len(_pli)>0
    PLIKI->(dbappend())
    PLIKI->NAZWA   :=_pli[1][F_NAME]
    PLIKI->DATA    :=_pli[1][F_DATE]
    PLIKI->CZAS    :=_pli[1][F_TIME]
    PLIKI->ROZMIAR :=_pli[1][F_SIZE]
  endi
next

go top
CPEDIT  POZ: 1,15,23,            ;                           
        DEF: "PLIKI"             ;
        POZWER: "V4"             ;                           
        RAMKA: R_GRUBA           ;
        PION: ,,,                ;
        INDEXY: {"nazwa","data"} ;
        EDYCJA: .f.              ;
        ODTWORZ:.t.              ;
        AKCJA: _r:=DAJ_PLIK()

if _r<>NIL
  _r:=alltrim(_r)
else
  _r:=""
endif

END SEQUENCE
CPClose(PLIKI)

sele (_sel)
dele file  (_sc+"PLIKI.DBF")
dele file  (_sc+"PLIKI_N.NTX")
dele file  (_sc+"PLIKI_D.NTX")
set(_SET_COLOR,_color)

RETURN _r

*******************************************************************************
FUNCTION K_OFF()
local getlist:={}, _a:=" "
keyboard(chr(K_PGDN))
@ 24,0 get _a pict "X"
set curs on; read; set curs off
keyboard(chr(K_PGUP))

RETURN NIL

*******************************************************************************
FUNCTION ROK(_data)
RETURN subs(dtos(_data),1,4)

*******************************************************************************
FUNCTION KART_OK()
if !DIR_EXIST(alltrim(KARTOTEKA)+"#"+subs(_sc,-3,2)) 
  TONE(220,5)
  If QTN("Na dysku nie ma kartoteki "+;
         alltrim(KARTOTEKA)+"#"+subs(_sc,-3,2)+" ! WYJCIE Z PROGRAMU ?")
    close data
    dele file (_sc+"FLAGA") 
    QUIT
  else
    RETU .f.
  endif
else
  RETU .t.
endif
RETURN NIL

******************************************************************************
FUNCTION SZER(tx)
local i,ret:=""
if _szer
  for i:=1 to len(tx)
    ret:=ret+subs(tx,i,1)+" "
  next
else
  ret:=tx
endif
RETU ret

*******************************************************************************
FUNCTION HASLO(_nr)
local _sel:=select(),_has:=_haslo,_err:=.f.

if subs(_wersja,49,1)=="H".and.!file("HASLA.DBF"); RETURN .F.; endi

BEGIN SEQUENCE
  
if !file("HASLA.DBF"); BREAK; endi

sele 0
_use("HASLA","R!")
dbgoto(_nr)
if subs(_wersja,49,1)=="H".and.;
       (empty(HASLO).or.HASLO==CRYPT("      ","ZSIWI "))
   _err:=.t.; BREAK
endi
if empty(HASLO).or.HASLO==CRYPT("      ","ZSIWI "); BREAK; endi

if subs(_wersja,49,1)=="H"
  _has:=CRYPT(HASLO,"ZSIWI ")
endi

END SEQUENCE
CPClose(HASLA)

sele(_sel)
if _err
  QKE("Hasa specjalne niezdefiniowane lub niedozwolona manipulacja hasami !")
  RETURN .F.
endi

RETURN HA(_has)

*******************************************************************************
FUNCTION RAP_ERR(_opis,_procedura,_linia)
local _sel:=select()

DEFAULT _opis TO "",;
        _procedura TO "",;
        _linia TO 0

BEGIN SEQUENCE

if file("ERR_LOG.DBF")

  sele 0
  if !_use("ERR_LOG","E"); BREAK; endi
  APPE_BLOK()
  repl DATA with date(),;
       CZAS with time(),;
       STA  with numer_stan,;
       OPE  with _operator,;
       OPIS with _opis,;
       PROCEDURA with _procedura,;
       LINIA with _linia 
  close ERR_LOG
endi

END SEQUENCE

sele (_sel)
RETURN NIL
*******************************************************************************
FUNCTION DiskError()
QKE("Bd napdu. Powtrz operacj.")
set colo to _ekra_blo
BREAK
RETURN NIL

*******************************************************************************
FUNCTION DS(_d)
RETURN if(empty(_d),spac(8),dtoc(_d))

*******************************************************************************
FUNCTION KAS_WIST()                       //dla kompatybilnoci z V_EDIT.PRG MV
RETURN NIL

*******************************************************************************
FUNCTION TEST_WEJ()       //badanie czy ktos inny wszedl z tym samym parametrem
local _fer,_t1,_t2

if !file(_sc+"FLAGA")
  desk:=fcreate(_sc+"FLAGA")
  fclose(desk)
  if !file(_sc+"FLAGA")
    QKE("Nieudana prba inicjacji katalogu roboczego !")
    QUIT
  endi
  desk:=fopen(_sc+"FLAGA",2+32) // FO_READWRITE+FO_DENYWRITE
  if (_fer:=ferror())<>0
    QKE(t1:="Nieudane otwarcie pliku rejestracji uytkownika.",;
        t2:="Blad DOS numer "+str(_fer,2))
    RAP_ERR(t1+" "+t2,PROCNAME(0),PROCLINE(0))
    dele file (_sc+"FLAGA")
    QUIT
  endi
  fwrite(desk,_operator+" "+dtoc(date())+" "+subs(time(),1,5))
  if (_fer:=ferror())<>0         // nie mozna zapisa
    fclose(desk)
    QKE(t1:="Nieudana rejestracja uytkownika.",;
        t2:="Blad DOS numer "+str(_fer,2))
    RAP_ERR(t1+" "+t2,PROCNAME(0),PROCLINE(0))
    dele file (_sc+"FLAGA")
    QUIT
  endi
else
  desk:=fopen(_sc+"FLAGA",2+16)    // FO_READWRITE+FO_EXCLUSIVE
  if (_fer:=ferror())<>0           // nie mozna ekskluzywnie
    desk:=fopen(_sc+"FLAGA",0+64)  // FO_READ+FO_SHARED
    if (_fer:=ferror())<>0         // nie mozna do odczytu
      QKE(t1:="Katalog roboczy "+numer_stan+" zajety."+;
          " Nieudane otwarcie pliku rejestracji.",;
          t2:="Blad DOS numer "+str(_fer,2))
      RAP_ERR(t1+" "+t2,PROCNAME(0),PROCLINE(0))
      QUIT
    endi
    _komunikat:=space(18)
    fread(desk,@_komunikat,18)   // proba odczytu
    if (_fer:=ferror())<>0
      QKE(t1:="Katalog roboczy "+numer_stan+" zajety."+;
          " Nieudany odczyt pliku rejestracji.",;
          t2:="Blad DOS numer "+str(_fer,2))
    else
      QKE(t1:="Katalog roboczy "+numer_stan+" zajety.",;
          t2:="Operator : "+_komunikat)
    endi
    RAP_ERR(t1+" "+t2,PROCNAME(0),PROCLINE(0))
    QUIT
  else
    fclose(desk)
    desk:=fopen(_sc+"FLAGA",2+32) // FO_READWRITE+FO_DENYWRITE
    if (_fer:=ferror())<>0
      QKE(t1:="Nieudane otwarcie pliku rejestracji uytkownika.",;
          t2:="Blad DOS numer "+str(_fer,2))
      RAP_ERR(t1+" "+t2,PROCNAME(0),PROCLINE(0))
      dele file (_sc+"FLAGA")
      QUIT
    endi
    fwrite(desk,_operator+" "+dtoc(date())+" "+subs(time(),1,5))
    if (_fer:=ferror())<>0         // nie mozna zapisa
      fclose(desk)
      QKE(t1:="Nieudana rejestracja uytkownika.",;
          t2:="Blad DOS numer "+str(_fer,2))
      RAP_ERR(t1+" "+t2,PROCNAME(0),PROCLINE(0))
      dele file (_sc+"FLAGA")
      QUIT
    endi
  endi
endi

RETURN NIL

*******************************************************************************
FUNCTION RET2()
cls
QKE("Opcja w opracowaniu")
RETURN NIL

*******************************************************************************
FUNCTION USTAW()                                                     //03.07.99
loca _tex:='۲  USTALANIE PARAMETRW KONFIGURACYJNYCH PROGRAMU ',;
     _err:=.t.,_lp:=0,_stary,_znak:=" "

cls
@ 0,0 say _tex

BEGIN SEQUENCE

if !_use("CONFIG","E"); BREAK; endi

@ 1,0 say "Numer parametru : " get _lp pict "@Z 99"
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi
_stary:=padr(subs(WERSJA,_lp,1),1)

@ 2,0 say "Aktualna warto : "+_stary
@ 3,0 say "Nowa warto :    " get _znak pict "@! X"
set curs on; read; set curs off
if lastkey()=K_ESC.or.!HA(_haslo); BREAK; endi

if fieldsize(fieldnum("WERSJA"))<_lp
  copy stru extended to XSTRUP
  _use("XSTRUP","E!")
  locate for rtrim(Field_name)=="WERSJA"
  repl  Field_len with _lp
  use
  create ("XSTRUN") from XSTRUP
  _use("XSTRUN","E!")
  appe from CONFIG
  copy to CONFIG
  use
  dele file ("XSTRUP.DBF")
  dele file ("XSTRUN.DBF")
  if !_use("CONFIG","E"); _err:=.t.;BREAK; endi
endif

if _znak<>_stary
  if _lp=1
    repl WERSJA with _znak+subs(WERSJA,2)
  else
    repl WERSJA with subs(WERSJA,1,_lp-1)+_znak+subs(WERSJA,_lp+1)
  endi

  sele 0
  if _use("STATUS","F")
    repl DATA_LIC with ""
    use
  endi

  _err:=.f.
  tone(440,1)
else
  _err:=.t.
endi

END SEQUENCE
clos data
if _err
  QKE("Nie zmieniono parametru konfiguracyjnego programu !")
else 
  QKE("Zmieniono parametr konfiguracyjny programu.",;
      "        Uruchom program ponownie !         ")
  dele file (_sc+"FLAGA")
  QUIT
endi
RETURN NIL

*******************************************************************************
FUNCTION ep(rr)                                                             //!
RETURN str(year(ctod("01.01."+rr)),4) 

*******************************************************************************
FUNCTION USTAW_DRUK()                                                 
loca _tex:='۲  USTAWIANIE GLOBALNYCH PARAMETRW WYDRUKW  ',;
     _tryb:=space(5),_konw1:=space(3),_konw2:=space(3),_kody:=space(30),;
     _port:=space(4),_err:=.t.,_konw:=space(6),_rr:=space(30)

cls
@ 0,0 say _tex

BEGIN SEQUENCE

do while _err

   @ 2,0 say "Tryb drukarki:  " get _tryb  pict "@! XXXXX";
                                vali _tryb$"ESC/P|IBM  |HPPCL"
   @ 3,0 say "Port drukarki:  " get _port pict "@! AAA9";
                vali subs(_port,1,3)=="LPT".and.subs(_port,4,1)$"123456789"
   @ 4,0 say "Konwersja:      " get _konw1 pict "@!"
                @ 4,21 say "->" get _konw2 pict "@!"
   @ 5,0 say "Kody sterujce: " get _kody pict "@!"
   set curs on; read; set curs off
   if lastkey()=K_ESC; BREAK; endi

   _rr:=alltrim(_kody)

   if ((_konw1=="   ".and._konw2=="   ").or.;
      ((_konw1=="MAZ".or._konw1=="LAT").and.;
      (_konw2=="MAZ".or._konw2=="LAT".or._konw2=="STD".or._konw2=="   ").and.;
      _konw1<>_konw2)).and.;
      charrem("01234567890/,",_rr)=="".and.subs(_rr,1,1)<>",".and.;
      subs(_rr,-1)<>",".and.subs(_rr,1,1)<>"/".and.subs(_rr,-1)<>"/"

       _err:=.f.
       _konw:=_konw1+_konw2
       _use(_sc+"PARADRUK","E!")
       repl all TRYB with _tryb,;
                PORT with _port,;
                KONWERSJA with _konw,;
                KODY with _kody
       close data
   else
      QKE ("PODANO BDNE PARAMETRY !")
   endi
endd

END SEQUENCE
RETURN .T.

*******************************************************************************
FUNCTION GRUPA_OK(x,maxgru,_agru)
// Uwaga ! _agru musi by przekazywana przez referencj 
// np. GRUPA_OK(_nr_g_kon,_maxgr,@akon) patrz R.Spence Clipper 5.2 str. 148
local _ret:=.t., s1:="",s2:="", _tn:="",i,j,k,_grmax,_maxpom

_maxpom:=if(maxgru>99,999,99)

s1:=CHARREM(" ",x)
s2:=CHARONLY(",-0123456789",x)
_agru:={}
BEGIN SEQUENCE
  if ! s1==s2; _ret:=.f.; BREAK; endif   // niedopuszczalne znaki

  TOKENINIT(@s1,",")
  i:=1
  do while !TOKENEND()
    _tn:=TOKENNEXT(s1)
    _nat:=NUMAT("-",_tn)

    if _nat=1 .and. len(_tn)=1         //  tylko "-"
      for i:=1 to maxgru
        aadd(_agru,i)
      next
    elseif _nat=1 .and. left(_tn,1)="-"    //  "-" jako pierwszy znak
      if (_grmax:= val(subs(_tn,2)))>_maxpom
        _ret:=.f.; BREAK
      endif
      for i:=1 to _grmax
        aadd(_agru,i)
      next      
    elseif _nat=1 .and. right(_tn,1)="-"    // "-" jako ostatni znak
      j:=val(left(_tn,len(_tn)-1)) 
      for i:=j to maxgru    
        if ascan(_agru,i)=0;   aadd(_agru,i); endi
      next      
    elseif _nat=1             // "-" nie jako ostatni znak i nie ostatni
      _nn:=at("-",_tn)
      j:=val(left(_tn,_nn-1)) 
      if (k:=val(subs(_tn,_nn+1)))>_maxpom
        _ret:=.f.; BREAK
      endif
      for i:=j to k   
        if ascan(_agru,i)=0;   aadd(_agru,i); endi
      next      
    elseif _nat>1
      _ret:=.f.; BREAK
    elseif _nat=0
      if (i:=val(_tn)) > _maxpom
        _ret:=.f.; BREAK
      endif
      if ascan(_agru,i)=0;   aadd(_agru,i); endi
    else
    endif 
  enddo

END SEQUENCE

if _ret=.f.
  tone(220,5)
  QKE(;
 "Bdna selekcja !  Naley zostawi puste pole lub wpisa grupy i przedziay",;
 "grup oddzielone przecinkami. Przykady: 7  2,3-5  1,2,6. Maksym. grupa : "+;
  str(maxgru,2))
  _agru:={}
endif
RETURN _ret 

*******************************************************************************
FUNCTION FWriteLn( nHandle, cString, nLength, cDelim )  //#23.10

   IF cDelim == NIL
      cString += CRLF
   ELSE
      cString += cDelim
   ENDIF

   RETURN ( FWRITE( nHandle, cString, nLength ) )
*******************************************************************************
/*

 /****************************************************************************
*  Browse Function By: Tom Claffy  March 1993
*  Search Routine  By: Phil Barnett  April 3, 1993
*  Minor Repair of DownFillArray By: Phil Barnett  April 5, 1993
*  Added Highlight to Search By: Tom Claffy  April 10, 1993
*  Added minor comments and fixed anomalous display on small files
*                                Tom Claffy  May 25, 1993
*  Added MAXBROWSELENGTH to avoid lockup on binary files: TC 7-26-1993
*  Fixed Ctrl-PgUp and Ctrl-PgDn problems with small files: TC 9-15-93
*  Added optional code block to modify text as it is extracted TC 9-23-93
*  LineDisp Function By: Todd C. MacDonald 9-28-1993 with minor
*      modification by Tom Claffy
*
*  Placed in Public Domain July 29, 1993 by Tom Claffy
*
*  Pure Clipper Text File Browser
*
*  with...
*
*      Virtual Reads  (view any size file with low memory overhead)
*      Relative Position Indicator
*      Panning
*      User-defineable Color Blocks
*      Search and Repeat Search
*      Handles all Video Screen sizes (looks nice in 40*132)
*      100% Clipper
*
*      Compile Clipper 5.x -n
****************************************************************************/
/***************************************************************************
* This is the default maximum line length
***************************************************************************/
#define MAXBROWSELENGTH 256

/***************************************************************************
* These defines are used by the LineDisp function to define the
* elements of the display color as written by Todd C. MacDonald.
****************************************************************************/
#define CODE_LEN    3
#define COLOR_CODE  1
#define COLOR_SET   2
#define COLOR_DELIM '~~'

/****************************************************************************
* Syntax          FileBrowse( <cFileName> , [<nTop>] , [<nLeft>] ,
*                     [<nBottom>] , [<nRight>] , [<cWinColor>] ,
*                     [<cBoxColor>] , [<cBarColor>] , [<cButtonColor>] ,
*                     [<bApplyText>] , [<aDispColors>] )
*
* Arguments       <cFileName> DOS file to browse. Provide your own
*                     error trapping prior to calling FileBrowse().
*                     This function assumes a valid, readable file.
*                 <nTop>, <nLeft>, <nBottom> , <nRight> browse window
*                     coordinates; If not specified, defaults to 0,0,
*                     MaxRow(),MaxCol()
*                 <cWinColor> , <cBoxColor> , <cBarColor>, <cButtonColor>
*                     Clipper color strings; If not specified, defaults to
*                     SetColor() , Setcolor() , "W/N" , "N/W" respectively.
*                 <bApplyText>  An optional code block which will be
*                     applied to each line of text as it is extracted
*                     from the file allowing control codes, etc. to be
*                     removed prior to display
*                 <aDispColors> An optional array of codes and Clipper color
*                     strings to affect the display colors. Each element of
*                     the array contains { cCode , cColorString }. Each
*                     cCode used must begin with a common delimiter and
*                     contain a unique identifier. Example:
*                      { { '~~WR' , 'W+/R' } , { ~~BW , 'B/W' } } where
*                     ~~ is the common delimiter and WR or BW is the
*                     unique identifier portion of each cCode.
*                     Imbed the cCode in the text file to display the text
*                     in the corresponding color. Each color change is
*                     only applicable to the end fo the  current line or
*                     another cCode is encountered; subsequent lines revert
*                     to the default cWinColor. If not specified, all
*                     output will be in the cWinColor.
* Returns         NIL
*
* Description     Pure Clipper text file browser
*
* Calls           NONE
*
* Notes           Beats the pants off of the similar tBrowse implementation
****************************************************************************/

Function FileBrowse(cFileName,nTop,nLeft,nBottom,nRight,cWinColor,;
                    cBoxColor,cBarColor,cButtonColor,bApplyText,aDispColors)
// the browse variables
LOCAL aLines
LOCAL aWinbuff := {savescreen(),setcolor(cWinColor),row(),col(),setcursor(0)}
LOCAL lApplyBlock := (bApplyText # NIL .and. VALTYPE(bApplyText) == "B")
LOCAL lHitBottom := .f.
LOCAL nCurrentLeft := 1
LOCAL nHandle := Fopen( cFileName , 0 )
LOCAL nKey := 0
LOCAL nLastOffSet := 0
LOCAL nLastLine
LOCAL nLeftBrowse := 1
LOCAL nLengthBrowse
LOCAL nMaxRight := 0
LOCAL nSize := Fseek( nHandle , 0 , 2 )
// for the ScrollBar
LOCAL nRow
LOCAL nBarTop
LOCAL nBarBottom
// for the search function
LOCAL cLookText := ''
LOCAL nHighLiteLine := 0
LOCAL nHighLiteOffSet := 0
LOCAL nLastFind
LOCAL nLooklen := 0
LOCAL nTotalFound := 0
// move back to the top of the file
Fseek(nHandle,0)
// set the defaults
DEFAULT nTop TO 0
DEFAULT nLeft TO 0
DEFAULT nBottom TO maxrow()
DEFAULT nRight TO maxcol()
DEFAULT cWinColor TO SetColor()
DEFAULT cBoxColor TO SetColor()
DEFAULT cBarColor TO 'W/N'
DEFAULT cButtonColor TO  'N/W'
// Set other vars; NOTE: if you change the window look at these carefully
nRow = nTop+1
nBarTop = nTop+1
nBarBottom = nBottom-1
nLastLine = nBottom - nTop - 1
nLengthBrowse = (nRight - nLeft - 2 )
// declare and fill the array
aLines = Array( nLastLine )
aFill( aLines , {'',0,0} )
DownFillArray(nHandle,aLines,1,nLastLine,lApplyBlock,bApplyText)
// paint the screen
//DispBegin()
Scroll(nTop,nLeft,nBottom,nRight)
Dispbox(nTop,nLeft,nBottom,nRight,,cBoxColor)
ScrollBar(.t.,aLines[1,2],nLastOffSet,nSize,nLastLine,;
          nBarTop,nRight,nBarBottom,@nRow,cBarColor,cButtonColor)
//DispEnd()
While .t.
   // reset default values
   nMaxRight := nLastOffSet := 0
   // display the screen
   //DispBegin()
   LineDisp(aLines,nTop,nLeft,nLeftBrowse,nLengthBrowse,;
            @nMaxRight,@nLastOffset,aDispColors,nLastLine,cWinColor)
   If nHighLiteLine # 0  // highlight the search text
      nHighLiteLine = Highlight(cLookText,nHighLiteOffSet-nLeftBrowse+1,;
                      nTop+nHighLiteLine,nLeft+1)
   Endif
   ScrollBar(.f.,aLines[1,2],nLastOffSet,nSize,nLastLine,nBarTop,nRight,;
         nBarBottom,@nRow,cBarColor,cButtonColor) // update the scroll bar
   //DispEnd()
   Clear TypeaHead // I like this thing to stop when I stop pressing a key
   do case
   case (nKey := inkey(0)) == K_ESC
      Exit
   case nKey == K_DOWN
      SkipDown(nHandle,aLines,nLastLIne,1,nSize,lApplyBlock,bApplyText)
   case nKey == K_UP
      SkipUp(nHandle,aLines,lApplyBlock,bApplytext)
   case nKey == K_PGUP
      If !UpFillArray(nHandle,aLines,nLastLine,nSize,lApplyBlock,bApplyText)
         Fseek( nHandle , 0 )
         aFill( aLines , {'',0,0} )
         DownFillArray(nHandle,aLines,1,nLastLine,lApplyBlock,bApplyText)
      Endif
   case nKey == K_PGDN
      SkipDown(nHandle,aLines,nLastLine,nLastLine,nSize,;
               lApplyBlock,bApplyText)
   case nKey == K_LEFT .and. nLeftBrowse > 1
      nLeftBrowse --
   case nKey == K_RIGHT .and. nLeftBrowse < ( nMaxRight - nLengthBrowse )
      nLeftBrowse ++
   case nKey == K_HOME .and. nLeftBrowse > 1
      nLeftBrowse = 1
   case nKey == K_END .and. nLeftBrowse < ( nMaxRight - nLengthBrowse )
      nLeftBrowse = ( nMaxRight - nLengthBrowse )
   case nKey == K_CTRL_PGUP //.and. aLines[1,2] # 0
      Fseek( nHandle , 0 )
      DownFillArray(nHandle,aLines,1,nLastLine,lApplyBlock,bApplyText)
   case nKey == K_CTRL_PGDN
      aLines[1,2] = Fseek( nHandle , 0 , 2 )
      If !UpFillArray(nHandle,aLines,nLastLine,nSize,lApplyBlock,bApplyText)
         Fseek( nHandle , 0 )
         aFill( aLines , {'',0,0} )
         DownFillArray(nHandle,aLines,1,nLastLine,lApplyBlock,bApplyText)
      Endif
   case nKey == K_TAB .and. nLeftBrowse < ( nMaxRight - nLengthBrowse )
      nLeftBrowse = MIN(nLeftBrowse+nLengthBrowse,nLeftBrowse+5)
   case nKey == K_SH_TAB .and. nLeftBrowse > 1
      nLeftBrowse = MAX(0,nLeftBrowse-5)
   case nKey == K_ALT_F .or. nKey == K_ALT_R
      If (nLastOffSet := search(nHandle,If(nKey==K_ALT_F,1,2),;
            @nLastFind,@cLookText,@nLooklen,@nHighLiteOffSet,;
                                     nBottom,@nTotalFound) ) > 0
         DownFillArray(nHandle,aLines,1,nLastLine,@lHitBottom,;
                       lApplyBlock,bApplyText)
         If lHitBottom .or. aScan(aLines,{|x|!Empty(x[1])}) = 0
            // we hit bottom or no text in any line
            aFill( aLines , {'',0,0} )
            aLines[1,2] = Fseek( nHandle , 0 , 2 )
            If !UpFillArray(nHandle,aLines,nLastLine,nSize,;
                            lApplyBlock,bApplyText)
               Fseek( nHandle , 0 )
               aFill( aLines , {'',0,0} )
               // this is not really as redundant as it may first appear
               DownFillArray(nHandle,aLines,1,nLastLine,;
                             lApplyBlock,bApplyText)
            Endif
         Endif
         nHighLiteLine = CheckDisp(cLookText,aLines,nLastOffSet,;
                                 nHighLiteOffSet,@nLeftBrowse,nLengthBrowse)
      Endif
   case SetKey( nKey ) # NIL
      Eval( SetKey( nKey), ProcName(), ProcLine(), ReadVar() )
   Endcase
End
fClose( nHandle )
SetColor( aWinbuff[2]) // next 4 lines are my screen restore stuff
*RestScreen(0,0,maxrow(),maxcol(),aWinbuff[1])
SetPos(aWinbuff[3],aWinbuff[4])
SetCursor(aWinbuff[5])
RETURN NIL

/****************************************************************************
* Displays the lines of text contained in the array
****************************************************************************/

STATIC Function LineDisp(aLines,nTop,nLeft,nLeftBrowse,nLengthBrowse,;
                        nMaxRight,nLastOffset,aDispColors,nLastLine,;
                        cWinColor)
// The LOCAL vars for Todd's part of this function
LOCAL cColorCode
LOCAL cColorSet
LOCAL cLine
LOCAL cOutPut
LOCAL nColorCode
LOCAL nCodePos
LOCAL nDiff
LOCAL nKey
LOCAL nLength
LOCAL nLine
LOCAL nLinePos

nLeft ++ // this needs to be incremented for both display methods
If aDispColors = NIL // no colors defined so use the standard display method
   Aeval(aLines,{ |x,y|DevPos(nTop+y,nLeft),;
                       DevOut(Pad(Substr(x[1],nLeftBrowse),nLengthBrowse)),;
                       nMaxRight   := Max(nMaxRight,Len(x[1])),;
                       nLastOffSet := Max(nLastOffSet,x[3])})
Else
  /*************************************************************************
  * This is an original work by Todd C. MacDonald and is hereby
  * placed in the public domain.
  *
  * The framework for this portion of the LineDisp function was
  * graciously provided by Todd C. MacDonald. It is included here with
  * modifications to use the established variables and conventions in
  * FileBrowse - Tom Claffy 9-28-93
  **************************************************************************/

  nTop ++
  FOR nLine = 1 TO nLastLine
     setpos( nTop++, nLeft )
     cLine = aLines[ nLine , 1 ]
     nLinePos = 1
     cColorSet = cWinColor
     nLength = LEN( cLine )
     WHILE (COLOR_DELIM $ cLine)
       nCodePos = at( COLOR_DELIM , cLine )
       cOutPut = Left( cLine , nCodePos - 1 )
       // strip the beginning of the line if we are panned right
       // this must be done as a color code may be in this part
       // of the line so we must process the characters but cannot
       // display any characters until we reach the first virtual column
       // of the display window
       If nLinePos < nLeftBrowse
          nDiff = MIN( LEN( cOutPut ) , nLeftBrowse - nLinePos )
          nLinePos += nDiff
          cOutPut = Substr( cOutPut , nDiff + 1 )
       Endif
       // output line up to code position in current color
       devout( cOutPut , cColorSet )
       // strip off text just displayed
       cLine =  substr( cLine, nCodePos )
       // Set new color based on color code.  If the color code
       // is not found in the array, the code is not stripped out
       // (therefore the code itself gets displayed in the output
       // text).  If the code is found but the color value is nil,
       // the color is set to the default.
       cColorCode = left( cLine, CODE_LEN )
       IF ( nColorCode := ascan( aDispColors, ;
          { | a | a[ COLOR_CODE ] == cColorCode } ) ) # 0
          IF ( cColorSet := aDispColors[ nColorCode, COLOR_SET ] ) =  NIL
             cColorSet = cWinColor
          ENDIF
          // strip off color code
          cLine = substr( cLine, CODE_LEN + 1 )
          // keep track of the line length
          nLength -= (CODE_LEN +1)
       ELSE
          // strip off color code prefix
          cLine = substr( cLine, CODE_LEN )
          // keep track of the line length
          nLength -= CODE_LEN
       ENDIF
     END
     // cut to the left column if we are not already there
     If nLinePos < nLeftBrowse
        cLine = Substr( cLine , nLeftBrowse - nLinePos + 1)
     Endif
     // output remainder of line
     devout( Pad( cLine , nLeft + nLengthBrowse - Col() ) , cColorSet )
     // set the system counters
     nMaxRight   = Max(nMaxRight,nLength)
     nLastOffSet = Max(nLastOffSet,aLines[nLine,3])
   NEXT
Endif
RETURN NIL

/***************************************************************************
* Justify the display before displaying the found text
* The find column may be out of view left or right
****************************************************************************/
STATIC Function CheckDisp(cLookText,aLines,nLastOffSet,;
                          nHighLiteOffSet,;
                          nLeftBrowse,nLengthBrowse)
LOCAL nLength := LEN(AllTrim(cLookText))
If nHighLiteOffSet < nLeftbrowse  // the find text is out of scope left
   nLeftBrowse = nHighLiteOffSet
Elseif nLeftBrowse+nHighLiteOffSet+nLength > ;
       nLeftBrowse+nLengthBrowse  // the find text is out of scope right
   nLeftBrowse = (nHighLiteOffSet+nLength-nLengthBrowse )
Endif
RETURN (Ascan(aLines,{ |x| x[2] <= nLastOffSet .and. x[3] > nLastOffSet}))

/***************************************************************************
* Highlight the found text
****************************************************************************/
STATIC Function HighLight(cLookText,nOffSet,nRow,nCol)
LOCAL nLength := LEN(AllTrim(cLookText))
LOCAL cScreen := SAVESCREEN(nRow,nCol+nOffSet-1,;
                            nRow,nCol+nOffSet+nLength-2)
// use this variable to set the highlight color you want to use
LOCAL cChar := If( Chr(7) $ cScreen,Chr(112),Chr(7))
RESTSCREEN(nRow,nCol+nOffSet-1,nRow,nCol+nOffSet+nLength-2,;
   TRANSFORM(cScreen,REPLICATE(("X"+cChar),nLength)))
RETURN 0

/***************************************************************************
* Clean up the line by removing control characters
* and apply the user-defined block if applicable
* cLine is passed to this function by reference
* thus no return value
****************************************************************************/
STATIC Function LineClean( cLine , lApplyBlock , bApplyText )
cLine = Strtran( cLine , Chr(10) , ' ' )   // LF
cLine = StrTran( cLine , Chr(12) , ' ' )   // FF
cLine = StrTran( cLine , Chr(13) , ' ' )   // CR
cLine = StrTran( cLine , Chr(26) , ' ' )   // EOF
If lApplyBlock
   cLine = Eval( bApplyText , cLine )
Endif
RETURN NIL

/****************************************************************************
* Search for line-feed or form-feed mark - return the first offset
* The extraordinary error trapping is included here to prevent
* lock-up when a binary file is browsed, i.e. a loop can be
* caused by the eof mark not being found
****************************************************************************/
STATIC Function FirstEolmark(cBuffer)
LOCAL nFFmark := At(Chr(12),cBuffer)
LOCAL nLFmark := At(Chr(10),cBuffer)
LOCAL nReturn := 0
If nFFmark > 0 .and. nLFmark > 0
   nReturn = MIN( MIN(nFFmark,nLFmark) , MAXBROWSELENGTH )
Elseif nFFmark > 0 .or. nLFmark > 0
   nReturn = MIN( MAX(nFFmark,nLFmark) , MAXBROWSELENGTH )
Elseif LEN( cBuffer ) >= MAXBROWSELENGTH
   nReturn = MAXBROWSELENGTH
Endif
RETURN nReturn

/***************************************************************************
* fill the array traversing down the file
****************************************************************************/
STATIC Function DownFillArray(nHandle,aLines,nStart,nEnd,;
                              lApplyBlock,bApplyText,lHitBottom)
LOCAL nBlock := 1024
LOCAL cBuffer
LOCAL cLine
LOCAL nEOL
LOCAL nCounter := nStart - 1
LOCAL nFilePos := Fseek( nHandle , 0 , 1 )
LOCAL nLineLength
LOCAL nLoopCounter := 0
LOCAL nBytesRead
lHitBottom = .f.
// while the array is not full
While nCounter < nEnd
   // reposition to current file position
   Fseek( nHandle , nFilePos , 0 )
   // assign a buffer and read the file
   cBuffer = Space( nBlock )
   if (nBytesRead := Fread( nHandle , @cBuffer , nBlock )) # nBlock
      nLoopCounter ++
   endif
   // check for eof
   If nBytesRead < 1 .or. nLoopCounter > 2
      lHitBottom = .t.
      Exit
   Else
      While nCounter < nEnd .and. (nEOL := FirstEolMark( cBuffer )) # 0
         nCounter ++
         // extract the line
         cLine = Left( cBuffer , nEOL )
         // strip the line from the buffer
         cBuffer = Substr(cBuffer,nEOL+1)
         // save the length
         nLineLength = LEN( cLine )
         // clean it up
         LineClean( @cLine , lApplyBlock , bApplyText )
         // store it in the array
         aLines[nCounter] = { cLine , nFilePos , nFilePos + nLineLength }
         // keep the pointer current
         nFilePos += nLineLength
      End
      // test for eof
      lHitBottom = (nCounter < nEnd)
   Endif
End
RETURN NIL

/***************************************************************************
* add one line to the bottom the array
****************************************************************************/
STATIC Function SkipDown(nHandle,aLines,nLastLine,nNumLines,nSize,;
                         lApplyBlock,bApplyText)
LOCAL lHitBottom := .f.
If aLines[ nLastLine , 3 ] # 0
   // position file to last line offset
   Fseek( nHandle , aLines[ nLastLine , 3 ] , 0 )
   Adel( aLines , 1 )
   aLines[nLastLine] = {'',0,0}
   // get the next line
   DownFillArray(nHandle,aLines,nLastLine+1-nNumLines,nLastLine,;
                 lApplyBlock,bApplyText,@lHitBottom)
   If lHitBottom .or. aScan(aLines,{|x|!Empty(x[1])}) = 0
      // we hit bottom or no text in any line
      aLines[1,2] = Fseek( nHandle , 0 , 2 )
      UpFillArray(nHandle,aLines,nLastLine,nSize,lApplyBlock,bApplyText)
   Endif
Endif
RETURN NIL

/***************************************************************************
* fill the array traversing up ... the tricky one ...
* This function was originally coded with the RAT function
* Tests show the AT func to be about 10 times faster than RAT
* thus the overhead of the aTemp with the AT function as an offset map
****************************************************************************/
STATIC func UpFillArray(nHandle,aLines,nEnd,nSize,lApplyBlock,bApplyText)
LOCAL aOffSets
LOCAL cBuffer
LOCAL cFirstChar
LOCAL cLine := ''
LOCAL nBlock := 1024
LOCAL nCounter := 0
LOCAL nEOL
LOCAL nFilePos := Fseek( nHandle , 0 , 1 )
LOCAL nTempCount
LOCAL lEOF :=  (nSize = nFilePos )
LOCAL lReturn := .t.
While nCounter < nEnd
   // assign some defaults and read the file
   nBlock = Min(nBlock,aLines[1,2])
   nFilePos = aLines[1,2] - nBlock
   Fseek( nHandle , nFilePos , 0 )
   cBuffer = Space( nBlock )
   If Fread( nHandle , @cBuffer , nBlock ) = 0
      Exit
   Else
      If nFilePos = 0
         aOffSets = {1}
      Else
         aOffSets = { }     // discard the first line - it is a fragment
      Endif
      // map the lines into a temp array
      nTempCounter = 0
      While (nEOL := FirstEolMark( Substr( cBuffer , nTempCounter + 1 ))) # 0
         nTempCounter += nEOL
         Aadd( aOffSets , nTempCounter )
      End
      // pick up the last line if eof and it does not end w/ LF CR etc.
      If lEOF .and. nTempCounter < nBlock
         Aadd( aOffSets , nBlock )
      Endif
      nTempCounter = LEN( aOffSets )
      // fill the array
      While nCounter < nEnd .and. nTempCounter > 1
         nCounter ++
         nTempCounter --
         cLine = Substr(cBuffer,aOffSets[nTempCounter]+1)
         // strip the first char if it is a control char
         // going down we don't have this problem as it is at the end and
         // we don't care
         cFirstChar = Left( cLine , 1 )
         If cFirstChar = Chr(10) .or. cFirstChar = Chr(12) .or. ;
            cFirstChar = Chr(13) .or. cFirstChar = Chr(26)
            cLine = Substr( cLine , 2 )
         Endif
         // clean it up
         LineClean( @cLine , lApplyBlock , bApplyText )
         // store the line and it's parameters
         Ains( aLines , 1 )
         aLines[1] = {cLine,;
                      nFilePos+aOffSets[nTempCounter],;
                      nFilePos+aOffSets[nTempCounter+1]}
         // strip the line from the buffer
         cBuffer = Left(cBuffer,aOffSets[nTempCounter])
      End
      // if nCounter < nEnd we ran out of lines
      // return .f. and fill the array from the top
      lReturn = (nCounter = nEnd )
      If nFilePos = 0
         If aLines[1,2] = 1 // assign BOF status explicitly for the other
            aLines[1,2] = 0 // functions
         Endif
         Exit  // we're done here
      Endif
   Endif
End
RETURN lReturn

/***************************************************************************
* add one line to the top of the array
****************************************************************************/
STATIC func SkipUp(nHandle,aLines,lApplyBlock,bApplyText)
LOCAL nBlock
LOCAL cBuffer
LOCAL cLine := ''
LOCAL lBOF := .f.
LOCAL nEOL
LOCAL nFilePos
LOCAL nLength
If aLines[1,2] #0
   nBlock = Min(512,aLines[1,2])
   nFilePos = aLines[1,2] - nBlock
   lBOF = (nFilePos <= 1 )
   Fseek( nHandle , nFilePos , 0 )
   cBuffer = Space( nBlock )
   If !Fread( nHandle , @cBuffer , nBlock ) = 0
      // get past the first eol mark
      nEOL = MAX( Rat(Chr(12),cBuffer), Rat(Chr(10),cBuffer) )
      If nEOL # 0
         cLine = Right( cBuffer , Len(cBuffer)-nEOL+1 )
         cBuffer = Left(cBuffer,nEOL-1)
      Endif
      // get the last line in the buffer
      nEOL = MAX( Rat(Chr(12),cBuffer), Rat(Chr(10),cBuffer) )
      If nEOL == 0 .and. !lBOF
         nEOL = MIN(nBlock,MAXBROWSELENGTH)
      Elseif LEN(cBuffer) - nEOL > MAXBROWSELENGTH
         nEOL = MAXBROWSELENGTH
      Endif
      // update the file position
      nFilePos += nEol
      // get the line
      cLine = ( Right(cBuffer,Len(cBuffer)-nEOL) + cLine )
      // save the real length of the line in the file
      nLength = LEN( cLine )
      // clean it up
      LineClean( @cLine , lApplyBlock , bApplyText )
      // store the line and it's parameters
      Ains( aLines , 1 )
      aLines[1] = {cLine,nFilePos,nFilePos+nLength}
   Endif
Endif
RETURN NIL

/***************************************************************************
* Display a status bar based on the relative position in the file
* Not 100 % accurate but a fair representation to pacify the mere mortals
****************************************************************************/
STATIC Function ScrollBar(lPaint,nStart,nEnd,nSize,nLastLine,nBarTop,nRight,;
                          nBarBottom,nRow,cBarColor,cButtonColor)
LOCAL nCounter
LOCAL nMiddle
LOCAL nPercent
If lPaint  // this only happens on the very first call
   For nCounter = nBarTop to nBarBottom
      DevPos(nCounter,nRight); DevOut(Chr(176),cBarColor)
   Next
Else // update the button
   // erase the old button - where's the whiteout
   DevPos(nRow,nRight); DevOut(Chr(176),cBarColor)
   If nStart = 0             // figger out the new row
      nRow = nBarTop         // nRow is passed by ref so it will be updated
   Elseif nEnd >= nSize -1
      nRow = nBarBottom
   Else
      nMiddle = nStart + ((nEnd - nStart) / 2 )
      nPercent = (nMiddle/nSize)
      nRow = nBarTop + INT( (nBarBottom - nBarTop) * nPercent )
   Endif
   // display the button
   DevPos(nRow,nRight); DevOut( chr(254),cButtonColor)
Endif
RETURN NIL

/***************************************************************************
* Search Routine By: Phil Barnett  April 3, 1993
* Search and repeat last find
****************************************************************************/
STATIC Function Search(nHandle,nMode,nLastFind,cLookText,nLooklen,;
                       nHighLiteOffSet,nBottom,nTotalFound)
LOCAL cBuffer
LOCAL cSaveIt := savescreen(nBottom,0,nBottom,MaxCol())
LOCAL nBytesRead
LOCAL nBlock := 4096  // Bigger is probably faster up to ~10000 bytes
LOCAL nThisOffset
LOCAL nOffset := 0
LOCAL nLoop := 0
LOCAL getlist := {}
LOCAL cMiniBuff
LOCAL nMBsize
LOCAL nEOLat
LOCAL cHoldBack := ''
if nMode == 1     // initiate search (ALT_F)ind
  nTotalFound = 0
  nLastFind = -1
  cLookText = pad(cLookText,25)
  @ nBottom,1 say space(49)
  //@ nBottom,2 say 'Enter Search Phrase' get cLookText picture '@K@!'
  @ nBottom,2 say 'Podaj szukany tekst:' get cLookText picture '@K'
  SetCursor( If(ReadInsert(),2,1 ))
  read
  SetCursor(0)
  restscreen(nBottom,0,nBottom,MaxCol(),cSaveIt)
  if lastkey() == 27 .or. empty(cLookText)
    RETURN 0
  endif
  cLookText = upper(alltrim(cLookText)) // Marek
  nLookLen = len(cLookText)
endif
fseek(nHandle,nLastFind+1,0)  // Position filepointer to starting location
nBytesRead = nBlock          // setup loop entry
do while nBytesRead == nBlock
  // Get and prepare the Character Buffer
  cBuffer = space(nBlock)
  nBytesRead = fread(nHandle,@cBuffer,nBlock)
  if nBytesRead < nBlock
    cBuffer = left(cBuffer,nBytesRead)
  endif
  cBuffer = cHoldBack + upper(cBuffer)
  nThisOffset = at(cLookText,cBuffer)
  if !empty(nThisOffset)
    // position the File Pointer to the find.
    nLastFind += ( nLoop * nBlock ) + nThisOffset - Len( cHoldBack )
    Fseek( nHandle, nLastFind , 0)
    // Now, locate the beginning of the line
    // ( It might not be in current buffer, so make a new minibuffer )
    nMBsize = min( nLastFind, 512 )
    cMiniBuff = space(nMBsize)
    fseek( nHandle,-nMBsize,1)
    fread(nHandle,@cMiniBuff,nMBsize)
    nEOLat = MAX( Rat(Chr(12),cMiniBuff), Rat(Chr(10),cMiniBuff) )
    if nEOLat > 0
       fseek( nHandle, nEOLat-nMBsize,1)
    endif
    nOffset = fseek(nHandle,0,1)
    nHighLiteOffSet = (nLastfind - nOffSet + 1)
         tone(880,1)
    nTotalFound ++
    // We found one so...
    exit
  endif
  cHoldBack = right(cBuffer,nLookLen - 1)
  nLoop ++
enddo
if nOffset == 0
  //@ nBottom,1 say ' ' +Ltrim(Trim(Str(nTotalFound)))+;
  //                ' Occurences Found - No More Finds (Press Any Key) '

  tone(880,1)
  @ nBottom,1 say ' Razem liczba wystpie: ' +Ltrim(Trim(Str(nTotalFound)))+;
                  ' - Koniec szukania (nacinij dowolny klawisz) '
  Tone(100,1)
  inkey(0)
  restscreen(nBottom,0,nBottom,MaxCol(),cSaveIt)
endif
RETURN nOffset

*******************************************************************************
FUNCTION DRUK_PLI()
local _tex:='۲  PRZEGLDANIE I WYDRUK ZAPAMITANYCH PLIKW ',;
      _pliki, _st, _na,_astru:={},_kropka,_r:="",;
      _wybor:=1, _portdru:="LPT1",_nastepny:=.f.
cls
@ 0,0 say _tex
BEGIN SEQUENCE

DO WHILE .t.
  _pliki:=DIRECTORY(_sc+"*.PRN")
  if len(_pliki)=0
    QKE("Brak zapamitanych plikw !")
    BREAK
  endif
  
  // kasowanie stopek i nagwkw gdyby pozostay w katalogu
  
  if (_st:=ascan(_pliki,{|x| x[1]=="STOP.PRN"}))>0
    adel(_pliki,_st)
    asize(_pliki,len(_pliki)-1)
  endif  
  
  if (_na:=ascan(_pliki,{|x| x[1]=="NAG.PRN"}))>0
    adel(_pliki,_na)
    asize(_pliki,len(_pliki)-1)
  endif  
  
  if (_na:=ascan(_pliki,{|x| x[1]=="DOD.PRN"}))>0
    adel(_pliki,_na)
    asize(_pliki,len(_pliki)-1)
  endif  
  
  if len(_pliki)=0
    QKE("Brak zapamitanych plikw !")
    BREAK
  endif

  CPClose(PLIKI)
  dele file (_sc+"PLIKI.DBF")

  _astru:={}  
  aadd(_astru,{"NAZWA","C",8,0})
  aadd(_astru,{"DATA","D",8,0})
  aadd(_astru,{"CZAS","C",8,0})
  aadd(_astru,{"ROZMIAR","N",8,0})
  dbcreate(_sc+"PLIKI",_astru)

  sele 0
  _use(_sc+"PLIKI","E!")
  inde on NAZWA to (_sc+"PLIKI_N")
  inde on dtos(DATA)+CZAS to (_sc+"PLIKI_D")
  set inde to  (_sc+"PLIKI_N"), (_sc+"PLIKI_D")
  
  aeval(_pliki,{ |aPrnFile| PLIKI->(dbappend()),;
                            _kropka:=at(".",aPrnFile[F_NAME]),;
                            PLIKI->NAZWA:=subs(aPrnFile[F_NAME],1,_kropka-1),;
                            PLIKI->DATA:=aPrnFile[F_DATE],; 
                            PLIKI->CZAS:=aPrnFile[F_TIME],;
                            PLIKI->ROZMIAR:=aPrnFile[F_SIZE] })
  

   set orde to 2
   go bott
   skip -10
  
  CPEDIT  POZ: 1,,23,               ;
          DEF: "PLIKI"             ;
          POZWER: "V1"              ;
          PION: ,,,              ;
          INDEXY: {"nazwa","data+czas"}                ;
          EDYCJA: .f.               ;
          ODTWORZ:.f.               ;
          AKCJA: _r:=DAJ_PLIK()

  if _r<>NIL
    _r:=alltrim(_r)
    @1,0 clea to 24,79
    max_line_len:=275
    _pp:=_sc+_r+".PRN"
    @ 1,0 say "Plik : "+_pp  
    @ 24,0 say "ALT_F - wyszukiwanie tekstu, ALT_R - kontynuacja"
    FileBrowse(_pp,2,,23)
    @ 24,0
*    tb27(_pp,2)
    do while .t.
      _wybor:=;
      HorizMenu(24,0,"",{"LPT1","LPT2","LPT3","SKASOWANIE PLIKU","NASTPNY",;
                         "KONIEC"})
      do case
        case _wybor=0 .or. _wybor>=5
          exit 
        case _wybor=4.and.QTN("Skasowanie pliku "+alltrim(_pp)+" ?")
          dele file (_pp)
          exit
        case _wybor=1 .or. _wybor=2 .or. _wybor=3
          _portdru:=if(_wybor=1,"LPT1",if(_wybor=2,"LPT2","LPT3"))
          DRUKUJ_PLIK(_pp,_portdru)
      endcase
    enddo
  else
   exit
  endi
  if _wybor>=1 .and. _wybor<=5
    @ 1,0 clea to 24,79
    loop
  endi

  exit
ENDDO
END SEQUENCE
close data
dele file  (_sc+"PLIKI.DBF")
dele file  (_sc+"PLIKI_N.NTX")
dele file  (_sc+"PLIKI_D.NTX")

RETU NIL
*******************************************************************************
FUNCTION DAJ_PLIK()        
static _wyjscie:=.f.                        // .T. jesli akcja wymusila wyjscie
local _l:=lastkey(), _np:=PLIKI->NAZWA

if _wyjscie
  _wyjscie:=.f.
  RETU _np
endif

if (_l=K_ENTER .or. _l=K_ALT_F7)
  keyboard chr(K_ESC)              // wroci jeszcze raz do AKCJI !!
  _wyjscie:=.t.
  RETURN NIL
endif
RETU NIL

*******************************************************************************
FUNCTION DRUKUJ_PLIK(_nazwa,_port)           
local prevhandler:=errorblock(),nhandle,cbuffer,_aa
max_line_len:=275    // static

* QPC(1)
set devi to print
set printer to (_port)
errorblock( { |e| PrintError(_port,e,prevhandler) } )

BEGIN SEQUENCE

if (nhandle:=Fopen(_nazwa)) = 0;  BREAK; endif    // otwieramy
Fseek(nhandle,0)                                  // poczatek 
_koniec:=.f.
do whil .t.                       
  if .not.PRINTER_OK(_port)
    clea typeahead
    inkey(1)
  endi
  if .not.PRINTER_OK(_port)
    set devi to screen
    if QTN("Drukarka nie jest gotowa  -  ponowienie prby wydruku ?")
      QKE("Przygotuj drukark !",,,,.t.)
      if lastkey()=K_ESC; BREAK; endi
    else
      BREAK
    endi
  else
    exit
  endi
endd
do while !_koniec
  Freadln(nhandle,@cBuffer,max_line_len)
  _aa:=At(chr(26), cBuffer) 
  _koniec:= _aa> 0
  if _koniec
    cbuffer:=subs(cbuffer,1,_aa-1)
  endif
  if inkey()=K_ESC; BREAK; endif
  @ prow()+1,0 say cBuffer
enddo
fclose(nhandle)
END SEQUENCE
QPC(0)
set devi to screen
errorblock(prevhandler)
RETU NIL

*******************************************************************************
FUNCTION POMOC()
loca _tex:=;
     '۲  POMOC  ',;
     _portdru,_wybor
cls
@ 1,0 say _tex

TB_PLIK("pomoc.mem")

@ 24,0
_wybor:=HorizMenu(24,0,"WYDRUK :",{"LPT1","LPT2","LPT3","KONIEC"},4)
if _wybor=1.or._wybor=2.or._wybor=3
  _portdru:=if(_wybor=1,"LPT1",if(_wybor=2,"LPT2","LPT3"))
  DRUKUJ_PLIK("crm.mem",_portdru)
endi

RETURN NIL

*******************************************************************************
FUNCTION SK()     
local _s:=Eval(MemVarBlock(readvar()))
if val(_s)>0
  _s:=strtran(str(val(_s),len(_s))," ","0")
  Eval(MemVarBlock(readvar()),_s)
elseif val(_s)=0.and.val(subs(_s,2))>0
  _s:=subs(_s,1,1)+strtran(str(val(subs(_s,2)),len(subs(_s,2)))," ","0")
  Eval(MemVarBlock(readvar()),_s)
endi
RETURN .T.

*******************************************************************************
FUNCTION Getfont()
local aFonts
local nloop, nrow:=1
local _wybor:=1
local _lat:=;
chr(165)+chr(134)+chr(169)+chr(136)+chr(228)+chr(162)+chr(152)+chr(171)+chr(190)+;
chr(164)+chr(143)+chr(168)+chr(157)+chr(227)+CHR(224)+chr(151)+chr(141)+chr(189)

local _win:=;
chr(185)+chr(230)+chr(234)+chr(179)+chr(241)+CHR(243)+chr(156)+chr(159)+chr(191)+;
chr(165)+chr(198)+chr(202)+chr(163)+chr(209)+chr(211)+chr(140)+chr(143)+chr(175)

loca _tex:='۲  LISTA DOSTPNYCH CZCIONEK  '
cls
@ 0,0 say _tex

BEGIN SEQUENCE

@ 2,2 say "Opcja drukuje na domylnej drukarce Windows list dostpnych czcionek dla "
@ 3,2 say "wydrukw uywajcych PScript. Dla portu WIN wyboru naley dokona sposrd"
@ 4,2 say "czcionek ze sta szerokoci i polskimi znakami diaktrycznymi."

@ 5,2 say "Wybran czcionk wpisuje si do pola Czcionka PS w opcji USTAWIENIA"
@ 6,2 say "z menu WYDRUK USTAWIENIA .... Pozostawienie dla portu WIN pustego pola"
@ 7,2 say "oznacza wybr czcionki Courier New."
@ 8,2 say "Domyln czcionk dla wydrukw graficznych jest Arial"
@ 9,2 say "Mona wybra czcionk o staej szerokoci bez polskich znakw ale"
@ 10,2 say "wtedy w opcji USTAWIENIA w polu Konwersja naley zmieni WIN na STD."
@ 11,2 say "Polskie znaki bd drukowane bez 'ogonkw' - a zamiast  itp."

@ 13,2 say "Wybr czcionki o staej szerokoci powinien uatwi pocztek testowego"
@ 14,2 say "tekstu 'MIM....' - czcionki M i I powinny zajmowa tak sam szeroko."
@ 15,2 say "Przykady czcionek o staej szerokoci: Courier New, Lucida Console,"
@ 16,2 say "Letter Gothic, OCR A Extended."

@ 18,2 say "Lista zostanie wygenerowana jesli przy starcie programu pojawi si" 
@ 19,2 say "komunikat 'PScript - OK !'"

if _ps=0
  _wybor:=HorizMenu(21,2,"",{"KONTYNUACJA","REZYGNACJA"})
else
  @ 21,2 say "PageScript nie zosta zainicjowany. Nacinij klawisz." COLOR "N/W"
  inkey(0)
  BREAK
endif

if _wybor=2 .or. _wybor=0;BREAK;endi

BEGINDOC  TITLE "Lista czcionek"  ORIENTATION APS_PORTRAIT
   aFonts := PSGetFonts()
   PSSetUnit(APS_TEXT)
   PSSetRowCol(50, 80)
   PSSetFont(APS_ARIAL, APS_PLAIN, 12)

   for nLoop := 1 to Len(aFonts)
      @nRow,0  TEXTOUT aFonts[nLoop]
//      @nRow,39 TEXTOUT aFonts[nLoop]  FONT aFonts[nLoop]
//      @nRow,39 TEXTOUT  "LATMIM"+_lat FONT aFonts[nLoop]
//      PSLine(nRow + 1, 0, nRow + 1, 80, 1, APS_BLACK)
      @nRow,39 TEXTOUT  "WINMIM"+_win FONT aFonts[nLoop]
      PSLine(nRow + 1, 0, nRow + 1, 80, 1, APS_BLACK)
      nrow+=2
      if nRow > 48
         nRow := 0
         PSNewPage()
      endif
   next nLoop
ENDDOC

END SEQUENCE

RETURN NIL

*******************************************************************************
FUNCTION WYB_DR_PS(_wariant,_seryjny)
   // funkcja zwaraca numer drukarki i czcionke {_ndrukarka,_font_ps}
local savescr, aprinters,i,_tdrukarka,ret,apom:={},_ndrukarka:=0
local _sel:=select(), getlist:={}
local _save:="N" ,ff,_scc,_font_ps

DEFAULT _seryjny TO .f.

BEGIN SEQUENCE

sele 0
_use (_sc+"PARADRUK","R!")
_lkonw:=  (fieldpos("KONWERSJA")=0)
_lorient:=(fieldpos("ORIENTACJA")=0)
_lfontps:=(fieldpos("FONT_PS")=0)
_ldrukarka:=(fieldpos("DRUKARKA")=0)
if _lkonw .or. _lorient .or. _lfontps .or. _ldrukarka
  _astru:=DBSTRUCT()
  close PARADRUK
  if _lkonw
    aadd(_astru,{"KONWERSJA","C",6,0})
  endi
  if _lorient
    aadd(_astru,{"ORIENTACJA","C",1,0})
  endi
  if _lfontps
    aadd(_astru,{"FONT_PS","C",30,0})
  endi
  if _ldrukarka
    aadd(_astru,{"DRUKARKA","C",30,0})
  endi
  dbcreate(_sc+"STRU",_astru)

  sele 0
  _use (_sc+"STRU","E!")
  appe from (_sc+"PARADRUK")
  copy to (_sc+"PARADRUK")
  _use (_sc+"PARADRUK","E!")
  dele file (_sc+"STRU.DBF")

  set filter to alltrim(PORT)="WIN"
    // program w LATIN 
  repl all KONWERSJA with "LATWIN"
  set filter to

endi

set inde to (_sc+"PARADRUK")
seek _wariant
ff:=found()

if ff
   redit:=recn()
else
  close PARADRUK

  sele 0
  _use (_sc+"PARADRUK","F!")
  set inde to (_sc+"PARADRUK")
  append blank
  repl WARIANT with _wariant
  seek _wariant
  ff:=found()
  redit:=recn()
endif   
*--------------  
//ALTD()
aprinters:=PSGetPrinters()
if ff
  _font_ps:=FONT_PS 
  _tdrukarka:=if(!empty(DRUKARKA),DRUKARKA,space(30))
  if !empty(_tdrukarka)
    _ndrukarka:=ascan(aprinters,alltrim(_tdrukarka))
  else
     _ndrukarka:=0
  endif   
else
  _ndrukarka:=0
  _tdrukarka:=space(30)
  _font_ps:=space(30)
endif   
CpClose(PARADRUK) 
 
//altd()
if _seryjny; BREAK;endif
   
do while .t.
  @ 24,0
  _ust_dru:=HorizMenu(24,0,"",{"WYDRUK","USTAWIENIA","PLIK PDF", "PODGLD WYDRUKU"})
  @ 24,0

  if _ust_dru=0
    _ndrukarka:=999
    BREAK
  elseif _ust_dru=4
    _ndrukarka:=997
    BREAK
  elseif _ust_dru=3
    _ndrukarka:=998
    BREAK
  elseif _ust_dru=1
     BREAK
  else   
                        
    _scc:=savescreen(14,0,18,64)  
    @  14,0 clea to 18,64
    @  14,0,18,64 box R_GRUBA
    @  15,2 say "Drukarka:  " get _tdrukarka pict "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
                    when (DAJ_DRUKARKI() .and.SLGET("DRUKARKI","DRUKARKI","V1",-1,1,{"drukarka"})) ;
                    valid SLGET()
    @ 16,2 say  "Czcionka:  " get _font_ps pict "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
                   
    @ 17,2 say  "Zapamita?" get _save  pict "@! X" valid _save$"TN"                  
                                       
    set cursor on;read;set cursor off  
    restscreen(14,0,18,64,_scc)
    if !empty(_tdrukarka)   
      _ndrukarka:=ascan(aprinters,alltrim(_tdrukarka))  
    else
      _ndrukarka:=0
    endi
    CpClose(DRUKARKI)
    if _save="T"
       
      CPClose(PARADRUK)
      sele 0
      _use(_sc+"PARADRUK","E!")
      go redit
      repl DRUKARKA with _tdrukarka, FONT_PS with _font_ps
      close PARADRUK
    endi  
    
    @ 24,0  
  endif
enddo

END SEQUENCE
sele (_sel)
if empty(_font_ps);_font_ps:="Arial";endif
RETURN {_ndrukarka,_font_ps}

*******************************************************************************
FUNCTION TEKST(_t)
local _i
for _i:=1 to len(_t); ZNAK(subs(_t,_i,1)); next
RETURN NIL

*******************************************************************************
FUNCTION MATRYCA()
_znaki:={}
aadd(_znaki,{"0","˻","","ʼ",4})
aadd(_znaki,{"1","ͻ ","  ","",4})
aadd(_znaki,{"2","ͻ","ͼ","",4})
aadd(_znaki,{"3","ͻ"," ͹","ͼ",4})
aadd(_znaki,{"4"," ","͹","  ",4})
aadd(_znaki,{"5","","ͻ","ͼ",4})
aadd(_znaki,{"6","ͻ","ͻ","ͼ",4})
aadd(_znaki,{"7","ͻ","  ","  ",4})
aadd(_znaki,{"8","ͻ","͹","ͼ",4})
aadd(_znaki,{"9","ͻ","͹","ͼ",4})
aadd(_znaki,{"-","   ","","   ",4})
aadd(_znaki,{"+","   ","","   ",4})
aadd(_znaki,{"*","   ","","   ",4})
aadd(_znaki,{" ","   ","   ","   ",4})
aadd(_znaki,{".","   ","   ","  ",4})
aadd(_znaki,{":","   ","  ","  ",4})
aadd(_znaki,{",","   ","   ","  ",4})
aadd(_znaki,{'"'," ","   ","   ",4})
aadd(_znaki,{"'","  ","   ","   ",4})

*aadd(_znaki,{"/","  ","  ","  ",4})

aadd(_znaki,{"/","   ","  ","   ",4})
aadd(_znaki,{"A","ͻ","͹"," ",4}) 
aadd(_znaki,{"","ͻ","͹"," ",4}) 
aadd(_znaki,{"B","ͻ","͹","ͼ",4}) 
aadd(_znaki,{"C","ͻ","  ","ͼ",4})
aadd(_znaki,{"","λ","  ","ͼ",4})
aadd(_znaki,{"D","ͻ"," ","ͼ",4})
aadd(_znaki,{"E","ͻ"," ","ͼ",4})
aadd(_znaki,{"","ͻ"," ","",4})
aadd(_znaki,{"F","ͻ"," ","  ",4})
aadd(_znaki,{"G","ͻ"," ","ͼ",4})
aadd(_znaki,{"H"," ","͹"," ",4})
aadd(_znaki,{"I","","  ","",4})
aadd(_znaki,{"J","  ","  ","ȼ ",4})
aadd(_znaki,{"K","","ʻ"," ",4})
aadd(_znaki,{"L","  ","  ","ͼ",4})
aadd(_znaki,{"","  "," ","ͼ",4})
aadd(_znaki,{"M","˻",""," ",4})
aadd(_znaki,{"N","ɻ","","ȼ",4})
aadd(_znaki,{"","ɹ","","ȼ",4})
aadd(_znaki,{"O","ͻ"," ","ͼ",4})
aadd(_znaki,{"","λ"," ","ͼ",4})
aadd(_znaki,{"P","ͻ","ͼ","  ",4})
aadd(_znaki,{"Q","ͻ"," ","",4})
aadd(_znaki,{"R","ͻ","˼","",4})
aadd(_znaki,{"S","ͻ","ͻ","ͼ",4})
aadd(_znaki,{"","λ","ͻ","ͼ",4})
aadd(_znaki,{"T","˻","  ","  ",4})
aadd(_znaki,{"U"," "," ","ͼ",4})
aadd(_znaki,{"W"," ","","ʼ",4})
aadd(_znaki,{"V"," ","ɼ","ȼ ",4})
aadd(_znaki,{"X","","λ","ͼ",4})
aadd(_znaki,{"Y"," ","˼","  ",4})
aadd(_znaki,{"Z","ͻ","ͼ","",4})
aadd(_znaki,{"","λ","ͼ","",4})
aadd(_znaki,{"","ͻ","μ","",4})
aadd(_znaki,{"z","   "," ͻ"," ",4})
aadd(_znaki,{"","   ","  "," ",4})

RETURN NIL

*******************************************************************************
FUNCTION ZNAK(_z)       
local _r:=row(),_c:=col(),_l:=0

_l:=ascan(_znaki,{|x| x[1]=_z })
if _l>0
  if _r>22.or._c>80-_znaki[_l][5]; chr(7); RETURN NIL;  endi
  devpos(_r,  _c); devout(_znaki[_l][2])
  devpos(_r+1,_c); devout(_znaki[_l][3])
  devpos(_r+2,_c); devout(_znaki[_l][4])
  devpos(_r,_c+_znaki[_l][5])  // +if(_znaki[_l][5]=0,1,0))
endi
RETURN NIL

*******************************************************************************
FUNCTION DZIEL(t,max)
// podzial t w miejscu spacji na 2 czesci
// dlugosc kazdej  czesci nie moze przekroczyc max
// dla przeleww  max=61

local t1:="",t2:="",_aret:={},_bierztoken,_poprztoken,_iletokenow,i,_ok:=.f.

//1.
BEGIN SEQUENCE

t:=alltrim(t)
if len(t)<=max
  _aret:={padr(t,max),space(max)}
  _ok:=.t.
  BREAK
endi

_iletokenow:=NUMTOKEN(t," ")  // liczba tokenw oddzielonych spacj
for i:=1 to _iletokenow
  _bierztoken:=ATTOKEN(t," ",i)
  if _bierztoken > max+2   //pozycja i-tego tokena
    _poprztoken:=ATTOKEN(t," ",i-1)           // pozycja i-1 tokena
    t1:=subs(t,1,_poprztoken-2)
    t2:=subs(t,_poprztoken)
    if len(t2)<=max
      _aret:={padr(t1,max),padr(t2,max)}
      _ok:=.t.
      BREAK
    endi
  endi
next
t1:=subs(t,1,_bierztoken-2)
t2:=subs(t,_bierztoken)
if len(t2)<=max
  _aret:={padr(t1,max),padr(t2,max)}
  _ok:=.t.
  BREAK
endi

END SEQUENCE

if !_ok
  t1:=subs(t,1,max)
  t2:=padr(subs(t,max+1) ,max)
  _aret:={t1,t2}
endi

RETURN _aret

*******************************************************************************
**********************************  E_MAIL  ***********************************
*******************************************************************************
FUNCTION HB_SendMail( cServer, nPort, cFrom, aTo, aCC, aBCC, cBody, cSubject, aFiles, cUser, cPass, cPopServer, nPriority, lRead, lTrace, lPopAuth, lNoAuth, nTimeOut, cReplyTo )
   /*
   cServer    -> Required. IP or domain name of the mail server
   nPort      -> Optional. Port used my email server
   cFrom      -> Required. Email address of the sender
   aTo        -> Required. Character string or array of email addresses to send the email to
   aCC        -> Optional. Character string or array of email adresses for CC (Carbon Copy)
   aBCC       -> Optional. Character string or array of email adresses for BCC (Blind Carbon Copy)
   cBody      -> Optional. The body message of the email as text, or the filename of the HTML message to send.
   cSubject   -> Optional. Subject of the sending email
   aFiles     -> Optional. Array of attachments to the email to send
   cUser      -> Required. User name for the POP3 server
   cPass      -> Required. Password for cUser
   cPopServer -> Required. Pop3 server name or address
   nPriority  -> Optional. Email priority: 1=High, 3=Normal (Standard), 5=Low
   lRead      -> Optional. If set to .T., a confirmation request is send. Standard setting is .F.
   lTrace     -> Optional. If set to .T., a log file is created (sendmail<nNr>.log). Standard setting is .F.
   lNoAuth    -> Optional. Disable Autentication methods
   nTimeOut   -> Optional. Number os ms to wait default 20000 (20s)
   cReplyTo   -> Optional.
   */

   LOCAL oInMail, cBodyTemp, oUrl, oMail, oAttach, aThisFile, cFile, cData, oUrl1

   LOCAL cTmp          := ""
   LOCAL cMimeText
   LOCAL cTo           := ""
   LOCAL cCC           := ""
   LOCAL cBCC          := ""

   LOCAL lConnectPlain := .F.
   LOCAL lReturn       := .T.
   LOCAL lAuthLogin    := .F.
   LOCAL lAuthPlain    := .F.
   LOCAL lConnect      := .T.
   LOCAL oPop
   LOCAL adata := {}, nCount
   LOCAL cTemp

   DEFAULT cUser       TO ""
   DEFAULT cPass       TO ""
   DEFAULT nPort       TO 25
   DEFAULT aFiles      TO {}
   DEFAULT nPriority   TO 3
   DEFAULT lRead       TO .F.
   DEFAULT lTrace      TO .F.
   DEFAULT lPopAuth    TO .T.
   DEFAULT lNoAuth     TO .F.
   DEFAULT nTimeOut    TO 3000
   DEFAULT cReplyTo    TO ""

   IF ValType( aFiles ) == "C"
      cTemp := aFiles
      aFiles := { cTemp }
   ENDIF

   cUser := StrTran( cUser, "@", "&at;" )

   IF !( ( ".htm" IN Lower( cBody ) .OR. ".html" IN Lower( cBody ) ) .AND. File( cBody ) )

      IF !( Right( cBody, 2 ) == hb_osNewLine() )
         cBody += hb_osNewLine()
      ENDIF

   ENDIF

// cTo
   IF ValType( aTo ) == "A"
      IF Len( aTo ) > 1
         FOR EACH cTo IN aTo
            IF HB_EnumIndex() != 1
               cTmp += cTo + ","
            ENDIF
         NEXT
         cTmp := SubStr( cTmp, 1, Len( cTmp ) - 1 )
      ENDIF
      cTo := aTo[ 1 ]
      IF Len( cTmp ) > 0
         cTo += "," + cTmp
      ENDIF
   ELSE
      cTo := AllTrim( aTo )
   ENDIF


// CC (Carbon Copy)
   IF ValType( aCC ) == "A"
      IF Len( aCC ) > 0
         FOR EACH cTmp IN aCC
            cCC += cTmp + ","
         NEXT
         cCC := SubStr( cCC, 1, Len( cCC ) - 1 )
      ENDIF
   ELSEIF ValType( aCC ) == "C"
      cCC := AllTrim( aCC )
   ENDIF


// BCC (Blind Carbon Copy)
   IF ValType( aBCC ) == "A"
      IF Len( aBCC ) > 0
         FOR EACH cTmp IN aBCC
            cBCC += cTmp + ","
         NEXT
         cBCC := SubStr( cBCC, 1, Len( cBCC ) - 1 )
      ENDIF
   ELSEIF ValType( aBCC ) == "C"
      cBCC := AllTrim( aBCC )
   ENDIF

   IF cPopServer != NIL .AND. lPopAuth
      TRY
         oUrl1 := tUrl():New( "pop://" + cUser + ":" + cPass + "@" + cPopServer + "/" )
         oUrl1:cUserid := StrTran( cUser, "&at;", "@" )
         opop := tIPClientPOP():New( oUrl1, lTrace )
         IF oPop:Open()
            oPop:Close()
         ENDIF
      CATCH
         lReturn := .F.
      END

   ENDIF

   IF !lReturn
      RETURN .F.
   ENDIF

   TRY
      oUrl := tUrl():New( "smtp://" + cUser + "@" + cServer + '/' + cTo )
   CATCH
      lReturn := .F.
   END

   IF !lReturn
      RETURN .F.
   ENDIF

   oUrl:nPort   := nPort
   oUrl:cUserid := StrTran( cUser, "&at;", "@" )

   oMail   := tipMail():new()
   oAttach := tipMail():new()
   oAttach:SetEncoder( "8bit" )

   IF ( ".htm" IN Lower( cBody ) .OR. ".html" IN Lower( cBody ) ) .AND. File( cBody )
      cMimeText := "text/html ; charset=UTF-8"
      oAttach:hHeaders[ "Content-Type" ] := cMimeText
      cBodyTemp := cBody
      cBody     := MemoRead( cBodyTemp ) + Chr( 13 ) + Chr( 10 )

   ELSE
      oMail:hHeaders[ "Content-Type" ] := "text/plain; charset=UTF-8"
   ENDIF

   oAttach:SetBody( cBody )
   oMail:Attach( oAttach )
   oUrl:cFile := cTo + If( Empty( cCC ), "", "," + cCC ) + If( Empty( cBCC ), "", "," + cBCC )

   oMail:hHeaders[ "Date" ] := tip_Timestamp()
   oMail:hHeaders[ "From" ] := cFrom

   IF !Empty( cCC )
      oMail:hHeaders[ "Cc" ] := cCC
   ENDIF
   //IF !Empty( cBCC )
      //oMail:hHeaders[ "Bcc" ] := cBCC
   //ENDIF
   IF !Empty( cReplyTo )
      oMail:hHeaders[ "Reply-To" ] := cReplyTo
   ENDIF

   TRY
      oInmail := tIPClientSMTP():New( oUrl, lTrace )
   CATCH
      lReturn := .F.
   END

   IF !lReturn
      RETURN .F.
   ENDIF

   oInmail:nConnTimeout := nTimeOut

   IF !lNoAuth

      IF oInMail:Opensecure()

         WHILE .T.
            oInMail:GetOk()
            IF oInMail:cReply == NIL .or. SUBSTR(oInMail:cReply,1,4) == "250 " // culik Last return from EHLO  return code + 1 space
               EXIT
            ELSEIF "LOGIN" IN oInMail:cReply
               lAuthLogin := .T.
            ELSEIF "PLAIN" IN oInMail:cReply
               lAuthPlain := .T.
            ENDIF
         ENDDO

         IF lAuthLogin
            IF !oInMail:Auth( StrTran( cUser, "&at;", "@" ), cPass )
               lConnect := .F.
            ELSE
               lConnectPlain  := .T.
            ENDIF
         ENDIF

         IF lAuthPlain .AND. !lConnect
            IF !oInMail:AuthPlain( StrTran( cUser, "&at;", "@" ), cPass )
               lConnect := .F.
            ENDIF
         ELSE
            IF !lConnectPlain
               oInmail:Getok()
               lConnect := .F.
            ENDIF
         ENDIF
      ELSE
         lConnect := .F.
      ENDIF
   ELSE
      lConnect := .F.
   ENDIF

   IF !lConnect

      IF !lNoAuth
         oInMail:Close()
      ENDIF

      TRY
         oInmail := tIPClientsmtp():New( oUrl, lTrace )
      CATCH
      END

      oInmail:nConnTimeout := nTimeOut


      IF !oInMail:Open()
         oInmail:Close()
         RETURN .F.
      ENDIF

      WHILE .T.
         oInMail:GetOk()
         IF oInMail:cReply == NIL  .or. Left( oInMail:cReply, 3 ) == '250'  // culik HELO return only 250 from server 
            EXIT
         ENDIF
      ENDDO

   ENDIF

   oInMail:oUrl:cUserid := cFrom
   oMail:hHeaders[ "To" ]      := cTo
   oMail:hHeaders[ "Subject" ] := cSubject

   FOR EACH aThisFile IN AFiles

      IF ValType( aThisFile ) == "C"
         cFile := aThisFile
         MemoRead( cFile )
      ELSEIF ValType( aThisFile ) == "A" .AND. Len( aThisFile ) >= 2
         cFile := aThisFile[ 1 ]
      ELSE
         EXIT
      ENDIF

      omail:AttachFile( cFile )
   NEXT

   IF lRead
      oMail:hHeaders[ "Disposition-Notification-To" ] := StrTran( cUser, "&at;", "@" )
   ENDIF

   IF nPriority != 3
      oMail:hHeaders[ "X-Priority" ] := Str( nPriority, 1 )
   ENDIF

//   oInmail:Write( oMail:ToString() )
   cData := oMail:ToString()
   FOR nCount := 1 TO Len( cData ) STEP 1024
      AAdd( aData, SubStr( cData,nCount,1024 ) )
   NEXT

   FOR nCount := 1 TO Len( aData )
      oInmail:Write( aData[nCount], Len( aData[nCount] ) )
   NEXT

   lReturn := oInMail:Commit()

   oInMail:Close()

   RETURN lReturn

//-------------------------------------------------------------//

FUNCTION HB_SetMimeType( cFile, cFname, cFext )

   cFile := Lower( cFile )

IF cFile LIKE ".+\.vbd" 
   RETURN "application/activexdocument=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(asn|asz|asd)" 
   RETURN "application/astound=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pqi" 
   RETURN "application/cprplayer=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tsp" 
   RETURN "application/dsptype=" + cFname + cFext
ELSEIF cFile LIKE ".+\.exe" 
   RETURN "application/exe=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(sml|ofml)" 
   RETURN "application/fml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pfr" 
   RETURN "application/font-tdpfr=" + cFname + cFext
ELSEIF cFile LIKE ".+\.frl" 
   RETURN "application/freeloader=" + cFname + cFext
ELSEIF cFile LIKE ".+\.spl" 
   RETURN "application/futuresplash =" + cFname + cFext
ELSEIF cFile LIKE ".+\.gz" 
   RETURN "application/gzip =" + cFname + cFext
ELSEIF cFile LIKE ".+\.stk" 
   RETURN "application/hstu =" + cFname + cFext
ELSEIF cFile LIKE ".+\.ips" 
   RETURN "application/ips=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ptlk" 
   RETURN "application/listenup =" + cFname + cFext
ELSEIF cFile LIKE ".+\.hqx" 
   RETURN "application/mac-binhex40 =" + cFname + cFext
ELSEIF cFile LIKE ".+\.mbd" 
   RETURN "application/mbedlet=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mfp" 
   RETURN "application/mirage=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(pot|pps|ppt|ppz)" 
   RETURN "application/mspowerpoint =" + cFname + cFext
ELSEIF cFile LIKE ".+\.n2p" 
   RETURN "application/n2p=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(bin|class|lha|lzh|lzx|dbf)" 
   RETURN "application/octet-stream =" + cFname + cFext
ELSEIF cFile LIKE ".+\.oda" 
   RETURN "application/oda=" + cFname + cFext
ELSEIF cFile LIKE ".+\.axs" 
   RETURN "application/olescript=" + cFname + cFext
ELSEIF cFile LIKE ".+\.zpa" 
   RETURN "application/pcphoto=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pdf" 
   RETURN "application/pdf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(ai|eps|ps)" 
   RETURN "application/postscript=" + cFname + cFext
ELSEIF cFile LIKE ".+\.shw" 
   RETURN "application/presentations=" + cFname + cFext
ELSEIF cFile LIKE ".+\.qrt" 
   RETURN "application/quest=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rtc" 
   RETURN "application/rtc=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rtf" 
   RETURN "application/rtf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.smp" 
   RETURN "application/studiom=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dst" 
   RETURN "application/tajima=" + cFname + cFext
ELSEIF cFile LIKE ".+\.talk" 
   RETURN "application/talker=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tbk" 
   RETURN "application/toolbook =" + cFname + cFext
ELSEIF cFile LIKE ".+\.vmd" 
   RETURN "application/vocaltec-media-desc=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vmf" 
   RETURN "application/vocaltec-media-file=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wri" 
   RETURN "application/write=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wid" 
   RETURN "application/x-DemoShield =" + cFname + cFext
ELSEIF cFile LIKE ".+\.rrf" 
   RETURN "application/x-InstallFromTheWeb=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wis" 
   RETURN "application/x-InstallShield=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ins" 
   RETURN "application/x-NET-Install=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tmv" 
   RETURN "application/x-Parable-Thing=" + cFname + cFext
ELSEIF cFile LIKE ".+\.arj" 
   RETURN "application/x-arj=" + cFname + cFext
ELSEIF cFile LIKE ".+\.asp" 
   RETURN "application/x-asap=" + cFname + cFext
ELSEIF cFile LIKE ".+\.aab" 
   RETURN "application/x-authorware-bin =" + cFname + cFext
ELSEIF cFile LIKE ".+\.(aam|aas)" 
   RETURN "application/x-authorware-map =" + cFname + cFext
ELSEIF cFile LIKE ".+\.bcpio" 
   RETURN "application/x-bcpio=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vcd" 
   RETURN "application/x-cdlink =" + cFname + cFext
ELSEIF cFile LIKE ".+\.chat" 
   RETURN "application/x-chat=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cnc" 
   RETURN "application/x-cnc=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(coda|page)" 
   RETURN "application/x-coda=" + cFname + cFext
ELSEIF cFile LIKE ".+\.z" 
   RETURN "application/x-compress=" + cFname + cFext
ELSEIF cFile LIKE ".+\.con" 
   RETURN "application/x-connector=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cpio" 
   RETURN "application/x-cpio=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pqf" 
   RETURN "application/x-cprplayer=" + cFname + cFext
ELSEIF cFile LIKE ".+\.csh" 
   RETURN "application/x-csh=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(cu|csm)" 
   RETURN "application/x-cu-seeme=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(dcr|dir|dxr|swa)" 
   RETURN "application/x-director=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dvi" 
   RETURN "application/x-dvi=" + cFname + cFext
ELSEIF cFile LIKE ".+\.evy" 
   RETURN "application/x-envoy=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ebk" 
   RETURN "application/x-expandedbook=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gtar" 
   RETURN "application/x-gtar=" + cFname + cFext
ELSEIF cFile LIKE ".+\.hdf" 
   RETURN "application/x-hdf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.map" 
   RETURN "application/x-httpd-imap =" + cFname + cFext
ELSEIF cFile LIKE ".+\.phtml" 
   RETURN "application/x-httpd-php=" + cFname + cFext
ELSEIF cFile LIKE ".+\.php3" 
   RETURN "application/x-httpd-php3 =" + cFname + cFext
ELSEIF cFile LIKE ".+\.ica" 
   RETURN "application/x-ica=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ipx" 
   RETURN "application/x-ipix=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ips" 
   RETURN "application/x-ipscript=" + cFname + cFext
ELSEIF cFile LIKE ".+\.js" 
   RETURN "application/x-javascript =" + cFname + cFext
ELSEIF cFile LIKE ".+\.latex" 
   RETURN "application/x-latex=" + cFname + cFext
ELSEIF cFile LIKE ".+\.bin" 
   RETURN "application/x-macbinary=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mif" 
   RETURN "application/x-mif=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(mpl|mpire)" 
   RETURN "application/x-mpire=" + cFname + cFext
ELSEIF cFile LIKE ".+\.adr" 
   RETURN "application/x-msaddr =" + cFname + cFext
ELSEIF cFile LIKE ".+\.wlt" 
   RETURN "application/x-mswallet=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(nc|cdf)" 
   RETURN "application/x-netcdf =" + cFname + cFext
ELSEIF cFile LIKE ".+\.npx" 
   RETURN "application/x-netfpx =" + cFname + cFext
ELSEIF cFile LIKE ".+\.nsc" 
   RETURN "application/x-nschat =" + cFname + cFext
ELSEIF cFile LIKE ".+\.pgp" 
   RETURN "application/x-pgp-plugin =" + cFname + cFext
ELSEIF cFile LIKE ".+\.css" 
   RETURN "application/x-pointplus=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sh" 
   RETURN "application/x-sh =" + cFname + cFext
ELSEIF cFile LIKE ".+\.shar" 
   RETURN "application/x-shar=" + cFname + cFext
ELSEIF cFile LIKE ".+\.swf" 
   RETURN "application/x-shockwave-flash=" + cFname + cFext
ELSEIF cFile LIKE ".+\.spr" 
   RETURN "application/x-sprite =" + cFname + cFext
ELSEIF cFile LIKE ".+\.sprite" 
   RETURN "application/x-sprite =" + cFname + cFext
ELSEIF cFile LIKE ".+\.sit" 
   RETURN "application/x-stuffit=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sca" 
   RETURN "application/x-supercard=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sv4cpio" 
   RETURN "application/x-sv4cpio=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sv4crc" 
   RETURN "application/x-sv4crc =" + cFname + cFext
ELSEIF cFile LIKE ".+\.tar" 
   RETURN "application/x-tar=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tcl" 
   RETURN "application/x-tcl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tex" 
   RETURN "application/x-tex=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(texinfo|texi)" 
   RETURN "application/x-texinfo=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tlk" 
   RETURN "application/x-tlk=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(t|tr|roff)" 
   RETURN "application/x-troff=" + cFname + cFext
ELSEIF cFile LIKE ".+\.man" 
   RETURN "application/x-troff-man=" + cFname + cFext
ELSEIF cFile LIKE ".+\.me" 
   RETURN "application/x-troff-me=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ms" 
   RETURN "application/x-troff-ms=" + cFname + cFext
ELSEIF cFile LIKE ".+\.alt" 
   RETURN "application/x-up-alert=" + cFname + cFext
ELSEIF cFile LIKE ".+\.che" 
   RETURN "application/x-up-cacheop =" + cFname + cFext
ELSEIF cFile LIKE ".+\.ustar" 
   RETURN "application/x-ustar=" + cFname + cFext
ELSEIF cFile LIKE ".+\.src" 
   RETURN "application/x-wais-source=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xls" 
   RETURN "application/xls=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xlt" 
   RETURN "application/xlt=" + cFname + cFext
ELSEIF cFile LIKE ".+\.zip" 
   RETURN "application/zip=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(au|snd)" 
   RETURN "audio/basic=" + cFname + cFext
ELSEIF cFile LIKE ".+\.es" 
   RETURN "audio/echospeech =" + cFname + cFext
ELSEIF cFile LIKE ".+\.(gsm|gsd)" 
   RETURN "audio/gsm=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rmf" 
   RETURN "audio/rmf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tsi" 
   RETURN "audio/tsplayer=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vox" 
   RETURN "audio/voxware=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wtx" 
   RETURN "audio/wtx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(aif|aiff|aifc)" 
   RETURN "audio/x-aiff =" + cFname + cFext
ELSEIF cFile LIKE ".+\.(cht|dus)" 
   RETURN "audio/x-dspeech=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(mid|midi)" 
   RETURN "audio/x-midi =" + cFname + cFext
ELSEIF cFile LIKE ".+\.mp3" 
   RETURN "audio/x-mpeg =" + cFname + cFext
ELSEIF cFile LIKE ".+\.mp2" 
   RETURN "audio/x-mpeg =" + cFname + cFext
ELSEIF cFile LIKE ".+\.m3u" 
   RETURN "audio/x-mpegurl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(ram|ra)" 
   RETURN "audio/x-pn-realaudio =" + cFname + cFext
ELSEIF cFile LIKE ".+\.rpm" 
   RETURN "audio/x-pn-realaudio-plugin=" + cFname + cFext
ELSEIF cFile LIKE ".+\.stream" 
   RETURN "audio/x-qt-stream=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rmf" 
   RETURN "audio/x-rmf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(vqf|vql)" 
   RETURN "audio/x-twinvq=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vqe" 
   RETURN "audio/x-twinvq-plugin=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wav" 
   RETURN "audio/x-wav=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wtx" 
   RETURN "audio/x-wtx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mol" 
   RETURN "chemical/x-mdl-molfile=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pdb" 
   RETURN "chemical/x-pdb=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dwf" 
   RETURN "drawing/x-dwf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ivr" 
   RETURN "i-world/i-vrml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cod" 
   RETURN "image/cis-cod=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cpi" 
   RETURN "image/cpi=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fif" 
   RETURN "image/fif=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gif" 
   RETURN "image/gif=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ief" 
   RETURN "image/ief=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(jpeg|jpg|jpe)" 
   RETURN "image/jpeg=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rip" 
   RETURN "image/rip=" + cFname + cFext
ELSEIF cFile LIKE ".+\.svh" 
   RETURN "image/svh=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(tiff|tif)" 
   RETURN "image/tiff=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mcf" 
   RETURN "image/vasa=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(svf|dwg|dxf)" 
   RETURN "image/vnd=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wi" 
   RETURN "image/wavelet=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ras" 
   RETURN "image/x-cmu-raster=" + cFname + cFext
ELSEIF cFile LIKE ".+\.etf" 
   RETURN "image/x-etf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fpx" 
   RETURN "image/x-fpx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(fh5|fh4|fhc)" 
   RETURN "image/x-freehand =" + cFname + cFext
ELSEIF cFile LIKE ".+\.dsf" 
   RETURN "image/x-mgx-dsf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pnm" 
   RETURN "image/x-portable-anymap=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pbm" 
   RETURN "image/x-portable-bitmap=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pgm" 
   RETURN "image/x-portable-graymap =" + cFname + cFext
ELSEIF cFile LIKE ".+\.ppm" 
   RETURN "image/x-portable-pixmap=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rgb" 
   RETURN "image/x-rgb=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xbm" 
   RETURN "image/x-xbitmap=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xpm" 
   RETURN "image/x-xpixmap=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xwd" 
   RETURN "image/x-xwindowdump=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dig" 
   RETURN "multipart/mixed=" + cFname + cFext
ELSEIF cFile LIKE ".+\.push" 
   RETURN "multipart/x-mixed-replace=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(wan|waf)" 
   RETURN "plugin/wanimate=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ccs" 
   RETURN "text/ccs =" + cFname + cFext
ELSEIF cFile LIKE ".+\.(htm|html)" 
   RETURN "text/html=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pgr" 
   RETURN "text/parsnegar-document=" + cFname + cFext
ELSEIF cFile LIKE ".+\.txt" 
   RETURN "text/plain=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rtx" 
   RETURN "text/richtext=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tsv" 
   RETURN "text/tab-separated-values=" + cFname + cFext
ELSEIF cFile LIKE ".+\.hdml" 
   RETURN "text/x-hdml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.etx" 
   RETURN "text/x-setext=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(talk|spc)" 
   RETURN "text/x-speech=" + cFname + cFext
ELSEIF cFile LIKE ".+\.afl" 
   RETURN "video/animaflex=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(mpeg|mpg|mpe)" 
   RETURN "video/mpeg=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(qt|mov)" 
   RETURN "video/quicktime=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(viv|vivo)" 
   RETURN "video/vnd.vivo=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(asf|asx)" 
   RETURN "video/x-ms-asf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.avi" 
   RETURN "video/x-msvideo=" + cFname + cFext
ELSEIF cFile LIKE ".+\.movie" 
   RETURN "video/x-sgi-movie=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(vgm|vgx|xdr)" 
   RETURN "video/x-videogram=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vgp" 
   RETURN "video/x-videogram-plugin =" + cFname + cFext
ELSEIF cFile LIKE ".+\.vts" 
   RETURN "workbook/formulaone=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vtts" 
   RETURN "workbook/formulaone=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(3dmf|3dm|qd3d|qd3)" 
   RETURN "x-world/x-3dmf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.svr" 
   RETURN "x-world/x-svr=" + cFname + cFext
ELSEIF cFile LIKE ".+\.(wrl|wrz)" 
   RETURN "x-world/x-vrml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vrt" 
   RETURN "x-world/x-vrt=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rar" 
   RETURN "application/x-rar-compressed=" + cFname + cFext
ELSEIF cFile LIKE ".+\.torrent" 
   RETURN "application/x-bittorrent=" + cFname + cFext
ELSEIF cFile LIKE ".+\.x3d" 
   RETURN "application/vnd.hzn-3d-crossword=" + cFname + cFext
ELSEIF cFile LIKE ".+\.3gp" 
   RETURN "video/3gpp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.3g2" 
   RETURN "video/3gpp2=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mseq" 
   RETURN "application/vnd.mseq=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pwn" 
   RETURN "application/vnd.3m.post-it-notes=" + cFname + cFext
ELSEIF cFile LIKE ".+\.plb" 
   RETURN "application/vnd.3gpp.pic-bw-large=" + cFname + cFext
ELSEIF cFile LIKE ".+\.psb" 
   RETURN "application/vnd.3gpp.pic-bw-small=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pvb" 
   RETURN "application/vnd.3gpp.pic-bw-var=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tcap" 
   RETURN "application/vnd.3gpp2.tcap=" + cFname + cFext
ELSEIF cFile LIKE ".+\.7z" 
   RETURN "application/x-7z-compressed=" + cFname + cFext
ELSEIF cFile LIKE ".+\.abw" 
   RETURN "application/x-abiword=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ace" 
   RETURN "application/x-ace-compressed=" + cFname + cFext
ELSEIF cFile LIKE ".+\.acc" 
   RETURN "application/vnd.americandynamics.acc=" + cFname + cFext
ELSEIF cFile LIKE ".+\.acu" 
   RETURN "application/vnd.acucobol=" + cFname + cFext
ELSEIF cFile LIKE ".+\.atc" 
   RETURN "application/vnd.acucorp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.adp" 
   RETURN "audio/adpcm=" + cFname + cFext
ELSEIF cFile LIKE ".+\.aab" 
   RETURN "application/x-authorware-bin=" + cFname + cFext
ELSEIF cFile LIKE ".+\.aam" 
   RETURN "application/x-authorware-map=" + cFname + cFext
ELSEIF cFile LIKE ".+\.aas" 
   RETURN "application/x-authorware-seg=" + cFname + cFext
ELSEIF cFile LIKE ".+\.air" 
   RETURN "application/vnd.adobe.air-application-installer-package+zip=" + cFname + cFext
ELSEIF cFile LIKE ".+\.swf" 
   RETURN "application/x-shockwave-flash=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fxp" 
   RETURN "application/vnd.adobe.fxp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pdf" 
   RETURN "application/pdf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ppd" 
   RETURN "application/vnd.cups-ppd=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dir" 
   RETURN "application/x-director=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xdp" 
   RETURN "application/vnd.adobe.xdp+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xfdf" 
   RETURN "application/vnd.adobe.xfdf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.aac" 
   RETURN "audio/x-aac=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ahead" 
   RETURN "application/vnd.ahead.space=" + cFname + cFext
ELSEIF cFile LIKE ".+\.azf" 
   RETURN "application/vnd.airzip.filesecure.azf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.azs" 
   RETURN "application/vnd.airzip.filesecure.azs=" + cFname + cFext
ELSEIF cFile LIKE ".+\.azw" 
   RETURN "application/vnd.amazon.ebook=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ami" 
   RETURN "application/vnd.amiga.ami=" + cFname + cFext
ELSEIF cFile LIKE ".+\.apk" 
   RETURN "application/vnd.android.package-archive=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cii" 
   RETURN "application/vnd.anser-web-certificate-issue-initiation=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fti" 
   RETURN "application/vnd.anser-web-funds-transfer-initiation=" + cFname + cFext
ELSEIF cFile LIKE ".+\.atx" 
   RETURN "application/vnd.antix.game-component=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mpkg" 
   RETURN "application/vnd.apple.installer+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.aw " 
   RETURN "application/applixware=" + cFname + cFext
ELSEIF cFile LIKE ".+\.les" 
   RETURN "application/vnd.hhe.lesson-player=" + cFname + cFext
ELSEIF cFile LIKE ".+\.swi" 
   RETURN "application/vnd.aristanetworks.swi=" + cFname + cFext
ELSEIF cFile LIKE ".+\.s" 
   RETURN "text/x-asm=" + cFname + cFext
ELSEIF cFile LIKE ".+\.atomcat" 
   RETURN "application/atomcat+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.atomsvc" 
   RETURN "application/atomsvc+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.atom" 
   RETURN "application/atom+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ac" 
   RETURN "application/pkix-attr-cert=" + cFname + cFext
ELSEIF cFile LIKE ".+\.aif" 
   RETURN "audio/x-aiff=" + cFname + cFext
ELSEIF cFile LIKE ".+\.avi" 
   RETURN "video/x-msvideo=" + cFname + cFext
ELSEIF cFile LIKE ".+\.aep" 
   RETURN "application/vnd.audiograph=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dxf" 
   RETURN "image/vnd.dxf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dwf" 
   RETURN "model/vnd.dwf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.par" 
   RETURN "text/plain-bas=" + cFname + cFext
ELSEIF cFile LIKE ".+\.bcpio" 
   RETURN "application/x-bcpio=" + cFname + cFext
ELSEIF cFile LIKE ".+\.bin" 
   RETURN "application/octet-stream=" + cFname + cFext
ELSEIF cFile LIKE ".+\.bmp" 
   RETURN "image/bmp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.torrent " 
   RETURN "application/x-bittorrent=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cod" 
   RETURN "application/vnd.rim.cod=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mpm" 
   RETURN "application/vnd.blueice.multipass=" + cFname + cFext
ELSEIF cFile LIKE ".+\.bmi" 
   RETURN "application/vnd.bmi=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sh" 
   RETURN "application/x-sh=" + cFname + cFext
ELSEIF cFile LIKE ".+\.btif" 
   RETURN "image/prs.btif=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rep" 
   RETURN "application/vnd.businessobjects=" + cFname + cFext
ELSEIF cFile LIKE ".+\.bz" 
   RETURN "application/x-bzip=" + cFname + cFext
ELSEIF cFile LIKE ".+\.bz2" 
   RETURN "application/x-bzip2=" + cFname + cFext
ELSEIF cFile LIKE ".+\.csh" 
   RETURN "application/x-csh=" + cFname + cFext
ELSEIF cFile LIKE ".+\.c" 
   RETURN "text/x-c=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cdxml" 
   RETURN "application/vnd.chemdraw+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.css" 
   RETURN "text/css=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cdx" 
   RETURN "chemical/x-cdx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cml" 
   RETURN "chemical/x-cml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.csml" 
   RETURN "chemical/x-csml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cdbcmsg " 
   RETURN "application/vnd.contact.cmsg=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cla" 
   RETURN "application/vnd.claymore=" + cFname + cFext
ELSEIF cFile LIKE ".+\.c4g" 
   RETURN "application/vnd.clonk.c4group=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sub" 
   RETURN "image/vnd.dvb.subtitle=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cdmia" 
   RETURN "application/cdmi-capability=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cdmic" 
   RETURN "application/cdmi-container=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cdmid" 
   RETURN "application/cdmi-domain=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cdmio" 
   RETURN "application/cdmi-object=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cdmiq" 
   RETURN "application/cdmi-queue=" + cFname + cFext
ELSEIF cFile LIKE ".+\.c11amc" 
   RETURN "application/vnd.cluetrust.cartomobile-config=" + cFname + cFext
ELSEIF cFile LIKE ".+\.c11amz" 
   RETURN "application/vnd.cluetrust.cartomobile-config-pkg=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ras" 
   RETURN "image/x-cmu-raster=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dae" 
   RETURN "model/vnd.collada+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.csv" 
   RETURN "text/csv=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cpt" 
   RETURN "application/mac-compactpro=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wmlc" 
   RETURN "application/vnd.wap.wmlc=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cgm" 
   RETURN "image/cgm=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ice" 
   RETURN "x-conference/x-cooltalk=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cmx" 
   RETURN "image/x-cmx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xar" 
   RETURN "application/vnd.xara=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cmc" 
   RETURN "application/vnd.cosmocaller=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cpio" 
   RETURN "application/x-cpio=" + cFname + cFext
ELSEIF cFile LIKE ".+\.clkx" 
   RETURN "application/vnd.crick.clicker=" + cFname + cFext
ELSEIF cFile LIKE ".+\.clkk" 
   RETURN "application/vnd.crick.clicker.keyboard=" + cFname + cFext
ELSEIF cFile LIKE ".+\.clkp" 
   RETURN "application/vnd.crick.clicker.palette=" + cFname + cFext
ELSEIF cFile LIKE ".+\.clkt" 
   RETURN "application/vnd.crick.clicker.template=" + cFname + cFext
ELSEIF cFile LIKE ".+\.clkw" 
   RETURN "application/vnd.crick.clicker.wordbank=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wbs" 
   RETURN "application/vnd.criticaltools.wbs+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cryptonote" 
   RETURN "application/vnd.rig.cryptonote=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cif" 
   RETURN "chemical/x-cif=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cmdf" 
   RETURN "chemical/x-cmdf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cu" 
   RETURN "application/cu-seeme=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cww" 
   RETURN "application/prs.cww=" + cFname + cFext
ELSEIF cFile LIKE ".+\.curl" 
   RETURN "text/vnd.curl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dcurl" 
   RETURN "text/vnd.curl.dcurl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mcurl" 
   RETURN "text/vnd.curl.mcurl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.scurl" 
   RETURN "text/vnd.curl.scurl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.car" 
   RETURN "application/vnd.curl.car=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pcurl" 
   RETURN "application/vnd.curl.pcurl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cmp" 
   RETURN "application/vnd.yellowriver-custom-menu=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dssc" 
   RETURN "application/dssc+der=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xdssc" 
   RETURN "application/dssc+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.deb" 
   RETURN "application/x-debian-package=" + cFname + cFext
ELSEIF cFile LIKE ".+\.uva" 
   RETURN "audio/vnd.dece.audio=" + cFname + cFext
ELSEIF cFile LIKE ".+\.uvi" 
   RETURN "image/vnd.dece.graphic=" + cFname + cFext
ELSEIF cFile LIKE ".+\.uvh" 
   RETURN "video/vnd.dece.hd=" + cFname + cFext
ELSEIF cFile LIKE ".+\.uvm" 
   RETURN "video/vnd.dece.mobile=" + cFname + cFext
ELSEIF cFile LIKE ".+\.uvu" 
   RETURN "video/vnd.uvvu.mp4=" + cFname + cFext
ELSEIF cFile LIKE ".+\.uvp" 
   RETURN "video/vnd.dece.pd=" + cFname + cFext
ELSEIF cFile LIKE ".+\.uvs" 
   RETURN "video/vnd.dece.sd=" + cFname + cFext
ELSEIF cFile LIKE ".+\.uvv" 
   RETURN "video/vnd.dece.video=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dvi" 
   RETURN "application/x-dvi=" + cFname + cFext
ELSEIF cFile LIKE ".+\.seed" 
   RETURN "application/vnd.fdsn.seed=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dtb" 
   RETURN "application/x-dtbook+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.res" 
   RETURN "application/x-dtbresource+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ait" 
   RETURN "application/vnd.dvb.ait=" + cFname + cFext
ELSEIF cFile LIKE ".+\.svc" 
   RETURN "application/vnd.dvb.service=" + cFname + cFext
ELSEIF cFile LIKE ".+\.eol" 
   RETURN "audio/vnd.digital-winds=" + cFname + cFext
ELSEIF cFile LIKE ".+\.djvu" 
   RETURN "image/vnd.djvu=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dtd" 
   RETURN "application/xml-dtd=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mlp" 
   RETURN "application/vnd.dolby.mlp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wad" 
   RETURN "application/x-doom=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dpg" 
   RETURN "application/vnd.dpgraph=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dra" 
   RETURN "audio/vnd.dra=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dfac" 
   RETURN "application/vnd.dreamfactory=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dts" 
   RETURN "audio/vnd.dts=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dtshd" 
   RETURN "audio/vnd.dts.hd=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dwg" 
   RETURN "image/vnd.dwg=" + cFname + cFext
ELSEIF cFile LIKE ".+\.geo" 
   RETURN "application/vnd.dynageo=" + cFname + cFext
ELSEIF cFile LIKE ".+\.es" 
   RETURN "application/ecmascript=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mag" 
   RETURN "application/vnd.ecowin.chart=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mmr" 
   RETURN "image/vnd.fujixerox.edmics-mmr=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rlc" 
   RETURN "image/vnd.fujixerox.edmics-rlc=" + cFname + cFext
ELSEIF cFile LIKE ".+\.exi" 
   RETURN "application/exi=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mgz" 
   RETURN "application/vnd.proteus.magazine=" + cFname + cFext
ELSEIF cFile LIKE ".+\.epub" 
   RETURN "application/epub+zip=" + cFname + cFext
ELSEIF cFile LIKE ".+\.eml" 
   RETURN "message/rfc822=" + cFname + cFext
ELSEIF cFile LIKE ".+\.nml" 
   RETURN "application/vnd.enliven=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xpr" 
   RETURN "application/vnd.is-xpr=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xif" 
   RETURN "image/vnd.xiff=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xfdl" 
   RETURN "application/vnd.xfdl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.emma" 
   RETURN "application/emma+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ez2" 
   RETURN "application/vnd.ezpix-album=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ez3" 
   RETURN "application/vnd.ezpix-package=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fst" 
   RETURN "image/vnd.fst=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fvt" 
   RETURN "video/vnd.fvt=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fbs" 
   RETURN "image/vnd.fastbidsheet=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fe_launch" 
   RETURN "application/vnd.denovo.fcselayout-link=" + cFname + cFext
ELSEIF cFile LIKE ".+\.f4v" 
   RETURN "video/x-f4v=" + cFname + cFext
ELSEIF cFile LIKE ".+\.flv" 
   RETURN "video/x-flv=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fpx" 
   RETURN "image/vnd.fpx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.npx" 
   RETURN "image/vnd.net-fpx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.flx" 
   RETURN "text/vnd.fmi.flexstor=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fli" 
   RETURN "video/x-fli=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ftc" 
   RETURN "application/vnd.fluxtime.clip=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fdf" 
   RETURN "application/vnd.fdf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.f" 
   RETURN "text/x-fortran=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mif" 
   RETURN "application/vnd.mif=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fm" 
   RETURN "application/vnd.framemaker=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fh" 
   RETURN "image/x-freehand=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fsc" 
   RETURN "application/vnd.fsc.weblaunch=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fnc" 
   RETURN "application/vnd.frogans.fnc=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ltf" 
   RETURN "application/vnd.frogans.ltf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ddd" 
   RETURN "application/vnd.fujixerox.ddd=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xdw" 
   RETURN "application/vnd.fujixerox.docuworks=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xbd" 
   RETURN "application/vnd.fujixerox.docuworks.binder=" + cFname + cFext
ELSEIF cFile LIKE ".+\.oas" 
   RETURN "application/vnd.fujitsu.oasys=" + cFname + cFext
ELSEIF cFile LIKE ".+\.oa2" 
   RETURN "application/vnd.fujitsu.oasys2=" + cFname + cFext
ELSEIF cFile LIKE ".+\.oa3" 
   RETURN "application/vnd.fujitsu.oasys3=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fg5" 
   RETURN "application/vnd.fujitsu.oasysgp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.bh2" 
   RETURN "application/vnd.fujitsu.oasysprs=" + cFname + cFext
ELSEIF cFile LIKE ".+\.spl" 
   RETURN "application/x-futuresplash=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fzs" 
   RETURN "application/vnd.fuzzysheet=" + cFname + cFext
ELSEIF cFile LIKE ".+\.g3" 
   RETURN "image/g3fax=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gmx" 
   RETURN "application/vnd.gmx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gtw" 
   RETURN "model/vnd.gtw=" + cFname + cFext
ELSEIF cFile LIKE ".+\.txd" 
   RETURN "application/vnd.genomatix.tuxedo=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ggb" 
   RETURN "application/vnd.geogebra.file=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ggt" 
   RETURN "application/vnd.geogebra.tool=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gdl" 
   RETURN "model/vnd.gdl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gex" 
   RETURN "application/vnd.geometry-explorer=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gxt" 
   RETURN "application/vnd.geonext=" + cFname + cFext
ELSEIF cFile LIKE ".+\.g2w" 
   RETURN "application/vnd.geoplan=" + cFname + cFext
ELSEIF cFile LIKE ".+\.g3w" 
   RETURN "application/vnd.geospace=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gsf" 
   RETURN "application/x-font-ghostscript=" + cFname + cFext
ELSEIF cFile LIKE ".+\.bdf" 
   RETURN "application/x-font-bdf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gtar" 
   RETURN "application/x-gtar=" + cFname + cFext
ELSEIF cFile LIKE ".+\.texinfo " 
   RETURN "application/x-texinfo=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gnumeric" 
   RETURN "application/x-gnumeric=" + cFname + cFext
ELSEIF cFile LIKE ".+\.kml" 
   RETURN "application/vnd.google-earth.kml+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.kmz" 
   RETURN "application/vnd.google-earth.kmz=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gqf" 
   RETURN "application/vnd.grafeq=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gif" 
   RETURN "image/gif=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gv" 
   RETURN "text/vnd.graphviz=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gac" 
   RETURN "application/vnd.groove-account=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ghf" 
   RETURN "application/vnd.groove-help=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gim" 
   RETURN "application/vnd.groove-identity-message=" + cFname + cFext
ELSEIF cFile LIKE ".+\.grv" 
   RETURN "application/vnd.groove-injector=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gtm" 
   RETURN "application/vnd.groove-tool-message=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tpl" 
   RETURN "application/vnd.groove-tool-template=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vcg" 
   RETURN "application/vnd.groove-vcard=" + cFname + cFext
ELSEIF cFile LIKE ".+\.h261" 
   RETURN "video/h261=" + cFname + cFext
ELSEIF cFile LIKE ".+\.h263" 
   RETURN "video/h263=" + cFname + cFext
ELSEIF cFile LIKE ".+\.h264" 
   RETURN "video/h264=" + cFname + cFext
ELSEIF cFile LIKE ".+\.hpid" 
   RETURN "application/vnd.hp-hpid=" + cFname + cFext
ELSEIF cFile LIKE ".+\.hps" 
   RETURN "application/vnd.hp-hps=" + cFname + cFext
ELSEIF cFile LIKE ".+\.hdf" 
   RETURN "application/x-hdf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rip" 
   RETURN "audio/vnd.rip=" + cFname + cFext
ELSEIF cFile LIKE ".+\.hbci" 
   RETURN "application/vnd.hbci=" + cFname + cFext
ELSEIF cFile LIKE ".+\.jlt" 
   RETURN "application/vnd.hp-jlyt=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pcl" 
   RETURN "application/vnd.hp-pcl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.hpgl" 
   RETURN "application/vnd.hp-hpgl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.hvs" 
   RETURN "application/vnd.yamaha.hv-script=" + cFname + cFext
ELSEIF cFile LIKE ".+\.hvd" 
   RETURN "application/vnd.yamaha.hv-dic=" + cFname + cFext
ELSEIF cFile LIKE ".+\.hvp" 
   RETURN "application/vnd.yamaha.hv-voice=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sfd-hdstx" 
   RETURN "application/vnd.hydrostatix.sof-data=" + cFname + cFext
ELSEIF cFile LIKE ".+\.stk" 
   RETURN "application/hyperstudio=" + cFname + cFext
ELSEIF cFile LIKE ".+\.hal" 
   RETURN "application/vnd.hal+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.html" 
   RETURN "text/html=" + cFname + cFext
ELSEIF cFile LIKE ".+\.irm" 
   RETURN "application/vnd.ibm.rights-management=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sc" 
   RETURN "application/vnd.ibm.secure-container=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ics" 
   RETURN "text/calendar=" + cFname + cFext
ELSEIF cFile LIKE ".+\.icc" 
   RETURN "application/vnd.iccprofile=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ico" 
   RETURN "image/x-icon=" + cFname + cFext
ELSEIF cFile LIKE ".+\.igl" 
   RETURN "application/vnd.igloader=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ief" 
   RETURN "image/ief=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ivp" 
   RETURN "application/vnd.immervision-ivp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ivu" 
   RETURN "application/vnd.immervision-ivu=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rif" 
   RETURN "application/reginfo+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.3dml" 
   RETURN "text/vnd.in3d.3dml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.spot" 
   RETURN "text/vnd.in3d.spot=" + cFname + cFext
ELSEIF cFile LIKE ".+\.igs" 
   RETURN "model/iges=" + cFname + cFext
ELSEIF cFile LIKE ".+\.i2g" 
   RETURN "application/vnd.intergeo=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cdy" 
   RETURN "application/vnd.cinderella=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xpw" 
   RETURN "application/vnd.intercon.formnet=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fcs" 
   RETURN "application/vnd.isac.fcs=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ipfix" 
   RETURN "application/ipfix=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cer" 
   RETURN "application/pkix-cert=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pki" 
   RETURN "application/pkixcmp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.crl" 
   RETURN "application/pkix-crl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pkipath " 
   RETURN "application/pkix-pkipath=" + cFname + cFext
ELSEIF cFile LIKE ".+\.igm" 
   RETURN "application/vnd.insors.igm=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rcprofile" 
   RETURN "application/vnd.ipunplugged.rcprofile=" + cFname + cFext
ELSEIF cFile LIKE ".+\.irp" 
   RETURN "application/vnd.irepository.package+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.jad" 
   RETURN "text/vnd.sun.j2me.app-descriptor=" + cFname + cFext
ELSEIF cFile LIKE ".+\.jar" 
   RETURN "application/java-archive=" + cFname + cFext
ELSEIF cFile LIKE ".+\.class" 
   RETURN "application/java-vm=" + cFname + cFext
ELSEIF cFile LIKE ".+\.jnlp" 
   RETURN "application/x-java-jnlp-file=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ser" 
   RETURN "application/java-serialized-object=" + cFname + cFext
ELSEIF cFile LIKE ".+\.java" 
   RETURN "text/x-java-source=" + cFname + cFext
ELSEIF cFile LIKE ".+\.js" 
   RETURN "application/javascript=" + cFname + cFext
ELSEIF cFile LIKE ".+\.json" 
   RETURN "application/json=" + cFname + cFext
ELSEIF cFile LIKE ".+\.joda" 
   RETURN "application/vnd.joost.joda-archive=" + cFname + cFext
ELSEIF cFile LIKE ".+\.jpm" 
   RETURN "video/jpm=" + cFname + cFext
ELSEIF cFile LIKE ".+\.jpgv" 
   RETURN "video/jpeg=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ktz" 
   RETURN "application/vnd.kahootz=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mmd" 
   RETURN "application/vnd.chipnuts.karaoke-mmd=" + cFname + cFext
ELSEIF cFile LIKE ".+\.karbon" 
   RETURN "application/vnd.kde.karbon=" + cFname + cFext
ELSEIF cFile LIKE ".+\.chrt" 
   RETURN "application/vnd.kde.kchart=" + cFname + cFext
ELSEIF cFile LIKE ".+\.kfo" 
   RETURN "application/vnd.kde.kformula=" + cFname + cFext
ELSEIF cFile LIKE ".+\.flw" 
   RETURN "application/vnd.kde.kivio=" + cFname + cFext
ELSEIF cFile LIKE ".+\.kon" 
   RETURN "application/vnd.kde.kontour=" + cFname + cFext
ELSEIF cFile LIKE ".+\.kpr" 
   RETURN "application/vnd.kde.kpresenter=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ksp" 
   RETURN "application/vnd.kde.kspread=" + cFname + cFext
ELSEIF cFile LIKE ".+\.kwd" 
   RETURN "application/vnd.kde.kword=" + cFname + cFext
ELSEIF cFile LIKE ".+\.htke" 
   RETURN "application/vnd.kenameaapp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.kia" 
   RETURN "application/vnd.kidspiration=" + cFname + cFext
ELSEIF cFile LIKE ".+\.kne" 
   RETURN "application/vnd.kinar=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sse" 
   RETURN "application/vnd.kodak-descriptor=" + cFname + cFext
ELSEIF cFile LIKE ".+\.lasxml" 
   RETURN "application/vnd.las.las+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.latex" 
   RETURN "application/x-latex=" + cFname + cFext
ELSEIF cFile LIKE ".+\.lbd" 
   RETURN "application/vnd.llamagraphics.life-balance.desktop=" + cFname + cFext
ELSEIF cFile LIKE ".+\.lbe" 
   RETURN "application/vnd.llamagraphics.life-balance.exchange+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.jam" 
   RETURN "application/vnd.jam=" + cFname + cFext
ELSEIF cFile LIKE ".+\.123" 
   RETURN "application/vnd.lotus-1-2-3=" + cFname + cFext
ELSEIF cFile LIKE ".+\.apr" 
   RETURN "application/vnd.lotus-approach=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pre" 
   RETURN "application/vnd.lotus-freelance=" + cFname + cFext
ELSEIF cFile LIKE ".+\.nsf" 
   RETURN "application/vnd.lotus-notes=" + cFname + cFext
ELSEIF cFile LIKE ".+\.org" 
   RETURN "application/vnd.lotus-organizer=" + cFname + cFext
ELSEIF cFile LIKE ".+\.scm" 
   RETURN "application/vnd.lotus-screencam=" + cFname + cFext
ELSEIF cFile LIKE ".+\.lwp" 
   RETURN "application/vnd.lotus-wordpro=" + cFname + cFext
ELSEIF cFile LIKE ".+\.lvp" 
   RETURN "audio/vnd.lucent.voice=" + cFname + cFext
ELSEIF cFile LIKE ".+\.m3u" 
   RETURN "audio/x-mpegurl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.m4v" 
   RETURN "video/x-m4v=" + cFname + cFext
ELSEIF cFile LIKE ".+\.hqx" 
   RETURN "application/mac-binhex40=" + cFname + cFext
ELSEIF cFile LIKE ".+\.portpkg " 
   RETURN "application/vnd.macports.portpkg=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mgp" 
   RETURN "application/vnd.osgeo.mapguide.package=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mrc" 
   RETURN "application/marc=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mrcx" 
   RETURN "application/marcxml+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mxf" 
   RETURN "application/mxf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.nbp" 
   RETURN "application/vnd.wolfram.player=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ma" 
   RETURN "application/mathematica=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mathml" 
   RETURN "application/mathml+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mbox" 
   RETURN "application/mbox=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mc1" 
   RETURN "application/vnd.medcalcdata=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mscml" 
   RETURN "application/mediaservercontrol+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cdkey" 
   RETURN "application/vnd.mediastation.cdkey=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mwf" 
   RETURN "application/vnd.mfer=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mfm" 
   RETURN "application/vnd.mfmp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.msh" 
   RETURN "model/mesh=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mads" 
   RETURN "application/mads+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mets" 
   RETURN "application/mets+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mods" 
   RETURN "application/mods+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.meta4" 
   RETURN "application/metalink4+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.potm" 
   RETURN "application/vnd.ms-powerpoint.template.macroenabled.12=" + cFname + cFext
ELSEIF cFile LIKE ".+\.docm" 
   RETURN "application/vnd.ms-word.document.macroenabled.12=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dotm" 
   RETURN "application/vnd.ms-word.template.macroenabled.12=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mcd" 
   RETURN "application/vnd.mcd=" + cFname + cFext
ELSEIF cFile LIKE ".+\.flo" 
   RETURN "application/vnd.micrografx.flo=" + cFname + cFext
ELSEIF cFile LIKE ".+\.igx" 
   RETURN "application/vnd.micrografx.igx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.es3" 
   RETURN "application/vnd.eszigno3+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mdb" 
   RETURN "application/x-msaccess=" + cFname + cFext
ELSEIF cFile LIKE ".+\.asf" 
   RETURN "video/x-ms-asf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.exe" 
   RETURN "application/x-msdownload=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cil" 
   RETURN "application/vnd.ms-artgalry=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cab" 
   RETURN "application/vnd.ms-cab-compressed=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ims" 
   RETURN "application/vnd.ms-ims=" + cFname + cFext
ELSEIF cFile LIKE ".+\.application" 
   RETURN "application/x-ms-application=" + cFname + cFext
ELSEIF cFile LIKE ".+\.clp" 
   RETURN "application/x-msclip=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mdi" 
   RETURN "image/vnd.ms-modi=" + cFname + cFext
ELSEIF cFile LIKE ".+\.eot" 
   RETURN "application/vnd.ms-fontobject=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xls" 
   RETURN "application/vnd.ms-excel=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xlam" 
   RETURN "application/vnd.ms-excel.addin.macroenabled.12=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xlsb" 
   RETURN "application/vnd.ms-excel.sheet.binary.macroenabled.12=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xltm" 
   RETURN "application/vnd.ms-excel.template.macroenabled.12=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xlsm" 
   RETURN "application/vnd.ms-excel.sheet.macroenabled.12=" + cFname + cFext
ELSEIF cFile LIKE ".+\.chm" 
   RETURN "application/vnd.ms-htmlhelp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.crd" 
   RETURN "application/x-mscardfile=" + cFname + cFext
ELSEIF cFile LIKE ".+\.lrm" 
   RETURN "application/vnd.ms-lrm=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mvb" 
   RETURN "application/x-msmediaview=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mny" 
   RETURN "application/x-msmoney=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pptx" 
   RETURN "application/vnd.openxmlformats-officedocument.presentationml.presentation=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sldx" 
   RETURN "application/vnd.openxmlformats-officedocument.presentationml.slide=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ppsx" 
   RETURN "application/vnd.openxmlformats-officedocument.presentationml.slideshow=" + cFname + cFext
ELSEIF cFile LIKE ".+\.potx" 
   RETURN "application/vnd.openxmlformats-officedocument.presentationml.template=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xlsx" 
   RETURN "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xltx" 
   RETURN "application/vnd.openxmlformats-officedocument.spreadsheetml.template=" + cFname + cFext
ELSEIF cFile LIKE ".+\.docx" 
   RETURN "application/vnd.openxmlformats-officedocument.wordprocessingml.document=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dotx" 
   RETURN "application/vnd.openxmlformats-officedocument.wordprocessingml.template=" + cFname + cFext
ELSEIF cFile LIKE ".+\.obd" 
   RETURN "application/x-msbinder=" + cFname + cFext
ELSEIF cFile LIKE ".+\.thmx" 
   RETURN "application/vnd.ms-officetheme=" + cFname + cFext
ELSEIF cFile LIKE ".+\.onetoc" 
   
   RETURN "application/onenote=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pya" 
   RETURN "audio/vnd.ms-playready.media.pya=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pyv" 
   RETURN "video/vnd.ms-playready.media.pyv=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ppt" 
   RETURN "application/vnd.ms-powerpoint=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ppam" 
   RETURN "application/vnd.ms-powerpoint.addin.macroenabled.12=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sldm" 
   RETURN "application/vnd.ms-powerpoint.slide.macroenabled.12=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pptm" 
   RETURN "application/vnd.ms-powerpoint.presentation.macroenabled.12=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ppsm" 
   RETURN "application/vnd.ms-powerpoint.slideshow.macroenabled.12=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mpp" 
   RETURN "application/vnd.ms-project=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pub" 
   RETURN "application/x-mspublisher=" + cFname + cFext
ELSEIF cFile LIKE ".+\.scd" 
   RETURN "application/x-msschedule=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xap" 
   RETURN "application/x-silverlight-app=" + cFname + cFext
ELSEIF cFile LIKE ".+\.stl" 
   RETURN "application/vnd.ms-pki.stl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.cat" 
   RETURN "application/vnd.ms-pki.seccat=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vsd" 
   RETURN "application/vnd.visio=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wm" 
   RETURN "video/x-ms-wm=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wma" 
   RETURN "audio/x-ms-wma=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wax" 
   RETURN "audio/x-ms-wax=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wmx" 
   RETURN "video/x-ms-wmx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wmd" 
   RETURN "application/x-ms-wmd=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wpl" 
   RETURN "application/vnd.ms-wpl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wmz" 
   RETURN "application/x-ms-wmz=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wmv" 
   RETURN "video/x-ms-wmv=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wvx" 
   RETURN "video/x-ms-wvx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wmf" 
   RETURN "application/x-msmetafile=" + cFname + cFext
ELSEIF cFile LIKE ".+\.trm" 
   RETURN "application/x-msterminal=" + cFname + cFext
ELSEIF cFile LIKE ".+\.doc" 
   RETURN "application/msword=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wri" 
   RETURN "application/x-mswrite=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wps" 
   RETURN "application/vnd.ms-works=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xbap" 
   RETURN "application/x-ms-xbap=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xps" 
   RETURN "application/vnd.ms-xpsdocument=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mid" 
   RETURN "audio/midi=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mpy" 
   RETURN "application/vnd.ibm.minipay=" + cFname + cFext
ELSEIF cFile LIKE ".+\.afp" 
   RETURN "application/vnd.ibm.modcap=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rms" 
   RETURN "application/vnd.jcp.javame.midlet-rms=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tmo" 
   RETURN "application/vnd.tmobile-livetv=" + cFname + cFext
ELSEIF cFile LIKE ".+\.prc" 
   RETURN "application/x-mobipocket-ebook=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mbk" 
   RETURN "application/vnd.mobius.mbk=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dis" 
   RETURN "application/vnd.mobius.dis=" + cFname + cFext
ELSEIF cFile LIKE ".+\.plc" 
   RETURN "application/vnd.mobius.plc=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mqy" 
   RETURN "application/vnd.mobius.mqy=" + cFname + cFext
ELSEIF cFile LIKE ".+\.msl" 
   RETURN "application/vnd.mobius.msl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.txf" 
   RETURN "application/vnd.mobius.txf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.daf" 
   RETURN "application/vnd.mobius.daf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fly" 
   RETURN "text/vnd.fly=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mpc" 
   RETURN "application/vnd.mophun.certificate=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mpn" 
   RETURN "application/vnd.mophun.application=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mj2" 
   RETURN "video/mj2=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mpga" 
   RETURN "audio/mpeg=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mxu" 
   RETURN "video/vnd.mpegurl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mpeg" 
   RETURN "video/mpeg=" + cFname + cFext
ELSEIF cFile LIKE ".+\.m21" 
   RETURN "application/mp21=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mp4a" 
   RETURN "audio/mp4=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mp4" 
   RETURN "video/mp4=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mp4" 
   RETURN "application/mp4=" + cFname + cFext
ELSEIF cFile LIKE ".+\.m3u8" 
   RETURN "application/vnd.apple.mpegurl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mus" 
   RETURN "application/vnd.musician=" + cFname + cFext
ELSEIF cFile LIKE ".+\.msty" 
   RETURN "application/vnd.muvee.style=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mxml" 
   RETURN "application/xv+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ngdat" 
   RETURN "application/vnd.nokia.n-gage.data=" + cFname + cFext
ELSEIF cFile LIKE ".+\.n-gage" 

   RETURN "application/vnd.nokia.n-gage.symbian.install=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ncx" 
   RETURN "application/x-dtbncx+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.nc" 
   RETURN "application/x-netcdf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.nlu" 
   RETURN "application/vnd.neurolanguage.nlu=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dna" 
   RETURN "application/vnd.dna=" + cFname + cFext
ELSEIF cFile LIKE ".+\.nnd" 
   RETURN "application/vnd.noblenet-directory=" + cFname + cFext
ELSEIF cFile LIKE ".+\.nns" 
   RETURN "application/vnd.noblenet-sealer=" + cFname + cFext
ELSEIF cFile LIKE ".+\.nnw" 
   RETURN "application/vnd.noblenet-web=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rpst" 
   RETURN "application/vnd.nokia.radio-preset=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rpss" 
   RETURN "application/vnd.nokia.radio-presets=" + cFname + cFext
ELSEIF cFile LIKE ".+\.n3" 
   RETURN "text/n3=" + cFname + cFext
ELSEIF cFile LIKE ".+\.edm" 
   RETURN "application/vnd.novadigm.edm=" + cFname + cFext
ELSEIF cFile LIKE ".+\.edx" 
   RETURN "application/vnd.novadigm.edx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ext" 
   RETURN "application/vnd.novadigm.ext=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gph" 
   RETURN "application/vnd.flographit=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ecelp4800" 
   RETURN "audio/vnd.nuera.ecelp4800=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ecelp7470" 
   RETURN "audio/vnd.nuera.ecelp7470=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ecelp9600" 
   RETURN "audio/vnd.nuera.ecelp9600=" + cFname + cFext
ELSEIF cFile LIKE ".+\.oda" 
   RETURN "application/oda=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ogx" 
   RETURN "application/ogg=" + cFname + cFext
ELSEIF cFile LIKE ".+\.oga" 
   RETURN "audio/ogg=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ogv" 
   RETURN "video/ogg=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dd2" 
   RETURN "application/vnd.oma.dd2+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.oth" 
   RETURN "application/vnd.oasis.opendocument.text-web=" + cFname + cFext
ELSEIF cFile LIKE ".+\.opf" 
   RETURN "application/oebps-package+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.qbo" 
   RETURN "application/vnd.intu.qbo=" + cFname + cFext
ELSEIF cFile LIKE ".+\.oxt" 
   RETURN "application/vnd.openofficeorg.extension=" + cFname + cFext
ELSEIF cFile LIKE ".+\.osf" 
   RETURN "application/vnd.yamaha.openscoreformat=" + cFname + cFext
ELSEIF cFile LIKE ".+\.weba" 
   RETURN "audio/webm=" + cFname + cFext
ELSEIF cFile LIKE ".+\.webm" 
   RETURN "video/webm=" + cFname + cFext
ELSEIF cFile LIKE ".+\.odc" 
   RETURN "application/vnd.oasis.opendocument.chart=" + cFname + cFext
ELSEIF cFile LIKE ".+\.otc" 
   RETURN "application/vnd.oasis.opendocument.chart-template=" + cFname + cFext
ELSEIF cFile LIKE ".+\.odb" 
   RETURN "application/vnd.oasis.opendocument.database=" + cFname + cFext
ELSEIF cFile LIKE ".+\.odf" 
   RETURN "application/vnd.oasis.opendocument.formula=" + cFname + cFext
ELSEIF cFile LIKE ".+\.odft" 
   RETURN "application/vnd.oasis.opendocument.formula-template=" + cFname + cFext
ELSEIF cFile LIKE ".+\.odg" 
   RETURN "application/vnd.oasis.opendocument.graphics=" + cFname + cFext
ELSEIF cFile LIKE ".+\.otg" 
   RETURN "application/vnd.oasis.opendocument.graphics-template=" + cFname + cFext
ELSEIF cFile LIKE ".+\.odi" 
   RETURN "application/vnd.oasis.opendocument.image=" + cFname + cFext
ELSEIF cFile LIKE ".+\.oti" 
   RETURN "application/vnd.oasis.opendocument.image-template=" + cFname + cFext
ELSEIF cFile LIKE ".+\.odp" 
   RETURN "application/vnd.oasis.opendocument.presentation=" + cFname + cFext
ELSEIF cFile LIKE ".+\.otp" 
   RETURN "application/vnd.oasis.opendocument.presentation-template=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ods" 
   RETURN "application/vnd.oasis.opendocument.spreadsheet=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ots" 
   RETURN "application/vnd.oasis.opendocument.spreadsheet-template=" + cFname + cFext
ELSEIF cFile LIKE ".+\.odt" 
   RETURN "application/vnd.oasis.opendocument.text=" + cFname + cFext
ELSEIF cFile LIKE ".+\.odm" 
   RETURN "application/vnd.oasis.opendocument.text-master=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ott" 
   RETURN "application/vnd.oasis.opendocument.text-template=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ktx" 
   RETURN "image/ktx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sxc" 
   RETURN "application/vnd.sun.xml.calc=" + cFname + cFext
ELSEIF cFile LIKE ".+\.stc" 
   RETURN "application/vnd.sun.xml.calc.template=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sxd" 
   RETURN "application/vnd.sun.xml.draw=" + cFname + cFext
ELSEIF cFile LIKE ".+\.std" 
   RETURN "application/vnd.sun.xml.draw.template=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sxi" 
   RETURN "application/vnd.sun.xml.impress=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sti" 
   RETURN "application/vnd.sun.xml.impress.template=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sxm" 
   RETURN "application/vnd.sun.xml.math=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sxw" 
   RETURN "application/vnd.sun.xml.writer=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sxg" 
   RETURN "application/vnd.sun.xml.writer.global=" + cFname + cFext
ELSEIF cFile LIKE ".+\.stw" 
   RETURN "application/vnd.sun.xml.writer.template=" + cFname + cFext
ELSEIF cFile LIKE ".+\.otf" 
   RETURN "application/x-font-otf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.osfpvg" 
   RETURN "application/vnd.yamaha.openscoreformat.osfpvg+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dp" 
   RETURN "application/vnd.osgi.dp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pdb" 
   RETURN "application/vnd.palm=" + cFname + cFext
ELSEIF cFile LIKE ".+\.p" 
   RETURN "text/x-pascal=" + cFname + cFext
ELSEIF cFile LIKE ".+\.paw" 
   RETURN "application/vnd.pawaafile=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pclxl" 
   RETURN "application/vnd.hp-pclxl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.efif" 
   RETURN "application/vnd.picsel=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pcx" 
   RETURN "image/x-pcx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.psd" 
   RETURN "image/vnd.adobe.photoshop=" + cFname + cFext
ELSEIF cFile LIKE ".+\.prf" 
   RETURN "application/pics-rules=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pic" 
   RETURN "image/x-pict=" + cFname + cFext
ELSEIF cFile LIKE ".+\.chat" 
   RETURN "application/x-chat=" + cFname + cFext
ELSEIF cFile LIKE ".+\.p10" 
   RETURN "application/pkcs10=" + cFname + cFext
ELSEIF cFile LIKE ".+\.p12" 
   RETURN "application/x-pkcs12=" + cFname + cFext
ELSEIF cFile LIKE ".+\.p7m" 
   RETURN "application/pkcs7-mime=" + cFname + cFext
ELSEIF cFile LIKE ".+\.p7s" 
   RETURN "application/pkcs7-signature=" + cFname + cFext
ELSEIF cFile LIKE ".+\.p7r" 
   RETURN "application/x-pkcs7-certreqresp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.p7b" 
   RETURN "application/x-pkcs7-certificates=" + cFname + cFext
ELSEIF cFile LIKE ".+\.p8" 
   RETURN "application/pkcs8=" + cFname + cFext
ELSEIF cFile LIKE ".+\.plf" 
   RETURN "application/vnd.pocketlearn=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pnm" 
   RETURN "image/x-portable-anymap=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pbm" 
   RETURN "image/x-portable-bitmap=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pcf" 
   RETURN "application/x-font-pcf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pfr" 
   RETURN "application/font-tdpfr=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pgn" 
   RETURN "application/x-chess-pgn=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pgm" 
   RETURN "image/x-portable-graymap=" + cFname + cFext
ELSEIF cFile LIKE ".+\.png" 
   RETURN "image/png=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ppm" 
   RETURN "image/x-portable-pixmap=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pskcxml" 
   RETURN "application/pskc+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pml" 
   RETURN "application/vnd.ctc-posml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ai" 
   RETURN "application/postscript=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pfa" 
   RETURN "application/x-font-type1=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pbd" 
   RETURN "application/vnd.powerbuilder6=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pgp" 
   RETURN "application/pgp-signature=" + cFname + cFext
ELSEIF cFile LIKE ".+\.box" 
   RETURN "application/vnd.previewsystems.box=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ptid" 
   RETURN "application/vnd.pvi.ptid1=" + cFname + cFext
ELSEIF cFile LIKE ".+\.pls" 
   RETURN "application/pls+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.str" 
   RETURN "application/vnd.pg.format=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ei6" 
   RETURN "application/vnd.pg.osasli=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dsc" 
   RETURN "text/prs.lines.tag=" + cFname + cFext
ELSEIF cFile LIKE ".+\.psf" 
   RETURN "application/x-font-linux-psf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.qps" 
   RETURN "application/vnd.publishare-delta-tree=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wg" 
   RETURN "application/vnd.pmi.widget=" + cFname + cFext
ELSEIF cFile LIKE ".+\.qxd" 
   RETURN "application/vnd.quark.quarkxpress=" + cFname + cFext
ELSEIF cFile LIKE ".+\.esf" 
   RETURN "application/vnd.epson.esf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.msf" 
   RETURN "application/vnd.epson.msf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ssf" 
   RETURN "application/vnd.epson.ssf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.qam" 
   RETURN "application/vnd.epson.quickanime=" + cFname + cFext
ELSEIF cFile LIKE ".+\.qfx" 
   RETURN "application/vnd.intu.qfx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.qt" 
   RETURN "video/quicktime=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rar" 
   RETURN "application/x-rar-compressed=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ram" 
   RETURN "audio/x-pn-realaudio=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rmp" 
   RETURN "audio/x-pn-realaudio-plugin=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rsd" 
   RETURN "application/rsd+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rm" 
   RETURN "application/vnd.rn-realmedia=" + cFname + cFext
ELSEIF cFile LIKE ".+\.bed" 
   RETURN "application/vnd.realvnc.bed=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mxl" 
   RETURN "application/vnd.recordare.musicxml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.musicxml" 
   RETURN "application/vnd.recordare.musicxml+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rnc" 
   RETURN "application/relax-ng-compact-syntax=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rdz" 
   RETURN "application/vnd.data-vision.rdz=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rdf" 
   RETURN "application/rdf+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rp9" 
   RETURN "application/vnd.cloanto.rp9=" + cFname + cFext
ELSEIF cFile LIKE ".+\.jisp" 
   RETURN "application/vnd.jisp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rtf" 
   RETURN "application/rtf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rtx" 
   RETURN "text/richtext=" + cFname + cFext
ELSEIF cFile LIKE ".+\.link66" 
   RETURN "application/vnd.route66.link66+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rss" 
   RETURN "application/rss+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.shf" 
   RETURN "application/shf+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.st" 
   RETURN "application/vnd.sailingtracker.track=" + cFname + cFext
ELSEIF cFile LIKE ".+\.svg" 
   RETURN "image/svg+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sus" 
   RETURN "application/vnd.sus-calendar=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sru" 
   RETURN "application/sru+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.setpay" 
   RETURN "application/set-payment-initiation=" + cFname + cFext
ELSEIF cFile LIKE ".+\.setreg" 
   RETURN "application/set-registration-initiation=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sema" 
   RETURN "application/vnd.sema=" + cFname + cFext
ELSEIF cFile LIKE ".+\.semd" 
   RETURN "application/vnd.semd=" + cFname + cFext
ELSEIF cFile LIKE ".+\.semf" 
   RETURN "application/vnd.semf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.see" 
   RETURN "application/vnd.seemail=" + cFname + cFext
ELSEIF cFile LIKE ".+\.snf" 
   RETURN "application/x-font-snf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.spq" 
   RETURN "application/scvp-vp-request=" + cFname + cFext
ELSEIF cFile LIKE ".+\.spp" 
   RETURN "application/scvp-vp-response=" + cFname + cFext
ELSEIF cFile LIKE ".+\.scq" 
   RETURN "application/scvp-cv-request=" + cFname + cFext
ELSEIF cFile LIKE ".+\.scs" 
   RETURN "application/scvp-cv-response=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sdp" 
   RETURN "application/sdp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.etx" 
   RETURN "text/x-setext=" + cFname + cFext
ELSEIF cFile LIKE ".+\.movie" 
   RETURN "video/x-sgi-movie=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ifm" 
   RETURN "application/vnd.shana.informed.formdata=" + cFname + cFext
ELSEIF cFile LIKE ".+\.itp" 
   RETURN "application/vnd.shana.informed.formtemplate=" + cFname + cFext
ELSEIF cFile LIKE ".+\.iif" 
   RETURN "application/vnd.shana.informed.interchange=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ipk" 
   RETURN "application/vnd.shana.informed.package=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tfi" 
   RETURN "application/thraud+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.shar" 
   RETURN "application/x-shar=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rgb" 
   RETURN "image/x-rgb=" + cFname + cFext
ELSEIF cFile LIKE ".+\.slt" 
   RETURN "application/vnd.epson.salt=" + cFname + cFext
ELSEIF cFile LIKE ".+\.aso" 
   RETURN "application/vnd.accpac.simply.aso=" + cFname + cFext
ELSEIF cFile LIKE ".+\.imp" 
   RETURN "application/vnd.accpac.simply.imp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.twd" 
   RETURN "application/vnd.simtech-mindmapper=" + cFname + cFext
ELSEIF cFile LIKE ".+\.csp" 
   RETURN "application/vnd.commonspace=" + cFname + cFext
ELSEIF cFile LIKE ".+\.saf" 
   RETURN "application/vnd.yamaha.smaf-audio=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mmf" 
   RETURN "application/vnd.smaf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.spf" 
   RETURN "application/vnd.yamaha.smaf-phrase=" + cFname + cFext
ELSEIF cFile LIKE ".+\.teacher" 
   RETURN "application/vnd.smart.teacher=" + cFname + cFext
ELSEIF cFile LIKE ".+\.svd" 
   RETURN "application/vnd.svd=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rq" 
   RETURN "application/sparql-query=" + cFname + cFext
ELSEIF cFile LIKE ".+\.srx" 
   RETURN "application/sparql-results+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.gram" 
   RETURN "application/srgs=" + cFname + cFext
ELSEIF cFile LIKE ".+\.grxml" 
   RETURN "application/srgs+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ssml" 
   RETURN "application/ssml+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.skp" 
   RETURN "application/vnd.koan=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sgml" 
   RETURN "text/sgml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sdc" 
   RETURN "application/vnd.stardivision.calc=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sda" 
   RETURN "application/vnd.stardivision.draw=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sdd" 
   RETURN "application/vnd.stardivision.impress=" + cFname + cFext
ELSEIF cFile LIKE ".+\.smf" 
   RETURN "application/vnd.stardivision.math=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sdw" 
   RETURN "application/vnd.stardivision.writer=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sgl" 
   RETURN "application/vnd.stardivision.writer-global=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sm" 
   RETURN "application/vnd.stepmania.stepchart=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sit" 
   RETURN "application/x-stuffit=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sitx" 
   RETURN "application/x-stuffitx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sdkm" 
   RETURN "application/vnd.solent.sdkm+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xo" 
   RETURN "application/vnd.olpc-sugar=" + cFname + cFext
ELSEIF cFile LIKE ".+\.au" 
   RETURN "audio/basic=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wqd" 
   RETURN "application/vnd.wqd=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sis" 
   RETURN "application/vnd.symbian.install=" + cFname + cFext
ELSEIF cFile LIKE ".+\.smi" 
   RETURN "application/smil+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xsm" 
   RETURN "application/vnd.syncml+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.bdm" 
   RETURN "application/vnd.syncml.dm+wbxml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xdm" 
   RETURN "application/vnd.syncml.dm+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sv4cpio" 
   RETURN "application/x-sv4cpio=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sv4crc" 
   RETURN "application/x-sv4crc=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sbml" 
   RETURN "application/sbml+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tsv" 
   RETURN "text/tab-separated-values=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tiff" 
   RETURN "image/tiff=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tao" 
   RETURN "application/vnd.tao.intent-module-archive=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tar" 
   RETURN "application/x-tar=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tcl" 
   RETURN "application/x-tcl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tex" 
   RETURN "application/x-tex=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tfm" 
   RETURN "application/x-tex-tfm=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tei" 
   RETURN "application/tei+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.txt" 
   RETURN "text/plain=" + cFname + cFext
ELSEIF cFile LIKE ".+\.dxp" 
   RETURN "application/vnd.spotfire.dxp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.sfs" 
   RETURN "application/vnd.spotfire.sfs=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tsd" 
   RETURN "application/timestamped-data=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tpt" 
   RETURN "application/vnd.trid.tpt=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mxs" 
   RETURN "application/vnd.triscape.mxs=" + cFname + cFext
ELSEIF cFile LIKE ".+\.t" 
   RETURN "text/troff=" + cFname + cFext
ELSEIF cFile LIKE ".+\.tra" 
   RETURN "application/vnd.trueapp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ttf" 
   RETURN "application/x-font-ttf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ttl" 
   RETURN "text/turtle=" + cFname + cFext
ELSEIF cFile LIKE ".+\.umj" 
   RETURN "application/vnd.umajin=" + cFname + cFext
ELSEIF cFile LIKE ".+\.uoml" 
   RETURN "application/vnd.uoml+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.unityweb" 
   RETURN "application/vnd.unity=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ufd" 
   RETURN "application/vnd.ufdl=" + cFname + cFext
ELSEIF cFile LIKE ".+\.uri" 
   RETURN "text/uri-list=" + cFname + cFext
ELSEIF cFile LIKE ".+\.utz" 
   RETURN "application/vnd.uiq.theme=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ustar" 
   RETURN "application/x-ustar=" + cFname + cFext
ELSEIF cFile LIKE ".+\.uu" 
   RETURN "text/x-uuencode=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vcs" 
   RETURN "text/x-vcalendar=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vcf" 
   RETURN "text/x-vcard=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vcd" 
   RETURN "application/x-cdlink=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vsf" 
   RETURN "application/vnd.vsf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wrl" 
   RETURN "model/vrml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vcx" 
   RETURN "application/vnd.vcx=" + cFname + cFext
ELSEIF cFile LIKE ".+\.mts" 
   RETURN "model/vnd.mts=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vtu" 
   RETURN "model/vnd.vtu=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vis" 
   RETURN "application/vnd.visionary=" + cFname + cFext
ELSEIF cFile LIKE ".+\.viv" 
   RETURN "video/vnd.vivo=" + cFname + cFext
ELSEIF cFile LIKE ".+\.ccxml" 
   RETURN "application/ccxml+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.vxml" 
   RETURN "application/voicexml+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.src" 
   RETURN "application/x-wais-source=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wbxml" 
   RETURN "application/vnd.wap.wbxml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wbmp" 
   RETURN "image/vnd.wap.wbmp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wav" 
   RETURN "audio/x-wav=" + cFname + cFext
ELSEIF cFile LIKE ".+\.davmount" 
   RETURN "application/davmount+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.woff" 
   RETURN "application/x-font-woff=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wspolicy" 
   RETURN "application/wspolicy+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.webp" 
   RETURN "image/webp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wtb" 
   RETURN "application/vnd.webturbo=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wgt" 
   RETURN "application/widget=" + cFname + cFext
ELSEIF cFile LIKE ".+\.hlp" 
   RETURN "application/winhlp=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wml" 
   RETURN "text/vnd.wap.wml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wmls" 
   RETURN "text/vnd.wap.wmlscript=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wmlsc" 
   RETURN "application/vnd.wap.wmlscriptc=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wpd" 
   RETURN "application/vnd.wordperfect=" + cFname + cFext
ELSEIF cFile LIKE ".+\.stf" 
   RETURN "application/vnd.wt.stf=" + cFname + cFext
ELSEIF cFile LIKE ".+\.wsdl" 
   RETURN "application/wsdl+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xbm" 
   RETURN "image/x-xbitmap=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xpm" 
   RETURN "image/x-xpixmap=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xwd" 
   RETURN "image/x-xwindowdump=" + cFname + cFext
ELSEIF cFile LIKE ".+\.der" 
   RETURN "application/x-x509-ca-cert=" + cFname + cFext
ELSEIF cFile LIKE ".+\.fig" 
   RETURN "application/x-xfig=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xhtml" 
   RETURN "application/xhtml+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xml" 
   RETURN "application/xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xdf" 
   RETURN "application/xcap-diff+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xenc" 
   RETURN "application/xenc+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xer" 
   RETURN "application/patch-ops-error+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rl" 
   RETURN "application/resource-lists+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rs" 
   RETURN "application/rls-services+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.rld" 
   RETURN "application/resource-lists-diff+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xslt" 
   RETURN "application/xslt+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xop" 
   RETURN "application/xop+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xpi" 
   RETURN "application/x-xpinstall=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xspf" 
   RETURN "application/xspf+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xul" 
   RETURN "application/vnd.mozilla.xul+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.xyz" 
   RETURN "chemical/x-xyz=" + cFname + cFext
ELSEIF cFile LIKE ".+\.yang" 
   RETURN "application/yang=" + cFname + cFext
ELSEIF cFile LIKE ".+\.yin" 
   RETURN "application/yin+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.zir" 
   RETURN "application/vnd.zul=" + cFname + cFext
ELSEIF cFile LIKE ".+\.zip" 
   RETURN "application/zip=" + cFname + cFext
ELSEIF cFile LIKE ".+\.zmm" 
   RETURN "application/vnd.handheld-entertainment+xml=" + cFname + cFext
ELSEIF cFile LIKE ".+\.zaz" 
   RETURN "application/vnd.zzazz.deck+xml=" + cFname + cFext
   ENDIF

RETURN "text/plain;filename=" + cFname + cFext

*******************************************************************************
***************************************************************************************************************
FUNCTION CONFIG_MAIL()  
local _tex:='۲  KONFIGURACJA POCZTY ELEKTRONICZNEJ  ',;
      _thaslo, _thaslo_powt:=space(30) ,_nhaslo:=0

cls
@ 0,0 say _tex
BEGIN SEQUENCE

sele 0
_use("CONFIG_MAIL","E!")
_nhaslo:=NHASLO

@  2,0 say "Serwer poczty wychodzcej SMTP: "

@  3,0 say "Nazwa serwera:       " get SERW_SMTP 
@  4,0 say "Port:                " get PORT_SMTP pict "9999" 
@  5,0 say "Adres e-mail nadawcy:" get ADRES_MAIL

@  7,0 say "Serwer POP/IMAP: "

@  8,0 say "Nazwa serwera:       " get SERW_POP   
@  9,0 say "Nazwa uytkownika:   " get USER_POP

set curs on; read; set curs off

@ 11,0 say "Dlugo hasa:" get _nhaslo pict "99"

set curs on; read; set curs off
/*
if empty(CRYPT(left(HASLO_POP,_nhaslo),"ZSIWI"))
  _thaslo:=space(_nhaslo)   
else  
  _thaslo:= crypt(left(HASLO_POP,_nhaslo),"ZSIWI")
endif
*/

_thaslo:=repl("*",_nhaslo)

//_thaslo:=CRYPT(left(HASLO_POP,_nhaslo),"ZSIWI")

@ 12,0 say "Haso:               " get _thaslo  PASSWORD    pict  "@K "+repl("X",_nhaslo)         
@ 13,0 say "Powtrz haso:       " get _thaslo_powt PASSWORD  pict "@K "+repl("X",_nhaslo) 
set curs on; read; set curs off

//altd()



if empty(_thaslo) .or.empty(_thaslo_powt) .or. (!_thaslo==_thaslo_powt)
   ALERT("Bd hasa. Konieczna powtrna konfiguracja!")
   repl HASLO_POP with CRYPT(space(_nhaslo),"ZSIWI")
else
  // _thaslo:=alltrim(_thaslo)
   repl HASLO_POP with CRYPT(_thaslo,"ZSIWI") ,;
        NHASLO with _nhaslo
endif   

END SEQUENCE
close CONFIG_MAIL
RETURN NIL

*******************************************************************************
FUNCTION MAIL_TXT(tBody,aTo)
   
// 2 linijki tekstu dolaczane do e-maila z faktura
local getlist:={}
local tlinia1:=space(60),tlinia2:=space(60)
local oColor
LOCAL nT := 19, nL := 0, nB := 23, nR := 59
local nw
local _tadres:=padr(aTo[1],40)

nw:=WOPEN(nT,nL,nB,nR)
oColor:=SET(_SET_COLOR)  //,"N/W,N/G")
WSelect(nw)
@ 1,1 say "Adres e-mail:" get _tadres
@ 2,1 say "Tre e-mail:"      
@ 3,1 get tlinia1
@ 4,1 get tlinia2
set cursor on; read; set cursor off

tBody:=alltrim(tlinia1)+if(!empty(tlinia2),CRLF+alltrim(tlinia2),"")
tBody:=hb_strtoutf8(tBody,"PL852")

aTo:={}
aadd(aTo,alltrim(_tadres) )

WClose()
WSelect(0)
SET(_SET_COLOR,oColor)
RETURN NIL

************************************************************************************************************************************************************************************************
FUNCTION MAIL()
local _tex:= '۲  WYSANIE POCZTY ELEKTRONICZNEJ  '

cls
@ 0,0 say _tex

BEGIN SEQUENCE   

_tmail:=alltrim(_mail_se)

sele 0
_use("CONFIG_MAIL","R!")
cServer:=alltrim(SERW_SMTP)
    nPort:=PORT_SMTP
    cFrom:=alltrim(ADRES_MAIL)
    aTo:={_tmail}   
    cBody:="Rezerwacja firan"
    cSubject:="Rezerwacja : "+dtoc(date())+" "+time()
    aFiles:={"MAIL.TXT"}
    cUser:=alltrim(USER_POP)
    cPass:=CRYPT(left(HASLO_POP,NHASLO),"ZSIWI")
    cPopServer:=alltrim(SERW_POP)  
close CONFIG_MAIL

if empty(cfrom) .or. empty(cUser) .or. empty(cPass) .or. empty(cPopServer)
  QKE("Konieczna konfiguracja poczty elektronicznej w opcji KONFIGURACJA BIECA!")
  BREAK
endi 
   
MAIL_TXT(@cBody,@aTo)
   
if empty(aTo)
  tone(440,.5)
  QK("Brak adresu kontrahenta!")
  BREAK
endi   
if HB_SendMail( cServer, , cFrom, aTo, , , cBody, cSubject, aFiles, cUser, cPass, cPopServer, , ,,,,)
   tone(880,1)
   QK("Wysano e-mail",4)
endi

END SEQUENCE

RETURN NIL

*******************************************************************************
FUNCTION LAT_WIN(_s)
local _n,_i

static a852:=;
      {165,134,169,136,228,162,152,171,190,164,143,168,157,227,224,151,141,189}
static awin:=;
      {185,230,234,179,241,243,156,159,191,165,198,202,163,209,211,140,143,175}

for _i:=1 to len(_s)
  _n:=ascan(a852,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(awin[_n]))
  endi
next
RETURN _s

*******************************************************************************
FUNCTION LAT_ISO(_s)
local _n,_i
static a852:=;
      {165,134,169,136,228,162,152,171,190,164,143,168,157,227,224,151,141,189}
static aiso:=;
      {177,230,234,179,241,243,182,188,191,161,198,202,163,209,211,166,172,175}

for _i:=1 to len(_s)
  _n:=ascan(a852,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(aiso[_n]))
  endi
next
RETURN _s

*******************************************************************************

