#include "comped.ch"
#include "inkey.ch"
#include "setcurs.ch"
#include "fileio.ch"              
#include "directry.ch"
#include "pscript.ch"

#xtranslate FTell(<fHandle>) => FSeek(<fHandle>, 0, FS_RELATIVE)
#xtranslate :fileHandle   => :cargo\[1\]
#xtranslate :fileLine     => :cargo\[2\]
#xtranslate :lineOffset   => :cargo\[3\]

#define FILE_BRWS_NUM_IVARS 3
static max_line_len:=0,_k_tab:=.f.
static _data_beg:=NIL, _data_end:=NIL

******************************  do przeleww  *********************************
#define  PICA       ( chr(18) + chr(27) + chr(80) )  
#define  ELITE      ( chr(18) + chr(27) + chr(77) )  
#define  PICA_COND  ( chr(15) + chr(27) + chr(80) )  
#define  ELITE_COND ( chr(15) + chr(27) + chr(77) )  
#define  KOD_RESET  ( chr(27) + chr(64) )

#define  PICA_I       ( chr(18) )  
#define  ELITE_I      ( chr(27) + chr(58) )
#define  PICA_COND_I  ( chr(18) + chr(15) )    
#define  ELITE_COND_I ( chr(27) + chr(58) + chr(15) )

#define  PICA_HP       (  chr(27) + chr(40) + chr(115) + "10.0" + chr(72) )
*                          chr(27) + chr(40) + "s4102T" )  
#define  PICA_COND_HP  chr(27) + chr(40) + chr(115) + "17" + chr(72)
#define  ELITE_COND_HP  ( ;
                          chr(27) + chr(40) + "s20H" )

*                          chr(27) + chr(40) + "s4102T" )  

#define  ELITE_HP          ( ;
                          chr(27) + chr(40) + "s12H" )
*                          chr(27) + chr(40) + "s4102T" )  

#define ENLARGE_ON  chr(27)+"W1"   // ESC/P + IBM
#define ENLARGE_OFF chr(27)+"W0"

#define DRAFT chr(27)+"x0"
#define DRAFT_HP chr(27)+"(s1Q"

#define CR    Chr(13)
#define LF    Chr(10)
#define CRLF  CR + LF

*******************************************************************************
FUNCTION UZG_WER()                                                
local _ret:=.f., _astru:={},_uzg:=.f.

tone(200,1) 
QPC(1," Prosz czeka. Aktualizacja wersji programu ... ")

BEGIN SEQUENCE

inkey(5)

sele 0
_use("CONFIG","R!")
public _format_ind:= alltrim(FORMAT_IND)

sele 0
_use("STATUS","R!")
_uzg:=(fieldpos("DATA_LIC")=0.or.len(DATA_LIC)<6)
CPClose(STATUS)
if _uzg
  _astru:={}
  aadd(_astru,{"DATA_LIC  ","C",6,0})
  dbcreate(_sc+"STATUS",_astru)
  _use(_sc+"STATUS","E!")
  appe from STATUS
  copy to STATUS
  CPClose(STATUS)
  dele file (_sc+"STATUS.DBF")
endi

if !file("SL_SEK.DBF")                                               //10.09.14
  _astru:={}
  aadd(_astru,{"SEKTOR    ","C",5,0})
  aadd(_astru,{"OPIS_SEK  ","C",40,0})
  dbcreate("SL_SEK",_astru)
  _use ("SL_SEK","E!")
  inde on SEKTOR to SL_SEK
  use
endi

if file("NZAM.DBF")                                                  //16.09.18
  if !_use("NZAM","R"); BREAK; endi 
  @ 23,0 say padr("Sprawdzanie struktury pliku NZAM",79)
  _uzg:=(len(PACZKI)<40)
  if _uzg
    copy stru extended to XSTRUP
    _use("XSTRUP","E!")
    loca for Field_name="PACZKI"
    repl Field_len with 40
    create ("XSTRUN") from XSTRUP
    _use("XSTRUN","E!")
    set dele off
    appe from NZAM
    copy to NZAM
    set dele on
    use
    dele file ("XSTRUP.DBF")
    dele file ("XSTRUN.DBF")
  endif
  CPClose(NZAM)
endi

if !_use("TOW","R"); BREAK; endi                                     //16.04.14
@ 23,0 say padr("Sprawdzanie struktury pliku TOW",79)
_uzg:=(len(SEKTOR)<5)
if _uzg
  copy stru extended to XSTRUP
  _use("XSTRUP","E!")
  loca for Field_name="SEKTOR"
  repl Field_len with 5
  create ("XSTRUN") from XSTRUP
  _use("XSTRUN","E!")
  set dele off
  appe from TOW
  repl all SEKTOR with subs(SEKTOR,1,1)+" -"+subs(SEKTOR,2)
  copy to TOW
  set dele on
  use
  dele file ("XSTRUP.DBF")
  dele file ("XSTRUN.DBF")
endif
CPClose(TOW)


if file("PZAM.DBF")                                                  //16.04.14
  if !_use("PZAM","R"); BREAK; endi                            
  @ 23,0 say padr("Sprawdzanie struktury pliku PZAM",79)
  _uzg:=(len(SEKTOR)<5)
  if _uzg
    copy stru extended to XSTRUP
    _use("XSTRUP","E!")
    loca for Field_name="SEKTOR"
    repl Field_len with 5
    create ("XSTRUN") from XSTRUP
    _use("XSTRUN","E!")
    set dele off
    appe from PZAM
    repl all SEKTOR with subs(SEKTOR,1,1)+" -"+subs(SEKTOR,2)
    copy to PZAM
    set dele on
    use
    dele file ("XSTRUP.DBF")
    dele file ("XSTRUN.DBF")
  endif
  CPClose(PZAM)
endi

if !_use("TOW","R"); BREAK; endi                                     //14.09.14
@ 23,0 say padr("Sprawdzanie struktury pliku TOW",79)
_uzg:=(fieldpos("FIRANA")=0)
if _uzg
  copy stru extended to XSTRUP
  _use("XSTRUP","E!")
  appe blan
  repl Field_name with "FIRANA",;
       Field_type with "C",;
       Field_len with 1,;
       Field_dec with 0
  create ("XSTRUN") from XSTRUP
  _use("XSTRUN","E!")
  set dele off
  appe from TOW
  copy to TOW
  set dele on
  use
  dele file ("XSTRUP.DBF")
  dele file ("XSTRUN.DBF")
endif
CPClose(TOW)

if _use("STATUS","F").and.fieldpos("DATA_LIC")>0
  repl DATA_LIC with _d_lic
  CPClose(STATUS)
  _ret:=.T.
endi

END SEQUENCE
clos data
@ 23,0                                                               //16.09.18

QPC(0," Prosz czeka. Aktualizacja wersji programu ... ")

if HorizMenu(24,0,"Wykona sortowanie kartotek ?",{"TAK","NIE"},1)=1
  cls

  sele 0
  _use("CONFIG","R!")
  _wersja:= CONFIG->WERSJA
  use
  
  INDEX()
endi

RETURN _ret

*******************************************************************************
FUNCTION ZAOKR(x,m)
local cstr,nStr,znak:=1
local nRound
if .f. //m=2
  if x<0; znak:=-1; x:=-x; endi
  cstr:=str(x,15,4)
  if subs(cstr,14,1)>="5"
    x+=0.005
  endi
  nround:=val(str(x,15,2))
  if znak=-1; nround:=-nround; endi
elseif m>=0 
  nRound:=round(x,m)
  nStr:=val(str(x,15,m))
  RETU if(x<0,min(nStr,nRound),max(nStr,nRound))
end
RETURN nRound

*******************************************************************************
FUNCTION SKOCZ()
RETURN if(KEY(chr(24)+chr(13)),0,0)

*******************************************************************************
FUNCTION MAZ_LAT(_s)
local _n,_i

static amaz:=;
      {134,141,145,146,164,162,158,166,167,143,149,144,156,165,163,152,160,161}
static a852:=;
      {165,134,169,136,228,162,152,171,190,164,143,168,157,227,224,151,141,189}

if upper(chr(169))=chr(168)      // program w LATIN
  RETURN _s              
endi

for _i:=1 to len(_s)
  _n:=ascan(amaz,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(a852[_n]))
  endi
next
RETURN _s    

*******************************************************************************
FUNCTION LAT_MAZ(_s)
local _n,_i
static amaz:=;
      {134,141,145,146,164,162,158,166,167,143,149,144,156,165,163,152,160,161}
static a852:=;
      {165,134,169,136,228,162,152,171,190,164,143,168,157,227,224,151,141,189}
for _i:=1 to len(_s)
  _n:=ascan(a852,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(amaz[_n]))
  endi
next
RETURN _s    

*******************************************************************************
FUNCTION ARCH()
local _tex:= '۲  ARCHIWIZACJA DANYCH  ',;
      _erc1:=.f.,_erc2:=.f.,_erc3:=.f.,_w:=1,_cmd1,_cmd2,_cmd3
local _scl:= _kartoteka+"#"+numer_stan

cls
@ 0,0 say _tex

if !_use("CONFIG","R!")
  QKE("Nie wykonano archiwizacji !")
  RETURN NIL
endi
if fieldpos("ARCH_1")=0.or.empty(ARCH_1)
  QKE("Bd konfiguracji. Nie wykonano archiwizacji !")
  RETURN NIL
endi
_cmd1:=alltrim(ARCH_1)
_cmd2:=alltrim(ARCH_2)
_cmd3:=alltrim(ARCH_3)
use

cls
/*                                                                        //xHB
_erc1:=!SWPRUNCMD(_cmd1,0,"",_scl)
if !empty(_cmd2)
  _erc2:=!SWPRUNCMD(_cmd2,0,"",_scl)
endi
if !empty(_cmd3)
  _erc3:=!SWPRUNCMD(_cmd3,0,"",_scl)
endi
*/

_erc1:=.f.
_erc2:=.f.
_erc3:=.f.
RUN(_cmd1)
if !empty(_cmd2)
  RUN(_cmd2)
endi
if !empty(_cmd3)
  RUN(_cmd3)
endi

if _erc1.or._erc2.or._erc3
  cls
  QKE("Bd operacji systemowej. Nie wykonano archiwizacji !")
else
  TONE(880,8)
  @ 24,0
  devpos(24,0)
  wait "Nacinij dowolny klawisz ..."
endi
cls
RETURN NIL

*******************************************************************************
FUNCTION FOX()
local _erc:=.f.,_scl:=_kartoteka+"#"+numer_stan

cls
? "Powrt do programu podstawowego poleceniem QUIT."
wait "Nacinij dowolny klawisz ..."
cls
set cursor on
RUN fox.exe

set cursor off
cls
TONE(880,8)
@ 24,0
devpos(24,0)
wait "Nacinij dowolny klawisz ..."
cls
RETURN NIL

*******************************************************************************
FUNCTION FOX32()
local _erc:=.f.,_scl:=_kartoteka+"#"+numer_stan

cls
? "Powrt do programu podstawowego poleceniem QUIT."
wait "Nacinij dowolny klawisz ..."
cls
set cursor on
RUN FOX32.EXE

set cursor off
cls
TONE(880,8)
@ 24,0
devpos(24,0)
wait "Nacinij dowolny klawisz ..."
cls
RETURN NIL

*******************************************************************************
FUNCTION FReadLn(fHandle, cBuffer, nMaxLine)

LOCAL cLine, nEol, nNumRead, nSavePos

  cLine   := Space(nMaxLine)
  cBuffer := ""

  // Save current file position for later seek
  nSavePos := FTell(fHandle)

  nNumRead := FRead(fHandle, @cLine, nMaxLine)

  IF (nEol := At(CRLF, SubStr(cLine, 1, nNumRead))) == 0
    cBuffer := cLine                     // Line overflow or eof
  ELSE
    cBuffer := SubStr(cLine, 1, nEol - 1)  // Copy up to eol

    // Now position file to next line (skip lf) ...
    FSeek(fHandle, nSavePos + nEol + 1, FS_SET)

  ENDIF

RETURN nNumRead != 0        // If last read didn't suceed, eof

*******************************************************************************
FUNCTION INDEX_MENU(wer,_sc,_scl)

sele 0
_use ("MENU","E!")
#ifdef POSNET
 wer:="POSNET"
#endi
#ifdef FP600
 wer:="FP600"
#endi

if DIR_EXIST(_scl)
  inde on OPCJA to (_sc+"MENU") for PRIORYTET<=_priorytet;
                   .and.(empty(UWAGI).or.wer$UWAGI)
else
  inde on OPCJA to MENU for PRIORYTET<=_priorytet;
                   .and.(empty(UWAGI).or.wer$UWAGI)
endi

clos MENU
RETURN NIL

*******************************************************************************
FUNCTION DAJ_REKXY()                                         // akcja do SLRX()
local _lk:=lastkey(),_osele:=select()

BEGIN SEQUENCE
_zaz:=aclone(_zaznaczone)
if lastkey()=K_CTRL_RET.or.lastkey()=K_ENTER
  _ktory_rekord:=recn()
  keyboard chr(K_ESC)+chr(K_DOWN)
endi

END SEQUENCE
sele (_osele)
RETU NIL

*******************************************************************************
FUNCTION MAZ_STD(_s)
local _n,_i
static amaz:=;
      {134,141,145,146,164,162,158,166,167,143,149,144,156,165,163,152,160,161}
static astd:=;
      { 97, 99,101,108,110,111,115,122,122, 65, 67, 69, 76, 78, 79, 83, 90, 90}
for _i:=1 to len(_s)
  _n:=ascan(amaz,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(astd[_n]))
  endi
next
RETURN _s    

*******************************************************************************
FUNCTION LAT_STD(_s)
local _n,_i
static a852:=;
      {165,134,169,136,228,162,152,171,190,164,143,168,157,227,224,151,141,189}
static astd:=;
      { 97, 99,101,108,110,111,115,122,122, 65, 67, 69, 76, 78, 79, 83, 90, 90}
for _i:=1 to len(_s)
  _n:=ascan(a852,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(astd[_n]))
  endi
next
RETURN _s    

*******************************************************************************
FUNCTION PL(_t,_pl)
if upper(chr(145))=chr(144) //900
  RETURN if(_pl="L",MAZ_LAT(_t),if(_pl="S",MAZ_STD(_t),_t))
elseif upper(chr(169))=chr(168) //852
  RETURN if(_pl="M",LAT_MAZ(_t),if(_pl="S",LAT_STD(_t),_t))
endi
RETURN _t

*******************************************************************************
/*
ESC/P :
#define CON_E1 chr(15)                 // condensed
#define CON_E0 chr(18)                 // cancel condensed
#define PICA_E chr(18)+chr(27)+chr(80) // pica (cancel condensed, cancel elite)
#define ELIT_E chr(18)+chr(27)+chr(77) // elite (cancel condensed, set elite)
#define PICC_E chr(18)+chr(27)+chr(80)+chr(15)  // pica condensed
#define ELIC_E chr(18)+chr(27)+chr(77)+chr(15)  // elite condensed
#define RESE_E chr(27)+chr(64)          // reset
#define CAE_E1 chr(27)+chr(73)+chr(49)  // cod area expansion
#define CAE_E0 chr(27)+chr(73)+chr(48)
#define ITA_E1 chr(27)+chr(52)          // italic
#define ITA_E0 chr(27)+chr(53)
#define UND_E1 chr(27)+chr(45)+chr(49)  // underlining
#define UND_E0 chr(27)+chr(45)+chr(48)
#define DET_E1 chr(27)+chr(57)          // detektor papieru
#define DET_E0 chr(27)+chr(56) 
#define DOU_E1 chr(27)+chr(71)          // double strike
#define DOU_E0 chr(27)+chr(72)
#define HEI_E1 chr(27)+chr(119)+chr(49) // double height     
#define HEI_E0 chr(27)+chr(119)+chr(48)
#define WID_E1 chr(27)+chr(87)+chr(49)  // double width (expanded)
#define WID_E0 chr(27)+chr(87)+chr(48)
#define EMP_E1 chr(27)+chr(69)          // emphasized 
#define EMP_E0 chr(27)+chr(70) 
#define L216_E chr(27)+chr(51)+chr(n)   // line spacing n/216 cal 

IBM :
#define RESE_I chr(27)+chr(64)          // reset
#define CON_I1 chr(15)                  // condensed
#define CON_I0 chr(18)                  // cancel condensed
#define PICA_I chr(18)                  // pica (cancel condensed)
#define ELIT_I chr(27)+chr(58)          // elite
#define PICC_I chr(18)+chr(15)         // pica condensed
#define ELIC_I chr(27)+chr(58)+chr(15) // elite condensed

#define DET_I1 chr(27)+chr(57)          // detektor papieru
#define DET_I0 chr(27)+chr(56) 
#define DOU_I1 chr(27)+chr(71)          // double strike
#define DOU_I0 chr(27)+chr(72)
#define HEI_I1 chr(27)+chr(119)+chr(49) // double height     
#define HEI_I0 chr(27)+chr(119)+chr(48)
#define WID_I1 chr(27)+chr(87)+chr(49)  // double width (expanded)
#define WID_I0 chr(27)+chr(87)+chr(48)
#define EMP_I1 chr(27)+chr(69)          // emphasized 
#define EMP_I0 chr(27)+chr(70) 
#define L216_I chr(27)+chr(51)+chr(n)   // line spacing n/216 cal 

HPPCL :
#define RESE_H chr(27)+"E"              // reset
#define ORIP_H chr(27)+"&l0O"          // portret
#define ORIL_H chr(27)+"&l1O"          // landscape
#define COUR_H chr(27)+"(s3T"          // curier
#define SPAF_H chr(27)+"(s0P"          // spacing fixed
#define SPAP_H chr(27)+"(s1P"          // spacing proportional
#define PICA_H chr(27)+"(s10.0H"                  // pica
#define ELIA_H chr(27)+"(s12H"+chr(27)+"(s4102T"  // elite
#define PICC_H chr(27)+"(s16.67H"                // pica condensed
#define ELCC_H chr(27)+"(s20H"+chr(27)+"(s4102T" // elite condensed
#define ITA_H1 chr(27)+"(s1S"          // italic
#define ITA_H0 chr(27)+"(s0S"
#define DOU_H1 chr(27)+"(s3B"          // double strike (bold)
#define DOU_H0 chr(27)+"(s0B" 
#define HEI_H1 chr(27)+"(s24V"         // double height ?
#define HEI_H0 chr(27)+"(s12V"
#define WID_H1 chr(27)+"(s5.0H"        // double width pica    
#define WID_H0 chr(27)+"(s10.0H"
#define EMP_H1 chr(27)+"(s3B"          // emphasized (bold)
#define EMP_H0 chr(27)+"(s0B"  
*/
*******************************************************************************
FUNCTION WPLAT_RAP(_d,_s)                   // dla kompatybilnosci z V_COMP.PRG
RETURN .T.

*******************************************************************************
FUNCTION INFO_LOG(_opis,_alia)
local _sele:=select()

DEFAULT _opis TO "",;
        _alia TO alias()

BEGIN SEQUENCE

if _priorytet>=10.or.!file("INFO_L_O.NTX"); BREAK; endi

sele 0
if !_use("INFO_LOG","S"); BREAK; endi
set index to INFO_L_T,INFO_L_O
APPE_BLOK()
repl DATA with date(),;
     CZAS with time(),;
     STANOWISKO  with numer_stan,;
     OPERATOR  with _operator,;
     OPIS with _opis
if !empty(_alia).and.(_alia)->(fieldpos("INDEKS"))>0
  repl INDEKS with (_alia)->INDEKS
endi
if !empty(_alia).and.(_alia)->(fieldpos("NR_MAG"))>0
  repl MAGAZYN with (_alia)->NR_MAG
endi
if !empty(_alia).and.(_alia)->(fieldpos("NR_KON"))>0
  repl FIRMA with (_alia)->NR_KON
endi
close INFO_LOG

END SEQUENCE

sele (_sele)
RETURN .t.

*******************************************************************************
FUNCTION TB_PLIK(_pp)
loca _ocolo:=SET(_SET_COLOR,_ekra_blo),_w:=row(),_k:=col(),;
     _ocurs:=setcursor()
max_line_len:=275

@ 24,0 say "ALT_F - wyszukiwanie tekstu, ALT_R - kontynuacja"
FileBrowse(_pp,2,,23)
@ 24,0
* tb27(_pp,2)
SET(_SET_COLOR,_ocolo)
devpos(_w,_k)
setcursor(_ocurs)
RETURN NIL

*******************************************************************************
FUNCTION S_I(_i)                                    //zamienia indeks na string
retu transform(_i,_format_ind)

*******************************************************************************
FUNCTION S_C(_i)                                       //zamienia cen na string
retu transform(_i,_format_cen)

*******************************************************************************
FUNCTION S_W(_i)                                   //zamienia wartosc na string
retu transform(_i,_format_war)

*******************************************************************************
FUNCTION S_S(_i)                                     //zamienia ilosc na string
retu transform(_i,_format_ilo)

*******************************************************************************
FUNCTION EXE1()                                                           //xHB
RETURN NIL

*******************************************************************************
FUNCTION EXE2()                                                           //xHB
RETURN NIL
*******************************************************************************
FUNCTION DAJ_PLI(_kat,_opi)                                
local _astru:={},_r:=NIL,_sel:=sele(),_color:=set(_SET_COLOR),_apli:={},_lin,;
      _pli:=""

BEGIN SEQUENCE

for _i:=1 to 50
  _lin:=MEMOLINE(_opi,76,_i)
  if subs(_lin,1,1)=="#".and.".PDF"$_lin
    _pli:=alltrim(subs(_lin,2,at(".PDF",_lin)+3))
    if file(_kat+_pli)
      aadd(_apli,_pli)
    endi
  endi
next

if len(_apli)=0
  QK("Brak plikw !")
  BREAK
endif

_astru:={}
aadd(_astru,{"NAZWA",  "C", 40,0}) 
aadd(_astru,{"DATA",   "D", 8,0})
aadd(_astru,{"CZAS",   "C", 8,0})
aadd(_astru,{"ROZMIAR","N", 8,0})
dbcreate(_sc+"PLIKI",_astru)

sele 0
_use(_sc+"PLIKI","E!")
inde on NAZWA to (_sc+"PLIKI_N")
inde on dtos(DATA)+CZAS to (_sc+"PLIKI_D")
set inde to  (_sc+"PLIKI_N"), (_sc+"PLIKI_D")


for _i:=1 to len(_apli)
  _pli:=DIRECTORY(_kat+_apli[_i])
  if len(_pli)>0
    PLIKI->(dbappend())
    PLIKI->NAZWA   :=_pli[1][F_NAME]
    PLIKI->DATA    :=_pli[1][F_DATE]
    PLIKI->CZAS    :=_pli[1][F_TIME]
    PLIKI->ROZMIAR :=_pli[1][F_SIZE]
  endi
next

go top
CPEDIT  POZ: 1,15,23,            ;                           
        DEF: "PLIKI"             ;
        POZWER: "V4"             ;                           
        RAMKA: R_GRUBA           ;
        PION: ,,,                ;
        INDEXY: {"nazwa","data"} ;
        EDYCJA: .f.              ;
        ODTWORZ:.t.              ;
        AKCJA: _r:=DAJ_PLIK()

if _r<>NIL
  _r:=alltrim(_r)
else
  _r:=""
endif

END SEQUENCE
CPClose(PLIKI)

sele (_sel)
dele file  (_sc+"PLIKI.DBF")
dele file  (_sc+"PLIKI_N.NTX")
dele file  (_sc+"PLIKI_D.NTX")
set(_SET_COLOR,_color)

RETURN _r

*******************************************************************************
FUNCTION K_OFF()
local getlist:={}, _a:=" "
keyboard(chr(K_PGDN))
@ 24,0 get _a pict "X"
set curs on; read; set curs off
keyboard(chr(K_PGUP))

RETURN NIL

*******************************************************************************
FUNCTION ROK(_data)
RETURN subs(dtos(_data),1,4)

*******************************************************************************
FUNCTION KART_OK()
if !DIR_EXIST(alltrim(KARTOTEKA)+"#"+subs(_sc,-3,2)) 
  TONE(220,5)
  If QTN("Na dysku nie ma kartoteki "+;
         alltrim(KARTOTEKA)+"#"+subs(_sc,-3,2)+" ! WYJCIE Z PROGRAMU ?")
    close data
    dele file (_sc+"FLAGA") 
    QUIT
  else
    RETU .f.
  endif
else
  RETU .t.
endif
RETURN NIL

******************************************************************************
FUNCTION SZER(tx)
local i,ret:=""
if _szer
  for i:=1 to len(tx)
    ret:=ret+subs(tx,i,1)+" "
  next
else
  ret:=tx
endif
RETU ret

*******************************************************************************
FUNCTION HASLO(_nr)
local _sel:=select(),_has:=_haslo,_err:=.f.

if subs(_wersja,49,1)=="H".and.!file("HASLA.DBF"); RETURN .F.; endi

BEGIN SEQUENCE
  
if !file("HASLA.DBF"); BREAK; endi

sele 0
_use("HASLA","R!")
dbgoto(_nr)
if subs(_wersja,49,1)=="H".and.;
       (empty(HASLO).or.HASLO==CRYPT("      ","ZSIWI "))
   _err:=.t.; BREAK
endi
if empty(HASLO).or.HASLO==CRYPT("      ","ZSIWI "); BREAK; endi

if subs(_wersja,49,1)=="H"
  _has:=CRYPT(HASLO,"ZSIWI ")
endi

END SEQUENCE
CPClose(HASLA)

sele(_sel)
if _err
  QKE("Hasa specjalne niezdefiniowane lub niedozwolona manipulacja hasami !")
  RETURN .F.
endi

RETURN HA(_has)

*******************************************************************************
FUNCTION RAP_ERR(_opis,_procedura,_linia)
local _sel:=select()

DEFAULT _opis TO "",;
        _procedura TO "",;
        _linia TO 0

BEGIN SEQUENCE

if file("ERR_LOG.DBF")

  sele 0
  if !_use("ERR_LOG","E"); BREAK; endi
  APPE_BLOK()
  repl DATA with date(),;
       CZAS with time(),;
       STA  with numer_stan,;
       OPE  with _operator,;
       OPIS with _opis,;
       PROCEDURA with _procedura,;
       LINIA with _linia 
  close ERR_LOG
endi

END SEQUENCE

sele (_sel)
RETURN NIL
*******************************************************************************
FUNCTION DiskError()
QKE("Bd napdu. Powtrz operacj.")
set colo to _ekra_blo
BREAK
RETURN NIL

*******************************************************************************
FUNCTION DS(_d)
RETURN if(empty(_d),spac(8),dtoc(_d))

*******************************************************************************
FUNCTION KAS_WIST()                       //dla kompatybilnoci z V_EDIT.PRG MV
RETURN NIL

*******************************************************************************
FUNCTION TEST_WEJ()                           // z MEGAVAT           //14.09.17
local _fer,_t1,_t2
*------------------------ badanie czy ktos inny wszedl z tym samym parametrem

if !file(_sc+"FLAGA")
  desk:=fcreate(_sc+"FLAGA")
  fclose(desk)
  if !file(_sc+"FLAGA")
    QKE("Nieudana prba inicjacji katalogu roboczego !")
    QUIT
  endi
  desk:=fopen(_sc+"FLAGA",2+32) // FO_READWRITE+FO_DENYWRITE
  if (_fer:=ferror())<>0
    QKE(t1:="Nieudane otwarcie pliku rejestracji uytkownika.",;
        t2:="Blad DOS numer "+str(_fer,2))
    RAP_ERR(t1+" "+t2,PROCNAME(0),PROCLINE(0))
    dele file (_sc+"FLAGA")
    QUIT
  endi
  fwrite(desk,_operator+" "+dtoc(date())+" "+subs(time(),1,5))
  if (_fer:=ferror())<>0         // nie mozna zapisa
    fclose(desk)
    QKE(t1:="Nieudana rejestracja uytkownika.",;
        t2:="Blad DOS numer "+str(_fer,2))
    RAP_ERR(t1+" "+t2,PROCNAME(0),PROCLINE(0))
    dele file (_sc+"FLAGA")
    QUIT
  endi
else
  desk:=fopen(_sc+"FLAGA",2+16)    // FO_READWRITE+FO_EXCLUSIVE
  if (_fer:=ferror())<>0           // nie mozna ekskluzywnie
    desk:=fopen(_sc+"FLAGA",0+64)  // FO_READ+FO_SHARED
    if (_fer:=ferror())<>0         // nie mozna do odczytu
      QKE(t1:="Katalog roboczy "+numer_stan+" zajety."+;
          " Nieudane otwarcie pliku rejestracji.",;
          t2:="Blad DOS numer "+str(_fer,2))
      RAP_ERR(t1+" "+t2,PROCNAME(0),PROCLINE(0))
      QUIT
    endi
    _komunikat:=space(18)
    fread(desk,@_komunikat,18)   // proba odczytu
    if (_fer:=ferror())<>0
      QKE(t1:="Katalog roboczy "+numer_stan+" zajety."+;
          " Nieudany odczyt pliku rejestracji.",;
          t2:="Blad DOS numer "+str(_fer,2))
    else
      QKE(t1:="Katalog roboczy "+numer_stan+" zajety.",;
          t2:="Operator : "+_komunikat)
    endi
    RAP_ERR(t1+" "+t2,PROCNAME(0),PROCLINE(0))
    QUIT
  else
    fclose(desk)
    desk:=fopen(_sc+"FLAGA",2+32) // FO_READWRITE+FO_DENYWRITE
    if (_fer:=ferror())<>0
      QKE(t1:="Nieudane otwarcie pliku rejestracji uytkownika.",;
          t2:="Blad DOS numer "+str(_fer,2))
      RAP_ERR(t1+" "+t2,PROCNAME(0),PROCLINE(0))
      dele file (_sc+"FLAGA")
      QUIT
    endi
    fwrite(desk,_operator+" "+dtoc(date())+" "+subs(time(),1,5))
    if (_fer:=ferror())<>0         // nie mozna zapisa
      fclose(desk)
      QKE(t1:="Nieudana rejestracja uytkownika.",;
          t2:="Blad DOS numer "+str(_fer,2))
      RAP_ERR(t1+" "+t2,PROCNAME(0),PROCLINE(0))
      dele file (_sc+"FLAGA")
      QUIT
    endi
  endi
endi
*------------------------------------------------------------------------------
RETU NIL

*******************************************************************************
FUNCTION RET2()
cls
QKE("Opcja w opracowaniu")
RETURN NIL

*******************************************************************************
FUNCTION USTAW()                                                     //03.07.99
loca _tex:='۲  USTALANIE PARAMETRW KONFIGURACYJNYCH PROGRAMU ',;
     _err:=.t.,_lp:=0,_stary,_znak:=" "

cls
@ 0,0 say _tex

BEGIN SEQUENCE

if !_use("CONFIG","E"); BREAK; endi

@ 1,0 say "Numer parametru : " get _lp pict "@Z 99"
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi
_stary:=padr(subs(WERSJA,_lp,1),1)

@ 2,0 say "Aktualna warto : "+_stary
@ 3,0 say "Nowa warto :    " get _znak pict "@! X"
set curs on; read; set curs off
if lastkey()=K_ESC.or.!HA(_haslo); BREAK; endi

if fieldsize(fieldnum("WERSJA"))<_lp
  copy stru extended to XSTRUP
  _use("XSTRUP","E!")
  locate for rtrim(Field_name)=="WERSJA"
  repl  Field_len with _lp
  use
  create ("XSTRUN") from XSTRUP
  _use("XSTRUN","E!")
  appe from CONFIG
  copy to CONFIG
  use
  dele file ("XSTRUP.DBF")
  dele file ("XSTRUN.DBF")
  if !_use("CONFIG","E"); _err:=.t.;BREAK; endi
endif

if _znak<>_stary
  if _lp=1
    repl WERSJA with _znak+subs(WERSJA,2)
  else
    repl WERSJA with subs(WERSJA,1,_lp-1)+_znak+subs(WERSJA,_lp+1)
  endi

  sele 0
  if _use("STATUS","F")
    repl DATA_LIC with ""
    use
  endi

  _err:=.f.
  tone(440,1)
else
  _err:=.t.
endi

END SEQUENCE
clos data
if _err
  QKE("Nie zmieniono parametru konfiguracyjnego programu !")
else 
  QKE("Zmieniono parametr konfiguracyjny programu.",;
      "        Uruchom program ponownie !         ")
  fclose(desk)                                                       //14.09.17
  dele file (_sc+"FLAGA")
  QUIT
endi
RETURN NIL

*******************************************************************************
FUNCTION ep(rr)                                                             //!
RETURN str(year(ctod("01.01."+rr)),4) 

*******************************************************************************
FUNCTION USTAW_DRUK()                                                 
loca _tex:='۲  USTAWIANIE GLOBALNYCH PARAMETRW WYDRUKW  ',;
     _tryb:=space(5),_konw1:=space(3),_konw2:=space(3),_kody:=space(30),;
     _port:=space(4),_err:=.t.,_konw:=space(6),_rr:=space(30)

cls
@ 0,0 say _tex

BEGIN SEQUENCE

do while _err

   @ 2,0 say "Tryb drukarki:  " get _tryb  pict "@! XXXXX";
                                vali _tryb$"ESC/P|IBM  |HPPCL"
   @ 3,0 say "Port drukarki:  " get _port pict "@! AAA9";
                vali subs(_port,1,3)=="LPT".and.subs(_port,4,1)$"123456789"
   @ 4,0 say "Konwersja:      " get _konw1 pict "@!"
                @ 4,21 say "->" get _konw2 pict "@!"
   @ 5,0 say "Kody sterujce: " get _kody pict "@!"
   set curs on; read; set curs off
   if lastkey()=K_ESC; BREAK; endi

   _rr:=alltrim(_kody)

   if ((_konw1=="   ".and._konw2=="   ").or.;
      ((_konw1=="MAZ".or._konw1=="LAT").and.;
      (_konw2=="MAZ".or._konw2=="LAT".or._konw2=="STD".or._konw2=="   ").and.;
      _konw1<>_konw2)).and.;
      charrem("01234567890/,",_rr)=="".and.subs(_rr,1,1)<>",".and.;
      subs(_rr,-1)<>",".and.subs(_rr,1,1)<>"/".and.subs(_rr,-1)<>"/"

       _err:=.f.
       _konw:=_konw1+_konw2
       _use(_sc+"PARADRUK","E!")
       repl all TRYB with _tryb,;
                PORT with _port,;
                KONWERSJA with _konw,;
                KODY with _kody
       close data
   else
      QKE ("PODANO BDNE PARAMETRY !")
   endi
endd

END SEQUENCE
RETURN .T.

*******************************************************************************
FUNCTION GRUPA_OK(x,maxgru,_agru)
// Uwaga ! _agru musi by przekazywana przez referencj 
// np. GRUPA_OK(_nr_g_kon,_maxgr,@akon) patrz R.Spence Clipper 5.2 str. 148
local _ret:=.t., s1:="",s2:="", _tn:="",i,j,k,_grmax,_maxpom

_maxpom:=if(maxgru>99,999,99)

s1:=CHARREM(" ",x)
s2:=CHARONLY(",-0123456789",x)
_agru:={}
BEGIN SEQUENCE
  if ! s1==s2; _ret:=.f.; BREAK; endif   // niedopuszczalne znaki

  TOKENINIT(@s1,",")
  i:=1
  do while !TOKENEND()
    _tn:=TOKENNEXT(s1)
    _nat:=NUMAT("-",_tn)

    if _nat=1 .and. len(_tn)=1         //  tylko "-"
      for i:=1 to maxgru
        aadd(_agru,i)
      next
    elseif _nat=1 .and. left(_tn,1)="-"    //  "-" jako pierwszy znak
      if (_grmax:= val(subs(_tn,2)))>_maxpom
        _ret:=.f.; BREAK
      endif
      for i:=1 to _grmax
        aadd(_agru,i)
      next      
    elseif _nat=1 .and. right(_tn,1)="-"    // "-" jako ostatni znak
      j:=val(left(_tn,len(_tn)-1)) 
      for i:=j to maxgru    
        if ascan(_agru,i)=0;   aadd(_agru,i); endi
      next      
    elseif _nat=1             // "-" nie jako ostatni znak i nie ostatni
      _nn:=at("-",_tn)
      j:=val(left(_tn,_nn-1)) 
      if (k:=val(subs(_tn,_nn+1)))>_maxpom
        _ret:=.f.; BREAK
      endif
      for i:=j to k   
        if ascan(_agru,i)=0;   aadd(_agru,i); endi
      next      
    elseif _nat>1
      _ret:=.f.; BREAK
    elseif _nat=0
      if (i:=val(_tn)) > _maxpom
        _ret:=.f.; BREAK
      endif
      if ascan(_agru,i)=0;   aadd(_agru,i); endi
    else
    endif 
  enddo

END SEQUENCE

if _ret=.f.
  tone(220,5)
  QKE(;
 "Bdna selekcja !  Naley zostawi puste pole lub wpisa grupy i przedziay",;
 "grup oddzielone przecinkami. Przykady: 7  2,3-5  1,2,6. Maksym. grupa : "+;
  str(maxgru,2))
  _agru:={}
endif
RETURN _ret 

*******************************************************************************
FUNCTION FWriteLn( nHandle, cString, nLength, cDelim )  //#23.10

   IF cDelim == NIL
      cString += CRLF
   ELSE
      cString += cDelim
   ENDIF

   RETURN ( FWRITE( nHandle, cString, nLength ) )
*******************************************************************************
/*

 /****************************************************************************
*  Browse Function By: Tom Claffy  March 1993
*  Search Routine  By: Phil Barnett  April 3, 1993
*  Minor Repair of DownFillArray By: Phil Barnett  April 5, 1993
*  Added Highlight to Search By: Tom Claffy  April 10, 1993
*  Added minor comments and fixed anomalous display on small files
*                                Tom Claffy  May 25, 1993
*  Added MAXBROWSELENGTH to avoid lockup on binary files: TC 7-26-1993
*  Fixed Ctrl-PgUp and Ctrl-PgDn problems with small files: TC 9-15-93
*  Added optional code block to modify text as it is extracted TC 9-23-93
*  LineDisp Function By: Todd C. MacDonald 9-28-1993 with minor
*      modification by Tom Claffy
*
*  Placed in Public Domain July 29, 1993 by Tom Claffy
*
*  Pure Clipper Text File Browser
*
*  with...
*
*      Virtual Reads  (view any size file with low memory overhead)
*      Relative Position Indicator
*      Panning
*      User-defineable Color Blocks
*      Search and Repeat Search
*      Handles all Video Screen sizes (looks nice in 40*132)
*      100% Clipper
*
*      Compile Clipper 5.x -n
****************************************************************************/
/***************************************************************************
* This is the default maximum line length
***************************************************************************/
#define MAXBROWSELENGTH 256

/***************************************************************************
* These defines are used by the LineDisp function to define the
* elements of the display color as written by Todd C. MacDonald.
****************************************************************************/
#define CODE_LEN    3
#define COLOR_CODE  1
#define COLOR_SET   2
#define COLOR_DELIM '~~'

/****************************************************************************
* Syntax          FileBrowse( <cFileName> , [<nTop>] , [<nLeft>] ,
*                     [<nBottom>] , [<nRight>] , [<cWinColor>] ,
*                     [<cBoxColor>] , [<cBarColor>] , [<cButtonColor>] ,
*                     [<bApplyText>] , [<aDispColors>] )
*
* Arguments       <cFileName> DOS file to browse. Provide your own
*                     error trapping prior to calling FileBrowse().
*                     This function assumes a valid, readable file.
*                 <nTop>, <nLeft>, <nBottom> , <nRight> browse window
*                     coordinates; If not specified, defaults to 0,0,
*                     MaxRow(),MaxCol()
*                 <cWinColor> , <cBoxColor> , <cBarColor>, <cButtonColor>
*                     Clipper color strings; If not specified, defaults to
*                     SetColor() , Setcolor() , "W/N" , "N/W" respectively.
*                 <bApplyText>  An optional code block which will be
*                     applied to each line of text as it is extracted
*                     from the file allowing control codes, etc. to be
*                     removed prior to display
*                 <aDispColors> An optional array of codes and Clipper color
*                     strings to affect the display colors. Each element of
*                     the array contains { cCode , cColorString }. Each
*                     cCode used must begin with a common delimiter and
*                     contain a unique identifier. Example:
*                      { { '~~WR' , 'W+/R' } , { ~~BW , 'B/W' } } where
*                     ~~ is the common delimiter and WR or BW is the
*                     unique identifier portion of each cCode.
*                     Imbed the cCode in the text file to display the text
*                     in the corresponding color. Each color change is
*                     only applicable to the end fo the  current line or
*                     another cCode is encountered; subsequent lines revert
*                     to the default cWinColor. If not specified, all
*                     output will be in the cWinColor.
* Returns         NIL
*
* Description     Pure Clipper text file browser
*
* Calls           NONE
*
* Notes           Beats the pants off of the similar tBrowse implementation
****************************************************************************/

Function FileBrowse(cFileName,nTop,nLeft,nBottom,nRight,cWinColor,;
                    cBoxColor,cBarColor,cButtonColor,bApplyText,aDispColors)
// the browse variables
LOCAL aLines
LOCAL aWinbuff := {savescreen(),setcolor(cWinColor),row(),col(),setcursor(0)}
LOCAL lApplyBlock := (bApplyText # NIL .and. VALTYPE(bApplyText) == "B")
LOCAL lHitBottom := .f.
LOCAL nCurrentLeft := 1
LOCAL nHandle := Fopen( cFileName , 0 )
LOCAL nKey := 0
LOCAL nLastOffSet := 0
LOCAL nLastLine
LOCAL nLeftBrowse := 1
LOCAL nLengthBrowse
LOCAL nMaxRight := 0
LOCAL nSize := Fseek( nHandle , 0 , 2 )
// for the ScrollBar
LOCAL nRow
LOCAL nBarTop
LOCAL nBarBottom
// for the search function
LOCAL cLookText := ''
LOCAL nHighLiteLine := 0
LOCAL nHighLiteOffSet := 0
LOCAL nLastFind
LOCAL nLooklen := 0
LOCAL nTotalFound := 0
// move back to the top of the file
Fseek(nHandle,0)
// set the defaults
DEFAULT nTop TO 0
DEFAULT nLeft TO 0
DEFAULT nBottom TO maxrow()
DEFAULT nRight TO maxcol()
DEFAULT cWinColor TO SetColor()
DEFAULT cBoxColor TO SetColor()
DEFAULT cBarColor TO 'W/N'
DEFAULT cButtonColor TO  'N/W'
// Set other vars; NOTE: if you change the window look at these carefully
nRow = nTop+1
nBarTop = nTop+1
nBarBottom = nBottom-1
nLastLine = nBottom - nTop - 1
nLengthBrowse = (nRight - nLeft - 2 )
// declare and fill the array
aLines = Array( nLastLine )
aFill( aLines , {'',0,0} )
DownFillArray(nHandle,aLines,1,nLastLine,lApplyBlock,bApplyText)
// paint the screen
//DispBegin()
Scroll(nTop,nLeft,nBottom,nRight)
Dispbox(nTop,nLeft,nBottom,nRight,,cBoxColor)
ScrollBar(.t.,aLines[1,2],nLastOffSet,nSize,nLastLine,;
          nBarTop,nRight,nBarBottom,@nRow,cBarColor,cButtonColor)
//DispEnd()
While .t.
   // reset default values
   nMaxRight := nLastOffSet := 0
   // display the screen
   //DispBegin()
   LineDisp(aLines,nTop,nLeft,nLeftBrowse,nLengthBrowse,;
            @nMaxRight,@nLastOffset,aDispColors,nLastLine,cWinColor)
   If nHighLiteLine # 0  // highlight the search text
      nHighLiteLine = Highlight(cLookText,nHighLiteOffSet-nLeftBrowse+1,;
                      nTop+nHighLiteLine,nLeft+1)
   Endif
   ScrollBar(.f.,aLines[1,2],nLastOffSet,nSize,nLastLine,nBarTop,nRight,;
         nBarBottom,@nRow,cBarColor,cButtonColor) // update the scroll bar
   //DispEnd()
   Clear TypeaHead // I like this thing to stop when I stop pressing a key
   do case
   case (nKey := inkey(0)) == K_ESC
      Exit
   case nKey == K_DOWN
      SkipDown(nHandle,aLines,nLastLIne,1,nSize,lApplyBlock,bApplyText)
   case nKey == K_UP
      SkipUp(nHandle,aLines,lApplyBlock,bApplytext)
   case nKey == K_PGUP
      If !UpFillArray(nHandle,aLines,nLastLine,nSize,lApplyBlock,bApplyText)
         Fseek( nHandle , 0 )
         aFill( aLines , {'',0,0} )
         DownFillArray(nHandle,aLines,1,nLastLine,lApplyBlock,bApplyText)
      Endif
   case nKey == K_PGDN
      SkipDown(nHandle,aLines,nLastLine,nLastLine,nSize,;
               lApplyBlock,bApplyText)
   case nKey == K_LEFT .and. nLeftBrowse > 1
      nLeftBrowse --
   case nKey == K_RIGHT .and. nLeftBrowse < ( nMaxRight - nLengthBrowse )
      nLeftBrowse ++
   case nKey == K_HOME .and. nLeftBrowse > 1
      nLeftBrowse = 1
   case nKey == K_END .and. nLeftBrowse < ( nMaxRight - nLengthBrowse )
      nLeftBrowse = ( nMaxRight - nLengthBrowse )
   case nKey == K_CTRL_PGUP //.and. aLines[1,2] # 0
      Fseek( nHandle , 0 )
      DownFillArray(nHandle,aLines,1,nLastLine,lApplyBlock,bApplyText)
   case nKey == K_CTRL_PGDN
      aLines[1,2] = Fseek( nHandle , 0 , 2 )
      If !UpFillArray(nHandle,aLines,nLastLine,nSize,lApplyBlock,bApplyText)
         Fseek( nHandle , 0 )
         aFill( aLines , {'',0,0} )
         DownFillArray(nHandle,aLines,1,nLastLine,lApplyBlock,bApplyText)
      Endif
   case nKey == K_TAB .and. nLeftBrowse < ( nMaxRight - nLengthBrowse )
      nLeftBrowse = MIN(nLeftBrowse+nLengthBrowse,nLeftBrowse+5)
   case nKey == K_SH_TAB .and. nLeftBrowse > 1
      nLeftBrowse = MAX(0,nLeftBrowse-5)
   case nKey == K_ALT_F .or. nKey == K_ALT_R
      If (nLastOffSet := search(nHandle,If(nKey==K_ALT_F,1,2),;
            @nLastFind,@cLookText,@nLooklen,@nHighLiteOffSet,;
                                     nBottom,@nTotalFound) ) > 0
         DownFillArray(nHandle,aLines,1,nLastLine,@lHitBottom,;
                       lApplyBlock,bApplyText)
         If lHitBottom .or. aScan(aLines,{|x|!Empty(x[1])}) = 0
            // we hit bottom or no text in any line
            aFill( aLines , {'',0,0} )
            aLines[1,2] = Fseek( nHandle , 0 , 2 )
            If !UpFillArray(nHandle,aLines,nLastLine,nSize,;
                            lApplyBlock,bApplyText)
               Fseek( nHandle , 0 )
               aFill( aLines , {'',0,0} )
               // this is not really as redundant as it may first appear
               DownFillArray(nHandle,aLines,1,nLastLine,;
                             lApplyBlock,bApplyText)
            Endif
         Endif
         nHighLiteLine = CheckDisp(cLookText,aLines,nLastOffSet,;
                                 nHighLiteOffSet,@nLeftBrowse,nLengthBrowse)
      Endif
   case SetKey( nKey ) # NIL
      Eval( SetKey( nKey), ProcName(), ProcLine(), ReadVar() )
   Endcase
End
fClose( nHandle )
SetColor( aWinbuff[2]) // next 4 lines are my screen restore stuff
*RestScreen(0,0,maxrow(),maxcol(),aWinbuff[1])
SetPos(aWinbuff[3],aWinbuff[4])
SetCursor(aWinbuff[5])
RETURN NIL

/****************************************************************************
* Displays the lines of text contained in the array
****************************************************************************/

STATIC Function LineDisp(aLines,nTop,nLeft,nLeftBrowse,nLengthBrowse,;
                        nMaxRight,nLastOffset,aDispColors,nLastLine,;
                        cWinColor)
// The LOCAL vars for Todd's part of this function
LOCAL cColorCode
LOCAL cColorSet
LOCAL cLine
LOCAL cOutPut
LOCAL nColorCode
LOCAL nCodePos
LOCAL nDiff
LOCAL nKey
LOCAL nLength
LOCAL nLine
LOCAL nLinePos

nLeft ++ // this needs to be incremented for both display methods
If aDispColors = NIL // no colors defined so use the standard display method
   Aeval(aLines,{ |x,y|DevPos(nTop+y,nLeft),;
                       DevOut(Pad(Substr(x[1],nLeftBrowse),nLengthBrowse)),;
                       nMaxRight   := Max(nMaxRight,Len(x[1])),;
                       nLastOffSet := Max(nLastOffSet,x[3])})
Else
  /*************************************************************************
  * This is an original work by Todd C. MacDonald and is hereby
  * placed in the public domain.
  *
  * The framework for this portion of the LineDisp function was
  * graciously provided by Todd C. MacDonald. It is included here with
  * modifications to use the established variables and conventions in
  * FileBrowse - Tom Claffy 9-28-93
  **************************************************************************/

  nTop ++
  FOR nLine = 1 TO nLastLine
     setpos( nTop++, nLeft )
     cLine = aLines[ nLine , 1 ]
     nLinePos = 1
     cColorSet = cWinColor
     nLength = LEN( cLine )
     WHILE (COLOR_DELIM $ cLine)
       nCodePos = at( COLOR_DELIM , cLine )
       cOutPut = Left( cLine , nCodePos - 1 )
       // strip the beginning of the line if we are panned right
       // this must be done as a color code may be in this part
       // of the line so we must process the characters but cannot
       // display any characters until we reach the first virtual column
       // of the display window
       If nLinePos < nLeftBrowse
          nDiff = MIN( LEN( cOutPut ) , nLeftBrowse - nLinePos )
          nLinePos += nDiff
          cOutPut = Substr( cOutPut , nDiff + 1 )
       Endif
       // output line up to code position in current color
       devout( cOutPut , cColorSet )
       // strip off text just displayed
       cLine =  substr( cLine, nCodePos )
       // Set new color based on color code.  If the color code
       // is not found in the array, the code is not stripped out
       // (therefore the code itself gets displayed in the output
       // text).  If the code is found but the color value is nil,
       // the color is set to the default.
       cColorCode = left( cLine, CODE_LEN )
       IF ( nColorCode := ascan( aDispColors, ;
          { | a | a[ COLOR_CODE ] == cColorCode } ) ) # 0
          IF ( cColorSet := aDispColors[ nColorCode, COLOR_SET ] ) =  NIL
             cColorSet = cWinColor
          ENDIF
          // strip off color code
          cLine = substr( cLine, CODE_LEN + 1 )
          // keep track of the line length
          nLength -= (CODE_LEN +1)
       ELSE
          // strip off color code prefix
          cLine = substr( cLine, CODE_LEN )
          // keep track of the line length
          nLength -= CODE_LEN
       ENDIF
     END
     // cut to the left column if we are not already there
     If nLinePos < nLeftBrowse
        cLine = Substr( cLine , nLeftBrowse - nLinePos + 1)
     Endif
     // output remainder of line
     devout( Pad( cLine , nLeft + nLengthBrowse - Col() ) , cColorSet )
     // set the system counters
     nMaxRight   = Max(nMaxRight,nLength)
     nLastOffSet = Max(nLastOffSet,aLines[nLine,3])
   NEXT
Endif
RETURN NIL

/***************************************************************************
* Justify the display before displaying the found text
* The find column may be out of view left or right
****************************************************************************/
STATIC Function CheckDisp(cLookText,aLines,nLastOffSet,;
                          nHighLiteOffSet,;
                          nLeftBrowse,nLengthBrowse)
LOCAL nLength := LEN(AllTrim(cLookText))
If nHighLiteOffSet < nLeftbrowse  // the find text is out of scope left
   nLeftBrowse = nHighLiteOffSet
Elseif nLeftBrowse+nHighLiteOffSet+nLength > ;
       nLeftBrowse+nLengthBrowse  // the find text is out of scope right
   nLeftBrowse = (nHighLiteOffSet+nLength-nLengthBrowse )
Endif
RETURN (Ascan(aLines,{ |x| x[2] <= nLastOffSet .and. x[3] > nLastOffSet}))

/***************************************************************************
* Highlight the found text
****************************************************************************/
STATIC Function HighLight(cLookText,nOffSet,nRow,nCol)
LOCAL nLength := LEN(AllTrim(cLookText))
LOCAL cScreen := SAVESCREEN(nRow,nCol+nOffSet-1,;
                            nRow,nCol+nOffSet+nLength-2)
// use this variable to set the highlight color you want to use
LOCAL cChar := If( Chr(7) $ cScreen,Chr(112),Chr(7))
RESTSCREEN(nRow,nCol+nOffSet-1,nRow,nCol+nOffSet+nLength-2,;
   TRANSFORM(cScreen,REPLICATE(("X"+cChar),nLength)))
RETURN 0

/***************************************************************************
* Clean up the line by removing control characters
* and apply the user-defined block if applicable
* cLine is passed to this function by reference
* thus no return value
****************************************************************************/
STATIC Function LineClean( cLine , lApplyBlock , bApplyText )
cLine = Strtran( cLine , Chr(10) , ' ' )   // LF
cLine = StrTran( cLine , Chr(12) , ' ' )   // FF
cLine = StrTran( cLine , Chr(13) , ' ' )   // CR
cLine = StrTran( cLine , Chr(26) , ' ' )   // EOF
If lApplyBlock
   cLine = Eval( bApplyText , cLine )
Endif
RETURN NIL

/****************************************************************************
* Search for line-feed or form-feed mark - return the first offset
* The extraordinary error trapping is included here to prevent
* lock-up when a binary file is browsed, i.e. a loop can be
* caused by the eof mark not being found
****************************************************************************/
STATIC Function FirstEolmark(cBuffer)
LOCAL nFFmark := At(Chr(12),cBuffer)
LOCAL nLFmark := At(Chr(10),cBuffer)
LOCAL nReturn := 0
If nFFmark > 0 .and. nLFmark > 0
   nReturn = MIN( MIN(nFFmark,nLFmark) , MAXBROWSELENGTH )
Elseif nFFmark > 0 .or. nLFmark > 0
   nReturn = MIN( MAX(nFFmark,nLFmark) , MAXBROWSELENGTH )
Elseif LEN( cBuffer ) >= MAXBROWSELENGTH
   nReturn = MAXBROWSELENGTH
Endif
RETURN nReturn

/***************************************************************************
* fill the array traversing down the file
****************************************************************************/
STATIC Function DownFillArray(nHandle,aLines,nStart,nEnd,;
                              lApplyBlock,bApplyText,lHitBottom)
LOCAL nBlock := 1024
LOCAL cBuffer
LOCAL cLine
LOCAL nEOL
LOCAL nCounter := nStart - 1
LOCAL nFilePos := Fseek( nHandle , 0 , 1 )
LOCAL nLineLength
LOCAL nLoopCounter := 0
LOCAL nBytesRead
lHitBottom = .f.
// while the array is not full
While nCounter < nEnd
   // reposition to current file position
   Fseek( nHandle , nFilePos , 0 )
   // assign a buffer and read the file
   cBuffer = Space( nBlock )
   if (nBytesRead := Fread( nHandle , @cBuffer , nBlock )) # nBlock
      nLoopCounter ++
   endif
   // check for eof
   If nBytesRead < 1 .or. nLoopCounter > 2
      lHitBottom = .t.
      Exit
   Else
      While nCounter < nEnd .and. (nEOL := FirstEolMark( cBuffer )) # 0
         nCounter ++
         // extract the line
         cLine = Left( cBuffer , nEOL )
         // strip the line from the buffer
         cBuffer = Substr(cBuffer,nEOL+1)
         // save the length
         nLineLength = LEN( cLine )
         // clean it up
         LineClean( @cLine , lApplyBlock , bApplyText )
         // store it in the array
         aLines[nCounter] = { cLine , nFilePos , nFilePos + nLineLength }
         // keep the pointer current
         nFilePos += nLineLength
      End
      // test for eof
      lHitBottom = (nCounter < nEnd)
   Endif
End
RETURN NIL

/***************************************************************************
* add one line to the bottom the array
****************************************************************************/
STATIC Function SkipDown(nHandle,aLines,nLastLine,nNumLines,nSize,;
                         lApplyBlock,bApplyText)
LOCAL lHitBottom := .f.
If aLines[ nLastLine , 3 ] # 0
   // position file to last line offset
   Fseek( nHandle , aLines[ nLastLine , 3 ] , 0 )
   Adel( aLines , 1 )
   aLines[nLastLine] = {'',0,0}
   // get the next line
   DownFillArray(nHandle,aLines,nLastLine+1-nNumLines,nLastLine,;
                 lApplyBlock,bApplyText,@lHitBottom)
   If lHitBottom .or. aScan(aLines,{|x|!Empty(x[1])}) = 0
      // we hit bottom or no text in any line
      aLines[1,2] = Fseek( nHandle , 0 , 2 )
      UpFillArray(nHandle,aLines,nLastLine,nSize,lApplyBlock,bApplyText)
   Endif
Endif
RETURN NIL

/***************************************************************************
* fill the array traversing up ... the tricky one ...
* This function was originally coded with the RAT function
* Tests show the AT func to be about 10 times faster than RAT
* thus the overhead of the aTemp with the AT function as an offset map
****************************************************************************/
STATIC func UpFillArray(nHandle,aLines,nEnd,nSize,lApplyBlock,bApplyText)
LOCAL aOffSets
LOCAL cBuffer
LOCAL cFirstChar
LOCAL cLine := ''
LOCAL nBlock := 1024
LOCAL nCounter := 0
LOCAL nEOL
LOCAL nFilePos := Fseek( nHandle , 0 , 1 )
LOCAL nTempCount
LOCAL lEOF :=  (nSize = nFilePos )
LOCAL lReturn := .t.
While nCounter < nEnd
   // assign some defaults and read the file
   nBlock = Min(nBlock,aLines[1,2])
   nFilePos = aLines[1,2] - nBlock
   Fseek( nHandle , nFilePos , 0 )
   cBuffer = Space( nBlock )
   If Fread( nHandle , @cBuffer , nBlock ) = 0
      Exit
   Else
      If nFilePos = 0
         aOffSets = {1}
      Else
         aOffSets = { }     // discard the first line - it is a fragment
      Endif
      // map the lines into a temp array
      nTempCounter = 0
      While (nEOL := FirstEolMark( Substr( cBuffer , nTempCounter + 1 ))) # 0
         nTempCounter += nEOL
         Aadd( aOffSets , nTempCounter )
      End
      // pick up the last line if eof and it does not end w/ LF CR etc.
      If lEOF .and. nTempCounter < nBlock
         Aadd( aOffSets , nBlock )
      Endif
      nTempCounter = LEN( aOffSets )
      // fill the array
      While nCounter < nEnd .and. nTempCounter > 1
         nCounter ++
         nTempCounter --
         cLine = Substr(cBuffer,aOffSets[nTempCounter]+1)
         // strip the first char if it is a control char
         // going down we don't have this problem as it is at the end and
         // we don't care
         cFirstChar = Left( cLine , 1 )
         If cFirstChar = Chr(10) .or. cFirstChar = Chr(12) .or. ;
            cFirstChar = Chr(13) .or. cFirstChar = Chr(26)
            cLine = Substr( cLine , 2 )
         Endif
         // clean it up
         LineClean( @cLine , lApplyBlock , bApplyText )
         // store the line and it's parameters
         Ains( aLines , 1 )
         aLines[1] = {cLine,;
                      nFilePos+aOffSets[nTempCounter],;
                      nFilePos+aOffSets[nTempCounter+1]}
         // strip the line from the buffer
         cBuffer = Left(cBuffer,aOffSets[nTempCounter])
      End
      // if nCounter < nEnd we ran out of lines
      // return .f. and fill the array from the top
      lReturn = (nCounter = nEnd )
      If nFilePos = 0
         If aLines[1,2] = 1 // assign BOF status explicitly for the other
            aLines[1,2] = 0 // functions
         Endif
         Exit  // we're done here
      Endif
   Endif
End
RETURN lReturn

/***************************************************************************
* add one line to the top of the array
****************************************************************************/
STATIC func SkipUp(nHandle,aLines,lApplyBlock,bApplyText)
LOCAL nBlock
LOCAL cBuffer
LOCAL cLine := ''
LOCAL lBOF := .f.
LOCAL nEOL
LOCAL nFilePos
LOCAL nLength
If aLines[1,2] #0
   nBlock = Min(512,aLines[1,2])
   nFilePos = aLines[1,2] - nBlock
   lBOF = (nFilePos <= 1 )
   Fseek( nHandle , nFilePos , 0 )
   cBuffer = Space( nBlock )
   If !Fread( nHandle , @cBuffer , nBlock ) = 0
      // get past the first eol mark
      nEOL = MAX( Rat(Chr(12),cBuffer), Rat(Chr(10),cBuffer) )
      If nEOL # 0
         cLine = Right( cBuffer , Len(cBuffer)-nEOL+1 )
         cBuffer = Left(cBuffer,nEOL-1)
      Endif
      // get the last line in the buffer
      nEOL = MAX( Rat(Chr(12),cBuffer), Rat(Chr(10),cBuffer) )
      If nEOL == 0 .and. !lBOF
         nEOL = MIN(nBlock,MAXBROWSELENGTH)
      Elseif LEN(cBuffer) - nEOL > MAXBROWSELENGTH
         nEOL = MAXBROWSELENGTH
      Endif
      // update the file position
      nFilePos += nEol
      // get the line
      cLine = ( Right(cBuffer,Len(cBuffer)-nEOL) + cLine )
      // save the real length of the line in the file
      nLength = LEN( cLine )
      // clean it up
      LineClean( @cLine , lApplyBlock , bApplyText )
      // store the line and it's parameters
      Ains( aLines , 1 )
      aLines[1] = {cLine,nFilePos,nFilePos+nLength}
   Endif
Endif
RETURN NIL

/***************************************************************************
* Display a status bar based on the relative position in the file
* Not 100 % accurate but a fair representation to pacify the mere mortals
****************************************************************************/
STATIC Function ScrollBar(lPaint,nStart,nEnd,nSize,nLastLine,nBarTop,nRight,;
                          nBarBottom,nRow,cBarColor,cButtonColor)
LOCAL nCounter
LOCAL nMiddle
LOCAL nPercent
If lPaint  // this only happens on the very first call
   For nCounter = nBarTop to nBarBottom
      DevPos(nCounter,nRight); DevOut(Chr(176),cBarColor)
   Next
Else // update the button
   // erase the old button - where's the whiteout
   DevPos(nRow,nRight); DevOut(Chr(176),cBarColor)
   If nStart = 0             // figger out the new row
      nRow = nBarTop         // nRow is passed by ref so it will be updated
   Elseif nEnd >= nSize -1
      nRow = nBarBottom
   Else
      nMiddle = nStart + ((nEnd - nStart) / 2 )
      nPercent = (nMiddle/nSize)
      nRow = nBarTop + INT( (nBarBottom - nBarTop) * nPercent )
   Endif
   // display the button
   DevPos(nRow,nRight); DevOut( chr(254),cButtonColor)
Endif
RETURN NIL

/***************************************************************************
* Search Routine By: Phil Barnett  April 3, 1993
* Search and repeat last find
****************************************************************************/
STATIC Function Search(nHandle,nMode,nLastFind,cLookText,nLooklen,;
                       nHighLiteOffSet,nBottom,nTotalFound)
LOCAL cBuffer
LOCAL cSaveIt := savescreen(nBottom,0,nBottom,MaxCol())
LOCAL nBytesRead
LOCAL nBlock := 4096  // Bigger is probably faster up to ~10000 bytes
LOCAL nThisOffset
LOCAL nOffset := 0
LOCAL nLoop := 0
LOCAL getlist := {}
LOCAL cMiniBuff
LOCAL nMBsize
LOCAL nEOLat
LOCAL cHoldBack := ''
if nMode == 1     // initiate search (ALT_F)ind
  nTotalFound = 0
  nLastFind = -1
  cLookText = pad(cLookText,25)
  @ nBottom,1 say space(49)
  //@ nBottom,2 say 'Enter Search Phrase' get cLookText picture '@K@!'
  @ nBottom,2 say 'Podaj szukany tekst:' get cLookText picture '@K'
  SetCursor( If(ReadInsert(),2,1 ))
  read
  SetCursor(0)
  restscreen(nBottom,0,nBottom,MaxCol(),cSaveIt)
  if lastkey() == 27 .or. empty(cLookText)
    RETURN 0
  endif
  cLookText = upper(alltrim(cLookText)) // Marek
  nLookLen = len(cLookText)
endif
fseek(nHandle,nLastFind+1,0)  // Position filepointer to starting location
nBytesRead = nBlock          // setup loop entry
do while nBytesRead == nBlock
  // Get and prepare the Character Buffer
  cBuffer = space(nBlock)
  nBytesRead = fread(nHandle,@cBuffer,nBlock)
  if nBytesRead < nBlock
    cBuffer = left(cBuffer,nBytesRead)
  endif
  cBuffer = cHoldBack + upper(cBuffer)
  nThisOffset = at(cLookText,cBuffer)
  if !empty(nThisOffset)
    // position the File Pointer to the find.
    nLastFind += ( nLoop * nBlock ) + nThisOffset - Len( cHoldBack )
    Fseek( nHandle, nLastFind , 0)
    // Now, locate the beginning of the line
    // ( It might not be in current buffer, so make a new minibuffer )
    nMBsize = min( nLastFind, 512 )
    cMiniBuff = space(nMBsize)
    fseek( nHandle,-nMBsize,1)
    fread(nHandle,@cMiniBuff,nMBsize)
    nEOLat = MAX( Rat(Chr(12),cMiniBuff), Rat(Chr(10),cMiniBuff) )
    if nEOLat > 0
       fseek( nHandle, nEOLat-nMBsize,1)
    endif
    nOffset = fseek(nHandle,0,1)
    nHighLiteOffSet = (nLastfind - nOffSet + 1)
         tone(880,1)
    nTotalFound ++
    // We found one so...
    exit
  endif
  cHoldBack = right(cBuffer,nLookLen - 1)
  nLoop ++
enddo
if nOffset == 0
  //@ nBottom,1 say ' ' +Ltrim(Trim(Str(nTotalFound)))+;
  //                ' Occurences Found - No More Finds (Press Any Key) '

  tone(880,1)
  @ nBottom,1 say ' Razem liczba wystpie: ' +Ltrim(Trim(Str(nTotalFound)))+;
                  ' - Koniec szukania (nacinij dowolny klawisz) '
  Tone(100,1)
  inkey(0)
  restscreen(nBottom,0,nBottom,MaxCol(),cSaveIt)
endif
RETURN nOffset

*******************************************************************************
FUNCTION DRUK_PLI()
local _tex:='۲  PRZEGLDANIE I WYDRUK ZAPAMITANYCH PLIKW ',;
      _pliki, _st, _na,_astru:={},_kropka,_r:="",;
      _wybor:=1, _portdru:="LPT1",_nastepny:=.f.
cls
@ 0,0 say _tex
BEGIN SEQUENCE

DO WHILE .t.
  _pliki:=DIRECTORY(_sc+"*.PRN")
  if len(_pliki)=0
    QKE("Brak zapamitanych plikw !")
    BREAK
  endif
  
  // kasowanie stopek i nagwkw gdyby pozostay w katalogu
  
  if (_st:=ascan(_pliki,{|x| x[1]=="STOP.PRN"}))>0
    adel(_pliki,_st)
    asize(_pliki,len(_pliki)-1)
  endif  
  
  if (_na:=ascan(_pliki,{|x| x[1]=="NAG.PRN"}))>0
    adel(_pliki,_na)
    asize(_pliki,len(_pliki)-1)
  endif  
  
  if (_na:=ascan(_pliki,{|x| x[1]=="DOD.PRN"}))>0
    adel(_pliki,_na)
    asize(_pliki,len(_pliki)-1)
  endif  
  
  if len(_pliki)=0
    QKE("Brak zapamitanych plikw !")
    BREAK
  endif

  CPClose(PLIKI)
  dele file (_sc+"PLIKI.DBF")

  _astru:={}  
  aadd(_astru,{"NAZWA","C",8,0})
  aadd(_astru,{"DATA","D",8,0})
  aadd(_astru,{"CZAS","C",8,0})
  aadd(_astru,{"ROZMIAR","N",8,0})
  dbcreate(_sc+"PLIKI",_astru)

  sele 0
  _use(_sc+"PLIKI","E!")
  inde on NAZWA to (_sc+"PLIKI_N")
  inde on dtos(DATA)+CZAS to (_sc+"PLIKI_D")
  set inde to  (_sc+"PLIKI_N"), (_sc+"PLIKI_D")
  
  aeval(_pliki,{ |aPrnFile| PLIKI->(dbappend()),;
                            _kropka:=at(".",aPrnFile[F_NAME]),;
                            PLIKI->NAZWA:=subs(aPrnFile[F_NAME],1,_kropka-1),;
                            PLIKI->DATA:=aPrnFile[F_DATE],; 
                            PLIKI->CZAS:=aPrnFile[F_TIME],;
                            PLIKI->ROZMIAR:=aPrnFile[F_SIZE] })
  

   set orde to 2
   go bott
   skip -10
  
  CPEDIT  POZ: 1,,23,               ;
          DEF: "PLIKI"             ;
          POZWER: "V1"              ;
          PION: ,,,              ;
          INDEXY: {"nazwa","data+czas"}                ;
          EDYCJA: .f.               ;
          ODTWORZ:.f.               ;
          AKCJA: _r:=DAJ_PLIK()

  if _r<>NIL
    _r:=alltrim(_r)
    @1,0 clea to 24,79
    max_line_len:=275
    _pp:=_sc+_r+".PRN"
    @ 1,0 say "Plik : "+_pp  
    @ 24,0 say "ALT_F - wyszukiwanie tekstu, ALT_R - kontynuacja"
    FileBrowse(_pp,2,,23)
    @ 24,0
*    tb27(_pp,2)
    do while .t.
      _wybor:=;
      HorizMenu(24,0,"",{"LPT1","LPT2","LPT3","SKASOWANIE PLIKU","NASTPNY",;
                         "KONIEC"})
      do case
        case _wybor=0 .or. _wybor>=5
          exit 
        case _wybor=4.and.QTN("Skasowanie pliku "+alltrim(_pp)+" ?")
          dele file (_pp)
          exit
        case _wybor=1 .or. _wybor=2 .or. _wybor=3
          _portdru:=if(_wybor=1,"LPT1",if(_wybor=2,"LPT2","LPT3"))
          DRUKUJ_PLIK(_pp,_portdru)
      endcase
    enddo
  else
   exit
  endi
  if _wybor>=1 .and. _wybor<=5
    @ 1,0 clea to 24,79
    loop
  endi

  exit
ENDDO
END SEQUENCE
close data
dele file  (_sc+"PLIKI.DBF")
dele file  (_sc+"PLIKI_N.NTX")
dele file  (_sc+"PLIKI_D.NTX")

RETU NIL
*******************************************************************************
FUNCTION DAJ_PLIK()        
static _wyjscie:=.f.                        // .T. jesli akcja wymusila wyjscie
local _l:=lastkey(), _np:=PLIKI->NAZWA

if _wyjscie
  _wyjscie:=.f.
  RETU _np
endif

if (_l=K_ENTER .or. _l=K_ALT_F7)
  keyboard chr(K_ESC)              // wroci jeszcze raz do AKCJI !!
  _wyjscie:=.t.
  RETURN NIL
endif
RETU NIL

*******************************************************************************
FUNCTION DRUKUJ_PLIK(_nazwa,_port)           
local prevhandler:=errorblock(),nhandle,cbuffer,_aa
max_line_len:=275    // static

* QPC(1)
set devi to print
set printer to (_port)
errorblock( { |e| PrintError(_port,e,prevhandler) } )

BEGIN SEQUENCE

if (nhandle:=Fopen(_nazwa)) = 0;  BREAK; endif    // otwieramy
Fseek(nhandle,0)                                  // poczatek 
_koniec:=.f.
do whil .t.                       
  if .not.PRINTER_OK(_port)
    clea typeahead
    inkey(1)
  endi
  if .not.PRINTER_OK(_port)
    set devi to screen
    if QTN("Drukarka nie jest gotowa  -  ponowienie prby wydruku ?")
      QKE("Przygotuj drukark !",,,,.t.)
      if lastkey()=K_ESC; BREAK; endi
    else
      BREAK
    endi
  else
    exit
  endi
endd
do while !_koniec
  Freadln(nhandle,@cBuffer,max_line_len)
  _aa:=At(chr(26), cBuffer) 
  _koniec:= _aa> 0
  if _koniec
    cbuffer:=subs(cbuffer,1,_aa-1)
  endif
  if inkey()=K_ESC; BREAK; endif
  @ prow()+1,0 say cBuffer
enddo
fclose(nhandle)
END SEQUENCE
QPC(0)
set devi to screen
errorblock(prevhandler)
RETU NIL

*******************************************************************************
FUNCTION POMOC()
loca _tex:=;
     '۲  POMOC  ',;
     _portdru,_wybor
cls
@ 1,0 say _tex

TB_PLIK("pomoc.mem")

@ 24,0
_wybor:=HorizMenu(24,0,"WYDRUK :",{"LPT1","LPT2","LPT3","KONIEC"},4)
if _wybor=1.or._wybor=2.or._wybor=3
  _portdru:=if(_wybor=1,"LPT1",if(_wybor=2,"LPT2","LPT3"))
  DRUKUJ_PLIK("crm.mem",_portdru)
endi

RETURN NIL

*******************************************************************************
FUNCTION SK()     
local _s:=Eval(MemVarBlock(readvar()))
if val(_s)>0
  _s:=strtran(str(val(_s),len(_s))," ","0")
  Eval(MemVarBlock(readvar()),_s)
elseif val(_s)=0.and.val(subs(_s,2))>0
  _s:=subs(_s,1,1)+strtran(str(val(subs(_s,2)),len(subs(_s,2)))," ","0")
  Eval(MemVarBlock(readvar()),_s)
endi
RETURN .T.

*******************************************************************************
FUNCTION Getfont()
local aFonts
local nloop, nrow:=1
local _wybor:=1
local _lat:=;
chr(165)+chr(134)+chr(169)+chr(136)+chr(228)+chr(162)+chr(152)+chr(171)+chr(190)+;
chr(164)+chr(143)+chr(168)+chr(157)+chr(227)+CHR(224)+chr(151)+chr(141)+chr(189)

local _win:=;
chr(185)+chr(230)+chr(234)+chr(179)+chr(241)+CHR(243)+chr(156)+chr(159)+chr(191)+;
chr(165)+chr(198)+chr(202)+chr(163)+chr(209)+chr(211)+chr(140)+chr(143)+chr(175)

loca _tex:='۲  LISTA DOSTPNYCH CZCIONEK  '
cls
@ 0,0 say _tex

BEGIN SEQUENCE

@ 2,2 say "Opcja drukuje na domylnej drukarce Windows list dostpnych czcionek dla "
@ 3,2 say "wydrukw uywajcych PScript. Dla portu WIN wyboru naley dokona sposrd"
@ 4,2 say "czcionek ze sta szerokoci i polskimi znakami diaktrycznymi."

@ 5,2 say "Wybran czcionk wpisuje si do pola Czcionka PS w opcji USTAWIENIA"
@ 6,2 say "z menu WYDRUK USTAWIENIA .... Pozostawienie dla portu WIN pustego pola"
@ 7,2 say "oznacza wybr czcionki Courier New."
@ 8,2 say "Domyln czcionk dla wydrukw graficznych jest Arial"
@ 9,2 say "Mona wybra czcionk o staej szerokoci bez polskich znakw ale"
@ 10,2 say "wtedy w opcji USTAWIENIA w polu Konwersja naley zmieni WIN na STD."
@ 11,2 say "Polskie znaki bd drukowane bez 'ogonkw' - a zamiast  itp."

@ 13,2 say "Wybr czcionki o staej szerokoci powinien uatwi pocztek testowego"
@ 14,2 say "tekstu 'MIM....' - czcionki M i I powinny zajmowa tak sam szeroko."
@ 15,2 say "Przykady czcionek o staej szerokoci: Courier New, Lucida Console,"
@ 16,2 say "Letter Gothic, OCR A Extended."

@ 18,2 say "Lista zostanie wygenerowana jesli przy starcie programu pojawi si" 
@ 19,2 say "komunikat 'PScript - OK !'"

if _ps=0
  _wybor:=HorizMenu(21,2,"",{"KONTYNUACJA","REZYGNACJA"})
else
  @ 21,2 say "PageScript nie zosta zainicjowany. Nacinij klawisz." COLOR "N/W"
  inkey(0)
  BREAK
endif

if _wybor=2 .or. _wybor=0;BREAK;endi

BEGINDOC  TITLE "Lista czcionek"  ORIENTATION APS_PORTRAIT
   aFonts := PSGetFonts()
   PSSetUnit(APS_TEXT)
   PSSetRowCol(50, 80)
   PSSetFont(APS_ARIAL, APS_PLAIN, 12)

   for nLoop := 1 to Len(aFonts)
      @nRow,0  TEXTOUT aFonts[nLoop]
//      @nRow,39 TEXTOUT aFonts[nLoop]  FONT aFonts[nLoop]
//      @nRow,39 TEXTOUT  "LATMIM"+_lat FONT aFonts[nLoop]
//      PSLine(nRow + 1, 0, nRow + 1, 80, 1, APS_BLACK)
      @nRow,39 TEXTOUT  "WINMIM"+_win FONT aFonts[nLoop]
      PSLine(nRow + 1, 0, nRow + 1, 80, 1, APS_BLACK)
      nrow+=2
      if nRow > 48
         nRow := 0
         PSNewPage()
      endif
   next nLoop
ENDDOC

END SEQUENCE

RETURN NIL

*******************************************************************************
FUNCTION WYB_DR_PS(_wariant,_seryjny)
   // funkcja zwaraca numer drukarki i czcionke {_ndrukarka,_font_ps}
local savescr, aprinters,i,_tdrukarka,ret,apom:={},_ndrukarka:=0
local _sel:=select(), getlist:={}
local _save:="N" ,ff,_scc,_font_ps

DEFAULT _seryjny TO .f.

BEGIN SEQUENCE

sele 0
_use (_sc+"PARADRUK","R!")
_lkonw:=  (fieldpos("KONWERSJA")=0)
_lorient:=(fieldpos("ORIENTACJA")=0)
_lfontps:=(fieldpos("FONT_PS")=0)
_ldrukarka:=(fieldpos("DRUKARKA")=0)
if _lkonw .or. _lorient .or. _lfontps .or. _ldrukarka
  _astru:=DBSTRUCT()
  close PARADRUK
  if _lkonw
    aadd(_astru,{"KONWERSJA","C",6,0})
  endi
  if _lorient
    aadd(_astru,{"ORIENTACJA","C",1,0})
  endi
  if _lfontps
    aadd(_astru,{"FONT_PS","C",30,0})
  endi
  if _ldrukarka
    aadd(_astru,{"DRUKARKA","C",30,0})
  endi
  dbcreate(_sc+"STRU",_astru)

  sele 0
  _use (_sc+"STRU","E!")
  appe from (_sc+"PARADRUK")
  copy to (_sc+"PARADRUK")
  _use (_sc+"PARADRUK","E!")
  dele file (_sc+"STRU.DBF")

  set filter to alltrim(PORT)="WIN"
    // program w LATIN 
  repl all KONWERSJA with "LATWIN"
  set filter to

endi

set inde to (_sc+"PARADRUK")
seek _wariant
ff:=found()

if ff
   redit:=recn()
else
  close PARADRUK

  sele 0
  _use (_sc+"PARADRUK","F!")
  set inde to (_sc+"PARADRUK")
  append blank
  repl WARIANT with _wariant
  seek _wariant
  ff:=found()
  redit:=recn()
endif   
*--------------  
//ALTD()
aprinters:=PSGetPrinters()
if ff
  _font_ps:=FONT_PS 
  _tdrukarka:=if(!empty(DRUKARKA),DRUKARKA,space(30))
  if !empty(_tdrukarka)
    _ndrukarka:=ascan(aprinters,alltrim(_tdrukarka))
  else
     _ndrukarka:=0
  endif   
else
  _ndrukarka:=0
  _tdrukarka:=space(30)
  _font_ps:=space(30)
endif   
CpClose(PARADRUK) 
 
//altd()
if _seryjny; BREAK;endif
   
do while .t.
  @ 24,0
  _ust_dru:=HorizMenu(24,0,"",{"WYDRUK","USTAWIENIA","PLIK PDF", "PODGLD WYDRUKU"})
  @ 24,0

  if _ust_dru=0
    _ndrukarka:=999
    BREAK
  elseif _ust_dru=4
    _ndrukarka:=997
    BREAK
  elseif _ust_dru=3
    _ndrukarka:=998
    BREAK
  elseif _ust_dru=1
     BREAK
  else   
                        
    _scc:=savescreen(14,0,18,64)  
    @  14,0 clea to 18,64
    @  14,0,18,64 box R_GRUBA
    @  15,2 say "Drukarka:  " get _tdrukarka pict "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
                    when (DAJ_DRUKARKI() .and.SLGET("DRUKARKI","DRUKARKI","V1",-1,1,{"drukarka"})) ;
                    valid SLGET()
    @ 16,2 say  "Czcionka:  " get _font_ps pict "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
                   
    @ 17,2 say  "Zapamita?" get _save  pict "@! X" valid _save$"TN"                  
                                       
    set cursor on;read;set cursor off  
    restscreen(14,0,18,64,_scc)
    if !empty(_tdrukarka)   
      _ndrukarka:=ascan(aprinters,alltrim(_tdrukarka))  
    else
      _ndrukarka:=0
    endi
    CpClose(DRUKARKI)
    if _save="T"
       
      CPClose(PARADRUK)
      sele 0
      _use(_sc+"PARADRUK","E!")
      go redit
      repl DRUKARKA with _tdrukarka, FONT_PS with _font_ps
      close PARADRUK
    endi  
    
    @ 24,0  
  endif
enddo

END SEQUENCE
sele (_sel)
if empty(_font_ps);_font_ps:="Arial";endif
RETURN {_ndrukarka,_font_ps}

*******************************************************************************
FUNCTION TEKST(_t)
local _i
for _i:=1 to len(_t); ZNAK(subs(_t,_i,1)); next
RETURN NIL

*******************************************************************************
FUNCTION MATRYCA()
_znaki:={}
aadd(_znaki,{"0","˻","","ʼ",4})
aadd(_znaki,{"1","ͻ ","  ","",4})
aadd(_znaki,{"2","ͻ","ͼ","",4})
aadd(_znaki,{"3","ͻ"," ͹","ͼ",4})
aadd(_znaki,{"4"," ","͹","  ",4})
aadd(_znaki,{"5","","ͻ","ͼ",4})
aadd(_znaki,{"6","ͻ","ͻ","ͼ",4})
aadd(_znaki,{"7","ͻ","  ","  ",4})
aadd(_znaki,{"8","ͻ","͹","ͼ",4})
aadd(_znaki,{"9","ͻ","͹","ͼ",4})
aadd(_znaki,{"-","   ","","   ",4})
aadd(_znaki,{"+","   ","","   ",4})
aadd(_znaki,{"*","   ","","   ",4})
aadd(_znaki,{" ","   ","   ","   ",4})
aadd(_znaki,{".","   ","   ","  ",4})
aadd(_znaki,{":","   ","  ","  ",4})
aadd(_znaki,{",","   ","   ","  ",4})
aadd(_znaki,{'"'," ","   ","   ",4})
aadd(_znaki,{"'","  ","   ","   ",4})

*aadd(_znaki,{"/","  ","  ","  ",4})

aadd(_znaki,{"/","   ","  ","   ",4})
aadd(_znaki,{"A","ͻ","͹"," ",4}) 
aadd(_znaki,{"","ͻ","͹"," ",4}) 
aadd(_znaki,{"B","ͻ","͹","ͼ",4}) 
aadd(_znaki,{"C","ͻ","  ","ͼ",4})
aadd(_znaki,{"","λ","  ","ͼ",4})
aadd(_znaki,{"D","ͻ"," ","ͼ",4})
aadd(_znaki,{"E","ͻ"," ","ͼ",4})
aadd(_znaki,{"","ͻ"," ","",4})
aadd(_znaki,{"F","ͻ"," ","  ",4})
aadd(_znaki,{"G","ͻ"," ","ͼ",4})
aadd(_znaki,{"H"," ","͹"," ",4})
aadd(_znaki,{"I","","  ","",4})
aadd(_znaki,{"J","  ","  ","ȼ ",4})
aadd(_znaki,{"K","","ʻ"," ",4})
aadd(_znaki,{"L","  ","  ","ͼ",4})
aadd(_znaki,{"","  "," ","ͼ",4})
aadd(_znaki,{"M","˻",""," ",4})
aadd(_znaki,{"N","ɻ","","ȼ",4})
aadd(_znaki,{"","ɹ","","ȼ",4})
aadd(_znaki,{"O","ͻ"," ","ͼ",4})
aadd(_znaki,{"","λ"," ","ͼ",4})
aadd(_znaki,{"P","ͻ","ͼ","  ",4})
aadd(_znaki,{"Q","ͻ"," ","",4})
aadd(_znaki,{"R","ͻ","˼","",4})
aadd(_znaki,{"S","ͻ","ͻ","ͼ",4})
aadd(_znaki,{"","λ","ͻ","ͼ",4})
aadd(_znaki,{"T","˻","  ","  ",4})
aadd(_znaki,{"U"," "," ","ͼ",4})
aadd(_znaki,{"W"," ","","ʼ",4})
aadd(_znaki,{"V"," ","ɼ","ȼ ",4})
aadd(_znaki,{"X","","λ","ͼ",4})
aadd(_znaki,{"Y"," ","˼","  ",4})
aadd(_znaki,{"Z","ͻ","ͼ","",4})
aadd(_znaki,{"","λ","ͼ","",4})
aadd(_znaki,{"","ͻ","μ","",4})
aadd(_znaki,{"z","   "," ͻ"," ",4})
aadd(_znaki,{"","   ","  "," ",4})

RETURN NIL

*******************************************************************************
FUNCTION ZNAK(_z)       
local _r:=row(),_c:=col(),_l:=0

_l:=ascan(_znaki,{|x| x[1]=_z })
if _l>0
  if _r>22.or._c>80-_znaki[_l][5]; chr(7); RETURN NIL;  endi
  devpos(_r,  _c); devout(_znaki[_l][2])
  devpos(_r+1,_c); devout(_znaki[_l][3])
  devpos(_r+2,_c); devout(_znaki[_l][4])
  devpos(_r,_c+_znaki[_l][5])  // +if(_znaki[_l][5]=0,1,0))
endi
RETURN NIL

*******************************************************************************
FUNCTION DZIEL(t,max)
// podzial t w miejscu spacji na 2 czesci
// dlugosc kazdej  czesci nie moze przekroczyc max
// dla przeleww  max=61

local t1:="",t2:="",_aret:={},_bierztoken,_poprztoken,_iletokenow,i,_ok:=.f.

//1.
BEGIN SEQUENCE

t:=alltrim(t)
if len(t)<=max
  _aret:={padr(t,max),space(max)}
  _ok:=.t.
  BREAK
endi

_iletokenow:=NUMTOKEN(t," ")  // liczba tokenw oddzielonych spacj
for i:=1 to _iletokenow
  _bierztoken:=ATTOKEN(t," ",i)
  if _bierztoken > max+2   //pozycja i-tego tokena
    _poprztoken:=ATTOKEN(t," ",i-1)           // pozycja i-1 tokena
    t1:=subs(t,1,_poprztoken-2)
    t2:=subs(t,_poprztoken)
    if len(t2)<=max
      _aret:={padr(t1,max),padr(t2,max)}
      _ok:=.t.
      BREAK
    endi
  endi
next
t1:=subs(t,1,_bierztoken-2)
t2:=subs(t,_bierztoken)
if len(t2)<=max
  _aret:={padr(t1,max),padr(t2,max)}
  _ok:=.t.
  BREAK
endi

END SEQUENCE

if !_ok
  t1:=subs(t,1,max)
  t2:=padr(subs(t,max+1) ,max)
  _aret:={t1,t2}
endi

RETURN _aret

*******************************************************************************
