#include "memoedit.ch"
#include "getexit.ch"
#include "hbXml.ch"                                                  //15.12.18

#define TAB   Chr(9)
#define CR    Chr(13)
#define LF    Chr(10)
#define CRLF  CR + LF
#xtranslate FTell(<fHandle>) => FSeek(<fHandle>, 0, FS_RELATIVE)
#xtranslate :fileHandle   => :cargo\[1\]
#xtranslate :fileLine     => :cargo\[2\]
#xtranslate :lineOffset   => :cargo\[3\]
#define FILE_BRWS_NUM_IVARS 3
                                                                     //12.02.19
//#xtranslate :<!Method!>( <args,...> ) := => :<Method>( <args> ):OleValue :=
#define CRLF Chr(13)+Chr(10)

static max_line_len:=0,_k_tab:=.f.                              

REQUEST HB_LANG_PL852       
REQUEST HB_CODEPAGE_PL852   

*******************************************************************************
*                                  W_MAIN                                     *
*******************************************************************************
FUNCTION MAIN(nr)
local desk,_data_b,_data_a

local oXmlDoc ,oXmlNode,oXmlNode1                                    //15.12.18


set date germ
set epoch to 1950

SETMODE(25,80)                                                            //xHB
SET(_SET_DELETED,.T.)

HB_SETCODEPAGE('PL852')                                                   //xHB
HB_LANGSELECT( 'PL852' )

public _d_lic:="91022",; //"91018",
       _nazwa_prg:=chr(255)+'IMPORT ZAMWIE SKLEP BAFPOL'+chr(255),;
       _uwaga:="A     ",;
       _scl,;
       _stary:=.f. // do zmiany okresw

// HASLA :
// _haslo    - z CONFIG.DBF
// _uwaga    - zazwyczj w funkcji HP() - wejscie do pola 


*-------------------------------------------------- obrobka parametru wywolania
DEFAULT nr TO "01"
if len(nr)>2;     RETURN NIL;     endif
if len(nr)=2
  if !(subs(nr,1,1)$"0123456789".and.subs(nr,2,1)$"0123456789")
    RETURN NIL  
  endif
else
  if !(nr$"0123456789");    RETURN NIL    
  else;                     nr:="0"+nr  
  endif
endif
*------------------------------------------------------------------------------

public _operator:="OPE",;
       _nr_ope:=0,;
       _priorytet:=0,;
       _total:=0,;
       _licencja:="M0A",;
       numer_stan:=nr,;
       _udocezak:=.t.                                                //08.08.17

_use("CONFIG","R!")
public _kartoteka:=   alltrim(KARTOTEKA),;
       _liczba_sta:=  LICZBA_STA,;
       _wersja:=WERSJA,;
       _firma_menu:=  alltrim(FIRMA_MENU),;
       _haslo:=       if(empty(HASLO),"A     ",HASLO),;
       _pieczat1:=    PIECZAT1,;
       _pieczat2:=    PIECZAT2,;
       _pieczat3:=    PIECZAT3,;
       _pieczat4:=    PIECZAT4,;
       _pieczat5:=    PIECZAT5,;
       _id_fir:=      alltrim(ID_FIR),;
       _bank_fir:=    alltrim(BANK_FIR),;
       _konto_fir:=   alltrim(KONTO_FIR),;
       _miasto_fir:=  alltrim(MIASTO_FIR),;
       _firma:=       if(fieldpos("FIRMA")>0, alltrim(FIRMA),""),;
       _ekra_blo:=   "W/N, N/W, N/N",;
       _edit_blo:=   "W/N, N/W, N/N",;
       _slow_blo:=   "W/N, N/W, N/N",;
       _format_war:=  alltrim(FORMAT_WAR),;
       _format_ilo:=  alltrim(FORMAT_ILO),;
       _format_ind:=  "99999",;
       _sc_fk:=     alltrim(SCIE_FK),;
       _sc_mv:=   alltrim(SCIE_MV),;
       _polskie:= if(fieldpos("POLSKIE")>0,POLSKIE,"   "),;
       _form_zap:="@! XX/9999"

if (val(nr) > _liczba_sta) .or. (val(nr)=0) 
  QKE("Niedozwolone stanowisko")
  RETURN NIL
endif

*----------------------------------------------------- scieka do katalogu robo
public _sc:=_kartoteka+"#"+nr+"\"             

_scl:=_kartoteka+"#"+nr
if !DIR_EXIST(_scl)
  cls
  QKE("Uwaga! Bdna konfiguracja programu. Brak kartoteki "+;
              subs(_sc,1,len(_sc)-1))
elseif !file(_sc+"PARADRUK.DBF")
  copy file PARADRUK.DBF to (_sc+"PARADRUK.DBF")
  _use(_sc+"PARADRUK","E!")
  inde on WARIANT to (_sc+"PARADRUK")
  use
endif

*-------------------------- badanie czy kto inny wszed z tym samym parametrem
if _liczba_sta > 1 .and. file(_sc+"FLAGA")
  cls
  if QTN("Kartoteka robocza zajta ! WYJCIE Z PROGRAMU ?"); RETURN NIL; endif
else
  desk:=fcreate(_sc+"FLAGA") 
  fclose(desk)
endif
cls


*----------------------------------------------------------------------- status
cls
_use("STATUS","F!")
public _rok:= ROK,;
       _data_blo  :=  DATA_BLO,;
       _data_arc  :=  DATA_ARC

_data_a:=_data_blo                                   // powyej : local _data_a

if file (_sc+"ekran.mem")
  restore from (_sc+"ekran") additive
  _d1:=_ekra_blo
  _d2:=_slow_blo
  _d3:=_edit_blo
  restore from comped additive
  _ekra_blo:=_d1
  _slow_blo:=_d2
  _edit_blo:=_d3
else
  restore from comped additive
endi
setcolor(_ekra_blo)  

if _data_blo<>_data_a
  cls
  QKE("Brak zgodnoci dat !")
  if _priorytet>=9.and.HA(_haslo)
    QKE("Zmiana daty blokady na "+dtoc(_data_a)+" !")
    _data_blo:=_data_a
    save to comped all like _????_blo
    repl DATA_BLO with _data_a
  else
    QKE("Niedozwolona ingerencja w system !")
    _data_blo:=_data_a
    retu NIL
  endi
endi 
clos STATUS

_use ("SL_OPE","E!")
index on HASLO to SL_OPE_H
use
cls

if .not.OPERATOR();   dele file (_sc+"FLAGA");   RETURN;     endif

set dele on
set key K_F1 to 
set scoreboard off
set confirm on
Polskie(.t.)

priv apolaVR:={}   // macierz do pamietania kolejnosci przestawianych
                   // i kasowanych przed wydrukiem kolumn
                   // wykorzystywana przy wersji druku "VR"

_use ("MENU","E!")
if DIR_EXIST(_scl)
  inde on OPCJA to (_sc+"MENU") for PRIORYTET<=_priorytet
else
  inde on OPCJA to MENU for PRIORYTET<=_priorytet
endif
use

MENU(0)

errorlevel(_nr_ope)
showtime()
close data
dele file (_sc+"FLAGA") 
dele file (_sc+"MENU.NTX") 
RETU NIL

*******************************************************************************
FUNCTION STOP_SORT()
if inkey()==K_ESC
  if QTN("Przerwa sortowanie ?"); close data; BREAK; endif
endif
RETU NIL

*******************************************************************************
FUNCTION ESL_OPE()
local _tex:='۲  EDYCJA SOWNIKA OPERATORW '

cls
@ 0,0 say _tex

sele 0
if !_use("SL_OPE","E","ROB"); RETURN NIL; endi
set index to SL_OPE_H
set orde to 0

go top
CPEDIT  POZ: 1,,23,               ;
        DEF: "SL_OPE"             ;
        POZWER: "V1"              ;
        PION: ,,,                 ;
        INDEXY: {}                ;
        EDYCJA: .T.               ;
        DODAWANIE: .t.            ;
        KASOWANIE: .t.            ;
        CZYDODAC:  .t.            ;
        ODTWORZ:.f.;
        SIEC: REKORD

dele all for empty(KOD).or.empt(HASLO)
pack

close data
RETURN

*******************************************************************************
FUNCTION UNIK_OPE()
local _re:=recn(), _kod:=KOD
loca for KOD=_kod.and.recn()<>_re
if found();  go _re;  RETU .f.
else;  go _re;  RETU .t.
endi

*******************************************************************************
FUNCTION INDEX()
*---------------------------------------------------------- sortowanie zbiorow
local _tex,_zb, _dok, _dkr, i,_mc

cls
_tex:='۲  SORTOWANIE ZBIORW  '
@ 0,0 say _tex

_total:=4 // liczba etapw sortowania
PASEK()

BEGIN SEQUENCE

_use("EDIT","E!")
if _priorytet=10; @ 23,0 say "EDIT"+spac(12); endi
inde on BAZA to EDIT
PASEK(1)                                        //1
??chr(7)
STOP_SORT()

_use("SL_OPE","E!"); pack
if _priorytet=10; @ 23,0 say "SL_OPE"+spac(12); endi
inde on HASLO to SL_OPE_H
PASEK(1)
STOP_SORT()

_use(_sc+"PARADRUK","E!"); pack
if _priorytet=10; @ 23,0 say "PARADRUK"+spac(12); endi
inde on WARIANT to (_sc+"PARADRUK")
PASEK(1)
STOP_SORT()

_use("SL_KAT","E!"); pack
if _priorytet=10; @ 23,0 say "SL_KAT"+spac(12); endi
inde on SYMBOL to SL_KAT
PASEK(1)
STOP_SORT()

END SEQUENCE
close data
PASEK()
@ 23,0
RETU NIL

****************************************************************************
FUNCTION KART_OK()
if !DIR_EXIST(alltrim(KARTOTEKA)+"#"+subs(_sc,-3,2)) 
  TONE(220,5)
  If QTN("Na dysku nie ma kartoteki "+;
         alltrim(KARTOTEKA)+"#"+subs(_sc,-3,2)+" ! WYJCIE Z PROGRAMU ?")
    close data
    dele file (_sc+"FLAGA") 
    QUIT
  else
    RETU .f.
  endif
else
  RETU .t.
endif
RETURN NIL

******************************************************************************
FUNCTION CONFIG()
local _tex:='۲  KONFIGURACJA SYSTEMU '

cls
@ 0,0 say _tex

if !HA(_haslo)
 retu NIL
endi

_use("CONFIG","E!")
@  1,0 say "Nr identyfikacyjny :    " get ID_FIR pict "@!"
@  2,0 say "Bank firmy :            " get BANK_FIR pict "@!"
@  3,0 say "Nr konta bankowego :    " get KONTO_FIR pict "@!"
@  4,0 say "Siedziba firmy :        " get MIASTO_FIR 
@  5,0 say "Piecztka :             " get PIECZAT1 
@  6,0 say "                        " get PIECZAT2 
@  7,0 say "                        " get PIECZAT3 
@  8,0 say "                        " get PIECZAT4 
@  9,0 say "                        " get PIECZAT5 

@ 17,0 say "Katalog programu :      " get KARTOTEKA pict "@!" ;
                                      valid KART_OK()
/*
@ 18,0 say "Polske znaki (MAZ/LAT/STD) :" get POLSKIE;
                                    vali POLSKIE$"MAZ|LAT|STD|   ";
                                                     pict "@! AAA"
*/
set curs on
read
set curs off

_pieczat1:=  PIECZAT1
_pieczat2:=  PIECZAT2
_pieczat3:=  PIECZAT3
_pieczat4:=  PIECZAT4
_pieczat5:=  PIECZAT5
_id_fir:=   alltrim(ID_FIR)
_bank_fir:=  alltrim(BANK_FIR)
_konto_fir:= alltrim(KONTO_FIR)
_miasto_fir:=alltrim(MIASTO_FIR)
_kartoteka:=  alltrim(KARTOTEKA)
_polskie:=POLSKIE

use
_sc:=_kartoteka+"#"+numer_stan+"\"

if !file(_sc+"PARADRUK.DBF")
  copy file PARADRUK.DBF to (_sc+"PARADRUK.DBF")
  _use(_sc+"PARADRUK","E!")
  inde on WARIANT to (_sc+"PARADRUK")
  use
endif
RETU

******************************************************************************
FUNCTION DATAB_OK(_dd)
RETU _data_blo<_dd

******************************************************************************
FUNCTION ESL_KAT()
local _tex:='۲  EDYCJA SOWNIKA KATALOGW RDOWYCH  '

cls
@ 0,0 say _tex

sele 0
if !_use("SL_KAT","S","ROB"); RETURN NIL; endi
set index to SL_KAT

go top
CPEDIT  POZ: 1,,23,               ;
        DEF: "SL_KAT"             ;
        POZWER: "V1"              ;
        PION: ,,,                 ;
        INDEXY: {}                ;
        EDYCJA: .T.               ;
        DODAWANIE: .t.            ;
        KASOWANIE: .t.            ;
        CZYDODAC:  .t.            ;
        ODTWORZ:.f.;
        SIEC: REKORD

close data
RETURN
*******************************************************************************
FUNCTION ZAOKR(x,m)  // zaokrglenia liczby x do m miejsc po przecinku
RETURN val(str(x,15,m))

*******************************************************************************
FUNCTION LISTA_PLI()        
loca _tex:='۲  LISTA ZBIORW Z DANYMI  ',;
     _pliki, _st, _na,_astru:={},_kropka,_r:= "", _wybor:=1
priv _kat:=" "

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use("SL_KAT","R"); BREAK; endi
set index to SL_KAT
if lastrec()=1.and.!empty(SYMBOL)
  _kat:=SYMBOL
  @ 1,0 say "Katalog : "+_kat
else
  @ 1,0 say "Katalog :" get _kat pict "@! A" ;
      when SLGET("SL_KAT","SL_KAT","V1",1,1,{"symbol"},,.f.);
      vali !empty(_kat).and.SL("SL_KAT","SL_KAT","V1",1,1)
  set curs on; read; set curs off 
  if lastkey()=K_ESC; BREAK; endi
endi

SL_KAT->(dbseek(_kat))
_scie_pli:=alltrim(KATALOG2)
_pliki:=DIRECTORY(_scie_pli+"*.DBF")
close SL_KAT

if len(_pliki)=0
  QKE("Brak zbiorw z danymi do FK !")
  BREAK
endif

aadd(_astru,{"NAZWA","C",8,0})
aadd(_astru,{"DATA","D",8,0})
aadd(_astru,{"CZAS","C",8,0})
aadd(_astru,{"ROZMIAR","N",8,0})
dbcreate(_sc+"PLIKI",_astru)

_use(_sc+"PLIKI","E!")
inde on NAZWA to (_sc+"PLIKI_N") descending
inde on dtos(DATA)+CZAS to (_sc+"PLIKI_D") descending
set inde to  (_sc+"PLIKI_N"), (_sc+"PLIKI_D")

aeval(_pliki,{ |aPrnFile| PLIKI->(dbappend()),;
                          _kropka:=at(".",aPrnFile[F_NAME]),;
                          PLIKI->NAZWA:=subs(aPrnFile[F_NAME],1,_kropka-1),;
                          PLIKI->DATA:=aPrnFile[F_DATE],; 
                          PLIKI->CZAS:=aPrnFile[F_TIME],;
                          PLIKI->ROZMIAR:=aPrnFile[F_SIZE] })
go top

CPEDIT  POZ: 2,,23,               ;
        DEF: "PLIKI"             ;
        POZWER: "V1"              ;
        PION: ,,,              ;
        INDEXY: {"nazwa","data+czas"}                ;
        EDYCJA: .f.               ;
        ODTWORZ:.f.               ;
        AKCJA: _r:=DAJ_PLIK()

if _r<>NIL
  _r:=alltrim(_r)
  _pp:=_scie_pli+_r+".DBF"

  _wybor:=HorizMenu(24,0,"",;
     {"PRZEGLDANIE ","ZAPIS NA DYSKIETK ","SKASOWANIE ","KONIEC"},1)

  @ 24,0

  if _wybor=3.and.HA(_haslo)
      dele file (_pp)
  endi

  if _wybor=1

    sele 0
    if !_use(_pp,"E"); BREAK; endi
    QPC(1)
    index on TYP+dtos(DATA)+NR_DOK to (_sc+"BUF_TY")
    index on TRESC_DKR to (_sc+"BUF_TR")
    index on DEKRET to (_sc+"BUF_DE")

    QPC(0)
    set index to (_sc+"BUF_TY"),(_sc+"BUF_TR"),(_sc+"BUF_DE")

    CPEDIT  POZ: 1,,23,           ;
        DEF: "BUFOR"              ;
        POZWER: "V1"              ;
        PION: ,,,                 ;
        INDEXY: {"typ","tresc","dekret"}   ;
        EDYCJA: .T.               ;
        DODAWANIE: HA(_haslo)     ;
        KASOWANIE: HA(_haslo)     ;
        ODTWORZ:.f.;

    clos data
    dele file (_sc+"BUF_TR.DBF")
    dele file (_sc+"BUF_TY.DBF")
  endi

  if _wybor=2
    *-----------
    _zapis:=.t.
    do while _zapis
      _k:=alltrim("a:\")
      _k:=if(subs(_k,-1,1)="\",subs(_k,1,len(_k)-1),_k)
      if subs(_k,2,1)=":"; _tdysk:= subs(_k,1,1); else; _tdysk:=DISKNAME(); endi
      _ndysk:=ASC(upper(_tdysk))-64 
    
      if !DIR_EXIST(_k) 
        QKE("Nieprawidowa cieka !")
        _zapis:=.f.
      endif
    
      if _zapis.and.filesize(_pp)>diskspace(_ndysk)
        QKE("Za mao miejsca na zapis pliku z danymi dla systemu FK !")
        _zapis:=.f.
      endif
    
      if _zapis
        prevhandler:=errorblock()
        errorblock( { |e| DiskError(e,prevhandler) } )
        BEGIN SEQUENCE
        QPC(1)
        dele file ("a:\"+_r+".DBF")
        copy file (_pp) to ("a:\"+_r+".DBF")
        QPC(0)
        END SEQUENCE
        errorblock(prevhandler)
      endi
    
      if file("a:\"+_r+".DBF")
        QKE("Wykonano zapis pliku z danymi dla systemu FK !")
      else
        QKE("Bd zapisu pliku z danymi dla systemu FK !")
      endif
    
      if _zapis
        exit
      else
        if QTN("Rezygnacja z zapisu danych dla systemu FK ?")
          exit
        else
          _zapis:=.t.
          loop
        endi
      endi
    endd
    *-----------
  endi
endi

END SEQUENCE
close data
dele file  (_sc+"PLIKI.DBF")
dele file  (_sc+"PLIKI_N.NTX")
dele file  (_sc+"PLIKI_D.NTX")
RETU NIL

*******************************************************************************
FUNCTION DISKERROR()
  set curs off
  QKE("Bd zapisu danych !")
  set curs on
RETURN NIL

*******************************************************************************
FUNCTION MAZ_LAT(_s)
local _n,_i
local amaz:=;
      {134,141,145,146,164,162,158,166,167,143,149,144,156,165,163,152,160,161}
local a852:=;
      {165,134,169,136,228,162,152,171,190,164,143,168,157,227,224,151,141,189}
for _i:=1 to len(_s)
  _n:=ascan(amaz,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(a852[_n]))
  endi
next
RETURN _s    

*******************************************************************************
FUNCTION ISO_LAT(_s)
local _n,_i
local aiso:=;   //ISO 8859-2
      {177,230,234,179,241,243,182,188,191,161,198,202,163,209,211,166,172,175}
local a852:=;
      {165,134,169,136,228,162,152,171,190,164,143,168,157,227,224,151,141,189}

for _i:=1 to len(_s)
  _n:=ascan(aiso,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(a852[_n]))
  endi
next
RETURN _s    

*******************************************************************************
FUNCTION MAZ_STD(_s)
local _n,_i
local amaz:=;
      {134,141,145,146,164,162,158,166,167,143,149,144,156,165,163,152,160,161}
local astd:=;
      { 97, 99,101,108,110,111,115,122,122, 65, 67, 69, 76, 78, 79, 83, 90, 90}
for _i:=1 to len(_s)
  _n:=ascan(amaz,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(astd[_n]))
  endi
next
RETURN _s    

*******************************************************************************
FUNCTION LAT_MAZ(_s)
local _n,_i
local amaz:=;
      {134,141,145,146,164,162,158,166,167,143,149,144,156,165,163,152,160,161}
local a852:=;
      {165,134,169,136,228,162,152,171,190,164,143,168,157,227,224,151,141,189}
for _i:=1 to len(_s)
  _n:=ascan(a852,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(amaz[_n]))
  endi
next
RETURN _s    

*******************************************************************************
FUNCTION KONW(_t)
do case
 case _polskie="LAT"
   RETURN _t
 case _polskie="STD"
   RETURN LAT_STD(_t)
endc
RETURN _t

*******************************************************************************
FUNCTION RD()
RETURN NIL

*******************************************************************************
FUNCTION JAKI_PLI()
loca _pliki,_astru:={},_kropka,_sel:=select()

_kat:=" "   // prywatna
_r:=""      // prywatna
_pp:=""     // prywatna

BEGIN SEQUENCE

sele 0
if !_use("SL_KAT","R"); BREAK; endi
set index to SL_KAT
if lastrec()=1.and.!empty(SYMBOL)
  _kat:=SYMBOL
  @ 1,0 say "Katalog : "+_kat
else
  @ 1,0 say "Katalog :" get _kat pict "@! A" ;
      when SLGET("SL_KAT","SL_KAT","V1",1,1,{"symbol"},,.f.);
      vali !empty(_kat).and.SL("SL_KAT","SL_KAT","V1",1,1)
  set curs on; read; set curs off 
  if lastkey()=K_ESC; BREAK; endi
endi

SL_KAT->(dbseek(_kat))
_scie_pli:=alltrim(KATALOG2)
_pliki:=DIRECTORY(_scie_pli+"*.DBF")
close SL_KAT

if len(_pliki)=0
  QKE("Brak zbiorw z danymi do FK !")
  BREAK
endif

aadd(_astru,{"NAZWA","C",8,0})
aadd(_astru,{"DATA","D",8,0})
aadd(_astru,{"CZAS","C",8,0})
aadd(_astru,{"ROZMIAR","N",8,0})
dbcreate(_sc+"PLIKI",_astru)

_use(_sc+"PLIKI","E!")
inde on NAZWA to (_sc+"PLIKI_N") descending
inde on dtos(DATA)+CZAS to (_sc+"PLIKI_D") descending
set inde to  (_sc+"PLIKI_N"), (_sc+"PLIKI_D")

aeval(_pliki,{ |aPrnFile| PLIKI->(dbappend()),;
                          _kropka:=at(".",aPrnFile[F_NAME]),;
                          PLIKI->NAZWA:=subs(aPrnFile[F_NAME],1,_kropka-1),;
                          PLIKI->DATA:=aPrnFile[F_DATE],; 
                          PLIKI->CZAS:=aPrnFile[F_TIME],;
                          PLIKI->ROZMIAR:=aPrnFile[F_SIZE] })
go top
CPEDIT  POZ: 2,,23,               ;
        DEF: "PLIKI"             ;
        POZWER: "V1"              ;
        PION: ,,,              ;
        INDEXY: {"nazwa","data+czas"}                ;
        EDYCJA: .f.               ;
        ODTWORZ:.f.               ;
        AKCJA: _r:=DAJ_PLIK()

END SEQUENCE
CPClos(PLIKI)
CPClos(SL_KAT)

sele (_sel)
if _r<>NIL.and.!empty(_r)
  _pp:=_scie_pli+alltrim(_r)+".DBF"
else
  _pp:=""; _r:=""
endi  

RETURN NIL

*******************************************************************************
FUNCTION AKT_FIR()
local _tex:='۲  AKTUALIZACJA SOWNIKA KONTRAHENTW  ',;
      _pliki,_astru:={},_err:=.t.
priv _kat:=" ",_r:="",_pp:=""

cls
@ 0,0 say _tex

JAKI_PLI()  // ustawia _kat,_r,_pp

BEGIN SEQUENCE

if empty(_pp); BREAK; endi

sele 0
if !_use(_sc_fk+"FIRMY","F"); BREAK; endi
set index to (_sc_fk+"FIRMY_NR"),(_sc_fk+"FIRMY_NA"),;
             (_sc_fk+"FIRMY_AD"),(_sc_fk+"FIRMY_NI")

sele 0
if !_use(_pp,"R","BUFOR"); BREAK; endi

QPC(1)
inkey(1)
do while !eof()

  if empty(NR_KON); skip; loop; endi
 
  sele FIRMY
  if !dbseek(BUFOR->NR_KON)
    appe blan
    repl NR_KON     with BUFOR->NR_KON,;
         NAZWA_KON  with KONW(BUFOR->NAZWA_KON),;
         MIASTO     with KONW(BUFOR->MIASTO),;
         ADRES      with KONW(BUFOR->ADRES),;
         KOD        with BUFOR->KOD,;
         NAZWA_BAN  with KONW(BUFOR->NAZWA_BAN),;
         NAZWA_KON2 with KONW(BUFOR->NAZWA_KON2),;
         KONTO_BAN  with BUFOR->KONTO_BAN,;
         ID_KON     with BUFOR->ID_KON
  endif
  
  sele BUFOR
  skip
enddo
QPC(0)
close BUFOR
close FIRMY
_err:=.f.

END SEQUENCE
clos data

if !_err
  QKE("Wykonano aktualizacj sownika firm !")
endi

RETURN NIL

*******************************************************************************
FUNCTION Z5(_k)
RETURN if(empty(_k).or._k="00000","99999",_k)

*******************************************************************************
*******************************************************************************
FUNCTION DR(d)       // np. 21.02.2002 -> "2002"                            //!
RETURN subs(dtos(d),1,4) 

*******************************************************************************
FUNCTION WIN_LAT(_s)
local _n,_i
static a852:=;
      {165,134,169,136,228,162,152,171,190,164,143,168,157,227,224,151,141,189}
static awin:=;
      {185,230,234,179,241,243,156,159,191,165,198,202,163,209,211,140,143,175}

for _i:=1 to len(_s)
  _n:=ascan(awin,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(a852[_n]))
  endi
next
RETURN _s

*******************************************************************************
FUNCTION NAZWA_KON()
repl all NAZWA with upper(POLE08)
repl all NAZWA with strtran(NAZWA,"  "," ")
repl all NAZWA with strtran(NAZWA,"  "," ")
repl all NAZWA with strtran(NAZWA,"  "," ")
repl all NAZWA with strtran(NAZWA,"  "," ")
repl all NAZWA with strtran(NAZWA,"SP. Z O.O.","SP.Z_O.O.")
repl all NAZWA with strtran(NAZWA,"SP.Z O.O.","SP.Z_O.O.")
repl all NAZWA with strtran(NAZWA,"SPKA Z O.O.","SP.Z_O.O.")
repl all NAZWA with OST(NAZWA),NAZWA_KON with "",NAZWA_KON2 with ""
repl all NAZWA_KON with NAZWA for at("|",NAZWA)=0
repl all NAZWA_KON with subs(NAZWA,1,at("|",NAZWA)-1),;
         NAZWA_KON2 with subs(NAZWA,at("|",NAZWA)+1);
         for at("|",NAZWA)>0
repl all NAZWA_KON with strtran(NAZWA_KON,"SP.Z_O.O.","SP.Z O.O."),;
         NAZWA_KON2 with strtran(NAZWA_KON2,"SP.Z_O.O.","SP.Z O.O.")
RETURN NIL

*******************************************************************************

*******************************************************************************
FUNCTION OST(t)
local n:=rtrim(t),l:=len(rtrim(t))

o:=0
for i:=1 to l
  if subs(n,i,1)==" ".and.i<=36
    o:=i
  endi
next
if o>0.and.l>36
  n:=subs(n,1,o-1)+"|"+subs(n,o+1)
endi
RETURN n

*******************************************************************************
FUNCTION PL(_s)
RETURN uppe(ISO_LAT(_s))

*******************************************************************************
FUNCTION NAZWA_KON2()
repl all NAZWA with upper(hb_utf8tostr(NAZWA_NAB))
repl all NAZWA with strtran(NAZWA,"  "," ")
repl all NAZWA with strtran(NAZWA,"  "," ")
repl all NAZWA with strtran(NAZWA,"  "," ")
repl all NAZWA with strtran(NAZWA,"  "," ")
repl all NAZWA with strtran(NAZWA,"SP. Z O.O.","SP.Z_O.O.")
repl all NAZWA with strtran(NAZWA,"SP.Z O.O.","SP.Z_O.O.")
repl all NAZWA with strtran(NAZWA,"SPKA Z O.O.","SP.Z_O.O.")
repl all NAZWA with OST(NAZWA),NAZWA_KON with "",NAZWA_KON2 with ""
repl all NAZWA_KON with NAZWA for at("|",NAZWA)=0
repl all NAZWA_KON with subs(NAZWA,1,at("|",NAZWA)-1),;
         NAZWA_KON2 with subs(NAZWA,at("|",NAZWA)+1);
         for at("|",NAZWA)>0
repl all NAZWA_KON with strtran(NAZWA_KON,"SP.Z_O.O.","SP.Z O.O."),;
         NAZWA_KON2 with strtran(NAZWA_KON2,"SP.Z_O.O.","SP.Z O.O.")
RETURN NIL

*******************************************************************************
FUNCTION VT(_x,_typ,_c,_d)
local _r:=""
DEFAULT _c TO 12,;
        _d TO 2
do case
  case _typ="N"; _r:=str(_x,_c,_d)
  case _typ="C"; _r:=WIN_LAT(_x)
  case _typ="D"; _r:=dtoc(_x)
  case _typ="L"; _r:=if(_x,"T","F")
  case _typ="U"; _r:=""
endc
RETURN _r

*******************************************************************************
*                                     SKLEP                                   *
*******************************************************************************
FUNCTION LISTA()
local _ftp_open  :="ftp.bafix.pl",;
      _ftp_login :="strona_bafpol",;
      _ftp_pass  :="sBaf_2019",;
      _ftp_path1:="bafpol.pl",;
      _ftp_path2:="zamowienia"
local _axml:={},_linia:=""

dele file LISTA.TXT

_plik:=fcreate("flist.bat")
fwriteln(_plik,"cls")
fwriteln(_plik,"ftp -s:flist.scr")
fclose(_plik)

_plik:=fcreate("flist.scr")
fwriteln(_plik,"open "+_ftp_open)
fwriteln(_plik,_ftp_login)
fwriteln(_plik,_ftp_pass)
fwriteln(_plik,"cd "+_ftp_path1)
fwriteln(_plik,"cd "+_ftp_path2)
fwriteln(_plik,"binary")
fwriteln(_plik,"dir *.xml LISTA.TXT")
fwriteln(_plik,"quit")
fclose(_plik)

RUN  flist.bat >NUL  
dele file flist.scr

if file("LISTA.TXT").and.(_nfile:=FOpen("LISTA.TXT"))>0
  Fseek(_nfile,0,0)
  _ln:=0
  do while FReadLn(_nfile,@_linia,500)
    if ".xml"$_linia.and.":"$_linia
       _linia:=alltrim(subs(_linia,at(":",_linia)+3))
       aadd(_axml,_linia)
    endi
  endd
  FClose(_nfile)
endi

dele file LISTA.TXT

RETURN _axml

*******************************************************************************
FUNCTION WCZYTAJ()
local _ftp_open  :="ftp.bafix.pl",;
      _ftp_login :="strona_bafpol",;
      _ftp_pass  :="sBaf_2019",;
      _ftp_path1:="bafpol.pl",;
      _ftp_path2:="zamowienia"
local _axml:={},_astru:={}

cls
_axml:=LISTA()

sele 0
if !_use(_sc_mv+"TOW","R"); BREAK; endi
set index to (_sc_mv+"TOW_IN")

sele 0
if !_use(_sc_fk+"FIRMY","R"); BREAK; endi
set index to (_sc_fk+"FIRMY_NR"),(_sc_fk+"FIRMY_NA"),;
             (_sc_fk+"FIRMY_AD"),(_sc_fk+"FIRMY_NI")
dbsetorder(4)

sele 0
_astru:={}
dele file (_sc+"EWIZAM.DBF")
aadd(_astru,{"LP        ","N",3,0})
aadd(_astru,{"DATA_ZAM  ","D",8,0})
aadd(_astru,{"KONTO     ","C",5,0})
aadd(_astru,{"NR_KON    ","C",5,0})
aadd(_astru,{"NR_ZAM    ","C",4,0})
aadd(_astru,{"STATUS    ","C",1,0})
aadd(_astru,{"TYP       ","C",1,0})
aadd(_astru,{"INDEKS    ","C",20,0})
aadd(_astru,{"NAZWA_TOW ","C",40,0})
aadd(_astru,{"JM        ","C",4,0})
aadd(_astru,{"ILO_ZAM   ","N",10,3})
aadd(_astru,{"CENA      ","N",9,2})
aadd(_astru,{"OPIS_TOW  ","C",20,0})
aadd(_astru,{"KOD_PAS   ","N",13,0})
aadd(_astru,{"VAT       ","C",2,0})
aadd(_astru,{"CENA_ZAK  ","N",9,2})
aadd(_astru,{"CENA_SPR  ","N",9,2})
aadd(_astru,{"CENA_CEN  ","N",9,2})
aadd(_astru,{"RABAT     ","N",6,1})
aadd(_astru,{"OPIS      ","M",10,0})
aadd(_astru,{"BRAK      ","N",6,0})
aadd(_astru,{"CZAS      ","C",5,0})
aadd(_astru,{"ETAP      ","C",3,0})
aadd(_astru,{"MAGAZYN_PH","C",1,0})
aadd(_astru,{"KURIER    ","C",1,0})
aadd(_astru,{"OPLATA    ","C",1,0})
aadd(_astru,{"ILO_FAK   ","N",10,3})
aadd(_astru,{"SKAN      ","C",3,0})
aadd(_astru,{"PACZKI    ","C",14,0})
aadd(_astru,{"OPE_MAG   ","C",3,0})
aadd(_astru,{"DATA_MAG  ","D",8,0})
aadd(_astru,{"TIME_MAG  ","C",5,0})
aadd(_astru,{"KUPONY    ","C",1,0})
dbcreate(_sc+"EWIZAM.DBF",_astru)

sele 0
if !_use(_sc+"EWIZAM","E"); BREAK; endi


_plik:=fcreate("fread.bat")
fwriteln(_plik,"cls")
fwriteln(_plik,"ftp -s:fread.scr")
fclose(_plik)

_plik:=fcreate("fread.scr")
fwriteln(_plik,"open "+_ftp_open)
fwriteln(_plik,_ftp_login)
fwriteln(_plik,_ftp_pass)
fwriteln(_plik,"cd "+_ftp_path1)
fwriteln(_plik,"cd "+_ftp_path2)
fwriteln(_plik,"binary")
for _i:=1 to len(_axml)
  fwriteln(_plik,"get "+_axml[_i]+" .\POBRANE\"+_axml[_i])
next
fwriteln(_plik,"quit")
fclose(_plik)

RUN  fread.bat >NUL
dele file fread.scr

for _i:=1 to len(_axml)
  if !file(strtran(".\POBRANE\"+_axml[_i],".xml","arc.xml"))

    cls
    QK("Zapis zamwienia "+_axml[_i]+" do systemu fakturowania.")

    CLS    
    XML_TO_EZAM(_axml[_i])

    RenameFile(".\POBRANE\"+_axml[_i],;
               strtran(".\POBRANE\"+_axml[_i],".xml","arc.xml"))
  else
    DeleteFile(".\POBRANE\"+_axml[_i])
  endi
next

_plik:=fcreate("fdele.bat")
fwriteln(_plik,"cls")
fwriteln(_plik,"ftp -s:fdele.scr")
fclose(_plik)

_plik:=fcreate("fdele.scr")
fwriteln(_plik,"open "+_ftp_open)
fwriteln(_plik,_ftp_login)
fwriteln(_plik,_ftp_pass)
fwriteln(_plik,"cd "+_ftp_path1)
fwriteln(_plik,"cd "+_ftp_path2)
fwriteln(_plik,"binary")
for _i:=1 to len(_axml)
  fwriteln(_plik,"delete "+_axml[_i])
next
fwriteln(_plik,"quit")
fclose(_plik)

//RUN  fdele.bat  >NUL
dele file fdele.scr

CPClose(EWIZAM)

QK("KONIEC")

RETURN NIL

*******************************************************************************
FUNCTION XML_TO_EZAM(_xml)
local _astru:={},tdata:="",tnazwa:="",tdigits:="1234567890"
local _idz:="",_reference:="",_message:="",_payment:="",_date:="",;
      _nr_kon:="00000",_idp:=""                                      //23.10.19
local _firstname:="",_lastname:="",_company:="",_vat_number:="",_phone:="",;
      _phone_mobile:="",_address:="",_city:="",_postcode:="",_country:=""


nhandle1:=FOpen(".\POBRANE\"+_xml)
oXmlDoc:= TXmlDocument():new(nhandle1)

oXmlNode1 :=oXmlDoc:findFirst("id")
if !oXmlNode1=NIL.and.!oXmlNode1:cData=NIL
  _idz       :=ISO_LAT(oXmlNode1:cData)
endi

oXmlNode1 :=oXmlDoc:findFirst("reference")
if !oXmlNode1=NIL.and.!oXmlNode1:cData=NIL
  _reference:=ISO_LAT(oXmlNode1:cData)
endi

oXmlNode1 :=oXmlDoc:findFirst("message")
if !oXmlNode1=NIL.and.!oXmlNode1:cData=NIL
  _message  :=ISO_LAT(oXmlNode1:cData)
endi

oXmlNode1 := oXmlDoc:findFirst("payment_method")
if !oXmlNode1=NIL.and.!oXmlNode1:cData=NIL
  _payment:=ISO_LAT(oXmlNode1:cData)
endi
do case                                                              //23.10.19
 case "PRZEL"$upper(_payment); _payment:="PRZELEW"
 case "ODBIO"$upper(_payment); _payment:="POBRANIE"
 othe; _payment:="GOTWKA"
endc

oXmlNode1 := oXmlDoc:findFirst("date_add")
if !oXmlNode1=NIL.and.!oXmlNode1:cData=NIL
  _date:=ISO_LAT(oXmlNode1:cData)
endi

oXmlNode1 := oXmlDoc:findFirst("total_tax_excluded")
if !oXmlNode1=NIL.and.!oXmlNode1:cData=NIL
  _total:=oXmlNode1:cData
endi

_idz:=trans0(val(_idz),4)

sele EWIZAM
appe blan

repl KONTO      with "00099",;
     DATA_ZAM   with stod(strtran(_date,"-")),;
     NR_ZAM     with ltrim(_idz),;
     STATUS     with "A",;
     TYP        with "N",;
     MAGAZYN_PH with "N",;
     KURIER     with "N",;
     OPLATA     with "N",;
     KUPONY     with "N",;
     INDEKS     with "OPIS",;
     NR_KON     with _nr_kon
     
repl OPIS with "00099"+";"+;                             // 1. konto
               strtran(_date,"-")+";"+;                  // 2. data zamwienia
               ltrim(_idz)+";"+;                         // 3. numer zamwienia
               "00000"+";"+;                             // 4. firma
               "0"+";"+;                                 // 5. termin
                padr(strtran(_payment,";",","),8)+";"+;  // 6. patno
                "F"+";"+;                                // 7. faktura
                alltrim(strtran(_message,";",","))+";"+; // 8. uwagi
                "1"+";"+;                                // 9. cennik
                "0.0"+";"+;                              // 10. rabat
                ltrim(_total)+";"+;                      // 11. warto netto
                "P-99"                                   // 12. operator

oXmlNode1 := oXmlDoc:findFirst("delivery_address")
oXmlIter := TXmlIterator():new( oXmlNode1 )
do while .t.
  oXmlNode1:= oXmlIter:next()
  if oXmlNode1=NIL
    exit
  endi
  if !oXmlNode1:cData=NIL.and.!oXmlNode1:cData=NIL
    tnazwa:=oXmlNode1:cName
    tdata :=oXmlNode1:cData
  endi

  do case
    case tnazwa="vat_number"  ;_vat_number  :=tdata
    case tnazwa="firstname"   ;_firstname   :=tdata
    case tnazwa="lastname"    ;_lastname    :=tdata
    case tnazwa="company"     ;_company     :=tdata
    case tnazwa="phone"       ;_phone       :=tdata
    case tnazwa="phone_mobile";_phone_mobile:=tdata
    case tnazwa="address"     ;_address     :=tdata
    case tnazwa="city"        ;_city        :=tdata
    case tnazwa="postcode"    ;_postcode    :=tdata
    case tnazwa="country"     ;_country     :=tdata
  endc
endd

_nip:=alltrim(strtran(strtran(_vat_number,"PL"),"-"))
_nr_kon:="00000"
if !empty(_nip).and.FIRMY->(dbseek(_nip)).and.val(FIRMY->NR_KON)>0
  _nr_kon:=FIRMY->NR_KON
  EWIZAM->NR_KON:=_nr_kon
endi

sele EWIZAM
repl NR_KON     with _nr_kon                                         //23.10.19

appe blan
repl KONTO      with "00099",;
     DATA_ZAM   with stod(strtran(_date,"-")),;
     NR_ZAM     with ltrim(_idz),;
     STATUS     with "A",;
     NR_KON     with _nr_kon,;
     TYP        with "P",;
     ILO_ZAM    with 1.0,;
     ILO_FAK    with 1.0,;
     INDEKS     with "00000",;
     NAZWA_TOW  with "- UWAGI DO ZAMWIENIA -"

repl OPIS with trans0(0,3)+"/UWAGI"+_idp+CRLF+;
               alltrim(ISO_LAT(_message))+CRLF+;
               "Dane adresowe:"+CRLF+;
               "NIP:     "+_vat_number+CRLF+;
               "NAZWA:   "+ISO_LAT(alltrim(_firstname)+" "+alltrim(_lastname))+CRLF+;
               "FIRMA:   "+ISO_LAT(_company)+CRLF+;
               "TELEFON: "+_phone+"  "+_phone_mobile+CRLF+;
               "ADRES:   "+ISO_LAT(_address)+CRLF+;
               "MIASTO:  "+ISO_LAT(_postcode+" "+_city)
  
//? "Produkty:"

oXmlNode1 := oXmlDoc:findFirst("product")
     
_lp:=0
do while oXmlNode1 <> NIL

  EWIZAM->(dbappend())
  _lp+=1

  EWIZAM->KONTO    := "00099"
  EWIZAM->DATA_ZAM := stod(strtran(_date,"-"))
  EWIZAM->NR_ZAM   := ltrim(_idz)
  EWIZAM->STATUS   := "A"
  EWIZAM->NR_KON   := _nr_kon
  EWIZAM->TYP      := "P"

  _reference :=""
  _name      :=""
  _quantity  :=""
  _price_tax_excluded     :=""
  _price_tax_included     :=""
  _idp       :=""                                                    //23.10.19
          
  oXmlIter := TXmlIterator():new( oXmlNode1 )
  do while .t.

    oXmlNode1:= oXmlIter:next()
    if oXmlNode1=NIL
      exit
    endi

    tnazwa:= oXmlNode1:cName
    tdata:= if(oXmlNode1:cData<>NIL,ISO_LAT(oXmlNode1:cData),"")

    if "id"==alltrim(tnazwa)                                         //23.10.19
      _idp:=alltrim(tdata)
    endi

    if "reference"$tnazwa
      _reference:=tdata
    endi

    if "name"$tnazwa
      _name:=tdata
    endi

    if "quantity"$tnazwa
      _quantity:=tdata
    endi

    if "price_tax_excluded"==alltrim(tnazwa)                         //23.10.19
      _price_tax_excluded:=tdata
    endi

    if "price_tax_included"==alltrim(tnazwa)
      _price_tax_included:=tdata
    endi

  endd

  if !empty(_reference)
    TOW->(dbseek(s_i(_reference)))
  else
    TOW->(dbgobottom())
    TOW->(dbskip())
  endi

  EWIZAM->LP:=_lp    
  EWIZAM->INDEKS     :=_reference

  if !empty(_reference)
    EWIZAM->JM         :=TOW->JM
  else
    EWIZAM->JM         :="?"
  endi

  if !empty(EWIZAM->INDEKS).and.!empty(TOW->NAZWA_TOW)               //23.10.19
    EWIZAM->NAZWA_TOW  :=TOW->NAZWA_TOW                             
  else
    EWIZAM->NAZWA_TOW  :=_name
  endi

  EWIZAM->ILO_ZAM    :=val(_quantity)*if(TOW->WSP_S<>0,TOW->WSP_S,1)
  EWIZAM->ILO_FAK    :=val(_quantity)*if(TOW->WSP_S<>0,TOW->WSP_S,1)
  EWIZAM->CENA       :=val(_price_tax_excluded)/if(TOW->WSP_S<>0,TOW->WSP_S,1)
  EWIZAM->CENA_CEN   :=val(_price_tax_excluded)/if(TOW->WSP_S<>0,TOW->WSP_S,1)
  EWIZAM->CENA_SPR   :=val(_price_tax_excluded)/if(TOW->WSP_S<>0,TOW->WSP_S,1)

  EWIZAM->VAT        :=str(zaokr(100*(val(_price_tax_included)-val(_price_tax_excluded))/;
                           val(_price_tax_excluded),2),2)
//@@@
  EWIZAM->OPIS    :=trans0(_lp,3)+"/"+_idp+CRLF+_name+CRLF+;
                  "Sklep: "+alltrim(str(val(_quantity),10,3))+" * "+;
                  alltrim(str(val(_price_tax_excluded),9,2))+" z   "+;
                  if(empty(_reference),;
                  "Hurtownia: ? * ? z   Wsp.: ?",;
                  "Hurtownia: "+alltrim(str(EWIZAM->ILO_ZAM,10,3))+" * "+;
                  alltrim(str(EWIZAM->CENA,9,2))+" z   Wsp.: "+;
                  if(TOW->WSP_S<>0,alltrim(str(TOW->WSP_S,7,3)),"1.000"))
                  
  oXmlNode1 := oXmlDoc:findNext()
endd

Fclose(nhandle1)

RETURN NIL

*******************************************************************************
 