*******************************************************************************
*                             MODUY DLA PLUSSa                               *
*******************************************************************************
#include "comped.ch"
#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"
#define GR_OTWARTA "99"

#include "Directry.ch"
#xtranslate FTell(<fHandle>) => FSeek(<fHandle>, 0, FS_RELATIVE)
#xtranslate :fileHandle   => :cargo\[1\]
#xtranslate :fileLine     => :cargo\[2\]
#xtranslate :lineOffset   => :cargo\[3\]
#define FILE_BRWS_NUM_IVARS 3

#define CR    Chr(13)
#define LF    Chr(10)
#define FF    Chr(12)
#define CRLF  CR + LF

static _tryb_et:="ESC/P",_port_et:="LPT1",_pl_et:="   ",_le_et:=8,_cen_et:=0,;
       _wys_et:=2,_szer_et:=1

static aLevel   := {}   // do inkey()
static nPointer := 1    // do inkey()    

static _data_beg:=NIL, _data_end:=NIL

*******************************************************************************
FUNCTION ESL_WAL()
local _tex:='۲  SOWNIK WALUT  '

cls
@ 0,0 say _tex

sele 0
if .not._use("SL_WAL","E"); RETURN; endi
set index to SL_WAL

go top
CPEDIT  POZ: 1,,23,               ;
        DEF: "SL_WAL"             ;
        POZWER: "V1"              ;
        PION: ,,,                 ;
        INDEXY: {"symbol"}           ;
        EDYCJA: .T.               ;
        DODAWANIE: .T.            ;
        KASOWANIE: .T.            ;
        ODTWORZ:.f.               

dele all for empty(WALUTA)
pack

go top
CPDRUK  DEF: "SL_WAL"                 ;
        WERSJA: "V1"              ;
        TYTUL: "SOWNIK WALUT";
        WARIANT: 23         

close data
RETURN NIL

*******************************************************************************
FUNCTION KURSY()
#ifdef M
 cls; QK("Opcja dostpna w penej wersji programu !"); RETURN NIL
#else
loca _tex:='۲  KURSY WALUT  ',_l,_data_od,_data_do
priv _waluta:=spac(3)

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use("SL_WAL","R"); BREAK; endi
set index to SL_WAL

@ 1,0 say "Waluta :" get _waluta pict "@! AAA";
           when SLGET("SL_WAL","SL_WAL","V1",1,1,{"waluta"},,.f.);
           vali SL("SL_WAL","SL_WAL","V1",1,1)
set curs on; read; SLGET(); set curs off
if lastkey()=K_ESC; BREAK; endi

sele 0
if !_use("KURSY","S"); BREAK; endi
set index to KURSY

FilterBottom(_waluta)
for _l:=1 to 10
  _r:=recn()
  skip -1
  if !WALUTA==_waluta; exit; endi
next
goto _r

CPEDIT  POZ: 2,,23,       ; 
        DEF: "KURSY"      ;
        POZWER: "V1"      ;
        PION: ,,,         ;
        INDEXY: {}        ;
        EDYCJA: .T.       ;
        DODAWANIE: .T.    ;
        KASOWANIE: KASUJ_KUR()  ;
        CZYDODAC: .T.     ;
        WARUNEK: WALUTA==_waluta   ;
        GORA: FilterTop(_waluta)    ;
        DOL:  FilterBottom(_waluta) ;
        DODAJ: DODAJ_KUR(_waluta)   ;
        ODTWORZ: .f.      ;
        SIEC: REKORD

_data_od:=date()-30; _data_do=date()
@ 24,0 say "Wydruk za okres :" get _data_od vali DODATY(_data_od,@_data_do)
@ 24,col()+1 say "-" get _data_do vali _data_od<=_data_do
set curs on; read; SLGET(); set curs off
if lastkey()=K_ESC; BREAK; endi

dbseek(_waluta+dtos(_data_od),.t.)
copy to (_sc+"KURSY_R") while WALUTA+dtos(DATA)<=_waluta+dtos(_data_do)
close KURSY

sele 0
_use(_sc+"KURSY_R","E!")
CPDRUK  DEF: "KURSY"   ;
        WERSJA: "V1"   ;
        TYTUL: "KURSY "+_waluta ;
        WARIANT: 34

END SEQUENCE
dele file (_sc+"KURSY_R.DBF")
clos data
RETURN NIL
#endi

*******************************************************************************
FUNCTION KASUJ_KUR()
local _olddele:=set(_SET_DELETED)

if QTN("SKASOWA WIERSZ ?")
   if  !Blokuj(REKORD); RETURN NIL; endif   
   set(_SET_DELETED,.t.)
   delete
   set(_SET_DELETED,_olddele)
   dbcommit()
   _rec:=eval(_hor:skipblock,1)
   if _rec==0; if !_rest[NINDEX0]
                  _hor:goBottom()
                  if eval(_hor:skipBlock,0)<>0; go bottom; skip
                  endif
               endif
   endif
   _hor:refreshAll()
endif

RETU .F.

*******************************************************************************
FUNCTION DODAJ_KUR(_waluta)
local _p

FilterAppend({_waluta,date()},{"WALUTA","DATA"})
if _rest[NCUR]==_hor    ; _hor: panHome()
else                    ; _vert:goTop()
endif
FilterTop(_waluta)
do while !_rest[NCUR]:stabilize(); enddo
keyboard chr(K_CTRL_PGDN)+chr(K_ENTER)

RETURN NIL

*******************************************************************************
FUNCTION WYKRES_KUR()
#ifdef M
 cls; QK("Opcja dostpna w penej wersji programu !"); RETURN NIL
#else
loca _tex:='۲  WYKRES KURSW WALUT  ',_l,_data_od,_data_do
loca daty[60],znaki[60],kursy[60],min,max,_w
priv _waluta:=spac(3)

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use("SL_WAL","R"); BREAK; endi
set index to SL_WAL

@ 1,0 say "Waluta : " get _waluta pict "@! AAA";
           when SLGET("SL_WAL","SL_WAL","V1",1,1,{"waluta"},,.f.);
           vali SL("SL_WAL","SL_WAL","V1",1,1)
set curs on; read; SLGET(); set curs off
if lastkey()=K_ESC; BREAK; endi

sele 0
if !_use("KURSY","S"); BREAK; endi
set index to KURSY

_data_do=date()
@ 2,0 say "Do dnia :" get _data_do 
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

_data_od=_data_do-59
dbseek(_waluta+dtos(_data_od),.t.)
min=KURS; max=KURS

for _i=1 to 60
  daty[_i]=_data_od-1+_i
  znaki[_i]=if(dow(daty[_i])=2,"|","-")
  @ 18,14+_i say znaki[_i]
  if znaki[_i]="|"
   @ 19,12+_i say subs(dtoc(daty[_i]),1,5)
  endi
  seek _waluta+dtos(daty[_i])
  if !eof()
    kursy[_i]=KURS
    if KURS>max; max=KURS; endi
    if KURS<min; min=KURS; endi
  else
    kursy[_i]=0
  endi
next
for _i=1 to 60
 if max-min<>0
  _w= int(kursy[_i]*10/(max-min)-10*min/(max-min))
 else
  _w=10
 endi
 if kursy[_i]<>0
  @ 17-_w ,15+_i-1 say "+"
 endi
next
@ 17,0 say min pict "@ZE 9999.9999" 
@ 7,0 say max pict "@ZE 9999.9999" 
@ 12,0 say int((max+min)/2) pict "@ZE 9999.9999"
inkey(0)

END SEQUENCE
clos data
RETURN NIL
#endi

*******************************************************************************
FUNCTION EKAL()
#ifdef M
 cls; QK("Opcja dostpna w penej wersji programu !"); RETURN NIL
#else
local _tex:='۲  KALKULACJA CEN TOWARW  ',_opcja:=0,_old_tab,;
      _skad,_astru:={},_data:=date(),apom:={}
priv _nr_mag:=_magazyn,_dok
priv _proc:=0

cls
@ 0,0 say _tex

BEGIN SEQUENCE

if empty(subs(_wersja,62,1))
  QKE("Opcja wymaga ustawienia parametru nr 62 programu.")
  BREAK
endi

DO WHILE .T.
  CLOS DATA
  @ 2,0 clea to 24,79
  _opcja:=0

  sele 0
  if !_use("SL_WAL","E"); BREAK; endi
  set index to SL_WAL

  sele 0
  if !_use("TOW","S"); close data; BREAK; endif
  set index to TOW_IN, TOW_NA, TOW_GR, TOW_SW

  sele 0
  if !_use("TOW_KAL","E"); BREAK; endi
  set index to TKAL_IN, TKAL_NA
  set rela to s_i(INDEKS) into TOW

  do while _opcja<>1
   @ 1,0 clea to 24,79
   _opcja:=1
   _opcja:=HorizMenu(1,0,"",{"EDYCJA","POBRANIE","SKASOWANIE",;
                   "KURSY","KOSZTY","CLO","AKCYZA","MARA","REZERWA","WALUTA"})
   do case
    case _opcja=0; BREAK
    case _opcja=3
      if QTN("Skasowanie arkusza i cen kalkulacyjnych ?").and.HA(_haslo)
  
        sele TOW_KAL; zap
        QKE("Skasowano arkusz kalkulacyjny !")
      endi
    case _opcja=10
      if QTN("Zmiana waluty na pozycjach arkusza kalkulacyjnego ?");
                   .and.HA(_haslo)
        _waluta:="   "
        @ 2,0 say "Waluta :" get _waluta pict "@! AAA";
           when SLGET("SL_WAL","SL_WAL","V1",1,1,{"waluta"},,.f.);
           vali SL("SL_WAL","SL_WAL","V1",1,1)
        set curs on; read; set curs off
        if lastkey()=K_ESC; loop; endi
     
      TOW_KAL->(dbeval({|| TOW_KAL->KURS:=0,TOW_KAL->WALUTA:=_waluta,;
                           KAL_MAR(.f.)}))
        QKE("Wykonano aktualizacj waluty !")
      endi
    case _opcja=9
      if QTN("Aktualizacja rezerwy ?").and.HA(_haslo)
        _proc:=0
        @ 2,0 say "Rezerwa w % :" get _proc pict "@ZE 99.99"
        set curs on; read; set curs off
        if lastkey()=K_ESC; loop; endi
     
      TOW_KAL->(dbeval({|| TOW_KAL->REZERWA:=_proc,KAL_MAR(.f.)}))
        QKE("Wykonano aktualizacj rezerwy !")
      endi
    case _opcja=5
      if QTN("Aktualizacja kosztw ?").and.HA(_haslo)
        _proc:=0
        @ 2,0 say "Koszty w % :" get _proc pict "@ZE 99.99"
        set curs on; read; set curs off
        if lastkey()=K_ESC; loop; endi
   
      TOW_KAL->(dbeval({|| TOW_KAL->KOSZT:=_proc,KAL_MAR(.f.)}))
        QKE("Wykonano aktualizacj kosztw !")
      endi
    case _opcja=6
      if QTN("Aktualizacja ca ?").and.HA(_haslo)
        _proc:=0
        @ 2,0 say "Co w % :" get _proc pict "@ZE 99.99"
        set curs on; read; set curs off
        if lastkey()=K_ESC; loop; endi

        TOW_KAL->(dbeval({|| TOW_KAL->CLO:=_proc,KAL_MAR(.f.)}))
        QKE("Wykonano aktualizacj ca !")
      endi
    case _opcja=7
      if QTN("Aktualizacja akcyzy ?").and.HA(_haslo)
        _proc:=0
        @ 2,0 say "Akcyza w % :" get _proc pict "@ZE 99.99"
        set curs on; read; set curs off
        if lastkey()=K_ESC; loop; endi
       
        TOW_KAL->(dbeval({|| TOW_KAL->AKCYZA:=_proc,KAL_MAR(.f.)}))
        QKE("Wykonano aktualizacj akcyzy !")
      endi
    case _opcja=8
      if QTN("Aktualizacja mary ?").and.HA(_haslo)
        _proc:=0
        @ 2,0 say "Mara w % :" get _proc pict "@ZE 99.99"
        set curs on; read; set curs off
        if lastkey()=K_ESC; loop; endi
        TOW_KAL->(dbeval({|| TOW_KAL->MARZA:=_proc,KAL_CEN(.f.)}))     
        
        QKE("Wykonano aktualizacj mary !")
      endi
    case _opcja=4
      if QTN("Pobranie kursw walut ze sownika ?").and.HA(_haslo)
        _data:=date()
        @ 2,0 say "Data kursu :" get _data
        set curs on; read; set curs off
        if lastkey()=K_ESC; loop; endi
        
        sele 0
        _use("KURSY","R!")
        set index to KURSY

        sele TOW_KAL

        QPC(1)
        dbeval({|| TOW_KAL->KURS:=DAJ_KURS(_data),KAL_MAR(.f.)})
        QPC(0)
        QKE("Uaktualniono kursy walut !")
        
        CPClose(KURSY)
      endi
  case _opcja=2
     _skad:=1
     _skad:=;
         HorizMenu(2,0,"Pobranie danych do arkusza z :",{"PLIKU","DOKUMENTU"})
         @ 2,0
     @ 24,0
     if _skad=2.and.HA(_haslo)   
   
       BEGIN SEQUENCE

       sele 0
       if !_use("SL_DOK","R"); BREAK; endif
       set index to SL_DOK
 
       sele 0
       if !_use("SL_MAG","R"); BREAK; endif
       set index to SL_MAG

       _dok:="  -     /"+_nr_mag+ "/"+_rok
       @ 2,0 say "Dokument (rodzaj/nr/magazyn/rok) : " get _dok ;
             pict "@! AA-99999/999/99"
       set curs on; read; set curs off
       if lastkey()=K_ESC; BREAK; endi
       _nr_mag:=subs(_dok,10,3)
       if empty(_nr_mag).or.!SL_MAG->(dbseek(_nr_mag))
         QKE("Nie ma takiego magazynu !"); BREAK
       endi

       sele SL_DOK
       seek subs(_dok,1,2)
       if eof(); QKE("Nie ma dokumentu "+subs(_dok,1,2)+" !"); BREAK; endi
 
       sele 0
       _zb:="DOK"+_nr_mag+"P"
       _i1:="D"+_nr_mag+"P"+"_NR"
       if !_use(_zb,"R","DOK_P"); BREAK; endi
       set index to (_i1)
       seek subs(_dok,1,2)+subs(_dok,10,3)+ep(subs(_dok,14,2));
           +subs(_dok,4,5)
       if !found(); QKE("Nie ma dokumentu "+;
           subs(_dok,1,2)+"-"+subs(_dok,4,5)+"/"+subs(_dok,10,3)+;
           +"/"+subs(_dok,14,2)+" !")
         use
         BREAK
       endi
       copy to (_sc+"POZ_KAL") while;
          subs(_dok,1,2)+subs(_dok,10,3)+ep(subs(_dok,14,2))+subs(_dok,4,5)==;
          RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK
       use
  
       QPC(1)

       sele 0
       _use(_sc+"POZ_KAL","R")
       TOW_KAL->(dbsetorder(1))
       dbeval({|| if(TOW_KAL->(dbseek(POZ_KAL->INDEKS)),NIL,;
                  (TOW_KAL->(dbappend()),;
                   TOW_KAL->INDEKS:=POZ_KAL->INDEKS,;    
                   TOW_KAL->ILOSC_KAL:=POZ_KAL->ILOSC)) })
       use
       dele file (_sc+"POZ_KAL.DBF")

       sele TOW_KAL
       dbeval({|| KAL_MAR(.f.),TOW_KAL->NAZWA_TOW:=TOW->NAZWA_TOW})
       QPC(0)

       QKE("Pobrano towary wg dokumentu !")
       END SEQUENCE
       CPClos(SL_DOK)
       CPClos(SL_MAG)

     elseif _skad=1.and.HA(_haslo)   

       BEGIN SEQUENCE

       _pliki:=DIRECTORY("*.ARK")
       if len(_pliki)=0
         QKE("Brak zbiorw z danymi !")
         BREAK
       endif
       _astru:={}
       aadd(_astru,{"NAZWA","C",8,0})
       aadd(_astru,{"DATA","D",8,0})
       aadd(_astru,{"CZAS","C",8,0})
       aadd(_astru,{"ROZMIAR","N",8,0})
       dbcreate(_sc+"PLIKI",_astru)
       
       sele 0
       _use(_sc+"PLIKI","E!")
       inde on NAZWA to (_sc+"PLIKI_N")
       inde on dtos(DATA)+CZAS to (_sc+"PLIKI_D")
       set inde to  (_sc+"PLIKI_N"), (_sc+"PLIKI_D")
       aeval(_pliki,{ |aPrnFile| PLIKI->(dbappend()),;
                         _kropka:=at(".",aPrnFile[F_NAME]),;
                         PLIKI->NAZWA:=subs(aPrnFile[F_NAME],1,_kropka-1),;
                         PLIKI->DATA:=aPrnFile[F_DATE],; 
                         PLIKI->CZAS:=aPrnFile[F_TIME],;
                         PLIKI->ROZMIAR:=aPrnFile[F_SIZE] })
       _zbior:=spac(8)
       @ 2,0
       @ 2,0 say "Plik danych :" get _zbior pict "@! XXXXXXXX";
            when SLGET("PLIKI","PLIKI","V1",1,1,{"nazwa","data"},,.f.,BEZBLOK);
            vali SL("PLIKI","PLIKI","V1",1,1);
           .and.filevalid(alltrim(_zbior)+".ark").and.SLGET()
       set curs on; read; set curs off
       if lastkey()=K_ESC; BREAK; endi
       _zbior:=strtran(alltrim(_zbior)," ")+".ARK"

       sele TOW_KAL
       if file (_zbior)

         QPC(1)

         sele 0
         _use(_zbior,"E!","POZ_KAL")
         for i:=1 to fcount(); aadd(apom,i); next
         TOW_KAL->(dbsetorder(1))
         dbeval({|| if(TOW_KAL->(dbseek(POZ_KAL->INDEKS)),NIL,;
                       (RECAPPEND(POZ_KAL,TOW_KAL))) })
         use
         sele TOW_KAL
         dbeval({|| KAL_MAR(.f.),TOW_KAL->NAZWA_TOW:=TOW->NAZWA_TOW})
         QPC(0)

       else
         BREAK
       endi
       QKE("Pobrano arkusz z pliku "+_zbior+" !")      

       END SEQUENCE
     endi
   
     sele TOW_KAL
     @ 2,0 clea to 3,79

    endc
  endd
  @ 1,0

  sele TOW_KAL
  go top
  CPEDIT  POZ: 1,,,                 ;
          DEF: "KAL"                ;
          POZWER: "V1|V_OPISY_TOW()";
          POZSLAD: spac(1)+TOW->INDEKS+"  "+;
                   subs(NAZWA_TOW,1,30)+spac(1)+TOW->OPIS_TOW;
          PION: ,,,                 ;
          INDEXY: {"indeks","nazwa"};
          EDYCJA: .T.               ;   
          DODAWANIE: .T.            ;
          KASOWANIE: .T.            ;
          ODTWORZ:.f.               

  go top
  CPEDIT  POZ: 1,,,                 ;
          DEF: "KAL"                ;
          POZWER: "V1|V_OPISY_TOW()";
          POZSLAD: spac(1)+subs(NAZWA_TOW,1,30)+spac(1)+TOW->OPIS_TOW;
          PION: ,,,                 ;
          INDEXY: {"indeks","nazwa"};
          ODTWORZ:.f.               
  
  CPDRUK  DEF: "KAL"                ;
          WERSJA: "V1|V_OPISY_TOW()";
          TYTUL: "KALKULACJA CEN TOWARW";
          WARIANT: 2
  @ 24,0
  _zapis:=2
  _zapis:=HorizMenu(24,0,"Zapis arkusza kalkulacyjnego :",{"TAK","NIE"},2)
  @ 24,0
  if _zapis=1
    _zbior:=spac(8)
    @ 24,0 say "Nazwa pliku :" get _zbior pict "@! XXXXXXXX";
         vali !" "$alltrim(_zbior).and.filevalid(alltrim(_zbior)+".ark")
    set curs on; read; set curs off
    @ 24,0
    if lastkey()=K_ESC; loop; endi
    _zbior:=alltrim(_zbior)+".ARK"

    if HA(_haslo)
      QPC(1)

      sele TOW_KAL
      set rela to s_i(INDEKS) into TOW
      copy to (_zbior)
      QPC(0)
      QKE("Zapisano arkusz to pliku "+_zbior+" !")
    endi
  endi

ENDD
END SEQUENCE
close data
RETURN NIL
#endi

*******************************************************************************
FUNCTION CENA_IMP(_rez)
local _c

DEFAULT _rez TO 0

if _rez=0
  _c:=CENA_WAL*KURS*(1+CLO/100)*(1+AKCYZA/100)*(1+KOSZT/100)
else
  _c:=CENA_WAL*KURS*(1+_rez/100)*(1+CLO/100)*(1+AKCYZA/100)*(1+KOSZT/100)
endi

RETURN zaokr(_c,2)

*******************************************************************************
FUNCTION IND_KAL()
 
TOW->(dbseek(s_i(TOW_KAL->INDEKS)))
repl TOW_KAL->NAZWA_TOW  with TOW->NAZWA_TOW
KAL_MAR(.t.)
RETU .T.

*******************************************************************************
FUNCTION KAL_MAR(_tabela) 
local _mar:=0,_cena:=0

DEFAULT _tabela TO .t.

_cena:=CENA_IMP(REZERWA)

if CENA_BKAL=0
  repl CENA_BKAL with CENA_NKAL*(1+val(TOW->VAT)/100)
endi

if _cena<>0

  if CENA_BKAL<>0
    if _typ_mar="2"
     _mar:=(CENA_BKAL/(1+val(TOW->VAT)/100)-_cena)/;
            CENA_BKAL/(1+val(TOW->VAT)/100)*100
    else
     _mar:=(CENA_BKAL/(1+val(TOW->VAT)/100)-_cena)/;
                  _cena*100
    endi
    repl MARZA with if(abs(_mar)<999,_mar,0)
  else
    repl MARZA with 0
  endi
else
  repl MARZA with 0
endi
repl CENA_NKAL with CNETTO(CENA_BKAL,TOW->VAT)

if _tabela
  CPSwiezyRekord()
endi
RETU .T.

*******************************************************************************
FUNCTION KAL_CEN(_tabela)
local _mar:=MARZA,_cena:=0,_cen:=0

DEFAULT _tabela TO .t.

_cena:=CENA_IMP(REZERWA)
if _typ_mar="2"
  _cen:=if(_mar<>100,_cena/(1-_mar/100),0)
else
  _cen:=_cena*(1+_mar/100)
endi
repl CENA_BKAL with _cen*(1+val(TOW->VAT)/100)
repl CENA_NKAL with CNETTO(CENA_BKAL,TOW->VAT)

if _tabela
  CPSwiezyRekord()
endi
TOW->(dbunlock())
RETU .T.

*******************************************************************************
FUNCTION CNETTO(_b,_s)
RETURN zaokr(100*_b/(100+val(_s)),2)

*******************************************************************************
FUNCTION CVAT(_b,_s)
RETURN zaokr(val(_s)*_b/(100+val(_s)),2)

*******************************************************************************
FUNCTION CNET_CBRU()
repl CENA_BKAL with CENA_NKAL*(1+val(TOW->VAT)/100)
CPSwiezyRekord()
RETURN .T.

*******************************************************************************
FUNCTION DAJ_KURS(_data)
KURSY->(dbseek(WALUTA+dtos(_data),.t.))
if WALUTA==KURSY->WALUTA.and._data=KURSY->DATA
  RETURN KURSY->KURS
endi
KURSY->(dbskip(-1))
if WALUTA==KURSY->WALUTA
  RETURN KURSY->KURS
endi
RETURN 0

*******************************************************************************
*******************************************************************************
FUNCTION CREA_ZAPIS()
local   _astru:={}

aadd(_astru,{"DATA_DOK"  ,"D", 8, 0})      
aadd(_astru,{"NR_KON"  ,  "C",5,  0})      
aadd(_astru,{"NAZWA_KON" ,"C",60, 0})      
aadd(_astru,{"WART_ZAP" , "N",12, 2})      
if subs(_wersja,77,1)$"Bb"
  aadd(_astru,{"POZYCJA",   "C",3,0  })
else
  aadd(_astru,{"POZYCJA",   "C",2,0  })
endi
aadd(_astru,{"ZNACZNIK",   "C",5,0  })
aadd(_astru,{"NR_DOK",     "C",5,0  })
aadd(_astru,{"OPERATOR",   "C",3,0  })
aadd(_astru,{"SYMBOL_ZAM", "C",10,0  })
aadd(_astru,{"DATA_ZAM",   "D", 8,0  })
aadd(_astru,{"WART_NET0 ","N",12,2})
aadd(_astru,{"WART_NET1 ","N",12,2})
aadd(_astru,{"WART_NET2 ","N",12,2})
aadd(_astru,{"WART_NET_ ","N",12,2})
aadd(_astru,{"WART_VAT1 ","N",12,2})
aadd(_astru,{"WART_VAT2 ","N",12,2})
aadd(_astru,{"WART_NET3 ","N",12,2})
aadd(_astru,{"WART_VAT3 ","N",12,2})
aadd(_astru,{"WART_NET4 ","N",12,2})
aadd(_astru,{"WART_VAT4 ","N",12,2})
aadd(_astru,{"UWAGI"    , "C",40,2})                                 //01.06.07
aadd(_astru,{"UWAGI2"  , "C",152,0})                                 //01.06.07
aadd(_astru,{"PACZKI"   , "C",40,0})                          //17.09.18 BAFPOL
aadd(_astru,{"OPE_MAG"  , "C", 3,0})                                
aadd(_astru,{"DATA_MAG" , "D", 8,0})
aadd(_astru,{"TIME_MAG" , "C", 5,0})
aadd(_astru,{"ETAP"     , "C", 3,0})                          //16.03.14 BAFPOL
aadd(_astru,{"FIRANY"   , "M",10,0})                          //12.09.14 BAFPOL
dbcreate ((_sc+"ZAPIS_R"),_astru)                                    //03.03.14

RETU NIL
  
*******************************************************************************
FUNCTION CREA_KOR_P_R()
local   _astru:={}

aadd(_astru,{"INDEKS"     ,"C",LENIN, 0})
aadd(_astru,{"CENA_ZAK"   ,"N",12, 2})      
aadd(_astru,{"DATA_DOS"   ,"D", 8, 0})      
aadd(_astru,{"NAZWA_TOW"  ,"C",max(40,_len_naz), 0})      
aadd(_astru,{"OPIS_TOW"   ,"C",max(20,_len_opi), 0})      
aadd(_astru,{"VAT"        ,"C", 2, 0})      
aadd(_astru,{"SWW"        ,"C", 8, 0})      
aadd(_astru,{"JM"         ,"C", 4, 0})      
aadd(_astru,{"OPAKOWANIE" ,"N", 5, 1})      
aadd(_astru,{"ILOSC"      ,"N",12, 3})      
aadd(_astru,{"ILOSC_O"    ,"N",12, 3})      
aadd(_astru,{"CENA_SPR"   ,"N",12, 2})      
aadd(_astru,{"CENA_SPR_O" ,"N",12, 2})      
aadd(_astru,{"CENA_DET"   ,"N",12, 2})      
aadd(_astru,{"CENA_DET_O" ,"N",12, 2})      
aadd(_astru,{"CENA_WAL"   ,"N",12, 2})      
aadd(_astru,{"CENA_WAL_O" ,"N",12, 2})      
dbcreate ((_sc+"KOR_P_R"),_astru)

RETU NIL

*******************************************************************************
FUNCTION CREA_KOR_U_R()
local   _astru:={}

aadd(_astru,{"INDEKS"     ,"C",LENIN, 0})
aadd(_astru,{"TRESC"   ,   "C",50, 0})      
aadd(_astru,{"CENA_ZAK"   ,"N", 9, 2})      
aadd(_astru,{"VAT"        ,"C", 2, 0})      
aadd(_astru,{"SWW"        ,"C", 8, 0})      
aadd(_astru,{"JM"         ,"C", 4, 0})      
aadd(_astru,{"ILOSC"      ,"N",12, 3})      
aadd(_astru,{"ZNAK"       ,"N",2, 0})      
aadd(_astru,{"CENA_SPR"   ,"N",9, 2})      
aadd(_astru,{"CENA_WAL"   ,"N",9, 2})                                //19.06.06
aadd(_astru,{"BONIFIKATA" ,"N",12, 2})      
dbcreate ((_sc+"KOR_P_R"),_astru)

RETU NIL

*******************************************************************************
FUNCTION DKAU(rodzaj)                                                //05.01.04
local _astru:={},_tio,_tiz,_rto,_ekran,_wart:=0,_mag:="   ",_kon:=spac(5),;
      _ser:="15",_ile_wn:=0  //JOT_L
priv _bez_kau:=.t.

sele 0
_use("TOW","R!")
set index to TOW_IN

sele 0
_use(_sc+"SPR_N_R","E!","NAG")    // przy wywolaniu funkcji jest to 1 rekord
_mag:=NR_MAG
_kon:=NR_KON

sele 0
_use(_sc+"SPR_P_R","E!","POZ")
set rela to s_i(INDEKS) into TOW

dele file (_sc+"KAU_I.NTX")
dele file (_sc+"KAU.DBF")

_astru:={}
aadd(_astru,{"INDEKS"     ,"C",LENIN, 0})      
aadd(_astru,{"OPAKOWANIE" ,"N", 5, 1})      
aadd(_astru,{"CENA_SPR"   ,"N",12, 2})      
aadd(_astru,{"WYDANIE"    ,"N",12, 3})      
aadd(_astru,{"ZWROT"      ,"N",12, 3})      
aadd(_astru,{"NR_MAG"     ,"C", 3, 0})      
aadd(_astru,{"WINIEN"     ,"N",12, 3})      
dbcreate ((_sc+"KAU"),_astru)
 
sele 0
_use(_sc+"KAU","E!")
index on s_i(INDEKS) to (_sc+"KAU_I")

sele POZ
go top
do while .not.eof()
  _rto:=TOW->(recn())
  _tio:=s_i(TOW->INDEKS_O)
  if !_tio==s_i(spac(LENIN))
    if !(KAU->(dbseek(_tio)))
      KAU-> (dbappend())
      repl KAU->INDEKS with TOW->INDEKS_O
      TOW->(dbseek(_tio))     
      do case 
        case subs(_wersja,14,1)="1"; repl KAU->CENA_SPR with ;
           iif(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="2"; repl KAU->CENA_SPR with ;
           iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="3"; repl KAU->CENA_SPR with ;
           iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
      endc
      TOW->(dbgoto(_rto))
    endi
    repl KAU->WYDANIE with KAU->WYDANIE+POZ->ILOSC
    _wart:=_wart+KAU->CENA_SPR*POZ->ILOSC                            //29.07.02
  endi        

  _tiz:=s_i(TOW->INDEKS_Z)
  if !_tiz==s_i(spac(LENIN)) .and. max(TOW->OPAKOWANIE,0) >0     
    if !(KAU->(dbseek(_tiz)))
      KAU-> (dbappend())
      repl KAU->INDEKS with TOW->INDEKS_Z,;
           KAU->OPAKOWANIE with max(TOW->OPAKOWANIE,0)
      TOW->(dbseek(_tiz))     
      do case 
        case subs(_wersja,14,1)="1"; repl KAU->CENA_SPR with ;
           iif(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="2"; repl KAU->CENA_SPR with ;
           iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="3"; repl KAU->CENA_SPR with ;
           iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
      endc
      TOW->(dbgoto(_rto))
    endi
    repl KAU->WYDANIE with KAU->WYDANIE+POZ->ILOSC/max(TOW->OPAKOWANIE,0)
    _wart:=_wart+KAU->CENA_SPR*(POZ->ILOSC/max(TOW->OPAKOWANIE,0))   //29.07.02
  endi        

  sele POZ
  skip
endd

dele file (_sc+"SPR_O_R.DBF")

sele 0
_ile_wn:=0
if ZOPA_N(_kon,"15",,).and.file(_sc+"SPR_O_R.DBF")             
  _use(_sc+"SPR_O_R","R!")
  go top
  do while !eof()
    if SPR_O_R->ILOSC=0; skip; loop; endi
    _ile_wn+=abs(SPR_O_R->ILOSC)

    if KAU->(!dbseek(s_i(SPR_O_R->INDEKS)))
      KAU-> (dbappend())
      repl KAU->INDEKS with SPR_O_R->INDEKS
    endi
    repl KAU->WINIEN with KAU->WINIEN+SPR_O_R->ILOSC
    skip
  endd
endi
CPClose(SPR_O_R)
* dele file (_sc+"SPR_O_R.DBF")

_ekran:=savescreen(7,0,24,79) 
@ 7,0 clea to 24,79 

sele KAU
set rela to s_i(INDEKS) into TOW
@ 23,0 say "Warto wydanych opakowa : "+transform(_wart,_format_war)
go top
CPEDIT  POZ: 7,,22,               ;
        DEF: "SKAU"               ;
        POZWER: if(_ile_wn=0,"V1","V3")  ;
        PION: ,,,                 ;
        INDEXY: {"indeks"}        ;
        EDYCJA: .T.               ;
        ODTWORZ:.F.

set filt to WYDANIE<>0.or.WINIEN<>0
go top
   CPDRUK  DEF: "SKAU"            ;
           WERSJA: if(_ile_wn=0,"V1","V3")  ;
           WARIANT: 19            ;
           TYTUL : "SPECYFIKACJA OPAKOWA do "+rodzaj+;
                 " "+NAG->NR_DOK+"/"+NAG->SERIA_FAK+"/"+RE(NAG->ROK_DOK)+ ;
                " z " +dtoc(NAG->DATA_DOK) ;         
           STOPKA: STO_SKAU(_wart)     ;    
        OPERATOR: NAG->OPERATOR

restscreen(7,0,24,79,_ekran)
close data
dele file (_sc+"KAU.DBF")
dele file (_sc+"KAU_I.NTX")
RETURN NIL

*******************************************************************************
FUNCTION DKAU_D(rodzaj,linia)                                            //@//
local _astru:={},_tio,_tiz,_rto,_ekran,_osele:=select(),_jatow:=.f.,_wart:=0,;
      _mag:=""

if select("TOW")=0
  _jatow:=.t.

  sele 0
  _use("TOW","R!")
  set index to TOW_IN
endif

sele DOKP_R
set rela to s_i(INDEKS) into TOW
dele file (_sc+"KAU_I.NTX")
dele file (_sc+"KAU.DBF")

_astru:={}
aadd(_astru,{"INDEKS"     ,"C",LENIN, 0})      
aadd(_astru,{"OPAKOWANIE" ,"N", 5, 1})      
aadd(_astru,{"CENA_SPR"   ,"N",12, 2})      
aadd(_astru,{"WYDANIE"    ,"N",12, 3})      
aadd(_astru,{"ZWROT"      ,"N",12, 3})      
aadd(_astru,{"NR_MAG"     ,"C", 3, 0})      
dbcreate ((_sc+"KAU"),_astru)

sele 0
_use(_sc+"KAU","E!")
index on s_i(INDEKS) to (_sc+"KAU_I")

sele DOKP_R
go top
do while .not.eof()
  _rto:=TOW->(recn())
  _tio:=s_i(TOW->INDEKS_O)
  if !_tio==s_i(spac(LENIN))
    if !(KAU->(dbseek(_tio)))
      KAU-> (dbappend())
      repl KAU->INDEKS with TOW->INDEKS_O
      TOW->(dbseek(_tio))     
      do case 
        case subs(_wersja,14,1)="1"; repl KAU->CENA_SPR with ;
           iif(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="2"; repl KAU->CENA_SPR with ;
           iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="3"; repl KAU->CENA_SPR with ;
           iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
      endc
      TOW->(dbgoto(_rto))
    endi
    repl KAU->WYDANIE with KAU->WYDANIE+DOKP_R->ILOSC
    _wart:=_wart+KAU->CENA_SPR*DOKP_R->ILOSC                         //29.07.02
  endi        

  _tiz:=s_i(TOW->INDEKS_Z)
  if !_tiz==s_i(spac(LENIN)) .and. TOW->OPAKOWANIE >0     
    if !(KAU->(dbseek(_tiz)))
      KAU-> (dbappend())
      repl KAU->INDEKS with TOW->INDEKS_Z,;
           KAU->OPAKOWANIE with max(TOW->OPAKOWANIE,0)
      TOW->(dbseek(_tiz))     
      do case 
        case subs(_wersja,14,1)="1"; repl KAU->CENA_SPR with ;
           iif(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="2"; repl KAU->CENA_SPR with ;
           iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="3"; repl KAU->CENA_SPR with ;
           iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
      endc
      TOW->(dbgoto(_rto))
    endi
    repl KAU->WYDANIE with KAU->WYDANIE+DOKP_R->ILOSC/max(TOW->OPAKOWANIE,0)
    _wart:=_wart+KAU->CENA_SPR*(DOKP_R->ILOSC/max(TOW->OPAKOWANIE,0))//29.07.02
  endi        

  sele DOKP_R
  skip
endd

_ekran:=savescreen(linia+3,0,24,79) 
@ linia+3,0 clea to 24,79 

sele KAU
set rela to s_i(INDEKS) into TOW
@ 23,0 say "Warto wydanych opakowa : "+transform(_wart,_format_war)
go top
CPEDIT  POZ: linia+3,,22,            ;
        DEF: "SKAU"                ;
        POZWER: "V1"              ;
        PION: ,,,                 ;
        INDEXY: {"indeks"}        ;
        EDYCJA:.t. ;
        ODTWORZ:.f.

set filt to WYDANIE<>0
go top
CPDRUK  DEF: "SKAU"            ;
        WERSJA: "V1"              ;
        WARIANT: 19                ;
        TYTUL : "SPECYFIKACJA OPAKOWA do "+rodzaj+  ;
               " "+DOKN_R->NR_DOK+"/"+DOKN_R->NR_MAG+"/"+;
               RE(DOKN_R->ROK_DOK)+" z " +dtoc(DOKN_R->DATA_DOK) ;
        STOPKA: STO_SKAU(_wart)     ;    
        OPERATOR: DOKN_R->OPERATOR

restscreen(linia+3,0,24,79,_ekran)
dele file (_sc+"KAU.DBF")
dele file (_sc+"KAU_I.NTX")

sele DOKP_R
set rela to

if _jatow
  close TOW
endif
close KAU
sele (_osele)
RETURN NIL

******************************************************************************
FUNCTION WAR_KAU()                                                       //@//
local _rk:=recn(),_x:=row(),_y:=col(),_w:=0
sum WYDANIE*CENA_SPR to _w
@ 23,0 say "Warto wydanych opakowa : "+transform(_w,_format_war)
go _rk
devpos(_x,_y)
RETURN .T.

******************************************************************************
FUNCTION STO_SKAU(_wart)                                                  //@//
local _t,_k
@ prow()+1, 0 say "Warto opakowa wydanych :   "+;
                               transform(_wart,_format_war)+" z"

_t:="Sporzdzi :                  Opakowania wyda/przyj :      Potwierdzenie zgodnoci :"
_k:="........................      ..........................      ........................."

@ prow()+2,max(0,int((rmarg-len(_t))/2)) say _t                     //10.09.02
@ prow()+2,max(0,int((rmarg-len(_t))/2)) say _k
RETURN NIL

******************************************************************************
FUNCTION UTKAU()                                                         //@//
local _astru:={},_tio,_tiz,_rto,_ekran,_wart:=0

sele 0
_use("TOW","R!")
set index to TOW_IN

sele 0
_use(_sc+"SPR_N_R","E!","NAG")    // przy wywolaniu funkcji jest to 1 rekord

sele 0
_use(_sc+"SPR_P_R","E!","POZ")
set rela to s_i(INDEKS) into TOW


_astru:={}
aadd(_astru,{"INDEKS",    "C",LENIN ,0})      
aadd(_astru,{"CENA_SPR",  "N",9,  2})      
aadd(_astru,{"NR_MAG",    "C",3,  0})      
aadd(_astru,{"NR_KON",    "C",5,  0})      
aadd(_astru,{"WYDANIE",   "N",10 ,0})
aadd(_astru,{"ZWROT",     "N",10 ,0})
aadd(_astru,{"WPLATA",    "N",10 ,0})
aadd(_astru,{"WYPLATA",   "N",10 ,0})
dbcreate (_sc+"DKAU.DBF",_astru)

sele 0
_use(_sc+"DKAU","E!")
index on s_i(INDEKS) to (_sc+"DKAU_I")

sele POZ
go top
do while .not.eof()
  _rto:=TOW->(recn())
  _tio:=s_i(TOW->INDEKS_O)
  if !_tio==s_i(spac(LENIN))
    if !(DKAU->(dbseek(_tio)))
      DKAU-> (dbappend())
      repl DKAU->INDEKS with TOW->INDEKS_O
      TOW->(dbseek(_tio))     
      repl DKAU->NR_KON with NAG->NR_KON,;
           DKAU->NR_MAG with NAG->NR_MAG
      do case 
        case subs(_wersja,14,1)="1"; repl DKAU->CENA_SPR with ;
           iif(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="2"; repl DKAU->CENA_SPR with ;
           iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="3"; repl DKAU->CENA_SPR with ;
           iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
      endc
      TOW->(dbgoto(_rto))
    endi
    repl DKAU->WYDANIE with DKAU->WYDANIE+POZ->ILOSC
  endi        

  _tiz:=s_i(TOW->INDEKS_Z)
  if !_tiz==s_i(spac(LENIN)) .and. TOW->OPAKOWANIE >0     
    if !(DKAU->(dbseek(_tiz)))
      DKAU-> (dbappend())
      repl DKAU->INDEKS with TOW->INDEKS_Z
      TOW->(dbseek(_tiz))     
      repl DKAU->NR_KON with NAG->NR_KON,;
           DKAU->NR_MAG with NAG->NR_MAG
      do case 
        case subs(_wersja,14,1)="1"; repl DKAU->CENA_SPR with ;
           iif(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="2"; repl DKAU->CENA_SPR with ;
           iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="3"; repl DKAU->CENA_SPR with ;
           iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
      endc
      TOW->(dbgoto(_rto))
    endi
    repl DKAU->WYDANIE with;
         DKAU->WYDANIE+POZ->ILOSC/max(TOW->OPAKOWANIE,0)
  endi        

  sele POZ
  skip
endd
close data
RETURN NIL

*******************************************************************************
FUNCTION CREA_ZAPDOK()
local  _astru:={}
aadd(_astru,{"DATA_DOK"  ,"D", 8, 0})      
aadd(_astru,{"NR_KON"  ,  "C", 5, 0})      
aadd(_astru,{"OPERATOR"  ,"C", 3, 0})      
aadd(_astru,{"UWAGI"  ,   "C",40, 0})      
aadd(_astru,{"WART_ZAK" , "N",12, 2})      
aadd(_astru,{"WART_NET_" , "N",12, 2})      
aadd(_astru,{"WART_NET0" , "N",12, 2})      
aadd(_astru,{"WART_NET1" , "N",12, 2})      
aadd(_astru,{"WART_NET2" , "N",12, 2})      
aadd(_astru,{"WART_NET3" , "N",12, 2})      
aadd(_astru,{"WART_NET4" , "N",12, 2})      
aadd(_astru,{"WART_VAT1" , "N",12, 2})      
aadd(_astru,{"WART_VAT2" , "N",12, 2})      
aadd(_astru,{"WART_VAT3" , "N",12, 2})      
aadd(_astru,{"WART_VAT4" , "N",12, 2})      
aadd(_astru,{"DO_MAG"    , "C", 3, 0})      
aadd(_astru,{"NR"        , "C", 2, 0})      
aadd(_astru,{"FIRANY"    , "M",10, 0})                        //12.09.14 BAFPOL
dbcreate ((_sc+"ZAPIS_R"),_astru)
RETU NIL

*******************************************************************************
FUNCTION CREA_PLIDO()
local _astru:={}
aadd(_astru,{"NAZWA","C",12,0})
aadd(_astru,{"DATA","D",8,0})
aadd(_astru,{"CZAS","C",8,0})
aadd(_astru,{"ROZMIAR","N",8,0})
aadd(_astru,{"NR_KON","C",5,0})
aadd(_astru,{"DOKUMENT","C",12,0})

aadd(_astru,{"NAZWA_KON","C",40,0})                                //30.06.03
aadd(_astru,{"DATA_DOK","D",40,0})
aadd(_astru,{"WART_ZAK","N",12,2})
dbcreate(_sc+"PLIDOK",_astru)
RETU NIL

*******************************************************************************
FUNCTION CREA_BDOK()
local _astru:={}
*----- 
aadd(_astru,{"NR_MAG", "C",3,0})
aadd(_astru,{"NAZWA_MAG", "C",30,0})
aadd(_astru,{"RODZAJ_DOK", "C",2,0})
aadd(_astru,{"NAZWA_DOK","C",30 ,0})
aadd(_astru,{"TYP_DOK","C",1 ,0})
aadd(_astru,{"WART_PRZYJ","N",12 ,2})  // przyjcia
aadd(_astru,{"WART_WYD","N",12,2})     // wydania
aadd(_astru,{"KOLEJNOSC","C",1,0})     // do ustawienia
DbCreate(_sc+"BDOK_R",_astru)
RETU NIL
  
*******************************************************************************
FUNCTION CREA_DOKPR(_i)
local _astru:={}

DEFAULT _i TO .f.

aadd(_astru,{"KONTO1"  ,   "C",36, 0})      
aadd(_astru,{"KONTO2"  ,   "C",36, 0})      
if _i
  aadd(_astru,{"INDEKS"     ,"C",LENIN, 0})      
endi
aadd(_astru,{"CENA_ZAK" ,  "N",12, 2})      
aadd(_astru,{"ILOSC"      ,"N",12, 3})      
aadd(_astru,{"KWOTA"      ,"N",12, 2})      
aadd(_astru,{"DATA_DOK"   ,"D", 8, 0})      
aadd(_astru,{"ROK_DOK"    ,"C", 4, 0})      //!
aadd(_astru,{"RODZAJ_DOK" ,"C", 2, 0})
aadd(_astru,{"NR_MAG" ,    "C", 3, 0})
aadd(_astru,{"NR_DOK" ,    "C", 5, 0})
dbcreate (_sc+"DOKP_R",_astru)
RETU NIL

*******************************************************************************
/*
22.10.99 - wersja dla LEKS CASH&CARRY 
           UWAGA _LICZBA_STA=2 ALE PROGRAM MUSI BYC
           INSTALOWANY NA KAZDYM KOMPUTERZE
         - dla wydruku 9 par etykiet 
Program drukuje etykiety na papierze 12" - 18 etykiet :
2 kolumny x 8 wierszy. Etykieta ma wymiar 105x32 mm.
Drukarka w trybie ESC/P i ustawiona skip over perforation - off
jesli jest skip over perforation - on to 16 etykiet (patrz linia 430) na FX1050
*/

*ESC/P :
#define PICC_E chr(18)+chr(27)+chr(80)+chr(15)  // pica condensed
#define RESE_E chr(27)+chr(64)          // reset
#define DET_E1 chr(27)+chr(57)          // detektor papieru
#define DET_E0 chr(27)+chr(56) 
#define DOU_E1 chr(27)+chr(71)          // double strike
#define DOU_E0 chr(27)+chr(72)
#define HEI_E1 chr(27)+chr(119)+chr(49) // double height     
#define HEI_E0 chr(27)+chr(119)+chr(48)
#define WID_E1 chr(27)+chr(87)+chr(49)  // double width
#define WID_E0 chr(27)+chr(87)+chr(48)
#define EMP_E1 chr(27)+chr(69)          // emphasized 
#define EMP_E0 chr(27)+chr(70) 

*IBM
#define PICC_I chr(18)+chr(15)         // pica condensed

#define RESE_H chr(27)+"E"              // reset
#define ORIP_H chr(27)+"&l0O"          // portret
#define SPAF_H chr(27)+"(s0P"          // spacing fixed
#define SPAP_H chr(27)+"(s1P"          // spacing proporcjonal

#define PICC_H chr(27)+"(s16.67H"      // pica condensed
#define DOU_H1 chr(27)+"(s3B"          // double strike (bold)
#define DOU_H0 chr(27)+"(s0B" 
#define HEI_H1 chr(27)+"(s24V"         // double height ?
#define HEI_H0 chr(27)+"(s12V"
#define WID_H1 chr(27)+"(s5.0H"        // double width pica    
#define WID_H0 chr(27)+"(s10.0H"
#define EMP_H1 chr(27)+"(s3B"          // emphasized (bold)
#define EMP_H0 chr(27)+"(s0B"  

#define SEMI_BOLD  "(s1B"

#define COUR_11      chr(27)+chr(40)+chr(115)+chr(51)+chr(84)+;
                     chr(27)+chr(40)+chr(115)+"11.0"+chr(86)
#define COUR_12      chr(27)+chr(40)+chr(115)+chr(51)+chr(84)+;
                     chr(27)+chr(40)+chr(115)+"12.0"+chr(86)
#define COUR_13      chr(27)+chr(40)+chr(115)+chr(51)+chr(84)+;
                     chr(27)+chr(40)+chr(115)+"13.0"+chr(86)
#define COUR_14      chr(27)+chr(40)+chr(115)+chr(51)+chr(84)+;
                     chr(27)+chr(40)+chr(115)+"14.0"+chr(86)
#define COUR_15      chr(27)+chr(40)+chr(115)+chr(51)+chr(84)+;
                     chr(27)+chr(40)+chr(115)+"15.0"+chr(86)
#define COUR_16      chr(27)+chr(40)+chr(115)+chr(51)+chr(84)+;
                     chr(27)+chr(40)+chr(115)+"16.0"+chr(86)
#define COUR_18      chr(27)+chr(40)+chr(115)+chr(51)+chr(84)+;
                     chr(27)+chr(40)+chr(115)+"18.0"+chr(86)
#define COUR_20      chr(27)+chr(40)+chr(115)+chr(51)+chr(84)+;
                     chr(27)+chr(40)+chr(115)+"20.0"+chr(86)
#define COUR_23      chr(27)+chr(40)+chr(115)+chr(51)+chr(84)+;
                     chr(27)+chr(40)+chr(115)+"23.0"+chr(86)
#define COUR_24      chr(27)+chr(40)+chr(115)+chr(51)+chr(84)+;
                     chr(27)+chr(40)+chr(115)+"24.0"+chr(86)


*******************************************************************************
FUNCTION WYDRUK_ET()                                                 //24.10.99
*---------------------------------------------------------- slownik operatorow 
loca _tex:='۲  WYDRUK ETYKIET ',_tc1:="",_plus:=70,;
     _nc1:=0,_nc2:=0,_selekcja:=.f.,;
     _k1,_k2,_rok:=year(date()),_tcb1,_tcb2
loca prevhandler:=errorblock(), _mag:=_magazyn
local _nc13:=0,_in3:="",_na3:="",_kp3:="",_jm1:="",_jm2:="",_jm3:=""
local _astru:={},_i,apom:={},_lcen

priv _st_mag:="   ",_cc:="     ",_cc_d:=ctod("")
priv _cen_et_priv
if _cen_et=0; _cen_et:=max(1,val(_cennik_spr)); endi

if _pl_et="   "
  if upper(chr(145))=chr(144) //900
    _pl_et:="MAZ"
  elseif upper(chr(169))=chr(168) //852
    _pl_et:="LAT"
  endi
endi

cls
@ 0,0 say _tex

@ 1,0 say "Port :" get _port_et pict "@! LPT9" vali _port_et$"LPT1,LPT2,LPT3,LPT4"
@ 1,col()+3 say "Tryb drukarki (ESC/P,IBM,HPPCL) :" get _tryb_et pict "@! AAAXA";
            vali _tryb_et="ESC/P".or._tryb_et="HPPCL".or._tryb_et="IBM"
@ 1,col()+2 say "Znaki (MAZ,LAT,STD) :" get _pl_et pict "@! AAA";
            when (if(_tryb_et="HPPCL",_pl_et:="LAT",NIL),.t.);
            vali _pl_et$"MAZ,STD,LAT"
@ 2,0 say "Cennik : " get _cen_et pict "9" valid str(_cen_et,1)$_cenniki
//@ 2,col()+3 say "Liczba etykiet na stron :" get _le_et pict "99" vali _le_et>0
set curs on; read; set curs off
if lastkey()=K_ESC; close data; RETU NIL; endi
if _tryb_et<>"HPPCL"
  @ 2,14 say "Liczba etykiet na stron :" get _le_et pict "99" vali _le_et>0
  @ 2,48 say "Druk wyrniony - szeroko:" get _szer_et pict "9";
                                                  vali _szer_et=1.or._szer_et=2
  @ 3,66 say "wysoko :" get _wys_et pict "9" vali _wys_et=1.or._wys_et=2
  set curs on; read; set curs off
  if lastkey()=K_ESC; close data; RETU NIL; endi
endi

if _tryb_et="HPPCL"
  _plus:=46
endi


_szab_i:= transform(spac(LENIN),_format_ind)
_szab_n:= spac(_len_naz)
_gru_tow:=if(subs(_wersja,81,1)=="G",spac(3),spac(2))
_dok:="  /     /"+_mag
_st_mag:="   "

_selekcja:=(HorizMenu(3,0,"Selekcja towarw :",{"TAK","NIE"},1))=1
if _selekcja
  @ 3,0 clea to 3,50

  sele 0
  if !_use("SL_DOK","R"); BREAK; endif
  set index to SL_DOK

  sele 0
  if !_use("SL_MAG","R"); BREAK; endif
  set index to SL_MAG

  @ 3,0 say "Szablon indeksu : " get _szab_i pict _format_ind 
  @ 4,0 say "Szablon nazwy :   " get _szab_n pict repl("!",_len_naz)
  @ 5,0 say "Grupa towarowa :  " get _gru_tow pict ;
                          if(subs(_wersja,81,1)=="G","999","99")
  @ 5,col()+3 say "Dokument :" get _dok pict "@! AA/99999/999";
        vali file("MAG"+subs(_dok,10,3)+".DBF") when _cc=" "
  @ 5,col()+1 say "z roku" get _rok pict "9999" valid _rok>=1999
  @ 6,0 say "Data zmiany cen : " get _cc_d;
         when _dok="  /     /".and.empty(_cc)
  @ 6,col()+5 say "Numer zmiany cen :" get _cc pict "99999" vali SZ();
         when _dok="  /     /".and.empty(_cc_d)
  @ 7,0 say "Niezerowe stany na magazynie : " get _st_mag pict "999" ;
        when SLGET("SL_MAG","SL_MAG","V1",1,1,{"magazyn"},,.f.);
        vali empty(_st_mag).or.(SZ().and.SL("SL_MAG","SL_MAG","V1",1,1))
  set curs on; read; set curs off
  if lastkey()=K_ESC; close data; RETU NIL; endi
  _mag:=subs(_dok,10,3)
endif
CPClose(SL_MAG)

QPC(1)
if _selekcja

  _war:=".t."  
  if !empty(_st_mag)

    sele 0
    if !_use("MAG"+_st_mag,"R","MAG"); BREAK; endif
    set index to ("M"+_st_mag+"_IP0")
  endi 

  if !_dok="  /     /"
  
     sele 0
     if !_use("DOK"+_mag+"P","R"); BREAK; endif
     set index to ("D"+_mag+"P_NR")         // RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK
     seek subs(_dok,1,2)+_mag+str(_rok,4)+subs(_dok,4,5)
     copy to (_sc+"TT") fields INDEKS ;
     while RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK ==;
           subs(_dok,1,2)+_mag+str(_rok,4)+subs(_dok,4,5)
  
     _use(_sc+"TT","E!")
     index on s_i(INDEKS) to (_sc+"TT")
    _war:=_war+".and.!empty(TT->INDEKS)"
  endi

  if !" "$_cc.and._dok="  /     /"

    QPC(1)
   
    sele 0
    if !_use("CENY","R"); BREAK; endif
    go bott
    do while !bof().and.NR>=_cc
      skip -1
    endd
    copy rest to (_sc+"TT") field INDEKS for NR==_cc 
  
    _use(_sc+"TT","E!")
    index on s_i(INDEKS) to (_sc+"TT")
    _war:=_war+".and.!empty(TT->INDEKS)"

    QPC(0)

  elseif !empty(_cc_d).and._dok="  /     /"

    QPC(1)
   
    sele 0
    if !_use("CENY","R"); BREAK; endif
    set index to CENY_DA
    dbseek(_cc_d)
    copy to (_sc+"TT") field INDEKS while DATA=_cc_d 
  
    _use(_sc+"TT","E!")
    index on s_i(INDEKS) to (_sc+"TT")
    _war:=_war+".and.!empty(TT->INDEKS)"

    QPC(0)
  endi

  if !_szab_i=transform(spac(LENIN),_format_ind)
    _war=_war+".and.(COMP(s_i(INDEKS),_szab_i))"
  endif
  if !empty(_szab_n)
    if " "=subs(_szab_n,1,1)
      _war=_war+".and.(alltrim(uppe(_szab_n))$uppe(NAZWA_TOW))"
    else
      _war=_war+".and.(uppe(NAZWA_TOW)=rtrim(uppe(_szab_n)))"
    endif
  endif
  if !_gru_tow=if(subs(_wersja,81,1)=="G",spac(3),spac(2))
    _war=_war+".and.(_gru_tow=GRUPA_TOW)"
  endif
  if !empty(_st_mag)
    _war=_war+".and.MAG->STAN<>0"
  endi
  _bwar:=COMPILE(_war)
endi

sele 0
if !_use("TOW","R"); BREAK; endif
apom:={}

for _i:=1 to fcount()
 aadd(apom,_i)
next

_lcen:=len(_cenniki)

_astru:={}
aadd(_astru,{"INDEKS","C",LENIN,0})
aadd(_astru,{"NAZWA_TOW","C",max(40,_len_naz),0})
aadd(_astru,{"GRUPA_TOW","C",3,0})
aadd(_astru,{"JM","C",4,0})
aadd(_astru,{"VAT","C",2,0})
aadd(_astru,{"KOD_PAS","N",13,0})
aadd(_astru,{"CENA_ZAK","N",9,2})
for _i:=1 to _lcen
  aadd(_astru,{"CENA_"+str(_i,1),"N",9,2})
next
dbcreate(_sc+"TOW_R",_astru)

sele 0
_use (_sc+"TOW_R","E!") 

sele TOW

if !_selekcja
  dbeval({||POLCOPY(TOW,TOW_R)})
else
  if !empty(_st_mag)
    set rela to s_i(INDEKS) into MAG
  endi
  if !" "$_dok.or.!" "$_cc.or.!empty(_cc_d)
    set rela to s_i(INDEKS) into TT additive
  endi

  dbeval({|| POLCOPY(TOW,TOW_R)},_bwar)
endi
close TOW
CPClose(TT)
CPclose(MAG)
dele file (_sc+"TT.DBF")
dele file (_sc+"TT.NTX")

sele TOW_R
_lpoz:=lastrec()
_licznik:=0

* _pom_cen:=Eval(fieldblock("CENA_"+str(_cen_et,1)))
* TOW_R->CENA_ZAK = cena brutto

if eval(memvarblock("_ceny_"+str(_cen_et,1)))="N"
    dbeval({|| _pom_cen:=Eval(fieldblock("CENA_"+str(_cen_et,1))),;
               TOW_R->CENA_ZAK := _pom_cen*(1+val(VAT)/100) })
else
    dbeval({|| _pom_cen:=Eval(fieldblock("CENA_"+str(_cen_et,1))),;
               TOW_R->CENA_ZAK:=_pom_cen,;
     Eval(fieldblock("CENA_"+str(_cen_et,1)) ,_pom_cen/(1+val(VAT)/100) ) } )
endi

_cen_et_priv:=_cen_et

_wer:="V1|V_ETYK(_cen_et_priv)"

index on INDEKS to (_sc+"TOW_RI")
index on NAZWA_TOW to (_sc+"TOW_RN")
set inde to (_sc+"TOW_RI"),(_sc+"TOW_RN")

QPC(0)
_lpoz:=_lpoz-_licznik
@ 24,0 say "Liczba pozycji: " +str(_lpoz,5)  
go top
CPEDIT  POZ: if(_selekcja,8,4),,23,               ;
        DEF: "iETYKIETY"             ;
        POZWER: _wer              ;
        PION: ,,,                 ;
        INDEXY: {"indeks","nazwa"};
        EDYCJA: "NAZWA_TOW"$Cpnazwa()  ;
        ODTWORZ: .f.             ;
        SIEC: REKORD

if len(_zaznaczone)>0
  QPC(1)
  @ if(_selekcja,6,1),0 clear to 24,79
  copy to (_sc+"TOW_RR") for ascan(_zaznaczone,recn())>0
  _use (_sc+"TOW_RR","E!")
  QPC(0)
  _lpoz:=lastrec()
  @ 24,0 say "Liczba pozycji: " +str(_lpoz,5)  

  CPEDIT  POZ: if(_selekcja,8,4),,23,               ;
        DEF: "ETYKIETY"             ;
        POZWER: _wer              ;
        PION: ,,,                 ;
        EDYCJA: "NAZWA_TOW"$Cpnazwa() ;
        ODTWORZ: .f.             ;
        SIEC: REKORD
endif

if _lpoz>0 .and. QTN("Wydruk etykiet ?")

  errorblock( { |e| PrintError(_port_et,e,prevhandler) } )

  BEGIN SEQUENCE
  _nowa_strona:=.t.
  go top
  i:=1

  do while ! eof()
    _nc11:=0;_nc12:=0;_in1:="";_in2:="";_na1:="";_na2:="";_kp1:="";_kp2:=""
    _nc13:=0;_in3:="";_na3:="";_kp3:="";_jm1:="";_jm2:="";_jm3:=""
    if _nowa_strona
      set devi to screen
      QKE(" Przygotuj drukark !")
      set devi to print
      SET(_SET_PRINTFILE,(_port_et),.t.)
      if !PRINTER_OK(_port_et)
        set devi to screen
        if !QTN("Drukarka nie jest gotowa. Ponowienie wydruku ?")
          BREAK
        else
          loop
        endi
      endif  
      setprc(0,0)

      _kody:=""
      if _tryb_et="ESC/P".or._tryb_et="IBM"
        if _wys_et=2
           _hei_1:=HEI_E1;_hei_0:=HEI_E0 
        else
           _hei_1:="";_hei_0:="" 
        endi
        if _szer_et=2       
           _wid_1:=WID_E1;_wid_0:=WID_E0 
        else
           _wid_1:="";_wid_0:=""
        endi
        _emp_1:=EMP_E1;_emp_0:=EMP_E0 
        _dou_1:=DOU_E1;_dou_0:=DOU_E0 
        _kody:=RESE_E+DET_E0  // chr(27)+chr(64) + chr(27)+chr(56)
        _kody+=chr(27)+chr(51)+chr(34) // line spacing n/216 cal (n=34)
      elseif _tryb_et="HPPCL"
        _hei_1:=HEI_H1;_hei_0:=HEI_H0 
        _wid_1:=WID_H1;_wid_0:=WID_H0 
        _emp_1:=EMP_H1;_emp_0:=EMP_H0 
        _dou_1:=DOU_H1;_dou_0:=DOU_H0 
        _kody:=RESE_H+ORIP_H
      endi
      if _tryb_et="ESC/P"
        _kody+=PICC_E         // chr(18)+chr(27)+chr(80)+chr(15)
      elseif _tryb_et="IBM"
        _kody+=PICC_I         // chr(18)+chr(15) 
      elseif _tryb_et="HPPCL"
        _kody+=PICC_H // pica condensed
      endi

      if _tryb_et="HPPCL" .and. _pl_et="LAT"
        _kody+=chr(27)+chr(40)+chr(49)+chr(55)+chr(85)  //CP 852
      endi
/*      
      if _tryb_et="HPPCL" 
        _kody+=chr(27)+"(s24S"
      endif
*/
      devout(_kody)
      _nowa_strona:=.f.
    endif

    _nc11:=Eval(Fieldblock("CENA_"+str(_cen_et,1)))
    _tc11:=if(_nc11>0,alltrim(transform(_nc11,_format_cen)),space(12)  )
    _tcb1:=alltrim(transform(CENA_ZAK,_format_cen))
    _in1:=PL(s_i(INDEKS),_pl_et)
    _na1:=PL(NAZWA_TOW,_pl_et)
    _kp1:=if(subs(_wersja,32,1)="K",transform(KOD_PAS,"@Z 9999999999999"),"")
    _jm1:=PL("/"+alltrim(JM),_pl_et)
    skip
    _nc12:=Eval(Fieldblock("CENA_"+str(_cen_et,1)))
    _tc12:=if(_nc12>0,alltrim(transform(_nc12,_format_cen)),space(12)  )
    _tcb2:=alltrim(transform(CENA_ZAK,_format_cen))
    _in2:=PL(s_i(INDEKS),_pl_et)
    _na2:=PL(NAZWA_TOW,_pl_et)
    _kp2:=if(subs(_wersja,32,1)="K",transform(KOD_PAS,"@Z 9999999999999"),"")
    _jm2:=PL("/"+alltrim(JM),_pl_et)

    if _tryb_et="HPPCL"
      skip
      _nc13:=Eval(Fieldblock("CENA_"+str(_cen_et,1)))                //29.01.04
      _tc13:=if(_nc13>0,alltrim(transform(_nc13,_format_cen)),space(12)  )
      _tcb3:=alltrim(transform(CENA_ZAK,_format_cen))
      _in3:=PL(s_i(INDEKS),_pl_et)
      _na3:=PL(NAZWA_TOW,_pl_et)
      _kp2:=if(subs(_wersja,32,1)="K",transform(KOD_PAS,"@Z 9999999999999"),"")
      _jm3:=PL("/"+alltrim(JM),_pl_et)
    endi

    if _tryb_et<>"HPPCL"
      devpos(i,0)
      devout(_hei_1+_wid_1+_emp_1+_dou_1+  _in1  +"    "+;
                           _emp_0+_dou_0+  _kp1  +_hei_0+_wid_0)
      devpos(i,0); devpos(i,_plus)
      devout(_hei_1+_wid_1+_emp_1+_dou_1+  _in2  +"    "+;
                           _emp_0+_dou_0+  _kp2  +_hei_0+_wid_0)
  
      devpos(i+2,0)
      devout(_hei_1+_wid_1+  _na1  +_hei_0+_wid_0) 
      devpos(i+2,0); devpos(i+2,_plus)
      devout(_hei_1+_wid_1+  _na2  +_hei_0+_wid_0) 
    else
      devpos(i,0); devout(SPAP_H)
      devout(SEMI_BOLD+COUR_16+  _in1  +BOLD_OFF+"    "+COUR_14+;
                           +  _kp1  +SPAF_H)
      devpos(i,0); devpos(i,_plus); devout(SPAP_H)
      devout(SEMI_BOLD+COUR_16+  _in2  +BOLD_OFF+"    "+COUR_14+;
                           +  _kp2  +SPAF_H)
  
      devpos(i,0); devpos(i,2*_plus); devout(SPAP_H)
      devout(SEMI_BOLD+COUR_16+  _in3  +BOLD_OFF+"    "+COUR_14+;
                           +  _kp3  +SPAF_H)
  
      devpos(i+1,0); devout(SPAP_H)
      devout(COUR_11+  _na1  +SPAF_H) 
      devpos(i+1,0); devpos(i+1,_plus); devout(SPAP_H)
      devout(COUR_11+  _na2  +SPAF_H) 
      devpos(i+1,0); devpos(i+1,2*_plus); devout(SPAP_H)
      devout(COUR_11+  _na3  +SPAF_H) 
    endi


    if empty(subs(_wersja,104,1)).or.subs(_wersja,104,1)="1"
      if _tryb_et<>"HPPCL"
        devpos(i+4,0)
        devout("CENA NETTO :   "+_hei_1+_wid_1+_emp_1+_dou_1+  _tc11  +;
                PL(" z",_pl_et)+_jm1+_hei_0+_wid_0+_emp_0+_dou_0)
        devpos(i+4,0); devpos(i+4,_plus)
        devout("CENA NETTO :   "+_hei_1+_wid_1+_emp_1+_dou_1+  _tc12  +;
                PL(" z",_pl_et)+_jm2+_hei_0+_wid_0+_emp_0+_dou_0) 
        devpos(i+5,0)
        devout("CENA BRUTTO :   "+  _tcb1  +PL(" z",_pl_et)+_jm1) 
        devpos(i+5,0); devpos(i+5,_plus)
        devout("CENA BRUTTO :   "+  _tcb2  +PL(" z",_pl_et)+_jm2) 
     else
        devpos(i+3,0); devout(SPAP_H)
        devout(COUR_12+SEMI_BOLD+"NETTO   "+ BOLD_ON+COUR_23 +_tc11+BOLD_OFF +;
               COUR_14+  PL(" z",_pl_et)+_jm1+SPAF_H) 
        devpos(i+3,0); devpos(i+3,_plus); devout(SPAP_H)
        devout(COUR_12+SEMI_BOLD+"NETTO   "+ BOLD_ON+COUR_23+ _tc12+BOLD_OFF +;
               COUR_14+  PL(" z",_pl_et)+_jm2+SPAF_H) 
        devpos(i+3,0); devpos(i+3,2*_plus); devout(SPAP_H)
        devout(COUR_12+SEMI_BOLD+"NETTO   "+ BOLD_ON+COUR_23+ _tc13+BOLD_OFF +;
               COUR_14+  PL(" z",_pl_et)+_jm3+SPAF_H) 
        devpos(i+5,0); devout(SPAP_H)
        devout(COUR_14+""+COUR_11+"BRUTTO    "+ COUR_15+  _tcb1  + COUR_11+;
                PL(" z",_pl_et)+_jm1+SPAF_H)
        devpos(i+5,0); devpos(i+5,_plus); devout(SPAP_H)
        devout(COUR_14+""+COUR_11+"BRUTTO    "+ COUR_15+  _tcb2  + COUR_11+;
                PL(" z",_pl_et)+_jm2+SPAF_H)
        devpos(i+5,0); devpos(i+5,2*_plus); devout(SPAP_H)
        devout(COUR_14+""+COUR_11+"BRUTTO    "+ COUR_15+  _tcb3  + COUR_11+;
                PL(" z",_pl_et)+_jm3+SPAF_H)
     endi 

    elseif subs(_wersja,104,1)>"1"
      if _tryb_et<>"HPPCL"
        devpos(i+4,0)
        devout("CENA BRUTTO :  "+_hei_1+_wid_1+_emp_1+_dou_1+  _tcb1  +;
                PL(" z",_pl_et)+_jm1+_hei_0+_wid_0+_emp_0+_dou_0) 
        devpos(i+4,0); devpos(i+4,_plus)
        devout("CENA BRUTTO :  "+_hei_1+_wid_1+_emp_1+_dou_1+  _tcb2  +;
              PL(" z",_pl_et)+_jm2+_hei_0+_wid_0+_emp_0+_dou_0) 
        devpos(i+5,0)
        devout("CENA NETTO :   "+  _tc11   +PL(" z",_pl_et)+_jm1) 
        devpos(i+5,0); devpos(i+5,_plus)
        devout("CENA NETTO :   "+  _tc12   +PL(" z",_pl_et)+_jm2) 
      else
        devpos(i+3,0); devout(SPAP_H)
        devout(COUR_12+SEMI_BOLD+"BRUTTO  "+ BOLD_ON+COUR_23 +_tcb1+BOLD_OFF +;
               COUR_14+  PL(" z",_pl_et)+_jm1+SPAF_H) 
        devpos(i+3,0); devpos(i+3,_plus); devout(SPAP_H)
        devout(COUR_12+SEMI_BOLD+"BRUTTO  "+ BOLD_ON+COUR_23+ _tcb2+BOLD_OFF +;
               COUR_14+  PL(" z",_pl_et)+_jm2+SPAF_H) 
        devpos(i+3,0); devpos(i+3,2*_plus); devout(SPAP_H)
        devout(COUR_12+SEMI_BOLD+"BRUTTO  "+ BOLD_ON+COUR_23+ _tcb3+BOLD_OFF +;
               COUR_14+  PL(" z",_pl_et)+_jm3+SPAF_H) 
        devpos(i+5,0); devout(SPAP_H)
        devout(COUR_14+""+COUR_11+"NETTO     "+ COUR_15+  _tc11  + COUR_11+;
                PL(" z",_pl_et)+_jm1+SPAF_H)
        devpos(i+5,0); devpos(i+5,_plus); devout(SPAP_H)
        devout(COUR_14+""+COUR_11+"NETTO     "+ COUR_15+  _tc12  + COUR_11+;
                PL(" z",_pl_et)+_jm2+SPAF_H)
        devpos(i+5,0); devpos(i+5,2*_plus); devout(SPAP_H)
        devout(COUR_14+""+COUR_11+"NETTO     "+ COUR_15+  _tc13  + COUR_11+;
                PL(" z",_pl_et)+_jm3+SPAF_H)

      endi
    endi

    devpos(i+6,0)
    devout(repl(" . ",46))


    if i<=8*(_le_et-1)
      i:=i+8
      _nowa_strona:=.f.
    else
      i:=1
      eject
      _nowa_strona:=.t.
    endif

    skip
  enddo

  if PRINTER_OK(_port_et)
    if _tryb_et="ESC/P".or._tryb_et="IBM"
       _kody:=RESE_E+DET_E1
    elseif _tryb_et="HPPCL"
       _kody:=RESE_H
    endi
    devout(_kody)
  endif

  END SEQUENCE
  set devi to screen
  set printer to
  errorblock(prevhandler)
endif

close data
RETURN NIL

*******************************************************************************
FUNCTION MAZ_STD(_s)
local _n,_i
static amaz:=;
      {134,141,145,146,164,162,158,166,167,143,149,144,156,165,163,152,160,161}
static astd:=;
      { 97, 99,101,108,110,111,115,122,122, 65, 67, 69, 76, 78, 79, 83, 90, 90}
for _i:=1 to len(_s)
  _n:=ascan(amaz,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(astd[_n]))
  endi
next
RETURN _s    

*******************************************************************************
FUNCTION LAT_STD(_s)
local _n,_i
static a852:=;
      {165,134,169,136,228,162,152,171,190,164,143,168,157,227,224,151,141,189}
static astd:=;
      { 97, 99,101,108,110,111,115,122,122, 65, 67, 69, 76, 78, 79, 83, 90, 90}
for _i:=1 to len(_s)
  _n:=ascan(a852,asc(subs(_s,_i,1)))
  if _n>0
    _s:=stuff(_s,_i,1,chr(astd[_n]))
  endi
next
RETURN _s    

*******************************************************************************
FUNCTION PL(_t,_pl)
if upper(chr(145))=chr(144) //900
  RETURN if(_pl="L",MAZ_LAT(_t),if(_pl="S",MAZ_STD(_t),_t))
elseif upper(chr(169))=chr(168) //852
  RETURN if(_pl="M",LAT_MAZ(_t),if(_pl="S",LAT_STD(_t),_t))
endi
RETURN _t

*******************************************************************************

/*
ESC/P :
#define CON_E1 chr(15)                 // condensed
#define CON_E0 chr(18)                 // cancel condensed
#define PICA_E chr(18)+chr(27)+chr(80) // pica (cancel condensed, cancel elite)
#define ELIT_E chr(18)+chr(27)+chr(77) // elite (cancel condensed, set elite)
#define PICC_E chr(18)+chr(27)+chr(80)+chr(15)  // pica condensed
#define ELIC_E chr(18)+chr(27)+chr(77)+chr(15)  // elite condensed
#define RESE_E chr(27)+chr(64)          // reset
#define CAE_E1 chr(27)+chr(73)+chr(49)  // cod area expansion
#define CAE_E0 chr(27)+chr(73)+chr(48)
#define ITA_E1 chr(27)+chr(52)          // italic
#define ITA_E0 chr(27)+chr(53)
#define UND_E1 chr(27)+chr(45)+chr(49)  // underlining
#define UND_E0 chr(27)+chr(45)+chr(48)
#define DET_E1 chr(27)+chr(57)          // detektor papieru
#define DET_E0 chr(27)+chr(56) 
#define DOU_E1 chr(27)+chr(71)          // double strike
#define DOU_E0 chr(27)+chr(72)
#define HEI_E1 chr(27)+chr(119)+chr(49) // double height     
#define HEI_E0 chr(27)+chr(119)+chr(48)
#define WID_E1 chr(27)+chr(87)+chr(49)  // double width (expanded)
#define WID_E0 chr(27)+chr(87)+chr(48)
#define EMP_E1 chr(27)+chr(69)          // emphasized 
#define EMP_E0 chr(27)+chr(70) 
#define L216_E chr(27)+chr(51)+chr(n)   // line spacing n/216 cal 

IBM :
#define RESE_I chr(27)+chr(64)          // reset
#define CON_I1 chr(15)                  // condensed
#define CON_I0 chr(18)                  // cancel condensed
#define PICA_I chr(18)                  // pica (cancel condensed)
#define ELIT_I chr(27)+chr(58)          // elite
#define PICC_I chr(18)+chr(15)         // pica condensed
#define ELIC_I chr(27)+chr(58)+chr(15) // elite condensed

#define DET_I1 chr(27)+chr(57)          // detektor papieru
#define DET_I0 chr(27)+chr(56) 
#define DOU_I1 chr(27)+chr(71)          // double strike
#define DOU_I0 chr(27)+chr(72)
#define HEI_I1 chr(27)+chr(119)+chr(49) // double height     
#define HEI_I0 chr(27)+chr(119)+chr(48)
#define WID_I1 chr(27)+chr(87)+chr(49)  // double width (expanded)
#define WID_I0 chr(27)+chr(87)+chr(48)
#define EMP_I1 chr(27)+chr(69)          // emphasized 
#define EMP_I0 chr(27)+chr(70) 
#define L216_I chr(27)+chr(51)+chr(n)   // line spacing n/216 cal 

HPPCL :
#define RESE_H chr(27)+"E"              // reset
#define ORIP_H chr(27)+"&l0O"          // portret
#define ORIL_H chr(27)+"&l1O"          // landscape
#define COUR_H chr(27)+"(s3T"          // curier
#define SPAF_H chr(27)+"(s0P"          // spacing fixed
#define SPAP_H chr(27)+"(s1P"          // spacing proportional
#define PICA_H chr(27)+"(s10.0H"                  // pica
#define ELIA_H chr(27)+"(s12H"+chr(27)+"(s4102T"  // elite
#define PICC_H chr(27)+"(s16.67H"                // pica condensed
#define ELCC_H chr(27)+"(s20H"+chr(27)+"(s4102T" // elite condensed
#define ITA_H1 chr(27)+"(s1S"          // italic
#define ITA_H0 chr(27)+"(s0S"
#define DOU_H1 chr(27)+"(s3B"          // double strike (bold)
#define DOU_H0 chr(27)+"(s0B" 
#define HEI_H1 chr(27)+"(s24V"         // double height ?
#define HEI_H0 chr(27)+"(s12V"
#define WID_H1 chr(27)+"(s5.0H"        // double width pica    
#define WID_H0 chr(27)+"(s10.0H"
#define EMP_H1 chr(27)+"(s3B"          // emphasized (bold)
#define EMP_H0 chr(27)+"(s0B"  
*/
*******************************************************************************
FUNCTION JL(par)                                                 //17.06.99 LIS
loca _pole:=CPNazwa(),_osele:=select(),_w,_wt,_tresc:="",;
     _alia:=alias()

if !file("ZMIANY.DBF");RETU .t.;endi

_w:=Eval(FieldWblock(_pole,_osele))
_wt:=valtype(_w)
Cpclose(ZMIANY)

do case
  case _wt="C"
   _tresc:=_w
  case _wt="N"
   _tresc:=str(_w)
  case _wt="D"
   _tresc:=dtoc(_w)
endcase

sele 0
_use("ZMIANY","S!")
APPE_BLOK()
repl OPERATOR with _operator,;
     DATA with date(),;
     ZNACZNIK with if(par=0,"0","1"),;
     TRESC with _pole+" : "+_tresc,;
     NR_KON with (_alia)->NR_KON,;
     CZAS with subs(time(),1,5)  

if (_alia)->(fieldpos("INDEKS"))>0 .and. ZMIANY->(fieldpos("INDEKS"))>0 .and.;
   select("SPR_N_R")>0
  repl INDEKS with (_alia)->INDEKS,;
       NR_KON with SPR_N_R->NR_KON
endi

close ZMIANY

sele (_osele)
RETURN .T.

*******************************************************************************
FUNCTION MEM()
RETURN NIL

*******************************************************************************
FUNCTION INDEKS_ZAM()
local _al:=alias(),_ret
_ret:=TOW->(dbseek(s_i((_al)->INDEKS)))
if _ret
   repl NAZWA_TOW with TOW->NAZWA_TOW
   if _opisy_tow="T"
      repl OPIS_TOW with TOW->OPIS_TOW
   endi
endi
RETU _ret

*******************************************************************************
/*
FUNCTION EXPORT_HAN()    //opcja nieaktywna
local _tex:='۲  ZAPIS INFORMACJI HANDLOWYCH  '
loca _sel:=select(),_kat,getlist:={},;
     _ndysk:=0,_tdysk:="",_k
loca prevhandler:=errorblock(),_sci:=subs(_sc,1,len(_sc)-1),;
     _oldcolor:=set(_SET_COLOR),_oldcursor,_screen,;
     apom:={},apom_k:={},apom_u:={},_erc1,_erc2,_erc3

priv _konto:=spac(5),_nr_mag:=_magazyn
priv _kat_zam:="A:\"+spac(27)

cls
@ 0,0 say _tex

BEGIN SEQUENCE

if file("KAT_ZAM.MEM")
  restore from KAT_ZAM.MEM additive
endi
_kat:=_kat_zam

sele 0
if !_use("SL_MAG","R"); BREAK; endif
set index to SL_MAG

sele 0
if !_use("SL_KONT","R"); BREAK; endi
set index to SL_KONT

@ 1,0 say "Zapis do katalogu :" get _kat pict "@!"
@ 2,0 say "Dane dla konta :   " get _konto pict "@K 99999";
           when SLGET("SL_KONT","SL_KONT","V1",1,1,{"konto"},,.f.);
           vali (empty(_konto).or.;
                (SZ().and.SL("SL_KONT","SL_KONT","V1",1,1))).and.SLGET() 
@ 3,0 say "Towary z magazynu :" get _nr_mag pict "@K 999";
      when SLGET("SL_MAG","SL_MAG","V1",1,1,{"nr magazynu"},,.f.);
      vali SZ().and.SL("SL_MAG","SL_MAG","V1",1,1).and.SLGET() 

set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

_kat_zam:=_kat
save to KAT_ZAM all like _kat_zam

_pelny:=HorizMenu(4,0,"Peny sownik towarw : ",{"TAK","NIE"},2)

_dane:= HorizMenu(5,0,"Zapis danych w postaci :",;
                                       {"PIERWOTNEJ","SKOMPRESOWANEJ"},1)
if _dane=0; BREAK; endi

_k:=alltrim(_kat)
_k:=if(subs(_k,-1,1)="\",subs(_k,1,len(_k)-1),_k)

if subs(_k,2,1)=":"
  _tdysk:= subs(_k,1,1)
else
  _tdysk:=DISKNAME()
endif
_ndysk = ASC(upper(_tdysk)) - 64 

_exit:=.f.

if !DIR_EXIST(_k); QKE("Nieprawidowy katalog lub brak dysku !"); BREAK; endi


QPC(1)

sele 0
if !_use("TOW","R"); BREAK; endi
set index to TOW_IN
copy stru to (_sc+"TOW")

sele 0
if !_use(_sc+"TOW","E","TOW_H"); BREAK; endi
index on INDEKS to (_sc+"TOW_H")

sele 0
if !_use("MAG"+_nr_mag,"R","MAG"); BREAK; endi
set index to "M"+_nr_mag+"_IP0"

sele 0
if !_use("UPUSTY","R"); BREAK; endif
set index to UPUSTY_K,UPUSTY_T
apom_u:={}
for i:=1 to fcount(); aadd(apom_u,i); next
copy stru to (_sc+"UPUSTY")

sele 0
if !_use(_sc+"UPUSTY","E","UPUSTY_H"); BREAK; endi

sele 0
if empty(_gdzie_fir)
  if !_use("KON","S"); BREAK; endi
  set index to KON_NR, KON_NA, KON_NI, KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","S","KON"); BREAK; endi
  set index to (_gdzie_fir+"FIRMY_NR"), (_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"), (_gdzie_fir+"FIRMY_AD")
endi
if fieldpos("KONTO")=0
  QKE("W sowniku firm brak pola KONTO C(5) !")
  BREAK
endi

if empty(_konto)
  copy to (_sc+"KON.DBF") for !empty(KONTO) 
else
  copy to (_sc+"KON.DBF") for KONTO==_konto
endi
close KON

sele 0
if !_use(_sc+"KON.DBF","R"); BREAK; endi

sele 0
if !_use("SPR_N","R"); BREAK; endif
set index to SPR_N_KO             // NR_KON+RODZAJ_DOK+SERIA_FAK+ROK_DOK+NR_DOK
apom_k:={}
for i:=1 to fcount(); aadd(apom_k,i); next
copy stru to (_sc+"SPR_N")

sele 0
if !_use(_sc+"SPR_N","E","SPR_H"); BREAK; endi

sele KON
go top
do while !eof()

  sele SPR_N
  dbseek(KON->NR_KON)
  apom:=apom_k
  dbeval({|| RECAPPEND(SPR_N,SPR_H)},{|| WN<>0},{|| NR_KON==KON->NR_KON}) 

  sele UPUSTY
  dbseek(KON->NR_KON)
  apom:=apom_u
  dbeval({|| RECAPPEND(UPUSTY,UPUSTY_H)},,{|| NR_KON==KON->NR_KON}) 

  sele KON
  skip
endd

sele UPUSTY
dbseek("00000")
apom:=apom_u
dbeval({|| RECAPPEND(UPUSTY,UPUSTY_H)},,{|| NR_KON=="00000"}) 

CPClose(KON)
CPClose(UPUSTY)
CPClose(UPUSTY_H)
CPClose(SPR_H)
CPClose(SPR_N)

sele TOW
apom:={}
for i:=1 to fcount(); aadd(apom,i); next

if _pelny=2

  sele MAG
  go top
  do while !eof()

    TOW_H->(dbseek(MAG->INDEKS))
    if TOW_H->(eof())
      TOW->(dbseek(s_i(MAG->INDEKS)))
      Eval({|| RECAPPEND(TOW,TOW_H)})
      TOW_H->STAN_MIN:=0
    endi    
    TOW_H->STAN_MIN+=MAG->STAN 

    sele MAG
    skip
  endd
else

  sele TOW
  do while !eof()
    Eval({|| RECAPPEND(TOW,TOW_H)})
    TOW_H->STAN_MIN:=0

    sele TOW
    skip
  endd

  sele MAG
  go top
  do while !eof()

    TOW_H->(dbseek(MAG->INDEKS))
    TOW_H->STAN_MIN+=MAG->STAN 

    sele MAG
    skip
  endd
endi

CPClose(TOW)
CPClose(TOW_H)
CPClose(MAG)

if _dane=1
  _rozmiar:=filesize("SL_G_TOW.DBF")+;
            filesize("SL_G_KON.DBF")+;
            filesize("SL_JM.DBF")+;
            filesize(_sc+"SPR_N.DBF")+;
            filesize(_sc+"UPUSTY.DBF")+;
            filesize(_sc+"KON.DBF")+;
            if(empty(_nr_mag),filesize("TOW.DBF"),filesize(_sc+"TOW.DBF"))

else
  dele file (_sc+"DANE_HAN.ARJ")
  _screen:=savescreen(0,0,24,79)
  _oldcursor:=set(_SET_CURSOR,SC_NORMAL)
  tone(880,4)
  cls

  _erc1:=.f.
  RUN("arj a "+_sc+"dane_han "+;
                             _sc+"SPR_N.DBF "+;
                             _sc+"UPUSTY.DBF -e") 

  set curs on;set curs off

  _erc2:=.f.
  RUN("arj a "+_sc+"dane_han "+;
                             _sc+"KON.DBF "+;
                             _sc+"TOW.DBF -e")

  set curs on;set curs off

  _erc3:=.f.
  RUN("arj a "+_sc+"dane_han "+;
                             "SL_JM.DBF -e")

  set curs on;set curs off
  RUN("arj a "+_sc+"dane_han "+;
                             "SL_G_TOW.DBF "+;
                             "SL_G_KON.DBF  -e")

  set curs on;set curs off
  inkey(2)
  set(_SET_CURSOR,_oldcursor)
  set(_SET_COLOR,_oldcolor)
  restscreen(0,0,24,79,_screen)
  if _erc1.or._erc2.or._erc3.or._erc4
     QKE("Wystpi bd wywoania programu kompresujcego !"); BREAK
  endi
  tone(880,4)
  _rozmiar:=filesize(_sc+"DANE_HAN.ARJ")
endi

if _rozmiar>diskfree(_tdysk)
  QKE("Za mao miejsca na zapis danych !")
  BREAK
endi

errorblock({|e| DiskError(e,prevhandler)})
*------------------------------------------------------------------------------

if _dane=1
  dele file (_k+"\"+"TOW.DBF")
  dele file (_k+"\"+"KON.DBF")
  dele file (_k+"\"+"SPR_N.DBF")
  dele file (_k+"\"+"UPUSTY.DBF")
  dele file (_k+"\"+"SL_G_TOW.DBF")
  dele file (_k+"\"+"SL_G_KON.DBF")
  dele file (_k+"\"+"SL_JM.DBF")
  if empty(_nr_mag)
    copy file TOW.DBF to (_k+"\"+"TOW.DBF")
  else
    copy file (_sc+"TOW.DBF") to (_k+"\"+"TOW.DBF")
  endi
  copy file (_sc+"SPR_N.DBF") to (_k+"\"+"SPR_N.DBF")
  copy file (_sc+"UPUSTY.DBF") to (_k+"\"+"UPUSTY.DBF")
  copy file (_sc+"KON.DBF")   to (_k+"\"+"KON.DBF")
  copy file SL_G_TOW.DBF      to (_k+"\"+"SL_G_TOW.DBF")
  copy file SL_G_KON.DBF      to (_k+"\"+"SL_G_KON.DBF")
  copy file SL_JM.DBF         to (_k+"\"+"SL_JM.DBF")
else
  dele file (_k+"\"+"DANE_HAN.ARJ")
  copy file (_sc+"DANE_HAN.ARJ") to (_k+"\"+"DANE_HAN.ARJ")
endi
*------------------------------------------------------------------------------
errorblock(prevhandler)

QPC(0)

if _dane=1.and.file(_k+"\"+"TOW.DBF");
          .and.file(_k+"\"+"KON.DBF");
          .and.file(_k+"\"+"SPR_N.DBF");
          .and.file(_k+"\"+"UPUSTY.DBF");
          .and.file(_k+"\"+"SL_JM.DBF");
          .and.file(_k+"\"+"SL_G_TOW.DBF");
          .and.file(_k+"\"+"SL_G_KON.DBF")
  QKE("Zapis wykonano !")
elseif _dane=2.and.file(_k+"\"+"DANE_HAN.ARJ")
  QKE("Zapis wykonano !")
else
  QKE("Bd zapisu danych !")
endi

END SEQUENCE
set(_SET_COLOR,_oldcolor)
@ 24,0

sele  (_sel)
RETURN NIL

*/

*******************************************************************************
FUNCTION LIMIT_EUR()
local _lim_eur:=0

sele 0
if !_use("CONFIG","R"); BREAK; endif
if fieldpos("LIM_EUR")>0
  _lim_eur:=LIM_EUR
else
  _lim_eur:=0
endi
use
if _lim_eur>0.and._use("KURSY","R")
  set index to KURSY
  dbseek("EUR3",.t.)
  skip -1
  if WALUTA="EUR"
    _lim_eur:=_lim_eur*KURSY->KURS
  else
    _lim_eur:=0
  endi
endi
CPClose(KURSY)
RETURN _lim_eur

*******************************************************************************
FUNCTION KONT_ZAM()
local _il:=0,_ilz:=0,_ind:=s_i(INDEKS),_stan:=0,_rec:=recno()

/*
if select("PRODOS")>0; RETURN .T.; endi

set order to 2
seek (_ind)

if found()
  sum ILOSC_ZAM,ILOSC_ZRE to _il,_ilz while !eof().and.s_i(INDEKS)=_ind
endi

sele MAG
seek (_ind)

if found()
  sum STAN to _stan while !eof().and.s_i(INDEKS)=_ind
endi

if _stan<_il-_ilz
  tone(220,0.5)
 QKE("Niezrealizowane zamwienia przekraczaj aktualny stan magazynowy !")
endi


sele PROZAM
set order to 1
go (_rec)

*/

RETURN .T.

*******************************************************************************
FUNCTION SLAD_ZAM()
local _il:=0,_ilz:=0,_ind:=s_i(INDEKS),_stan:=0,_rec:=recno(),_cena:=0,_tr:=0,;
      _ill:=0,_ocol:=SET(_SET_COLOR),_ret:="",_ilp:=0

if select("PRODOS")>0; RETURN .T.; endi

if subs(_wersja,140,1)=="T"
  sele MAG
  seek (_ind)
  
  if found()
     sum STAN to _stan while !eof().and.s_i(INDEKS)=_ind
  endi

  sele PROZAM
  _ill:=0; _ilp:=0
  seek _nr_kon+dtos(_data_zam)+_sym_zam
  dbeval({||  _ilp++,;
              _ill+=ILOSC_ZAM },{ || !empty(NAZWA_TOW) },;
           {|| NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
               _nr_kon+dtos(_data_zam)+_sym_zam})
  _ret:=" Stan : "+transform(_stan,_format_ilo)+;
        "  Pozycji : "+transform(_ilp,"@Z 999")+"  "+;
         "Suma iloci : "+transform(_ill,_format_ilo)

  go (_rec)
  RETURN _ret
endi

set order to 2
seek (_ind)

if found()
  sum ILOSC_ZAM,ILOSC_ZRE to _il,_ilz while !eof().and.s_i(INDEKS)=_ind
endi

sele MAG
seek (_ind)

if found()
   sum STAN to _stan while !eof().and.s_i(INDEKS)=_ind
endi

sele TOW
_tr:=recno()
seek (_ind)

if found().and._nr_cen_spr$_cenniki                                     //05.04.04
   _cena:=fieldget(fieldpos("CENA_"+_nr_cen_spr))
endi

/*                                                                     
if found()
   _cena:=fieldget(fieldpos("CENA_"+_cennik_spr))
endi
*/

go (_tr)

sele PROZAM
set order to 1

if empty(_data_zam)
   dbseek(_nr_kon)
   sum ILOSC_ZAM-ILOSC_ZRE to _ill while NR_KON=_nr_kon
else
   dbseek (_nr_kon+dtos(_data_zam))
   sum ILOSC_ZAM-ILOSC_ZRE to _ill while NR_KON=_nr_kon.and.DATA_ZAM=_data_zam
endi

SET(_SET_COLOR,_ekra_blo)
@ 24,65-len(transform(_ill,_format_ilo)) say "Suma iloci : "+transform(_ill,_format_ilo)
SET(_SET_COLOR,_ocol)

go (_rec)

RETURN " "+_ind+"  Do realizacji : "+transform(_il-_ilz,_format_ilo)+;
                "  Stan : "+transform(_stan,_format_ilo)+;
                "  Cena : "+transform(_cena,_format_cen)

*******************************************************************************
FUNCTION AFAK()
local _tex,_ll:=0,_tyt, lenw, _mian, _kwo_zap:=0,_zapisal:=.f.,;
      _anu_ok:=.f.                                                   //14.04.99
local _wart_pre:=0                                                   //12.07.99
local _wwz:=.f.,_awwz:={},_i,_ilewlinii,_poczWZ
local _fak_exp:=.f.,_exp_war1:=.f.
local _pom_cs1,_pom_cs2,_pom_cp1,_pom_cp2, _sel_tow
local _spr_fis:=.f.
local _f_zal:=.f.  // zaliczkowana
local _dokumenty:=""
local _opis_tow:=.f.   // domyslnie z TOW->DBF

        
priv _ilosc, _vf8,_vdr,_ceny_prz:=" ",_ceny_prz:=" ",;
     _kon:="T", _wer, _seria_fak:="01",_rodz_dok:="FA",;
     _rok_fak:=subs(dtoc(date()),7),;
     _nr_fak:=space(5)
priv _wl:="z"

_tex:='۲  ANULOWANIE FAKTUR I RACHUNKW  '

* _paragon:=.f.;_par_kor:=.f.;_detal:=.f.                            //14.04.99

cls
@ 0,0 say _tex



BEGIN SEQUENCE

sele 0
if !_use("EDIT","R");BREAK;endi
set index to EDIT

seek "FAFA"
dbeval({|| if("OPIS_TOW"$POLE .and. (".t."$POLE .or. ".T."$POLE),;
             _opis_tow:=.t.,NIL)},,{|| BAZA="FAFA"})
close EDIT


sele 0
if !_use("SL_MAG","R"); BREAK; endif
set index to SL_MAG

sele 0
if !_use("SPR_N","R");  BREAK;  endif
set inde to SPR_N_NR
*------------------------ SPR_N_NR = RODZAJ_DOK+SERIA_FAK+ROK_DOK+NR_DOK

_ceny_spr:="T"


************
_dokumenty:="FA|FK|RA|RK|NO|PK|NK|PA"                         //29.09.15 BAFPOL

#ifdef WINDOWS
  _dokumenty:="FA|FK|RA|RK|NO|PK|NK|PA"                      
#endif

@ 1,0 say "Dokument :" get _rodz_dok pict "@! AA";
    valid _rodz_dok$_dokumenty
set curs on; read; set cursor off
if lastkey()=K_ESC; BREAK; endi

SL_MAG->(dbseek(_magazyn))                                          //29.03.03
if _magazyn<>"000"
  if subs(_wersja,20,1)=="P".and._rodz_dok$"PA|PK".and._seria_par<>"  "
      _seria_fak:=_seria_par
  else
    _seria_fak:=SL_MAG->SERIA_FAK
  endi
else
  _seria_fak:="00"
endi


@ 1,15 say "Seria :";
       get _seria_fak pict "@K! NN";
      valid if(SERIAFF_OK(),.t.,SZ().and..t.);                //29.09.15 BAFPOL
               .and.(SP_SERIA(_seria_fak).or..t.) .and. ;     //29.09.15 BAFPOL
             Eval({|| devpos(1,58),devout(_seria_fak),.t.})
@ 1,27 say "Rok :" get _rok_fak pict "99" valid ;
             Eval({|| devpos(1,61),devout(_rok_fak),.t.})
@ 1,47 say "Nr :"
@ 1,57 say "/"+"01"+"/"+subs(dtoc(date()),7)
set curs on; read; set cursor off
if lastkey()=K_ESC; BREAK; endi

*------------------------------------------------------------------- //14.04.99
/*_spr_fis:=.f.
if _rodz_dok="PA".or.;
         (_seria_fak=_seria_par.and.!empty(_seria_par).and._rodz_dok$"FA,RA")
   _spr_fis:=.t.
elseif empty(_seria_par).and.subs(_wersja,20,1)="P"
  _spr_fis:=;
    QTN("Rachunek/faktura do sprzeday detalicznej na paragony fiskalne ?")
endi
if _spr_fis                         
  QKE("Nie mona anulowa dokumentw do fiskalnej sprzeday detalicznej !")
  BREAK
endi*/
*--------------------------------------------------------------------
_anu_ok:=.f.

FAK_BOTTOM(_rodz_dok,_seria_fak,ep(_rok_fak))  //!
_nr_fak:=NR_DOK
go top

@ 1,52  get _nr_fak pict "99999";
       when SLGETFAK(1);
       valid SZ().and. ;
      (SPR_N->(dbseek(_rodz_dok+_seria_fak+ep(_rok_fak)+_nr_fak))) .and. ; //!
             SLGETFAK()

set curs on; read; set cursor off
if lastkey()=K_ESC; BREAK; endi


#ifndef WINDOWS
if SPR_N->AUTO$"pP" .and. !"K"$_rodz_dok
                                                              //29.09.15 BAFPOL
//  QKE("Nie mona anulowa dokumentw do fiskalnej sprzeday detalicznej !")
  if !QTN("Anulowanie dokumentu do fiskalnej sprzeday detalicznej ?")
    BREAK
  endi
endi
#endif

sele 0  //"S"
if empty(_gdzie_fir)
  if !_use("KON","S"); BREAK; endif
  set index to KON_NR, KON_NA, KON_NI, KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","S","KON"); BREAK; endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi


sele SPR_N
set order to 1
seek _rodz_dok+_seria_fak+ep(_rok_fak)+_nr_fak  //!


if eof(); BREAK;  endi

_exp_war1:=.f.
if EXPORT$"VE" ;_exp_war1:=.t.; endi

if SPR_N->WPLATA>0 .and. _jest_kasa="T"

  sele 0
  USE_RAP("R!","RAP_KAS")                              //K
/*
  _use("RAP_KAS","R!")
  set index to RAP_KAS
*/
  go bottom
  if SPR_N->DATA_DOK<=DATA_DO
    TONE(220,5) 
    QKE("        Nie mona anulowa faktury z dat "+dtoc(SPR_N->DATA_DOK)+" !",;
        "Dokonano wpaty gotwkowej, ktra wesza do raportu kasowego.")
    BREAK
  endif
  close RAP_KAS
endif

sele SPR_N
_nr_mag:=NR_MAG
copy next 1 to (_sc+"ZBN_R")
close SPR_N

sele 0
if _nr_mag="000"
  if !_use("SPR_U","R","SPR_P");  BREAK;  endif
  set inde to SPR_U_NR
else
  if !_use("SPR_P","R");  BREAK;  endif
  set inde to SPR_P_NR
endi

*------------------------------ SPR_P_NR = RODZAJ_DOK+SERIA_FAK+ROK_DOK+NR_DOK
*------------------------------ SPR_P_DS = dtos(DATA_DOK)+SERIA_FAK

seek _rodz_dok+_seria_fak+ep(_rok_fak)+_nr_fak  //!

* if eof(); BREAK;  endi                                             //28.07.01

copy  to (_sc+"ZBP_R") while RODZAJ_DOK==_rodz_dok .and.;
                             SERIA_FAK==_seria_fak .and.;
                             ROK_DOK==ep(_rok_fak) .and.;    //!
                             NR_DOK==_nr_fak  

close SPR_P

*if file("SPR_T.DBF").and.file("FAK_TXT.DBF").and._nr_mag<>"000"  //04.03.96

_fak_exp:=.f.

if file("SPR_T.DBF").and.file("FAK_TXT.DBF")       //MOTIP

  sele 0
  if !_use("SPR_T","R");  BREAK;  endif
  set inde to SPR_T_NR
  seek _rodz_dok+_seria_fak+ep(_rok_fak)+_nr_fak  //!

  if _exp_war1 
    loca for "|W"$LINIA while RODZAJ_DOK+SERIA_FAK+ROK_DOK+NR_DOK==;
              _rodz_dok+_seria_fak+ep(_rok_fak)+_nr_fak .and. !eof()
    if found()
      _fak_exp:=.t.
    endi
  endi 

  if eof(); tone(880,0.5) ;  endif  // bez treci

  seek _rodz_dok+_seria_fak+ep(_rok_fak)+_nr_fak  //!
  copy  to (_sc+"FAK_TXT") while RODZAJ_DOK==_rodz_dok .and.;
                                 SERIA_FAK==_seria_fak .and.;
                                 ROK_DOK==ep(_rok_fak) .and.;  //!
                                 NR_DOK==_nr_fak  
  close SPR_T
  if !_use(_sc+"FAK_TXT","R");  BREAK;  endif
endi


if _nr_mag<>"000"

  sele 0                        // -------------------------- ceny przekazania
  if !_use("SL_G_MAG","R"); BREAK; endif
  set index to SL_G_MAG

  SL_MAG->(dbseek(_nr_mag)) 
  seek SL_MAG->GRUPA_MAG
  _ceny_prz:=CENY_PRZ
  close SL_G_MAG
else
  _ceny_prz:=" "
endi
close SL_MAG

sele 0
if _nr_mag<>"000"

  if !_use("TOW","S"); BREAK; endi 
  set index to TOW_IN, TOW_NA, TOW_GR, TOW_SW
else
  if !_use("SL_USL","S"); BREAK; endi
  set index to SL_USL_I,SL_USL_N
endi

sele 0
if !_use("QSPR_N","R"); BREAK; endif
copy stru to (_sc+"SPR_N_R")
use

_use(_sc+"SPR_N_R","E!","SPR_N_R")
appe from (_sc+"ZBN_R")
set rela to NR_KON into KON
_nr_cen_spr:=CENNIK_S

sele 0
if !_use("QSPR_P","R"); BREAK; endif
copy stru to (_sc+"SPR_P_R")
use

sele 0
_use(_sc+"SPR_P_R","E!","SPR_P_R")
appe from (_sc+"ZBP_R")
if _nr_mag<>"000"
  set rela to s_i(INDEKS) into TOW
  _sel_tow:=select("TOW")
  
  _pom_cs1:= Eval(memvarblock("_ceny_"+_nr_cen_spr))    //"B" lub "N"
  _pom_cs2:= fieldwblock("CENA_"+_nr_cen_spr,_sel_tow) // cena z TOW

  repl all CENA_CEN_S with;
      if(_pom_cs1="N",Eval(_pom_cs2),Eval(_pom_cs2)/(1+val(SPR_P_R->VAT)/100))
endi

sele SPR_N_R
@ 1,65 say "Data : "+dtoc(DATA_DOK)
if "K"$_rodz_dok
  @ 2,0 say "Korekta "+if("F"$_rodz_dok,"faktury " ,"rach. ")+;
             RODZAJ_KOR+"-"+NR_KOR+"/"+SERIA_KOR+"/"+ROK_KOR 
  @ 2,31 say "z "+dtoc(DATA_KOR)
endif

@ 2,45 say "Konto : "+KONTO

if _nr_mag<>"000"
  @ 2,61 say "Nr WZ  "+NR_WZ+"/"+NR_MAG+"/"+ROK_WZ
endi

@ 3,0  say "Patnik :  "+NR_KON
@ 3,19 say subs(NAZWA_KON,1,40)
@ 3,61 say "NIP : "+ID_KON
@ 4,11 say KOD 
@ 4,19 say MIASTO
@ 4,40 say ADRES 

@ 5,0 say  "Sposb zapaty :   "+SPOSOB_PLA
@ 5,47 say "Termin : "+str( TERMIN ,3)
@ 5,61 say "Data zap.: "+dtoc(DATA_PLA)
@ 6,0 say  "Uwagi :    "+ UWAGI
if (RABAT+PREMIA) <> 0; @ 6,53 say "Rabat : "+transform((RABAT+PREMIA),"99.9")+ " %"; endif

sele SPR_P_R
if _nr_mag<>"000"
  repl all NAZWA_TOW with TOW->NAZWA_TOW,;
         OPIS_TOW  with if(_opis_tow,OPIS_TOW,TOW->OPIS_TOW),;
         JM        with TOW->JM,;
         NR_MAG    with _nr_mag
endi

go top
if _nr_mag<>"000"
  _wer:="V1|V_DATA_DOS().and.V_CENY_SPR().and.V_CENA_PRZ().and.V_VAT()"
else
  _wer:="V2|V_VAT()"
endi

@ 7,0 clear to 24,79
_li=iif(_ceny_prz="T",1,0)

_li=2+if(_ceny_spr="T",1,0)+iif(_ceny_prz="T",1,0)+;
      if(!empty(SPR_N_R->(RABAT+PREMIA)),1,0)

@ 24-_li,35 say "Kwota netto      Podatek VAT     Kwota brutto"
if _udocezak
  @ row()+1,0 say  "Warto wg cen zakupu :"  
  @ row(),31 say transform(SPR_N_R->WART_ZAK,_format_war)
endi
@ row()+1,0 say "Warto wg cen sprzeday :"
_wart_n_spr:=SPR_N_R->WART_NET_+SPR_N_R->WART_NET0+SPR_N_R->WART_NET1+;
             SPR_N_R->WART_NET2+SPR_N_R->WART_NET3+SPR_N_R->WART_NET4
_wart_v_spr:=SPR_N_R->WART_VAT1+SPR_N_R->WART_VAT2+;
             SPR_N_R->WART_VAT3+SPR_N_R->WART_VAT4
@ row(),31 say transform(_wart_n_spr,_format_war)
@ row(),48 say transform(_wart_v_spr,_format_war)
@ row(),65 say transform(_wart_n_spr+_wart_v_spr,_format_war)
if !empty(SPR_N_R->(RABAT+PREMIA))
  @ row()+1,0 say "Warto rabatu netto: "
  @ row(),31  say  transform(SPR_N_R->BONIFIKATA,_format_war)
endif
if _ceny_prz="T"
  @ row()+1,0 say "Warto wg cen przekazania :"
  @ row(),31 say transform(SPR_N_R->WART_PRZ,_format_war)
endi

CPEDIT  POZ: 7,,23-_li,           ;
        DEF: "SPR_P"               ;
        POZWER: _wer              ;
        POZSLAD: spac(1)+;
             if(_nr_mag<>"000",TOW->NAZWA_TOW+spac(1)+TOW->OPIS_TOW,;
             TRESC+spac(4));
        PION: 7,,23-_li,          ;
        PIONWER: _wer             ;
        EDYCJA: .f.               ;
        ODTWORZ:.F.        

                                                                     //04.03.96
*if file("SPR_T.DBF").and.file("FAK_TXT.DBF").and._nr_mag<>"000".and.;
*   FAK_TXT->(lastrec())>0        
if file("SPR_T.DBF").and.file("FAK_TXT.DBF").and.;
   FAK_TXT->(lastrec())>0        //MOTIP

   EDYCJA_TXT(.f.)           
   ODBIORCA_TXT(.f.)                                                 //05.11.99

   sele FAK_TXT
   go top
   loca for subs(LINIA,1,4)=="|ZAL"
   if found()                                                       
     _f_zal:=.t.
     copy to (_sc+"FA_ZAL")  for subs(LINIA,1,4)=="|ZAL"
   endi

   sele FAK_TXT
   go top
   loca for "Wystawiono wg dokumentw " $ LINIA                      //06.11.05
   if found()                                                        //06.11.05
  //   if "Wystawiono wg dokumentw " $ LINIA
     _wwz:=.t.;_awwz:={}
  // go 2
     skip                                                            //06.11.05

     do while !eof()
       _ilewlinii:=NUMAT("WZ-",LINIA)
       for _i:=1 to _ilewlinii
         _poczWZ:=18*(_i-1)+1
         aadd(_awwz,"WZ"+;                          // RODZAJ_DOK
                    subs(LINIA,_poczWZ+9,3)+;       // NR_MAG
                    subs(LINIA,_poczWZ+13,4)+;      // ROK_DOK
                    subs(LINIA,_poczWZ+3,5) )       // NR_DOK
       next
       skip 
     enddo
   endi 

   close FAK_TXT
endi

clos KON

*------------------------------------------------------------------- anulowanie
if !QTN("Anulowanie dokumentu ?")
  BREAK
endi

_anu_ok:=.f.

if _bierny="T".or._bierny="X".or.;
   (!empty(subs(_wersja,87,1)).and.;
   val(subs(_wersja,87,1))>=_priorytet.and.SPR_N_R->NR_MAG<>_magazyn)
   close data
   QKE ("Operator nieupowaniony do anulowania dokumentu !")
   BREAK
endi

if !( SPR_N_R->DATA_DOK > _data_blo .and. ;
      ( subs(_wersja,9,1)=="A" .or. SPR_N_R->DATA_DOK=date() ) )
  close data   
  QKE("Faktury z t dat nie mona anulowa !")
  BREAK
endi

if subs(_wersja,149,1)="L".and.SPR_N_R->(fieldpos("LAPTOP")>0.and.LAPTOP="*")
   close data
   QKE ("Faktur mona anulowa tylko w centrali !")
   BREAK
endi

if subs(_wersja,149,1)="C".and.SPR_N_R->(fieldpos("LAPTOP")>0.and.LAPTOP="+")
   close data
   QKE ("Faktur mona anulowa tylko na laptopie !")
   BREAK
endi

_kwo_zap:=SPR_N_R->WART_ZAP-SPR_N_R->WPLATA-SPR_N_R->WN
if zaokr(_kwo_zap,2)<>0
  close data
  QKE("Uwaga ! Po wystawieniu faktury wprowadzono zapat "+;
       transform(_kwo_zap,_format_war)+" z.",padc("Wycofaj zapat !",70))
  BREAK
endif
if !HASLO(2)
*  QKE("Nie anulowano dokumentu !")
  BREAK
endi

*if subs(_wersja,49,1)<>"H"                                          //03.09.02
 INFO_LOG("Anulowanie faktury "+SPR_N_R->(RODZAJ_DOK+" "+NR_DOK+"/"+SERIA_FAK+;
                      "/"+subs(ROK_DOK,3,2)),"SPR_N_R") 
*endi


QPC(1)
*------------------------------------------------------------------------------

if _nr_mag<>"000"


  if _nr_mag="001"                                            //01.12.14 BAFPOL

    sele 0                                               
    if !_use("FIRANY","F","MFIRAN"); BREAK; endi                    
    set index to FIRANY_I,;        //s_i(INDEKS)+str(KLASA,3)
                 FIRANY_N          //NAZWA_TOW+str(KLASA,3)
  endi


  sele 0
  _zb:="MAG"+_nr_mag
  _i1:="M"+_nr_mag+"_IP"      // indeks + pozycja
  _i2:="M"+_nr_mag+"_N"       // nazwa
  _i3:="M"+_nr_mag+"_IP0"     // indeks + pozycja (bez stanow zerowych)
  _i4:="M"+_nr_mag+"_N0"      // nazwa (bez stanow zerowych)
  if !_use(_zb,"F","MAG"); BREAK; endi                      //30.11.2014 BAFPOL
  set inde to (_i1), (_i2),(_i3), (_i4)

  sele 0 
  _zb:="DOK"+_nr_mag+"N"
  _i1:="D"+_nr_mag+"N"+"_NR"
  _i2:="D"+_nr_mag+"N"+"_RD"
  if !_use(_zb,"F","DOKN"); BREAK; endi
  set inde to (_i1), (_i2)

  sele 0
  if !_use("SPR_N","F"); BREAK; endi
  set inde to SPR_N_NR,SPR_N_SD,SPR_N_KO,SPR_N_DA,SPR_N_VA

  sele 0
  _zb:="DOK"+_nr_mag+"P"
  _i1:="D"+_nr_mag+"P"+"_NR"
  _i2:="D"+_nr_mag+"P"+"_DI"
  if !_use(_zb,"F","DOKP"); BREAK; endi
  set inde to (_i1), (_i2)

  sele 0
  if !_use("SPR_P","F"); BREAK; endi
  set inde to SPR_P_NR,SPR_P_DS

else

  sele 0
  if !_use("SPR_N","F"); BREAK; endi
  set inde to SPR_N_NR,SPR_N_SD,SPR_N_KO,SPR_N_DA,SPR_N_VA

  sele 0
  if !_use("SPR_U","F","SPR_P"); BREAK; endi
  set inde to SPR_U_NR,SPR_U_DS

endi

if file("SPR_T.DBF")               //MOTIP

  sele 0
  if !_use("SPR_T","F"); BREAK; endi
  set inde to SPR_T_NR
endi

if SPR_N_R->WPLATA<>0

  sele 0
  if !_use("ZAP","F"); BREAK; endi
  set index to ZAP_DD, ZAP_DS, ZAP_KO, ZAP_FA
endi

if _jest_kasa="T".and.SPR_N_R->WPLATA<>0                 

  _jaki:=if(SPR_N_R->WPLATA>0,"KP","KW")

  sele 0
  if !USE_KPW_N(_jaki,"F",_jaki+"_N"); BREAK; endi 

  sele 0
  if !USE_KPW_P(_jaki,"F",_jaki+"_P"); BREAK; endi 

endi

if _nr_mag<>"000"

  sele DOKN
  seek "WZ"+_nr_mag+SPR_N_R->ROK_WZ+SPR_N_R->NR_WZ
  if AUTO="T"
    _z_wz:=.f.
    dele
  elseif _wwz
    _z_wz:=.t.
    CPClose(DOKP)  
  
    for _i:=1 to len(_awwz)
      seek(_awwz[_i])
      repl AUTO with " ",NR_FAK with "",RODZAJ_FAK with "",ROK_FAK with "",;
           SERIA_FAK with "", UWAGI with subs(UWAGI,1,at(" (",UWAGI))
    next
  else
    _z_wz:=.t.
    CPClose(DOKP)  

    repl AUTO with " ",NR_FAK with "",RODZAJ_FAK with "",ROK_FAK with "",;
         SERIA_FAK with ""
  endi
  dbcommit()
* close DOKN
endi

if _nr_mag<>"000".and.!_z_wz

  sele DOKP 
  if SPR_P_R->(lastrec())=0                                          //28.07.01
    seek "WZ"+_nr_mag+SPR_N_R->ROK_WZ+SPR_N_R->NR_WZ
    copy to (_sc+"POZ_WZ");
         while RODZAJ_DOK="WZ".and.ROK_DOK=SPR_N_R->ROK_WZ.and.;
               NR_DOK=SPR_N_R->NR_WZ
  
    sele SPR_P_R
    appe from (_sc+"POZ_WZ")
    repl all NAZWA_TOW with TOW->NAZWA_TOW
    dele file (_sc+"POZ_WZ.DBF")

    sele DOKP
  endi

  seek "WZ"+_nr_mag+SPR_N_R->ROK_WZ+SPR_N_R->NR_WZ
  dele while RODZAJ_DOK="WZ".and.ROK_DOK=SPR_N_R->ROK_WZ.and.;
             NR_DOK=SPR_N_R->NR_WZ
  dbcommit()
* close DOKP
endi

*--------------------------------------------------------------------- magazyny

if _nr_mag<>"000"

  sele MAG
  set rela to s_i(INDEKS) into TOW

  sele SPR_P_R
  go top
  do while .not.eof().and.!_z_wz
    do case
      case _rozchody="1";      _k1:=s_i(INDEKS)+s_c(CENA_ZAK)
      case _rozchody="2";      _k1:=s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK)
    endc

    sele MAG
    set orde to 1
    seek _k1
    if eof()  // ew. dla  dok zwrotnych
      tone(880,0.5)
      appe blan
      repl INDEKS with SPR_P_R->INDEKS,;
           CENA_ZAK with SPR_P_R->CENA_ZAK,;
           DATA_DOS with SPR_P_R->DATA_DOS
    endi
    repl STAN     with STAN-SPR_P_R->ZNAK*SPR_P_R->ILOSC,;
         DATA_AKT with date()

    if subs(_wersja,2,1)<>"P"  
      _mian:=(STAN-SPR_P_R->ZNAK*SPR_P_R->ILOSC)

      if _mian>0          // wielce wtpliwe skd w SPR_P_R ceny przekazania !
        repl CENA_PRZ with ;
         (STAN*CENA_PRZ-(SPR_P_R->ZNAK*SPR_P_R->ILOSC*SPR_P_R->CENA_PRZ))/_mian
      endi

    elseif _ceny_prz="T"                                   //04.03.96
        repl SPR_P_R->CENA_PRZ with MAG->CENA_PRZ
    endi

    skip 0
    dbcommit()
  
    sele SPR_P_R
    skip
  endd

  close MAG  //zamykamy
endi

sele SPR_N_R
_wplata:=WPLATA;  _wart_zap:=WART_ZAP

*---------------------------------------------------------------------- faktury

sele SPR_P  // jest to SPR_P.DBF lub SPR_U.DBF
seek SPR_N_R->RODZAJ_DOK+SPR_N_R->SERIA_FAK+SPR_N_R->ROK_DOK+SPR_N_R->NR_DOK
dele while RODZAJ_DOK=SPR_N_R->RODZAJ_DOK.and.ROK_DOK=SPR_N_R->ROK_DOK.and.;
           NR_DOK=SPR_N_R->NR_DOK.and.SERIA_FAK=SPR_N_R->SERIA_FAK
dbcommit()
* clos SPR_P

if file("SPR_T.DBF")               //MOTIP

  sele SPR_T
  seek SPR_N_R->RODZAJ_DOK+SPR_N_R->SERIA_FAK+SPR_N_R->ROK_DOK+SPR_N_R->NR_DOK
  dele while RODZAJ_DOK=SPR_N_R->RODZAJ_DOK.and.ROK_DOK=SPR_N_R->ROK_DOK.and.;
           NR_DOK=SPR_N_R->NR_DOK.and.SERIA_FAK=SPR_N_R->SERIA_FAK
  dbcommit()
* clos SPR_T
endi


sele SPR_N
seek SPR_N_R->RODZAJ_DOK+SPR_N_R->SERIA_FAK+SPR_N_R->ROK_DOK+SPR_N_R->NR_DOK

_firany:=SPR_N->FIRANY                                        //01.12.14 BAFPOL

dele
dbcommit()
* close SPR_N

if _f_zal 
  AKTU_ZAL("A")
endi

*-------------------------------------------------------------//01.12.14 BAFPOL
if select("MFIRAN")>0.and.len(_firany)>0

  CPClose(FIRANY)
  dele file (_sc+"FIRANY.DBF")

  sele 0
  _astru:={}
  aadd(_astru,{"INDEKS    ","C",20,0})
  aadd(_astru,{"NAZWA_TOW ","C",30,0})
  aadd(_astru,{"OPIS_TOW  ","C",20,0})
  aadd(_astru,{"JM        ","C", 4,0})
  aadd(_astru,{"KLASA   ","N", 3,0})
  aadd(_astru,{"STAN      ","N", 4,0})
  dbcreate(_sc+"FIRANY",_astru)

  _use(_sc+"FIRANY","E!")
  inde on s_i(INDEKS)+str(KLASA,3)              to (_sc+"FIRA_I")
  set inde to (_sc+"FIRA_I")
  set rela to s_i(INDEKS) into TOW

  for _i:=1 to MLCount(_firany)
    _fir:=MemoLine(_firany,,_i)
    FIRANY->(dbappend())
    FIRANY->INDEKS:=s_i(alltrim(subs(_fir,1,at(";",_fir)-1)))
    _fir:=subs(_fir,at(";",_fir)+1)
    FIRANY->KLASA:=val(_fir) 
    _fir:=subs(_fir,at(";",_fir)+1)
    FIRANY->STAN:=val(_fir)
  next

  QK("AKTUALIZACJA MAGAZYNU FIRAN")

  _znakf:=1.0

  sele FIRANY
  go top
  do while !eof()

    sele MFIRAN
    set rela to s_i(INDEKS) into TOW
    dbseek(s_i(FIRANY->INDEKS)+str(FIRANY->KLASA,3))
    if eof()
      MFIRAN->(dbappend())   
      MFIRAN->INDEKS:=s_i(FIRANY->INDEKS)
      MFIRAN->KLASA:=FIRANY->KLASA
      DAJ_F()
    endi
    MFIRAN->STAN+=_znakf*FIRANY->STAN

    sele FIRANY 
    skip
  endd  
  MFIRAN->(dbunlock())
  
endi
CPClose(FIRANY)
CPCLose(MFIRAN)
*----------------------------------------------------------------- koniec firan

*---------------------------------------------------------------------- zapaty
if SPR_N_R->WPLATA<>0

  sele ZAP
  set orde to 3
  seek SPR_N_R->NR_KON
  locate for RODZAJ_DOK=SPR_N_R->RODZAJ_DOK.and.ROK_FAK=SPR_N_R->ROK_DOK.and.;
           NR_FAK=SPR_N_R->NR_DOK.and.SERIA_FAK=SPR_N_R->SERIA_FAK.and.;
           AUTO="T" while NR_KON=SPR_N_R->NR_KON
  if found(); dele; dbcommit(); endif  //17.10.96
*  clos ZAP
endi

*------------------------------------------------------------------------- kasa
if _jest_kasa="T".and.SPR_N_R->WPLATA<>0                             //13.03.99

  sele (_jaki+"_P")
  set orde to 2
  seek SPR_N_R->NR_KON
  loca for RODZAJ_DOK=SPR_N_R->RODZAJ_DOK.and.ROK_FAK=SPR_N_R->ROK_DOK.and.;
           NR_FAK=SPR_N_R->NR_DOK.and.SERIA_FAK=SPR_N_R->SERIA_FAK while ;
           NR_KON=SPR_N_R->NR_KON

  _nr_zap:=""
  if found()
   _nr_zap:=NR_ZAP; _ro_zap:=ROK_ZAP
  dele for RODZAJ_DOK=SPR_N_R->RODZAJ_DOK.and.ROK_FAK=SPR_N_R->ROK_DOK.and.;
           NR_FAK=SPR_N_R->NR_DOK.and.SERIA_FAK=SPR_N_R->SERIA_FAK while ;
           NR_KON=SPR_N_R->NR_KON
  endi
  dbcommit()
  * close (_jaki+"_P")    

  if !empty(_nr_zap)

    sele (_jaki+"_N")
    seek _ro_zap+_nr_zap
    dele
    dbcommit()
  * close (_jaki+"_N")    
  endif

endif

CPClose(DOKN)
CPClose(SPR_N)
CPClose(DOKP)
CPClose(SPR_P)
CPClose(SPR_T)
CPClose(ZAP)
CPClose(KP_N)
CPClose(KW_N)
CPClose(KP_P)
CPClose(KW_P)

*######################

*-------------------------------------------------------------------------- KON
if !empty(SPR_N_R->NR_KON)

  sele 0  // "F!"
  if empty(_gdzie_fir)
    _use("KON","F!")
    set index to KON_NR, KON_NA, KON_NI, KON_AD
  else
    _use(_gdzie_fir+"FIRMY","F!","KON")
    set index to (_gdzie_fir+"FIRMY_NR"), (_gdzie_fir+"FIRMY_NA"),;
                 (_gdzie_fir+"FIRMY_NI"), (_gdzie_fir+"FIRMY_AD")
  endi

  seek SPR_N_R->NR_KON
  repl WN_ODB with WN_ODB-SPR_N_R->WART_ZAP,;
       MA_ODB with MA_ODB-SPR_N_R->WPLATA
  clos KON
endif

*----------------------------------------------------------------------- premie
if SPR_N_R->WART_PRE>0
  _wart_pre:=SPR_N_R->WART_PRE

  sele 0
  _use("PREMIE","F!")
  set index to PREMIE
  dbseek(subs(SPR_N_R->NR_KON,1,4)+chr(asc(subs(SPR_N_R->NR_KON,5,1))+1),.t.)
  skip -1
  if !NR_KON==SPR_N_R->NR_KON.or._wart_pre<0
    QKE("Nie anulowano naliczonej premii specjalnej !")
  else
    do while NR_KON==SPR_N_R->NR_KON.and._wart_pre>0.001.and.!bof()
      if PREMIA-MA<=0
        skip -1
        loop
      endi
      p:=min(PREMIA-MA,_wart_pre)
      PREMIE->MA+=p
      _wart_pre-=p 
      skip -1
    endd
    if _wart_pre>0.001
      dbseek(SPR_N_R->NR_KON)
      PREMIE->MA+=_wart_pre
    endi
    dbcommit()
  endi
  clos PREMIE
endi

*---------------------------------------------------------- koniec aktualizacji

sele SPR_N_R
// copy to (_sc+"S"+_rodz_dok+"_N_R")

if !file("SPR_I.DBF")
  copy stru to SPR_I
endi

*--------------------

if _fak_exp 

  sele SPR_P_R
  repl all CENA_SPR with CENA_WAL,;
           CENA_PRZ with 0,;
           VAT with " 0",;
           MARZA with 0
  if subs(_wersja,36,1)=="2"  // wyliczanie od tylu pola BONIFIKATA
    repl all BONIFIKATA with CENA_SPR*;
           (100+min(SPR_N_R->(RABAT+PREMIA),100))/ 100/_mnoznik
  else
    repl all BONIFIKATA with CENA_SPR/;
        (100-min(SPR_N_R->(RABAT+PREMIA),100))*100/_mnoznik
  endif

  sum ;
      if(VAT=" 0",zaokr( ILOSC*CENA_SPR, 2),0),;
      zaokr( (zaokr(BONIFIKATA*_mnoznik,2)-CENA_SPR)*ILOSC, 2);
      to _wart_n_0, _wart_b
  if "."$_format_ilo
    _wart_n_0:=zaokr(_wart_n_0,2)
  endi

  _wart_n_spr:=_wart_n_0

  repl SPR_N_R->WART_PRZ  with 0,;
       SPR_N_R->WART_NET_ with 0,  SPR_N_R->WART_NET0 with _wart_n_0,;
       SPR_N_R->WART_NET1 with 0,  SPR_N_R->WART_NET2 with 0,;
       SPR_N_R->WART_VAT1 with 0,  SPR_N_R->WART_VAT2 with 0,;
       SPR_N_R->WART_VAT3 with 0,  SPR_N_R->WART_NET3 with 0,;
       SPR_N_R->WART_VAT4 with 0,  SPR_N_R->WART_NET4 with 0,;
       SPR_N_R->BONIFIKATA with _wart_b,   SPR_N_R->RABAT_NET with 0,;
       SPR_N_R->WART_ZAP  with _wart_n_0,  SPR_N_R->WPLATA    with 0
endi
*--------------------

clos SPR_N_R   

sele 0
_use("SPR_I","E!")
appe from (_sc+"SPR_N_R")     //03.11.96
repl UWAGI with dtoc(date())+" "+_operator+" "+UWAGI
use



clos SPR_P_R   

if file("SPR_IP.DBF")           //22.03.00
  _use("SPR_IP","E!")
  appe from (_sc+"SPR_P_R")     //03.11.96
  use
endi


*------------------------------------------------------------------------------
_zapisal:=.f.
if !subs(_wersja,77,1)$"Bb"
  for i:=0 to 9          // 03.11.96
    _nr:=str(i,1)
    if !file(_sc+"S"+_rodz_dok+"_NRA"+_nr+".DBF").and.;
       !file(_sc+"S"+_rodz_dok+"_NRA"+_nr+".DBF").and.;
       !file(_sc+"FAK_TXA"+_nr+".DBF")                      //24.10.07

 
      rena (_sc+"SPR_N_R.DBF") to (_sc+"S"+_rodz_dok+"_NRA"+_nr+".DBF")

      if file(_sc+"SPR_N_R.DBT")
        rena (_sc+"SPR_N_R.DBT") to (_sc+"S"+_rodz_dok+"_NRA"+_nr+".DBT")
      endi

      rena (_sc+"SPR_P_R.DBF") to (_sc+"S"+_rodz_dok+"_PRA"+_nr+".DBF")
      rena (_sc+"FAK_TXT.DBF") to (_sc+"FAK_TXA"+_nr+".DBF")
      _zapisal:=.t.
      exit
   endif
  next
else
  for i:=0 to 99          // 03.11.96
    _nr:=trans0(i,2)
    if !file("#00\flaga"+_nr).and.;          
       !file("#00\"+"S"+_rodz_dok+"_NA"+_nr+".DBF").and.;
       !file("#00\"+"S"+_rodz_dok+"_NA"+_nr+".DBF").and.;
       !file("#00\"+"FAK_TA"+_nr+".DBF")                       //24.10.07
  
      _flaga:=fcreate("#00\flaga"+_nr) 
      fclose(_flaga)
      _zapisal:=.t. 
  
      rena (_sc+"SPR_N_R.DBF") to ("#00\"+"S"+_rodz_dok+"_NA"+_nr+".DBF")

      if file(_sc+"SPR_N_R.DBT")
        rena (_sc+"SPR_N_R.DBT") to ("#00\"+"S"+_rodz_dok+"_NA"+_nr+".DBT")
      endi
      rena (_sc+"SPR_P_R.DBF") to ("#00\"+"S"+_rodz_dok+"_PA"+_nr+".DBF")
      rena (_sc+"FAK_TXT.DBF") to ("#00\"+"FAK_TA"+_nr+".DBF")
      dele file ("#00\flaga"+_nr) 
      exit
   endif
  next
endi
QPC(0)
if !_zapisal
  QKE("Nie dokonano zapisu anulowanej faktury.",;
      "     Wyczerpany limit zapisw (10"+if(subs(_wersja,77,1)$"Bb","0","")+;
      ")     ")
endif     
tone(880,0.5)

_anu_ok:=.t.

END SEQUENCE
clos data

if !_anu_ok
  QKE("Nie anulowano dokumentu !")
else
  QKE("Wykonano anulowanie dokumentu !")
endi

dele file (_sc+"WDOKN_R.DBF")
dele file (_sc+"WDOKP_R.DBF")
dele file (_sc+"ZBN_R.DBF")
dele file (_sc+"ZBP_R.DBF")
dele file (_sc+"ZB_R.DBF")

RETURN NIL

*******************************************************************************
FUNCTION KOMPLET()
loca _tex:='۲  KOMPLETACJA ZESTAWW  ',_opcja:=1,m:=0,;
     _astru:={},_p,i,_wzak:=0,_ile_ind:=0,pom,_k1,_zb,_i1,_i2,_i3,;
     _dokument:="",_pomkom1:="",_pomkom2:="",pom1:=0,;
     _cz_mag:=0

priv _nr_mag:=_magazyn,_rodz_dok:="  "
priv _lista_zes:="T",_wertow


cls
@ 0,0 say _tex

if !(file("ZES.DBF").and.subs(_wersja,10,1)$"Zz")
  if !file ("ZES.DBF");  _pomkom1:="Brak pliku ZES.DBF. ";endif
  if !subs(_wersja,10,1)$"Zz";  _pomkom2:='Parametr nr 10 <> "Z".';endif
  QKE("Program nie jest skonfigurowany na obsug zestaww.",;
      _pomkom1+_pomkom2)
  RETURN NIL
endif

BEGIN SEQUENCE

if subs(_wersja,171,1)=="W"
  _lista_zes:="N"
endi

sele 0
if !_use("SL_DOK","R"); BREAK; endif
set index to SL_DOK
set filt to TYP_DOK="+"
if dbseek ("KZ" ); _rodz_dok:="KZ";endi

sele 0
if !_use("SL_MAG","R"); BREAK; endi
set index to SL_MAG

@ 1,0 say "Kontrola stanw wg magazynu :" get _nr_mag pict "999" ;
      when SLGET("SL_MAG","SL_MAG","V1",1,1,{"magazyn"},,.f.);
      vali (SZ().and.SL("SL_MAG","SL_MAG","V1",1,1)).and. SLGET()


@ 1,col()+3 say "Dokument :" get _rodz_dok pict "@! AA";
                            when SLGET("SL_DOK","SL_DOK","V2",1,1,;
                                 {""},,.f.,BEZBLOK);
                            valid  SL("SL_DOK","SL_DOK","V2",1,1)

@ 2,0 say "Podpowied listy zestaww:" get _lista_zes pict "@! A";
           valid _lista_zes$"TN"
set  curs on; read; SLGET(); set curs off
if lastkey()=K_ESC; BREAK; endi

close SL_MAG
close SL_DOK
sele 0
if !_use("MAG"+_nr_mag,"R","MAG"); BREAK; endi 
set inde to ("M"+_nr_mag+"_IP"), ("M"+_nr_mag+"_N"),;
            ("M"+_nr_mag+"_IP0"), ("M"+_nr_mag+"_N0")

sele 0
if !_use("ZES","R"); BREAK; endi
set index to ZES_I,ZES_E


sele 0
if !_use("TOW","R"); BREAK; endi
set index to TOW_IN, TOW_NA, TOW_GR, TOW_SW
copy stru to (_sc+"ZESUNI") fields INDEKS,NAZWA_TOW,OPIS_TOW,JM

sele 0
_use(_sc+"ZESUNI","E!")
index on INDEKS to (_sc+"ZESUNI") 
if _lista_zes="T"

/*
@ 23,0 say "Budowanie listy zestaww - etap 1/2 ...."
sele ZES
_total:=lastrec()
PASEK()
total on s_i(INDEKS) to (_sc+"ZESUNI") for PASEK(10).and.ILOSC>0
PASEK()

sele 0
_use(_sc+"ZESUNI","E!")
_total:=1.1*lastrec()
PASEK()
@ 23,0 say "Budowanie listy zestaww - etap 2/2 ...."
set rela to s_i(INDEKS) into TOW
repl all NAZWA_TOW with TOW->NAZWA_TOW,;
         OPIS_TOW with TOW->OPIS_TOW,;
         JM       with TOW->JM for PASEK(10)

index on INDEKS to (_sc+"ZESUNI")
PASEK()
@ 23,0
set rela to
go top
*/


sele ZES
_total:=lastrec()
@ 23,0 say "Budowanie listy zestaww -  ...."
PASEK()

dbeval({|| STOP_ZEST(),ZESUNI->(dbseek(ZES->INDEKS)),;
           if(ZESUNI->(found()),NIL,;
             (ZESUNI->(dbappend()),;
              ZESUNI->INDEKS:=ZES->INDEKS,;
              TOW->(dbseek(s_i(ZESUNI->INDEKS))),;
              ZESUNI->NAZWA_TOW:=TOW->NAZWA_TOW,;
              ZESUNI->OPIS_TOW:=TOW->OPIS_TOW,;
              ZESUNI->JM:=TOW->JM))},{|| ILOSC>0.and.PASEK(10,,'') })       
PASEK()
@ 23,0
else
  _wertow:="V7|V_OPISY_TOW().and.V_OPAK().and.V_INDEKS_SWW().and.V_ZESTAW()"+;
      ".and.V_ILOSC_JM().and.V_KAU().and.V_WAL().and.V_KONCES().and."+;
      "V_KOD_P().and.V_TARA().and.V_ELZA()" //21.11.99
endi

_astru:={}
aadd(_astru,{"INDEKS    ","C",LENIN,0})
aadd(_astru,{"ILOSC     ","N",10,3})
aadd(_astru,{"STAN      ","N",10,3})
aadd(_astru,{"ILOSC_MAX ","N",10,3})
dbcreate(_sc+"ROBKOM",_astru)

sele 0
_use(_sc+"ROBKOM","E!")
set rela to s_i(INDEKS) into TOW

_astru:={}
aadd(_astru,{"INDEKS    ","C",LENIN,0})
aadd(_astru,{"STAN      ","N",10,3})
dbcreate(_sc+"ROBMAG",_astru)

sele 0
_use(_sc+"ROBMAG","E!")
index on INDEKS to (_sc+"ROBMAG") 

sele ROBKOM
go top
do while .t.
  @ 2,0 clear to 24,79

  sele ROBKOM
  go top
  CPEDIT POZ: 2,,23,           ;
         DEF: "KOMPLET"        ;
         POZWER: "V1|V_OPISY_TOW()"          ;
         PION: ,,,             ;
         EDYCJA: .t.           ;
         KASOWANIE: .t.        ;
         DODAWANIE: .t.        ;
         CZYDODAC: .t.         ;
         ODTWORZ:.f.           ;

// 0.
  inde on s_i(INDEKS) to (_sc+"RK")
  total on INDEKS to (_sc+"ROBKOM2") fields ILOSC
  CPClose(ROBKOM)

  sele 0
  _use (_sc+"ROBKOM2","E!")
  copy to (_sc+"ROBKOM")
  CPClose(ROBKOM2)

  sele 0
  _use(_sc+"ROBKOM","E!")
  set rela to s_i(INDEKS) into TOW

// 1.
  dbeval({|| ZES->(dbseek(s_i(ROBKOM->INDEKS))),;
             ZES->(dbeval({||;
             ROBMAG->(dbseek(ZES->INDEKS_E)),;
             if(ROBMAG->(found()),NIL,;
               (ROBMAG->(dbappend()),;
                ROBMAG->INDEKS:=ZES->INDEKS_E,;    
                ROBMAG->STAN:=ROBMAG->(STAN_IND())))};
             ,,{||ROBKOM->INDEKS==ZES->INDEKS}))})

*  priv m  
           *  ROBKOM->STAN:=STAN_IND(),;               
//2.
  dbeval({|i| i:=ILOSC,;
             ZES->(dbseek(s_i(ROBKOM->INDEKS))),;
             m:=999999,;
             ZES->(dbeval({|e| ROBMAG->(dbseek(ZES->INDEKS_E)),;
                            e:=ROBMAG->STAN,;
                            m:=max(0,min(m,int(e/ZES->ILOSC)))},,;
                  {||ROBKOM->INDEKS==ZES->INDEKS})),;
             ROBKOM->ILOSC_MAX:=m,;
             ZES->(dbseek(s_i(ROBKOM->INDEKS))),;
             ZES->(dbeval({|| ROBMAG->(dbseek(ZES->INDEKS_E)),;
                            ROBMAG->STAN-=min(m,ROBKOM->ILOSC)*ZES->ILOSC},,;
                  {||ROBKOM->INDEKS==ZES->INDEKS})) })


  sele ROBKOM
  go top
  CPEDIT POZ: 2,,23,           ;
         DEF: "KOMPLET"        ;
         POZWER: "V3|V_OPISY_TOW()"          ;
         PION: ,,,             ;
         ODTWORZ:.f.           ;

  go top
//3.
  loca for ILOSC>ILOSC_MAX

  if found()
    tone(440,.5)
    if QTN_2W("    Wymaganej liczby zestaww nie mozna skompletowa !",;
              "Ograniczy ilo zestaww zgodnie ze stanem w elementach ?")
       repl all ILOSC with ILOSC_MAX for ILOSC>ILOSC_MAX
    endi
    sele ROBMAG
    repl all STAN with STAN_IND()
    loop
  endi

/*
   1. buduje stany zbiorcze elementow   - ROBMAG.DBF
   2. obliczenie maksymalnej iloci zestaww, ktore mona skompletowa ( pole 
      ILOSC_MAX w ROBKOM ) przydzielajc elementy do  zestaww w kolejnoci 
      w jakiej s w ROBKOM       (bez cena i data)  
   3. porwnanie ILOSC_MAX i ILOSC i  powrt do ptli jeli ILOSC>ILOSC_MAX,
      przed powrotem odwieenie ROBMAG->STAN
   4. po AKCEPTACJA zablokowanie magazynu na Flock i prba rozchodowania
*/

  count to _p
  if _p=0; BREAK;endif

  _opcja:=HorizMenu(24,0,"",{"POPRAWA","AKCEPTACJA","REZYGNACJA"})

  do case
    case _opcja=3 .or. _opcja=0.and.QTN("Rezygnacja ?")
      BREAK
    case _opcja=2

      sele ROBMAG
      repl all STAN with STAN_IND()

      sele ROBKOM
      dbeval({|i| i:=ILOSC,;
            ZES->(dbseek(s_i(ROBKOM->INDEKS))),;
            m:=999999,;
            ZES->(dbeval({|e| ROBMAG->(dbseek(ZES->INDEKS_E)),;
                           e:=ROBMAG->STAN,;
                           m:=max(0,min(m,int(e/ZES->ILOSC)))},,;
                  {||ROBKOM->INDEKS==ZES->INDEKS})),;
             ROBKOM->ILOSC_MAX:=m,;
             ZES->(dbseek(s_i(ROBKOM->INDEKS))),;
             ZES->(dbeval({|| ROBMAG->(dbseek(ZES->INDEKS_E)),;
                            ROBMAG->STAN-=min(m,ROBKOM->ILOSC)*ZES->ILOSC},,;
                  {||ROBKOM->INDEKS==ZES->INDEKS})) })

      loca for ILOSC>ILOSC_MAX

      if found()
         tone(440,.5)
         QKE("Nastpio zmniejszenie stanw magazynowych !",;
             "Wymaganej liczby zestaww "+s_i(INDEKS)+" nie mona skompletowa !")

         if QTN("Ograniczy ilo zestaww zgodnie ze stanem w elementach ?")
            repl all ILOSC with ILOSC_MAX for ILOSC>ILOSC_MAX
         endi
         sele ROBMAG
         repl all STAN with STAN_IND()
         loop
      endi

      exit
  endcase

  sele ROBMAG
  repl all STAN with STAN_IND()

enddo

*----------- akceptacja

close MAG

sele 0
if !_use("MAG"+_nr_mag,"F","MAG"); BREAK; endi 
set inde to ("M"+_nr_mag+"_IP"), ("M"+_nr_mag+"_N"),;
            ("M"+_nr_mag+"_IP0"), ("M"+_nr_mag+"_N0")
set rela to s_i(INDEKS) into TOW

/*
 4. powtrne sprawdzenie czy mozna skompletowac zestawy
 5. jesli mona to rozchodowujemy i tworzymy dokument "KZ" - kompletacja
    zestaww
*/


//4.

sele ROBMAG
repl all STAN with STAN_IND()

sele ROBKOM
dbeval({|i| i:=ILOSC,;
            ZES->(dbseek(s_i(ROBKOM->INDEKS))),;
            m:=999999,;
            ZES->(dbeval({|e| ROBMAG->(dbseek(ZES->INDEKS_E)),;
                           e:=ROBMAG->STAN,;
                           m:=max(0,min(m,int(e/ZES->ILOSC)))},,;
                  {||ROBKOM->INDEKS==ZES->INDEKS})),;
             ROBKOM->ILOSC_MAX:=m,;
             ZES->(dbseek(s_i(ROBKOM->INDEKS))),;
             ZES->(dbeval({|| ROBMAG->(dbseek(ZES->INDEKS_E)),;
                            ROBMAG->STAN-=min(m,ROBKOM->ILOSC)*ZES->ILOSC},,;
                  {||ROBKOM->INDEKS==ZES->INDEKS})) })

loca for ILOSC>ILOSC_MAX

if found()
  tone(440,.5)
  QKE("Nastpio zmniejszenie stanw magazynowych !",;
       "Wymaganej liczby zestaww "+s_i(INDEKS)+" nie mona skompletowa !")
  BREAK
endi

 //5.


* _rodz_dok:="KZ"

sele 0
if !_use("QDOKN","R"); BREAK; endif
copy stru to (_sc+"D"+_rodz_dok+"_N_R")
_use(_sc+"D"+_rodz_dok+"_N_R","E!","DOKN_R")

sele 0
if !_use("QDOKP","R"); BREAK; endif
copy stru to (_sc+"D"+_rodz_dok+"_P_R")
_use(_sc+"D"+_rodz_dok+"_P_R","E!","DOKP_R")

sele ROBKOM
go top
do while !eof()
  i:=ILOSC  //ilo zestaww
  _wzak:=0

  sele MAG                                                           //08.01.03
  set order to 1 
  _cz_mag:=0
  MAG->(dbseek(s_i(ROBKOM->INDEKS)))                               
  do while MAG->(s_i(INDEKS))==s_i(ROBKOM->INDEKS)
    _cz_mag:=MAG->CENA_ZAK
    skip
  endd

  sele ZES
  dbseek(s_i(ROBKOM->INDEKS))

  do while ROBKOM->INDEKS==ZES->INDEKS
    _ile_ind:=i*ZES->ILOSC    // tyle trzeba rozchodowac INDEKS_E

    *---zdjcie z magazynu i przygotowanie pozycji dokumentu

    sele MAG
    set order to 1  //patrz nize dlaczego 1 a nie 3
    seek ZES->(s_i(INDEKS_E))
    pom:=0  // ile rozchodowano
    do while pom<_ile_ind .and. MAG->INDEKS==ZES->INDEKS_E
      if MAG->(STAN-STAN_B)>=_ile_ind-pom   //_ile_ind-pom - tyle trzeba rozchodowac
        MAG->STAN-=_ile_ind-pom
        DOKP_R->(dbappend())
        DOKP_R->INDEKS:=MAG->INDEKS
        DOKP_R->VAT:=TOW->VAT
        DOKP_R->CENA_ZAK:=MAG->CENA_ZAK
        DOKP_R->DATA_DOS:=MAG->DATA_DOS
        DOKP_R->ILOSC:=-(_ile_ind-pom)
        _wzak+=abs(DOKP_R->(ILOSC*CENA_ZAK)   )
        exit
      elseif MAG->(STAN-STAN_B)>0 // jest w magazynie ale na pewno mniej niz chcemy
        pom1:=MAG->(STAN-STAN_B)
        pom+=pom1        // rozchodowujemy wszystko co sie da
        MAG->STAN-=pom1     //dla order 3 po wyzerowaniu stanu skakal na nastepny i skip opuszczal go
        DOKP_R->(dbappend())
        DOKP_R->INDEKS:=MAG->INDEKS
        DOKP_R->VAT:=TOW->VAT
        DOKP_R->CENA_ZAK:=MAG->CENA_ZAK
        DOKP_R->DATA_DOS:=MAG->DATA_DOS
        DOKP_R->ILOSC:=-pom1
        _wzak+=abs(DOKP_R->(ILOSC*CENA_ZAK)   )
      else
      endi
      skip
    enddo
   *------------------
    sele ZES
    skip
  enddo
    
  sele ROBKOM

  *-------------------
  DOKP_R->(dbappend())
  DOKP_R->INDEKS:=INDEKS

  if subs(_wersja,116,1)="F".and._cz_mag>0                           //08.01.03
    DOKP_R->CENA_ZAK:=_cz_mag
  else
    DOKP_R->CENA_ZAK:=_wzak/i
  endi
  DOKP_R->DATA_DOS:=date()
  DOKP_R->ILOSC:=i

  do case
    case _rozchody="1";    _k1:=DOKP_R->(s_i(INDEKS)+s_c(CENA_ZAK))
    case _rozchody="2";    _k1:=DOKP_R->(s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK))
  endc

  sele MAG
  set orde to 1
  seek _k1
  if eof()  // ew. dla  dok zwrotnych
    appe blan
    repl INDEKS with DOKP_R->INDEKS,;
         CENA_ZAK with DOKP_R->CENA_ZAK,;
         DATA_DOS with DOKP_R->DATA_DOS
  endi
  repl STAN  with STAN+DOKP_R->ILOSC,;
       DATA_AKT with date()
  repl DOKP_R->VAT with TOW->VAT
  skip 0
  dbcommit()

  *------------------- 
  sele ROBKOM
  skip
enddo

sele DOKP_R
_wzak:=0
dbeval({|| _wzak+=ILOSC*CENA_ZAK ,;
         DOKP_R->RODZAJ_DOK := _rodz_dok,;                         //08.01.03
         DOKP_R->DATA_DOK := date(),;
         DOKP_R->ROK_DOK:=left(dtos(date()),4),;
         DOKP_R->NR_MAG := _nr_mag,;
         DOKP_R->ZNAK:=1  })


if abs(_wzak)>=0.01.and.subs(_wersja,116,1)<>"F"                    //08.01.03

  sele ROBKOM
  go top

  loca for ILOSC>1

  if found()
    sele DOKP_R
    loca for INDEKS=ROBKOM->INDEKS 
    if ILOSC>1 
      repl ILOSC with ILOSC-1
     do case
        case _rozchody="1";    _k1:=DOKP_R->(s_i(INDEKS)+s_c(CENA_ZAK))
        case _rozchody="2";    _k1:=DOKP_R->(s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK))
      endc
  
      sele MAG
      set orde to 1
      seek _k1     // musi byc 
      repl STAN  with STAN-1

      sele DOKP_R
      _wzakpom:=CENA_ZAK
      DOKP_R->(dbappend())
      DOKP_R->INDEKS:=ROBKOM->INDEKS
      DOKP_R->CENA_ZAK:=_wzakpom-_wzak
      DOKP_R->DATA_DOS:=date()
      DOKP_R->ILOSC:=1
      DOKP_R->RODZAJ_DOK := _rodz_dok                                 //08.01.03
      DOKP_R->DATA_DOK := date()
      DOKP_R->ROK_DOK:=left(dtos(date()),4)
      DOKP_R->NR_MAG := _nr_mag
      DOKP_R->VAT := TOW->VAT
      DOKP_R->ZNAK:=1  
      do case
        case _rozchody="1";    _k1:=DOKP_R->(s_i(INDEKS)+s_c(CENA_ZAK))
        case _rozchody="2";    _k1:=DOKP_R->(s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK))
      endc
  
      sele MAG
      set orde to 1
      seek _k1
      if eof() 
        appe blan
        repl INDEKS with DOKP_R->INDEKS,;
             CENA_ZAK with DOKP_R->CENA_ZAK,;
             DATA_DOS with DOKP_R->DATA_DOS
      endi
      repl STAN  with STAN+DOKP_R->ILOSC,;
           DATA_AKT with date()
      skip 0
      dbcommit()

    endi 
  endi
  
  sele DOKP_R
  _wzak:=0
  dbeval({|| _wzak+=ILOSC*CENA_ZAK })

endi

close MAG

*----------- koniec aktualizacji magazynu


DOKN_R->(dbappend())
DOKN_R->RODZAJ_DOK := _rodz_dok                                      //08.01.03
DOKN_R->DATA_DOK := date()
DOKN_R->NR_MAG := _nr_mag
DOKN_R->WART_ZAK := _wzak
DOKN_R->OPERATOR:=_operator
DOKN_R->ROK_DOK:=left(dtos(date()),4)
DOKN_R->UWAGI:="AUTO - kompletacja"

*-----------  dokumenty

sele 0 
_zb:="DOK"+_nr_mag+"N"
_i1:="D"+_nr_mag+"N"+"_NR"
_i2:="D"+_nr_mag+"N"+"_RD"
_use(_zb,"F!","DOKN")
set inde to (_i1), (_i2)


set soft on
seek _rodz_dok+_nr_mag+DOKN_R->ROK_DOK+ "9999:"
set soft off
skip -1
if RODZAJ_DOK=_rodz_dok .and. NR_MAG=_nr_mag .and. ROK_DOK=DOKN_R->ROK_DOK
           repl DOKN_R->NR_DOK with trans0(val(NR_DOK)+1,5)
else;  repl DOKN_R->NR_DOK with "00001"
endif

_dokument:=DOKN_R->(RODZAJ_DOK+"-"+NR_DOK+"/"+NR_MAG+"/"+ROK_DOK)

sele DOKP_R
repl all NR_DOK with DOKN_R->NR_DOK


close DOKP_R
close DOKN_R

sele 0
_zb:="DOK"+_nr_mag+"P"
_i1:="D"+_nr_mag+"P"+"_NR"
_i2:="D"+_nr_mag+"P"+"_DI"
_use(_zb,"F!","DOKP")
set inde to (_i1), (_i2)
appe from (_sc+"D"+_rodz_dok+"_P_R")
dbcommit()


sele DOKN
appe from (_sc+"D"+_rodz_dok+"_N_R")
dbcommit()

tone(880,1)
QK("Wytworzono dokument kompletacji "+_dokument)

END SEQUENCE
clos data
*dele file (_sc+"ROBKOM.DBF")
RETURN NIL

*******************************************************************************
FUNCTION SKAU()                                                      //05.01.04
local _astru:={},_tin,_tio,_tiz,_rto,_wart:=0,_sel:=select(),;
      _rtow,_sa_opa:=.f.,_sa_wop:=.f.,_iz:=0                         //20.09.02
local _ile_wn:=0,_forilo:="@ZE 9,999,999"                                                     //07.12.03
  

if empty(subs(_wersja,112,1)); RETURN NIL; endi                      //03.09.02

if !_kaucje.or.subs(_wersja,111,1)<>"S".or.NAG->NR_MAG="000"; RETURN NIL; endi
_rtow:=TOW->(recn())                                                 //30.08.02

BEGIN SEQUENCE

CPClose(KAU)                                                         //27.08.02

sele 0
_astru:={}
aadd(_astru,{"INDEKS"     ,"C",LENIN, 0})      
aadd(_astru,{"TYP"        ,"C",1, 0})      
aadd(_astru,{"OPAKOWANIE" ,"N", 5, 1})      
aadd(_astru,{"CENA_SPR"   ,"N",12, 2})      
aadd(_astru,{"WYDANIE"    ,"N",12, 3})      
aadd(_astru,{"ZWROT"      ,"N",12, 3})      
aadd(_astru,{"NR_MAG"     ,"C", 3, 0})      
aadd(_astru,{"WINIEN"     ,"N",12, 3})      
dbcreate(_sc+"KAU",_astru)
_use(_sc+"KAU","E!")
index on TYP+s_i(INDEKS)+str(CENA_SPR,12,2) to (_sc+"KAU_I")

sele POZ
go top
do while .not.eof()                                                  //15.08.02
  _tin:=s_i(POZ->INDEKS)
  TOW->(dbseek(_tin))     
  if TOW->OPAK_ZWR="T"
    _sa_opa:=.t.
    exit
  endi
  skip
endd  

sele POZ
go top
do while .not.eof()
  _rto:=TOW->(recn())
  _tio:=s_i(TOW->INDEKS_O)
  _tiz:=s_i(TOW->INDEKS_Z)

  if !_tio==s_i(spac(LENIN))
    _sa_wop:=.t.
    if !(KAU->(dbseek("W"+_tio)))
      KAU-> (dbappend())
      repl KAU->INDEKS with TOW->INDEKS_O,KAU->TYP with "W"
      TOW->(dbseek(_tio))     
      do case 
        case subs(_wersja,14,1)="1"; repl KAU->CENA_SPR with ;
           if(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="2"; repl KAU->CENA_SPR with ;
           if(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="3"; repl KAU->CENA_SPR with ;
           if(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
      endc
      TOW->(dbgoto(_rto))
    endi
    repl KAU->WYDANIE with KAU->WYDANIE+POZ->ILOSC
    _wart:=_wart+KAU->CENA_SPR*POZ->ILOSC
  endi        

  if !_tiz==s_i(spac(LENIN)) .and. max(TOW->OPAKOWANIE,0) >0     
    _sa_wop:=.t.
    if !(KAU->(dbseek("W"+_tiz)))
      KAU-> (dbappend())
      repl KAU->INDEKS with TOW->INDEKS_Z,;
           KAU->OPAKOWANIE with max(TOW->OPAKOWANIE,0),;
           KAU->TYP with "W"
      TOW->(dbseek(_tiz))     
      do case 
        case subs(_wersja,14,1)="1"; repl KAU->CENA_SPR with ;
           if(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="2"; repl KAU->CENA_SPR with ;
           if(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="3"; repl KAU->CENA_SPR with ;
           if(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
      endc
      TOW->(dbgoto(_rto))
    endi
    _iz:=int(POZ->ILOSC/max(TOW->OPAKOWANIE,0))                      //20.09.02
    repl KAU->WYDANIE with KAU->WYDANIE+_iz
    _wart:=_wart+KAU->CENA_SPR*_iz
  endi        

  sele POZ
  skip
endd
                                                                     //27.08.02
sele POZ
go top
do while .not.eof()
  _tin:=s_i(POZ->INDEKS)

  TOW->(dbseek(_tin))     
  if TOW->OPAK_ZWR="T"
    if !(KAU->(dbseek("F"+_tin+str(POZ->CENA_SPR,12,2))))
      KAU-> (dbappend())
      repl KAU->INDEKS with POZ->INDEKS,;
           KAU->TYP with "F",;
           KAU->CENA_SPR with POZ->CENA_SPR
    endi
    repl KAU->WYDANIE with KAU->WYDANIE+POZ->ILOSC
    _wart:=_wart+KAU->CENA_SPR*POZ->ILOSC
  endi        
  TOW->(dbgoto(_rto))

  sele POZ
  skip
endd

sele 0
_ile_wn:=0                                                        //07.12.03
if ZOPA_N(NAG->NR_KON,"15",,).and.file(_sc+"SPR_O_R.DBF")        

  _use(_sc+"SPR_O_R","R!")
  go top
  do while !eof()
    if SPR_O_R->ILOSC=0; skip; loop; endi
    _ile_wn+=abs(SPR_O_R->ILOSC)

    _tin:=s_i(SPR_O_R->INDEKS)
    TOW->(dbseek(_tin))     
    if KAU->(!dbseek("W"+s_i(SPR_O_R->INDEKS)))
      KAU-> (dbappend())

      repl KAU->INDEKS with SPR_O_R->INDEKS,;
           KAU->TYP with "W"
    endi
    repl KAU->WINIEN with KAU->WINIEN+SPR_O_R->ILOSC
    skip
  endd
endi
CPClose(SPR_O_R)
* dele file (_sc+"SPR_O_R.DBF")


if !_sa_opa.and.!_sa_wop.and._ile_wn=0; BREAK; endi                  //07.12.03
if subs(_wersja,112,1)="1".and.!_sa_wop.and._ile_wn=0; BREAK; endi   //07.12.03
if subs(_wersja,112,1)="2".and.!_sa_opa.and._ile_wn=0; BREAK; endi   //07.12.03

sele KAU
appe blan; repl TYP with chr(255)                                    //03.05.06
appe blan; repl TYP with chr(255)

set rela to s_i(INDEKS) into TOW
if recc()>0
  @ prow()+1,0 say "ROZLICZENIE OPAKOWA do "+NAG->RODZAJ_DOK+;
                " "+NAG->NR_DOK+"/"+NAG->SERIA_FAK+"/"+RE(NAG->ROK_DOK)+ ;
                " z " +dtoc(NAG->DATA_DOK)

  _l:=max(6,len(s_i(spac(LENIN))))+_len_naz+4+3+len(transform(0,_forfak_cen))+;
      4*len(transform(0,_forilo))+8

  @ prow()+2,0 say padr("Indeks",max(6,len(s_i(spac(LENIN)))))+" "+;
                   padr("Nazwa",_len_naz)+" "+;
                   padr("Jm.",4)+" "+;
                   "Typ"+" "+;
                   padr("  Cena  ",len(transform(0,_forfak_cen)))+" "+;
                   padr("WYDANO  ",len(transform(0,_forilo)))+" "+;
                   padr("WINIEN  ",len(transform(0,_forilo)))+" "+;
                   padr("PRZYJTO",len(transform(0,_forilo)))+" "+;
                   padr("SALDO   " ,len(transform(0,_forilo)))

  @ prow()+1,0 say repl("-",_l)
  go top
  do while !eof()
    @ prow()+1,0 say padr(s_i(INDEKS),max(6,len(s_i(spac(LENIN)))))+" "+;
                     padr(TOW->NAZWA_TOW,_len_naz)+" "+;
                     TOW->JM+" "+;
                     " "+TYP+"  "+;
                     transform(CENA_SPR,_forfak_cen)+" "+;
                     transform(WYDANIE,_forfak_ilo)+" "+;
                     transform(WINIEN+WYDANIE, _forfak_ilo)+;
                     "   "+padr("........",len(transform(0,_forilo)))+" "+;
                     padr("........",len(transform(0,_forilo)))



    skip
  endd
  @ prow()+1,0 say repl("-",_l)
  @ prow()+1,0 say "Warto wydanych opakowa : "+transform(_wart,_format_war)
  @ prow()+2,0 say "Potwierdzenie wydania/zwrotu :  ..................   .................."
  @ prow()+2,0 say "                        Data :  .................."
endi

CPclose(KAU)
dele file (_sc+"KAU.DBF")
dele file (_sc+"KAU_I.NTX")

END SEQUENCE
TOW->(dbgoto(_rtow))

sele (_sel)
RETURN NIL

*******************************************************************************
FUNCTION ZMIANA_DOK()
local _tex:='۲  ZMIANA NUMERW I DAT DOKUMENTW  '
priv _magazyn:="   ",_nr_mag:="   ",_rok_dok:=subs(dtos(date()),1,4),;
     _rodz_dok:="  ",_data_dok:=ctod(""), _zmiana:=0,;
     _nr_od:="     ",_nr_do:="     "

cls
@ 0,0 say _tex

BEGIN SEQUENCE



@ 12,0 say "UWAGA :"
@ 13,0 say "Jest to funkcja serwisowa, dostpna tylko dla informatykw."
@ 14,0 say "Mona j zastosowa tylko, gdy program nie jest uruchomiony"
@ 15,0 say "na adnym stanowisku. Przed uruchomieniem opcji naley wykona"
@ 16,0 say "archiwizacj danych a po wykonaniu zmian naley przeprowadzi"
@ 17,0 say "sortowanie zbiorw i testy danych."

@ 18,0 say "W opcji zmieniane s dane w plikach zwizanych z podanym magazynem."
@ 19,0 say "Dla dokumentw przesuni midzymagazynowych zmiana musi by wykonana"
@ 20,0 say "zarwno w plikach magazynu rdowego jak i docelowego."

@ 22,0 say "Przy zamianie numerw dokumentw naley wczeniej sprawdzi, czy nowe"
@ 23,0 say "numery s wolne !"

do while .t.
  @ 1,0 say "Zmiany dotycz dokumentw magazynu :" get _magazyn pict "@K 999";
                                  vali SZ().and.file("MAG"+_magazyn+".DBF")
  @ 2,0 say "Rodzaj dokumentw :" get _rodz_dok pict "@K! AA";
                                  vali !" "$_rodz_dok
  @ 3,0 say "Magazyn rdowy : " get _nr_mag pict "999";
                                  vali SZ().and.file("MAG"+_nr_mag+".DBF")
  @ 4,0 say "Dokumenty z roku : " get _rok_dok pict "@K 9999";
                                  vali SZ().and.!" "$_rok_dok
  @ 5,0 say "Numery dokumentw :" get _nr_od pict "@K 99999" vali SZ()
  @ 5,col()+1 say "-" get _nr_do pict "@K 99999" vali SZ()

  @ 7,0 say "Zamie dat dokumentw na : " get _data_dok 
  @ 8,0 say "Zmie numer o liczb (+/-) :" get _zmiana pict "@ZK 999999"
  set curs on; read; set curs off
  if lastkey()=K_ESC; BREAK; endi

  _wybor:=HorizMenu(10,0,"Dane prawidowe :",{"TAK","NIE","REZYGNACJA"},3)
  @ 10,0

  if _wybor=1; exit
  elseif _wybor=3; BREAK
  endi
endd

QPC(1)

sele 0
if !_use("SPR_N","E"); BREAK; endi 
index on NR_MAG+ROK_WZ+NR_WZ to (_sc+"WZ")

sele 0
if !_use("DOK"+_magazyn+"N","E","DOKN"); BREAK; endi 
set index to ("D"+_magazyn+"N"+"_NR"),("D"+_magazyn+"N"+"_RD")
set order to 0
set filt to RODZAJ_DOK==_rodz_dok.and.ROK_DOK==_rok_dok.and.;
            NR_DOK>=_nr_od.and.NR_DOK<=_nr_do.and.NR_MAG==_nr_mag
go top

sele 0
if !_use("DOK"+_magazyn+"P","E","DOKP"); BREAK; endi 
set index to ("D"+_magazyn+"P"+"_NR"),("D"+_magazyn+"P"+"_DI")
set order to 0
set filt to RODZAJ_DOK=_rodz_dok.and.ROK_DOK=_rok_dok.and.;
            NR_DOK>=_nr_od.and.NR_DOK<=_nr_do.and.NR_MAG==_nr_mag
go top

sele DOKN
_l:=0
dbeval({|| _l+=1,;
           if(_rodz_dok<>"WZ",NIL,;
               (SPR_N->(dbseek(DOKN->(NR_MAG+ROK_DOK+NR_DOK))),;
                if(empty(_data_dok),NIL,SPR_N->DATA_WZ:=_data_dok),;
                SPR_N->NR_WZ:=trans0(val(DOKN->NR_DOK)+_zmiana,5))),;
           if(empty(_data_dok),NIL,DOKN->DATA_DOK:=_data_dok),;
           DOKN->NR_DOK:=trans0(val(DOKN->NR_DOK)+_zmiana,5)})

sele DOKP
dbeval({|| if(empty(_data_dok),NIL,DOKP->DATA_DOK:=_data_dok),;
           DOKP->NR_DOK:=trans0(val(NR_DOK)+_zmiana,5)})

QPC(0)
close data
QKE("Zmieniono "+ltrim(str(_l))+" dokumentw.")
cls
QKE("Po wszystkich zmianach wykonaj sortowanie kartotek i testy danych !")

END SEQUENCE
close data
RETURN NIL

*******************************************************************************
FUNCTION NAG_ZAPI()
local _wp:=if(subs(_wersja,1,1)<>"R",0,20), _kolf,_nrds:="",_spe

_spe:=SZERx2+;
      SZER("SPECYFIKACJA WEWNTRZNA"+if(_rodz_dok="P",""," do "+_rodz_dok)+;
                                   " dla firmy "+NAG->NR_KON)
_kolf:=rmarg-25
      
devpos(prow(),_kolf); devout("Data : "+dtoc(NAG->DATA_DOK))
devpos(prow()+2,int(rmarg/2-26))
devout(_spe+SZERx1)

devpos(prow()+1,0);   devout("Nabywca : "+NAG->NR_KON+" "+rtrim(NAG->NAZWA_KON))
devpos(prow()+1,10);  devout(NAG->KOD+" "+alltrim(NAG->MIASTO)+", "+NAG->ADRES)

devpos(prow()+1,0);   devout("Warto brutto : ";
             +transform(NAG->WART_ZAP,_format_war)+" z")

devpos(prow()+1,0);   devout("Uwagi :   "+;
  if(NAG->UWAGI="!",subs(NAG->UWAGI,at(" ",NAG->UWAGI)+1),NAG->UWAGI))
RETURN NIL

******************************************************************************
FUNCTION NAG_ZAPI_D()
local _wp:=if(subs(_wersja,1,1)<>"R",0,20), _kolf,_nrds:="",_spe

_spe:=SZERx2+;
      SZER("SPECYFIKACJA WEWNTRZNA"+if(_rodz_dok="P",""," do "+_rodz_dok)+;
       if(_typ_dok="-".and.!empty(NAG->NR_KON)," dla firmy "+NAG->NR_KON,""))
_kolf:=rmarg-25
      
devpos(prow(),_kolf); devout("Data : "+dtoc(NAG->DATA_DOK))
devpos(prow()+2,int(rmarg/2-26))
devout(_spe+SZERx1)
if !empty(NAG->NR_KON)
  devpos(prow()+1,0);   devout("Nabywca : "+NAG->NR_KON+" "+rtrim(KON->NAZWA_KON))
  devpos(prow()+1,10);  devout(KON->KOD+" "+alltrim(KON->MIASTO)+", "+;
                               KON->ADRES)
endi
if _udocezak
  devpos(prow()+1,0);   devout("Warto wg cen zakupu : ";
               +transform(NAG->WART_ZAK,_format_war)+" z")
endi

devpos(prow()+1,0);   devout("Uwagi :   "+;
  if(NAG->UWAGI="!",subs(NAG->UWAGI,at(" ",NAG->UWAGI)+1),NAG->UWAGI))
RETURN NIL

*******************************************************************************
FUNCTION Z_WZ()  
loca _al:=alias(),_kon_wz:=SPR_N_R->NR_KON

if _nr_mag="000".or.!_z_wz; RETURN .T.; endi                         //07.06.03

sele DOKN
set order to 1

seek "WZ"+SPR_N_R->NR_MAG+SPR_N_R->ROK_WZ+SPR_N_R->NR_WZ

if found().and.empty(NR_FAK)
  _kon_wz:=NR_KON

* repl SPR_N_R->NR_KON with NR_KON   // teraz w Z_WZ0()

 sele (_al)
 RETU iif(SPR_N_R->NR_KON<>_kon_wz,;
        QTN("Zgoda na innego patnika ni odbiorca ?"),.T.)
endi

sele (_al)
RETU .T.

*******************************************************************************
FUNCTION Z_WZ0()
loca _al:=alias(),_kon_nr:=SPR_N_R->NR_KON

if _nr_mag="000".or.!_z_wz; RETURN .T.; endi                         //07.06.03

sele DOKN
set order to 1

seek "WZ"+SPR_N_R->NR_MAG+SPR_N_R->ROK_WZ+SPR_N_R->NR_WZ

if found().and.empty(NR_FAK)
 repl SPR_N_R->NR_KON with NR_KON,;
      SPR_N_R->UWAGI with alltrim(alltrim(SPR_N_R->UWAGI)+" "+alltrim(UWAGI))
                                                                    //07.02.04
endi

sele (_al)
RETU .T.

*******************************************************************************
FUNCTION ILE_WOPAK()
local _rv:=readvar(),_al:=alias()

if _rv="ILOSC ".or._rv="STAN_K" .or. _rv="ILOSC_ZAM"
  tone(880,0.5)
  if max(TOW->OPAKOWANIE,0) > 0
    if _rv="ILOSC "
      repl ILOSC with ILOSC*max(TOW->OPAKOWANIE,0)
    elseif _rv="STAN_K"
      repl STAN_K with STAN_K*max(TOW->OPAKOWANIE,0)
    else
      repl ILOSC_ZAM with ILOSC_ZAM*max(TOW->OPAKOWANIE,0)
    endif
    keyboard chr(K_UP)
  endif 
endi
RETU  NIL

*******************************************************************************
FUNCTION REP()
loca _cez,_inp,_rep,_pp,_dat

if _powtorka="T" .or. (alias()="SPR_P_R" .and. subs(_rodz_dok,2,1)="K")
// w konfiguracji dopuszczono powtorki lub edycja FK lub RK
 RETURN .T.
endi

go recn()
_cez:=CENA_ZAK
_dat:=DATA_DOS
_inp:=s_i(INDEKS)
_rep:=recn()

count to _pp for s_i(INDEKS)==_inp.and.CENA_ZAK=_cez ;
                 .and.if(_rozchody="1",.t.,DATA_DOS=_dat).and.recn()<>_rep   
// jesli rozchody="1" to DATA_DOS nie moze byc sprawdzana

if _pp>0
 set curs off
 tone(880,0.5)
 QKE("Powtrzenie symbolu "+rtrim(_inp)+" !")
 set curs on
 go _rep
 if alias()="SPR_P_R"
   repl SPR_P_R->ILOSC     with 0,;
        SPR_P_R->CENA_SPR  with 0,;
        SPR_P_R->DATA_DOS  with ctod(""),;
        SPR_P_R->CENA_ZAK  with 0,;
        SPR_P_R->NAZWA_TOW with "",;
        SPR_P_R->OPIS_TOW  with "",;
        SPR_P_R->JM        with "",;
        SPR_P_R->SWW       with "",;
        SPR_P_R->GRUPA_TOW with "",;
        SPR_P_R->OPAKOWANIE with 0,;
        SPR_P_R->VAT       with "",;
        SPR_P_R->BONIFIKATA with 0,;
        SPR_P_R->CENA_SPR   with 0

 endi
 RETU .F.
endi
go _rep
RETU .T.

*******************************************************************************
FUNCTION DODAJ()
loca _ile,_al,_ce,_da,_ces,_in,_ro,_rre,_upu,_roz,_sta,_cez,_k1,_naz,;
     _tabela:=.f.,_uz:=.f.,_ordmag,_brak:=.f.,_ila:=0

_ile_dod:=0         //16.07.02
_sta:=MAG->(STAN-S_BLO())                                            //10.01.04

if ILOSC<=_sta
 RETU .T.
endi

if subs(_wersja,32,1)=="K".and.ILOSC>1000000
  tone(220,2)
  QKE("Uwaga : Ilo wiksza od 1000000 !")
endi


_roz:=ILOSC
_in:=s_i(INDEKS)

_rre=recn()
do case
  case _rozchody="1"
    _k1:=s_i(INDEKS)+s_c(CENA_ZAK)
  case _rozchody="2"
    _k1:=s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK)
endc
copy next 1 to (_sc+"DODAJ_R")

sele MAG
_ordmag:=indexord()
set order to 1

seek _k1
sum STAN-S_BLO() to _ile whil s_i(INDEKS)==_in

set order to _ordmag

sele SPR_P_R

_uz:=.t.                                                             //23.03.03
/*                                                                   //23.03.03
if _ile>_sta.and._ile>0                                            
  loca for s_i(INDEKS)=_in.and.recn()<>_rre
  _uz:=.not.found()
endi
*/

go _rre

if _roz>_ile; _brak:=.t.; endi

if _ile>_sta.and._uz.and._roz>0                                   
  tone(880,0.5)
  if subs(_wersja,28,1)=="N".or.subs(_wersja,67,1)=="S".or.;
     QTN("Uzupenienie rozchodu z nastpnych pozycji ?")

    if _ile<_roz.and.!(subs(_wersja,67,1)=="S".or._ujemne="T")       //23.03.03
      _roz:=_ile
    endi

    _tabela:=.t.

    sele MAG
    _ordmag:=indexord()
    set order to 1
    seek _k1 
    _ila=_roz-_sta
    skip
    do while _ila>0.and.s_i(INDEKS)=_in

      _rem=recn()
      _ce=CENA_ZAK
      _da=DATA_DOS
     
      if STAN-S_BLO()=0.or.(subs(_wersja,122,1)="N".and.STAN-S_BLO()<0) 
        skip; loop
      endi  

      _ro=STAN-S_BLO()
      _ro=iif(_ila>_ro,_ro,_ila)
  
      sele SPR_P_R
      appe from (_sc+"DODAJ_R")
      _ile_dod++                                                     //16.07.02
      repl ILOSC with _ro, CENA_ZAK with _ce,DATA_DOS with _da

      if subs(_wersja,50,1)=="O"
        DAJ_OPA2()
      endi
      _ila=_ila-_ro
  
      sele MAG
      go _rem
      skip
    endd
 
    sele MAG
    seek _k1 
    set order to _ordmag  

    sele SPR_P_R

    go _rre
    repl ILOSC with _sta
    if ILOSC=0; dbdelete(); endi
 
/*
    repl ILOSC with _sta+;
                 if(subs(_wersja,67,1)=="S".or._ujemne="T",_ila,0)   
*/
    if _ila<>0                                                       //23.03.03
      appe from (_sc+"DODAJ_R")
      _ile_dod++                                        
      repl ILOSC with _ila, CENA_ZAK with _ce,DATA_DOS with _da
      if subs(_wersja,50,1)=="O"
        DAJ_OPA2()
      endi
    endi

    if !(subs(_wersja,67,1)=="S".or._ujemne="T").and._brak
      tone(220,3)
      QKE("Uwaga: Sumaryczna ilo sprzedawanego towaru "+_in,;
                   "zostaa zmniejszona !")
    endi
  endi

  * commit
  cpswiezatabela()
  cpstabilizuj()
endif

sele SPR_P_R
go _rre                                                              //10.01.04
dele file (_sc+"DODAJ_R.DBF")
go recn()

RETURN .T.
  
*******************************************************************************
FUNCTION ILE24()
RETURN if(recn()<lastrec()-_ile_dod,chr(0),chr(K_CTRL_PGDN)+chr(24))
*RETURN repl(chr(24),_ile_dod+2)

*******************************************************************************
FUNCTION REAL_ZAM_O(_fis,_z_wz,_rea_zam,_rea_zam2,_zam_kon,_pytaj_zam,_fil,;
                    _uje,_azz,_odb,_mem)                             //08.12.06
//_odb - numer odbiorcy 
//_mem - .t. jeeli _odb pobrane z PROMEM a nie PROZAM

local _sym,_uwa,_spo,_dni,_ord,_konto
local _orm:=MAG->(indexord())                                        //08.12.06

DEFAULT _uje TO " ",;
        _odb to spac(5),;                                            //08.12.06
        _mem TO .f.

if !empty(_fil)
  QKE("Realizacja zamwienia : "+subs(_fil,9)+" z dnia "+;
           dtoc(stod(subs(_fil,1,8))))
  if subs(_wersja,157,1)=="N"
    _rea_zam:=.t.
//    _rea_zam2=.t.

    RETU NIL

  else
    if !QTN("Uzupeni pozycje faktury o towary, ktre pojawiy si w magazynie ?")
      _rea_zam:=.t.
//      _rea_zam2=.t.

      RETURN NIL
    endi
  endi
endi

set index to PROZAM,PROZAM_I,PROZAM_S
seek SPR_N_R->NR_KON
loca for ILOSC_ZAM>ILOSC_ZRE;
     while SPR_N_R->NR_KON==NR_KON

if !_rea_zam2.and.found().and.((tone(220,2),.t.)).and.;
       (!empty(_fil).or.QTN("Realizacja zamwie od odbiorcy ?"))

      _rea_zam:=.t.
      _rea_zam2=.t.
      _zam_kon:=SPR_N_R->NR_KON

      if SPR_N_R->RABAT<>0.and.;
            QTN("Czy ceny z zamwienia zmniejszy o rabat nagwkowy ?")
      else
         tone(440,1)
         @ 6,61 say "  0.0"
         repl SPR_N_R->RABAT with 0 
      endi

      if !_z_wz

        ***********************


        sele 0
        if !_use("PROMEM","R!");BREAK;endi
        set index to PROMEM  //  inde on NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM to PROMEM
        seek PROZAM->(NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM)
        if found()
          _txt:=PROMEM->OPIS
          _lnr:="";_lnazwa:="";_lnazwa2:="";_lkod:="";_lmiasto:="";_ladres:="" 
          for i:=1 to mlcount(_txt,76)
            _pom:=memoline(_txt,76,i)
            if left(_pom,2)=="|F"; _lnr:=rtrim(_pom);endi
            if left(_pom,2)=="|N"; _lnazwa:=rtrim(_pom);endi
            if left(_pom,2)=="|2"; _lnazwa2:=rtrim(_pom);endi
            if left(_pom,2)=="|K"; _lkod:=rtrim(_pom);endi
            if left(_pom,2)=="|M"; _lmiasto:=rtrim(_pom);endi
            if left(_pom,2)=="|A"; _ladres:=rtrim(_pom);endi
          next

          if len(_lmiasto+_ladres)>0    
            sele FAK_TXT   
            appe blank 
            repl LINIA  with _lnr
            appe blank 
            repl LINIA  with _lnazwa
            appe blank 
            repl LINIA  with _lnazwa2
            appe blank 
            repl LINIA  with _lkod
            appe blank 
            repl LINIA  with _lmiasto
            appe blank 
            repl LINIA  with _ladres
          endi

          if !empty(_lnr)                                            //08.12.06
            _odb:=_lnr     
            _mem:=.t.
          endi

        endi
        close PROMEM
        ***********************

         CREA_POZ_ZAM()

         sele select("KON_OD")                                       //08.12.06
         if empty(_gdzie_fir)
           if !_use("KON","R","KON_OD"); BREAK; endi
           set index to KON_NR
         else
           if !_use(_gdzie_fir+"FIRMY","S","KON_OD"); BREAK; endi
           set index to (_gdzie_fir+"FIRMY_NR")
         endi

         sele 0
         _use(_sc+"POZ_ZAM","E!")
         index on dtos(DATA_ZAM)+SYMBOL_ZAM+NR_ODB to (_sc+"POZ_ZAM") unique
 
         sele PROZAM
         seek SPR_N_R->NR_KON

         dbeval({||  POZ_ZAM->( dbseek(PROZAM->(dtos(DATA_ZAM)+SYMBOL_ZAM+NR_ODB))),;
                  if(POZ_ZAM->(found()),NIL,;
                     (POZ_ZAM->(dbappend()),;
                      POZ_ZAM->DATA_ZAM:=PROZAM->DATA_ZAM,;
                      POZ_ZAM->NR_KON:=PROZAM->NR_KON,;
                      POZ_ZAM->UWAGI:=PROZAM->UWAGI,;
                      POZ_ZAM->SYMBOL_ZAM:=PROZAM->SYMBOL_ZAM,;
                      POZ_ZAM->NR_ODB:=PROZAM->NR_ODB,;              //08.12.06
                      KON_OD->(dbseek(PROZAM->NR_ODB)),;             //08.12.06
                      POZ_ZAM->NAZWA_ODB:=KON_OD->NAZWA_KON,;        //08.12.06
                      POZ_ZAM->TERMIN_ZAM:=PROZAM->TERMIN_ZAM))},;
           {|| if(!empty(_fil),PROZAM->(dtos(DATA_ZAM)+SYMBOL_ZAM)==_fil,;
                  ascan(_azz,PROZAM->(dtos(DATA_ZAM)+SYMBOL_ZAM))=0).and.;
                  ILOSC_ZAM>ILOSC_ZRE},{|| SPR_N_R->NR_KON==NR_KON})

         CPClose(KON_OD)
 
         sele POZ_ZAM
*        index on dtos(DATA_ZAM)+SYMBOL_ZAM+NR_ODB to (_sc+"POZTOT") uniq
         go top
         if !empty(DATA_ZAM)

           if empty(_fil)
             @ if(_fis,2,7)+1,0 say "Wybierz jedno zamwienie klawiszem Ins"
             @ if(_fis,2,7)+1,54 say "Enter - pozycje zamwienia"
             go top
             CPEDIT POZ: if(_fis,2,7)+2;
                  ,,22-if(Eval(memvarblock("_ceny_"+_nr_cen_spr))="B",1,0),  ;
                    DEF: "WYBZAM"       ;
                    POZWER: "V1"        ;
                    KOLOR: _slow_blo    ;
                    PION: ,,,          ;
                    AKCJA: POZ_ZAM()    
           else
             _zaznaczone:={1} 
           endif
 
           @ if(_fis,2,7)+1,0

           if len(_zaznaczone)=0 
             QKE("Nie wybrano zamwienia !")
  
             sele SPR_P_R
             _fil:=""
             if SPR_N_R->(fieldpos(SYMBOL_ZAM))>0
               SPR_N_R->SYMBOL_ZAM:=""
               SPR_N_R->DATA_ZAM:=ctod("")
             endi
             SPR_N_R->UWAGI:=""
// wyzerowa na ekranie uwagi
             _rea_zam:=.f.
             _rea_zam2:=.f.
             CPClose(POZ_ZAM)
             CPClose(PROZAM)
             RETURN NIL
           else
             dbgoto(_zaznaczone[1])
             _fil:=dtos(DATA_ZAM)+SYMBOL_ZAM 

             odblokuj(DR(DATA_ZAM)+subs(SYMBOL_ZAM,1,5),;
                      NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM)
           endi
         else

            sele SPR_P_R
             _fil:=""
             _rea_zam:=.f.
             _rea_zam2:=.f.
             if SPR_N_R->(fieldpos(SYMBOL_ZAM))>0
               SPR_N_R->SYMBOL_ZAM:=""
               SPR_N_R->DATA_ZAM:=ctod("")
             endi
             SPR_N_R->UWAGI:=""
// wyzerowa na ekranie uwagi
             CPClose(POZ_ZAM)
             CPClose(PROZAM)
             RETURN NIL
         endi
        
         sele POZ_ZAM
         set index to
         zap
         index on INDEKS to (_sc+"POZ_ZAM")

         sele PROZAM
         seek SPR_N_R->NR_KON

         MAG->(dbsetorder(1))                                        //08.12.06

         dbeval({|| POZ_ZAM->(dbseek(PROZAM->INDEKS)),;
                 if(POZ_ZAM->(found()),NIL,;
                     (POZ_ZAM->(dbappend()),;
                      POZ_ZAM->DATA_ZAM1:=DATA_ZAM,;
                      POZ_ZAM->DATA_ZAM2:=DATA_ZAM,;
                      POZ_ZAM->INDEKS:=PROZAM->INDEKS,;
                      MAG->(dbseek(s_i(PROZAM->INDEKS))),;
                      MAG->(dbeval({|| POZ_ZAM->ILOSC_MAG+=MAG->STAN},,;
                                   {|| MAG->INDEKS==PROZAM->INDEKS}) ))),;
                 POZ_ZAM->ILOSC_ZRE+=PROZAM->ILOSC_ZRE,; 
                 POZ_ZAM->ILOSC_ZAM+=PROZAM->ILOSC_ZAM,;
                 POZ_ZAM->CENA:=PROZAM->CENA,;
                 POZ_ZAM->RABAT:=PROZAM->RABAT,;
                 POZ_ZAM->SPOSOB_PLA:=PROZAM->SPOSOB_PLA,;
                 POZ_ZAM->DNI:=PROZAM->DNI,;
                 POZ_ZAM->SYMBOL_ZAM:=PROZAM->SYMBOL_ZAM,;
                 POZ_ZAM->KONTO:=PROZAM->KONTO,;
                 POZ_ZAM->UWAGI:=PROZAM->UWAGI,;
                 POZ_ZAM->DATA_ZAM2:=max(PROZAM->DATA_ZAM,POZ_ZAM->DATA_ZAM2),;
                 POZ_ZAM->NAZWA_TOW:=PROZAM->NAZWA_TOW,;
                 POZ_ZAM->NR_ODB:=PROZAM->NR_ODB,;                   //08.12.06
                 if(_uje<>"T",POZ_ZAM->ILOSC:=;
                     min(POZ_ZAM->(ILOSC_ZAM-ILOSC_ZRE),POZ_ZAM->ILOSC_MAG),;
                          POZ_ZAM->ILOSC:=POZ_ZAM->(ILOSC_ZAM-ILOSC_ZRE));
             },;
          {|| dtos(DATA_ZAM)+SYMBOL_ZAM==_fil.and.ILOSC_ZAM>ILOSC_ZRE},;
          {|| SPR_N_R->NR_KON==NR_KON})

         MAG->(dbsetorder(_orm))                                     //08.12.06

         sele POZ_ZAM
         set rela to s_i(INDEKS) into TOW
         go top
         _konto:=KONTO
         _sym:=SYMBOL_ZAM
         _uwa:=UWAGI
         _spo:=SPOSOB_PLA
         _dni:=DNI

         if !_mem                                                    //08.12.06
           _odb:=NR_ODB
         endi

         _pytaj_zam:=.t.
         do while !eof() .and. _pytaj_zam
            if alltrim(TOW->NAZWA_TOW)<>alltrim(NAZWA_TOW) .and. _pytaj_zam
               _pytaj_zam:=QTN_2W("Uwaga ! Zmieniona nazwa indeksu "+s_i(INDEKS)+;
                   " w sowniku towarw.","Kontynuowa sprawdzanie nazw ?")
            endi
            skip 1
         endd
         set rela to 
         go top
 
         @ 22-if(Eval(memvarblock("_ceny_"+_nr_cen_spr))="B",1,0),0;
           say "R - raport o brakujcych pozycjach zamwienia."
         @ 22-if(Eval(memvarblock("_ceny_"+_nr_cen_spr))="B",1,0),col()+6;
           say "Ins - pozycje do realizacji."
//
         _zaznaczone:={}
         CPEDIT POZ: if(_fis,2,7);
               ,,21-if(Eval(memvarblock("_ceny_"+_nr_cen_spr))="B",1,0),  ;
                DEF: "PROODB"       ;
                POZWER: "V3"        ;
                KOLOR: _slow_blo    ;
                PION: ,,,         ;
                INDEXY: {}        ;
                AKCJA: RAPORT_BRAK(_fis);
                EDYCJA: CPNazwa()=="ILOSC"

         @ 22-if(Eval(memvarblock("_ceny_"+_nr_cen_spr))="B",1,0),0

         sele SPR_P_R
         go top
         do while !eof()
           POZ_ZAM->(dbseek(SPR_P_R->INDEKS))
           POZ_ZAM->ILOSC_WZA+=SPR_P_R->ILOSC
           skip
         endd
         go top
         do while !eof()
           if POZ_ZAM->(dbseek(SPR_P_R->INDEKS)).and.;
                 POZ_ZAM->ILOSC_WZA<=POZ_ZAM->ILOSC_ZAM
             dbdelete() 
           endi
           skip  
         endd
                  
         sele POZ_ZAM 
         loca for ILOSC>0
         if found()
           set filt to ILOSC>0.and.ILOSC_WZA<=ILOSC_ZAM
           set index to                                              //16.06.03
           go top
           do while !eof()
             if len(_zaznaczone)>0 .and. ascan(_zaznaczone,recn())=0
               skip
               loop
             endi
             sele SPR_P_R

             POBR_ZAM(POZ_ZAM->INDEKS,POZ_ZAM->ILOSC,;
                      POZ_ZAM->CENA,POZ_ZAM->RABAT,_uje)

             sele POZ_ZAM
             skip
           endd
         endi

          
         sele SPR_N_R

         AKTU_NAG(_sym,_uwa,_spo,_dni,_konto)

         clos POZ_ZAM
         dele file (_sc+"POZ_ZAM.DBF")
         dele file (_sc+"POZ_ZAM.NTX")
      
         sele SPR_P_R
         loca for ILOSC=0
         if found()
           QKE("Ilo do realizacji ograniczono ze wzgldu na blokady stanw !")  
           dele all for ILOSC=0
           pack
         endi
         *---------  sprawdzenie stanow minimalnych

         if (subs(_wersja,97,1)=="M".and.;
             QTN("Sygnalizowa naruszenie stanw minimalnych ?"))

           QPC(1)
     
           sele SPR_P_R
           _ord:=indexord()
           inde on INDEKS to (_sc+"SPR_MI")
           total on INDEKS fields ILOSC to (_sc+"SPR_MIT")

           sele 0
           _use(_sc+"SPR_MIT","E!")
           dbeval({|| MINA()})
           close SPR_MIT
           dele file (_sc+"SPR_MIT.DBF")
           
           sele SPR_P_R
           set index to (_sc+"POZORY")
           set order to _ord
           dele file (_sc+"SPR_MI.NTX")

           sele SPR_P_R
           QPC(0) 
     
         endif
         *---------
      endi
else
      if !_rea_zam2
         _rea_zam:=.f.
      endi
endi
CPClose(PROZAM)
RETURN NIL

*******************************************************************************
FUNCTION SKAU_D()                                                    //20.09.02
local _astru:={},_tin,_tio,_tiz,_rto,_wart:=0,_sel:=select(),;
      _rtow,_sa_opa:=.f.,_sa_wop:=.f.,_iz:=0

if subs(_wersja,114,1)<>"1"; RETURN NIL; endi                    
if !_kaucje.or.subs(_wersja,111,1)<>"S".or.select("TOW")=0; RETURN NIL; endi
_rtow:=TOW->(recn())                                     

BEGIN SEQUENCE

CPClose(KAU)                                             

sele 0
_astru:={}
aadd(_astru,{"INDEKS"     ,"C",LENIN, 0})      
aadd(_astru,{"TYP"        ,"C",1, 0})      
aadd(_astru,{"OPAKOWANIE" ,"N", 5, 1})      
aadd(_astru,{"CENA_SPR"   ,"N",12, 2})      
aadd(_astru,{"WYDANIE"    ,"N",12, 3})      
aadd(_astru,{"ZWROT"      ,"N",12, 3})      
aadd(_astru,{"NR_MAG"     ,"C", 3, 0})      
dbcreate(_sc+"KAU",_astru)
_use(_sc+"KAU","E!")
index on TYP+s_i(INDEKS)+str(CENA_SPR,12,2) to (_sc+"KAU_I")

sele DOKP_R
go top
do while .not.eof()                                                
  _tin:=s_i(DOKP_R->INDEKS)
  TOW->(dbseek(_tin))     
  if TOW->OPAK_ZWR="T"
    _sa_opa:=.t.
    exit
  endi
  skip
endd  

sele DOKP_R
go top
do while .not.eof()
  _rto:=TOW->(recn())
  _tio:=s_i(TOW->INDEKS_O)
  _tiz:=s_i(TOW->INDEKS_Z)

  if !_tio==s_i(spac(LENIN))
    _sa_wop:=.t.
    if !(KAU->(dbseek("W"+_tio)))
      KAU-> (dbappend())
      repl KAU->INDEKS with TOW->INDEKS_O,KAU->TYP with "W"
      TOW->(dbseek(_tio))     
      do case 
        case subs(_wersja,14,1)="1"; repl KAU->CENA_SPR with ;
           if(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="2"; repl KAU->CENA_SPR with ;
           if(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="3"; repl KAU->CENA_SPR with ;
           if(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
      endc
      TOW->(dbgoto(_rto))
    endi
    repl KAU->WYDANIE with KAU->WYDANIE+DOKP_R->ILOSC
    _wart:=_wart+KAU->CENA_SPR*DOKP_R->ILOSC
  endi        

  if !_tiz==s_i(spac(LENIN)) .and. max(TOW->OPAKOWANIE,0) >0     
    _sa_wop:=.t.
    if !(KAU->(dbseek("W"+_tiz)))
      KAU-> (dbappend())
      repl KAU->INDEKS with TOW->INDEKS_Z,;
           KAU->OPAKOWANIE with max(TOW->OPAKOWANIE,0),;
           KAU->TYP with "W"
      TOW->(dbseek(_tiz))     
      do case 
        case subs(_wersja,14,1)="1"; repl KAU->CENA_SPR with ;
           if(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="2"; repl KAU->CENA_SPR with ;
           if(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="3"; repl KAU->CENA_SPR with ;
           if(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
      endc
      TOW->(dbgoto(_rto))
    endi
    _iz:=int(DOKP_R->ILOSC/max(TOW->OPAKOWANIE,0))                      //20.09.02
    repl KAU->WYDANIE with KAU->WYDANIE+_iz
    _wart:=_wart+KAU->CENA_SPR*_iz
  endi        

  sele DOKP_R
  skip
endd
    
sele DOKP_R
go top
do while .not.eof()
  _tin:=s_i(DOKP_R->INDEKS)

  TOW->(dbseek(_tin))     
  if TOW->OPAK_ZWR="T"
    if !(KAU->(dbseek("D"+_tin+str(DOKP_R->CENA_SPR,12,2))))
      KAU-> (dbappend())
      repl KAU->INDEKS with DOKP_R->INDEKS,;
           KAU->TYP with "D"
      if DOKP_R->(fieldpos("CENA_SPR"))>0.and.DOKP_R->CENA_SPR>0
        repl KAU->CENA_SPR with DOKP_R->CENA_SPR
      else
        do case 
          case subs(_wersja,14,1)="1"; repl KAU->CENA_SPR with ;
             if(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
          case subs(_wersja,14,1)="2"; repl KAU->CENA_SPR with ;
             if(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
          case subs(_wersja,14,1)="3"; repl KAU->CENA_SPR with ;
            if(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
        endc
      endi
    endi
    repl KAU->WYDANIE with KAU->WYDANIE+DOKP_R->ILOSC
    _wart:=_wart+KAU->CENA_SPR*DOKP_R->ILOSC
  endi        
  TOW->(dbgoto(_rto))

  sele DOKP_R
  skip
endd

if !_sa_opa.and.!_sa_wop; BREAK; endi                               

sele KAU
* dele all for WYDANIE=0                                             //20.09.02
set rela to s_i(INDEKS) into TOW
if recc()>0
  @ prow()+1,0 say "ROZLICZENIE OPAKOWA do "+DOKN_R->RODZAJ_DOK+;
           " "+DOKN_R->NR_DOK+"/"+DOKN_R->NR_MAG+"/"+RE(DOKN_R->ROK_DOK)+ ;
           " z " +dtoc(DOKN_R->DATA_DOK)

  _l:=len(s_i(spac(LENIN)))+_len_naz+4+3+len(transform(0,_forfak_cen))+;
                                     2*len(transform(0,_forfak_ilo))+7

  @ prow()+1,0 say padr("Indeks",len(s_i(spac(LENIN))))+" "+;
                   padr("Nazwa",_len_naz)+" "+;
                   padr("Jm.",4)+" "+;
                   "Typ"+" "+;
                   padr("Cena",len(transform(0,_forfak_cen)))+" "+;
                   padr("Wydano",len(transform(0,_forfak_ilo)))+" "+;
                   padr("Zwrcono",len(transform(0,_forfak_ilo)))+" "
  @ prow()+1,0 say repl("-",_l)
  go top
  do while !eof()
    @ prow()+1,0 say s_i(INDEKS)+" "+;
                     padr(TOW->NAZWA_TOW,_len_naz)+" "+;
                     TOW->JM+" "+;
                     " "+TYP+"  "+;
                     transform(CENA_SPR,_forfak_cen)+" "+;
                     transform(WYDANIE,_forfak_ilo)
    skip
  endd
  @ prow()+1,0 say repl("-",_l)
  @ prow()+1,0 say "Warto wydanych opakowa : "+transform(_wart,_format_war)
  @ prow()+2,0 say "Potwierdzenie wydania/zwrotu :  ..................   .................."
  @ prow()+2,0 say "                        Data :  .................."
endi

CPclose(KAU)
dele file (_sc+"KAU.DBF")
dele file (_sc+"KAU_I.NTX")

END SEQUENCE
TOW->(dbgoto(_rtow))

sele (_sel)
RETURN NIL

*******************************************************************************
FUNCTION ODPADY()
local _tex:='۲  ZESTAWIENIE ODPADW  '
priv  _data_od, _data_do,_w_zak:=0
priv _rodz_dok, _nr_g_kon:="  "

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use("ZES","R"); BREAK; endif
set index to ZES_I,ZES_E

sele 0
if !_use("SL_DOK","R"); BREAK; endif
set index to SL_DOK

sele 0
if !_use("SL_MAG","R"); BREAK; endif
set index to SL_MAG

_dla:=2
_dla:=HorizMenu(1,0,"Zestawienie dla :",{"DOKUMENTU","OKRESU"},2)

_nr_mag:=_magazyn
_rodz_dok:=space(2)

@ 2,0 say "Magazyn :" get _nr_mag pict "@K 999";
           when SLGET("SL_MAG","SL_MAG","V1",1,1,{"nr magazynu"},,.f.,BEZBLOK);
           vali SZ().and.SL("SL_MAG","SL_MAG","V1",1,1).and.SLGET()
@ 2,17 say if(_dla=2,"Dokumenty :","Dokument :") get _rodz_dok pict "@! AA";
           when SLGET("SL_DOK","SL_DOK","V2",1,1,{""},,.f.,BEZBLOK);
           vali SL("SL_DOK","SL_DOK","V2",1,1).and.SLGET()
set curs on; read; set curs off; SLGET()
if empty(_rodz_dok).or.empty(_nr_mag).or.lastkey()=K_ESC; BREAK; endi

if _dla=0; BREAK; endi

sele 0
if !_use(_gdzie_fir+"SL_G_KON","R"); BREAK; endif
set index to (_gdzie_fir+"SL_G_KON")

sele 0 
if empty(_gdzie_fir)
  if !_use("KON","R"); BREAK; endif
  set index to KON_NR, KON_NA, KON_NI, KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi

sele 0
SL_DOK->(dbseek(_rodz_dok))
_kon:=SL_DOK->KONTRAHENT

sele 0
if !_use("DOK"+_nr_mag+"N","R","DOKNN");  BREAK;  endif
set inde to ("D"+_nr_mag+"N"+"_NR") //RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK
set rela to NR_KON into KON

if _dla=1
  SL_DOK->(dbseek(_rodz_dok))
  _typ:=SL_DOK->TYP_DOK
  _koszty:=SL_DOK->KOSZTY     
  _ceny_spr:=SL_DOK->CENY_SPR 
  _dok_prz:=.f.
  _ceny_prz:=" "
  if SL_DOK->CENY_SPR="A"; _ceny_spr="T"; endi
  if SL_DOK->CENY_SPR="B"; _ceny_spr="T"; _brutto:=.t.; endi
  
  _rok_dok:=subs(dtos(date()),3,2)
  @ 2,32 say "Rok :" get _rok_dok pict "99" vali empty(_rok_dok).or.!" "$_rok_dok
  set curs on; read; set curs off
  if lastkey()=K_ESC; BREAK; endi
    
  if _kon="T" 
    _wer:="V3|V_C_SPR().and.V_C_PRZ().and.V_WZB().and.V_PZB().and.V_MMB().and."+;
              "V_VATOWIEC().and.V_OPA().and.V_OPAKOWANIA()"
  else                            // bez kontrahentow
    _wer:="V4|V_C_SPR().and.V_C_PRZ().and.V_WZB().and.V_PZB().and.V_MMB().and."+;
              "V_VATOWIEC().and.V_OPA().and.V_OPAKOWANIA()" 
  endi 

  sele DOKNN
  DOK_BOTTOM(_rodz_dok,_nr_mag,ep(_rok_dok)) 
  _nr_dok:=NR_DOK
  go top

  @ 2,43 say "Numer :"
  @ 2,51  get _nr_dok pict "99999" when SLGETDOK(1);
    vali SZ().and.(DOKNN->(dbseek(_rodz_dok+_nr_mag+ep(_rok_dok)+_nr_dok)));
             .and.SLGETDOK()
  @ 2,56 say "/"+_nr_mag+"/"+_rok_dok
  set curs on; read; set cursor off
  if lastkey()=K_ESC; BREAK; endi
  CPClose(KON)
  close SL_DOK
  close SL_MAG

else
  _data_od:=date()-day(date())+1
  _data_do:=date()
  if !(_data_beg=NIL.or._data_end=NIL)
    _data_od:=_data_beg; _data_do:=_data_end
  endi

  @ 2,32 say "Zestawienie za okres : " get _data_od;
                                    vali _data_od<=date().and.DODATY(_data_od,@_data_do)
  @ 2,col()+1 say "-" get _data_do  vali _data_do <= date().and._data_do>=_data_od
  set curs on; read; set curs off; SLGET()
  if empty(_rodz_dok).or.empty(_nr_mag).or.lastkey()=K_ESC; BREAK; endi

  SL_DOK->(dbseek(_rodz_dok))
  _typ_dok:=SL_DOK->TYP_DOK
  close SL_DOK
  close SL_MAG

  _data_beg:=_data_od; _data_end:=_data_do
  _zbiorcze:=1  // TAK
  _kierunek:=1  // wydania dla MM
  _selekcja:=2  // NIE
  _cen_prz:=" "
  _cen_spr:=" "
endi

if _kon="T".and._dla=2
  _nr_g_kon:="  "
  @ 3,0 say "Grupa firm :" get _nr_g_kon pict "99";
    when SLGET("SL_G_KON","GKON","V1",1,1,;
         {"grupa"},,.f.,BEZBLOK);
    vali empty(_nr_g_kon).or.(SZ().and.SL("SL_G_KON","GKON","V1",1,1))
  set curs on; read; set curs off; SLGET()
  if lastkey()=K_ESC; BREAK; endi
endi

sele 0
if !_use("TOW","R"); BREAK; endif
set index to TOW_IN

sele 0
if !_use("QDOKP","R"); BREAK; endif
copy stru to (_sc+"DOKP_R")

if !_use(_sc+"DOKP_R","E"); BREAK; endif
index on s_i(INDEKS) to (_sc+"DOKP_R")    

sele 0 
if !_use("DOK"+_nr_mag+"P","R","DOKP"); BREAK; endi
if _dla=2
  set rela to RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK into DOKNN
endi

if empty(_nr_g_kon).or._dla=1
  _war:=".t."
else
  _war:="KON->GRUPA_KON==_nr_g_kon"
endi

if _dla=2
  set inde to ("D"+_nr_mag+"P"+"_DI") //"dtos(DATA_DOK)+s_i(INDEKS)"

  sele DOKP
  _total:=lastrec()
  PASEK()

  _war:=_war+".and.(RODZAJ_DOK==_rodz_dok)"
  if _typ_dok=" "
   _war:=_war+".and.(_nr_mag=DOKP->NR_MAG)"
  endi
  _bwar:=COMPILE(_war)
  _bwhi:=COMPILE("DATA_DOK<=_data_do.and.!eof()")
  dbseek(_data_od,.t.)
else
  set inde to ("D"+_nr_mag+"P"+"_NR") 
  dbseek(_rodz_dok+_nr_mag+ep(_rok_dok)+_nr_dok)
  _bwar:=COMPILE(_war)
  _bwhi:=COMPILE("_rodz_dok+_nr_mag+ep(_rok_dok)+_nr_dok=="+;
                 "RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK.and.!eof()")
endi

do while Eval(_bwhi)
  if _dla=2
    PASEK(10)
    STOP_ZEST()
  endi
  if !Eval(_bwar);  skip;  loop;  endif
  
  sele DOKP_R
  seek s_i(DOKP->INDEKS)
  if !found()
    appe blank
    repl INDEKS with DOKP->INDEKS, VAT with DOKP->VAT, ZNAK with DOKP->ZNAK
  endif
  repl ILOSC      with ILOSC+DOKP->ILOSC,;
       WART_ZAK   with WART_ZAK+zaokr(DOKP->(ILOSC*CENA_ZAK),2)
  _w_zak:=_w_zak+zaokr(DOKP->(ILOSC*CENA_ZAK),2)  

  sele DOKP
  skip
enddo
close DOKP

sele DOKP_R
repl all CENA_ZAK with iif(ILOSC<>0,WART_ZAK/ILOSC,0)
copy stru to (_sc+"SPEC_R") fiel INDEKS,ILOSC,VAT
if _dla=2
  PASEK()
endi

sele 0
_use(_sc+"SPEC_R","E")
  
sele DOKP_R
go top
do while !eof()
       
  ZES->(dbseek(s_i(DOKP_R->INDEKS)))
  if ZES->(found())
  
    sele ZES
    do while s_i(INDEKS)==s_i(DOKP_R->INDEKS)
      SPEC_R->(dbappend())
      SPEC_R->INDEKS:=INDEKS_E 
      SPEC_R->ILOSC:=ZES->ILOSC*DOKP_R->ILOSC
      skip
    endd        
  endi

  sele DOKP_R
  skip
endd
clos ZES
  
sele SPEC_R
index on INDEKS to (_sc+"SPEC_R")
total on INDEKS fields ILOSC to (_sc+"SPEC")
  
clos SPEC_R
dele file (_sc+"SPEC_R.DBF")
dele file (_sc+"SPEC_R.NTX")

_use(_sc+"SPEC","!R") 
set rela to s_i(INDEKS) into TOW

go top
CPEDIT  POZ: 3+if(_dla=1,0,1),,22,               ;
        DEF: "ODPADY"             ;
        POZWER: "V1"              ;
        POZSLAD: " "+transform(INDEKS,_format_ind)+"  "+;
                 rtrim(subs(TOW->NAZWA_TOW,1,30));
        PION: ,,,                 ;
        ODTWORZ: .f.              
if _dla=2
  _tyt:="ODPADY wg "+_rodz_dok+"/"+_nr_mag+;
         if(empty(_nr_g_kon),""," dla firm "+_nr_g_kon)+;
               " okres "+dtoc(_data_od)+"-"+dtoc(_data_do)
else
  _tyt:="ZESTAWIENIE ODPADW wg "+_rodz_dok+" "+_nr_dok+"/"+_nr_mag+;
               "/"+_rok_dok
endi
go top
CPDRUK  DEF: "ODPADY"             ;
        WERSJA: "VR"              ;
        TYTUL: _tyt;
        WARIANT: 25               


END SEQUENCE
close data
dele file (_sc+"DOKP_R.DBF")
dele file (_sc+"DOKP_R.NTX")
dele file (_sc+"SPEC.DBF")
RETURN NIL

*******************************************************************************
FUNCTION KON_WEGA(_nkon)
local _osel:=select(),_ktxt,_at,_nlines,i,_komunikat:=""
BEGIN SEQUENCE

sele 0  
if !_use("KON_TXT","R","KON_WEGA"); BREAK;endif
set index to KON_TXT

if dbseek (_nkon)
    _ktxt:=KON_WEGA->TEKST
  _nlines:=MLCount(_ktxt,74)
  for i:=1 to _nlines
    _linia:=MemoLine(_ktxt,74,i)
    if  (_at:=AT("@@",_linia))>0
      _komunikat:=alltrim(subs(_linia,_at+2))
      tone(880,1)
      QKE(_komunikat)
      BREAK
    endi
  next
endi
END SEQUENCE
Cpclose(KON_WEGA)
sele (_osel)
RETU NIL

*******************************************************************************
FUNCTION KON_MOTIP(_nkon,par)
local _osel:=select(),_ktxt,_at,_nlines,i,_komunikat:=""
local _ret:=.f.,_bamk:=""

BEGIN SEQUENCE

sele 0  
if !_use("KON_TXT","R","KON_MOTIP"); BREAK;endif
set index to KON_TXT

if dbseek (_nkon)
    _ktxt:=KON_MOTIP->TEKST
  _nlines:=MLCount(_ktxt,74)
  for i:=1 to _nlines
    _linia:=upper(MemoLine(_ktxt,74,i))
    if par="B" .and. "BANK "$_linia .and." NA "$_linia .and. " FAKT"$_linia
//      tone(880,1)
      _ret:=.t.
//      QKE("Bedzie bank na fakturze")


      sele 0
      if empty(_gdzie_fir)
        if !_use("KON","R","KON_MOTI"); BREAK; endi
        set index to KON_NR, KON_NA, KON_NI, KON_AD
      else
        if !_use(_gdzie_fir+"FIRMY","R","KON_MOTI"); BREAK; endi
        set index to (_gdzie_fir+"FIRMY_NR"), (_gdzie_fir+"FIRMY_NA"),;
                     (_gdzie_fir+"FIRMY_NI"), (_gdzie_fir+"FIRMY_AD")
      endi
      dbseek(_nkon) 
      _bank:=rtrim(NAZWA_BAN)+" "+rtrim(KONTO_BAN)
      close KON_MOTI
      devpos(prow()+1,11)
      devout(_bank)
         
    elseif par="F" .and. "FAKTUR"$_linia .and." JAK "$_linia .and. " ZAM"$_linia
  //    QKE("Bedzie kolejnosc na fakturze")
      _ret:=.t.
    endi
  next
endi
END SEQUENCE
Cpclose(KON_MOTIP)
sele (_osel)
RETU _ret

*******************************************************************************
FUNCTION WE_SL_ZA_R()
local _sele :=select(), _ind:=s_i(INDEKS)
local _sel_tow:=select("TOW"),_lcen,_pom_cen, _vat_tow,_pom_cen1

_lcen:=len(_cenniki)

TOW->(dbseek(_ind))
_pom_vat:=TOW->VAT

sele select("TO_R")
use

sele 0
_use ("QTOWR","E!")
copy stru to (_sc+"TO_R")
use

sele 0
_use (_sc+"TO_R","E!")

for _i:=1 to _lcen
  _pom_cen:=Eval(memvarblock("_ceny_"+str(_i,1))) 
  _pom_cen1:=Eval(fieldwblock("CENA_"+str(_i,1),_sel_tow)) 
  appe blank
  repl CENNIK with str(_i,1),;     //_pom_cen, ;
       CENA with if(_pom_cen="N",_pom_cen1,_pom_cen1/(1+val(_pom_vat)/100))
next

sele (_sele)
RETURN .T.

*******************************************************************************
FUNCTION AKTU_NAG(_sym,_uwa,_spo,_dni,_konto)
local GetList:={}
if !empty(_sym).or.!empty(_uwa)
  repl SPR_N_R->UWAGI with alltrim(UWAGI)+" "+if(subs(_wersja,123,1)=="N","",;
       if(_sym$SPR_N_R->UWAGI.or.empty(_sym),"","ZAM. "+alltrim(_sym)+" ")+;
       if(_uwa$SPR_N_R->UWAGI.or.empty(_uwa),"","("+alltrim(_uwa)+") "))
  @ 6,11 say  SPR_N_R->UWAGI pict "@! "+repl("X",40)
endi
if !empty(_spo)
  repl  SPR_N_R->SPOSOB_PLA with _spo
  @ 5,11 say  SPR_N_R->SPOSOB_PLA pict "@! "+repl("X",25)
endi
if !empty(_dni)
  repl  SPR_N_R->TERMIN with _dni,;
        SPR_N_R->DATA_PLA with SPR_N_R->DATA_DOK+_dni
  @ 5,44 say TERMIN pict "999"
  @ 5,61 say dtoc(DATA_PLA)
endi

if !empty(_konto)
  repl  SPR_N_R->KONTO with _konto
  @ 2,54 say  SPR_N_R->KONTO 
endi
RETURN NIL

*******************************************************************************
FUNCTION NAG_ZAM_WK(_kon_nr,_kon_id,_kon_a,_kon_m,_kon_k,_kon_n,_kon_n2,;
                    _sposob,_dni,_uwagi,_sym_zam,_nr_odb,_data_zam,_konto)
local _mf

_mf:=_miasto_fir+dtoc(date())
devpos(prow(),0);devout("Sprzedawca :")
devpos(prow(),rmarg-len(_mf));devout(_mf)
devpos(prow()+1,0);devout(padc(alltrim(_pieczat1) ,45))
devpos(prow()+1,0);devout(padc(alltrim(_pieczat2) ,45))
devpos(prow()+1,0);devout(padc(alltrim(_pieczat3) ,45))

devpos(prow(),rmarg-27)
devout("O R Y G I N A  / K O P I A")
if !empty(_pieczat4)
  devpos(prow()+1,0);devout(padc(alltrim(_pieczat4) ,45))
endi
if !empty(_pieczat5)
  devpos(prow()+1,0);devout(padc(alltrim(_pieczat5) ,45))
endi
if !empty(_pieczat6)
  devpos(prow()+1,0);devout(padc(alltrim(_pieczat6) ,45))
endi
if !empty(_pieczat7)
  devpos(prow()+1,0);devout(padc(alltrim(_pieczat7) ,45))
endi

devpos(prow()+1,0);devout(padc(rtrim("Nr NIP: "+_id_fir),45))
devpos(prow()+1,0)

devpos(prow()+2,int(rmarg/2)-46)
devout(SZERx2+SZER("POTWIERDZENIE ZAMWIENIA Nr "+alltrim(_sym_zam))+;
         " z dnia "+dtoc(_data_zam)+SZERx1)

devpos(prow()+3,0);        devout("Nabywca :  "+rtrim(_kon_n))
if !empty(_kon_n2)
  devpos(prow()+1,11);     devout(alltrim(_kon_n2))
endif
devpos(prow()+1,11);       devout(if(empty(_kon_k),"",_kon_k+" ")+;
                           alltrim(_kon_m)+", "+_kon_a)

devpos(prow()+1,11);       devout("Nr NIP : "+_kon_id)

if !empty(_kon_nr) 
  devpos(prow(),pcol()+4); devout("Nr FK : "+alltrim(_kon_nr))
endif

*----------------------
DAJ_ODB_PF(_nr_odb)
*---------------------

devpos(prow()+2,0);        devout("Sposb zapaty : "+alltrim(_sposob))
devpos(prow(),pcol()+10);  devout("Termin zapaty : "+str(_dni,3)+" dni")
if !empty(_konto)
  devpos(prow(),rmarg-11);devout("Konto "+_konto)
endi
devpos(prow()+2,0);devout("Uwagi : "+_uwagi);

RETURN NIL

******************************************************************************
FUNCTION CZAM_NET()
RETURN zaokr(CENA*(1-RABAT/100),2) 

******************************************************************************
FUNCTION WZAM_NET()
RETURN zaokr(ILOSC_ZAM*zaokr(CENA*(1-RABAT/100),2),2)

******************************************************************************
FUNCTION WZAM_NETP()
RETURN zaokr((ILOSC_ZAM-ILOSC_ZRE)*zaokr(CENA*(1-RABAT/100),2),2)

******************************************************************************
FUNCTION WZAM_BRU()
RETURN zaokr(zaokr(ILOSC_ZAM*zaokr(CENA*(1-RABAT/100),2),2);
           *(1+val(TOW->VAT)/100),2)

******************************************************************************
FUNCTION DRU_ZAM_W(_sposob,_dni,_uwagi,_sym_zam,_nr_odb,_data_zam,_typ,_konto)
local _se:=sele(),_kon:=NR_KON,_w_net:=0,_w_bru:=0,_wer,;
      _w_net_:=0,_w_net0:=0,_w_net1:=0,_w_net2:=0,_w_net3:=0,_w_net4:=0,;
                            _w_vat1:=0,_w_vat2:=0,_w_vat3:=0,_w_vat4:=0,;
      _sel:=SELECT()

priv  _termin_rea:=ctod(""),_data_imp:=ctod(""),_godz_imp:="",_op:="",_nazw:=""

DEFAULT _typ TO 1    // _typ=2 zamwienia archiwalne

KON->(dbseek(_kon))
set rela to s_i(INDEKS) into TOW
//repl all WAGA with ILOSC_ZAM*TOW->WAGA
go top

sum;
      if(TOW->VAT$"zw,np" ,zaokr(ILOSC_ZAM*zaokr(CENA*(1-RABAT/100),2),2),0),;
      if(TOW->VAT=" 0" ,zaokr(ILOSC_ZAM*zaokr(CENA*(1-RABAT/100),2),2),0),;
      if(TOW->VAT=_vat1,zaokr(ILOSC_ZAM*zaokr(CENA*(1-RABAT/100),2),2),0),;
      if(TOW->VAT=_vat2,zaokr(ILOSC_ZAM*zaokr(CENA*(1-RABAT/100),2),2),0),;
      if(TOW->VAT=_vat3,zaokr(ILOSC_ZAM*zaokr(CENA*(1-RABAT/100),2),2),0),;
      if(TOW->VAT=_vat4,zaokr(ILOSC_ZAM*zaokr(CENA*(1-RABAT/100),2),2),0);
      to _w_net_,_w_net0,_w_net1,_w_net2,_w_net3,_w_net4

if "."$_format_ilo
       _w_net_:=zaokr(_w_net_,2)
       _w_net0:=zaokr(_w_net0,2)
       _w_net1:=zaokr(_w_net1,2)
       _w_net2:=zaokr(_w_net2,2)
       _w_net3:=zaokr(_w_net3,2)
       _w_net4:=zaokr(_w_net4,2)
endi

_w_vat1:=zaokr(_w_net1*val(_vat1)/100,2)
_w_vat2:=zaokr(_w_net2*val(_vat2)/100,2)
_w_vat3:=zaokr(_w_net3*val(_vat3)/100,2)
_w_vat4:=zaokr(_w_net4*val(_vat4)/100,2)

 _w_net:=_w_net_+_w_net0+_w_net1+_w_net2+_w_net3+_w_net4
 _w_bru:=_w_net+_w_vat1+_w_vat2+_w_vat3+_w_vat4

/*sum zaokr(ILOSC_ZAM*zaokr(CENA*(1-RABAT/100),2),2),;
    zaokr(zaokr(ILOSC_ZAM*zaokr(CENA*(1-RABAT/100),2),2);
          *(1+val(TOW->VAT)/100),2);
 to _w_net,_w_bru */



*if "LO-GI"$_firma
  index on INDEKS to (_sc+"ZAM_L")
*endi
if _typ=2
  _wer:="V9|V_OPIS_DOK()"         
else
  _wer:="V9|V_OPIS_DOK().and.V_IL_ZREA()"         
endi
go top
_termin_rea:=TERMIN_ZAM
if subs(_wersja,149,1)<>" "
   _data_imp:=DATA_IMP
   _godz_imp:=GODZ_IMP
   _op:=OPERATOR
   sele 0
   _use("SL_OPE","R!")
   loca for _op==KOD
   _nazw:=alltrim(NAZWA)
   CPClose (SL_OPE)
   sele (_sel)
endi

CPDRUK DEF: "PROODB"             ;
            WERSJA: _wer                          ;
            NAGLOWEK: NAG_ZAM_WK(KON->NR_KON, KON->ID_KON, KON->ADRES,;
                                 KON->MIASTO, KON->KOD, KON->NAZWA_KON,;
                                 KON->NAZWA_KON2,;
                   _sposob,_dni,_uwagi,_sym_zam,_nr_odb,_data_zam,_konto);
            STOPKA: STO_PROWAD(_w_net,_w_bru) ; 
            WARIANT: 49
sele (_se)
set index to
dele file (_sc+"ZAM_L.NTX")

RETURN NIL

******************************************************************************
FUNCTION STO_PROWAD(_w_net,_w_bru)
local j:=0,i,_txt:=""

@ prow(),numery_kol[7+if(_opis_na_do="T",1,0)] say transform(_w_net,_format_war)
@ prow(),numery_kol[9+if(_opis_na_do="T",1,0)] say transform(_w_bru,_format_war)
@ prow()+2,0 say "Warto do zapaty : "+transform(_w_bru,_format_war);
                +" z"

  _sl:=SLOW_ZL_GR(_w_bru,rmarg-16,1)
  
  if at('_',_sl)=0 
     @ prow()+2,0 say "Sownie :     "+_sl
  else
     @ prow()+2,0 say "Sownie :     "+subs(_sl,1,at('_',_sl)-1)
     @ prow()+1,0 say "              "+subs(_sl,at('_',_sl)+1)
  endif
if !"FORNETTI"$upper(_firma)
  @ prow()+3,int((rmarg-97)/2) say "Potwierdzenie zoenia zamwienia :                       Potwierdzenie przyjcia do realizacji :"
  @ prow()+3,int((rmarg-97)/2) say "...................................                       ......................................."
  @ prow()+2,int((rmarg-97)/2) say "Data : ............                                       Data : ............"
else
  @ prow()+3,int((rmarg-97)/2) say "Towar wyda:                                              Towar przyj:                         "
  @ prow()+3,int((rmarg-97)/2) say "...................................                       ......................................."
  @ prow()+2,int((rmarg-97)/2) say "                                                          Data : ............"
endi  
  if _wagazam>0.and. !subs(_wersja,141,1)=="N"  
    @ prow()+2,0 say "Waga towaru : "+;
                      ltrim(transform(_wagazam,_forwag_tow))+" "+_jm_wag_tow+;
      if (!_wagazamok," (dane niepene)","")
  endi

  if !empty(_termin_rea)
     @ prow()+2,0 say "Termin realizacji: "+dtoc(_termin_rea)
  endi

  if subs(_wersja,149,1)<>" "
     if !empty(_data_imp)
        @ prow()+2,0 say "Data/godzina importu do centrali: "+dtoc(_data_imp)+;
                         " "+_godz_imp
     endi
     if !empty(_op)
        @ prow(),pcol()+2 say "Operator: "+_op+" "+_nazw
     endi
  endi
 
  @ prow()+1,0 say ""
  _txt:=PROMEM->OPIS
  for i:=1 to mlcount(_txt,76)
      @ prow()+1,0 say BOLD_ON+alltrim(memoline(_txt,76,i))+BOLD_OFF
  next

RETURN NIL

*******************************************************************************
FUNCTION SPO_ZAP(_dni,_sposob)
local _sel:=select(),_ret:=.t.,_znalazl:=.f.

sele SL_PLA
loca for SPOSOB_PLA=_sposob
_znalazl:=found()
if _dni_kon<>0.and._dni_kon<SL_PLA->DNI.and.!_pyt_zap
   if QTN;
     ("Zgoda na termin patnoci niezgodny ze sownikiem kontrahentw ?").and.;
      WARA()

      _dni:= SL_PLA->DNI
      _pyt_zap:=.t.
   else
      _ret:=.f.
   endi
else
   if _znalazl
     _dni:= SL_PLA->DNI
   endi
endi

sele (_sel)
for _i:=1 to len(GetList); GetList[_i]:display(); next 
RETURN _ret
*******************************************************************************
FUNCTION DNI_ZAP()
local _ret:=.t.

if _dni_kon<>0.and._dni_kon<_dni.and.!_pyt_zap
   if QTN;
     ("Zgoda na termin patnoci niezgodny ze sownikiem kontrahentw ?").and.;
      WARA()
      _pyt_zap:=.t.
   else
      _ret:=.f.
   endi
endi

RETU _ret
*******************************************************************************
FUNCTION DAJ_CIR(_ref)
local _c:=0,_r:=0
local _spacgru:=if(subs(_wersja,81,1)=="G",spac(3),spac(2)),;
      _zerogru:=if(subs(_wersja,81,1)=="G","000","00")

DEFAULT _ref TO .t.

CENA_ZAM(_nr_cen_spr)
UPU_ZAM()

if _ref;CPSwiezyRekord();endi
RETURN NIL

*******************************************************************************
FUNCTION CENA_ZAM(_nr_cen)
local _sel_tow:=select("TOW"),_pom_cen,_pom_cen1,_lcen

_lcen:=len(_cenniki)
TOW->(dbseek(PROZAM->(s_i(INDEKS))))

_pom_cen:=Eval(fieldwblock("CENA_"+_nr_cen,_sel_tow))
_pom_cen1:=Eval(memvarblock("_ceny_"+_nr_cen))
repl PROZAM->CENA with if(_pom_cen1="N",_pom_cen,;
                                        _pom_cen/(1+val(TOW->VAT)/100))
/*  
do case 
  case _nr_cen="1"
    repl PROZAM->CENA with ;
              if(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
  case _nr_cen="2"
    repl PROZAM->CENA with ;
              iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
  case _nr_cen="3"
    repl PROZAM->CENA with ;
              iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
endc
*/
RETURN NIL

*******************************************************************************
FUNCTION DAJ_SYM(_sym_zam)
local _i
_byl_w_slowniku:=.f.

if _ktory_rekord>0
  go _ktory_rekord  
  _ktory_rekord:=0
  _sym_zam:=SYMBOL_ZAM
  _byl_w_slowniku:=.t.
endi                                                                
for _i:=1 to len(GetList); GetList[_i]:display(); next 
RETURN .t.

*******************************************************************************
FUNCTION SYM_ZAM_DO(_rk)
loca _al:=alias(),_re,_or,_nr:="00000"

DEFAULT _rk TO subs(dtos(date()),1,4)
if subs(_wersja,149,1)="L".and.file("ZAK_ZAM.DBF")
   sele 0
   _use("ZAK_ZAM","R!")
endi
if subs(_wersja,149,1)="C"
   sele 0
   _use("CONFIG","R!")
   if fieldpos("ZAM_OD")>0.and.fieldpos("ZAM_DO")>0
      if !empty(ZAM_OD)
         _czam_od:=ZAM_OD
      endi
      if !empty(ZAM_DO)
         _czam_do:=ZAM_DO
      endi
   endi
   CPClose(CONFIG)
endi

sele PROZAM
_re:=recn()
_or:=indexord()
set orde to 3
if subs(_wersja,149,1)="L".and.select("ZAK_ZAM")>0
   dbseek(_rk+subs(str(val(ZAK_ZAM->ZAM_DO),7),1,6)+":",.t.)
elseif subs(_wersja,149,1)="C"
   dbseek(_rk+subs(str(val(_czam_do),7),1,6)+":",.t.)
else
   dbseek(_rk+"9999:",.t.)  
endi
skip -1
if empty(subs(_wersja,149,1))
   if DR(DATA_ZAM)=_rk.and.!bof()
      _nr:=trans0(val(SYMBOL_ZAM)+1,5)+"/"+_rk
   else
      _nr:="00001/"+_rk
   endi
else
   if subs(_wersja,149,1)="L".and.select("ZAK_ZAM")>0
      if DR(DATA_ZAM)<>_rk.or.bof().or.val(SYMBOL_ZAM)+1<val(ZAK_ZAM->ZAM_OD)
         _nr:=ZAK_ZAM->ZAM_OD+"/"+_rk
      else
         if val(SYMBOL_ZAM)+1>val(ZAK_ZAM->ZAM_DO)
            QKE("Uwaga ! Wyczerpany zakres numeracji zamwie !")
         endi
         _nr:=trans0(val(SYMBOL_ZAM)+1,5)+"/"+_rk
      endi
   endi
   if subs(_wersja,149,1)="C"
      if DR(DATA_ZAM)<>_rk.or.bof().or.val(SYMBOL_ZAM)+1<val(_czam_od)
         _nr:=_czam_od+"/"+_rk
      else
         if val(SYMBOL_ZAM)+1>val(_czam_do)
            QKE("Uwaga ! Wyczerpany zakres numeracji zamwie !")
         endi
         _nr:=trans0(val(SYMBOL_ZAM)+1,5)+"/"+_rk
      endi
   endi
endi
go _re
set orde to _or

if subs(_wersja,149,1)="L".and.select("ZAK_ZAM")>0
   CPClose(ZAK_ZAM)
endi

sele (_al)
RETURN _nr

*******************************************************************************
FUNCTION SYM_OK(_sym)
local _pom1,_pom:=val(subs(_sym,7,4)),_ret:=.t.,_sel:=select(),;
      _nrz:=val(subs(_sym,1,5))

_pom1:=isdigit(subs(_sym,1,1)) .and.isdigit(subs(_sym,2,1)) .and.;
      isdigit(subs(_sym,3,1)) .and.isdigit(subs(_sym,4,1)) .and.;
      isdigit(subs(_sym,5,1)) .and. subs(_sym,6,1)=="/" .and.;
      _pom>=1995 .and._pom<=year(date())+2

if !_pom1
  tone(220,1)
  _ret:=QTN_2W(;
"Uwaga! Symbol zamwienia powinien skada si z 5 cyfr, znaku '/'",;
" i 4-cyfrowego roku np. 00012/"+str(year(date()),4)+",  01234/"+str(year(date()),4)+;
". Kontynuacja ?" )
endi

if !empty(subs(_wersja,149,1))
   if subs (_wersja,149,1)="C"
      sele 0
      _use("SL_LAP","R!")
      go top
      do while !eof().and._ret
         if _nrz>=val(ZAM_OD).and._nrz<=val(ZAM_DO).and.;
            file("LAP"+NR_MAG+".DBF")
            QKE("Numer zamwienia w zakresie numeracji akwizytora w trasie !")
            if _priorytet<11
               _ret:=.f.
            endi
         endi
         skip 1
      endd
      CPClose(SL_LAP)
      if _nrz<val(_czam_od).or._nrz>val(_czam_do)
         QKE("Numer zamwienia poza zakresem numeracji zamwie !")
         if _priorytet<11
            _ret:=.f.
         endi
      endi
   else
      if file("ZAK_ZAM.DBF")
         sele 0
         _use("ZAK_ZAM","R!")
         if _nrz<val(ZAM_OD).or._nrz>val(ZAM_DO)
            QKE("Numer zamwnienia poza dopuszczalnym zakresem !")
            if _priorytet<11
               _ret:=.f.
            endi
         endi
         CPClose(ZAK_ZAM)
      endi
   endi
endi

sele (_sel)
RETURN _ret

*******************************************************************************
FUNCTION PZAM_ODB(_p)  
loca _tex1:='۲  PRZEGLDANIE ZAMWIE OD ODBIORCW  ',;
     _tex2:='۲  PRZEGLDANIE ARCHIWALNYCH ZAMWIE OD ODBIORCW  ',;
     _tex3:='۲  PRZYPISANIE/ZMIANA OPERATORA  '
loca _nazwa_kon:="",GetList:={}
loca _war_zam:=0,_war_zamr:=0, _bez_cen:=.f., _ill:=0, _ilp:=0
local rr,_blok:=.f.
local _waga:=0,_waga_ok:=.t.,_di:=ctod(""),_gi:=ctod(""),_nazwisko:=""
local _kolor

priv _nr_kon:=spac(5),_data_zam:=date(),_nr_mag:=_magazyn,;
     _sym_zam:=spac(10),_nr_odb:=spac(5),_uwagi:=spac(33),_sposob:=spac(25),;
     _dni:=0,_nr_cen_spr:=" ",_termin_zam:=ctod(""),_konto:=space(5)
priv _ktory_rekord:=0,_op:=""

cls

DEFAULT _p TO 1

if _p=1
  @ 0,0 say _tex1
elseif _p=2
  @ 0,0 say _tex2
else
  @ 0,0 say _tex3
endi

BEGIN SEQUENCE

sele 0
if !_use("TOW","R"); BREAK; endi
set index to TOW_IN, TOW_NA, TOW_GR, TOW_SW

sele 0
if empty(_gdzie_fir)
  if !_use("KON","R"); BREAK; endif
  set index to KON_NR, KON_NA, KON_NI, KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
                 (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi

if _p=1.or._p=3

  sele 0
  if !_use("PROZAM","R"); BREAK; endi
  set index to PROZAM,PROZAM_I,PROZAM_S
 
  sele 0
  _use("PROMEM","R!")
  set index to PROMEM
else

  sele 0
  if !_use("PROZAM_A","R","PROZAM"); BREAK; endi
  set index to PROZA,PROZA_I,PROZA_S
  
  sele 0
  _use("PROMEM_A","R!","PROMEM")
  set index to PROME
endi
        
sele PROZAM
*------------------
#ifdef XXX

* skopiowanie po jednym rekordzie z kazdego zamowienia do 
* (_sc+PRO_PR)
copy stru to  (_sc+"PRO_NR")

sele 0
_use(_sc+"PRO_NR","E")
inde on DR(DATA_ZAM)+str(val(SYMBOL_ZAM),7)+NR_KON to (_sc+"PRO_NR")

sele PROZAM
go top

QPC(1)
do while !eof()
  if PRO_NR->(!dbseek(PROZAM->(DR(DATA_ZAM)+str(val(SYMBOL_ZAM),7)+NR_KON)))
    if !empty(PROZAM->INDEKS)
      rr:=PROZAM->(recn())

      sele PRO_NR
      appe RECORD rr from PROZAM
    endi
  endi
  
  sele PROZAM
  skip
enddo
QPC(0)
*---------------------
#endif

sele PROZAM
set rela to s_i(INDEKS) into TOW
set rela to NR_KON into KON additive

//sele PRO_NR
set order to 3
go bott
_sym_zam:=SYMBOL_ZAM

sele PROZAM
@ 1,0 say "Zamwienie :" get _sym_zam pict "@! "+repl("X",10);
      when SLRGET("PROZAM","PROODB","V1",3,;
      {"nr kontr.","indeks","rok+nr zam."},,.f.,BEZBLOK);
      vali SYM_ZAM_OK()


set curs on; read; SLGET(); set curs off
if lastkey()=K_ESC; BREAK; endi

//close PRO_NR

sele PROZAM
set order to 1

seek _nr_kon+dtos(_data_zam)+_sym_zam
if !found(); tone(220,1); BREAK; endi

_data_zam:=DATA_ZAM
_termin_zam:=TERMIN_ZAM
_sposob:=SPOSOB_PLA
_nr_kon:=NR_KON
_nr_odb:=NR_ODB
_dni:=DNI
_uwagi:=padr(UWAGI,33)
_konto:=KONTO
KON->(dbseek(_nr_kon))
_nazwa_kon:=KON->NAZWA_KON
if subs(_wersja,149,1)<>" "
   _di:=DATA_IMP
   _gi:=GODZ_IMP
   _op:=OPERATOR
   sele 0
   _use("SL_OPE","R!")
   loca for KOD==_op
   _nazwisko:=alltrim(NAZWA)
   CPClose(SL_OPE)
   sele PROZAM
endi

_kolor:=subs(_ekra_blo,at(",",_ekra_blo)+1)

@ 1,25 say "Data:"  
@ 1,31 say dtoc(_data_zam) COLOR _kolor
@ 1,40 say "Termin realizacji:" 
@ 1,59 say  dtoc(_termin_zam) COLOR _kolor
@ 1,69 say "K-to:" 
@ 1,75 say  _konto COLOR _kolor
@ 2,0  say "Nr firmy:" 
@ 2,10 say _nr_kon  COLOR _kolor
@ 2,col()+2 say subs(_nazwa_kon,1,40) //COLOR _kolor
@ 2,65 say "Odbiorca:" 
@ 2,75 say _nr_odb  COLOR _kolor
@ 3,0 say "Uwagi:" 
@ 3,7 say _uwagi  COLOR _kolor
@ 3,col()+2 say "Patno:" 
@ 3,col()+1 say _sposob  COLOR _kolor
/*
@ 3,col()+2 say "Termin:" 
@ 3,col()+1 say str(_dni,3)  COLOR _kolor
*/
//cleear gets

if ILOSC_ZAM=0.and.ILOSC_ZRE=0.and.!empty(DATA_ZAM)
  QKE("Zamwienie archiwalne.")
  BREAK
endi

sele PROMEM
set(_SET_COLOR,_edit_blo)

@ 20,0 clea to 23,79
@ 20,0,23,79 BOX B_DOUBLE
if dbseek(_nr_kon+dtos(_data_zam)+_sym_zam)
  @ 23,4 say " przegldanie - SPACJA "
  keyboard chr(K_ESC)
  MEMOEDIT(PROMEM->OPIS,21,2,22,77,.f.)
endi

set(_SET_COLOR,_ekra_blo)

sele PROZAM
seek _nr_kon+dtos(_data_zam)+_sym_zam
if _p=1
   if empty(NR_BLO)
      _blo:=.f.
   else
      _blo:=.t.
   endi
endi
_war_zam:=0;_war_zamr:=0; _bez_cen:=.f.; _ill:=0; _ilp:=0
_waga:=0;_waga_ok:=.t.
dbeval({|| if(ILOSC_ZAM=0.or.empty(INDEKS),NIL,;
               (if(CENA=0,_bez_cen:=.t.,NIL),;
                _ilp++,_ill+=ILOSC_ZAM,;
                _war_zamr+=ILOSC_ZAM*zaokr(CENA*(1-RABAT/100),2),;
                _war_zam+=ILOSC_ZAM*CENA,;
                if(TOW->WAGA=0,_waga_ok:=.f.,NIL),;
                _waga+=ILOSC_ZAM*TOW->WAGA));
       },,;
       {|| NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==_nr_kon+dtos(_data_zam)+_sym_zam})

if !_bez_cen
  @ 17,0 say "Warto bez rabatu : "+transform(_war_zam ,_format_war)
  @ 18,0 say "Warto z rabatem :  "+transform(_war_zamr,_format_war)
else
  @ 17,0 say "Uwaga : brak cen towarw."
endi
@ 17,36  say "Pozycji : "+transform(_ilp,"@Z 999")
@ 17,65-len(transform(_ill,_format_ilo));
         say "Suma iloci : "+transform(_ill,_format_ilo)
if _waga>0
  @ 18,36 say "Waga : "+ ltrim(transform(_waga,_forwag_tow))+" "+_jm_wag_tow+;
    if(_waga_ok,""," (dane niepene)")
endi
if !empty(_gi)
   @19,0 say "Data/godzina importu do centrali: "+dtoc(_di)+;
             " "+_gi
endi

if !empty(_op)
   @19,col()+1 say "Operator: "+_op+" "+_nazwisko+"                  "
endi

FilterTop(_nr_kon+dtos(_data_zam)+_sym_zam)
CPEDIT  POZ: 4,,16,       ;
        DEF: "PROODB"     ;
        POZWER: "V2|V_MAG().and.V_OPIS_DOK()" ;
        POZSLAD: " "+s_i(INDEKS)+"  "+TOW->NAZWA_TOW;
        PION: ,,,         ;
        INDEXY: {}        ;
        AKCJA: OPIS_ZAM(_nr_kon,_data_zam,_sym_zam,.f.) ;
        WARUNEK: _nr_kon+dtos(_data_zam)+_sym_zam==;
                  NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM ;
        GORA: FilterTop(_nr_kon+dtos(_data_zam)+_sym_zam)        ;
        DOL:  FilterBottom(_nr_kon+dtos(_data_zam)+_sym_zam)     ;
        DODAJ: DODAJ_ZAM2(_nr_kon,_data_zam,_sym_zam,_nr_odb,_uwagi,;
                             _sposob,_dni,_nr_cen_spr)  ;
        ODTWORZ: .f.                                    

sele PROZAM
seek _nr_kon+dtos(_data_zam)+_sym_zam
copy to (_sc+"PROZAM_R") while _nr_kon+dtos(_data_zam)+_sym_zam==;
                    NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM
  
_use(_sc+"PROZAM_R","E!")
if TOW->(fieldpos("WAGA")>0)                      //17.01.00
   set rela to s_i(INDEKS) into TOW
   _wagazam:=0
   _wagazamok:=.t.
   dbeval({|| if(TOW->WAGA=0, _wagazamok:=.f.,NIL),;
              _wagazam:=_wagazam+ILOSC_ZAM*TOW->WAGA})
   set rela to
   go top
endi

*DRU_ZAM_W(_sposob,_dni,_uwagi,_sym_zam,_nr_odb,_data_zam,_p)
if "MirekS" $ _firma                                                 //12.05.06

  sele 0
  if !_use("MAG"+_nr_mag,"S","MAG");break;endi 
  set inde to ("M"+_nr_mag+"_IP0")

  sele PROZAM_R
  DRU_ZAM_MI(_uwagi,_sym_zam,_nr_kon,_data_zam)

else
  do while .t.
          @ 24,0
          _co_druk:=;
          Horizmenu(24,0,"Druk: ",{"ZAMOWIENIE","FAKTURA PRO FORMA","KONIEC"},1)
          if _co_druk=1
            DRU_ZAM_W(_sposob,_dni,_uwagi,_sym_zam,_nr_odb,_data_zam,_p,_konto)
          elseif _co_druk=2
            PRO_FOR_ZAM( _nr_kon,_data_zam,_sym_zam,,,,_nr_odb)
          else
            exit
          endi
  enddo 
endi

CPClose(PROZAM_R)

@ 24,0
close data

if _p=2 //.and."LO-GI"$_firma
 _wybl:=HorizMenu(24,0,"",{"SKASOWANIE","PRZYWRCENIE DO REALIZACJI","KONIEC"};
                          ,3)

  if _wybl=3.or._wybl=0
    BREAK
  elseif _wybl=1.and.HA(_haslo)

    sele 0
    if !_use("PROZAM_A","S"); BREAK; endi
    set index to PROZA,PROZA_I,PROZA_S
  
    sele 0
    if !_use("PROMEM_A","S"); BREAK; endi
    set index to PROME

    sele PROZAM_A
    seek _nr_kon+dtos(_data_zam)+_sym_zam
    dbeval({|| RBLOK(),dbdelete() },,{ ||NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
              _nr_kon+dtos(_data_zam)+_sym_zam })

//    dele while NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
//              _nr_kon+dtos(_data_zam)+_sym_zam

    sele PROMEM_A
    seek _nr_kon+dtos(_data_zam)+_sym_zam
    dbeval({|| RBLOK(),dbdelete() },,{ ||NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
              _nr_kon+dtos(_data_zam)+_sym_zam })
//    dele while NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
//              _nr_kon+dtos(_data_zam)+_sym_zam

  elseif _wybl=2.and.HA(_haslo)
    
    sele 0
    if !_use("PROZAM_A","S"); BREAK; endi
    set index to PROZA,PROZA_I,PROZA_S
  
    sele 0
    if !_use("PROMEM_A","S"); BREAK; endi
    set index to PROME

    sele 0
    if !_use("PROZAM","S"); BREAK; endi
    set index to PROZAM, PROZAM_I, PROZAM_S
  
    sele 0
    if !_use("PROMEM","S"); BREAK; endi
    set index to PROMEM

    sele PROZAM_A
    seek _nr_kon+dtos(_data_zam)+_sym_zam
    copy to (_sc+"PROZAM_R") while _nr_kon+dtos(_data_zam)+_sym_zam==;
                    NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM
    sele PROMEM_A
    seek _nr_kon+dtos(_data_zam)+_sym_zam
    copy to (_sc+"PROMEM_R") while _nr_kon+dtos(_data_zam)+_sym_zam==;
                    NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM

    sele PROZAM
    seek _nr_kon+dtos(_data_zam)+_sym_zam
    dbeval({|| RBLOK(),dbdelete() },,{ ||NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
              _nr_kon+dtos(_data_zam)+_sym_zam })

//    dele while NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
//              _nr_kon+dtos(_data_zam)+_sym_zam
********************************************************************** 08.03.05
    if QTN("Czy wyzerowa iloci zrealizowane ?")
       sele 0
       _use(_sc+"PROZAM_R","E!")
       repl all ILOSC_ZRE with 0
       use
       sele PROZAM
    endi
*******************************************************************************
    appe from (_sc+"PROZAM_R")
//    pack
    use


    sele PROMEM
    seek _nr_kon+dtos(_data_zam)+_sym_zam
//    dele while NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
//              _nr_kon+dtos(_data_zam)+_sym_zam
    dbeval({|| RBLOK(),dbdelete() },,{ ||NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
              _nr_kon+dtos(_data_zam)+_sym_zam })


    appe from (_sc+"PROMEM_R")
    use

    sele PROZAM_A
    seek _nr_kon+dtos(_data_zam)+_sym_zam
    dbeval({|| RBLOK(),dbdelete() },,{ ||NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
              _nr_kon+dtos(_data_zam)+_sym_zam })

//    dele while NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
//              _nr_kon+dtos(_data_zam)+_sym_zam
//    pack

    sele PROMEM_A
    seek _nr_kon+dtos(_data_zam)+_sym_zam
    dbeval({|| RBLOK(),dbdelete() },,{ ||NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
              _nr_kon+dtos(_data_zam)+_sym_zam })

//    dele while NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
//              _nr_kon+dtos(_data_zam)+_sym_zam

  endi
endi

if _p=1
 _wybl:=HorizMenu(24,0,"",{"SKASOWANIE","PRZENIESIENIE DO ARCHIWUM",;
        if(_blo=.t.,"ODBLOKOWANIE ","ZABLOKOWANIE ")+"STANU","KONIEC"},4)

  if _blo=.f..and._wybl=3
     if !HA(_haslo);break;endi

     sele 0
     _use("PROZAM","S!")
     set index to PROZAM,PROZAM_I,PROZAM_S

     if dbseek(_nr_kon+dtos(_data_zam)+_sym_zam)

        sele 0
        _use("SL_MAG","R!")
        set inde to SL_MAG
         @ 24,71 say "Mag.:" get _nr_mag pict "@K 999";
                     when SLGET("SL_MAG","SL_MAG","V2",1,1,;
                     {"nr magazynu"},,.f.,BEZBLOK);
                     valid SZ().and.SL("SL_MAG","SL_MAG","V2",1,1)
        set curs on; read; SLGET(); set cursor off
        use


 
        sele 0
        _use("MAG"+_nr_mag,"S!","MAG")
        set inde to ("M"+_nr_mag+"_IP")

        sele 0
        _use("BLOKADY","S!")
        set inde to BLOK_IN,BLOK_PO,BLOK_NR
        set order to 3

        _astru:={}
        aadd(_astru,{"INDEKS","C"   ,LENIN,0})
        aadd(_astru,{"ILOSC_ZAM","N",12,3})
        aadd(_astru,{"ILOSC_BLO","N",12,3})
        dbcreate(_sc+"BRAK_BLO",_astru)
        sele 0
        _use(_sc+"BRAK_BLO","E!")

        _nr:= NR_BLO_DOM()
        
        sele PROZAM

        do while !eof().and.;
           _nr_kon+dtos(_data_zam)+_sym_zam==NR_KON+dtos(_data_zam)+SYMBOL_ZAM

           _ile:=ILOSC_ZAM-ILOSC_ZRE
           if MAG->(dbseek(s_i(PROZAM->INDEKS)))
              do while !MAG->(eof()).and.;
                       s_i(PROZAM->INDEKS)==s_i(MAG->INDEKS).and.;
                       _ile>0
                 if MAG->(STAN-STAN_B)>0
  
                    MAG->(rblok())
                    _ii:=min(_ile,MAG->(STAN-STAN_B))
                    repl MAG->STAN_B with min(MAG->STAN,MAG->STAN_B+_ile)
                    _ile:=_ile-_ii
 
                    MAG->(dbunlock())
     
                    BLOKADY->(appe_blok())
                    repl BLOKADY->STATUS with "B",;
                         BLOKADY->NR_MAG with _nr_mag ,;
                         BLOKADY->INDEKS with MAG->INDEKS,;
                         BLOKADY->CENA_ZAK with MAG->CENA_ZAK,;
                         BLOKADY->DATA_DOS with MAG->DATA_DOS,;
                         BLOKADY->ILOSC with _ii,;
                         BLOKADY->UWAGI with "|zam|"+alltrim(SYMBOL_ZAM),;
                         BLOKADY->DATA with DATA_ZAM,;
                         BLOKADY->NR_KON with NR_KON,;
                         BLOKADY->OPERATOR with _operator,;
                         BLOKADY->NR_BLO with _nr

                    BLOKADY->(dbunlock())
                 endi
                 MAG->(dbskip())
              endd
           endi         
           if _ile>0
              BRAK_BLO->(dbappend())
              BRAK_BLO->INDEKS   :=PROZAM->INDEKS
              BRAK_BLO->ILOSC_ZAM:=PROZAM->(ILOSC_ZAM-ILOSC_ZRE)
              BRAK_BLO->ILOSC_BLO:=PROZAM->(ILOSC_ZAM-ILOSC_ZRE)-_ile
           endi
           skip
        endd

        CPClose(BRAK_BLO)
        CPClose(MAG)
        sele PROZAM

        if dbseek (_nr_kon+dtos(_data_zam)+_sym_zam)
           do while _nr_kon+dtos(_data_zam)+_sym_zam==;
                    NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM
              rblok()
              repl NR_BLO with DR(DATA_ZAM)+_nr
              dbunlock()
              skip
           endd
        endi
          
        dbseek (_nr_kon+dtos(_data_zam)+_sym_zam)

        if I_R(_sc+"BRAK_BLO").and.;
           QTN_2W(;
                "Nie udao si zablokowa wszystkich stanw dla zamwienia.",;
                "Chcesz zobaczy raport ?")

           sele 0
           _use("TOW","R!")
           set inde to TOW_IN

           sele 0
           _use(_sc+"BRAK_BLO","E!")
           set rela to s_i(INDEKS) into TOW

           go top
           CPEDIT  POZ: 6,0,23,79            ;
                   DEF: "BRAK_BLO"           ;
                   POZWER: "V1|V_OPIS_DOK()" ;
                   KOLOR: _slow_blo          ;
                   PION: ,,,                 ;
                   INDEXY: {}                ;
                   EDYCJA: .f.               ;
                   ODTWORZ: .f.

           CPDRUK DEF: "BRAK_BLO"             ;
           WERSJA: "V1|V_OPIS_DOK()"              ;
           TYTUL: "Braki na magazynie w stosunku do zamwienia "+;
                   alltrim(PROZAM->SYMBOL_ZAM);
           WARIANT: 39

           CPClose(BRAK_BLO)
           CPCLose(TOW)
        endi       
     endi

     CPClose (PROZAM)
  endi 

  if _wybl=1.or._wybl=2.or.(_blo=.t..and._wybl=3)
     if !HA(_haslo);break;endi

     sele 0
     if !_use("PROZAM","S"); BREAK; endi
     set index to PROZAM,PROZAM_I,PROZAM_S

     if dbseek(_nr_kon+dtos(_data_zam)+_sym_zam).and.!empty(NR_BLO)
        sele 0
        if !_use("BLOKADY","S");break;endi
        set inde to BLOK_IN,BLOK_PO,BLOK_NR
        set order to 3
        if dbseek(PROZAM->NR_BLO)
           do while !eof().and.PROZAM->NR_BLO==DR(DATA)+NR_BLO
               _kk:=s_i(INDEKS)+if(_rozchody="2",dtos(DATA_DOS),"")+;
                    s_c(CENA_ZAK)
              if NR_KON==_nr_kon.and.UWAGI=;
                              "|zam|"+if(empty(_data_zam),"",alltrim(_sym_zam))

                 sele 0
                 if !_use("MAG"+BLOKADY->NR_MAG,"S","MAGB");break;endi
                 set inde to ("M"+BLOKADY->NR_MAG+"_IP0")
 
                 sele BLOKADY
                 if MAGB->(dbseek(_kk))
                    MAGB->(rblok())
                    repl MAGB->STAN_B with max(0,MAGB->STAN_B-ILOSC)
                    MAGB->(dbunlock())
                 endi
  
                 CPClose(MAGB)
                 sele BLOKADY
                 rblok()
                 dele
                 dbunlock()
              endi
           skip
           endd
        endi
        sele PROZAM
        do while !eof().and.;
             _nr_kon+dtos(_data_zam)+_sym_zam==NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM
           rblok()
           repl NR_BLO with ""
           dbunlock()
           skip
        endd
     endi
     CPClose(PROZAM)
  endi 

  if _wybl=4.or._wybl=0
    BREAK
  elseif _wybl=1

    sele 0
    if !_use("PROZAM","S"); BREAK; endi
    set index to PROZAM,PROZAM_I,PROZAM_S
  
    sele 0
    if !_use("PROMEM","S"); BREAK; endi
    set index to PROMEM

    sele PROZAM
    seek _nr_kon+dtos(_data_zam)+_sym_zam
    dbeval({|| RBLOK(),dbdelete() },,{ ||NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
              _nr_kon+dtos(_data_zam)+_sym_zam })

//    dele while NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
//              _nr_kon+dtos(_data_zam)+_sym_zam
//    pack

    sele PROMEM
    seek _nr_kon+dtos(_data_zam)+_sym_zam
    dbeval({|| RBLOK(),dbdelete() },,{ ||NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
              _nr_kon+dtos(_data_zam)+_sym_zam })

//    dele while NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
//              _nr_kon+dtos(_data_zam)+_sym_zam
//    pack

  elseif _wybl=2
    
    sele 0
    if !_use("PROZAM_A","S"); BREAK; endi
    set index to PROZA,PROZA_I,PROZA_S
  
    sele 0
    if !_use("PROMEM_A","S"); BREAK; endi
    set index to PROME

    sele 0
    if !_use("PROZAM","S"); BREAK; endi
    set index to PROZAM,PROZAM_I,PROZAM_S
  
    sele 0
    if !_use("PROMEM","S"); BREAK; endi
    set index to PROMEM

    sele PROZAM
    seek _nr_kon+dtos(_data_zam)+_sym_zam
    copy to (_sc+"PROZAM_R") while _nr_kon+dtos(_data_zam)+_sym_zam==;
                    NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM

    sele PROMEM
    seek _nr_kon+dtos(_data_zam)+_sym_zam
    copy to (_sc+"PROMEM_R") while _nr_kon+dtos(_data_zam)+_sym_zam==;
                    NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM

    sele PROZAM_A
    seek _nr_kon+dtos(_data_zam)+_sym_zam
    dbeval({|| RBLOK(),dbdelete() },,{ ||NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
              _nr_kon+dtos(_data_zam)+_sym_zam })

//    dele while NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
//              _nr_kon+dtos(_data_zam)+_sym_zam
    appe from (_sc+"PROZAM_R")

    sele PROMEM_A
    seek _nr_kon+dtos(_data_zam)+_sym_zam
    dbeval({|| RBLOK(),dbdelete() },,{ ||NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
              _nr_kon+dtos(_data_zam)+_sym_zam })

//    dele while NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
//              _nr_kon+dtos(_data_zam)+_sym_zam
    appe from (_sc+"PROMEM_R")

    sele PROZAM
    seek _nr_kon+dtos(_data_zam)+_sym_zam
    RBLOK()
    repl ILOSC_ZAM with 0, ILOSC_ZRE with 0, INDEKS with "",;
         UWAGI with "ARCH "+UWAGI
    skip
    dbeval({|| RBLOK(),dbdelete() },,{ ||NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
              _nr_kon+dtos(_data_zam)+_sym_zam })
//    dele while NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
//              _nr_kon+dtos(_data_zam)+_sym_zam
//    pack

    sele PROMEM
    seek _nr_kon+dtos(_data_zam)+_sym_zam
    dbeval({|| RBLOK(),dbdelete() },,{ ||NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
              _nr_kon+dtos(_data_zam)+_sym_zam })

//    dele while NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==;
//              _nr_kon+dtos(_data_zam)+_sym_zam
//    pack

  endi
endi

if _p=3.and.QTN("Zmiana operatora ?").and._bierny<>"T"
   sele 0
   if !_use("SL_OPE","R");break;endi
   inde on KOD to (_sc+"SL_OPE")
   loca for KOD==_operator
   _op:=_operator
   @24,0
   @24,0 say "Operator " get _op pict "@!"; 
        when SLGET("SL_OPE","SL_OPE","V2",1,1,{},,.f.,BEZBLOK,,,,,,,.t.);
        vali SL("SL_OPE","SL_OPE","V2",1,1)
   set curs on;read;set curs off
   if lastkey()=K_ESC;break;endi

   loca for KOD==_op
 
   _nazwisko:=alltrim(NAZWA)

   if !empty(_gi)
      @19,0 say "Data/godzina importu do centrali: "+dtoc(_di)+;
                " "+_gi
   endi

   if !empty(_op)
      @19,col()+1 say "Operator: "+_op+" "+_nazwisko+"                     "
   endi

   CPClose(SL_OPE)

   sele 0
   if !_use("PROZAM","S"); BREAK; endi
   set index to PROZAM,PROZAM_I,PROZAM_S

   seek _nr_kon+dtos(_data_zam)+_sym_zam
   do while NR_KON+DTOS(DATA_ZAM)+SYMBOL_ZAM==_nr_kon+dtos(_data_zam)+_sym_zam
      RBLOK()
      repl OPERATOR with _op
      dbunlock()
      skip
   endd
endi

END SEQUENCE
close data

/*
if _p=2
  QPC(1)
  if !_use("PROZAM","E"); BREAK; endi
  pack
  inde on NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM to PROZAM
  inde on s_i(INDEKS)+NR_KON to PROZAM_I
  inde on DR(DATA_ZAM)+str(val(SYMBOL_ZAM),7)+NR_KON to PROZAM_S uniq
  QPC(0)
endi
*/
close data

dele file (_sc+"PROZAM_R.DBF")
RETURN NIL

*******************************************************************************
FUNCTION SYM_ZAM_OK()
local _r,_n,_ret:=.T.,_or:=PROZAM->(indexord())

BEGIN SEQUENCE
if _ktory_rekord>0
*  PRO_NR->(dbgoto( _ktory_rekord  ))
  dbgoto( _ktory_rekord  )
  _ktory_rekord:=0
else
  if "/"$_sym_zam
    _r:=min(9999,val(subs(_sym_zam,at("/",_sym_zam)+1)))
    if _r<2000; _r:=_r+2000; endi
    _r:=trans0(_r,4)
    _n:=str(val(_sym_zam),7)
    set order to 3
    if !dbseek(_r+_n)
      QPC(1); loca for SYMBOL_ZAM==_sym_zam; QPC(0)
      if !found(); _ret:=.F.; BREAK; endi
    endi
  else
    QPC(1); loca for SYMBOL_ZAM==_sym_zam; QPC(0)
    if !found(); _ret:=.F.; BREAK; endi
  endi
endi                                                                 //14.04.99
/*
_nr_kon:=PRO_NR->NR_KON
_data_zam:=PRO_NR->DATA_ZAM
_sym_zam:=PRO_NR->SYMBOL_ZAM
*/
_nr_kon:=NR_KON
_data_zam:=DATA_ZAM
_sym_zam:=SYMBOL_ZAM
for _i:=1 to len(GetList); GetList[_i]:display(); next 

END SEQUENCE
PROZAM->(dbsetorder(_or))
RETURN _ret

*******************************************************************************
FUNCTION V_MAG()
RETURN if("MAG"$EDIT->POLE,.f.,.t.)

*******************************************************************************
FUNCTION V_IL_ZREA()
RETURN if("ILOSC_ZRE"$EDIT->POLE,.f.,.t.)

*******************************************************************************
FUNCTION NOWY_IND()
local _tex:='۲  ZMIANA INDEKSU  ',_lr,_zb,;
      _ind_old:=spac(LENIN),_ind_new:=spac(LENIN)

cls
@ 0,0 say _tex

BEGIN SEQUENCE
@ 2,0 say 'Uwaga : Zamiana indeksu jest funkcj serwisow !'
@ 3,0 say '        Zakada si, e zamieniany indeks nie wystpuje w dokumentach'
@ 4,0 say '        tymczasowych (faktury i dokumenty w "zapisie").  Zamiana jest'
@ 5,0 say '        wykonywana w plikach  aktualnych oraz wstecznie we wszystkich'
@ 6,0 say '        dokumentach w okresie rozrachunkowym objtym programem.'
@ 7,0 say '        Przed wykonaniem zamiany zaleca si wykonanie archiwizacji danych.'


if !HA(_haslo); BREAK; endi

sele 0
if !_use("SL_MAG","R"); BREAK; endi
set index to SL_MAG

sele 0
if !_use("TOW","S"); BREAK; endi
set index to TOW_IN, TOW_NA, TOW_GR, TOW_SW

do while .t.
  @ 8,0 say "Indeks przed zmian :" get _ind_old pict _format_ind ;
      when SLGET("TOW","TOW","V1",1,1,{"indeks","nazwa","grupa",ORD4()},,.f.);
      vali EXIST(_ind_old,"TOW",1).and.SLGET()
  @ 9,0 say "Indeks po zamianie : " get _ind_new pict _format_ind ;
      when SLGET("TOW","TOW","V1",1,1,{"indeks","nazwa","grupa",ORD4()},,.f.);
      vali SLGET()
  set curs on; read; SLGET(); set curs off
  if lastkey()=K_ESC; BREAK; endi
 
  _ind_old:=s_i(_ind_old)
  _ind_new:=s_i(_ind_new)

  sele TOW
  seek _ind_new
  if found()
    QKE("Uwaga : Indeks "+_ind_new+" ju wystpuje w sowniku !")
    keyboard chr(K_ENTER)
    loop
  endi

  seek _ind_old
  if !found() 
    TOW->(dbunlock())
    QKE("Uwaga : Indeks "+_ind_old+" nie wystpuje w sowniku !")
    loop
  endi
  copy to (_sc+"IND_ROB") next 1
  set orde to 0

  FBLOK()
  appe from (_sc+"IND_ROB")
  repl INDEKS with _ind_new
  exit
endd

TOW->(dbsetorder(1))

sele SL_MAG
do while !eof()
  _nr_mag:=NR_MAG
  if !file("MAG"+_nr_mag+".DBF"); skip; loop; endi
  
  sele 0
  _zb:="DOK"+_nr_mag+"P.DBF"
  _use(_zb,"S!","DOKP")
  set inde to ("D"+_nr_mag+"P"+"_NR"),("D"+_nr_mag+"P"+"_DI")
  set order to 0
  _lr:=lastrec()
  @ 23,0
  @ 23,0 say "Zamiana w pliku "+_zb
  dbeval({|| RBLOK(),;
             if(s_i(DOKP->INDEKS)=_ind_old,DOKP->INDEKS:=_ind_new,NIL),;
             dbunlock(),;
             POKAZ(_lr)})
  @ 23,0
  close DOKP

  sele 0
  _zb:="MAG"+_nr_mag+".DBF"
  _use(_zb,"S!","MAG")
  set rela to s_i(INDEKS) into TOW 
  set index to ("M" + _nr_mag+"_IP"), ("M" + _nr_mag+"_N"),;
               ("M" + _nr_mag+"_IP0"),("M" + _nr_mag+"_N0")
  set order to 0
  _lr:=lastrec()
  @ 23,0
  @ 23,0 say "Zamiana w pliku "+_zb
  dbeval({|| RBLOK(),;
             if(s_i(MAG->INDEKS)=_ind_old,;
                       (TOW->(dbseek(_ind_old)),MAG->INDEKS:=_ind_new),NIL),;
             dbunlock(),;
             POKAZ(_lr)})

  @ 23,0
  close MAG

  sele 0
  _zb:="SP"+_nr_mag+".DBF"
  if file(_zb)
    _use(_zb,"S!","SP")
    set index to ("SP"+_nr_mag+"_I"), ("SP"+_nr_mag+"_N"),;
                 ("SP"+_nr_mag+"_A")
    set order to 0
    _lr:=lastrec()
    @ 23,0
    @ 23,0 say "Zamiana w pliku "+_zb
    dbeval({|| RBLOK(),;
               if(s_i(SP->INDEKS)=_ind_old,SP->INDEKS:=_ind_new,NIL),;
               dbunlock(),;
               POKAZ(_lr)})
    @ 23,0
    close SP
  endi

  sele SL_MAG
  skip
endd
clos SL_MAG

if file("KODY_PAS.DBF")

  sele 0
  _zb:="KODY_PAS.DBF"
  _use(_zb,"S!","KODY_PAS")
  set index to KODY_I, KODY_K
  set order to 0
  _lr:=lastrec()
  @ 23,0
  @ 23,0 say "Zamiana w pliku "+_zb
  dbeval({|| RBLOK(),;
         if(s_i(KODY_PAS->INDEKS)=_ind_old,KODY_PAS->INDEKS:=_ind_new,NIL),;
         dbunlock(),;
         POKAZ(_lr)})
  @ 23,0
  close KODY_PAS
endi

if _zestawy

  sele 0
  _zb:="ZES.DBF"
  _use(_zb,"S!","ZES")
  set index to ZES_I, ZES_E
  set order to 0
  _lr:=lastrec()
  @ 23,0
  @ 23,0 say "Zamiana w pliku "+_zb
  dbeval({|| RBLOK(),;
         if(s_i(ZES->INDEKS)=_ind_old,ZES->INDEKS:=_ind_new,NIL),;
         if(s_i(ZES->INDEKS_E)=_ind_old,ZES->INDEKS_E:=_ind_new,NIL),;
         dbunlock(),;
         POKAZ(_lr)})
  @ 23,0
  close ZES
endi

sele 0
_zb:="SPR_P.DBF"
_use(_zb,"S!","SPR_P")
set index to SPR_P_NR, SPR_P_DS
set order to 0
_lr:=lastrec()
@ 23,0
@ 23,0 say "Zamiana w pliku "+_zb
dbeval({|| RBLOK(),;
             if(s_i(SPR_P->INDEKS)=_ind_old,SPR_P->INDEKS:=_ind_new,NIL),;
             dbunlock(),;
             POKAZ(_lr)})
@ 23,0
close SPR_P

sele 0
_zb:="SPR_U.DBF"
_use(_zb,"S!","SPR_U")
set index to SPR_U_NR, SPR_U_DS
set order to 0
_lr:=lastrec()
@ 23,0
@ 23,0 say "Zamiana w pliku "+_zb
dbeval({|| RBLOK(),;
             if(s_i(SPR_U->INDEKS)=_ind_old,SPR_U->INDEKS:=_ind_new,NIL),;
             dbunlock(),;
             POKAZ(_lr)})
@ 23,0
close SPR_U

sele 0
_zb:="CENY.DBF"
_use(_zb,"S!","CENY")
set index to CENY_DA
set order to 0
_lr:=lastrec()
@ 23,0
@ 23,0 say "Zamiana w pliku "+_zb
dbeval({|| RBLOK(),;
             if(s_i(CENY->INDEKS)=_ind_old,CENY->INDEKS:=_ind_new,NIL),;
             dbunlock(),;
             POKAZ(_lr)})
@ 23,0
close CENY

sele 0
_zb:="UPUSTY.DBF"
_use(_zb,"S!","UPUSTY")
set index to UPUSTY_K, UPUSTY_T
set order to 0
_lr:=lastrec()
@ 23,0
@ 23,0 say "Zamiana w pliku "+_zb
dbeval({|| RBLOK(),;
             if(s_i(UPUSTY->INDEKS)=_ind_old,UPUSTY->INDEKS:=_ind_new,NIL),;
             dbunlock(),;
             POKAZ(_lr)})
@ 23,0
close UPUSTY

sele 0
_zb:="TOW_TXT.DBF"
_use(_zb,"S!","TOW_TXT")
set index to TOW_TXT
set order to 0
_lr:=lastrec()
@ 23,0
@ 23,0 say "Zamiana w pliku "+_zb
dbeval({|| RBLOK(),;
             if(s_i(TOW_TXT->INDEKS)=_ind_old,TOW_TXT->INDEKS:=_ind_new,NIL),;
             dbunlock(),;
             POKAZ(_lr)})
@ 23,0
close TOW_TXT

sele 0
_zb:="POTRZEBY.DBF"
_use(_zb,"S!","POTRZEBY")
set index to POT_K, POT_I
set order to 0
_lr:=lastrec()
@ 23,0
@ 23,0 say "Zamiana w pliku "+_zb
dbeval({|| RBLOK(),;
            if(s_i(POTRZEBY->INDEKS)=_ind_old,POTRZEBY->INDEKS:=_ind_new,NIL),;
             dbunlock(),;
             POKAZ(_lr)})
@ 23,0
close POTRZEBY

if !empty(subs(_wersja,62,1))

  sele 0
  _zb:="TOW_KAL.DBF"
  _use(_zb,"S!","TOW_KAL")
  set index to TKAL_IN, TKAL_NA
  set order to 0
  _lr:=lastrec()
  @ 23,0
  @ 23,0 say "Zamiana w pliku "+_zb
  dbeval({|| RBLOK(),;
            if(s_i(TOW_KAL->INDEKS)=_ind_old,TOW_KAL->INDEKS:=_ind_new,NIL),;
             dbunlock(),;
             POKAZ(_lr)})
  @ 23,0
  close TOW_KAL
endi

sele 0
_zb:="PROZAM.DBF"
_use(_zb,"S!","PROZAM")
set index to PROZAM,PROZAM_I,PROZAM_S
set order to 0
_lr:=lastrec()
@ 23,0
@ 23,0 say "Zamiana w pliku "+_zb
dbeval({|| RBLOK(),;
            if(s_i(PROZAM->INDEKS)=_ind_old,PROZAM->INDEKS:=_ind_new,NIL),;
             dbunlock(),;
             POKAZ(_lr)})
@ 23,0
close PROZAM

sele 0
_zb:="PRODOS.DBF"
_use(_zb,"S!","PRODOS")
set index to
set order to 0
_lr:=lastrec()
@ 23,0
@ 23,0 say "Zamiana w pliku "+_zb
dbeval({|| RBLOK(),;
            if(s_i(PRODOS->INDEKS)=_ind_old,PRODOS->INDEKS:=_ind_new,NIL),;
             dbunlock(),;
             POKAZ(_lr)})
@ 23,0
close PRODOS

sele TOW
dbseek(_ind_old)
RBLOK(); dbdelete(); dbunlock()
set order to 0
_lr:=lastrec()
@ 23,0
@ 23,0 say "Zamiana w pliku "+_zb
dbeval({|| RBLOK(),;
            if(s_i(TOW->INDEKS_Z)=_ind_old,TOW->INDEKS_Z:=_ind_new,NIL),;
            if(s_i(TOW->INDEKS_O)=_ind_old,TOW->INDEKS_O:=_ind_new,NIL),;
             dbunlock(),;
             POKAZ(_lr)})
clos TOW

QKE("Wykonano zamian indeksu "+_ind_old+" na "+_ind_new+" !")

END SEQUENCE
clos data
RETURN NIL

*******************************************************************************
FUNCTION POKAZ(n)
*DEFAULT i TO .T.
devpos(23,30)
devout(if(n>0,str(recn()/n*100,2),100)+" %")
RETURN .T.

*******************************************************************************
FUNCTION AUTO_ZAM(_ceny)
loca _tex:=;
'۲  REJESTRACJA ZAMWIENIA NA PODSTAWIE RAPORTU ASORTYMENTOWEGO  '
loca _kat:=spac(40),_uwagi:=spac(33)
priv _data_zam:=date(),_nr_kon:=spac(5),_nr_mag:=spac(3),_sym_zam:=spac(10)
priv _kat_rej:=spac(40)

cls
@ 0,0 say _tex

DEFAULT _ceny TO .f.

BEGIN SEQUENCE

sele 0
if !_use(_sc+"POZ_ZAM","E"); BREAK; endi
dele all for ILOSC=0
pack
if _ceny
  repl all CENA_SPR with min(999999,WART_NET/ILOSC)
else
  repl all CENA_SPR with 0
endi

_kat:=spac(40)
if file ("kat_rej.mem")
  restore from ("kat_rej") additive
  _kat:=padr(_kat_rej,40)
endi

@ 1,0 say "Katalog zamwienia :" get _kat pict "@!" ;
     vali DIR_EXIST(alltrim(_kat)).or.empty(_kat).or.;
               (right(alltrim(_kat),1)=="\".and.;
               DIR_EXIST(subs(alltrim(_kat),1,len(alltrim(_kat))-1)))
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

_kat_rej:=padr(_kat,40)
save to kat_rej all like _kat_rej

_kat:=alltrim(_kat)
if empty(_kat); _kat:="\"+curdir(); endi
if right(_kat,1)<>"\"; _kat+="\"; endi

sele 0
if empty(_gdzie_fir)
  if !_use("KON","R"); BREAK; endif
  set index to KON_NR, KON_NA, KON_NI, KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
                 (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi

sele 0
if !_use("SL_MAG","R"); BREAK; endi
set index to SL_MAG

sele 0
if !_use(_kat+"PROZAM","S"); BREAK; endi
set index to (_kat+"PROZAM"),(_kat+"PROZAM_I"),(_kat+"PROZAM_S")
copy stru to (_sc+"ZAM_TMP")

sele 0
_use(_sc+"ZAM_TMP","E!")

_data_zam:=date()
_nr_kon:=spac(5)
_nr_mag:=spac(3)

@ 2,0 say "Firma :" get _nr_kon pict "99999";
      when SLGET("KON","KON","V2|V_KONCES()",1,1,;
                   {"numer","nazwa","NIP","miasto i ulica"},,.f.,,,,0); 
      valid SZ().and.SL("KON","KON","V2|V_KONCES()",1,1).and.SLGET()
@ 2,15 say "Magazyn :" get _nr_mag pict "999" ;
      when SLGET("SL_MAG","SL_MAG","V1",1,1,{"magazyn"},,.f.);
      vali SZ().and.SL("SL_MAG","SL_MAG","V1",1,1).and.SLGET()
@ 2,30 say "Data :" get _data_zam vali _data_zam<=date()
_kol:=col()+2
set curs on; read; SLGET(); set curs off
if lastkey()=K_ESC; BREAK; endi

_sym_zam:= SYM_ZAM_DO(DR(_data_zam))
@ 3,0 say "Zamwienie :" get _sym_zam pict "@! "+repl("X",10);
      vali !EXIST(_nr_kon+dtos(_data_zam)+_sym_zam,"PROZAM",1)
@ 3,col()+2 say "Uwagi :" get _uwagi pict "@!"
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

close PROZAM

sele 0
if !_use("TOW","R"); BREAK; endi  
set index to TOW_IN


sele POZ_ZAM
go top
do while !eof()

  sele ZAM_TMP
  appe blan
  TOW->(dbseek(s_i(POZ_ZAM->INDEKS)))
  repl NR_KON   with _nr_kon,;
     DATA_ZAM   with _data_zam,;
     SYMBOL_ZAM with _sym_zam,;
     DATA_AKT   with date(),;
     INDEKS     with POZ_ZAM->INDEKS,;
     ILOSC_ZAM  with POZ_ZAM->ILOSC,;
     CENA       with POZ_ZAM->CENA_SPR,;
     NAZWA_TOW  with TOW->NAZWA_TOW,;
     UWAGI      with _uwagi

  sele POZ_ZAM
  skip
endd

sele ZAM_TMP
use

sele 0
if _use(_kat+"PROZAM","F")
  set index to (_kat+"PROZAM"),(_kat+"PROZAM_I"),(_kat+"PROZAM_S")
  appe from (_sc+"ZAM_TMP")
  QKE("Wykonano rejestracj zamwienia.")
else
  QKE("Wykonaj rejestracj zamwienia w pniejszym czasie !")
endi

END SEQUENCE
close data

RETURN NIL

*******************************************************************************
FUNCTION SKOK_DC()                                // skok do pola ceny sprzedy
RETURN subs(_wersja,16,1)="T".or.subs(_wersja,133,1)="S"

*******************************************************************************
FUNCTION TOW_WEGA(_nkon)
local _osel:=select(),_ktxt,_at,_nlines,i,_komunikat:="",;
      _w146:=subs(_wersja,146,1),_ctow:=SPR_P_R->NAZWA_TOW

if  !subs(_ctow,_len_naz,1) == _w146 
  RETURN NIL
endi

BEGIN SEQUENCE

sele 0  
if !_use("TOW_TXT","R","TOW_WEGA"); BREAK;endif
set index to TOW_TXT

if dbseek( s_i(SPR_P_R->INDEKS))
    _ktxt:=TOW_WEGA->TEKST
  _nlines:=MLCount(_ktxt,74)
  for i:=1 to _nlines
    _linia:=MemoLine(_ktxt,74,i)
    if  (_at:=AT("@@",_linia))>0
      _komunikat:=alltrim(subs(_linia,_at+2))
      tone(880,1)
      QKE(_komunikat)
      BREAK
    endi
  next
endi
END SEQUENCE
Cpclose(TOW_WEGA)
sele (_osel)
RETU NIL

*******************************************************************************
FUNCTION V_ETYK(_cen_et)
local pom,_ret:=.t.

if "CENA_"$EDIT->POLE 
  pom:=subs(EDIT->POLE,6,1)
  if isdigit(pom).and. !val(pom)=_cen_et
    _ret:=.f.
  endi
endif
RETU _ret
*******************************************************************************
FUNCTION ODBLOKUJ(_sss,_nrz)
local _sel:=select(),_rn:=recno(),_kk:=""

BEGIN SEQUENCE
sele 0
_use("BLOKADY","S!")
set inde to BLOK_IN,BLOK_PO,BLOK_NR
set order to 3

loca for _sss==subs(UWAGI,12,4)+subs(UWAGI,6,5)
if found()
   do while !eof().and.subs(UWAGI,12,4)+subs(UWAGI,6,5)==_sss
      if UWAGI="|zam|"
         _kk:=s_i(INDEKS)+if(_rozchody="2",dtos(DATA_DOS),"")+s_c(CENA_ZAK)
         if NR_MAG==_nr_mag
            if MAG->(dbseek(_kk))
               MAG->(rblok())
               repl MAG->STAN_B with max(MAG->STAN_B-ILOSC,0)
               MAG->(dbunlock())
            endi
         else
            sele 0
            _use("MAG"+BLOKADY->NR_MAG,"S!","MAGZAM")
            set inde to ("M"+BLOKADY->NR_MAG+"_IP")
            if MAGZAM->(dbseek(_kk))
               MAGZAM->(rblok())
               repl MAGZAM->STAN_B with max(MAGZAM->STAN_B-BLOKADY->ILOSC,0)
               MAGZAM->(dbunlock())
            endi
            CPClose(MAGZAM)
            sele BLOKADY 
         endi
         _blok_zam:=.t.
         _nr_bzam:=_nrz
         rblok()
         dbdelete()
      endi
      skip
   endd
endi

END SEQUENCE
CPClose(BLOKADY)
sele (_sel)
goto (_rn)
RETU NIL
*******************************************************************************
FUNCTION ZABLOKUJ()
local _sel:=select(),_rn:=recno(),_kk:="",_nr:="",_zp:=.f.

BEGIN SEQUENCE
sele 0
_use("BLOKADY","S!")
set inde to BLOK_IN,BLOK_PO,BLOK_NR

if select("PROZAM")=0
   sele 0
   _use("PROZAM","S!")
   set inde to PROZAM
   _zp:=.t.
else
   sele select("PROZAM")
endi

go top
_nr:= NR_BLO_DOM()

dbseek(_nr_bzam)

do while !eof().and._nr_bzam=NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM
   _ile:=ILOSC_ZAM-ILOSC_ZRE
   if MAG->(dbseek(s_i(PROZAM->INDEKS)))
      do while !MAG->(eof()).and.;
               s_i(PROZAM->INDEKS)==s_i(MAG->INDEKS).and.;
               _ile>0
         if MAG->(STAN-STAN_B)>0
  
            MAG->(rblok())
            _ii:=min(_ile,MAG->(STAN-STAN_B))
            repl MAG->STAN_B with min(MAG->STAN,MAG->STAN_B+_ile)
            _ile:=_ile-_ii
 
            MAG->(dbunlock())
     
            BLOKADY->(appe_blok())
            repl BLOKADY->STATUS with "B",;
                 BLOKADY->NR_MAG with _nr_mag ,;
                 BLOKADY->INDEKS with MAG->INDEKS,;
                 BLOKADY->CENA_ZAK with MAG->CENA_ZAK,;
                 BLOKADY->DATA_DOS with MAG->DATA_DOS,;
                 BLOKADY->ILOSC with _ii,;
                 BLOKADY->UWAGI with "|zam|"+alltrim(SYMBOL_ZAM),;
                 BLOKADY->DATA with DATA_ZAM,;
                 BLOKADY->NR_KON with NR_KON,;
                 BLOKADY->OPERATOR with _operator,;
                 BLOKADY->NR_BLO with _nr
                 BLOKADY->(dbunlock())
         endi
         MAG->(dbskip())
      endd
   endi         
   PROZAM->(rblok())
   repl PROZAM->NR_BLO with DR(DATA_ZAM)+_nr
   PROZAM->(dbunlock())
   skip
endd                   

END SEQUENCE
CPClose(BLOKADY)
if _zp
   CPClose(PROZAM)
endi
sele (_sel)
goto (_rn)
RETU NIL
*******************************************************************************
FUNCTION RAPORT_BRAK(_fis)
local _lk:=lastkey(),_sel:=select(),_re:=recno(),_gora:=if(_fis,3,8),;
      _dol:=21-if(Eval(memvarblock("_ceny_"+_nr_cen_spr))="B",1,0),_ekran

if chr(_lk)$"Rr"
   loca for ILOSC_MAG<ILOSC.or.;
            ILOSC_MAG<ILOSC_ZAM-ILOSC_ZRE

   if !found()
      QKE("Wszystkie pozycje mog by zrealizowane !")
      go (_re)
      RETU NIL
   endi
   
   copy to (_sc+"BRAKIZAM") for ILOSC_MAG<ILOSC.or.;
                                ILOSC_MAG<ILOSC_ZAM-ILOSC_ZRE
   sele 0
   _use(_sc+"BRAKIZAM","E!")

   _ekran:=savescreen(_gora,0,_dol+1,79) 

   SET(_SET_COLOR,_ekra_blo)
   @ _dol+1,0

   CPEDIT      POZ: _gora,,_dol,;
               DEF: "PROODB"     ;
               POZWER: "V3"      ;
               PION: ,,,         ;
               INDEXY: {}        ;
               EDYCJA: .f.       ;
               ODTWORZ: .f.       

   go top
   CPDRUK  DEF: "PROODB"                 ;
           WERSJA: "V3"              ;
           TYTUL: "BRAKUJCE POZYCJE ZAMWIENIA" ;
           WARIANT: 39

   CPClose(BRAKIZAM)
   
   sele (_sel)
   go (_re)

   restscreen(_gora,0,_dol+1,79,_ekran)
   SET(_SET_COLOR,_slow_blo)
   
 endi

RETU NIL

********************************************************************************
FUNCTION POZ_ZAM()  //
local _lk:=lastkey(),_astru:={},_osele:=select(),_rekord
local _adir:={}, _i,apom:={}, _j:=PROZAM->(fcount()) ,;
      _pord:=PROZAM->(indexord()),_klucz:=""

BEGIN SEQUENCE
if _lk=K_ENTER

  _osele:=select()
  _rekord:=recn()
  _astru:={}
  aadd(_astru,{"INDEKS"     ,"C",LENIN, 0})
  aadd(_astru,{"NAZWA_TOW"  ,"C",max(40,_len_naz), 0})      
  aadd(_astru,{"ILOSC_ZAM"   ,"N",12, 3})
  aadd(_astru,{"ILOSC_ZRE"   ,"N",12, 2})
  dbcreate ((_sc+"CO_ZAM"),_astru)

  for _i:=1 to _j
    aadd(apom,_i)
  next

  
  sele 0
  if !_use(_sc+"CO_ZAM","E"); BREAK; endi
  
  sele PROZAM
  dbsetorder(1)
  _klucz:=POZ_ZAM->(NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM)
  dbseek(_klucz)
  dbeval({|| POLCOPY(PROZAM,CO_ZAM)},,;
         {|| NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM==_klucz})

  sele CO_ZAM
  go top
  CPEDIT  POZ: 7,2,20, ;
          DEF: "PROZAM"                 ;
          POZWER: "V5"                 ;
          PION: ,,,
  PROZAM->(dbsetorder(_pord))

endif
END SEQUENCE
CPClose(CO_ZAM)

sele (_osele)
RETU NIL

*******************************************************************************
FUNCTION NAG_ZAM_MI(_kon_nr,_kon_id,_kon_a,_kon_m,_kon_k,;           //12.05.06
                    _kon_n,_kon_n2,_uwagi,_sym_zam,_data_zam)
local _mf

_mf:=_miasto_fir+dtoc(date())
devpos(prow(),0);devout(padc(alltrim(_pieczat1) ,45))
devpos(prow(),rmarg-len(_mf));devout(_mf)
devpos(prow()+1,0);devout(padc(alltrim(_pieczat2) ,45))
* devpos(prow()+1,0);devout(padc(alltrim(_pieczat3) ,45))
devpos(prow()+2,int(rmarg/2)-40)
devout(SZERx2+SZER("ZAMWIENIE Nr "+alltrim(_sym_zam))+;
         " z dnia "+dtoc(_data_zam)+SZERx1)

devpos(prow()+2,0);        devout("Nabywca :  "+rtrim(_kon_n))
if !empty(_kon_n2)
  devpos(prow()+1,11);     devout(alltrim(_kon_n2))
endif

devpos(prow()+1,11);       devout(if(empty(_kon_k),"",_kon_k+" ")+;
                           alltrim(_kon_m)+", "+_kon_a)
if !empty(_kon_nr) 
  devpos(prow()+1,0); devout("Nr FK : "+alltrim(_kon_nr))
endi

if !empty(_uwagi) 
  devpos(prow()+1,0);   devout("Uwagi : "+_uwagi)
endi

RETURN NIL

******************************************************************************
FUNCTION STO_PRO_MI()                                               //12.05.06
local j:=0,i,_txt:=""
@ prow()+1,int((rmarg-97)/2) say "Zamwienie przyj :                                            Przygotowa do realizacji :"
@ prow()+2,int((rmarg-97)/2) say "..........................                                      .............................."
@ prow()+1,int((rmarg-97)/2) say "Data : ...................                                      Data : ......................."
  
@ prow()+1,0 say ""
_txt:=PROMEM->OPIS
for i:=1 to mlcount(_txt,76)
  @ prow()+1,0 say BOLD_ON+alltrim(memoline(_txt,76,i))+BOLD_OFF
next

RETURN NIL

*******************************************************************************
FUNCTION STAN_MI()                                                   //12.05.06
local _ind:=s_i(INDEKS),_stan:=0,_recm:=MAG->(recno()),_sel:=select()

sele MAG
seek (_ind)
if found()
  sum STAN to _stan while !eof().and.s_i(INDEKS)=_ind
endi
dbgoto(_recm)

sele (_sel)
RETURN _stan

*******************************************************************************
FUNCTION DRU_ZAM_MI(_uwagi,_sym_zam,_nr_kon,_data_zam)               //12.05.06
local _se:=sele()

set rela to s_i(INDEKS) into TOW
KON->(dbseek(_nr_kon))

CPDRUK DEF: "PRO_MI"             ;
            WERSJA: "V1"           ;
            NAGLOWEK :NAG_ZAM_MI(KON->NR_KON, KON->ID_KON, KON->ADRES,;
                                 KON->MIASTO, KON->KOD, KON->NAZWA_KON,;
                                 KON->NAZWA_KON2,;
                                 _uwagi,_sym_zam,_data_zam);
            STOPKA: STO_PRO_MI() ; 
            WARIANT: 49

sele (_se)

RETURN NIL

******************************************************************************
FUNCTION UPU_ZAM()
local  _spacgru:=if(subs(_wersja,81,1)=="G",spac(3),spac(2)),;
       _zerogru:=if(subs(_wersja,81,1)=="G","000","00")
local _rabat:=0,_rabatmax:=0,_cena:=0

if subs(_wersja,16,1)$"RU".and.select("UPUSTY")>0
// 1.  indeks z podan cen dla kontrahenta wskazanego,"
  if UPUSTY->(dbseek(PROZAM->NR_KON+_spacgru+PROZAM->INDEKS));
               .and.UPUSTY->CENA>0.and.DATA_PROM()
    _cena:=UPUSTY->CENA
    repl PROZAM->CENA with _cena,PROZAM->RABAT with 0
// 2.  indeks z podan cen dla kontrahenta oglnego o numerze 00000,"
  elseif UPUSTY->(dbseek("00000"+_spacgru+PROZAM->INDEKS));
               .and.UPUSTY->CENA>0.and.DATA_PROM()
    _cena:=UPUSTY->CENA
    repl PROZAM->CENA with _cena,PROZAM->RABAT with 0
// 3.  grupa z podan cen dla kontrahenta wskazanego,"
  elseif !empty(TOW->GRUPA_TOW).and.; 
           UPUSTY->(dbseek(PROZAM->NR_KON+TOW->GRUPA_TOW+space(LENIN))).and.DATA_PROM();
                 .and.UPUSTY->CENA>0
    _cena:=UPUSTY->CENA
    repl PROZAM->CENA with _cena,PROZAM->RABAT with 0
// 4.  grupa z podan cen dla kontrahenta oglnego o numerze 00000,"
  elseif !empty(TOW->GRUPA_TOW).and.; 
           UPUSTY->(dbseek("00000"+TOW->GRUPA_TOW+space(LENIN))).and.DATA_PROM();
                 .and.UPUSTY->CENA>0
    _cena:=UPUSTY->CENA
    repl PROZAM->CENA with _cena,PROZAM->RABAT with 0
    *--- koniec cen -----------------------------------------------------------
  else
    if empty(subs(_wersja,190,1))  // dotychczasowy wariant - pierwszy napotkany rabat
// 5.  indeks z upustem dla kontrahenta wskazanego,"
      if UPUSTY->(dbseek(PROZAM->NR_KON+_spacgru+PROZAM->INDEKS)).and.DATA_PROM()
        _rabat:=UPUSTY->UPUST        

//  6.  indeks z upustem dla kontrahenta oglnego o numerze 00000,"
      elseif UPUSTY->(dbseek("00000"+_spacgru+PROZAM->INDEKS)).and.DATA_PROM()
        _rabat:=UPUSTY->UPUST        

    *----------------------------------------------------------------- 06.08.04
// 7.  szablon indeksu z upustem dla kontrahenta wskazanego,"
      elseif _znaki_upu>0.and.UPUSTY->(dbseek(PROZAM->NR_KON+_spacgru+;
                                       subs(PROZAM->INDEKS,1,_znaki_upu)));
                       .and.len(rtrim(UPUSTY->INDEKS))=_znaki_upu.and.DATA_PROM()
        _rabat:=UPUSTY->UPUST        

// 8.  szablon indeksu z upustem dla kontrahenta oglnego o numerze 00000,"
      elseif _znaki_upu>0.and.UPUSTY->(dbseek("00000"+_spacgru+;
                                       subs(PROZAM->INDEKS,1,_znaki_upu)));
                       .and.len(rtrim(UPUSTY->INDEKS))=_znaki_upu.and.DATA_PROM()
        _rabat:=UPUSTY->UPUST        

// 9.  grupa towarowa z upustem dla kontrahenta wskazanego,"
      elseif !empty(TOW->GRUPA_TOW).and.;                //07.09.04
            UPUSTY->(dbseek(PROZAM->NR_KON+TOW->GRUPA_TOW+space(LENIN))).and.DATA_PROM()
        _rabat:=UPUSTY->UPUST        

// 10. grupa towarowa z upustem dla kontrahenta oglnego o numerze 00000,"
      elseif !empty(TOW->GRUPA_TOW).and.;
           UPUSTY->(dbseek("00000"+TOW->GRUPA_TOW+space(LENIN))).and.DATA_PROM()
        _rabat:=UPUSTY->UPUST        

*-----------------------------------------------------  07.09.04
// 11. upust na towary wskazanego dostawcy dla wskazanego kontrahenta, "
      elseif UPUSTY->(dbseek(PROZAM->NR_KON+_spacgru+space(LENIN)+TOW->NR_KON));
          .and.!empty(TOW->NR_KON).and.DATA_PROM()
        _rabat:=UPUSTY->UPUST        

// 12. upust na towary wskazanego dostawcy dla kontrahenta oglnego nr 00000,"
      elseif UPUSTY->(dbseek("00000"+_spacgru+space(LENIN)+TOW->NR_KON));
          .and.!empty(TOW->NR_KON).and.DATA_PROM()
        _rabat:=UPUSTY->UPUST        
*-------------------------------------------------------------------------

//  13. grupa towarowa oglna 00 dla indywidualnego kontrahenta."
      elseif UPUSTY->(dbseek(PROZAM->NR_KON+_zerogru)).and.DATA_PROM()    //11.04.03
        _rabat:=UPUSTY->UPUST        
      endi
      if _rabat<>0
        repl PROZAM->RABAT with _rabat
      endi    
    else
// 5.  indeks z upustem dla kontrahenta wskazanego,"
      if UPUSTY->(dbseek(PROZAM->NR_KON+_spacgru+PROZAM->INDEKS)).and.DATA_PROM()
        _rabatmax:=max(_rabatmax,UPUSTY->UPUST)        
      endi
//  6.  indeks z upustem dla kontrahenta oglnego o numerze 00000,"
      if UPUSTY->(dbseek("00000"+_spacgru+PROZAM->INDEKS)).and.DATA_PROM()
        _rabatmax:=max(_rabatmax,UPUSTY->UPUST)        
      endi
    *----------------------------------------------------------------- 06.08.04
// 7.  szablon indeksu z upustem dla kontrahenta wskazanego,"
      if _znaki_upu>0.and.UPUSTY->(dbseek(PROZAM->NR_KON+_spacgru+;
                                       subs(PROZAM->INDEKS,1,_znaki_upu)));
                       .and.len(rtrim(UPUSTY->INDEKS))=_znaki_upu.and.DATA_PROM()
        _rabatmax:=max(_rabatmax,UPUSTY->UPUST)        
      endi
// 8.  szablon indeksu z upustem dla kontrahenta oglnego o numerze 00000,"
      if _znaki_upu>0.and.UPUSTY->(dbseek("00000"+_spacgru+;
                                       subs(PROZAM->INDEKS,1,_znaki_upu)));
                       .and.len(rtrim(UPUSTY->INDEKS))=_znaki_upu.and.DATA_PROM()
        _rabatmax:=max(_rabatmax,UPUSTY->UPUST)        
      endi 
// 9.  grupa towarowa z upustem dla kontrahenta wskazanego,"
      if !empty(TOW->GRUPA_TOW).and.;                //07.09.04
            UPUSTY->(dbseek(PROZAM->NR_KON+TOW->GRUPA_TOW+space(LENIN))).and.DATA_PROM()
        _rabatmax:=max(_rabatmax,UPUSTY->UPUST)        
      endi
// 10. grupa towarowa z upustem dla kontrahenta oglnego o numerze 00000,"
      if !empty(TOW->GRUPA_TOW).and.;
           UPUSTY->(dbseek("00000"+TOW->GRUPA_TOW+space(LENIN))).and.DATA_PROM()
        _rabatmax:=max(_rabatmax,UPUSTY->UPUST)        
      endi
*-----------------------------------------------------  07.09.04
// 11. upust na towary wskazanego dostawcy dla wskazanego kontrahenta, "
      if UPUSTY->(dbseek(PROZAM->NR_KON+_spacgru+space(LENIN)+TOW->NR_KON));
          .and.!empty(TOW->NR_KON).and.DATA_PROM()
        _rabatmax:=max(_rabatmax,UPUSTY->UPUST)        
      endi
// 12. upust na towary wskazanego dostawcy dla kontrahenta oglnego nr 00000,"
      if UPUSTY->(dbseek("00000"+_spacgru+space(LENIN)+TOW->NR_KON));
          .and.!empty(TOW->NR_KON).and.DATA_PROM()
        _rabatmax:=max(_rabatmax,UPUSTY->UPUST)        
      endi
*-------------------------------------------------------------------------

//  13. grupa towarowa oglna 00 dla indywidualnego kontrahenta."
      if UPUSTY->(dbseek(PROZAM->NR_KON+_zerogru)).and.DATA_PROM()    //11.04.03
        _rabatmax:=max(_rabatmax,UPUSTY->UPUST)        
      endi
      if _rabatmax>0
        repl PROZAM->RABAT with _rabatmax
      endi    
    endi
  endi  
endi
RETURN NIL

*******************************************************************************
FUNCTION CZY_ZESTAW()
local _ret:=.f.
ZES->(dbseek(s_i(ROBKOM->INDEKS)))
ZES->(dbeval({|| if(ILOSC>0,_ret:=.t.,NIL)},,{||ZES->INDEKS==ROBKOM->INDEKS}))
if !_ret
  QKE("To nie jest zestaw!")
endi
RETURN _ret

*******************************************************************************
FUNCTION DSTA_ROZ()                                                  //29.11.01
local _astru:={},_winien:=0, _sel:=select(),_nr_kon:=spac(5),_na_kon:=""
local _ekran:=savescreen(5,0,24,79)

BEGIN SEQUENCE

  @ 5,0 clea to 24,79

  sele 0
  if !_use(_sc+"SPR_N_R","R","AKT_FAK"); BREAK; endi
  _nr_kon:=NR_KON
  _na_kon:=alltrim(NAZWA_KON)
  use

  _astru:={}
  aadd(_astru,{"RODZAJ_DOK" ,"C",2, 0})      
  aadd(_astru,{"SERIA_FAK"  ,"C",2, 1})      
  aadd(_astru,{"ROK_DOK"    ,"C",4, 1})      
  aadd(_astru,{"NR_DOK"     ,"C",5, 1})      
  aadd(_astru,{"DATA_DOK"   ,"D",8, 0})      
  aadd(_astru,{"WART_ZAP"   ,"N",12,2})      
  aadd(_astru,{"WN"         ,"N",12,2})      
  aadd(_astru,{"DATA_PLA"   ,"D",8, 0})      
  aadd(_astru,{"DNI"        ,"N",6, 0})      
  dbcreate (_sc+"STA_ROZ",_astru)
 
  sele 0
  _use(_sc+"STA_ROZ","E!")
  index on DATA_DOK to (_sc+"STA_ROZ")

  sele 0
  if !_use("SPR_N","R","ROZ_FAK"); BREAK; endi 
  set index to SPR_N_KO
  dbseek(_nr_kon)
  _winien:=0
  do while !eof().and.NR_KON==_nr_kon
    if WN=0.or.RODZAJ_DOK<>"F"; skip; loop; endi
  
    sele STA_ROZ
    appe blan
    STA_ROZ->RODZAJ_DOK:=ROZ_FAK->RODZAJ_DOK
    STA_ROZ->SERIA_FAK:=ROZ_FAK->SERIA_FAK
    STA_ROZ->ROK_DOK:=ROZ_FAK->ROK_DOK
    STA_ROZ->NR_DOK:=ROZ_FAK->NR_DOK
    STA_ROZ->DATA_DOK:=ROZ_FAK->DATA_DOK
    STA_ROZ->WART_ZAP:=ROZ_FAK->WART_ZAP
    STA_ROZ->WN:=ROZ_FAK->WN
    STA_ROZ->DATA_PLA:=ROZ_FAK->DATA_PLA
    STA_ROZ->DNI:=max(0,date()-ROZ_FAK->DATA_PLA)
    _winien+=ROZ_FAK->WN

    sele ROZ_FAK
    skip
  endd
  close ROZ_FAK

  sele STA_ROZ
  if lastrec()=0
    QKE("Brak faktur nierozliczonych.")
    BREAK
  endi

  @ 5,0 say "STAN ROZRACHUNKW ZA FAKTURY (BEZ NOT) :"
  go top  
  CPEDIT POZ: 6,,22,               ;
         DEF: "STA_ROZ"            ;
         POZWER: "V1"              ;
         PION: ,,,                 ;
         INDEXY: {"data"}          ;
         EDYCJA: .F.               ;
         ODTWORZ:.F.
  go top
  CPDRUK DEF: "STA_ROZ"            ;
         WERSJA: "V1"              ;
         WARIANT: 19               ;
         TYTUL : "STAN ROZRACHUNKW ZA FAKTURY w dniu : "+dtoc(date()) ;
         STOPKA: STO_ROZ(_winien)  ;    
         OPERATOR: _operator

END SEQUENCE

CPClose(AKT_FAK)
CPClose(STA_ROZ)
CPClose(ROZ_FAK)

sele (_sel)
restscreen(5,0,24,79,_ekran)
dele file (_sc+"STA_ROZ.DBF")
dele file (_sc+"STA_ROZ.NTX")

RETURN NIL

*******************************************************************************
FUNCTION STO_ROZ(_w)
@ prow(), WN stop_sayr transform(_w,_foramt_war)
RETURN NIL

*******************************************************************************
FUNCTION CASE_CO(_co,_rodz_dok,_wyr_fa,_fakkau,_nr_fir)              //09.12.06
local _eekran
do case
  case _co="KAU"
    DKAU(_rodz_dok)
  case _co="DOK_KAU"
    UTKAU()
    _eekran:=savescreen(0,0,24,79)
    WY_KAU(_wyr_fa)
    restscreen(0,0,24,79,_eekran)

  case _co="FAK_KAU"
    _eekran:=savescreen(7,0,24,79)
    FAK_KAU()
    restscreen(7,0,24,79,_eekran)
    _fakkau:=.t.
    BREAK

  case _co="SEK"  // specyfikacja wg sektorw
    _eekran:=savescreen(7,0,24,79)
    DSEK()
    restscreen(7,0,24,79,_eekran)

  case _co="STA_ROZ"  // stan rozrachunkow                     
    _eekran:=savescreen(7,0,24,79)
    DSTA_ROZ()
    restscreen(7,0,24,79,_eekran)

  case _co="ROZ_OPA" // rozliczenie opakowan                   
    _eekran:=savescreen(0,0,24,79)
    ZOPA_N2(_nr_fir)
    restscreen(0,0,24,79,_eekran)
endc
RETURN NIL

*******************************************************************************
FUNCTION CASE_CO2(_co,_rodz_dok,_nr_fir)                             //09.12.06
do case
  case _co=="SPEC.OP."
    DKAU(_rodz_dok)
  case _co=="SEKT."
    DSEK()
  case _co=="POTW.WP."
    KP_TEMP()
  case _co=="SPEC.EAN"     
    DSKP()
  case _co=="OPAK."        
    ZOPA_N2(_nr_fir)
  case _co=="ROZR."        
    DSTA_ROZ()
endc
RETURN NIL

*******************************************************************************
**********************************   ZEBRA     ********************************
*******************************************************************************
FUNCTION ZEBRA_ET()                                                  //27.10.13
loca _tex:='۲  WYDRUK ETYKIET Z KODAMI EAN NA DRUKARCE ZEBRA  ',;
     _rok:=year(date()),_mag:=_magazyn
local _astru:={},_i,_lcen,_licznik:=1
local prevhandler:=errorblock()

priv _selekcja:=1,apom:={},_war, _bwar

priv _cen_et1:=1,_opi_et1:=padr("Cena  ",12),_typ_et1:="N",;
     _cen_et2:=2,_opi_et2:=padr("Cena 2",12),_typ_et2:="B",_por_et1:="LPT2",;
     _len_opi:=0

priv _szab_i:= transform(spac(LENIN),_format_ind),_szab_n:= spac(_len_naz),;
     _gru_tow:=if(subs(_wersja,81,1)=="G",spac(3),spac(2)),;
     _dok:="  -     /"+_mag+"/"+str(year(date()),4),;
     _st_mag:=_magazyn,_dostawca:=spac(5),_niezerowe:=1

cls
@ 0,0 say _tex

BEGIN SEQUENCE

if file("ZEBRA.MEM")
  restore from ZEBRA.MEM additive
  _opi_et1:=padr(_opi_et1,20)
  _opi_et2:=padr(_opi_et2,20)
  _por_et1:=padr(_por_et1,4)
endi

_por_et1:=padr(_por_et1,4)
_pl_et:="LAT"

@ 2,0 say "Drukarki ZEBRA EPL, np. ZDesigner GC420d (EPL) :"  //15.04.18 BAFPOL
@ 3,0 say "LPT1 do LPT4 -  dla wejcia i kabla Centronics,"
@ 4,0 say "USB - dla wejcia i kabla USB, w konfiguracji nazwa drukarki po instalacji."

@ 1,0 say "Port :" get _por_et1 pict "@!";                           //15.04.18
          vali alltrim(_por_et1)$"LPT1,LPT2,LPT3,LPT4,USB".or.empty(_por_et1)
/*
@ 2,0 say "Cennik   :" get _cen_et1 pict "@Z 9" vali str(_cen_et1,1)$_cenniki
*/

set curs on; read; set curs off
@ 2,0 clear to 4,79                                           //15.04.18 BAFPOL

if lastkey()=K_ESC; close data; BREAK; endi
_por_et1:=alltrim(_por_et1)

/*
if _cen_et1>0 
  @ 2,14 say "Opis   :" get _opi_et1 pict repl("X",12)
  @ 2,col()+2 say "Typ   :" get _typ_et1 pict "@! A" vali _typ_et1$"NB"
endi
@ 3,0 say "Cennik 2 :" get _cen_et2 pict "@Z 9" valid str(_cen_et2,1)$_cenniki
@ 3,col()+2 say "Opis 2 :" get _opi_et2 pict repl("X",12)
@ 3,col()+2 say "Typ 2 :" get _typ_et2 pict "@! A" vali _typ_et2$"NB"
set curs on; read; set curs off
if lastkey()=K_ESC; close data; BREAK; endi
*/

save to ZEBRA all like _???_et?

_opi_et1:=alltrim(_opi_et1)
_opi_et2:=alltrim(_opi_et2)

_len_opi:=max(len(rtrim(_opi_et1)),len(rtrim(_opi_et2)))
_opi_et1:=padr(_opi_et1,_len_opi)
_opi_et2:=padr(_opi_et2,_len_opi)

if !_use("TOW","R"); BREAK; endi
set index to TOW_IN, TOW_NA, TOW_GR, TOW_SW
apom:={}
for _i:=1 to fcount()
 aadd(apom,_i)
next

@ 4,0 clea to 4,50

sele 0
if empty(_gdzie_fir)
  if !_use("KON","S"); BREAK; endi
  set index to KON_NR, KON_NA, KON_NI, KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","S","KON"); BREAK; endi
  set index to (_gdzie_fir+"FIRMY_NR"), (_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"), (_gdzie_fir+"FIRMY_AD")
endi

sele 0
if !_use("SL_G_TOW","R"); BREAK; endif 
set index to SL_G_TOW, SL_G_TON

sele 0
if !_use("SL_DOK","R"); BREAK; endi
set index to SL_DOK

sele 0
if !_use("SL_MAG","R"); BREAK; endi
set index to SL_MAG

_selekcja:=(HorizMenu(4-2,0,"Selekcja towarw :",;
                      {"DOKUMENT","KRYTERIA","PLIK"},1))      //25.11.13 BAFPOL
@ 4-2,0
if _selekcja=1
   @ 4-2,0 say "Dokument :"
  _dok:=DAJ_DOK(4-2,11)

elseif _selekcja=2

  @ 4-2,0 say "Szablon indeksu : " get _szab_i pict _format_ind; 
      when SLGET("TOW","TOW","V1",1,1,{"indeks","nazwa","grupa",ORD4()},,.f.);
      vali SLGET()

  @ 4-2,col()+3 say "Grupa towarowa :  " get _gru_tow pict ;
                          if(subs(_wersja,81,1)=="G","999","99");
      when SLGET("SL_G_TOW","GTOW","V1",1,1,{"grupa","nazwa"},,.f.,BEZBLOK);
      valid (empty(_gru_tow).or.(SZ().and.SL("SL_G_TOW","GMAG","V1",1,1)));
            .and. SLGET()
 
  @ 4-2,col()+3 say "Dostawca : " get _dostawca pict "99999";
      when SLGET("KON","KON","V2|V_KONCES()",1,1,;
                 {"numer","nazwa","NIP","miasto i ulica"},,.f.,,,,0); 
      vali (empty(_dostawca).or.SZ().and.SL("KON","KON","V2|V_KONCES()",1,1));
           .and.SLGET()

  @ 5-2,0 say "Szablon nazwy :   " get _szab_n pict repl("!",_len_naz)

  @ 6-2,0 say "Stan w magazynie :" get _st_mag pict "999" ;
        when SLGET("SL_MAG","SL_MAG","V1",1,1,{"magazyn"},,.f.);
        vali SZ().and.SL("SL_MAG","SL_MAG","V1",1,1).and.SLGET()

  set curs on; read; set curs off
  if lastkey()=K_ESC; close data; BREAK; endi

elseif _selekcja=3
  if !file("DRUK_PAS.DBF")
    QKE("Brak pliku DRUK_PAS.DBF !")
    BREAK
  endi
endi

_mag:=subs(_dok,10,3)
_rok:=subs(_dok,14,4)

if " "$_dok.and._selekcja<>3                                         //25.11.13
  _niezerowe:=HorizMenu(6-2,29,"Tylko stany niezerowe ? :",{"TAK","NIE"},1)
else
  _niezerowe:=2
endi

CPClose(SL_MAG)
CPClose(SL_G_TOW)
CPClose(KON)

QPC(1)

_war:=".t."  

sele 0
if !_use("MAG"+_st_mag,"R","MAG"); BREAK; endif
set index to ("M"+_st_mag+"_IP0")

if !" "$_dok.and._selekcja=1                                  //25.11.13 BAFPOL
  
   sele 0
   if !_use("DOK"+_mag+"P","R"); BREAK; endif
   set index to ("D"+_mag+"P_NR")         // RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK
   seek subs(_dok,1,2)+_mag+_rok+subs(_dok,4,5)
   copy to (_sc+"TT") fields INDEKS,ILOSC ;
   while RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK ==;
         subs(_dok,1,2)+_mag+_rok+subs(_dok,4,5)

   _use(_sc+"TT","E!")
   index on s_i(INDEKS) to (_sc+"TT")
  _war:=_war+".and.!empty(TT->INDEKS)"
endi

if _selekcja=2

  if !_szab_i=transform(spac(LENIN),_format_ind)
    _war=_war+".and.(COMP(s_i(INDEKS),_szab_i))"
  endif

  if !empty(_dostawca)
    _war=_war+".and.NR_KON==_dostawca"
  endi

  if !empty(_szab_n)
    if " "=subs(_szab_n,1,1)
      _war=_war+".and.(alltrim(uppe(_szab_n))$uppe(NAZWA_TOW))"
    else
      _war=_war+".and.(uppe(NAZWA_TOW)=rtrim(uppe(_szab_n)))"
    endif
  endif
  if !_gru_tow=if(subs(_wersja,81,1)=="G",spac(3),spac(2))
    _war=_war+".and.(_gru_tow=GRUPA_TOW)"
  endif
  if _niezerowe=1
    _war=_war+".and.MAG->STAN<>0"
  endi
  _bwar:=COMPILE(_war)

endi

_lcen:=len(_cenniki)                                       

_astru:={}
aadd(_astru,{"INDEKS"   ,"C",LENIN,0})
aadd(_astru,{"NAZWA_TOW","C",max(40,_len_naz),0})
aadd(_astru,{"OPIS_TOW ","C",max(40,_len_opi),0})
aadd(_astru,{"GRUPA_TOW","C", 3,0})
aadd(_astru,{"JM"       ,"C", 4,0})
aadd(_astru,{"VAT"      ,"C", 2,0})
aadd(_astru,{"KOD_PAS"  ,"N",13,0})
aadd(_astru,{"ILOSC"    ,"N", 9,2})
aadd(_astru,{"CEN_ET1"  ,"N", 9,2})
aadd(_astru,{"CEN_ET2"  ,"N", 9,2})
aadd(_astru,{"STAN"    ,"N", 9,2})
for _i:=1 to _lcen
  aadd(_astru,{"CENA_"+str(_i,1),"N",9,2})
next
dbcreate(_sc+"TOW_R",_astru)

sele 0
_use (_sc+"TOW_R","E!") 

sele TOW
set rela to s_i(INDEKS) into MAG
if !" "$_dok.and._selekcja<>3
  set rela to s_i(INDEKS) into TT additive
endi

if _selekcja<>3
  COPY_TOW(_bwar)
else                                                                 //25.11.13
  TOW->(dbsetorder(4))

  sele TOW_R
  appe from DRUK_PAS for KOD_PAS>0
  set rela to KOD_PAS into TOW
  dele all for TOW->KOD_PAS=0
  repl all INDEKS    with TOW->INDEKS,;   
           NAZWA_TOW with TOW->NAZWA_TOW,;
           OPIS_TOW  with TOW->OPIS_TOW,;
           GRUPA_TOW with TOW->GRUPA_TOW,;
           JM        with TOW->JM,;
           VAT       with TOW->VAT,;
           ILOSC     with 1
  set rela to
  TOW->(dbsetorder(1))
endi

//close TOW                                                   //17.11.13 BAFPOL

sele TOW_R
if !" "$_dok
  set rela to s_i(INDEKS) into TT additive
  repl all ILOSC with TT->ILOSC
endi
go top
do while !eof()
    
  sele MAG
  dbseek(s_i(TOW_R->INDEKS))
  _s:=0
  do while s_i(MAG->INDEKS)==s_i(TOW_R->INDEKS)
    TOW_R->STAN+=MAG->STAN
    skip
  endd 

  sele TOW_R
  skip
endd

sele TOW_R
repl all STAN with max(0,STAN),;
         ILOSC with 1 //max(0,if(" "$_dok,STAN,min(STAN,ILOSC)))     //27.10.13

CPclose(MAG)
CPClose(TT)
dele file (_sc+"TT.DBF")
dele file (_sc+"TT.NTX")

sele TOW_R                                                    //17.11.13 BAFPOL
TOW->(dbclearrelation())                     
TOW->(dbsetorder(1))
set rela to s_i(INDEKS) into TOW
repl all OPIS_TOW with TOW->OPIS_TOW                       //na wszelki wypadek

_lpoz:=lastrec()

/*                                                                   //27.10.13
if eval(memvarblock("_ceny_"+str(_cen_et1,1)))="N".and._typ_et1="B"
  dbeval({|| _pom_cen:=Eval(fieldblock("CENA_"+str(_cen_et1,1))),;
             TOW_R->CEN_ET1:=_pom_cen*(1+val(VAT)/100)})
elseif eval(memvarblock("_ceny_"+str(_cen_et1,1)))="B".and._typ_et1="N"
  dbeval({|| _pom_cen:=Eval(fieldblock("CENA_"+str(_cen_et1,1))),;
             TOW_R->CEN_ET1:=_pom_cen/(1+val(VAT)/100)})
else
  dbeval({|| _pom_cen:=Eval(fieldblock("CENA_"+str(_cen_et1,1))),;
             TOW_R->CEN_ET1:=_pom_cen})  
end
if eval(memvarblock("_ceny_"+str(_cen_et2,1)))="N".and._typ_et2="B"
  dbeval({|| _pom_cen:=Eval(fieldblock("CENA_"+str(_cen_et2,1))),;
             TOW_R->CEN_ET2:=_pom_cen*(1+val(VAT)/100)})
elseif eval(memvarblock("_ceny_"+str(_cen_et2,1)))="B".and._typ_et2="N"
  dbeval({|| _pom_cen:=Eval(fieldblock("CENA_"+str(_cen_et2,1))),;
             TOW_R->CEN_ET2:=_pom_cen/(1+val(VAT)/100)})
else
  dbeval({|| _pom_cen:=Eval(fieldblock("CENA_"+str(_cen_et2,1))),;
             TOW_R->CEN_ET2:=_pom_cen})  
end
*/

index on INDEKS to (_sc+"TOW_RI")
index on NAZWA_TOW to (_sc+"TOW_RN")
set inde to (_sc+"TOW_RI"),(_sc+"TOW_RN")
sum ILOSC to _lety
_lpoz:=lastrec()

QPC(0)

@ 24,0 say "Liczba pozycji : " +ltrim(str(_lpoz,5))+"   "+;
           "Liczba etykiet : " +ltrim(str(_lety,5))
go top
CPEDIT  POZ: if(_selekcja=1,5,7)-2,,23,               ;
        DEF: "iZEBRA"              ;
        POZWER: "V1"              ;
        POZSLAD: " "+s_i(INDEKS)+"  "+OPIS_TOW ;   
        PION: ,,,                 ;
        INDEXY: {"indeks","nazwa"};
        EDYCJA: .T.               ;
        ODTWORZ: .f.              ;
        SIEC: REKORD

if len(_zaznaczone)>0

  QPC(1)
  @ 8-2,0 clear to 24,79
  copy to (_sc+"TOW_RR") for ascan(_zaznaczone,recn())>0
  _use (_sc+"TOW_RR","E!")
  repl all ILOSC with 1 for ILOSC=0
  sum ILOSC to _lety
  _lpoz:=lastrec()

  QPC(0)

  @ 24,0 say "Liczba pozycji : " +ltrim(str(_lpoz,5))+"   "+;
             "Liczba etykiet : " +ltrim(str(_lety,5))

  CPEDIT  POZ: 8-2,,23,               ;
        DEF: "ZEBRA"             ;
        POZWER: "V1"            ;
        PION: ,,,               ;
        EDYCJA: .T.             ;
        ODTWORZ: .f.            ;
        SIEC: REKORD
endi

* errorblock( { |e| PrintError(_por_et1,e,prevhandler) } )

if QTN("Wydruk etykiet ZEBRA ?")

/* WARIANTY PODCZENIA
  1. LPT1 kabel Centronics, jezeli PC posiada port LPT1
  2. USB i kabel USB - nazw zwyk drukarki po instalacji wpisa w CONFIG.DBF
  3. USB i kabel USB - uy np. net use LPT2 \\<PC>\<nazwa sieciowa>   (?)
  3. Adapter USB->Centronics (po podaczeniu i zainstalowaniu drukarki naley
     w programie wybra port USB, a w konfiguracji poda nazw zwyk drukarki)
*/

  set devi to screen
  QKE(" Przygotuj drukark !")

  dele file (".\zebra.txt")
  _zebra:=fcreate(".\zebra.txt")

//@@@
  if _por_et1="LPT"
    
    set device to screen
    QK("Wydruk na drukark "+_por_et1)                        //15.04.18 BAFPOL
    set devi to print
    // SET(_SET_PRINTFILE,(_por_et1),.t.)

/*                                                            //15.04.18 BAFPOL
    if !PRINTER_OK(_por_et1)                           
    // if !PrintReady(val(subs(_por_et1,4,1)))
      tone(440,5)
      set devi to screen
      QKE("Drukarka nie jest gotowa !")
      set devi to print
      set print to
      close data
      BREAK
    endif
*/

  elseif _por_et1="USB".or.empty(_por_et1)                    //15.04.18 BAFPOL
    QK("Wydruk na drukark : "+_druk_zebra)                 
    set printer to (_druk_zebra) // lub SET(_SET_PRINTFILE,_druk_zebra,.t.)
    set devi to screen
    set devi to print

    if !PrinterExists(_druk_zebra)
      tone(440,5)
      set devi to screen
      QKE("Nieznana drukarka !")
      set devi to print
      clos data
      BREAK
    endif

  else                                                        //15.04.18 BAFPOL
    set devi to screen
    set printer to
    clos data
    BREAK
  endi

//  SET PRINT TO ZEBRA_X.TXT   // do testw

  *----------------------------------------- zaadowanie LOGO.PCX
  DEVOUT2('GK"LOGO"'+CRLF)
  if file("LOGO.PCX").and.(_flogo:=fopen("LOGO.PCX"))>0
    DEVOUT2('GM"LOGO"'+ltrim(str(_l:=filesize("LOGO.PCX")))+CRLF)
    _z2:=""
    for _i:=1 to _l
      _z:=" "; fread(_flogo,@_z,1)
      if _i<=50
        _z2+=_z
      endi
      DEVOUT2(_z) 
    next
    fclose(_flogo)
  endi
  _zl:="z"+chr(136)  

/*
  DEVOUT2(A,
         kolumna,  (dots)
         wiersz    (dots, zalezy od parametru qnnn)
         obrot     (0-3)
         czcionka  (1-5)
         mnoznik szer.
         mnoznik wys.
         rewersja  (N,R)
         <dane>    " -> \"  \ -> \\
        )
*/

/*  zaladowanie logo z rki
    LOGO.TXT :
    GK"ZEBRA"
    GK"ZEBRA"
    GM"ZEBRA"951
    copy LOGO.TXT+ZEBRA.PCX PRN /b
*/

  if upper(chr(145))=chr(144)
    _opi_et1:=MAZ_LAT(_opi_et1)
    _opi_et2:=MAZ_LAT(_opi_et2)
  endi

//DEVOUT2(CRLF)

  DEVOUT2("N"+CRLF)           //form feed
  DEVOUT2("q440"+CRLF)        //label width 440 dots (440dots/8=50mm)
  DEVOUT2("D10"+CRLF)         //density 0-15
  DEVOUT2("S4"+CRLF)          //speed 1-4
  DEVOUT2("I8,2,001"+CRLF)    // character set selection

  go top
  do while !eof()
    if ILOSC<=0; skip; loop; endi

    _ean:=alltrim(str(KOD_PAS))
    if len(_ean)=12                                           //22.11.13 BAFPOL
      _ean:="0"+_ean
    endi
    _naz:=alltrim(subs(NAZWA_TOW,1,30))
    _opi:=alltrim(subs(OPIS_TOW ,1,15))
    _ind:=s_i(INDEKS)

    if upper(chr(145))=chr(144)
      _naz:= MAZ_LAT(_naz)
      _ind:=MAZ_LAT(_ind)
    endi

    _cen1:=str(CEN_ET1,7,2)
    _cen2:=str(CEN_ET2,7,2)
    _ile:=ltrim(str(ILOSC,3,0))

    set devi to screen
    // QK(s_i(INDEKS)+" "+padr(NAZWA_TOW,_len_naz)+" x "+_ile+"  "+_por_et1)
    set devi to print

/*
    DEVOUT2('A14,10,0,3,2,2,N,'  +'"ABCDEFGHIJWWWWW"'+CRLF)
    DEVOUT2('A14,50,0,3,2,2,N,'  +'"MMMMMMMMMMMMMMO"'+CRLF)
    DEVOUT2('A14,90,0,3,2,2,N,'  +'"123456789012345"'+CRLF)
*/

    _anaz:=DZIEL(strtran(_naz,"  "," "),15)

    DEVOUT2('A14,10,0,3,2,2,N,'  +'"'+padr(_anaz[1],15)+'"'+CRLF)  //18.11.13
    DEVOUT2('A14,50,0,3,2,2,N,'  +'"'+padr(_anaz[2],15)+'"'+CRLF)
    DEVOUT2('A14,90,0,3,2,2,N,'  +'"'+padr(_opi,15)    +'"'+CRLF)

    if len(_ean)=8                                   
      DEVOUT2('B19,145,0,E80,4,6,100,B,'+'"'+_ean+'"'+CRLF) //kod pask.
    elseif len(_ean)=13
      DEVOUT2('B19,145,0,E30,4,6,100,B,'+'"'+_ean+'"'+CRLF) //kod pask.
    endi

  if file("LOGO.PCX"); DEVOUT2("GG4,275,"+'"LOGO"'+CRLF); endi  //obrazek

//DEVOUT2('A320,295,0,3,2,2,N,'  +'"'+_ind+'"'+CRLF)         
  DEVOUT2('A312,295,0,3,2,2,N,'  +'"'+_ind+'"'+CRLF)          //15.04.18 BAFPOL


/*                                              
    DEVOUT2('A0,115,0,3,1,1,N,'  +'"Ceny :"'+CRLF)
    DEVOUT2('A0,160,0,3,1,1,N,'  +'"DETAL"'+CRLF)
    DEVOUT2('A0,205,0,3,1,1,N,'  +'"HURT "'+CRLF)
    if val(_cen1)>0
      DEVOUT2('A80,132,0,4,2,2,N,'  +'"'+_cen1+'"'+CRLF)
    endi
    if val(_cen2)>0
      DEVOUT2('A80,180,0,4,2,2,N,'  +'"'+_cen2+'"'+CRLF)
    endi
    DEVOUT2('A290,140,0,2,1,1,N,'  +'"'+_zl+'"'+CRLF)
    DEVOUT2('A290,165,0,2,1,1,N,'  +'"'+_zl+'"'+CRLF)
*/


    DEVOUT2("P"+_ile+CRLF)

    _key:=inkey()
    if _key=K_ESC 
      set devi to screen
      if QTN("Przerwa drukowanie ?")
        fclose(_zebra)
        close data
        BREAK
      else
       set devi to prin
      endi
    endi

    skip
  endd

  set devi to screen
  set printer to
  fclose(_zebra)                                              //17.11.13 BAFPOL

endif

if !(_por_et1="LPT".or._por_et1="USB").and.;                  //15.04.18 BAFPOL
    file("zebra.bat").and.file("zebra.txt")
  _cmd:="cmd.exe /c start /MIN zebra.bat"
  RUN(_cmd)
endi


END SEQUENCE

cls
close data
errorblock(prevhandler)
tone(880,1)

RETURN NIL

*******************************************************************************
FUNCTION COPY_TOW(_bwar)
loca _or_tow:=TOW->(indexord()),_sel:=sele()

sele TOW
if !" "$_szab_i
  TOW->(dbsetorder(1))
  TOW->(dbseek(_szab_i))
  if TOW->(s_i(INDEKS))==_szab_i
    dbeval({|| POLCOPY(TOW,TOW_R)},,{|| TOW->(s_i(INDEKS))==_szab_i})
  endi
elseif !empty(_gru_tow)
  TOW->(dbsetorder(3))
  TOW->(dbseek(_gru_tow))
  dbeval({|| POLCOPY(TOW,TOW_R)},_bwar,{|| TOW->GRUPA_TOW==_gru_tow})
else
  dbeval({|| POLCOPY(TOW,TOW_R)},_bwar)
endi

sele (_sel)
TOW->(dbsetorder(_or_tow))

RETURN NIL

*******************************************************************************
FUNCTION DAJ_DOK(_w,_k)
loca _sel:=sele(),_dok:="  -     /  /    ",getlist:={}
loca _osl_mag:=sele("SL_MAG")>0,;
      _osl_dok:=sele("SL_DOK")>0,;
      _o_kon:=sele("KON")>0,;
      _o_nag:=sele("DOKN")>0

priv _rodz_dok:="PZ",_nr_mag:=_magazyn,_rok_dok:=str(year(date()),4,0),;
     _nr_dok:=spac(5)

DEFAULT _w TO 0, _k TO 0

if !_osl_mag
  sele 0
  if !_use("SL_MAG","R","SL_MAG"); BREAK; endi
  set index to SL_MAG
endi

if !_osl_dok
  sele 0
  if !_use("SL_DOK","R","SL_DOK"); BREAK; endi
  set index to SL_DOK
endi

if !_o_kon
  sele 0
  if empty(_gdzie_fir)
    if !_use("KON","R","KON"); BREAK; endi
    set index to KON_NR,KON_NA,KON_NI,KON_AD
  else
    if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endi
    set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
                 (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
  endi
endi

*PZ-12345/001/2011
*01234567890123456

@ _w,_k say "  -     /   /    "
@ _w,_k+3 get _nr_dok pict "99999"; clear gets
@ _w,_k get _rodz_dok pict "@! AN" when SLGET("SL_DOK","SL_DOK","V2",1,1,;
            {""},,.f.,BEZBLOK) vali SL("SL_DOK","SL_DOK","V2",1,1).and.SLGET()
@ _w,_k+9 get _nr_mag pict "@K 999" when SLGET("SL_MAG","SL_MAG","V2",1,1,;
            {"magazyn"},,.f.,BEZBLOK);
            vali SZ().and.SL("SL_MAG","SL_MAG","V2",1,1).and.SLGET()
@ _w,_k+13 get _rok_dok pict "9999" vali _rok_dok>"2000"
set curs on; read; set curs off
if !_osl_dok; CPClose(QSL_DOK); endi
if !_osl_mag; CPClose(QSL_MAG); endi

if !_o_nag
  sele 0
  if !_use("DOK"+_nr_mag+"N","R","DOKN"); BREAK; endi
  set inde to ("D"+_nr_mag+"N_NR")  
  set rela to NR_KON into KON
endi

_wer:="V10"

DOK_BOTTOM(_rodz_dok,_nr_mag,ep(_rok_dok))
_nr_dok:=NR_DOK
go top

@ _w,_k+3 get _nr_dok pict "@K 99999" when SLGETDOK(1);
   vali SZ().and.(DOKN->(dbseek(_rodz_dok+_nr_mag+ep(_rok_dok)+_nr_dok)));
            .and.SLGETDOK()
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

_dok:=_rodz_dok+"-"+_nr_dok+"/"+_nr_mag+"/"+_rok_dok

if !_o_nag; CPClose(DOKN); endi
if !_o_kon; CPClose(KON); endi

sele(_sel)
RETURN _dok

*******************************************************************************
FUNCTION DEVOUT2(_t)
if _por_et1="LPT".or._por_et1="USB".or.empty(_por_et1)        //15.04.18 BAFPOL
  DEVOUT(_t)
endi
if file (".\zebra.txt")
  fwrite(_zebra,_t)
endi
RETURN NIL

*******************************************************************************
FUNCTION ZMIANA_PZ()                                          //24.11.14 BAFPOL
local _tex:='۲  ZMIANA FIRMY NA PZ (DOK001N,DOS_N,ZAP,KON)  ',;
      _nr_mag:="001",_nr_kon:="     ",;
      _key:="",_err:=.t.,;
      _nr_dos:=spac(5),_rok_dos:=spac(4),_wart_n_pz:=0,_wart_b_dos:=0,;
      _bez_dos:=.t.,_bez_zap:=.t.
 
priv  _nr_dok:="     ",_rok_dok:=subs(dtos(date()),1,4),;
      _nr_kon1:=space(5),_nr_kon2:=space(5)
   
cls
@ 0,0 say _tex

BEGIN SEQUENCE

@ 1,0 say "Rok :  " get _rok_dok pict "9999" vali SZ().and._rok_dok>="2005"
@ 2,0 say "Nr PZ :" get _nr_dok  pict "99999" vali SZ()
@ 3,0 say "Firma stara :" get _nr_kon1 pict "99999" vali SZ()
@ 4,0 say "Firma nowa : " get _nr_kon2 pict "99999" vali SZ()
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi


sele 0
if !_use("DOK"+_nr_mag+"N","S","DOKN"); BREAK; endi
set index to ("D"+_nr_mag+"N"+"_NR"),;//RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK
             ("D"+_nr_mag+"N"+"_RD")  //RODZAJ_DOK+NR_MAG+dtos(DATA_DOK)+NR_DOK


sele 0
if !_use("ZAP","S"); BREAK; endi
set index to ZAP_DD,;  //DATA_ZAP for RODZAJ_DOK=="DO"
             ZAP_DS,;  //DATA_ZAP for RODZAJ_DOK != "DO"
             ZAP_KO,;  //ZAP_KO
             ZAP_FA    //RODZAJ_DOK+SERIA_FAK+ROK_FAK+NR_FAK+ROK_DOS+NR_DOS

/*
sele 0
if !_use("KP_N","S"); BREAK; endi
set index to KP_N_NR,;  //ROK_ZAP+NR_ZAP    
             KP_N_KD,;  //NR_KON+dtos(DATA_ZAP)
             KP_N_DK    //dtos(DATA_ZAP)+NR_KON

sele 0
if !_use("KP_P","S"); BREAK; endi
set index to KP_P_NR,;  //ROK_ZAP+NR_ZAP    
             KP_P_KD    //NR_KON
*/

sele 0
if !_use("DOS_N","S"); BREAK; endi
set index to DOS_N_NR,; //ROK_DOS+NR_DOS 
             DOS_N_DK,; //dtos(DATA_WPL)+NR_KON 
             DOS_N_PL,; //dtos(DATA_PLA) 
             DOS_N_KO   //NR_KON+ROK_DOS+NR_DOS

sele 0
if empty(_gdzie_fir)
  if !_use("KON","S"); BREAK; endi
  set index to KON_NR, KON_NA, KON_NI, KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","S","KON"); BREAK; endi
  set index to (_gdzie_fir+"FIRMY_NR"), (_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"), (_gdzie_fir+"FIRMY_AD")
endi


sele KON
dbseek(_nr_kon1)
if !found()
  QK("Nie znaleziono firmy starej !")
  BREAK
endi
@ 3,21 say NAZWA_KON

dbseek(_nr_kon2)
if !found()
  QK("Nie znaleziono firmy nowej !")
  BREAK
endi
@ 4,21 say NAZWA_KON


sele DOKN
loca for RODZAJ_DOK="PZ".and.NR_MAG="001".and.;
         ROK_DOK=_rok_dok.and.NR_DOK=_nr_dok
if !found()
  QK("Nie znaleziono dokumentu PZ !")
  BREAK
endi
if !NR_KON=_nr_kon1
  QK("Niezgodna firma na dokumencie PZ !")
  BREAK
endi

@ 6,0 say "Data PZ : "+dtoc(DATA_DOK)
@ 6,0 say "Wartosc netto PZ : "+ltrim(transform(WART_ZAK,"@E 9,999,999.99"))
_wart_n_pz:=WART_ZAK

sele DOS_N
loca for ROK_DOK=_rok_dok.and.NR_DOK=_nr_dok.and.NR_MAG="001"
_bez_dos:=!found()
if _bez_dos
  @ 7,0 say "Dostawa : "+"nie znaleziono"
else
  _nr_dos:=NR_DOS
  _rok_dos:=ROK_DOS
  _wart_b_dos:=WART_B_DOS

  @ 7,0 say "Dostawa : "+_nr_dos+"/"+_rok_dos

  if !NR_KON==_nr_kon1
    QK("Niezgodna firma na dostawie !")
    BREAK
  endi

  sele ZAP
  loca for ROK_DOS=_rok_dos.and.NR_DOS=_nr_dos
  _bez_zap:=!found()
  if !_bez_zap
    QKE("Znaleziono zaplate. Procedura przerwana !")
    BREAK
  endi

endi

sele ZAP
loca for ROK_DOS=_rok_dos.and.NR_DOS=_nr_dos
if found()
  QKE("Znaleziono zaplate. Procedura przerwana !")
  BREAK
endi

if !QTN("Kontynuacja ?")
  BREAK
endi

_err:=.t.

if !DOKN->(rlock())
  BREAK
endi

if !DOS_N->(rlock())
  BREAK
endi

sele DOKN
repl NR_KON with KON->NR_KON
use

if !_bez_dos
  sele DOS_N
  repl NR_KON with KON->NR_KON,;
       ID_KON with KON->ID_KON,;
       GRUPA_KON with KON->GRUPA_KON
  use
endi
_err:=.f.


END SEQUENCE
close data

if !_err
  QKE("Wykonano zmiane numeru firmy. Wykonaj uzgodnienie firm !")
else
  QKE("Nie Wykonano zmiany !")
endi


RETURN NIL

*******************************************************************************
FUNCTION TEST_ZEBRA()                                       //15.04.18 OK BAFPOL
cls
wait "START"
set devi to print
//set printer to "HP Deskjet 5900 Series"
//set printer to "ZDesigner GC420d (EPL)"
set printer to (_druk_zebra) //z CONFIG.DBF

devpos(0,0)
devout('GK"LOGO"'+LF)
devout('N'+LF)
devout('q440'+LF)
devout('D10'+LF)
devout('S4'+LF)
devout('I8,2,001'+LF)
devout('A14,10,0,3,2,2,N,"KB    K   5,4CM"'+LF)
devout('A14,50,0,3,2,2,N,"KORONKA        "'+LF)
devout('A14,90,0,3,2,2,N,"A-25           "'+LF)
devout('B19,145,0,E30,4,6,100,B,"2100000000005"'+LF)
devout('A320,295,0,3,2,2,N,"10000"'+LF)
devout('P1'+LF)
eject
set device to screen
set printer to
wait "KONIEC"

/* ZEBRA.TXT
GK"LOGO"
N
q440
D10
S4
I8,2,001
A14,10,0,3,2,2,N,"KB    K   5,4CM"
A14,50,0,3,2,2,N,"KORONKA        "
A14,90,0,3,2,2,N,"A-25           "
B19,145,0,E30,4,6,100,B,"2100000000005"
A320,295,0,3,2,2,N,"10000"
P1
*/

RETURN NIL

*******************************************************************************
  