#include "comped.ch"
#include "inkey.ch"
#include "setcurs.ch"
#include "achoice.ch"
#include "box.ch"

#define K_STAR 42
#define K_PLUS 43
#define K_MINUS 45
#define CRLF CHR(13)+CHR(10)

static _klawisz:=0,_sygnal:=.f. // denominator
static _data_beg:=NIL, _data_end:=NIL
static _fak_kau:="             "

*******************************************************************************
FUNCTION ANA_DOS()
#ifdef M
 cls; QK("Opcja dostpna w penej wersji programu !"); RETURN NIL
#else

local _kol:=25, _tex:="", _inde:="",_nazwa_kon:=""
priv  _war:=".t.", _data_od:=date()-day(date())+1, _data_do:=date(),_dok:={}
priv  _szab_i:=transform(spac(LENIN),_format_ind),  _nr_kon:=spac(5), _bwar

cls
@ 0,0 say '۲  ANALIZA DOSTAW   '
BEGIN SEQUENCE

sele 0
if !_use("SL_DOK","R");break;endi
dbeval({ ||  aadd(_dok,{RODZAJ_DOK,"T"}) },{||TYP_DOK="+".and.KONTRAHENT="T"})
CPClose(SL_DOK)

@ 1,0        say "Zestawienie za okres :  "

if !(_data_beg=NIL.or._data_end=NIL)
  _data_od:=_data_beg; _data_do:=_data_end
endi


@ 1,_kol     get _data_od  vali _data_od <= date();
                     .and.DODATY(_data_od,@_data_do)
@ 1,_kol+10  get _data_do  vali _data_do <= date().and._data_do>=_data_od
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endif

_data_beg:=_data_od; _data_end:=_data_do

sele 0
if !_use("TOW","R"); BREAK; endif
set index to TOW_IN, TOW_NA, TOW_GR

/*
sele 0
if !_use("KON","R"); BREAK; endif
set index to KON_NR, KON_NA
*/
sele 0  //"R"
if empty(_gdzie_fir)
  if !_use("KON","R"); BREAK; endif
  set index to KON_NR,KON_NA
else
  if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA")
endi

@ 2,0    say "Szablon indeksu : "
@ 2,_kol get _szab_i pict _format_ind ;
         when SLGET("TOW","TOW","V1",1,1,;
             {"indeks","nazwa","grupa"},,.f.,BEZBLOK) ;
         valid SLGET()
@ 3,0    say "Numer dostawcy : "
@ 3,_kol get _nr_kon pict "@K 99999";
         when SLGET("KON","KON","V1",1,1,;
              {"nr dostawcy","nazwa kontrahenta"},,.f.,BEZBLOK,,,0);
         valid (empty(_nr_kon).or.;
              (SZ().and.SL("KON","KON","V1",1,1))).and.SLGET()

set cursor on;  read;  SLGET();  set cursor off
if lastkey()=K_ESC; BREAK; endif

@4,0 say "Dokumenty: "

for i:=1 to len(_dok)
    @4,11+(3*(i-1)) say _dok[i][1]
    @5,11+(3*(i-1)) get _dok[i][2] pict "@! X" ;
                      valid {|oget| oget:varget()$"TN"}
next

set curs on; read; set curs off
if lastkey()=K_ESC;BREAK; endif

//@4,0 

if !empty(_nr_kon)
   KON->(dbsetorder(1))
   KON->(dbseek(_nr_kon))
   _nazwa_kon:=alltrim(KON->NAZWA_KON)
   devpos(3, _kol+10); devout(subs(_nazwa_kon,1,40))
endif
if !_szab_i=transform(spac(LENIN),_format_ind)
  _war:=_war+".and.(COMP(s_i(INDEKS),_szab_i))"
endi
if !_nr_kon=spac(5)
  _war:=_war+".and.(_nr_kon=DOKN->NR_KON)"
endif

sele 0
if !_use("QDOKP","R"); BREAK; endif
copy stru to (_sc+"DP_R")

if !_use(_sc+"DP_R","E"); BREAK; endif
set rela to s_i(INDEKS) into TOW

sele 0
if !_use("SL_MAG","R"); BREAK; endif
set index to SL_MAG

_total:=lastrec()
*------------------------------------------ wykopiowanie z pozycji dokumentow
PASEK()
do while !eof()

  _nr_mag:=NR_MAG
  PASEK(1)

  sele 0
  _zb:="DOK"+_nr_mag+"N"
  _i1:="D"+_nr_mag+"N"+"_NR"
  _use(_zb,"R!","DOKN")
  set inde to (_i1)

  sele 0
  _zb:="DOK"+_nr_mag+"P"
  _i1:="D"+_nr_mag+"P"+"_NR"  //"RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK"

  if !_use(_zb,"R!","DOKP"); BREAK; endif
  set inde to (_i1)
  set rela to RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK into DOKN

  _bwar:=COMPILE(_war)

  for i:=1 to len(_dok)
     if _dok[i][2]<>"T";loop;endi
     seek _dok[i][1]
     do while RODZAJ_DOK=_dok[i][1] .and. !eof()

        if !(DATA_DOK>=_data_od .and. DATA_DOK<=_data_do);  skip;  loop;  endif
        if !Eval(_bwar);  skip;  loop;  endif

        sele DP_R
        appe blank
        repl INDEKS     with DOKP->INDEKS
        go recn()
        repl RODZAJ_DOK with _dok[i][1],;
             NR_MAG     with DOKP->NR_MAG,;
             ROK_DOK    with DOKP->ROK_DOK,;
             NR_DOK     with DOKP->NR_DOK,;
             DATA_DOK   with DOKP->DATA_DOK,;
             ILOSC      with DOKP->ILOSC,;
             CENA_ZAK   with DOKP->CENA_ZAK,;
             DATA_DOS   with DOKP->DATA_DOS,;
             NAZWA_TOW  with TOW->NAZWA_TOW,;
             OPIS_TOW   with TOW->OPIS_TOW,;
             GRUPA_TOW  with TOW->GRUPA_TOW,;
             JM         with TOW->JM,;
             VAT        with DOKP->VAT,;
             NR_KON     with DOKN->NR_KON

        sele DOKP
        skip
     enddo
  next

  close DOKP
  close DOKN

  sele SL_MAG
  skip

enddo

PASEK()
@24,0


sele DP_R
set rela to

if empty(_nr_kon)
  index on NR_MAG+ROK_DOK+RODZAJ_DOK+NR_DOK+s_i(INDEKS)  to (_sc+"DP_NR_R")
  index on s_i(INDEKS )+NR_KON+dtos(DATA_DOK) to (_sc+"DP_IN_R")
  index on NAZWA_TOW   +NR_KON+dtos(DATA_DOK) to (_sc+"DP_NA_R")
  index on NR_KON+INDEKS+dtos(DATA_DOK) to (_sc+"DP_KO_R")
  _inde:={'rodzaj + nr dok + indeks','indeks + nr kontrahenta + data',;
          'nazwa towaru + nr kontrahenta','nr kontrahenta + indeks + data'}
  set index to (_sc+"DP_NR_R"),(_sc+"DP_IN_R"),(_sc+"DP_NA_R"),(_sc+"DP_KO_R")
  _wer:="V1"
  _tex:="ANALIZA DOSTAW TOWARW  w okresie "+dtoc(_data_od)+" - "+dtoc(_data_do)
else

  index on NR_MAG+ROK_DOK+RODZAJ_DOK+NR_DOK+s_i(INDEKS)  to (_sc+"DP_NR_R")
  index on s_i(INDEKS )+dtos(DATA_DOK) to (_sc+"DP_IN_R")
  index on NAZWA_TOW   +dtos(DATA_DOK) to (_sc+"DP_NA_R")
  _inde:={'rodzaj + nr dok + indeks','indeks + data','nazwa towaru'}

  set index to (_sc+"DP_NR_R"), (_sc+"DP_IN_R"), (_sc+"DP_NA_R")
  _wer:="V2"
  _tex:="ANALIZA DOSTAW TOWARW w okresie "+dtoc(_data_od)+" - "+;
        dtoc(_data_do)+" od dostawcy : "+ subs(_nazwa_kon,1,40)
endif


QPC(0)
KON->(dbsetorder(1))
set rela to NR_KON into KON

go top
CPEDIT  POZ: 6,,,                 ;
        DEF: "ANA_PZ"               ;
        POZWER: _wer              ;
        POZSLAD: " "+transform(INDEKS,_format_ind)+"  "+rtrim(subs(TOW->NAZWA_TOW,1,30))+;
            space(72-len(alltrim(_format_ind))-len(rtrim(subs(TOW->NAZWA_TOW,1,30))))  ;
        PION: ,,,                 ;
        INDEXY: _inde          ;
        ODTWORZ: .f.

go top
CPDRUK  DEF: "ANA_PZ"            ;
        WERSJA: "VR"              ;
        TYTUL: _tex               ;
        WARIANT: 25


END SEQUENCE
close data
dele file (_sc+"DP_R.DBF")
dele file (_sc+"DP_NR_R.NTX")
dele file (_sc+"DP_IN_R.NTX")
dele file (_sc+"DP_NA_R.NTX")
dele file (_sc+"DP_KO_R.NTX")

RETURN NIL
#endi
*******************************************************************************
FUNCTION ZAPASY()
#ifdef M
 cls; QK("Opcja dostpna w penej wersji programu !"); RETURN NIL
#else

local _tex:='۲  MIESICZNY STAN ZAPASW  ',;
       _w_net,_w_zak
priv  _data_od, _data_do,_mi,_ro,;
      _rodz_dok,_wer

priv  _szab_i1,_szab_i2,_szab_i3,_szab_n,;
      _gru_tow1,_gru_tow2,_gru_tow3,_nr_kon,_stan:=0,;
      _war,_warinde,_wargrupa
priv _akt_poz:=0 //  aktywna pozycja znacznika (1,2 lub 3)           //18.07.04
cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use("SL_MAG","R"); BREAK; endif
set index to SL_MAG

_nr_mag:=space(3)
_mi:=subs(dtoc(date()),4,2)
_ro:=subs(dtoc(date()),7,2)
@ 1,0 say "Magazyn : " get _nr_mag pict "999";
           when SLGET("SL_MAG","SL_MAG","V1",1,1,;
           {"nr magazynu"},,.f.,BEZBLOK);
           valid SZ().and.SL("SL_MAG","SL_MAG","V1",1,1)
@ 2,0 say "Miesic : " get _mi pict "99";
           valid SZ().and.val(_mi)>=1.and.val(_mi)<=12
@ 2,13 say "."
@ 2,14 get _ro pict "99" valid SZ() //.and.val(_ro)>=93.and.val(_ro)<=99
set curs on; read; SLGET(); set curs off
if lastkey()=K_ESC; BREAK; endi

clos SL_MAG
_data_od:=ctod("01."+_mi+"."+_ro)
_data_do:=ctod( "01."+ subs(  dtoc(_data_od+31) ,4) )-1
if _data_do>date()
 _data_do:=date()
endi

sele 0
if !_use("TOW","S!"); BREAK; endi
set index to TOW_IN, TOW_NA, TOW_GR, TOW_SW

_zero_s:=2
_zero_s:=   Horizmenu(3,0,"Stany zerowe :",{"TAK","NIE"},2)

_selekcja:=2
_selekcja:= Horizmenu(4,0,"Selekcja :    ",{"TAK","NIE"},2)


if lastkey()=K_ESC; BREAK; endi

_war:=(".t."); _warinde=".f."; _wargrupa:=".f."
if _selekcja=1

  sele 0
  if !_use("SL_G_TOW","R"); BREAK; endif
  set index to SL_G_TOW, SL_G_TON

/*  sele 0
  if !_use("KON","R"); BREAK; endif
  set index to KON_NR, KON_NA, KON_NI, KON_AD
*/
  sele 0  //"R"
  if empty(_gdzie_fir)
    if !_use("KON","R"); BREAK; endif
    set index to KON_NR,KON_NA,KON_NI,KON_AD
  else
    if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endif
    set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
                 (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
  endi

  _szab_i1:=transform(spac(LENIN),_format_ind)
  _szab_i2:=transform(spac(LENIN),_format_ind)
  _szab_i3:=transform(spac(LENIN),_format_ind)
  _szab_n:=spac(_len_naz)
  _gru_tow1:=if(subs(_wersja,81,1)=="G",spac(3),spac(2))
  _gru_tow2:=_gru_tow1
  _gru_tow3:=_gru_tow1
  _nr_kon:=spac(5)
  _znacz:=" "

  @ 5,0 say "Szablon 1 indeksu :   " get _szab_i1 pict _format_ind ;
            when SLGET("TOW","TOW","V1",1,1,;
            {"indeks","nazwa","grupa",ORD4()},,.f.,BEZBLOK) valid SLGET()
  @ 6,0 say "Szablon 2 indeksu :   " get _szab_i2 pict _format_ind ;
            when SLGET("TOW","TOW","V1",1,1,;
            {"indeks","nazwa","grupa",ORD4()},,.f.,BEZBLOK) valid SLGET()

  @ 5,40 say "Grupa towarowa 1 :   " get _gru_tow1 pict ;
           if(subs(_wersja,81,1)=="G","999","99");
           when SLGET("SL_G_TOW","GTOW","V1",1,1,;
           {"grupa","nazwa"},,.f.,BEZBLOK);
           valid SLGET().and.(empty(_gru_tow1).or.;
           (SZ().and.SL("SL_G_TOW","GMAG","V1",1,1)))
  @ 6,40 say "Grupa towarowa 2 :   " get _gru_tow2 pict ;
           if(subs(_wersja,81,1)=="G","999","99");
           when SLGET("SL_G_TOW","GTOW","V1",1,1,;
           {"grupa","nazwa"},,.f.,BEZBLOK);
           valid SLGET().and.(empty(_gru_tow2).or.;
           (SZ().and.SL("SL_G_TOW","GMAG","V1",1,1)))
  @ 7,0 say "Szablon nazwy :       " get _szab_n pict repl("!",_len_naz)
  @ 8,0 say "Nr dostawcy :         " get _nr_kon pict "99999";
           when SLGET("KON","KON","V1",1,1,;
           {"nr dostawcy","nazwa","NIP","adres"},,.f.,BEZBLOK,,,0);
           valid SLGET().and.(empty(_nr_kon).or.;
           (SZ().and.SL("KON","KON","V1",1,1)))
  @ 9,0 say "Pomin :"
  @ 10,0 say "Szablon 3 indeksu :   " get _szab_i3 pict _format_ind ;
            when SLGET("TOW","TOW","V1",1,1,;
            {"indeks","nazwa","grupa",ORD4()},,.f.,BEZBLOK) valid SLGET()

  @ 11,0 say "Pozycja znacznika:" get _akt_poz pict "9" range 0,3
  set curs on; read; set curs off
  
  if _akt_poz=0
     _znacz:=space(3)
  endi

  @ 11,22 say "znacznik: " get _znacz pict "@!"
  
  if _akt_poz=0
     @11,col()+2 say "? - dowolny znak"
  endi

  set curs on; read; set curs off
  SLGET()
  if lastkey()=K_ESC; BREAK; endi

  clos KON
  clos SL_G_TOW

  if !_szab_i1=transform(spac(LENIN),_format_ind)
    _warinde:=_warinde+".or. COMP(s_i(TOW->INDEKS),_szab_i1)"
  endi
  if !_szab_i2=transform(spac(LENIN),_format_ind)
    _warinde:=_warinde+" .or. COMP(s_i(TOW->INDEKS),_szab_i2)"
  endi
  if !(_warinde==".f.")
   _war:="("+_warinde+")"
  endif

  if !_gru_tow1=if(subs(_wersja,81,1)=="G",spac(3),spac(2))
    _wargrupa:=_wargrupa+".or.(_gru_tow1=TOW->GRUPA_TOW)"
  endi
  if !_gru_tow2=if(subs(_wersja,81,1)=="G",spac(3),spac(2))
    _wargrupa:=_wargrupa+".or.(_gru_tow2=TOW->GRUPA_TOW)"
  endi
  if !(_wargrupa==".f.")
   _war:=_war+".and.("+_wargrupa+")"
  endif

  if .not.empty(_szab_n)
    if " "=subs(_szab_n,1,1)
      _war:=_war+".and.(alltrim(uppe(_szab_n))$uppe(TOW->NAZWA_TOW))"
    else
      _war:=_war+".and.(uppe(TOW->NAZWA_TOW)=rtrim(uppe(_szab_n)))"
    endi
  endi

  if !_nr_kon=spac(5)
    _war:=_war+".and.(_nr_kon=TOW->NR_KON)"
  endi

  if !_szab_i3=transform(spac(LENIN),_format_ind)
    _war:="("+_war+")"+".and.!COMP(s_i(TOW->INDEKS),_szab_i3)"
  endi

  if _akt_poz>0
     if !_znacz=" "
       _war:="("+_war+")"+".and.!subs(TOW->USLUGA,_akt_poz,1)=_znacz"
     endi
  else
     if _znacz<>space(3)
        for _i:=1 to 3
            if subs(_znacz,_i,1)<>"?"        
               _war:=_war+".and.(!subs(TOW->USLUGA,"+str(_i,1,0)+;
                                 ",1)==subs(_znacz,"+str(_i,1,0)+",1))"
            endi
        next
     endi
  endi
endi
_bwar:=COMPILE(_war)

sele 0
if !_use("QSTA","R"); BREAK; endif
copy stru to (_sc+"STA_R")

if !_use(_sc+"STA_R","E"); BREAK; endif
index on s_i(INDEKS) to (_sc+"STA_R")

sele 0
_zb:="DOK"+_nr_mag+"P"
_i1:="D"+_nr_mag+"P"+"_DI"       //  "dtos(DATA_DOK)+s_i(INDEKS)")
if !_use(_zb,"R","DOKP"); BREAK; endif
set index to (_i1)
set rela to s_i(INDEKS) into TOW
_total:=lastrec()
PASEK()

go top
do while DATA_DOK<=_data_od-1 .and.!eof()
  PASEK(10)
  if Eval(_bwar)

    sele STA_R
    seek s_i(DOKP->INDEKS)
    if !found()
      appe blank
      repl INDEKS with DOKP->INDEKS
    endif
    repl M01 with M01+(DOKP->ZNAK)*(DOKP->ILOSC)

    sele DOKP
  endif
  skip
endd

for _d:=_data_od to _data_do

  sele DOKP
  _dz:="M"+iif(day(_d)<10,"0"+str(day(_d),1),str(day(_d),2))
  _dz2:="M"+iif(day(_d+1)<10,"0"+str(day(_d+1),1),str(day(_d+1),2))
  _dz3:="Z"+iif(day(_d)<10,"0"+str(day(_d),1),str(day(_d),2))
  set soft on
  seek dtos(_d)
  set soft off

  do while DATA_DOK<=_d .and.!eof()
    PASEK(10)
    if Eval(_bwar)

      sele STA_R
      seek s_i(DOKP->INDEKS)
      if !found()
        appe blank
        repl INDEKS with DOKP->INDEKS
      endif
      repl &_dz with &_dz+(DOKP->ZNAK)*(DOKP->ILOSC),;
           &_dz3 with &_dz3+if(DOKP->RODZAJ_DOK="PZ",DOKP->ILOSC,0),;
           WART_NET with WART_NET+if(DOKP->RODZAJ_DOK="WZ",DOKP->ILOSC,0),;
           WART_ZAK with WART_ZAK+if(DOKP->RODZAJ_DOK="PZ",DOKP->ILOSC,0)
              // ostatnie dwa pola tez zliczaja ilosc sprzedazy i zakupu
      sele DOKP
    endi
    skip
  endd

  if _d<_data_do
    sele STA_R
    repl all &_dz2 with &_dz
  endi
next
close DOKP

sele STA_R
if _zero_s=2
  dele all for M01=0.and.WART_NET=0.and.WART_ZAK=0
endi

PASEK()
go top
if eof()
  QKE("Zestawienie jest puste !")
  BREAK
endif
set rela to s_i(INDEKS) into TOW
_wie:=if(_selekcja=1,12,4)
go top

_wer:="V6|V_DZIE()"
_nag_sz="Sprzeda"

CPEDIT  POZ: _wie,,23,            ;
        DEF: "ASO"                ;
        POZWER: _wer              ;
        POZSLAD: " "+transform(INDEKS,_format_ind)+"  "+rtrim(subs(TOW->NAZWA_TOW,1,30))+;
                   spac(4)+TOW->OPIS_TOW ;
        PION: ,,,                 ;
        INDEXY: {"indeks"}        ;
        EDYCJA: .f.;
        ODTWORZ:.f.
go top
_nag_sz="Zak.;Sprz."
CPDRUK  DEF: "ASO"                 ;
        WERSJA: "V8|V_DZIE()"              ;
        TYTUL: "STAN ZAPASW  za okres "+ ;
                dtoc(_data_od)+" - "+dtoc(_data_do) ;
        DODATEK: DOD_ZAPA() ;
        WARIANT: 5

END SEQUENCE
close data
dele file (_sc+"STA_R.NTX")
dele file (_sc+"STA_R.DBF")
RETURN NIL
#endi

*******************************************************************************
FUNCTION V_DZIE()
loca _dd:=val(subs(dtoc(_data_do),1,2)), _pp:=val(subs(EDIT->POLE,2,2))
if _pp>0.and._pp>_dd ;  RETURN .f.;  endi
RETU .t.

*******************************************************************************
FUNCTION DOD_ZAPA()
@ prow(),0 say  TOW->INDEKS
@ prow(),15 say TOW->NAZWA_TOW
@ prow(),48 say int(WART_ZAK) pict "@Z 9999"
for _i:=1 to 31
 _ii:="Z"+iif(_i<10,"0"+str(_i,1),str(_i,2))
 @ prow(),58+(_i-1)*6 say &_ii pict "@Z 9999"
next

RETU NIL

*******************************************************************************
FUNCTION SPR_ZAP()
#ifdef M
 cls; QK("Opcja dostpna w penej wersji programu !"); RETURN NIL
#else

local _tex,_blad:=.f.,_z_spr,_z_dos,_w_spr,_w_dos

cls
_tex:='۲  SPRAWDZENIE ZBIORU ZAPAT  '
@ 0,0 say _tex
@ 2,0 say "Sprawdzenie czy w zbiorze zapat ZAP.DBF s wszystkie zapaty"
@ 3,0 say "wynikajce z SPR_N oraz DOS_N."

BEGIN SEQUENCE

sele 0
if !_use("ZAP","E"); _blad:=.t.; BREAK; endif
sum WPLATA-WYPLATA to _z_spr for RODZAJ_DOK$"FA,FK,RA,RK"
sum WYPLATA-WPLATA to _z_dos for RODZAJ_DOK="DO"
_z_spr:=zaokr(_z_spr,2)
_z_dos:=zaokr(_z_dos,2)


if !_use("SPR_N","E"); _blad:=.t.; BREAK; endif
sum WART_ZAP-WN to _w_spr

if !_use("DOS_N","E"); _blad:=.t.; BREAK; endif
sum WART_B_DOS-MA to _w_dos
_w_spr:=zaokr(_w_spr,2)
_w_dos:=zaokr(_w_dos,2)

/*
@ 6,0 say "_z_spr = "+str(_z_spr)
@ 7,0 say "_w_spr = "+str(_w_spr)
@ 8,0 say if(_w_spr=_z_spr,"_w_spr=_z_spr","_w_spr<>_z_spr")

@ 10,0 say "_z_dos = "+str(_z_dos)
@ 11,0 say "_w_dos = "+str(_w_dos)
@ 12,0 say if(_w_dos=_z_dos,"_w_dos=_z_dos","_w_dos<>_z_dos")

inkey(0)
*/

END SEQUENCE
clos data
if _blad
  QKE("Testu nie wykonano !")
else
  if _w_spr=_z_spr.and._w_dos=_z_dos
    QKE("Nie wykryto niezgodnoci !")
  else
   if _w_spr != _z_spr
     QKE("Niezgodno w wpatach od odbiorcw !")
   endi
   if _w_dos != _z_dos
     QKE("Niezgodno w wypatach dla dostawcw !")
   endi
  endi
endi

RETU NIL
#endi

*******************************************************************************
FUNCTION ZERUJ_MAG(_nrm)
#ifdef M
 cls; QK("Opcja dostpna w penej wersji programu !"); RETURN NIL
#else

local _tex,_zb,_i1,_k1,_i2,_k2,_i3,_k3,_i4,_k4

cls
_tex:='۲  ZEROWANIE ZBIORW : MAG???, DOK???N, DOK???P, SP???  '
@ 0,0 say _tex

DEFAULT _nrm TO "   "
_nr_mag:=_nrm

sele 0
if !_use("SL_MAG","R"); BREAK; endif
set index to SL_MAG

@ 1,0 say "Numer magazynu :      " get _nr_mag pict "999";
           when SLGET("SL_MAG","SL_MAG","V1",1,1,;
           {"nr magazynu"},,.f.,BEZBLOK);
           valid (SZ().and.SL("SL_MAG","SL_MAG","V1",1,1))
set curs on; read; SLGET(); set curs off
if lastkey()=K_ESC; BREAK; endi
if !HA(_haslo); BREAK; endi

_total:=1
PASEK()

BEGIN SEQUENCE

SORTUJ()

sele 0
_use("TOW","E!")
set index to TOW_IN

sele 0
_zb:="MAG"+_nr_mag
_i1:="M"+_nr_mag+"_IP"
_i2:="M"+_nr_mag+"_N"
_i3:="M"+_nr_mag+"_IP0"
_i4:="M"+_nr_mag+"_N0"
do case
  case _rozchody="1"
   _k1:="s_i(INDEKS)+s_c(CENA_ZAK)"
  case _rozchody="2"
   _k1:="s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK)"
endc

_k2:="TOW->NAZWA_TOW"
_k3:=_k1
_k4:=_k2

_use(_zb,"E!")
zap
use
SORTUJ(_zb,_i1,_k1)
SORTUJ(_zb,_i2,_k2,"s_i(INDEKS)","TOW")              // relacja
SORTUJ(_zb,_i3,_k3,,,"STAN<>0")                      // stany
SORTUJ(_zb,_i4,_k4,"s_i(INDEKS)","TOW","STAN<>0")    // relacja, stany

_zb:="DOK"+_nr_mag+"N"
_i1:="D"+_nr_mag+"N"+"_NR"
_i2:="D"+_nr_mag+"N"+"_RD"
_use(_zb,"E!")
zap
use
SORTUJ(_zb,_i1,"RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK")
SORTUJ(_zb,_i2,"RODZAJ_DOK+NR_MAG+dtos(DATA_DOK)+NR_DOK")

_zb:="DOK"+_nr_mag+"P"
_i1:="D"+_nr_mag+"P"+"_NR"
_i2:="D"+_nr_mag+"P"+"_DI"
_use(_zb,"E!")
zap
use
SORTUJ(_zb,_i1,"RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK")
SORTUJ(_zb,_i2,"dtos(DATA_DOK)+s_i(INDEKS)")

if file("SP"+_nr_mag+".DBF")
  _zb="SP"+_nr_mag+".DBF"
  _i1="SP"+_nr_mag+"_I"
  _i2="SP"+_nr_mag+"_N"
  _k1:="s_i(INDEKS)"
  _k2:="NAZWA_TOW"
  _use(_zb,"E!")
  zap
  use
  SORTUJ(_zb,_i1,_k1)
  SORTUJ(_zb,_i2,_k2)

  sele 0
  _use("SP"+_nr_mag,"F!")
  repl all MAGAZYN with _nr_mag
  use
endi
@ 23,0 clea to 23,79
SORTUJ()
END SEQUENCE

PASEK()
RETU NIL
#endi

*******************************************************************************
FUNCTION KASUJ_DOK(_nrm,_rdk)
local _tex,_zb,_i1,_k1,_i2,_k2,_i3,_k3,_i4,_k4,_dokument:="  -     /   /  ",;
      _typ_dok:="?",_err:=.f.,_zapis:=.t.,_nr_cen_spr:=" ",_nr_cen_prz:=" "
local zapisal:=.f.,_rodz_dok:=""                                     //08.05.99
local _firany:="",_astru:={}                                  //12.09.14 BAFPOL

cls
_tex:='۲  KASOWANIE DOKUMENTU  '
@ 0,0 say _tex

DEFAULT _nrm TO "   ",;
        _rdk TO ""

_nr_mag:=_nrm

BEGIN SEQUENCE

sele 0
if !_use("SL_DOK","R"); BREAK; endif
set index to SL_DOK

sele 0
if !_use("SL_MAG","R"); BREAK; endif
set index to SL_MAG


@ 1,0 say "Numer magazynu :      " get _nr_mag pict "999";
           when SLGET("SL_MAG","SL_MAG","V1",1,1,;
           {"nr magazynu"},,.f.,BEZBLOK);
           valid (SZ().and.SL("SL_MAG","SL_MAG","V1",1,1))
set curs on; read; SLGET(); set curs off
if lastkey()=K_ESC; _err:=.t.; BREAK; endi

if _bierny="T".or._bierny="X".or.;
   (!empty(subs(_wersja,87,1)).and.val(subs(_wersja,87,1))>=_priorytet.and.;
    _nr_mag<>_magazyn)
   QKE ("Operator nieupowaniony do anulowania dokumentw.")
   _err:=.t.
   break
endi

*_dokument:="  -     /"+_nr_mag+ "/"+_rok
_dokument:="  -     /"+_nr_mag+ "/"+subs(dtos(date()),3,2)           //28.07.01
if !empty(_rdk)
  _dokument:=_rdk+"-     /"+_nr_mag+ "/"+subs(dtos(date()),3,2)
endi
@ 2,0 say "Rodzaj/nr/magazyn/rok " get _dokument pict "@! AA-99999/999/99";
     vali subs(_dokument,10,3)==_nr_mag.and.if(empty(_rdk),.t.,_dokument=_rdk)

set curs on; read; set curs off
if lastkey()=K_ESC; _err:=.t.; BREAK; endi

_rodz_dok:=subs(_dokument,1,2)

sele SL_DOK
seek subs(_dokument,1,2)
if eof()
  QKE("Nie ma dokumentu "+subs(_dokument,1,2)+" !")
  _err:=.t.
  BREAK
else
 _typ_dok:=TYP_DOK
endi


if _typ_dok="+"
  QKE("UWAGA : Anulowanie dokumentu przychodu lub przesunicia moe",;
      "        spowodowa powstanie stanw ujemnych w magazynie !  ")
endi

sele 0
_zb:="DOK"+_nr_mag+"N"
_i1:="D"+_nr_mag+"N"+"_NR"
_i2:="D"+_nr_mag+"N"+"_RD"
if !_use(_zb,"E","DOK_N_1"); _err:=.t.; BREAK; endi
set index to (_i1),(_i2)
seek subs(_dokument,1,2)+subs(_dokument,10,3)+ep(subs(_dokument,14,2));  //!
    +subs(_dokument,4,5)
if !found()
  QKE("Nie ma takiego dokumentu !")
  _err:=.t.
  BREAK
endi

if subs(_dokument,1,2)=="WZ".and. AUTO="T"
  QKE("Dokument WZ mona anulowa tylko poprzez anulowanie ";
       +RODZAJ_FAK+"-"+NR_FAK+"/"+SERIA_FAK+"/"+right(ROK_FAK,2) +" !")  //!
  _err:=.t.
  BREAK
elseif subs(_dokument,1,2)=="WZ".and. AUTO<>"T" .and. !empty(NR_FAK)
  QKE("Dokument WZ mona anulowa tylko po uprzednim anulowaniu ";
       +RODZAJ_FAK+"-"+NR_FAK+"/"+SERIA_FAK+"/"+right(ROK_FAK,2) +" !")  //!
  _err:=.t.
  BREAK
elseif ! DOK_N_1->DATA_DOK > _data_blo
   
  QKE("Dokumentu z t dat nie mona anulowa !")
  _err:=.t.
  BREAK
endi

if subs(_wersja,149,1)="L".and.fieldpos("LAPTOP")>0.and.LAPTOP="*"
   QKE("Dokument mona anulowa tylko w centrali !")
   _err:=.t.
   break
endi

if subs(_wersja,149,1)="C".and.fieldpos("LAPTOP")>0.and.LAPTOP="+"
   QKE("Dokument mona anulowa tylko na laptopie !")
   _err:=.t.
   break
endi

_do_mag:=DO_MAG
_nr_cen_spr:=CENNIK_S
_nr_cen_prz:=CENNIK_P

if !HA(_haslo); _err:=.t.; BREAK; endi

QPC(1)

sele 0
if !_use("DOK_T","F"); _err:=.t.; BREAK; endi
set index to DOK_T_NR, DOK_T_DA


sele 0                                                    // wytworzenie zapisu
if !_use("TOW","R"); _err:=.t.; BREAK; endi
set index to TOW_IN

sele 0                                                        //12.09.14 BAFPOL
if !_use("FIRANY","S","MFIRAN"); BREAK; endi                    
set index to FIRANY_I,;        //s_i(INDEKS)+str(KLASA,3)
             FIRANY_N          //NAZWA_TOW+str(KLASA,3)
set rela to s_i(INDEKS) into TOW

sele 0
_zb:="DOK"+_nr_mag+"P"
_i1:="D"+_nr_mag+"P"+"_NR"
_i2:="D"+_nr_mag+"P"+"_DI"
if !_use(_zb,"E","DOK_P_1"); _err:=.t.; BREAK; endi
set index to (_i1),(_i2)

sele 0
if !_use("MAG"+_nr_mag,"F","MAG_1"); _err:=.t.; BREAK; endi
_i1:="M"+_nr_mag+"_IP"
_i2:="M"+_nr_mag+"_N"
_i3:="M"+_nr_mag+"_IP0"
_i4:="M"+_nr_mag+"_N0"
* set rela to s_i(INDEKS) into TOW    //01.11
set inde to (_i1),(_i2),(_i3),(_i4)

if _typ_dok=" ".and.!empty(_do_mag)

  sele 0
  _zb:="DOK"+_do_mag+"N"
  _i1:="D"+_do_mag+"N"+"_NR"
  _i2:="D"+_do_mag+"N"+"_RD"
  if !_use(_zb,"E","DOK_N_2"); _err:=.t.; BREAK; endi
  set index to (_i1),(_i2)

  sele 0
  _zb:="DOK"+_do_mag+"P"
  _i1:="D"+_do_mag+"P"+"_NR"
  _i2:="D"+_do_mag+"P"+"_DI"
  if !_use(_zb,"E","DOK_P_2"); _err:=.t.; BREAK; endi
  set index to (_i1),(_i2)

  sele 0
  if !_use("MAG"+_do_mag,"F","MAG_2"); _err:=.t.; BREAK; endi
  _i1:="M"+_do_mag+"_IP"
  _i2:="M"+_do_mag+"_N"
  _i3:="M"+_do_mag+"_IP0"
  _i4:="M"+_do_mag+"_N0"
  * set rela to s_i(INDEKS) into TOW    //01.11
  set inde to (_i1),(_i2),(_i3),(_i4)
endi

*----------------------------------------------- sprawdzenie stanw  //28.07.01
if _typ_dok="+"

  sele 0
  _astru:={}
  aadd(_astru,{"INDEKS"     ,"C",LENIN, 0})
  aadd(_astru,{"NAZWA_TOW"  ,"C",max(40,_len_naz), 0})
  aadd(_astru,{"OPIS_TOW"   ,"C",max(20,_len_opi), 0})
  aadd(_astru,{"CENA_ZAK"   ,"N",12, 2})
  aadd(_astru,{"DATA_DOS"   ,"D", 8, 0})
  aadd(_astru,{"JM"         ,"C", 4, 0})
  aadd(_astru,{"VAT"        ,"C", 2, 0})
  aadd(_astru,{"ILOSC"      ,"N",12, 3})
  aadd(_astru,{"STAN"       ,"N",12, 3})
  aadd(_astru,{"STAN_B"     ,"N",12, 3})
  dbcreate ((_sc+"UJEMNE"),_astru)
  if !_use(_sc+"UJEMNE","E"); BREAK; endi

  sele DOK_P_1
  if _rozchody="1"
    set rela to s_i(INDEKS)+s_c(CENA_ZAK) into MAG_1
  else
    set rela to s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK) into MAG_1
  endi
  seek subs(_dokument,1,2)+subs(_dokument,10,3)+ep(subs(_dokument,14,2))+;
       subs(_dokument,4,5)
  dbeval({|| TOW->(dbseek(s_i(DOK_P_1->INDEKS))),;
             UJEMNE->(dbappend()),;
             UJEMNE->INDEKS   :=DOK_P_1->INDEKS,;
             UJEMNE->NAZWA_TOW:=TOW->NAZWA_TOW,;
             UJEMNE->OPIS_TOW :=TOW->OPIS_TOW,;
             UJEMNE->CENA_ZAK :=DOK_P_1->CENA_ZAK,;
             UJEMNE->DATA_DOS :=DOK_P_1->DATA_DOS,;
             UJEMNE->JM       :=TOW->JM,;
             UJEMNE->VAT      :=TOW->VAT,;
             UJEMNE->ILOSC    :=DOK_P_1->ILOSC,;
             UJEMNE->STAN     :=MAG_1->STAN,;
             UJEMNE->STAN_B   :=MAG_1->STAN_B },;
         {|| MAG_1->(STAN-STAN_B)-DOK_P_1->ILOSC<0 },;
         {|| RODZAJ_DOK==subs(_dokument,1,2).and.;
             NR_DOK==subs(_dokument,4,5).and.;
             NR_MAG==subs(_dokument,10,3).and.;
             ROK_DOK==ep(subs(_dokument,14,2)) })

  set rela to

  sele UJEMNE
  if lastrec()>0
    _okno:=savescreen(3,0,24,79)
    @ 3,0 clea to 24,79
    @ 4,0 say "NA NASTPUJCYCH POZYCJACH MAGAZYNOWYCH POWSTAN STANY UJEMNE :"
    go top
    CPEDIT POZ: 5,,23,        ;
           DEF: "POZ_UJE"     ;
           POZWER: "V1"       ;
           PION: ,,,          ;
           INDEXY: {}         ;
           ODTWORZ: .f.

    go top
    CPDRUK DEF: "POZ_UJE"      ;
           WERSJA: "VR"        ;
           TYTUL: "DOKUMENT "+_dokument+" - pozycje brakujce" ;
           WARIANT: 40

    restscreen(3,0,24,79,_okno)
    close UJEMNE
    dele file (_sc+"UJEMNE.DBF")

    if !QTN("Kontynuacja anulowania dokumentu pomimo powstania stanw ujemnych ?")
      _err:=.t.
      BREAK
    endi
  else
    close UJEMNE
    dele file (_sc+"UJEMNE.DBF")
  endi
endi
*------------------------------------------------------------------------------

sele DOK_N_1
seek subs(_dokument,1,2)+subs(_dokument,10,3)+ep(subs(_dokument,14,2))+;
     subs(_dokument,4,5)    

_firany:=DOK_N_1->FIRANY                                      //12.09.14 BAFPOL
                                 //!
copy to (_sc+"D"+strtran(subs(_dokument,1,2)," ","_")+"_N_RR") while;
           RODZAJ_DOK==subs(_dokument,1,2).and.;
           NR_DOK==subs(_dokument,4,5).and.;
           NR_MAG==subs(_dokument,10,3).and.;
           ROK_DOK==ep(subs(_dokument,14,2))                 //!
seek subs(_dokument,1,2)+subs(_dokument,10,3)+ep(subs(_dokument,14,2))+;
     subs(_dokument,4,5)                                     //!
dele while RODZAJ_DOK==subs(_dokument,1,2).and.;
           NR_DOK==subs(_dokument,4,5).and.;
           NR_MAG==subs(_dokument,10,3).and.;
           ROK_DOK==ep(subs(_dokument,14,2))                 //!
use

sele DOK_P_1
seek subs(_dokument,1,2)+subs(_dokument,10,3)+ep(subs(_dokument,14,2))+;
     subs(_dokument,4,5)                                     //!
copy to (_sc+"D"+strtran(subs(_dokument,1,2)," ","_")+"_P_RR") while;
           RODZAJ_DOK==subs(_dokument,1,2).and.;
           NR_DOK==subs(_dokument,4,5).and.;
           NR_MAG==subs(_dokument,10,3).and.;
           ROK_DOK==ep(subs(_dokument,14,2))                 //!
seek subs(_dokument,1,2)+subs(_dokument,10,3)+ep(subs(_dokument,14,2))+;
     subs(_dokument,4,5)                                     //!
dele while RODZAJ_DOK==subs(_dokument,1,2).and.;
           NR_DOK==subs(_dokument,4,5).and.;
           NR_MAG==subs(_dokument,10,3).and.;
           ROK_DOK==ep(subs(_dokument,14,2))                 //!
use

if _typ_dok=" ".and.!empty(_do_mag)

  sele DOK_N_2
  seek subs(_dokument,1,2)+subs(_dokument,10,3)+ep(subs(_dokument,14,2))+;
     subs(_dokument,4,5)                                     //!
  dele while RODZAJ_DOK==subs(_dokument,1,2).and.;
             NR_DOK==subs(_dokument,4,5).and.;
             NR_MAG==subs(_dokument,10,3).and.;
             ROK_DOK==ep(subs(_dokument,14,2))               //!
  use

  sele DOK_P_2
  seek subs(_dokument,1,2)+subs(_dokument,10,3)+ep(subs(_dokument,14,2))+;
     subs(_dokument,4,5)                                     //!
  dele while RODZAJ_DOK==subs(_dokument,1,2).and.;
             NR_DOK==subs(_dokument,4,5).and.;
             NR_MAG==subs(_dokument,10,3).and.;
             ROK_DOK==ep(subs(_dokument,14,2))               //!
  use
endi
*---------------

sele DOK_T
seek subs(_dokument,1,2)+subs(_dokument,10,3)+ep(subs(_dokument,14,2))+;
     subs(_dokument,4,5)                                     //!
  if found()
    TONE(440,1)
    QK("Uwaga! Dodatkowa tre nie jest przekazywana do dokumentu w zapisie!")
    dele while RODZAJ_DOK==subs(_dokument,1,2).and.;
             NR_DOK==subs(_dokument,4,5).and.;
             NR_MAG==subs(_dokument,10,3).and.;
             ROK_DOK==ep(subs(_dokument,14,2))               //!
 endi 
use

                                                          // wytworzenie zapisu
sele 0
_use("QDOKN","R!")
copy stru to (_sc+"D"+strtran(subs(_dokument,1,2)," ","_")+"_N_R")

_use("QDOKP","R!")
copy stru to (_sc+"D"+strtran(subs(_dokument,1,2)," ","_")+"_P_R")
use

_use(_sc+"D"+strtran(subs(_dokument,1,2)," ","_")+"_N_R","E!")
appe from (_sc+"D"+strtran(subs(_dokument,1,2)," ","_")+"_N_RR")

if !file("DOK_I.DBF")
  copy stru to DOK_I
endi

_use("DOK_I","E!")
appe from (_sc+"D"+strtran(subs(_dokument,1,2)," ","_")+"_N_RR")
repl UWAGI with dtoc(date())+" "+_operator+" "+UWAGI
dele file (_sc+"D"+strtran(subs(_dokument,1,2)," ","_")+"_N_RR.DBF")

_use(_sc+"D"+strtran(subs(_dokument,1,2)," ","_")+"_P_R","E!")
appe from (_sc+"D"+strtran(subs(_dokument,1,2)," ","_")+"_P_RR")
set rela to s_i(INDEKS) into TOW
repl all JM with TOW->JM,;
            NAZWA_TOW with TOW->NAZWA_TOW,;
            OPIS_TOW with TOW->OPIS_TOW,;
            GRUPA_TOW with TOW->GRUPA_TOW,;
            OPAKOWANIE with max(TOW->OPAKOWANIE,0),;
            SWW with TOW->SWW,;
            ZNAK with if(_typ_dok="-",-1,1),;
            CENA_1 with TOW->CENA_1,;
            CENA_2 with TOW->CENA_2,;
            CENA_3 with TOW->CENA_3,;
            USLUGA with TOW->USLUGA
do case                                                   //01.11
  case _nr_cen_spr="1"; repl all CENA_CEN_S with ;
        iif(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
  case _nr_cen_spr="2"; repl all CENA_CEN_S with ;
        iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
  case _nr_cen_spr="3"; repl all CENA_CEN_S with ;
        iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
endc
do case                                                     //01.11
  case _nr_cen_prz="1"; repl all CENA_CEN_P with TOW->CENA_1
  case _nr_cen_prz="2"; repl all CENA_CEN_P with TOW->CENA_2
  case _nr_cen_prz="3"; repl all CENA_CEN_P with TOW->CENA_3
endc
use

if select("MFIRAN")>0                                         //12.09.14 BAFPOL

  CPClose(FIRANY)
  dele file (_sc+"FIRANY.DBF")

  sele 0
  _astru:={}
  aadd(_astru,{"INDEKS    ","C",20,0})
  aadd(_astru,{"NAZWA_TOW ","C",30,0})
  aadd(_astru,{"OPIS_TOW  ","C",20,0})
  aadd(_astru,{"JM        ","C", 4,0})
  aadd(_astru,{"KLASA   ","N", 3,0})
  aadd(_astru,{"STAN      ","N", 4,0})
  dbcreate(_sc+"FIRANY",_astru)

  _use(_sc+"FIRANY","E!")
  inde on s_i(INDEKS)+str(KLASA,3)              to (_sc+"FIRA_I")
  set inde to (_sc+"FIRA_I")
  set rela to s_i(INDEKS) into TOW
//@@@

  for _i:=1 to MLCount(_firany)
    _fir:=MemoLine(_firany,,_i)
    FIRANY->(dbappend())
    FIRANY->INDEKS:=s_i(alltrim(subs(_fir,1,at(";",_fir)-1)))
    _fir:=subs(_fir,at(";",_fir)+1)
    FIRANY->KLASA:=val(_fir) 
    _fir:=subs(_fir,at(";",_fir)+1)
    FIRANY->STAN:=val(_fir)
  next

  QK("AKTUALIZACJA MAGAZYNU FIRAN")

  _znakf:=0.0
  do case
    case (_nr_mag="001".and._typ_dok="+").or.(_do_mag="001".and._typ_dok=" ")
      _znakf:=1.0
    case (_nr_mag="001".and._typ_dok$"- ")
      _znakf:=-1.0
  endc

  sele MFIRAN
  FLOCK()

  sele FIRANY
  go top
  do while !eof()

    sele MFIRAN
    dbseek(s_i(FIRANY->INDEKS)+str(FIRANY->KLASA,3))
    if eof()
      MFIRAN->(dbappend())   
      MFIRAN->INDEKS:=s_i(FIRANY->INDEKS)
      MFIRAN->KLASA:=FIRANY->KLASA
      DAJ_F()
    endi
    MFIRAN->STAN+=-1*_znakf*FIRANY->STAN

    sele FIRANY 
    skip
  endd  
  MFIRAN->(dbunlock())
  
endi
CPClose(FIRANY)
CPCLose(MFIRAN)
                                                    // uzgodnienie magazynu(w)
sele 0
_zb:=_sc+"D"+strtran(subs(_dokument,1,2)," ","_")+"_P_RR.DBF"
_use (_zb,"E!","POZ")

do while !eof()
  do case
    case _rozchody="1"
      _k1:=s_i(INDEKS)+s_c(CENA_ZAK)
    case _rozchody="2"
      _k1:=s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK)
  endcase

  sele MAG_1
  set rela to s_i(INDEKS) into TOW        //01.11
  seek _k1
  repl STAN with STAN+if(POZ->ZNAK=1,-(POZ->ILOSC),POZ->ILOSC)

  sele POZ
  skip
enddo
close MAG_1

if _typ_dok=" ".and.!empty(_do_mag)

  sele POZ
  go top
  do while !eof()
    do case
      case _rozchody="1"
        _k1:=s_i(INDEKS)+s_c(CENA_ZAK)
      case _rozchody="2"
        _k1:=s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK)
    endcase

    sele MAG_2
    set rela to s_i(INDEKS) into TOW               //01.11
    seek _k1
    repl STAN with STAN+if(POZ->ZNAK=1,POZ->ILOSC,-(POZ->ILOSC))

    sele POZ                                     // ! dok z _nr_mag
    skip
  enddo
  close MAG_2
endi
close POZ

if file("DOK_IP.DBF")                                                //08.09.03
  _use("DOK_IP","E!")
  appe from (_zb)           
  use
endi

QPC(0)

END SEQUENCE
clos data

*------------------------------------------------------------------- //08.05.99
_zapisal:=.f.
_rodz:=subs(alltrim(_rodz_dok)+"__",1,2)
for i:=1 to 99
   _nr:=trans0(i,2)
   if !file(_sc+_rodz+_nr_mag+"N"+_nr+".DBF").and.;
      !file(_sc+_rodz+_nr_mag+"P"+_nr+".DBF")
     _zapisal:=.t.
    rena (_sc+"D"+_rodz+"_N_R.DBF") to;
         (_sc+_rodz+_nr_mag+"N"+_nr+".DBF")
    if file(_sc+"D"+_rodz+"_N_R.DBT")
      rena (_sc+"D"+_rodz+"_N_R.DBT") to;
           (_sc+_rodz+_nr_mag+"N"+_nr+".DBT")
    endi
    rena (_sc+"D"+_rodz+"_P_R.DBF") to;
         (_sc+_rodz+_nr_mag+"P"+_nr+".DBF")
    exit
  endif
next
if !_zapisal
  _nr:="00"
  dele file (_sc+_rodz+_nr_mag+"N"+_nr+".DBF")
  dele file (_sc+_rodz+_nr_mag+"N"+_nr+".DBT")
  dele file (_sc+_rodz+_nr_mag+"P"+_nr+".DBF")

  rena (_sc+"D"+_rodz+"_N_R.DBF") to;
         (_sc+_rodz+_nr_mag+"N"+_nr+".DBF")
  if file(_sc+"D"+_rodz+"_N_R.DBT")
    rena (_sc+"D"+_rodz+"_N_R.DBT") to;
           (_sc+_rodz+_nr_mag+"N"+_nr+".DBT")
  endi
  rena (_sc+"D"+_rodz+"_P_R.DBF") to;
         (_sc+_rodz+_nr_mag+"P"+_nr+".DBF")
  QKE("      Wykonano zapis awaryjny !      ",;
        "Wyczerpany limit liczby zapisw (99).")
endif
*------------------------------------------------------------------------------

clos data
dele file (_sc+"D"+strtran(subs(_dokument,1,2)," ","_")+"_P_RR.DBF")
if _err
  QKE("Nie wykonano anulowania dokumentu !")
else
  QKE("Wykonano anulowanie dokumentu !")
endi
RETURN  NIL

*******************************************************************************
FUNCTION KASUJ_PAR()
local _tex,_zb,_i1,_k1,_i2,_k2,_i3,_k3,_i4,_k4,_dokument:="  -     /   /  ",;
      _typ_dok:="-",_err:=.f.,_zapis:=.t.,_nr_cen_spr:=" ",_nr_cen_prz:=" "
priv  _nr_dok:="     ",_nr_mag:="   "

cls
_tex:='۲  KASOWANIE PARAGONU  '
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use("SL_DOK","R"); BREAK; endif
set index to SL_DOK
seek "PA"
if eof().or.TYP_DOK<>"-"
  QKE("Niewaciwa definicja paragonu !")
  BREAK
endi
clos SL_DOK


sele 0
if !_use("SL_MAG","R"); BREAK; endif
set index to SL_MAG

_nr_mag:=_magazyn
@ 1,0 say "Numer magazynu : " get _nr_mag pict "999";
           when SLGET("SL_MAG","SL_MAG","V1",1,1,;
           {"nr magazynu"},,.f.,BEZBLOK);
           valid (SZ().and.SL("SL_MAG","SL_MAG","V1",1,1))
set curs on; read; SLGET(); set curs off
if lastkey()=K_ESC; BREAK; endi

_dokument:="PA-     /"+_nr_mag+ "/"+_rok
@ 2,0 say "Numer paragonu : " get _nr_dok pict "99999" vali SZ()
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

_dokument:="PA-"+_nr_dok+"/"+_nr_mag+ "/"+_rok



sele 0
_zb:="DOK"+_nr_mag+"N"
_i1:="D"+_nr_mag+"N"+"_NR"
_i2:="D"+_nr_mag+"N"+"_RD"
if !_use(_zb,"F","DOK_N_1"); _err:=.t.; BREAK; endi
set index to (_i1),(_i2)
seek subs(_dokument,1,2)+subs(_dokument,10,3)+ep(subs(_dokument,14,2));  //!
    +subs(_dokument,4,5)
if !found()
  QKE("Nie ma paragonu o podanym numerze !")
  _err:=.t.
  BREAK
endi
if DATA_DOK<>date()
  QKE("Nie mona anulowa paragonu z dat "+dtoc(DATA_DOK)+"!")
  _err:=.t.
  BREAK
endi

_nr_cen_spr:=CENNIK_S
_nr_cen_prz:=CENNIK_P

if !HA(_haslo); _err:=.t.; BREAK; endi

QPC(1)

sele 0                                                    // wytworzenie zapisu
if !_use("TOW","R"); _err:=.t.; BREAK; endi
set index to TOW_IN

sele 0
_zb:="DOK"+_nr_mag+"P"
_i1:="D"+_nr_mag+"P"+"_NR"
_i2:="D"+_nr_mag+"P"+"_DI"
if !_use(_zb,"F","DOK_P_1"); _err:=.t.; BREAK; endi
set index to (_i1),(_i2)

sele 0
if !_use("MAG"+_nr_mag,"F","MAG_1"); _err:=.t.; BREAK; endi
_i1:="M"+_nr_mag+"_IP"
_i2:="M"+_nr_mag+"_N"
_i3:="M"+_nr_mag+"_IP0"
_i4:="M"+_nr_mag+"_N0"
* set rela to s_i(INDEKS) into TOW    // 01.11
set inde to (_i1),(_i2),(_i3),(_i4)

sele DOK_N_1
seek subs(_dokument,1,2)+subs(_dokument,10,3)+ep(subs(_dokument,14,2));  //!
    +subs(_dokument,4,5)

INFO_LOG("Anulowanie dokumentu "+_dokument,"DOK_N_1")                //03.09.02

copy to (_sc+"D"+subs(_dokument,1,2)+"_N_RR") while;
           RODZAJ_DOK==subs(_dokument,1,2).and.;
           NR_DOK==subs(_dokument,4,5).and.;
           NR_MAG==subs(_dokument,10,3).and.;
           ROK_DOK==ep(subs(_dokument,14,2))  //!
seek subs(_dokument,1,2)+subs(_dokument,10,3)+ep(subs(_dokument,14,2));  //!
    +subs(_dokument,4,5)
dele while RODZAJ_DOK==subs(_dokument,1,2).and.;
           NR_DOK==subs(_dokument,4,5).and.;
           NR_MAG==subs(_dokument,10,3).and.;
           ROK_DOK==ep(subs(_dokument,14,2))  //!
use

sele DOK_P_1
seek subs(_dokument,1,2)+subs(_dokument,10,3)+ep(subs(_dokument,14,2));  //!
    +subs(_dokument,4,5)
copy to (_sc+"D"+subs(_dokument,1,2)+"_P_RR") while;
           RODZAJ_DOK==subs(_dokument,1,2).and.;
           NR_DOK==subs(_dokument,4,5).and.;
           NR_MAG==subs(_dokument,10,3).and.;
           ROK_DOK==ep(subs(_dokument,14,2))  //!
seek subs(_dokument,1,2)+subs(_dokument,10,3)+ep(subs(_dokument,14,2));  //!
    +subs(_dokument,4,5)
dele while RODZAJ_DOK==subs(_dokument,1,2).and.;
           NR_DOK==subs(_dokument,4,5).and.;
           NR_MAG==subs(_dokument,10,3).and.;
           ROK_DOK==ep(subs(_dokument,14,2))  //!
use

sele 0
_use("QDOKN","R!")
copy stru to (_sc+"D"+subs(_dokument,1,2)+"_N_R")

_use("QDOKP","R!")
copy stru to (_sc+"D"+subs(_dokument,1,2)+"_P_R")
use

_use(_sc+"D"+subs(_dokument,1,2)+"_N_R","E!")
appe from (_sc+"D"+subs(_dokument,1,2)+"_N_RR")
dele file (_sc+"D"+subs(_dokument,1,2)+"_N_RR.DBF")
use

_use(_sc+"D"+subs(_dokument,1,2)+"_P_R","E!")
appe from (_sc+"D"+subs(_dokument,1,2)+"_P_RR")
set rela to s_i(INDEKS) into TOW
repl all JM with TOW->JM,;
            NAZWA_TOW with TOW->NAZWA_TOW,;
            OPIS_TOW with TOW->OPIS_TOW,;
            GRUPA_TOW with TOW->GRUPA_TOW,;
            OPAKOWANIE with max(TOW->OPAKOWANIE,0),;
            SWW with TOW->SWW,;
            ZNAK with if(_typ_dok="-",-1,1),;
            CENA_1 with TOW->CENA_1,;
            CENA_2 with TOW->CENA_2,;
            CENA_3 with TOW->CENA_3,;
            USLUGA with TOW->USLUGA
do case                                                   //01.11
  case _nr_cen_spr="1"; repl all CENA_CEN_S with ;
        iif(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
  case _nr_cen_spr="2"; repl all CENA_CEN_S with ;
        iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
  case _nr_cen_spr="3"; repl all CENA_CEN_S with ;
        iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
endc
do case                                                     //01.11
  case _nr_cen_prz="1"; repl all CENA_CEN_P with TOW->CENA_1
  case _nr_cen_prz="2"; repl all CENA_CEN_P with TOW->CENA_2
  case _nr_cen_prz="3"; repl all CENA_CEN_P with TOW->CENA_3
endc
use

                                                        // uzgodnienie magazynu
sele 0
_zb:=_sc+"D"+subs(_dokument,1,2)+"_P_RR.DBF"
_use (_zb,"E!","POZ")

do while !eof()
  do case
    case _rozchody="1"
      _k1:=s_i(INDEKS)+s_c(CENA_ZAK)
    case _rozchody="2"
      _k1:=s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK)
  endcase

  sele MAG_1
  set rela to s_i(INDEKS) into TOW        //01.11
  seek _k1
  repl STAN with STAN+if(POZ->ZNAK=1,-(POZ->ILOSC),POZ->ILOSC)

  sele POZ
  skip
enddo
close MAG_1
close POZ

QPC(0)

END SEQUENCE
clos data
dele file (_sc+"D"+subs(_dokument,1,2)+"_P_RR.DBF")
if _err
  QKE("Nie wykonano anulowania paragonu !")
else
  QKE("Wykonano anulowanie paragonu !")
endi
RETURN  NIL

*******************************************************************************
FUNCTION SPR95()
#ifdef M
 cls; QK("Opcja dostpna w penej wersji programu !"); RETURN NIL
#else
local _tex:=;
   "۲  PRZENIESIENIE FAKTUR NIEROZLICZONYCH  ",;
      _kat95:="C:\MEGAVAT"+spac(12), _adir:={},_form_w95,_form_c95,;
      _form_w96,_form_c96,war95,cen95,totu:=diskname()+":\"+curdir(),;
      _data_do:=ctod("31.12."+str(year(date())-1901,2))
cls

BEGIN SEQUENCE

@ 0,0 say _tex

if !QTN_2W(;
"Podstaw selekcji faktur jest stan rozrachunkw na koniec podanego okresu.",;
"Naleao wyliczy ten stan w programie rdowym. Kontynuacja ?")
  BREAK
endif

@ 2,0 say;
"Program przeniesienia faktur nierozliczonych :"
@ 4,0 say;
"- kasuje w biecym katalogu nagwki sprzeday i zapaty za sprzeda"
@ 5,0 say;
"  z podanego okresu,"
@ 6,0 say;
"- kopiuje  z katalogu rdowego nagwki faktur i rachunkw nierozliczonych"
@ 7,0 say;
"  z podanego okresu,"
@ 8,0 say;
"- wytwarza w zbiorze zapat zapisy odpowiadajce cznej zapacie"
@ 9,0 say;
"  za przeniesione faktury."


inkey(0)

@ 1,0 clea to 24,79

@ 2,0 say "Katalog rdowego programu MEGAVAT : " get _kat95 pict "@!" ;
         valid DIR_EXIST(alltrim(_kat95)) .and. !(alltrim(_kat95) == totu)
@ 3,0 say "Ostatni dzie poprzedniego okresu   : " get _data_do
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK;endif

if QTN(;
 "Wyliczono w programie rdowym stan rozrachunkw na dzie "+;
  dtoc(_data_do)+" ?");
 .and.HA(_haslo)
else ; BREAK; endi



_k95:=alltrim(_kat95)

if !file(_k95+"\SPR_N.DBF")
  tone(220,10)
  QKE("W podanym katalogu nie ma plikw programu MEGAVAT !")
  cls
  BREAK
endif

QPC(1)

sele 0
_use(_k95+"\SPR_N","E!")
copy to (_sc+"SPR95") for DLUG<>0.and.DATA_DOK<=_data_do
_use(_sc+"SPR95","E!")

sele 0
_use("SPR_N","E!")
dele all for DATA_DOK<=_data_do
pack

sele 0
_use("ZAP","E!")
dele all for DATA_ZAP<=_data_do.and.RODZAJ_DOK<>"DO"
pack

apom1:={1,2,3,4,5,6,7,8,9,27,28,29,30,31,32,33,37,38,39,40,41,42,43,44,47,50,51 }

sele SPR95
dbeval( {|| SPR_N->(dbappend()),;
            aeval(apom1,{|x| SPR_N->(fieldput(x,SPR95->(fieldget(x))))} ),;
            SPR_N->WART_ZAP:=SPR95->WART_ZAP,;
            SPR_N->WN      :=SPR95->DLUG,;
            SPR_N->UWAGI   :=;
            "Przeniesienie rozliczenia "+str(year(_data_do),4)+" r.",;
            SPR_N->AUTO    := "D",;
            if(SPR_N->WART_ZAP<>SPR_N->WN,(ZAP->(dbappend()),;
            ZAP->DATA_ZAP  := _data_do,;
            ZAP->AUTO      := "D",;
            ZAP->TYP_ZAP   := "I",;
            ZAP->NR_KON    := SPR95->NR_KON,;
            ZAP->WPLATA    := SPR_N->WART_ZAP-SPR_N->WN,;
            ZAP->RODZAJ_DOK:= SPR95->RODZAJ_DOK,;
            ZAP->SERIA_FAK := SPR95->SERIA_FAK,;
            ZAP->ROK_FAK   := SPR95->ROK_DOK,;
            ZAP->NR_FAK    := SPR95->NR_DOK,;
            ZAP->UWAGI     :=;
            "Przeniesienie rozliczenia "+str(year(_data_do),4)+" r.";
             ),NIL) })

close data

QPC(0)

dele file (_sc+"SPR95.DBF")

tone(880,8)

QKE("Wykonano przeniesienie nierozliczonej sprzeday !")
cls
INDEX_SPR()
INDEX_ZAP()
UZG_KON(.f.)
cls
END SEQUENCE

RETU NIL
#endi

*******************************************************************************
FUNCTION DOS95()
#ifdef M
 cls; QK("Opcja dostpna w penej wersji programu !"); RETURN NIL
#else
local _tex:=;
   "۲  PRZENIESIENIE DOSTAW NIEROZLICZONYCH  ",;
      _kat95:="C:\MEGAVAT"+spac(12), _adir:={},_form_w95,_form_c95,;
      _form_w96,_form_c96,war95,cen95,totu:=diskname()+":\"+curdir(),;
      _data_do:=ctod("31.12."+str(year(date())-1901,2))
cls

BEGIN SEQUENCE

@ 0,0 say _tex

if !QTN_2W(;
"Podstaw selekcji dostaw jest stan rozrachunkw na koniec podanego okresu.",;
"Naleao wyliczy ten stan w programie rdowym. Kontynuacja ?")
  BREAK
endif

@ 2,0 say;
"Program przeniesienia dostaw nierozliczonych :"
@ 4,0 say;
"- kasuje w biecym katalogu faktury od dostawcw i zapaty za dostawy"
@ 5,0 say;
"  z podanego okresu,"
@ 6,0 say;
"- kopiuje  z katalogu rdowego  dostawy nierozliczone z podanego okresu,"
@ 7,0 say;
"- wytwarza w zbiorze zapat zapisy odpowiadajce cznej zapacie"
@ 8,0 say;
"  za przeniesione dostawy."

inkey(0)

@ 1,0 clea to 24,79

@ 2,0 say "Katalog programu MEGAVAT '95 : " get _kat95 pict "@!" ;
         valid DIR_EXIST(alltrim(_kat95)) .and. !(alltrim(_kat95) == totu)
@ 3,0 say "Ostatni dzie poprzedniego okresu   : " get _data_do
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK;endif

if QTN(;
 "Wyliczono w programie rdowym stan rozrachunkw na dzie "+;
  dtoc(_data_do)+" ?");
 .and.HA(_haslo)
else ; BREAK; endi

_k95:=alltrim(_kat95)

if !file(_k95+"\DOS_N.DBF")
  tone(220,10)
  QKE("W podanym katalogu nie ma plikw programu MEGAVAT !")
  cls
  BREAK
endif

QPC(1)

sele 0
_use(_k95+"\DOS_N","E!")
copy to (_sc+"DOS95") for DLUG<>0.and.DATA_WPL<=_data_do
_use (_sc+"DOS95","E!")

sele 0
_use("DOS_N","E!")
dele all for DATA_WPL<=_data_do
pack

sele 0
_use("ZAP","E!")
dele all for DATA_ZAP<=_data_do.and.RODZAJ_DOK=="DO"
pack

apom1:={1,2,3,4,5,6,7,8,9,10,11,12,13,14,24,25,27,28,29,31,32,34,35 }

sele DOS95
dbeval( {|| DOS_N->(dbappend()),;
            aeval(apom1,{|x| DOS_N->(fieldput(x,DOS95->(fieldget(x))))} ),;
            DOS_N->WART_B_DOS:=DOS95->WART_B_DOS,;
            DOS_N->MA      :=DOS95->DLUG,;
            DOS_N->UWAGI   :=;
            "Przeniesienie rozliczenia "+str(year(_data_do),4)+" r.",;
            if(DOS_N->WART_B_DOS<>DOS_N->MA,(ZAP->(dbappend()),;
            ZAP->DATA_ZAP  := _data_do,;
            ZAP->TYP_ZAP   := "I",;
            ZAP->NR_KON    := DOS95->NR_KON,;
            ZAP->WYPLATA   := DOS_N->WART_B_DOS-DOS_N->MA,;
            ZAP->RODZAJ_DOK:= "DO",;
            ZAP->ROK_DOS   := DOS95->ROK_DOS,;
            ZAP->NR_DOS    := DOS95->NR_DOS,;
            ZAP->UWAGI     :=;
            "Przeniesienie rozliczenia "+str(year(_data_do),4)+" r.";
             ),NIL) })

close data

QPC(0)

dele file (_sc+"DOS95.DBF")

tone(880,8)

QKE("Wykonano przeniesienie nierozliczonych dostaw !")
cls
INDEX_DOS()
INDEX_ZAP()
UZG_KON(.f.)
cls
END SEQUENCE

RETU NIL
#endi
FUNCTION COMPED()
#ifdef M
 cls; QK("Opcja dostpna w penej wersji programu !"); RETURN NIL
#else
local _okno_c:=savescreen(0,0,24,79)
local _wiersz_c:=row(),_kolumna_c:=col(),_kursor:=setcursor()

cls
setcursor(0)

@  1,8 to 24,71
@  3,12 say "        ZAKAD SZKOLENIA I WDRAANIA INFORMATYKI        "
@  4,12 say "                 C O M P E D  Sp. z o.o.                "
@  5,12 say "         ul. Legnicka 56 p. 204, 54-204 Wrocaw         "
@  6,12 say "                 tel./fax (071) 55-31-05                "

*           "--------------------------------------------------------"

@  8,12 say "              Firma istnieje od 1989 roku.              "
@  9,12 say "  Specjalizuje si w wytwarzaniu i wdraaniu programw  "
@ 10,12 say "komputerowych do obsugi informatycznej przedsibiorstw."
@ 11,12 say "Prowadzi szkolenia i kursy z zakresu obsugi komputerw."
@ 12,12 say " Zapewnia serwis oprogramowania i nadzr informatyczny. "

@ 13,12 say "             Szczeglnie polecamy systemy :             "

@ 15,12 say '              FINANSOWO-KSIGOWY  "BONUS"               '
@ 16,12 say '        OBSUGI HURTOWNI I SKLEPW  "MEGAVAT"           '
@ 17,12 say '            OBSUGI KAS FISKALNYCH  "INPOS"             '

@ 19,12 say "     We Wrocawiu bezpatne pokazy oprogramowania.      "

@ 21,12 say "Mamy nadziej, e spenimy Wasze yczenia i oczekiwania."
@ 22,12 say "           dyrektor dr in. Maciej Popkiewicz           "



inkey(0)

setcursor(_kursor)
restscreen(0,0,24,79,_okno_c)
devpos(_wiersz_c,_kolumna_c)
RETURN NIL
#endi

*******************************************************************************
FUNCTION SUFLER()
local _okno_c:=savescreen(0,0,24,79)
local _wiersz_c:=row(),_kolumna_c:=col(),_kursor:=setcursor()

cls
setcursor(0)

@ 1,8 to 24,71
*           "--------------------------------------------------------"
@ 3,12 say  "                      OPIS KLAWISZY                     "

@  5,12 say "F1  -  sufler"
@  6,12 say "F2  -  informacja"
@  7,12 say "Esc -  koniec"

@  9,12 say "Z   -  zmiana tabel nominaw lub kwoty do zapaty"
@ 10,12 say "X   -  skasowanie danych"
@ 11,12 say "C   -  skasowanie liczby"
@ 12,12 say "+   -  przejcie do tabeli nominaw wypaty"
@ 13,12 say "-   -  powrt do tabeli nominaw wpaty"
@ 14,12 say "*   -  zmiana stare/nowe nominay"
@ 15,12 say chr(26)+"   -  zmiana na nowe nominay"
@ 16,12 say chr(27)+"   -  zmiana na stare nominay"
@ 17,12 say chr(24)+"   -  wybr wyszego nominau lub kwota do zapaty"
@ 18,12 say chr(25)+"   -  wybr niszego nominau lub tabele nominaw"

@ 20,12 say "TAB -  specyfikacja nominaw kwoty do zapaty"
@ 21,12 say "       gdy tabele nominaw s puste"
@ 22,12 say "TAB -  specyfikacja nominaw dla dodatniej reszty"

inkey(0)

setcursor(_kursor)
restscreen(0,0,24,79,_okno_c)
devpos(_wiersz_c,_kolumna_c)
RETURN NIL

*******************************************************************************
FUNCTION KASUJ(_kw,_wp,_wy,_get,_i)
do case
  case _get=1
     _kw[2]:=0
  case _get=11
     _kw[3]:=0
  case _get=12
     _kw[4]:=0
  case _get=2
    _wp[if(_i<=14,15-_i,43-_i)]:=0
  case _get=3
    _wy[if(_i<=14,15-_i,43-_i)]:=0
endc
RETURN NIL
*******************************************************************************
FUNCTION DENO_END()
BREAK
RETURN NIL

*******************************************************************************
**************************** KONIEC DENOMINATORA ***************************************************
*******************************************************************************
FUNCTION TOW_INFO()
local getlist:={}, _okno,_cursor:=setcursor(),;
      _osele:=select(), _ocolo:=SET(_SET_COLOR,_ekra_blo),;
      _r:=row(),_c:=col(),_zb,_i1,;
      _out:=.f., _old_esc  :=set(_SET_ESCAPE,.t.),_pom,;
      g,d,_kij
local _pas_info:=0
local _colx:=subs(_ekra_blo,at(",",_ekra_blo)+1)
local _rtow,_ordtow,_scr24,_scropak
local _astany:={}
local _kk_info:="     "
local _tow_opak:=0.0
local _jm, _blo_all:=0

priv  _mag_info:=_magazyn,_indeks_info:=s_i(space(LENIN)),;
      _indeks_kop:=s_i(space(LENIN))
priv _wist_xml:=.f.

SHOWTIME()
g:=1
d:=23

 _okno:=savescreen(g,1,d,78)

set key K_ALT_I to
set key K_ALT_K to
set key K_ALT_J to
set key K_CTRL_J to

if used() .and. fieldpos("INDEKS")>0;_indeks_info:=s_i(INDEKS);endif

BEGIN SEQUENCE
_lcen:=len(_cenniki)
_pom:=len(transform(1.00,_format_cen))

sele 0
if !_use("TOW","R","TOWARY")
  BREAK
  _out:=.t.
endif
set inde to TOW_IN,TOW_NA,TOW_GR,TOW_SW  //03.05.98

@ g,1 clea to d,78
@ g,1,g+14,78 BOX R_GRUBA
@ g+15,1,d,78 BOX B_DOUBLE
@ g+14,3  say " opak.- PgUp "
@ g+14,23 say " blok.- B "
@ g+14,43 say " poz.mag.- P "
@ g+14,63 say " inne mag.- M "

@ g+1,3  say "Magazyn :" get _mag_info pict "@K 999" valid SZ1(@_mag_info).and.;
                       file("MAG"+trans0(val(_mag_info),3)+".DBF")
@ g+1,18 say "Indeks :" get  _indeks_info pict _format_ind ;
        when SLGET("TOWARY","TOW","V1",1,1,;
                {"indeks","nazwa","grupa",ORD4()},,.f.) ;
        vali  (_indeks_info=" ".or.SL("TOWARY","TOW","V1",1,1)) .and. SLGET()
if subs(_wersja,32,1)=="K"
  @ g+2,18 say "Kod :   " get _pas_info pict repl("9",13) when .f.
endi
set curs on;  read;  set curs off
if lastkey()=K_ESC; SLGET(); BREAK; endif

if _indeks_info=" "
* keyboard chr(K_CTRL_T)
  tone(880,1)

  sele 0
  _zb:="MAG"+trans0(val(_mag_info),3)
  _i1:="M"+trans0(val(_mag_info),3)+"_IP0"
* _i2:="M"+trans0(val(_mag_info),3)+"_N0"
  if !_use(_zb,"R","MAGAZYN");  BREAK; endif
  set inde to (_i1) //,(_i2)
  set rela to s_i(INDEKS) into TOWARY

  @ g+1,27 get  _indeks_info pict _format_ind when _pas_info=0.and.;
                SLGET("MAGAZYN","ITOW","V1",1,1,{"indeks"},,.f.) ;
          vali (_indeks_info=" ".or.EXIST(_indeks_info,"TOWARY",1)).and.SLGET()
  if subs(_wersja,32,1)=="K"
    @ g+2,18 say "Kod :   " get _pas_info pict repl("9",13);
                            when _indeks_info=" "
  endi
  set curs on; read; set curs off; SLGET()
  clos MAGAZYN
  if lastkey()=K_ESC.or.(_indeks_info=" ".and._pas_info=0); BREAK; endi
endi

if _pas_info>0                                                       //18.02.03
  TOWARY->(dbsetorder(4))
  TOWARY->(dbseek(_pas_info))
  if TOWARY->(!eof())

    _indeks_info:=s_i(TOWARY->INDEKS)
    @ g+1,18 say "Indeks :" get  _indeks_info pict _format_ind
    clea gets

  elseif file("KODY_PAS.DBF").and.file("KODY_K.NTX")

     sele 0
     if _use("KODY_PAS","R","KODY_INFO")
       set index to KODY_K
       if dbseek(_pas_info)
         TOWARY->(dbsetorder(1))
         TOWARY->(dbseek(KODY_INFO->(s_i(INDEKS))))
         _indeks_info:=s_i(TOWARY->INDEKS)
         close KODY_INFO

         @ g+1,27 say  _indeks_info pict _format_ind ;
                       COLOR _colx
       else
         QKE("Nieznany kod paskowy !")
         BREAK
       endi
     else
       BREAK
     endi
  else
    QKE("Nieznany kod paskowy !")
    BREAK
  endi
  TOWARY->(dbsetorder(1))
endi

sele TOWARY

TOWARY->(dbseek(s_i(_indeks_info)))
_wist_xml:=subs(TOWARY->USLUGA,3,1)=="S"
_jm:=TOWARY->JM

POKAZ_TOW(g,d,@_astany,@_blo_all)

do while (_kij:=inkey(0))<>K_ESC

  if _kij=K_PGUP

    BEGIN SEQUENCE
    sele 0
    if !_use("TOW","S","TOW_OPAK")
      BREAK
    endif
    set inde to TOW_IN,TOW_NA,TOW_GR,TOW_SW  //03.05.98


    TOW_OPAK->(dbseek(s_i(_indeks_info)))
    _tow_opak :=TOW_OPAK->OPAKOWANIE
    _scropak:=savescreen(g+13,3, g+13,37)
    @ g+13,3 clear to g+13,37
    @ g+13,3 say "Opak.:" get _tow_opak pict "@E 99999.9"
    set curs on; read; set curs off        
    if updated()
      TOW_OPAK->(RBLOK())
      repl TOW_OPAK->OPAKOWANIE with _tow_opak
    endi
    close TOW_OPAK    
    restscreen(g+13,3, g+13,37,_scropak)
    END SEQUENCE
  endi

  if (_kij==asc("P") .or. _kij=asc("p")) .and.len(_astany)>=1
    TONE(880,0.5)
    @ g+6,37 say chr(31)
    @ g+9,37 say chr(30)
    abrowse(@_astany,g+5,38,g+9,77)
    @ g+6,37 say " "
    @ g+9,37 say " "

  endi

  if (_kij==asc("b") .or. _kij=asc("B")) 
    TONE(880,0.5)
    BLOK_INFO(_mag_info,_indeks_info,g,d,_jm,_blo_all)
  endi

  if (_kij==asc("m") .or. _kij=asc("M")) 
    TONE(880,0.5)
    GDZIE_ST_I(_indeks_info)
  endi


  if _kij=K_SPACE
      IND_INFO(_indeks_info,_mag_info,g,d)
  endif

  if _kij=K_BS .and.;
      ( select("SPR_N_R")>0 .and. !empty(_kk_info:=SPR_N_R->NR_KON) .or.;
        select("DOKN_R")>0 .and. !empty(_kk_info:=DOKN_R->NR_KON))
      IND_INFO(_indeks_info,_mag_info,g,d,_kk_info)
  endif

  if _kij=K_TAB
      ZAM_INFO(_indeks_info,_mag_info,g,d)
  endif

  if _kij=K_CTRL_V
   BEGIN SEQUENCE
     _scr24:=savescreen(27,0,27,79)
     @ 24,0

     sele 0
     if !_use("TOW","R","TOW_KOP")
       BREAK
     endif
     set inde to TOW_IN,TOW_NA,TOW_GR,TOW_SW  //03.05.98
  
      _rtow:=TOW_KOP->(recn())
      _ordtow:=TOW_KOP->(indexord())
        
      @ 24,0 say "Indeks:" get  _indeks_kop pict _format_ind ;
          when SLGET("TOW_KOP","TOW","V1",1,1,;
                  {"indeks","nazwa","grupa",ORD4()},,.f.) ;
          vali  SL("TOW_KOP","TOW","V1",1,1) .and. SLGET() .and.;
                TRESC(_indeks_kop,"TOW_KOP","NAZWA_TOW")
      set curs on; read; set curs off
      if lastkey()=K_ESC;  close TOW_KOP; BREAK;    endi
//      @ 24, col()+2 say TOW_KOP->NAZWA_TOW
      inkey(2)
      TOW_KOP->(dbgoto(_rtow))
      TOW_KOP->(dbsetorder(_ordtow))
      close TOW_KOP
  
      sele 0
      if !_use("TOW_TXT","S");BREAK;endif
      set index to TOW_TXT
      if dbseek (_indeks_kop)
        _tkop:=TOW_TXT->TEKST
        if !dbseek (_indeks_info)
          APPE_BLOK()
          repl INDEKS with _indeks_info
        else
          RBLOK()
        endi
        tone(880,0.5)
        @ d,4 say repl(chr(205),74)
        @ d,4 say " zapis - Ctrl W "
        @ d,58 say " rezygnacja - Esc "
        set curs on
        repl TOW_TXT->TEKST with MEMOEDIT(TOW_TXT->TEKST+CRLF+;
                                _tkop,g+16,3,d-1,76,.t.)
        TOW_TXT->(dbcommit())
        if _wist_xml
          MOD_WIST("opis")
        endi
        set curs off
        @ d,4 say repl(chr(205),74)
        @ d,4 say " edycja - PgDn "
        @ d,38 say " skopiowanie z innego towaru - Ctrl V "
        tone(440,0.5)
      endi

    END SEQUENCE
    CpClose( TOW_TXT)
    restscreen(27,0,27,79,_scr24)
  endi

  if _kij=K_PGDN

    sele 0
    if _use("TOW_TXT","S")
      set index to TOW_TXT
      if !dbseek (_indeks_info)
        APPE_BLOK()
        repl INDEKS with _indeks_info
      else
        RBLOK()
      endi
      tone(880,0.5)
      @ d,4 say repl(chr(205),74)
      @ d,4 say " zapis - Ctrl W "
      @ d,58 say " rezygnacja - Esc "
      set curs on
      repl TOW_TXT->TEKST with MEMOEDIT(TOW_TXT->TEKST,g+16,3,d-1,76,.t.)
      TOW_TXT->(dbcommit())
      if _wist_xml
        MOD_WIST("opis")
      endi
      set curs off
      @ d,4 say repl(chr(205),74)
      @ d,4 say " edycja - PgDn "
      @ d,38 say " skopiowanie z innego towaru - Ctrl V "
      tone(440,0.5)
      close TOW_TXT
    endi
  endi

  if _kij=K_UP .or. _kij=K_DOWN .or. _kij=K_PLUS .or. _kij=K_MINUS

    sele 0
    if !_use("TOW","R","TOWARY")
      BREAK
      _out:=.t.
    endif
    set inde to TOW_IN,TOW_NA,TOW_GR

    TOWARY->(dbseek(s_i(_indeks_info)))

    if _kij=K_UP
      TOWARY->(dbskip(-1))
    elseif _kij=K_DOWN
      TOWARY->(dbskip(1))
    elseif _kij=K_MINUS
      TOWARY->(dbsetorder(2))
      TOWARY->(dbskip(-1))
      TOWARY->(dbsetorder(1))
    elseif _kij=K_PLUS
      TOWARY->(dbsetorder(2))
      TOWARY->(dbskip(1))
      TOWARY->(dbsetorder(1))
    else
    endif

    _indeks_info:=TOWARY->INDEKS
    TOWARY->(dbseek(s_i(_indeks_info)))
    _wist_xml:=subs(TOWARY->USLUGA,3,1)=="S"
    _jm:=TOWARY->JM
    POKAZ_TOW(g,d,@_astany,@_blo_all)
  endif
enddo


END SEQUENCE
getlist:={}
if select("TOWARY")>0
  close TOWARY
endif
CpClose(KODY_INFO)                                                   //18.02.03
set(_SET_ESCAPE,_old_esc)
restscreen(g,1,d,78,_okno)
if _osele > 0; sele (_osele); endif
setcursor(_cursor)
devpos(_r,_c)
SET(_SET_COLOR,_ocolo)
set key K_ALT_I to TOW_INFO()
setkey (K_ALT_K ,{|p,l,v| KON_INFO(p,l,v,"o")})
setkey (K_ALT_J ,{|p,l,v| KON_INFO(p,l,v,"d")})
set key K_CTRL_J to MAG_INFO()
RETU NIL

*******************************************************************************
FUNCTION KON_INFO(x,y,z,_k)
local getlist:={}, _okno,_cursor:=setcursor(),;
      _osele:=select(),_ocolo:=SET(_SET_COLOR,_ekra_blo),;
      _zb,_i1,_r:=row(),_c:=col(),;
      _out:=.f.,_old_esc:=set(_SET_ESCAPE,.t.),_pom,g,d
local _naz_kon,_naz_kon2,_miasto,_telefon,_limit,_kredyt,_dni,;
      _saldo_wn,_saldo_ma,_bkon,_grupa,_rabat,_opis_g_k,_wn_odb,_uwagi,;
      _koncesje:="" ,;//21.11.99
      _m_sug:=0.0,_konto
local _kategoria:="",_kod_ph:=""
local _oldf1:=setkey(K_F1,{|| NIL })

priv  _nr_info:=space(5)

_bkon:={||;
 _naz_kon:=subs(rtrim(KONINF->NAZWA_KON),1,40),;
 _naz_kon2:=subs(KONINF->NAZWA_KON2,1,40),;
 _grupa:=GRUPA_KON,;
 G_KON_INF->(dbseek(_grupa)),;
 _opis_g_k:=G_KON_INF->OPIS_G_KON,;
 _konto:=KONTO,;
 _miasto:=rtrim(MIASTO),;
 _adres:=rtrim(ADRES),;
 _telefon:=TELEFON,;
 if(subs(_wersja,71,1)=="K",;
 _koncesje:= KONINF->("P - "+dtoc(D_KONCES_P)+"       W - "+dtoc(D_KONCES_W)+;
           "           S - "+dtoc(D_KONCES_S)),NIL),;  //09.01.00
 _limit:=LIMIT,;
 _rabat:=RABAT_KON,;
 _kredyt:=KREDYT,;
 _dni:=DNI,;
 if(fieldpos("KATEGORIA")>0,_kategoria:=KATEGORIA,_kategoria:=""),;
 if(fieldpos("KOD_PH")>0,_kod_ph:=KOD_PH,_kod_ph:=""),;
 if(fieldpos("MAR_SUG")>0,_m_sug:=MAR_SUG,_m_sug:=0.0),;
 _uwagi:=UWAGI,;
 _nr_info:=KONINF->NR_KON,;
 _saldo_wn:=WN_ODB-MA_ODB,;
 _wn_odb:=WN_ODB,;
 _saldo_ma:=MA_DOS-WN_DOS,;
 SET(_SET_COLOR,subs(_ekra_blo,at(",",_ekra_blo)+1)),;
 devpos(g+2,15),devout(_nr_info),;
 SET(_SET_COLOR,_ekra_blo),;
 devpos(g+2,23),devout("Gr.: "+_grupa+"  "+_opis_g_k),;
 devpos(g+2,col()+2),devout("Konto: "),;
 SET(_SET_COLOR,subs(_ekra_blo,at(",",_ekra_blo)+1)),;
 devpos(g+2,col()+1),devout(_konto),;
 SET(_SET_COLOR,_ekra_blo),;
 devpos(g+3,3),devout(padright(_naz_kon+"  "+_naz_kon2,75)),;
 devpos(g+4,3),devout(padright(_miasto+",  "+_adres,75)),;
 devpos(g+5,3),devout("Telefon : "+_telefon),;
 if(subs(_wersja,71,1)=="K",;
         (devpos(g+6,3),devout("Koncesje : "+_koncesje)),NIL),;  //21.11.99
 devpos(g+7,3),devout("Saldo WN odbiorcy :"+transform(_saldo_wn,_format_war)),;
 devpos(g+7,40),devout("Obroty odbiorcy :"+transform(_wn_odb,_format_war)),;
 devpos(g+8,3),devout("Saldo MA dostawcy :"+transform(_saldo_ma,_format_war)),;
 devpos(g+10,3),devout("Kredyt : "+if(_kredyt="T","TAK","NIE")),;
 devpos(g+10,40),devout("Patno dni : "+str(_dni,3)),;
 devpos(g+11,3), devout("Limit kredytu : "+transform(_limit,_format_war)),;
 devpos(g+11,40),devout("Rabat : "+str(_rabat,4,1)+" %"),;
 devpos(g+11,63),devout(if(_m_sug<>0,"M. : "+str(_m_sug,4,1)+" %",space(11))),;
 devpos(g+12,3),devout("Uwagi :  "+_uwagi),;
 if(!empty(_kategoria),( devpos(g+13,3),devout("Kategoria : "+_kategoria)),NIL),;
 if(!empty(_kod_ph),( devpos(g+13,40),devout("Kod PH : "+_kod_ph)),NIL),;
 if(!empty(subs(_wersja,105,1)),RAP_ALERT(_nr_info,_k),NIL) }

g:=1
d:=23

SHOWTIME()
_okno:=savescreen(g,1,d,78)

set key K_ALT_K to
set key K_ALT_J to
set key K_ALT_I to
set key K_CTRL_J to

if used() .and. fieldpos("NR_KON")>0;_nr_info:=NR_KON;endif

BEGIN SEQUENCE

/*
sele 0
if !_use("KON","R","KONINF")
  BREAK
  _out:=.t.
endif
set index to KON_NR, KON_NA, KON_NI, KON_AD
*/

sele 0
if empty(_gdzie_fir)
  if !_use("KON","R","KONINF")
    BREAK
    _out:=.t.
  endif
  set index to KON_NR,KON_NA,KON_NI,KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","R","KONINF")
    BREAK
    _out:=.t.
  endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi

@ g,1 clea to d,78
@ g,1,g+14,78 BOX R_GRUBA
@ g+15,1,d,78 BOX B_DOUBLE

@ g+2,3 say "Nr kontr.: " get _nr_info pict "@K 99999";
           when SLGET("KONINF","KON","V1",1,1,;
           {"numer","nazwa","NIP","miasto,adres"},,.f.,BEZBLOK,,,0);
           valid SZ().and.SL("KONINF","KON","V1",1,1)

set curs on;  read;  set curs off

@ g+14,4 say " F1 - aktywne klawisze "
SLGET()
if lastkey()=K_ESC
  BREAK
endif

sele 0
if !_use(_gdzie_fir+"SL_G_KON","R","G_KON_INF")
  BREAK
else
  set index to (_gdzie_fir+"SL_G_KON")
endif

sele 0
_txt:=.t.
if !_use("KON_TXT","S")
  _txt:=.f.
else
  set index to KON_TXT
  if !dbseek (_nr_info)
    APPE_BLOK()
    repl NR_KON with _nr_info
  endi
  @ d,4 say " edycja - PgDn "
endi

sele KONINF
KONINF->(dbseek(_nr_info))
Eval(_bkon)
close KONINF
set curs off
if _txt
  keyboard chr(K_ESC)
  MEMOEDIT(KON_TXT->TEKST,g+16,3,d-1,76,.f.)

  close KON_TXT
endi

do while (_kij:=inkey(0))<>K_ESC
  if _kij=K_F1
    AKTYWNE1()
  endi

  if _kij=K_TAB
      ZAM_INKO(_nr_info,g,d)
  endif

  if _kij=K_STAR .and. _k="o"
      SPR_INFO(_nr_info,g,d,"O")
  endi

  if _kij=K_SPACE
    if _k="o"
      SPR_INFO(_nr_info,g,d)
    elseif _k="d"
      DOS_INFO(_nr_info,g,d)
    endif
  endif

  if _kij=K_BS .and. _k="o"
    KON_CEN_INF(_nr_info)
  endif

  if chr(_kij)$"zZ" .and. _k="o"
    POKAZ_ZAL(_nr_info)
  endif

  if chr(_kij)$"rR" .and. _k="o"
    POKAZ_UPU(_nr_info)
  endif

  if chr(_kij)$"xX" .and. _k="o"
    POKAZ_XX(_nr_info)
  endif

  if !empty(subs(_wersja,105,1))  .and. _k="d" .and. _kij=K_STAR
    WEGA_RAP(_nr_info,_saldo_ma)
  endi

  if _k="o".and._kij=K_ENTER.and.select("KON_POT")=0
    POT_INFO(_nr_info,g,d)
  endif

  if _kij=K_PGDN

    sele 0
    if _use("KON_TXT","S")
      set index to KON_TXT
      if !dbseek (_nr_info)
        APPE_BLOK()
        repl NR_KON with _nr_info
      else
        RBLOK()
      endi
      tone(880,0.5)
      @ d,4 say " zapis - Ctrl W "
      @ d,58 say " rezygnacja - Esc "
      set curs on
      repl KON_TXT->TEKST with MEMOEDIT(KON_TXT->TEKST,g+16,3,d-1,76,.t.)
      set curs off
      @ d,4 say repl(chr(205),74)
      @ d,4 say " edycja - PgDn "
      tone(440,0.5)
      close KON_TXT
    endi
  endi

  if _kij=K_UP .or. _kij=K_DOWN .or. _kij=K_PLUS .or. _kij=K_MINUS

/*    sele 0
    if !_use("KON","R","KONINF")
      BREAK
      _out:=.t.
    endif
    set index to KON_NR, KON_NA, KON_NI, KON_AD
*/
    sele 0
    if empty(_gdzie_fir)
      if !_use("KON","R","KONINF")
        BREAK
        _out:=.t.
      endif
      set index to KON_NR,KON_NA,KON_NI,KON_AD
    else
      if !_use(_gdzie_fir+"FIRMY","R","KONINF")
        BREAK
        _out:=.t.
      endif
      set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
                   (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
    endi

    KONINF->(dbseek(_nr_info))

    if _kij=K_UP
      KONINF->(dbskip(-1))
    elseif _kij=K_DOWN
      KONINF->(dbskip(1))
    elseif _kij=K_MINUS
      KONINF->(dbsetorder(2))
      KONINF->(dbskip(-1))
      KONINF->(dbsetorder(1))
    elseif _kij=K_PLUS
      KONINF->(dbsetorder(2))
      KONINF->(dbskip(1))
      KONINF->(dbsetorder(1))
    else
    endif

    Eval(_bkon)
    close KONINF

    sele 0
    if !_use("KON_TXT","S")
      _txt:=.f.
    else
      set index to KON_TXT
      if !dbseek (_nr_info)
        APPE_BLOK()
        repl NR_KON with _nr_info
      endi
    endi

    if _txt
      keyboard chr(K_ESC)
      MEMOEDIT(KON_TXT->TEKST,g+16,3,d-1,76,.f.)
      close KON_TXT
    endi

  endif

enddo


END SEQUENCE
getlist:={}
CPClose(KONINF)
CPClose(G_KON_INF)

set(_SET_ESCAPE,_old_esc)
restscreen(g,1,d,78,_okno)
if _osele > 0; sele (_osele); endif
setcursor(_cursor)
devpos(_r,_c)
SET(_SET_COLOR,_ocolo)
set key K_ALT_I to TOW_INFO()
setkey (K_ALT_K ,{|p,l,v| KON_INFO(p,l,v,"o")})
setkey (K_ALT_J ,{|p,l,v| KON_INFO(p,l,v,"d")})
set key K_CTRL_J to MAG_INFO()
setkey(K_F1,_oldf1)

RETU NIL

*******************************************************************************
FUNCTION SPR_INFO(_nrk,g,d,typ)
*---------------------------- skopiowanie odpowiednich faktur
local _sele:=select(), apom:={}, bwhi, bwyk, bwar,klucz

DEFAULT typ TO "P"   // patnik

BEGIN SEQUENCE

sele 0
if !_use("SPR_N","R","INFO_SPR"); BREAK; endif
apom:={1,2,3,4,5,6,21,25,34,36,38,48,53}                             //11.07.05
set index to SPR_N_KO,SPR_N_NR

sele 0
_use("QNR","R!")
copy stru to (_sc+"SPR_INFO")
_use(_sc+"SPR_INFO","E!")

if typ="P"

  sele INFO_SPR
  set order to 1

  seek _nrk
  if !found()
    QKE("Brak faktur tego kontrahenta - patnika !")
    BREAK
  endif
  bwhi:= {|| NR_KON==_nrk }
  bwyk:= {|| POLCOPY(INFO_SPR,SPR_INFO),;
      SPR_INFO->WART_ZAP:=INFO_SPR->(WART_BRU()),;
      SPR_INFO->NUMER_FAK :=SPR_INFO->( NR_DOK+"/"+SERIA_FAK+"/"+;
                            right(ROK_DOK,2)  )}                     //10.07.99
  QPC(1)
  dbeval(bwyk,,bwhi)
else

  sele 0
  if !_use("SPR_T","R","INF_SPRT"); BREAK; endif
 //  inde on RODZAJ_DOK+SERIA_FAK+ROK_DOK+NR_DOK to SPR_T_NR
  set index to SPR_T_NR

  bwyk:= {|| POLCOPY(INFO_SPR,SPR_INFO),;
          SPR_INFO->WART_ZAP:=INFO_SPR->(WART_BRU()),;
          SPR_INFO->NUMER_FAK :=SPR_INFO->( NR_DOK+"/"+SERIA_FAK+"/"+;
                              right(ROK_DOK,2)  )}                     //10.07.99

  QPC(1)

  sele INF_SPRT
  do while !eof()

    if subs(LINIA,1,2)=="|F" .and. subs(LINIA,3,5)==_nrk

      sele INFO_SPR
      set order to 2
      dbseek(INF_SPRT->(RODZAJ_DOK+SERIA_FAK+ROK_DOK+NR_DOK))
      Eval(bwyk)
    endi

    sele INF_SPRT
    skip

  enddo
  Close INF_SPRT

  if SPR_INFO->(lastrec())=0
    QKE("Brak faktur tego kontrahenta - odbiorcy towaru !")
    QPC(0)
    BREAK
  endif
endi

sele 0
if !_use("ZAP","R","INFO_ZAP"); BREAK; endif
set index to ZAP_FA

sele SPR_INFO
go top
do while !eof()
  _kiedy:=ctod("")
  if WN>0; skip;loop;endi
 
  sele INFO_ZAP
  klucz:=SPR_INFO->(RODZAJ_DOK+SERIA_FAK+ROK_DOK+NR_DOK)
  dbseek(klucz)
  dbeval({|| _kiedy:=max(_kiedy,DATA_ZAP)},,;
        {|| RODZAJ_DOK+SERIA_FAK+ROK_FAK+NR_FAK==klucz})
  SPR_INFO->KIEDY_ZAP:=_kiedy
  
  sele SPR_INFO
  skip
enddo
CpClose(INFO_ZAP)

sele SPR_INFO
index on if(subs(RODZAJ_DOK,1,1)="N","1","0")+;                      //16.01.07
          if(WN<>0,"0","1")+dtos(DATA_PLA);  
                                             to (_sc+"SPR_INF1") 
index on if(subs(RODZAJ_DOK,1,1)="N","0","1")+;                      //16.01.07
         dtos(DATA_DOK) to (_sc+"SPR_INF2") descending

set index to (_sc+"SPR_INF1") ,(_sc+"SPR_INF2") 
if subs(_wersja,140,1)=="T"
  set order to 2
endi

QPC(0)
go top
CPEDIT  POZ: g+5,2,d-1,77         ;                                  //10.07.99
        DEF: "N_R"                ;
        POZWER: "V3|V_PRE()"      ;
        PION: ,,,                 ;
        AKCJA: POZ_INFO(g,d,RODZAJ_DOK,SERIA_FAK,subs(ROK_DOK,3,2),NR_DOK);
        INDEXY: {"data pat.","data dok"}

clear typeahead
tone(880,.5)

END SEQUENCE
CpClose(INFO_SPR)
CpClose(SPR_INFO)
CpClose(INF_SPRT)
*dele file (_sc+"SPR_INFO.DBF")
dele file (_sc+"SPR_INF1.NTX")
dele file (_sc+"SPR_INF2.NTX")
RETURN  NIL

*******************************************************************************
FUNCTION POZ_INFO(g,d,_rd,_sf,_rf,_nf)
 local _lk:=lastkey(),_osele:=select(),_okno,_paragon:=.f.,_par_kor:=.f.,;
       _detal:=.f.,_astru:={},_rekord:=recn(),_key,lenw,_nazwa_ope:=spac(22),;
       _nazwa_odb:=spac(30),_ocolo:=SET(_SET_COLOR,_ekra_blo)
  priv _rodz_dok:=_rd,_seria_fak:=_sf,_rok_fak:=_rf,_nr_fak:=_nf,;
       _proforma:=.f.,_ceny_prz:=" ",_wer,_wl:="z",_ceny_spr:=" "
  priv _nr_mag

  if _lk=K_ENTER
     BEGIN SEQUENCE
        _okno:=savescreen(0,0,24,79)

        cls

        SET(_SET_COLOR,_ekra_blo)

        sele 0
        if !_use("SL_MAG","R","_SL_MAG"); BREAK; endif
        set index to SL_MAG

        sele 0
        if !_use("SPR_N","R","_SPR_N");  BREAK;  endif

        set inde to SPR_N_NR
        *----------------------- SPR_N_NR = RODZAJ_DOK+SERIA_FAK+ROK_DOK+NR_DOK

        _ceny_spr:="T"

        @ 1,0 say "Dokument : "+_rodz_dok

        if subs(_wersja,20,1)=="P".and._rodz_dok$"PA|PK".and._seria_par<>"  "
           _seria_fak:=_seria_par   //31.10.96
        endi

        @ 1,15 say "Seria : "+_seria_fak

        @ 1,27 say "Rok : "+_rok_fak

        @ 1,46 say "Nr : "
        @ 1,56 say "/"+_seria_fak+"/"+_rok_fak
        @ 1,51 say _nr_fak
/*
        if _rodz_dok="PK".or.;
           ("K"$_rodz_dok.and._seria_fak==_seria_par.and.!empty(_seria_par))
           _par_kor:=.t.
        elseif subs(_wersja,20,1)=="P".and."K"$_rodz_dok.and.empty(_seria_par)
           tone(880,2)
           _par_kor:=;
                 QTN("Korekta do sprzeday detalicznej na paragony fiskalne ?")
        endi
        if subs(_wersja,20,1)=="P".and.!_par_kor
           _paragon:=(_rodz_dok="PA")
        endi
        if !_par_kor.and.!_paragon
           if subs(_wersja,20,1)=="P".and._seria_fak==_seria_par.and.;
              !empty(_seria_par)
              _detal:=.t.
           elseif subs(_wersja,20,1)=="P".and.empty(_seria_par)
               tone(880,2)
               _detal:=QTN(;
            "Rachunek/faktura do sprzeday detalicznej na paragony fiskalne ?")
           endi
        endi  */
   *---------------------------------------------------------------
        sele 0
        if empty(_gdzie_fir)
           if !_use("KON","R","_KON"); BREAK; endif
           set index to KON_NR, KON_NA, KON_NI, KON_AD
        else
           if !_use(_gdzie_fir+"FIRMY","R","_KON"); BREAK; endif
           set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
                        (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
        endi

        sele _SPR_N
        set order to 1
        seek _rodz_dok+_seria_fak+ep(_rok_fak)+_nr_fak  //!
        if eof(); BREAK;  endif

        if subs(_wersja,20,1)="P"
           if "K"$_rodz_dok.and.AUTO$"Pp"
               _par_kor:=.t.
           endi
           if !_par_kor
               _paragon:=(_rodz_dok="PA")
           endi
           if !_par_kor.and.!_paragon.and."AUTO"$"Pp"
               _detal:=.t. 
           endi
        endi 

        _od_bru:=(subs(_wersja,78,1)=="B" .and.(_detal.or._paragon.or._par_kor)).or.;
                  subs(_wersja,78,1)=="C"

        @ 1,65 say "Data : "+dtoc(DATA_DOK)
        sele _KON
        seek _SPR_N->NR_KON
        _nazwa_kon2:=subs(_KON->NAZWA_KON2,1,40)

        *********** //25.09.99
        if fieldpos("NAZWA_ODB")>0
           _nazwa_odb:=NAZWA_ODB
        endi

        sele 0
        if !_use("SL_OPE","R","_SL_OPE"); BREAK; endi
        loca for KOD==_SPR_N->OPERATOR
        _nazwa_ope:=NAZWA
        close _SL_OPE

        sele _SPR_N
        _nr_mag:=NR_MAG
        copy next 1 to (_sc+"_ZBN_R")
        close _SPR_N

        sele 0
        if _nr_mag="000"
           clos _SL_MAG
           if !_use("SPR_U","R","_SPR_P");  BREAK;  endif
           set inde to SPR_U_NR
        else
           if !_use("SPR_P","R","_SPR_P");  BREAK;  endif
           set inde to SPR_P_NR
        endi

        seek _rodz_dok+_seria_fak+ep(_rok_fak)+_nr_fak  //!
        if eof(); BREAK;  endif

        copy  to (_sc+"_ZBP_R") while RODZAJ_DOK==_rodz_dok .and.;
                                      SERIA_FAK==_seria_fak .and.;
                                      ROK_DOK==ep(_rok_fak) .and.;       //!
                                      NR_DOK==_nr_fak

        close _SPR_P

*        if _rodz_dok<>"P" .and.file("SPR_T.DBF").and.file("FAK_TXT.DBF");
*                          .and._nr_mag<>"000"
        if _rodz_dok<>"P" .and.file("SPR_T.DBF").and.file("FAK_TXT.DBF")
     //MOTIP
           sele 0
           if !_use("SPR_T","R","_SPR_T");  BREAK;  endif
           set inde to SPR_T_NR
           seek _rodz_dok+_seria_fak+ep(_rok_fak)+_nr_fak  //!

           copy  to (_sc+"_FAK_TXT") while RODZAJ_DOK==_rodz_dok .and.;
                                           SERIA_FAK==_seria_fak .and.;
                                           ROK_DOK==ep(_rok_fak) .and.;  //!
                                           NR_DOK==_nr_fak
           close _SPR_T
           if !_use(_sc+"_FAK_TXT","R");  BREAK;  endif
        endi

        if _nr_mag<>"000"

           sele 0               // -------------------------- ceny przekazania
           if !_use("SL_G_MAG","R","_SLGMAG"); BREAK; endif
           set index to SL_G_MAG

           _SL_MAG->(dbseek(_nr_mag))
           seek _SL_MAG->GRUPA_MAG
           _ceny_prz:=CENY_PRZ
           close _SL_MAG
           close _SLGMAG

           sele 0
           if !_use("TOW","R","_TOW"); BREAK; endi
           set index to TOW_IN, TOW_NA, TOW_GR, TOW_SW
        endi

        sele 0
        if !_use("QSPR_N","R","_QSPR_N"); BREAK; endif
        copy stru to (_sc+"_SPR_N_R")

        if !_use("QSPR_P","R","_QSPR_P"); BREAK; endif
        copy stru to (_sc+"_SPR_P_R")
        use

        sele 0
        _use(_sc+"_SPR_P_R","E!","_SPR_P_R")
        appe from (_sc+"_ZBP_R")

        if _nr_mag<>"000"
           set rela to s_i(INDEKS) into _TOW
        endi

        sele 0
        _use(_sc+"_SPR_N_R","E!","_SPR_N_R")
        appe from (_sc+"_ZBN_R")
        set rela to NR_KON into _KON

        sele _SPR_N_R
        @ 1,65 say "Data : "+dtoc(DATA_DOK)
        if "K"$_rodz_dok
           @ 2,0 say "Korekta "+if("F"$_rodz_dok,"faktury " ,"rach. ")+;
                      RODZAJ_KOR+"-"+NR_KOR+"/"+SERIA_KOR+"/"+subs(ROK_KOR,3,2)
           @ 2,31 say " z "+dtoc(DATA_KOR)
        endif

        @ 2,46 say "Konto : "+KONTO

        if _nr_mag<>"000"
           @ 2,61 say "Nr WZ  "+NR_WZ+"/"+NR_MAG+"/"+subs(ROK_WZ,3,2)
        endi

        @ 3,0  say "Patnik :  "+NR_KON
        @ 3,19 say subs(NAZWA_KON,1,40)
        @ 3,61 say "NIP : "+ID_KON
        @ 4,11 say KOD
        @ 4,19 say MIASTO
        @ 4,40 say ADRES

        @ 5,0 say  "Sposb zapaty :   "+SPOSOB_PLA
        @ 5,47 say "Termin : "+str( TERMIN ,3)
        @ 5,61 say "Data zap.: "+dtoc(DATA_PLA)
        @ 6,0 say  "Uwagi :    "+ UWAGI
        if (RABAT+PREMIA)<>0.and.empty(subs(_wersja,38,1)).and.;
           subs(_wersja,16,1)<>"R"
           @ 6,53 say "Rabat : "+transform((RABAT+PREMIA),"99.9")+ " %"
        endif

        sele _SPR_P_R
        if _nr_mag<>"000"
           repl all NAZWA_TOW with _TOW->NAZWA_TOW,;
                    OPIS_TOW  with _TOW->OPIS_TOW,;
                    JM        with _TOW->JM
        endi

        go top
        if _nr_mag<>"000"
           if empty(subs(_wersja,38,1))
              _wer:=;
                "V1|V_DATA_DOS().and.V_CENY_SPR().and.V_CENA_PRZ().and.V_VAT()"
           else
              _wer:=;
                "V6|V_DATA_DOS().and.V_CENY_SPR().and.V_CENA_PRZ().and.V_VAT()"
          endi
        else
           _wer:="V2|V_VAT()"
        endi

        @ 7,0 clear to 24,79
        _li=iif(_ceny_prz="T",1,0)

        _li=2+iif(_ceny_spr="T",1,0)+iif(_ceny_prz="T",1,0)+;
            if(!empty(_SPR_N_R->(RABAT+PREMIA)),1,0)

        @ 24-_li,35 say "Kwota netto      Podatek VAT     Kwota brutto"

        if _udocezak .and._priorytet=9
           @ row()+1,0 say  "Warto wg cen zakupu :"
           @ row(),31 say transform(_SPR_N_R->WART_ZAK,_format_war)
        endi

        @ row()+1,0 say "Warto wg cen sprzeday :"
        _wart_n_spr:=_SPR_N_R->WART_NET_+_SPR_N_R->WART_NET0+;
                     _SPR_N_R->WART_NET1+_SPR_N_R->WART_NET2+;
                     _SPR_N_R->WART_NET3+_SPR_N_R->WART_NET4
        _wart_v_spr:=_SPR_N_R->WART_VAT1+_SPR_N_R->WART_VAT2+;
                     _SPR_N_R->WART_VAT3+_SPR_N_R->WART_VAT4
        @ row(),31 say transform(_wart_n_spr,_format_war)
        @ row(),48 say transform(_wart_v_spr,_format_war)
        @ row(),65 say transform(_wart_n_spr+_wart_v_spr,_format_war)
        if !empty(_SPR_N_R->(RABAT+PREMIA))
           @ row()+1,0 say "Warto rabatu netto: "
           @ row(),31  say  transform(_SPR_N_R->BONIFIKATA,_format_war)
        endif

        if _ceny_prz="T"
           @ row()+1,0 say "Warto wg cen przekazania :"
           @ row(),31 say transform(_SPR_N_R->WART_PRZ,_format_war)
        endi

        CPEDIT  POZ: 7,,23-_li,           ;
                DEF: "SPR_P"              ;
                POZWER: _wer              ;
                POZSLAD: spac(1)+padr(if(_nr_mag<>"000",;
                 if(_opisy_tow="T",alltrim(NAZWA_TOW)+" "+OPIS_TOW,NAZWA_TOW),;
                    TRESC),75) ;
                PION: 7,,23-_li,          ;
                AKCJA: ILO_SYN(.t.)       ;
                EDYCJA: .f.               ;
                ODTWORZ:.F.
/*
        @ 23,0
        if _ope_enter$"23" .and. !_paragon
           @ 23,0 say "Odbierajcy :" get _nazwa_odb pict "@! "+repl("X",30)
           set curs on; read; set curs off
           if lastkey()=K_ESC; _nazwa_odb:=spac(30); endi
        endi

        if _ope_enter$"T31"
           @ 23,47 say "Operator :" get _nazwa_ope pict "@! "+repl("X",22)
           set curs on; read; set curs off
           if lastkey()=K_ESC; _nazwa_ope:=spac(22); endi
        else
           @ 23,48 say "Operator :  " + _nazwa_ope
        endif

        if _rodz_dok<>"P" .and.;
*           file("SPR_T.DBF").and.file("FAK_TXT.DBF").and._nr_mag<>"000".and.;
*           _FAK_TXT->(lastrec())>0
           file("SPR_T.DBF").and.file("FAK_TXT.DBF").and.;
           _FAK_TXT->(lastrec())>0 //MOTIP
           EDYCJA_TXT(.f.)
           ODBIORCA_TXT(.f.)                                   //05.11.99
        endi
*/
        CPClose(_SL_MAG)
        CPClose(_SPR_N)
        CPClose(_KON)
        CPClose(_SL_OPE)
        CPClose(_SPR_P)
        CPClose(_SPR_T)
        CPClose(_FAK_TXT)
        CPClose(_SLGMAG)
        CPClose(_TOW)
        CPClose(_SPR_P_R)
        CPClose(_SPR_N_R)
****** wydruk do zrobienia

/*
        if _oryginal<>"T"
           do case
              case left(_rodz_dok,1)="R"; awybor:={"RACHUNEK"}
              case left(_rodz_dok,1)="P"; awybor:={"PARAGON"}
              case left(_rodz_dok,1)="N"; awybor:={"NOTA"}
              othe;                       awybor:={"FAKTURA"}
           endc
        else
           do case
              case left(_rodz_dok,1)="R"
                   awybor:={"ORYG. RACHUNKU","KOPIA RACHUNKU"}
              case left(_rodz_dok,1)="P"
                   awybor:={"ORYG. PARAGONU","KOPIA PARAGONU"}
              case left(_rodz_dok,1)="N"
                   awybor:={"ORYG. NOTY","KOPIA NOTY"}
              othe
                   awybor:={"ORYG. FAKTURY","KOPIA FAKTURY"}
           endc
        endi

        if _kaucje .and._nr_mag<>"000"
           aadd(awybor,"SPEC.OPAK.")
        endif
        if subs(_wersja,48,1)=="S"
           aadd(awybor,"SEKTORY")
        endif
        aadd(awybor,"KONIEC")
        lenw:=len(awybor)

        do while .t.
           @ 24,0 clea to 24,79
           clear typeahead
          _wyb1:=HorizMenu(24,0,"",awybor)
             do case
                case _wyb1=1 .and. _oryginal=" "
                    DFAK(_rodz_dok,"O/K")               // oryginal/kopia
                case _wyb1=1 .and. _oryginal="B"
                    DFAK(_rodz_dok,"B")               // bez napisu
                case _wyb1=1 .and. _oryginal="T"
                    DFAK(_rodz_dok,"OR")                // oryginal
                case _wyb1=2 .and. _oryginal="T"      // kopia
                    DFAK(_rodz_dok,"KO")
                case _wyb1>0 .and. awybor[_wyb1]=="SPEC.OPAK."
                    DKAU(_rodz_dok)
                case _wyb1>0 .and. awybor[_wyb1]=="SEKTORY"
                    DSEK()
                case _wyb1=0 .or. _wyb1=lenw           // wyjscie
                    exit
             endcase
        enddo
*/

     END SEQUENCE
     restscreen(0,0,24,79,_okno)
     SET(_SET_COLOR,_ocolo)

     CPClose(_SL_MAG)
     CPClose(_SPR_N)
     CPClose(_KON)
     CPClose(_SL_OPE)
     CPClose(_SPR_P)
     CPClose(_SPR_T)
     CPClose(_FAK_TXT)
     CPClose(_SLGMAG)
     CPClose(_TOW)
     CPClose(_SPR_P_R)
     CPClose(_SPR_N_R)

     dele file(_sc+"_fak_txt.dbf")
     dele file(_sc+"_spr_n_r.dbf")
     dele file(_sc+"_spr_p_r.dbf")
     dele file(_sc+"_zbn_r.dbf")
     dele file(_sc+"_zbp_r.dbf")

     sele (_osele)




  elseif _lk=K_SPACE

     BEGIN SEQUENCE

     _key:=SPR_INFO->(RODZAJ_DOK+SERIA_FAK+ROK_DOK+NR_DOK)

     if SPR_INFO->NR_MAG<>"000"                             // towary    10.07.05
  
       sele 0
       if !_use("TOW","R","DO_NAZW"); BREAK; endif
       set inde to TOW_IN
  
       sele 0
       _astru:={}
       aadd(_astru,{"INDEKS"     ,"C",LENIN, 0})
       aadd(_astru,{"NAZWA_TOW"  ,"C",max(40,_len_naz), 0})
       aadd(_astru,{"OPIS_TOW"   ,"C",max(20,_len_opi), 2})
       aadd(_astru,{"CENA_ZAK"  ,"N",12, 2})
       aadd(_astru,{"JM"        ,"C", 4, 0})
       aadd(_astru,{"ILOSC"      ,"N",12, 3})
       aadd(_astru,{"CENA_SPR"   ,"N",12, 2})
       dbcreate ((_sc+"POZ_INFO"),_astru)
       if !_use(_sc+"POZ_INFO","E"); BREAK; endi
  
       sele 0
       if !_use("SPR_P","R","DO_POZ"); BREAK; endif
       set inde to SPR_P_NR
  
       seek _key
       dbeval({|| POZ_INFO->(dbappend()),;
                  POZ_INFO->INDEKS:=DO_POZ->INDEKS,;
                  DO_NAZW->(dbseek(POZ_INFO->(s_i(INDEKS)))),;
                  POZ_INFO->NAZWA_TOW:=DO_NAZW->NAZWA_TOW,;
                  POZ_INFO->OPIS_TOW:=DO_NAZW->OPIS_TOW,;
                  POZ_INFO->JM:=DO_NAZW->JM,;
                  POZ_INFO->CENA_ZAK:=DO_POZ->CENA_ZAK,;
                  POZ_INFO->ILOSC:=DO_POZ->ILOSC,;
                  POZ_INFO->CENA_SPR:=DO_POZ->CENA_SPR},,;
                  {|| _key==(RODZAJ_DOK+SERIA_FAK+ROK_DOK+NR_DOK)})
  
       sele POZ_INFO
       close DO_POZ
       close DO_NAZW
       go top
       CPEDIT  POZ: g+5,8,d-1,77 ;
               DEF: "SPR_P"                 ;
               POZWER: "V5|V_OPISY_TOW()"                 ;
               KOLOR: _slow_blo ;                                   //07.10.04
               PION: ,,,
          clear typeahead
*         tone(880,0.5)                                                //07.10.04
    else

      sele 0   
      if !_use("SPR_U","R","DO_NAZW");  BREAK;  endif
      set inde to SPR_U_NR
      seek _key
      copy to (_sc+"POZ_INFO") fields INDEKS, TRESC, JM, ILOSC, CENA_SPR;
        while RODZAJ_DOK+SERIA_FAK+ROK_DOK+NR_DOK==_key
      if !_use(_sc+"POZ_INFO","E"); BREAK; endi
      go top
      CPEDIT  POZ: g+5,8,d-1,77 ;
              DEF: "SPR_P"                 ;
              POZWER: "V10"                 ;
              KOLOR: _slow_blo ;                                   //07.10.04
              PION: ,,,
 
      clear typeahead
    endi

  END SEQUENCE
  CPClose(POZ_INFO)
  CPClose(DO_NAZW)
  sele (_osele)
endi

RETU NIL
*******************************************************************************
FUNCTION SZ1(_s)
if !empty(_s)
  _s:=strtran(str(val(_s),len(_s))," ","0")
endif
RETURN .t.

*****************************************************************************
FUNCTION DOS_INFO(_nrk,g,d)
*---------------------------- skopiowanie odpowiednich faktur dostaw
local _sele:=select(), apom:={}, bwhi, bwyk, bwar

BEGIN SEQUENCE
_do_daty:=1

sele 0
if !_use("DOS_N","R","INFO_DOS"); BREAK; endif

set index to DOS_N_KO
copy stru to (_sc+"DOS_INFO") fields OPIS_FAK,DATA_FAK,WART_B_DOS, MA, NR_DOK,;
                                      NR_MAG, ROK_DOK,DATA_WPL,TERMIN,DATA_PLA

sele 0
_use(_sc+"DOS_INFO","E!")

sele INFO_DOS
seek _nrk
if !found()
  QKE("Brak faktur od tego dostawcy !")
  BREAK
endif
apom:={3,4,5,6,9,10,11,23,24,25,26}
bwhi:= {|| NR_KON==_nrk }
bwyk:= {|| POLCOPY(INFO_DOS,DOS_INFO) }

QPC(1)
dbeval(bwyk,,bwhi)

sele DOS_INFO
index on if(MA<>0,"0","1")+dtos(max(TERMIN,DATA_PLA)) to (_sc+"DOS_INF1")
index on DATA_WPL to (_sc+"DOS_INF2") descending
set index to (_sc+"DOS_INF1"),(_sc+"DOS_INF2")

QPC(0)
go top
CPEDIT  POZ: g+5,8,d-1,77         ;
        DEF: "DOS"                ;
        POZWER: "V6"              ;
        PION: ,,,                 ;
        AKCJA: PZ_INFO(g,d)      ;
        INDEXY: {"data pat.","data wpywu"}

clear typeahead
tone(880,.5)

END SEQUENCE
CpClose(INFO_DOS)
CpClose(DOS_INFO)
dele file (_sc+"DOS_INF1.NTX")
dele file (_sc+"DOS_INF2.NTX")
dele file (_sc+"DOS_INFO.DBF")
RETURN  NIL

*******************************************************************************
FUNCTION PZ_INFO(g,d)
local _lk:=lastkey(),_astru:={},_osele:=select(),_rekord:=recn(),_key,;
      _npz, _opis_zro,i,apz:={},akom:={}

BEGIN SEQUENCE

if !(_lk=K_SPACE .and.file("D"+DOS_INFO->NR_MAG+"P_NR.NTX")); BREAK; endi
if empty(DOS_INFO->NR_DOK); BREAK;endif

_key:=DOS_INFO->("PZ"+NR_MAG+ROK_DOK+NR_DOK)

*--------------------------------
// zaklaadamy, ze to jest pierwszy PZ i szukamy czy jest drugi, trzeci itd
// na tego samego kontrahenta z tym samym OPIS_ZRO czy
apz:={}
aadd(apz,_key)   // pierwszy PZ

sele 0
if !_use("DOK"+DOS_INFO->NR_MAG+"N","R","DO_FAK"); BREAK; endif
set inde to "D"+DOS_INFO->NR_MAG+"N_NR"

seek _key  // pierwsza PZ
_opis_zro:=OPIS_ZRO; _dostawca:=NR_KON
skip
dbeval({|| aadd(apz,"PZ"+NR_MAG+ROK_DOK+NR_DOK)},;
       {|| NR_KON==_dostawca .and. OPIS_ZRO==_opis_zro},;
       {|| RODZAJ_DOK="PZ"})
close DO_FAK
*--------------------------------

sele 0
if !_use("TOW","R","DO_NAZW"); BREAK; endif
set inde to TOW_IN

sele 0
_astru:={}
aadd(_astru,{"INDEKS"     ,"C",LENIN, 0})
aadd(_astru,{"NAZWA_TOW"  ,"C",max(40,_len_naz), 0})
aadd(_astru,{"OPIS_TOW"   ,"C",max(20,_len_opi), 0})
aadd(_astru,{"CENA_ZAK"  ,"N",12, 2})
aadd(_astru,{"JM"        ,"C", 4, 0})
aadd(_astru,{"ILOSC"      ,"N",12, 3})
aadd(_astru,{"WAGA"      ,"N",12, 5})
aadd(_astru,{"POJEMNOSC" ,"N",12, 5})
dbcreate ((_sc+"PZ_INFO"),_astru)
if !_use(_sc+"PZ_INFO","E"); BREAK; endi

sele 0
if !_use("DOK"+DOS_INFO->NR_MAG+"P","R","DO_POZ"); BREAK; endif
set inde to "D"+DOS_INFO->NR_MAG+"P_NR"

if (_npz:=len(apz))>1
  akon:={}
  aadd(akom,"Pozycje "+ltrim(str(_npz))+" PZ:")
  for i:=1 to _npz
    aadd(akom,left(apz[i],2)+"-"+right(apz[i],5)+"/"+;
              subs(apz[i],3,3)+"/"+subs(apz[i],6,4))
  next
  QKE_ARR(akom)
endi
for i:=1 to _npz
  _key:=apz[i]
  seek _key
  dbeval({|| PZ_INFO->(dbappend()),;
           PZ_INFO->INDEKS:=DO_POZ->INDEKS,;
           DO_NAZW->(dbseek(PZ_INFO->(s_i(INDEKS)))),;
           PZ_INFO->NAZWA_TOW:=DO_NAZW->NAZWA_TOW,;
           PZ_INFO->OPIS_TOW:=DO_NAZW->OPIS_TOW,;
           PZ_INFO->JM:=DO_NAZW->JM,;
           PZ_INFO->CENA_ZAK:=DO_POZ->CENA_ZAK,;
           PZ_INFO->ILOSC:=DO_POZ->ILOSC},,;
           {|| _key==(RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK)})
next
sele PZ_INFO
close DO_POZ
close DO_NAZW
go top
CPEDIT  POZ: g+5,8,d-1,77 ;
        DEF: "SPR_P"                 ;
        POZWER: "V8|V_OPISY_TOW()"                 ;
        PION: ,,,

clear typeahead
tone(880,0.5)

END SEQUENCE
CPClose(PZ_INFO)
CPClose(DO_NAZW)

sele (_osele)
RETURN NIL

*******************************************************************************
FUNCTION GRUPA_OK(x,maxgru,_agru)
// Uwaga ! _agru musi by przekazywana przez referencj
// np. GRUPA_OK(_nr_g_kon,_maxgr,@akon) patrz R.Spence Clipper 5.2 str. 148
local _ret:=.t., s1:="",s2:="", _tn:="",i,j,k,_grmax,_maxpom

_maxpom:=if(maxgru>99,999,99)

s1:=CHARREM(" ",x)
s2:=CHARONLY(",-0123456789",x)
_agru:={}
BEGIN SEQUENCE
  if ! s1==s2; _ret:=.f.; BREAK; endif   // niedopuszczalne znaki

  TOKENINIT(@s1,",")
  i:=1
  do while !TOKENEND()
    _tn:=TOKENNEXT(s1)
    _nat:=NUMAT("-",_tn)

    if _nat=1 .and. len(_tn)=1         //  tylko "-"
      for i:=1 to maxgru
        aadd(_agru,i)
      next
    elseif _nat=1 .and. left(_tn,1)="-"    //  "-" jako pierwszy znak
      if (_grmax:= val(subs(_tn,2)))>_maxpom
        _ret:=.f.; BREAK
      endif
      for i:=1 to _grmax
        aadd(_agru,i)
      next
    elseif _nat=1 .and. right(_tn,1)="-"    // "-" jako ostatni znak
      j:=val(left(_tn,len(_tn)-1))
      for i:=j to maxgru
        if ascan(_agru,i)=0;   aadd(_agru,i); endi
      next
    elseif _nat=1             // "-" nie jako ostatni znak i nie ostatni
      _nn:=at("-",_tn)
      j:=val(left(_tn,_nn-1))
      if (k:=val(subs(_tn,_nn+1)))>_maxpom
        _ret:=.f.; BREAK
      endif
      for i:=j to k
        if ascan(_agru,i)=0;   aadd(_agru,i); endi
      next
    elseif _nat>1
      _ret:=.f.; BREAK
    elseif _nat=0
      if (i:=val(_tn)) > _maxpom
        _ret:=.f.; BREAK
      endif
      if ascan(_agru,i)=0;   aadd(_agru,i); endi
    else
    endif
  enddo

END SEQUENCE

if _ret=.f.
  tone(220,5)
  QKE(;
 "Bdna selekcja !  Naley zostawi puste pole lub wpisa grupy i przedziay",;
 "grup oddzielone przecinkami. Przykady: 7  2,3-5  1,2,6. Maksym. grupa : "+;
  str(maxgru,2))
  _agru:={}
endif
RETURN _ret

*******************************************************************************
FUNCTION DATY_ZAP()
#ifdef M
 cls; QK("Opcja dostpna w penej wersji programu !"); RETURN NIL
#else
local _tex:='۲  WYZNACZENIE DAT ZAPACENIA ZA FAKTURY ',;
      _err:=.t.

cls
@ 0,0 say _tex

BEGIN SEQUENCE

QPC(1)

sele 0
if !_use("ZAP","E!"); BREAK; endi
set index to ZAP_FA   // on RODZAJ_DOK+SERIA_FAK+ROK_FAK+NR_FAK+ROK_DOS+NR_DOS

sele 0
if !_use("SPR_N","E!"); BREAK; endi
_total:=lastrec()
set inde to SPR_N_NR  // on RODZAJ_DOK+SERIA_FAK+ROK_DOK+NR_DOK

PASEK()
go top
do while !eof()
 PASEK(10)
 if !empty(DATA_WEZ); skip; loop; endi

 if (WART_ZAP>0.and.WN<=0) .or.(WART_ZAP<0 .and.WN>=0)

   sele ZAP
   if !dbseek((_klucz:=SPR_N->(RODZAJ_DOK+SERIA_FAK+ROK_DOK+NR_DOK))).and.;
       SPR_N->WART_ZAP<>0
     tone(220,.5)
     QKE("Zweryfikuj zapaty za faktur "+;
    SPR_N->(RODZAJ_DOK+"-"+NR_DOK+"/"+SERIA_FAK+"/"+right(ROK_DOK,2))+" !") 
   else
     repl SPR_N->DATA_WEZ with ZAP->DATA_ZAP
   endi
   dbeval({|| if(DATA_ZAP>SPR_N->DATA_WEZ,SPR_N->DATA_WEZ:=DATA_ZAP,NIL)},,;
          {|| _klucz==RODZAJ_DOK+SERIA_FAK+ROK_FAK+NR_FAK })
 endi

 sele SPR_N
 skip
endd

QPC(0)
_err:=.f.

END SEQUENCE
clos data
PASEK()
if _err
  QKE("Nie odtworzono dat zapat za faktury !")
else
  QKE("Odtworzono daty zapat za faktury !")
 endi
RETURN NIL
#endi

*******************************************************************************
FUNCTION UZG_DAT()
local _amagi:={},_i,_zb

cls

sele 0
_use("CONFIG","E!")
repl ROZCHODY with "2"
_rozchody:="2"
close CONFIG

sele 0
_use("SL_MAG","R!")
set index to SL_MAG
go top
do while .not.eof()
  if !empty(NR_MAG);  aadd(_amagi,NR_MAG); endi
  skip
enddo
clos SL_MAG

for _i:=1 to len(_amagi)

  cls
  _nr_mag:=_amagi[_i]
  @ 0,0 say '۲  UZGODNIENIE DAT DOSTAWY - magazyn '+_nr_mag+'  '

  QPC(1)

  sele 0
  _zb:="MAG"+_nr_mag
  _use(_zb,"E","MAG")
  zap
  clos MAG

  sele 0
  _zb:="DOK"+_nr_mag+"P"
  _use(_zb,"E","DOKP")
  index on DATA_DOK to (_sc+"ROB")
  copy to (_sc+"POZ_DOS") for ZNAK=1.and.ILOSC>=0
  copy to (_sc+"POZ_DOK")
  set index to

  sele 0
  _use(_sc+"POZ_DOK","E!")
  repl all DATA_DOS with DATA_DOK for empty(DATA_DOS).or.DATA_DOS>DATA_DOK
  index on INDEKS+str(CENA_ZAK,12,2) to (_sc+"ROB") uniq

  sele DOKP
  set rela to INDEKS+str(CENA_ZAK,12,2) into POZ_DOK
  repl all DATA_DOS with POZ_DOK->DATA_DOS
  set rela to
  clos DOKP
  clos POZ_DOK
  dele file (_sc+"POZ_DOK.DBF")

  QPC(0)

  INDEX_MAG(_amagi[_i])

  UZG_MAG(_amagi[_i])

  UZG_POZ(_amagi[_i])
next

close data
dele file (_sc+"ROB.DBF")
dele file (_sc+"ROB.NTX")

RETURN NIL

*******************************************************************************
FUNCTION UZG_POZ(_nr_mag)
local _txt:=;
'۲  UTWORZENIE DOKUMENTU PI WG ZASADY FIFO - magazyn '+_nr_mag+'  '
local _nrn,_ind,_ile,_cez,_das,_dan

@ 0,0 say _txt
QPC(1)

sele 0
_use("TOW","R!")
set index to TOW_IN, TOW_NA, TOW_GR

sele 0
_use(_sc+"POZ_DOS","E!")                  // stare pozycje dokumentw przychodowych
copy stru to (_sc+"POZ_PI")
index on INDEKS+str(CENA_ZAK,12,2)+dtos(DATA_DOK) to (_sc+"POZ_DOS") descending

sele 0
_use(_sc+"POZ_PI","E!")                   // pozycje dokumentu korygujcego

sele 0
_use("MAG"+_nr_mag,"E!","MAG")         // magazyn z mimimalnymi datami dostaw
set inde to ("M"+_nr_mag+"_IP"),("M"+_nr_mag+"_N"),;
            ("M"+_nr_mag+"_IP0"),("M"+_nr_mag+"_N0")
set rela to s_i(INDEKS) into TOW

do while !eof()
  if MAG->STAN<=0; skip; loop; endi

  _ind:=INDEKS
  _ile:=STAN
  _cez:=CENA_ZAK
  _das:=DATA_DOS
  
  sele POZ_DOS
  dbseek(_ind+str(_cez,12,2))
  if found().and._ile>POZ_DOS->ILOSC
    POZ_PI->(dbappend())
    TOW->(dbseek(s_i(_ind)))
    POZ_PI->VAT:=TOW->VAT
    POZ_PI->INDEKS:=_ind
    POZ_PI->CENA_ZAK:=_cez
    POZ_PI->DATA_DOS:=_das
    POZ_PI->ILOSC:=-_ile

    do while _ile>0.and.INDEKS+str(CENA_ZAK,12,2)==_ind+str(_cez,12,2);
                   .and.!eof()
      POZ_PI->(dbappend())
      POZ_PI->INDEKS:=_ind
      TOW->(dbseek(s_i(_ind)))
      POZ_PI->VAT:=TOW->VAT
      POZ_PI->CENA_ZAK:=_cez
      POZ_PI->DATA_DOS:=POZ_DOS->DATA_DOK
      POZ_PI->ILOSC:=min(_ile,POZ_DOS->ILOSC)
      _ile:=_ile-POZ_PI->ILOSC
      _dan:=POZ_PI->DATA_DOS
      skip
    endd
    if _ile>0
      POZ_PI->(dbappend())
      POZ_PI->INDEKS:=_ind
      TOW->(dbseek(s_i(_ind)))
      POZ_PI->VAT:=TOW->VAT
      POZ_PI->CENA_ZAK:=_cez
      POZ_PI->DATA_DOS:=_dan
      POZ_PI->ILOSC:=_ile
    endi
  endi
   
  sele MAG
  skip
endd 
close POZ_DOS

sele POZ_PI
index on INDEKS+dtos(DATA_DOS)+str(CENA_ZAK,12,2) to (_sc+"POZ_PI")
total on INDEKS+dtos(DATA_DOS)+str(CENA_ZAK,12,2) fiel ILOSC to (_sc+"POZ_T")
set index to
zap
appe from (_sc+"POZ_T") for ILOSC<>0
dele file (_sc+"POZ_T.DBF")
sum zaokr(ILOSC*CENA_ZAK,2) to _wart_zak  // ma by zero
go top
do while !eof()                                        // aktualizacja magazynu
  MAG->(dbseek(POZ_PI->(s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK))))
  if MAG->(!found())
    MAG->(dbappend())
    MAG->INDEKS:=POZ_PI->INDEKS
    MAG->CENA_ZAK:=POZ_PI->CENA_ZAK
    MAG->DATA_DOS:=POZ_PI->DATA_DOS
  endi
  repl MAG->STAN with MAG->STAN+POZ_PI->ILOSC
  
  skip
endd

sele 0
_use("DOK"+_nr_mag+"N","E!","DOKN")
set inde to ("D"+_nr_mag+"N"+"_NR"),("D"+_nr_mag+"N"+"_RD")
dbseek("PI"+_nr_mag+left(dtos(date()),4)+"9999:",.t.)
skip -1
if RODZAJ_DOK="PI".and.ROK_DOK=left(dtos(date()),4).and.NR_MAG=_nr_mag
  _nrn=str(val(NR_DOK)+1,5)
  _nrn=strtran(str(val(_nrn),len(_nrn))," ","0")
else
  _nrn="00001"
endi
appe blank                                              //nagwek dokumentu PI
repl RODZAJ_DOK with "PI",;
     DATA_DOK with date(),;
     ROK_DOK with left(dtos(date()),4),;
     NR_DOK with _nrn,;
     NR_MAG with _nr_mag,;
     WART_ZAK with _wart_zak,;
     UWAGI with "ZMIANA SPOSOBU EWIDENCJI NA FIFO",;
     OPERATOR with _operator

sele POZ_PI
repl all RODZAJ_DOK with "PI",;
         DATA_DOK with date(),;
         ROK_DOK with left(dtos(date()),4),;
         NR_DOK with _nrn,;
         NR_MAG with _nr_mag,;
         ZNAK with 1
close POZ_PI

sele 0
_use("DOK"+_nr_mag+"P","E!","DOKP")                     // pozycje dokumentu PI
set inde to ("D"+_nr_mag+"P"+"_NR"),("D"+_nr_mag+"P"+"_DI")
appe from (_sc+"POZ_PI")

close DOKP
close DOKN
close MAG
close TOW

dele file (_sc+"POZ_DOS.DBF")
dele file (_sc+"POZ_DOS.NTX")
* dele file (_sc+"POZ_PI.DBF")
dele file (_sc+"POZ_PI.NTX")
dele file (_sc+"POZ_T.NTX")

QPC(0)
cls

RETURN NIL

********************************************************************************
FUNCTION EPOT()
#ifdef M
 cls; QK("Opcja dostpna w penej wersji programu !"); RETURN NIL
#else
local _tex:='۲  ZAPOTRZEBOWANIE NA TOWARY  ',apom:={},;
      _zbiorczo
priv  _nr_kon:="     "

cls
@ 0,0 say _tex

BEGIN SEQUENCE

if !file("POTRZEBY.DBF"); QKE("Brak zbioru POTRZEBY.DBF !"); BREAK; endi

sele 0
if !_use("TOW","R","TOW_POT"); BREAK; endi
set index to TOW_IN,TOW_NA,TOW_GR,TOW_SW

sele 0
if empty(_gdzie_fir)
  if !_use("KON","R","KON_POT"); BREAK; endif
  set index to KON_NR,KON_NA,KON_NI,KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","R","KON_POT"); BREAK; endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi

/*
sele 0
if !_use("KON","R","KON_POT"); BREAK; endif
set index to KON_NR, KON_NA, KON_NI, KON_AD
*/

sele 0
*_mag_pot:="001"
_mag_pot:=if(empty(_magazyn),"001",_magazyn)
_zb:="MAG"+trans0(val(_mag_pot),3)
_i1:="M"+trans0(val(_mag_pot),3)+"_IP"
if !_use(_zb,"R","MAG_POT");  BREAK; endif
set inde to (_i1)

sele 0
if !_use("POTRZEBY","S"); BREAK; endi
set index to POT_K,POT_I

@ 1,0 say "Nr firmy :" get _nr_kon pict "99999";
           when SLGET("KON_POT","KON","V1",1,1,;
           {"numer","nazwa","NIP","miasto i ulica"},,.f.,BEZBLOK,,,0);
           valid (empty(_nr_kon).or.;
           (SZ().and.SL("KON_POT","KON","V1",1,1))).and.;
           Eval({|| KON_POT->(dbseek(_nr_kon)),devpos(row(),col()+2),;
                    devout(subs(KON_POT->NAZWA_KON,1,40)),.t. })
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

sele POTRZEBY
if !empty(_nr_kon)
  dbseek(_nr_kon)
  CPEDIT  POZ: 2,,22,              ;
          DEF: "POT"              ;
          POZWER: "V1"            ;
          POZSLAD: " "+NR_KON+" "+subs(NAZWA_KON,1,40);
          PION: ,,,                 ;
          INDEXY: {}                ;
          EDYCJA: .T.               ;
          DODAWANIE: .T.            ;
          KASOWANIE: .T.            ;      // ZAMOWIENIE=REALIZACJA;
          WARUNEK: NR_KON==_nr_kon  ;
          GORA: FilterTop(_nr_kon)    ;
          DOL:  FilterBottom(_nr_kon) ;
          DODAJ: DODAJ_POT(_nr_kon)   ;
          AKCJA: ILE_IND()          ;
          SIEC: REKORD              ;
          ODTWORZ:.f.

*         "Stan : "+transform(STAN_POT(INDEKS),_format_ilo)+;
*         "  Blok.: "+transform(BLOK_POT(INDEKS),_format_ilo);

   FilterBottom(_nr_kon)
   do while !bof().and.NR_KON==_nr_kon.and.(empty(NR_KON).or.empty(INDEKS))
     RBLOK(); dbdelete(); dbunlock()
     skip -1
   endd
else
  go top
  CPEDIT  POZ: 2,,22,               ;
          DEF: "POT"                ;
          POZWER: "V2"              ;
          POZSLAD: " "+NR_KON+" "+subs(NAZWA_KON,1,40);
          PION: ,,,                 ;
          INDEXY: {"nr firmy","indeks"}  ;
          EDYCJA : .T.;
          DODAWANIE: .T.            ;
          KASOWANIE: .T.            ;      // ZAMOWIENIE=REALIZACJA;
          AKCJA: ILE_IND()          ;
          SIEC: REKORD              ;
          ODTWORZ:.f.

*         "Stan : "+transform(STAN_POT(INDEKS),_format_ilo)+;
*         "  Blok.: "+transform(BLOK_POT(INDEKS),_format_ilo);

endi

if !empty(_nr_kon)
  copy stru to (_sc+"POT_ROB")

  sele 0
  _use(_sc+"POT_ROB","E!")

  sele POTRZEBY
  for i:=1 to fcount()
    aadd(apom,i)
  next
  dbseek(_nr_kon)
  dbeval({||RECAPPEND(POTRZEBY,POT_ROB)},,{|| NR_KON==_nr_kon})
  clos POTRZEBY

  sele POT_ROB
  go top

  CPDRUK  DEF: "POT"                 ;
          WERSJA: "V1" ;
          TYTUL: "ZAPOTRZEBOWANIE NA TOWARY  - firma "+_nr_kon+"  "+;
           subs(alltrim(NAZWA_KON),1,40)+if(!empty(MIASTO),", "+alltrim(MIASTO),"");
          WARIANT: 41
else
  go top
  CPDRUK  DEF: "POT"                 ;
          WERSJA: "V2" ;
          TYTUL: "ZAPOTRZEBOWANIE NA TOWARY - "+dtoc(date());
          WARIANT: 42
  @ 24,0
  _zbiorczo:= Horizmenu(24,0,"Zestawienie zbiorcze :",{"TAK","NIE"},2)
  @ 24,0
  if _zbiorczo<>1; BREAK; endi

  QPC(1)
  set order to 2
  total on INDEKS fiel ZAMOWIENIE,REALIZACJA for ZAMOWIENIE<>REALIZACJA;
        to (_sc+"POT_ROB")
  QPC(0)

  _use(_sc+"POT_ROB","E!")

   @ 2,0 clea to 22,79
   CPEDIT  POZ: 2,,22,              ;
          DEF: "POT"                ;
          POZWER: "V3"              ;
          PION: ,,,                 ;
          EDYCJA : .f. ;
          ODTWORZ:.f.

  go top
  CPDRUK  DEF: "POT"                 ;
          WERSJA: "V3" ;
          TYTUL: "ZAPOTRZEBOWANIE ZBIORCZE NA TOWARY - "+dtoc(date());
          WARIANT: 43
endi

END SEQUENCE
close data
dele file (_sc+"POT_ROB.DBF")
RETURN
#endi

*******************************************************************************
FUNCTION DODAJ_POT(_nr_kon)
FilterAppend({_nr_kon},{"NR_KON"})
RBLOK()

FIRMA_POT()

if _rest[NCUR]==_hor    ; _hor: panHome()
else                    ; _vert:goTop()
endif
FilterTop(_nr_kon)
do while !_rest[NCUR]:stabilize(); enddo
keyboard chr(K_CTRL_PGDN)+chr(K_ENTER)

RETURN NIL

*******************************************************************************
FUNCTION INDEKS_POT()
local _i:=s_i(INDEKS)

TOW_POT->(dbseek(_i))
repl NAZWA_TOW with TOW_POT->NAZWA_TOW,;
       JM with TOW_POT->JM
repl OPERATOR with _operator,;
     DATA_ZAM with date()
CPSwiezyrekord()
RETURN .T.

*******************************************************************************
FUNCTION FIRMA_POT()
local _n:=NR_KON
KON_POT->(dbseek(_n))
repl NAZWA_KON with KON_POT->NAZWA_KON,;
     MIASTO with KON_POT->MIASTO
CPSwiezyrekord()
RETURN .T.

*******************************************************************************
FUNCTION DAJ_ZRE()
if empty(DATA_ZRE); repl DATA_ZRE with date(); endi
RETURN .t.

*******************************************************************************
FUNCTION ILE_IND()
loca _r:=recn(),_o:=indexord(),_i:=INDEKS,_j:=JM
if lastkey()=K_SPACE
  set orde to 2
  seek _i
  if empty(_nr_kon)
    sum ZAMOWIENIE-REALIZACJA to _n while INDEKS==_i
  else
    sum ZAMOWIENIE-REALIZACJA to _n while INDEKS==_i for NR_KON==_nr_kon
  endi
  QKE("Do realizacji "+s_i(_i)+" : "+ltrim(transform(_n,_format_ilo))+" "+;
       alltrim(_j))
  dbgoto(_r)
  dbsetorder(_o)
endi
RETURN NIL

*******************************************************************************
FUNCTION STAN_POT(_ind)
local _stan:=0,_sel:=select()

sele MAG_POT
seek s_i(_ind)
dbeval({|| _stan:=_stan+STAN},,{||s_i(_ind)==s_i(INDEKS)})

sele (_sel)
RETURN _stan

*******************************************************************************
FUNCTION BLOK_POT(_ind)
local _stan_b:=0,_sel:=select()

sele MAG_POT
seek s_i(_ind)
dbeval({|| _stan_b:=_stan_b+STAN_B},,{||s_i(_ind)==s_i(INDEKS)})

sele (_sel)
RETURN _stan_b

*******************************************************************************
FUNCTION POT_INFO(_nrk,g,d)
*---------------------------- skopiowanie odpowiednich faktur
local _sele:=select(), apom:={}, bwhi, bwyk, bwar

if !file("POTRZEBY.DBF"); tone(220,1); RETURN NIL; endi

BEGIN SEQUENCE

sele 0
*_mag_pot:="001"
_mag_pot:=if(empty(_magazyn),"001",_magazyn)
_zb:="MAG"+trans0(val(_mag_pot),3)
_i1:="M"+trans0(val(_mag_pot),3)+"_IP"
if !_use(_zb,"R","MAG_POT");  BREAK; endif
set inde to (_i1)

sele 0
if !_use("TOW","R","TOW_POT"); BREAK; endif
set inde to TOW_IN

sele 0
if empty(_gdzie_fir)
  if !_use("KON","R","KON_POT"); BREAK; endif
  set index to KON_NR,KON_NA,KON_NI,KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","R","KON_POT"); BREAK; endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi

/*
sele 0
if !_use("KON","R","KON_POT"); BREAK; endif
set index to KON_NR
*/

sele 0
if !_use("POTRZEBY","S","INFO_POT"); BREAK; endif
set index to POT_K,POT_I
dbseek(_nrk)

CPEDIT  POZ: g+5,4,d-1,77         ;
        DEF: "POT"                ;
        POZWER: "V1"              ;
        PION: ,,,                 ;
        INDEXY: {}                ;
        EDYCJA: .T.               ;
        DODAWANIE: .T.            ;
        KASOWANIE: .T.            ;              //ZAMOWIENIE=REALIZACJA;
        WARUNEK: NR_KON==_nrk     ;
        GORA: FilterTop(_nrk)     ;
        DOL:  FilterBottom(_nrk)  ;
        DODAJ: DODAJ_POT(_nrk)   ;
        SIEC: REKORD              ;
        ODTWORZ:.T.

*        POZSLAD: "  Stan mag.001 : "+transform(STAN_POT(INDEKS),_format_ilo)+;
*                 "   Blokada mag.001 : "+;
*                 transform(BLOK_POT(INDEKS),_format_ilo);


END SEQUENCE
CpClose(INFO_POT)
CpClose(KON_POT)
CpClose(TOW_POT)
CpClose(MAG_POT)
RETURN  NIL

*******************************************************************************
FUNCTION NAP_DOS()
#ifdef M
 cls; QK("Opcja dostpna w penej wersji programu !"); RETURN NIL
#else
local _tex:='۲  UZGODNIENIE NUMERW PZ W DOS_N  ',;
      _nrmag:="001",_astru:={}
cls
@ 0,0 say _tex
if !HA(_haslo); RETU NIL; endi
BEGIN SEQUENCE

@ 1,0 say "Magazyn dostaw :" get _nrmag pict "@K 999" ;
           valid file("MAG"+_nrmag+".DBF")
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

_astru:={}
aadd(_astru,{"ROK_DOS",  "C",4 ,0})
aadd(_astru,{"NR_DOS",  "C",5 ,0})
aadd(_astru,{"DATA_DOK","D",8 ,0})
aadd(_astru,{"NR_DOK_DOS"    ,"C",5,0})
aadd(_astru,{"NR_DOK_PZ"    ,"C",5,0})
DbCreate(_sc+"ZLE",_astru)

sele 0
_use(_sc+"ZLE","E!")

sele 0
if !_use("DOS_N","E!"); BREAK; endif
index on NR_KON+OPIS_FAK+dtos(DATA_DOK) to (_sc+"ROB")

sele 0
if !_use ("DOK"+_nrmag+"N","E","DOKN");BREAK;endi
set rela to NR_KON+OPIS_ZRO+dtos(DATA_DOK) into DOS_N
set index to ("D"+_nrmag+"N_NR")
_total:=lastrec()/4
PASEK()
dbseek("PZ")
dbeval({|| PASEK(10),;
           ZLE->(dbappend()),;
           ZLE->ROK_DOS:=DOS_N->ROK_DOS,;
           ZLE->NR_DOS:=DOS_N->NR_DOS,;
           ZLE->DATA_DOK:=DOS_N->DATA_DOK,;
           ZLE->NR_DOK_DOS:=DOS_N->NR_DOK,;
           ZLE->NR_DOK_PZ:=DOKN->NR_DOK,;
           DOS_N->NR_DOK := DOKN->NR_DOK },;
       {|| DOS_N->NR_DOK<>DOKN->NR_DOK.and.abs(DOKN->WART_ZAK-;
           DOS_N->(WART_NET_+WART_NET0+;
                  WART_NET1+WART_NET2+WART_NET3+WART_NET4))<;
                   0.1*abs(DOKN->WART_ZAK) },;
       {|| RODZAJ_DOK=="PZ" })
PASEK()
END SEQUENCE
clos data
RETU NIL
#endi

*******************************************************************************
FUNCTION AKTU_BLO()                                         
local _tex:='۲  WERYFIKACJA REZERWACJI TOWARW '
local _azapis:={},_astru:={},_nrmag,_aktu:=.f.,_ok:=.t.,_sa_blo:=.f.,apom:={}
local _nzapis

cls
@ 0,0 say _tex

/*
if !subs(_wersja,77,1)=="B"
  QKE("Opcja aktywna w wersji programu z blokadami pozycji faktur w zapisie !")
  RETURN NIL
endi
*/

BEGIN SEQUENCE

@ 2,1 say "Uwaga : Opcja suy do aktualizacji blokad stanw magazynowych w przypadku"
@ 3,1 say "        braku ich zgodnoci z fakturami w zapisie i zamwieniami."
@ 4,1 say "        Uzgodnienie blokad naley wykona w sytuacji gdy na pozostaych"
@ 5,1 say "        stanowiskach nikt nie pracuje."

if !(QTN("Aktualizacja blokad stanw magazynowych ?").and.HA(_haslo))
  BREAK
endi

QPC(1)

sele 0
_use("SL_MAG","R!")
do whil !eof()
  if empty(NR_MAG); skip; loop; endi
  _nr_mag:=SL_MAG->NR_MAG

  sele select("MAG")
  if !_use("MAG"+_nr_mag,"E","MAG")
    _ok:=.f.
    QKE("Zbiory danych s zajte przez innego uytkownika !")
    BREAK
  else
    clos MAG
  endi

  sele SL_MAG
  skip
endd

azapis:=DIRECTORY("#00\"+"S??_P???.DBF")
_nzapis:=len(azapis);_tzapis:=ltrim(str(_nzapis))

@ 24,0 say "Etap 1/11 - weryfikacja blokad z zamwie ...     "      

sele 0
if !_use("PROZAM","R"); BREAK; endi
set index to PROZAM,PROZAM_I,PROZAM_S

sele 0
_use("BLOKADY","E!")
set index to BLOK_PO,BLOK_IN,BLOK_NR
set order to 3

/*
  inde on NR_MAG+s_i(INDEKS) to BLOK_IN
  do case
    case _rozchody="1"
      inde on NR_MAG+s_i(INDEKS)+s_c(CENA_ZAK) to BLOK_PO
    case _rozchody="2"
      inde on NR_MAG+s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK) to BLOK_PO
  endc
  inde on DR(DATA)+NR_BLO to BLOK_NR
*/

/*
  inde on NR_KON+dtos(DATA_ZAM)+SYMBOL_ZAM to PROZAM
  inde on s_i(INDEKS)+NR_KON+ dtos(DATA_ZAM)+SYMBOL_ZAM to PROZAM_I
  inde on DR(DATA_ZAM)+str(val(SYMBOL_ZAM),7)+NR_KON to PROZAM_S // uniq
*/

sele PROZAM
do while !eof()
  if "ARCH"$UWAGI .and. !empty(NR_BLO)
    
    sele BLOKADY
    seek PROZAM->NR_BLO    
    dbeval({|| BLOKADY->(dbdelete())},;
           {|| BLOKADY->DATA==PROZAM->DATA_ZAM.and.;
               BLOKADY->NR_KON==PROZAM->NR_KON},; 
           {|| BLOKADY->(DR(DATA)+NR_BLO)==PROZAM->NR_BLO})
  endi
  sele PROZAM
  skip
enddo
close BLOKADY
close PROZAM 

@ 24,0 say "Etap 2/11 - kopiowanie pozycji faktur w zapisie .."      


_astru:={}
aadd(_astru,{"NR_MAG"  ,  "C", 3, 0})
aadd(_astru,{"RODZAJ_DOK","C", 2, 0})
aadd(_astru,{"DATA_DOS",  "D", 8, 0})
aadd(_astru,{"CENA_ZAK",  "N", 9, 2})
aadd(_astru,{"INDEKS"  ,  "C",LENIN, 0})
aadd(_astru,{"ILOSC" ,    "N",10, 3})
aadd(_astru,{"NR_DOK" ,   "C", 5, 0})
dbcreate ((_sc+"BLOKUJ"),_astru)

sele 0
_use (_sc+"BLOKUJ","E!")


for i:=1 to if(subs(_wersja,77,1)=="B",len(azapis),0)                //28.12.03
  @ 24,60 say str(i,4)+"/"+ _tzapis
  appe from ("#00\"+azapis[i][1]) for !subs(RODZAJ_DOK,2,1)="K".and.;
            NR_DOK="B"
next

@ 24,0
_sa_blo:=lastrec()>0
if _sa_blo
  if _rozchody="1"
    @ 24,0 say "Etap 3/11 - sortowanie pozycji faktur w zapisie .."      
    index on NR_MAG+s_i(INDEKS)+s_c(CENA_ZAK) to (_sc+"BLOKUJ")
    @ 24,0 say "Etap 4/11 - grupowanie pozycji faktur w zapisie .."      
    total on NR_MAG+s_i(INDEKS)+s_c(CENA_ZAK) to (_sc+"BLO_TOT") fiel ILOSC
  else
    @ 24,0 say "Etap 3/11 - sortowanie pozycji faktur w zapisie .."      
    index on NR_MAG+s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK) to (_sc+"BLOKUJ")
    @ 24,0 say "Etap 4/11 - grupowanie pozycji faktur w zapisie .."      
    total on NR_MAG+s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK);
          to (_sc+"BLO_TOT") fiel ILOSC
  endi

  _use (_sc+"BLO_TOT","E!","BLOKUJ")
  @ 24,0 say "Etap 5/11 - sortowanie zgrupowanych pozycji .."      
  if _rozchody="1"
    index on NR_MAG+s_i(INDEKS)+s_c(CENA_ZAK) to (_sc+"BLOKUJ")
  else
    index on NR_MAG+s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK) to (_sc+"BLOKUJ")
  endi
  @ 24,0
endi

sele 0
if file("BLOKADY.DBF").and.file("BLOK_PO.NTX").and._use("BLOKADY","E")
  set index to BLOK_PO,BLOK_IN,BLOK_NR
  apom:={}
  for i:=1 to fcount(); aadd(apom,i); next
  @ 24,0 say "Etap 6/11 - przygotowanie do krekty ujemnych  blokad .."
  copy to (_sc+"BLO_ROB")
  zap
  appe from (_sc+"BLO_ROB")
  dele file (_sc+"BLO_ROB.DBF")
  @ 24,0
  @ 24,0 say "Etap 7/11 - grupowanie pliku 'rcznych' blokad .."
  if _rozchody="1"
    total on NR_MAG+s_i(INDEKS)+s_c(CENA_ZAK) fiel ILOSC to (_sc+"BLOM_TOT")
  elseif _rozchody="2"
    total on NR_MAG+s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK) fiel ILOSC;
                                                         to (_sc+"BLOM_TOT")
  endi
  @ 24,0
  @ 24,0 say "Etap 8/11 - korekta blokad ujemnych .."

  sele 0
  _use(_sc+"BLOM_TOT","E!")
  dele all for ILOSC>=0
  pack
  go top
  do while !eof()
    _nrb:=NR_BLO_DOM()
    eval({|| RECAPPEND(BLOM_TOT,BLOKADY)})
    BLOKADY->NR_BLO:=_nrb
    BLOKADY->UWAGI:="AUTOMATYCZNA KOREKTA BLOKADY UJEMNEJ"
    BLOKADY->NR_KON:=""
    BLOKADY->OPERATOR:=_operator
    BLOKADY->ILOSC:=-BLOKADY->ILOSC
    BLOKADY->DATA:=date()
    
    sele BLOM_TOT
    skip
  endd

  sele BLOKADY
  CPClose(BLOM_TOT)
  dele file(_sc+"BLOM_TOT.DBF")
  @ 24,0
endi
CPClose(BLOKADY)

if file("BLOKADY.DBF").and.file("BLOK_PO.NTX").and._use("BLOKADY","R")
  @ 24,0 say "Etap 9/11 - grupowanie skorygowanego pliku 'rcznych' blokad .."
  set index to BLOK_PO
  do case
    case _rozchody="1"
      total on NR_MAG+s_i(INDEKS)+s_c(CENA_ZAK) to (_sc+"BLOK_MAN");
          fiel ILOSC 
    case _rozchody="2"
      total on NR_MAG+s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK);
            to (_sc+"BLOK_MAN") fiel ILOSC
  endc
  close BLOKADY
  @ 24,0

  sele 0
  _use(_sc+"BLOK_MAN","E!")
  @ 24,0 say "Etap 9/11 - sortowanie skorygowanego pliku 'rcznych' blokad .."
  dele all for ILOSC=0
  pack
  if _rozchody="1"
    index on NR_MAG+s_i(INDEKS)+s_c(CENA_ZAK) to (_sc+"BLOK_MAN")
  else
    index on NR_MAG+s_i(INDEKS)+dtos(DATA_DOS)+s_c(CENA_ZAK) to (_sc+"BLOK_MAN")
  endi
  @ 24,0
endi


sele SL_MAG
go top
@ 24,0 say "Etap 10/11 - korygowanie  blokad .."
do whil !eof()
  if empty(NR_MAG); skip; loop; endi
  _nr_mag:=SL_MAG->NR_MAG

  sele 0
  _use("MAG"+_nr_mag,"E!","MAG")
  repl all STAN_B with 0
  close MAG

  if _sa_blo .and.BLOKUJ->(dbseek(_nr_mag))

    sele 0
    _use("MAG"+_nr_mag,"E!","MAG")
    set inde to ("M"+_nr_mag+"_IP")

    sele BLOKUJ
    if _rozchody="1"
      dbeval( {|| MAG->(dbseek(BLOKUJ->(s_i(INDEKS)+s_c(CENA_ZAK)))) ,;
                  MAG->STAN_B+=BLOKUJ->ILOSC },,{|| NR_MAG==_nr_mag})
    else
      dbeval( {|| MAG->(dbseek(BLOKUJ->(s_i(INDEKS)+dtos(DATA_DOS)+;
                                        s_c(CENA_ZAK)))),;
                  MAG->STAN_B+=BLOKUJ->ILOSC },,{|| NR_MAG==_nr_mag})
    endi
    close MAG
  endi

  if BLOK_MAN->(dbseek(_nr_mag))

    sele 0
    _use("MAG"+_nr_mag,"E!","MAG")
    set inde to ("M"+_nr_mag+"_IP")

    sele BLOK_MAN
    if _rozchody="1"
      dbeval( {|| MAG->(dbseek(BLOK_MAN->(s_i(INDEKS)+s_c(CENA_ZAK)))),;
                  MAG->STAN_B+=BLOK_MAN->ILOSC },,{|| NR_MAG==_nr_mag})
    else
      dbeval( {|| MAG->(dbseek(BLOK_MAN->(s_i(INDEKS)+dtos(DATA_DOS)+;
                                        s_c(CENA_ZAK)))),;
                  MAG->STAN_B+=BLOK_MAN->ILOSC },,{|| NR_MAG==_nr_mag})
    endi
    close MAG
  endi

  sele SL_MAG
  skip
endd

QPC(0)
tone(880,0.5)
QK("Zaktualizowano blokady stanw magazynowych !")
clear typeahead

END SEQUENCE
clos data
dele file (_sc+"BLO_TOT.DBF")
dele file (_sc+"BLOKUJ.DBF")
dele file (_sc+"BLOKUJ.NTX")
dele file (_sc+"BLOK_MAN.DBF")
dele file (_sc+"BLOK_MAN.NTX")
RETURN NIL

*******************************************************************************
FUNCTION MAG_INFO()                                                  //29.05.99
local getlist:={},_linia,_okno,_cursor:=setcursor(),g,d,_pom,_astru:={},;
      _osele:=select(),_ocolo:=SET(_SET_COLOR,_ekra_blo),;
      _old_esc:=set(_SET_ESCAPE,.t.),_r:=row(),_c:=col(),;
      _naz_kon:="",_naz_kon2:="",_miasto:="",;
      _wart_zak:=0,_wart_c1:=0,_wart_c2:=0,_wart_c3:=0,_ilosc:=0,;
      _braki1:=" ",_braki2:=" ",_braki3:=" ",_wart_zab:=0,_st_zer:="N"

priv  _mag_info:=_magazyn,_nr_info:=spac(5)

SHOWTIME()
g:=1
d:=23
_okno:=savescreen(g,1,d,78)
_linia:=savescreen(24,0,24,79)
_pom:=len(transform(1.00,_format_cen))

set key K_ALT_I to
set key K_ALT_K to
set key K_ALT_J to
set key K_CTRL_J to

BEGIN SEQUENCE

_astru:={}
aadd(_astru,{"INDEKS"     ,"C",LENIN, 0})
aadd(_astru,{"NAZWA_TOW"  ,"C",max(40,_len_naz), 0})
aadd(_astru,{"OPIS_TOW"   ,"C",max(20,_len_opi), 0})
aadd(_astru,{"JM"         ,"C", 4, 0})
aadd(_astru,{"STAN"       ,"N",12, 3})
aadd(_astru,{"WART_ZAK"   ,"N",12, 2})
dbcreate (_sc+"MAG_POZ",_astru)

sele 0                                          //21.05.99
if !_use(_sc+"MAG_POZ","E"); BREAK; endif
index on INDEKS to (_sc+"POZ_I")
index on NAZWA_TOW to (_sc+"POZ_N")
set index to (_sc+"POZ_I"),(_sc+"POZ_N")

sele 0
if empty(_gdzie_fir)
  if !_use("KON","R","KONINF"); BREAK; endif
  set index to KON_NR,KON_NA,KON_NI,KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","R","KONINF"); BREAK; endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi

sele 0
if !_use("TOW","R","TOWARY"); BREAK; endif
set inde to TOW_IN,TOW_NA,TOW_GR,TOW_SW

@ g,1 clea to d,78
@ g,1,g+8,78 BOX R_GRUBA
@ g+9,1,d,78 BOX B_DOUBLE

@ g+2,3 say "Magazyn :" get _mag_info pict "@K 999";
        vali SZ1(@_mag_info).and.file("MAG"+trans0(val(_mag_info),3)+".DBF");
              .and.!empty(_mag_info).and.SLGET()
@ g+2,18 say "Dostawca :" get _nr_info pict "@K 99999";
         when SLGET("KONINF","KON","V1|V_KONCES()",1,1,;
              {"numer","nazwa","NIP","miasto,adres"},,.f.,BEZBLOK,,,0);
         vali SZ().and.SL("KONINF","KON","V1",1,1);
             .and.!empty(_nr_info).and.SLGET()
set curs on;  read;  set curs off
if lastkey()=K_ESC; SLGET(); BREAK; endif

KONINF->(dbseek(_nr_info))
_naz_kon:=subs(rtrim(KONINF->NAZWA_KON),1,40)
_miasto:=rtrim(KONINF->MIASTO)
clos KONINF
SET(_SET_COLOR,_ekra_blo)
@ g+2,36 say padr(_naz_kon,40)
@ g+3,36 say _miasto

@ g+3,3 say "Stany zerowe (T/N) : " get _st_zer pict "@! A" valid _st_zer$"TN"
set curs on;  read;  set curs off
if lastkey()=K_ESC; SLGET(); BREAK; endif


sele 0
if !_use("MAG"+trans0(val(_mag_info),3),"R","MAGAZYN");  BREAK; endif
if _st_zer="N"
  set inde to ("M"+trans0(val(_mag_info),3)+"_IP0")
endi

_total:=lastrec()+2
PASEK()
dbeval({|| PASEK(1),;
           MAG_POZ->(dbseek(MAGAZYN->INDEKS)),;
           if(MAG_POZ->(found()),NIL,(MAG_POZ->(dbappend()),;
                                      MAG_POZ->INDEKS:=MAGAZYN->INDEKS,;
                                      MAG_POZ->NAZWA_TOW:=TOWARY->NAZWA_TOW,;
                                      MAG_POZ->OPIS_TOW:=TOWARY->OPIS_TOW,;
                                      MAG_POZ->JM:=TOWARY->JM)),;
           MAG_POZ->WART_ZAK:=MAG_POZ->WART_ZAK+MAGAZYN->(STAN*CENA_ZAK),;
           MAG_POZ->STAN:=MAG_POZ->STAN+MAGAZYN->STAN,;
           _wart_zak:=_wart_zak+MAGAZYN->(STAN*CENA_ZAK),;
           _wart_zab:=_wart_zab+MAGAZYN->(STAN*CENA_ZAK)*;
                                (1+val(TOWARY->VAT)/100),;
           if(TOWARY->CENA_1=0,_braki1:="?",NIL),;
           if(TOWARY->CENA_2=0,_braki2:="?",NIL),;
           if(TOWARY->CENA_3=0,_braki3:="?",NIL),;
           _wart_c1:=_wart_c1+MAGAZYN->STAN*TOWARY->CENA_1,;
           _wart_c2:=_wart_c2+MAGAZYN->STAN*TOWARY->CENA_2,;
           _wart_c3:=_wart_c3+MAGAZYN->STAN*TOWARY->CENA_3,;
           _ilosc:=_ilosc+MAGAZYN->STAN },;
   {|| (PASEK(1),TOWARY-> (dbseek(s_i(MAGAZYN->INDEKS))),;
                 TOWARY->NR_KON==_nr_info)})

PASEK()
restscreen(24,0,24,79,_linia)
close MAGAZYN
close TOWARY

@ g+4,3  say "Stan ogem :"+transform(_ilosc,_format_ilo)
if _udocezak
  @ g+5,3 say "Warto wg zakupu :   "
  @ g+5,25 say transform(_wart_zak,"@E 99,999,999.99")+" N"+"  "+;
               transform(_wart_zab,"@E 99,999,999.99")+" B"
endi

if _wart_c1=0; _braki1:=" "; endi
if _wart_c2=0; _braki2:=" "; endi
if _wart_c3=0; _braki3:=" "; endi

@ g+6,3  say "Wartoci wg cennika :"
@ g+6,25 say transform(_wart_c1,"@E 99,999,999.99")+" "+_ceny_1+_braki1+" "+;
             transform(_wart_c2,"@E 99,999,999.99")+" "+_ceny_2+_braki2+" "+;
             transform(_wart_c3,"@E 99,999,999.99")+" "+_ceny_3+_braki3+" "

sele MAG_POZ
go top
CPEDIT  POZ: g+9,1,d,78            ;
        DEF: "MAG_INFO"            ;
        POZWER: "V1"               ;
        POZSLAD: " "+transform(INDEKS,_format_ind)+"  "+;
                 rtrim(subs(NAZWA_TOW,1,30))+spac(4)+OPIS_TOW ;
        PION: ,,,                  ;
        INDEXY: {"indeks","nazwa"} ;
        ODTWORZ:.f.
_linia:=savescreen(24,0,24,79)
go top
CPDRUK  DEF: "MAG_INFO"            ;
        WERSJA: "VR"               ;
        TYTUL: "Magazyn "+_mag_info+", dostawca "+_nr_info+" "+_naz_kon;
        WARIANT: 17
restscreen(24,0,24,79,_linia)

END SEQUENCE

getlist:={}
CPClose(TOWARY)
CPClose(KONINF)
CPClose(MAG_POZ)  //!
set(_SET_ESCAPE,_old_esc)
restscreen(g,1,d,78,_okno)
if _osele > 0; sele (_osele); endif
setcursor(_cursor)
devpos(_r,_c)
SET(_SET_COLOR,_ocolo)
set key K_ALT_I to TOW_INFO()
setkey (K_ALT_K ,{|p,l,v| KON_INFO(p,l,v,"o")})
setkey (K_ALT_J ,{|p,l,v| KON_INFO(p,l,v,"d")})
set key K_CTRL_J to MAG_INFO()

dele file (_sc+"MAG_POZ.DBF")
dele file (_sc+"POZ_I.NTX")  //!
dele file (_sc+"POZ_N.NTX")  //!
RETU NIL

*******************************************************************************
FUNCTION USTAW()                                                     //03.07.99
loca _tex:='۲  USTALANIE PARAMETRW KONFIGURACYJNYCH PROGRAMU ',;
     _err:=.t.,_lp:=0,_stary,_znak:=" "

cls
@ 0,0 say _tex

BEGIN SEQUENCE

if !_use("CONFIG","E"); BREAK; endi

@ 1,0 say "Numer parametru : " get _lp pict "@Z 999" vali _lp>0
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi
_stary:=padr(subs(WERSJA,_lp,1),1)

@ 2,0 say "Aktualna warto : "+_stary
@ 3,0 say "Nowa warto :    " get _znak pict "X"                    //31.07.02
set curs on; read; set curs off
if lastkey()=K_ESC.or.!HA(_haslo); BREAK; endi

if fieldsize(fieldnum("WERSJA"))<_lp
  copy stru extended to XSTRUP
  _use("XSTRUP","E!")
  locate for rtrim(Field_name)=="WERSJA"
  repl  Field_len with _lp
  use
  create ("XSTRUN") from XSTRUP
  _use("XSTRUN","E!")
  appe from CONFIG
  copy to CONFIG
  use
  dele file ("XSTRUP.DBF")
  dele file ("XSTRUN.DBF")
  if !_use("CONFIG","E"); _err:=.t.;BREAK; endi
endif

if _znak<>_stary
  if _lp=1
    repl WERSJA with _znak+subs(WERSJA,2)
  else
    repl WERSJA with subs(WERSJA,1,_lp-1)+_znak+subs(WERSJA,_lp+1)
  endi

  sele 0
  if _use("STATUS","F")
    repl DATA_LIC with ""
    use
  endi

  _err:=.f.
  tone(440,1)
else
  _err:=.t.
endi

END SEQUENCE
clos data
if _err
  QKE("Nie zmieniono parametru konfiguracyjnego programu !")
else
  QKE("Zmieniono parametr konfiguracyjny programu.",;
      "        Uruchom program ponownie !         ")
  fclose(desk)
  dele file (_sc+"FLAGA")
  QUIT
endi
RETURN NIL

*******************************************************************************
FUNCTION EP(rr)
RETURN str(year(ctod("01.01."+rr)),4)

*******************************************************************************
FUNCTION V_PRE()                                                     //10.07.99
if "WART_PRE"$EDIT->POLE; retu if(!subs(_wersja,64,1)=="K",.f.,.t.); endi
RETU .T.

*******************************************************************************
FUNCTION USTAW_DRUK()
loca _tex:='۲  USTAWIANIE GLOBALNYCH PARAMETRW WYDRUKW  ',;
     _tryb:=space(5),_konw1:=space(3),_konw2:=space(3),_kody:=space(30),;
     _port:=space(4),_err:=.t.,_konw:=space(6),_rr:=space(30)

cls
@ 0,0 say _tex

BEGIN SEQUENCE

do while _err

   @ 2,0 say "Tryb drukarki:  " get _tryb  pict "@! XXXXX";
                                vali _tryb$"ESC/P|IBM  |HPPCL"
   @ 3,0 say "Port drukarki:  " get _port pict "@! AAA9";
                vali subs(_port,1,3)=="LPT".and.subs(_port,4,1)$_cenniki
   @ 4,0 say "Konwersja:      " get _konw1 pict "@!"
                @ 4,21 say "->" get _konw2 pict "@!"
   @ 5,0 say "Kody sterujce: " get _kody pict "@!"
   set curs on; read; set curs off
   if lastkey()=K_ESC; BREAK; endi

   _rr:=alltrim(_kody)

   if ((_konw1=="   ".and._konw2=="   ").or.;
      ((_konw1=="MAZ".or._konw1=="LAT").and.;
      (_konw2=="MAZ".or._konw2=="LAT".or._konw2=="STD".or._konw2=="   ").and.;
      _konw1<>_konw2)).and.;
      charrem("01234567890/,",_rr)=="".and.subs(_rr,1,1)<>",".and.;
      subs(_rr,-1)<>",".and.subs(_rr,1,1)<>"/".and.subs(_rr,-1)<>"/"

       _err:=.f.
       _konw:=_konw1+_konw2
       _use(_sc+"PARADRUK","E!")
       repl all TRYB with _tryb,;
                PORT with _port,;
                KONWERSJA with _konw,;
                KODY with _kody
       close data
   else
      QKE ("PODANO BDNE PARAMETRY !")
   endi
endd

END SEQUENCE
RETURN .T.

*******************************************************************************
FUNCTION RAP_ALERT(_kon,_typ,_dni)
// _kon - NR_KON
// _typ - "o" reklamacje odbiorcw  , "d" - reklamacje u dostawcw
local _sel:=select(),_rn:=recn(),_scie_rap

DEFAULT _dni TO 0
BEGIN SEQUENCE

sele 0
_use("CONFIG","R!")
if fieldpos("RAPORTY")>0 .and. !empty(_scie_rap:=alltrim(RAPORTY)).and.;
   if (_typ="o",file(_scie_rap+"REK_KLI.DBF"),file(_scie_rap+"REK_DOS.DBF"))
  if _typ="o"
    if !_use(_scie_rap+"REK_KLI","R"); BREAK; endi
    set index to (_scie_rap+"REK_K_N"),(_scie_rap+"REK_K_D"),;
                 (_scie_rap+"REK_K_Z")
    dbseek(_kon)
    loca for empty(DATA_OK) .and. date()-DATA_WPISU>=_dni while (NR_KON==_kon)
*    loca for empty(DATA_OK) while (NR_KON==_kon)
    if found()
      tone(440,1)
      ALERT ("Klient ma niezaatwione reklamacje !")
    endi
    close REK_KLI

  else
    if !_use(_scie_rap+"REK_DOS","R"); BREAK; endi
    set index to (_scie_rap+"REK_D_N"),(_scie_rap+"REK_D_D"),;
                 (_scie_rap+"REK_D_Z")
    dbseek(_kon)
    loca for empty(DATA_OK) .and. date()-DATA_WPISU>15 while (NR_KON==_kon)
    if found()
      tone(440,1)
      ALERT ("U dostawcy s reklamacje czekajce ponad 15 dni !")
    endi
    close REK_DOS
  endi
endi

END SEQUENCE
CpClose(CONFIG)
sele (_sel)
dbgoto(_rn)
RETURN NIL

*******************************************************************************
*******************************************************************************
*                              K A U C J E                                    *
*******************************************************************************
*******************************************************************************
FUNCTION WY_KAU(_wyr)                                                   //@//
loca _tex:=;
      '۲  EDYCJA DOKUMENTU WYDANIA OPAKOWA ZWROTNYCH  ',;
     _pierwszy,_wybor1,_wybor2,_kasuj:="T",_nag:=.f.,;
     _astru:={},_data_roz:=date()
priv _ktory_rekord:=0,_nr_mag:="   ",_nr_kon:="     ",;
     _wart_wyd:=0,_wart_zwr:=0,_wart_wyp:=0,_wart_wpl:=0,;
     _nazwa_kon,_miasto,_kod,_adres
priv _mag_kau:=spac(3)                                               //03.10.02

DEFAULT _wyr TO spac(14)

cls
@ 0,0 say _tex

BEGIN SEQUENCE

if .not.file(_sc+"DKAU.DBF")
  _astru:={}
  aadd(_astru,{"INDEKS",    "C",LENIN ,0})
  aadd(_astru,{"CENA_SPR",  "N",9,  2})
  aadd(_astru,{"NR_MAG",    "C",3,  0})
  aadd(_astru,{"NR_KON",    "C",5,  0})
  aadd(_astru,{"WYDANIE",   "N",10 ,0})
  aadd(_astru,{"ZWROT",     "N",10 ,0})
  aadd(_astru,{"WPLATA",    "N",10 ,0})
  aadd(_astru,{"WYPLATA",   "N",10 ,0})
  dbcreate (_sc+"DKAU.DBF",_astru)
endi

sele 0
_use(_sc+"DKAU","E!")
_nr_mag:=NR_MAG
_nr_kon:=NR_KON

sele 0
if empty(_gdzie_fir)
  if !_use("KON","R"); BREAK; endif
  set index to KON_NR,KON_NA,KON_NI,KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi

if file("MAG_KAU.MEM")                                               //02.10.02
  restore from MAG_KAU.MEM additive
endi
_nr_mag:=_mag_kau

sele 0
if !_use("SL_MAG","R"); BREAK; endi
set index to SL_MAG

@ 1,0 say "Magazyn : " get _nr_mag pict "999";
            when SLGET("SL_MAG","SL_MAG","V1",1,1,{"numer"},,.f.);
            valid SZ().and.SL("SL_MAG","SL_MAG","V1",1,1).and.SLGET()
@ 1,23 say "Wyrnik : " get _wyr pict "@! "+repl("X",14);
       vali !empty(_wyr).or.QTN("Wydanie opakowa bez wskazania wyrnika ?")
@ 2,0 say "Odbiorca :"
@ 2,11 get _nr_kon pict "99999";
            when SLGET("KON","KON","V1",1,1,;
           {"numer","nazwa","NIP","miasto i ulica"},,.f.,,,,0);
            valid ((SZ().and.SL("KON","KON","V1",1,1)).or.lastkey()=K_UP);
               .and.SLGET();
               .and.Eval( {||;
                        KON->(dbseek(_nr_kon)),;
                        devpos(2,18),devout(subs(KON->NAZWA_KON,1,40)),.t.})
set curs on;  read; set curs off
if lastkey()=K_ESC; BREAK; endi

_mag_kau:=_nr_mag                                                    //03.10.02
save to MAG_KAU all like _mag_kau

KON->(dbseek(_nr_kon))
_nazwa_kon:=KON->NAZWA_KON
_miasto:=KON->MIASTO
_kod:=KON->KOD
_adres:=KON->ADRES

sele 0
if !_use("TOW","R"); BREAK; endi
set index to TOW_IN,TOW_NA,TOW_GR,TOW_SW

sele 0
if !_use("MAG"+_nr_mag,"R","MAG"); BREAK; endi
set index to ("M" + _nr_mag+"_IP0")

sele 0
if !_use("ROZKAU","S"); BREAK; endi
set index to RKAU_NR,RKAU_DA,RKAU_KP

sele DKAU
set rela to s_i(INDEKS) into TOW

*------------------------------------------------------------------ptla gwna
DO WHILE .T.

  sele DKAU
  go top
  CPEDIT  POZ: 3,0,22,79      ;
          DEF: "JKAU"         ;
          POZWER: "V1|V_WKAU()";
          POZSLAD: spac(1)+;
                   if(empty(INDEKS),repl(" ",len(s_i(INDEKS))),s_i(INDEKS))+;
                   "  "+TOW->NAZWA_TOW+;
                   spac(15)+STAN_OP();
          PION: ,,,            ;
          EDYCJA: .T.          ;
          DODAWANIE: .T.       ;
          KASOWANIE: .T.       ;
          CZYDODAC: .T.        ;
          ODTWORZ:.F.          ;
          ZACHOWAJ: 0
  _pierwszy:=.t.

  do while .t.
    if .not._pierwszy
      CPEDIT KONTYNUUJ
    else
     _pierwszy:=.f.
    endi

    sele DKAU
    clea gets
    clea typeahea

    loca for empty(INDEKS)
    if found()
      dele all for empty(INDEKS); pack
    endi
    if recc()=0 ; BREAK; endi

    *------------------------------------------------------------- niekompletne
    count to _p for (WYDANIE<>0.or.WPLATA<>0).and.CENA_SPR=0
    if _p>0
      QKE("Uwaga : Niekompletne wiersze ("+alltrim(str(_p))+") - brak cen sprzedy !")
      _wybor1:=1
      _wybor1:=HorizMenu(24,0,"",;
                {"POPRAWA","SKASOWANIE NIEKOMPLETNYCH WIERSZY","ZAPIS"})
      @ 24,0
      do case
        case _wybor1=2
          if HA(_haslo)
            dele all for (WYDANIE<>0.or.WPLATA<>0).and.CENA_SPR=0
            pack
          endi
        case _wybor1=3
         _kasuj:="N"; BREAK
      endcase
      loop
    endi

    *------------------------------------------------- uzupenienia w pozycjach
    repl all DKAU->NR_MAG with _nr_mag,;
             DKAU->NR_KON with _nr_kon

    sum WYDANIE*CENA_SPR,;
        ZWROT*CENA_SPR, ;
        WPLATA*CENA_SPR, ;
        WYPLATA*CENA_SPR ;
        to _wart_wyd,_wart_zwr,_wart_wpl,_wart_wyp


    @ 21,0 say "Warto wydanych opak.:  ";
                                  +(transform(_wart_wyd,_forfak_war))
    @ 22,0 say "Warto przyjtych opak.:";
                                  +(transform(_wart_zwr,_forfak_war))
    @ 23,0 say "Saldo wydanych opakowa :";
                                  +(transform(_wart_wyd-_wart_zwr,_forfak_war))

    if subs(_wersja,110,1)<>"X"
      @ 21,41 say "Wpacona kaucja :        ";
                      +(transform(_wart_wpl,_forfak_war))
/*
      @ 22,41 say "Wypacona kaucja :       ";
                      +(transform(_wart_wyp,_forfak_war))
      @ 23,41 say "Saldo wpaconych kaucji :";
                      +(transform(_wart_wpl-_wart_wyp,_forfak_war))
*/
    endi

    count to _p for WYDANIE<>0.or.WPLATA<>0
    if _p=0.and.subs(_wersja,110,1)<>"X"
       QKE("Brak danych o wydaniu opakowa lub wpacie kaucji !")
    elseif _p=0
       QKE("Brak danych o wydaniu opakowa !")
    endi

    _wybor2:=1
    if _p>0
      _awybor:={"POPRAWA","AKCEPTACJA","ZAPIS","SKASOWANIE"}
    else
      _awybor:={"POPRAWA","ZAPIS","SKASOWANIE"}
    endi
    _nag:=.f.
    do while .t.
      @ 24,0
      _wybor2:=HorizMenu(24,0,"",_awybor,1)
      if _wybor2<>0; exit; endi
    endd

    @ 24,0
    do case
      case _awybor[_wybor2]="POPRAWA";  @ 23,0 clea to 24,79;    loop
      case _awybor[_wybor2]="AKCEPTACJA"
          if _bierny="T".or._bierny="X".or.;
           (!empty(subs(_wersja,87,1)).and.;
           val(subs(_wersja,87,1))>=_priorytet.and._nr_mag<>_magazyn)
             QKE("Operator nieupowaniony do akceptacji dokumentu  !",;
                 "      Dokument zosta umieszczony w zapisie.")
             _wybor2:=3;  _kasuj:="N";  BREAK
          else
             ROZKAU->(FBLOK()) ;  exit
          endi
      case _awybor[_wybor2]="ZAPIS";  _kasuj:="N";  BREAK
      case _wybor2=0.or._awybor[_wybor2]="SKASOWANIE"
        if QTN("Skasowanie edytowanego dokumentu ?"); BREAK
        else;  @ 23,0 clea to 24,79; loop
        endi
    endcase
  enddo // ptla edycji pozycji

  CPEDIT ZAKONCZ
  if _nag; loop; endi
  exit
ENDDO // ptla gwna z nagwkiem

*----------------------------------------------------------------- aktualizacja
QPC(1)

sele ROZKAU
set orde to 1
_nr_roz:=NR_ROZ_DO()
_data_roz:=date()
set order to 3

sele DKAU
go top
do while !eof()

  sele ROZKAU
  appe blan
  repl DATA_ROZ with _data_roz,;
       NR_ROZ with _nr_roz,;
       NR_KON with _nr_kon,;
       NR_MAG with _nr_mag,;
       INDEKS with DKAU->INDEKS,;
       CENA_SPR with DKAU->CENA_SPR,;
       WYDANIE with DKAU->WYDANIE,;
       ZWROT   with DKAU->ZWROT,;
       WPLATA with DKAU->WPLATA,;
       WYPLATA with DKAU->WYPLATA,;
       WYROZNIK with _wyr,;
       OPERATOR with _operator

  _key:=_nr_kon+DKAU->(INDEKS+NR_MAG+str(CENA_SPR,9,2))+WYROZNIK
  seek _key
  sum WYDANIE-ZWROT,WPLATA-WYPLATA;
      to _saldo_o,_saldo_k;
      for ROZLICZONY=" ";
      while NR_KON+INDEKS+NR_MAG+str(CENA_SPR,9,2)+WYROZNIK==_key
  if _saldo_o=0.and._saldo_k=0
    seek _key
    repl ROZLICZONY with "T" ;
         for ROZLICZONY=" ";
         while NR_KON+INDEKS+NR_MAG+str(CENA_SPR,9,2)+WYROZNIK==_key
  endi

  sele DKAU
  skip
endd

sele ROZKAU
set orde to 1
seek DR(_data_roz)+_nr_roz
copy to (_sc+"ROZKAU_R") while NR_ROZ==_nr_roz.and.DATA_ROZ=_data_roz

clos ROZKAU
clos DKAU
*---------------------------------------------------------- koniec aktualizacji

QPC(0)
*----------------------------------------------------------------------- wydruk

sele 0
_use(_sc+"ROZKAU_R","R!")
set rela to s_i(INDEKS) into TOW
go top
CPDRUK  DEF: "JKAU"               ;
        WERSJA: "V2|V_WKAU()"     ;
        WARIANT: 22               ;
        STOPKA : STO_KAU()        ;
        NAGLOWEK : NAG_KAU(_data_roz)

END SEQUENCE
clos data
if _kasuj="T"
  dele file(_sc+"DKAU.DBF")
endi
dele file(_sc+"ROZKAU_R.DBF")
RETURN NIL

*******************************************************************************
/*                                                                        //@//
FUNCTION ILE_OP()
repl WYDANIE with DO_WYDANIA-PRZYJETO
Cpswiezyrekord()
RETURN (WYDANIE>=0).and.(WYDANIE>=WPLATA)
*/
*******************************************************************************
FUNCTION INDEKS_OP()
go recn()
do case
  case subs(_wersja,14,1)="1"; repl CENA_SPR with ;
    iif(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
  case subs(_wersja,14,1)="2"; repl CENA_SPR with ;
    iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
  case subs(_wersja,14,1)="3"; repl CENA_SPR with ;
    iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
endc
CPswiezyrekord()
RETURN .T.

*******************************************************************************
FUNCTION STAN_OP()
loca _al:=select(),_in:=s_i(INDEKS),_stan:=0,_om,_rm
if empty(INDEKS)
 RETU " "+transform(0,_format_ilo)+"  "
endi

sele MAG
_om:=indexord()
_rm:=recn()
set orde to 3
seek _in
sum STAN to _stan whil s_i(INDEKS)==_in
set orde to _om
go _rm

sele (_al)
RETU transform(_stan,_format_ilo)

*******************************************************************************
FUNCTION ROZ_KAU(_wyr)                                                    //@//
local _tex:= '۲  ROZLICZENIE I ZWROT OPAKOWA  ',;
    _pierwszy,_wybor1,_wybor2,_nag:=.f.,;
    _astru:={},_data:=date()
priv _ktory_rekord:=0,_nr_kon:="     ",;
     _wart_wyd:=0,_wart_zwr:=0,_wart_wyp:=0,_wart_wpl:=0,_wart_kre:=0,;
     _nazwa_kon,_miasto,_kod,_adres,_zwyr                            //04.10.02

DEFAULT _wyr TO spac(14)

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use("TOW","R"); BREAK; endi
set index to TOW_IN,TOW_NA,TOW_GR,TOW_SW

sele 0
if !_use("ROZKAU","S"); BREAK; endi
set index to RKAU_NR,RKAU_DA,RKAU_KP
set orde to 3

_astru:={}
aadd(_astru,{"INDEKS",    "C",LENIN ,0})
aadd(_astru,{"CENA_SPR",  "N",9,  2})
aadd(_astru,{"NR_MAG",    "C",3,  0})
aadd(_astru,{"NR_KON",    "C",5,  0})
aadd(_astru,{"WYDANIE",   "N",10 ,0})
aadd(_astru,{"ZWROT",     "N",10 ,0})
aadd(_astru,{"WPLATA",    "N",10 ,0})
aadd(_astru,{"WYPLATA",   "N",10 ,0})
aadd(_astru,{"DO_ZWROTU", "N",10 ,0})
aadd(_astru,{"DO_WPLATY", "N",10 ,0})
aadd(_astru,{"DO_WYPLATY","N",10 ,0})
aadd(_astru,{"WYROZNIK",  "C",14 ,0})
aadd(_astru,{"ROZLICZONY","C",1  ,0})
dbcreate (_sc+"RKAU.DBF",_astru)

sele 0
_use(_sc+"RKAU","E!")

sele 0
if empty(_gdzie_fir)
  if !_use("KON","R"); BREAK; endif
  set index to KON_NR,KON_NA,KON_NI,KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi

sele 0
if !_use("SL_MAG","R"); BREAK; endi
set index to SL_MAG

@ 1,0 say "Odbiorca :"
@ 1,11 get _nr_kon pict "99999";
            when SLGET("KON","KON","V1",1,1,;
           {"numer","nazwa","NIP","miasto i ulica"},,.f.,,,,0);
            valid ((SZ().and.SL("KON","KON","V1",1,1)).or.lastkey()=K_UP);
               .and.SLGET();
               .and.Eval( {|| KON->(dbseek(_nr_kon)),;
                           devpos(1,18),devout(subs(KON->NAZWA_KON,1,40)),.t.})
set curs on;  read; set curs off
if lastkey()=K_ESC.or.empty(_nr_kon); BREAK; endi

sele ROZKAU
set orde to 3
dbseek(_nr_kon)
copy to (_sc+"ROZKAU_R") for empty(ROZLICZONY) while NR_KON==_nr_kon //02.10.02

sele 0
_use(_sc+"ROZKAU_R","E!")

QPC(1)
index on DR(DATA_ROZ)+NR_ROZ to (_sc+"ROZ_N")
index on WYROZNIK to (_sc+"ROZ_W")
set index to (_sc+"ROZ_N"),(_sc+"ROZ_W")
set rela to s_i(INDEKS) into TOW
QPC(0)
_aind:={"numer","wyrnik"}
@ 2,0 say "Wyrnik :" get _wyr pict "@! "+repl("X",14);
      when SLGET("ROZKAU_R","JKAU","V5",1,1,_aind,,.f.);
      vali SLGET()
set curs on;  read; set curs off
if lastkey()=K_ESC; BREAK; endi
CPClose(ROZKAU_R)

_zwyr:=1                                                             //04.10.02
if empty(_wyr)
  _zwyr:=Horizmenu(2,40,"Uwzgldni wyrniki :",{"TAK","NIE"},2)
endi

KON->(dbseek(_nr_kon))
_nazwa_kon:=KON->NAZWA_KON
_miasto:=KON->MIASTO
_kod:=KON->KOD
_adres:=KON->ADRES

QPC(1)

sele ROZKAU
set order to 3
seek _nr_kon
if empty(_wyr)
  if _zwyr=1                                                         //04.10.02
    total on NR_KON+INDEKS+NR_MAG+str(CENA_SPR,9,2)+WYROZNIK ;
            fiel WYDANIE,ZWROT,WPLATA,WYPLATA;
            for ROZLICZONY=" ";
            while NR_KON=_nr_kon to (_sc+"ROZKAU_R")
  else
    total on NR_KON+INDEKS+NR_MAG+str(CENA_SPR,9,2) ;
            fiel WYDANIE,ZWROT,WPLATA,WYPLATA;
            for ROZLICZONY=" ";
            while NR_KON=_nr_kon to (_sc+"ROZKAU_R")
  endi
else
  total on NR_KON+INDEKS+NR_MAG+str(CENA_SPR,9,2)+WYROZNIK ;
          fiel WYDANIE,ZWROT,WPLATA,WYPLATA;
          for ROZLICZONY=" ".and.WYROZNIK==_wyr;
          while NR_KON=_nr_kon to (_sc+"ROZKAU_R")
endi

sele RKAU
appe from (_sc+"ROZKAU_R")
if _zwyr=2                                                           //04.10.02
  repl all WYROZNIK with ""
endi
set rela to s_i(INDEKS) into TOW

QPC(0)

*------------------------------------------------------------------ptla gwna
DO WHILE .T.

  sele RKAU
  go top
  CPEDIT  POZ: 2,0,23,79      ;
          DEF: "JKAU"         ;
          POZWER: "V4|V_WKAU()";
          POZSLAD: spac(1)+;
                   if(empty(INDEKS),repl(" ",len(s_i(INDEKS))),s_i(INDEKS))+;
                   "  "+TOW->NAZWA_TOW;
          PION: ,,,            ;
          EDYCJA: .T.          ;
          ODTWORZ:.F.          ;
          ZACHOWAJ: 0
  _pierwszy:=.t.

  do while .t.                    // koniec pierwszej i powtrne edycje pozycji
    if .not._pierwszy
      CPEDIT KONTYNUUJ
    else
     _pierwszy:=.f.
    endi

    sele RKAU
    clea gets
    clea typeahea

    *----------------------------------------------------------- ostatnie puste
    go bott
    if empty(INDEKS)
      dele; pack
    endi
    if recc()=0 ; BREAK; endi

    sum DO_ZWROTU*CENA_SPR,;
        DO_WYPLATY*CENA_SPR,;
        DO_WPLATY*CENA_SPR;
    to _wart_zwr,_wart_wyp,_wart_wpl

    @ 22,0 say    "Warto przyjtych opak.:";
                                  +(transform(_wart_zwr,_forfak_war))

    if subs(_wersja,110,1)<>"X"
      @ 23,0  say "Kwota wypat kaucji :    ";
                      +(transform(_wart_wyp,_forfak_war))
    endi

    _wybor2:=1
    _nag:=.f.
    _wybor2:=HorizMenu(24,0,"",;
           {"POPRAWA","AKCEPTACJA","SKASOWANIE"})

    @ 24,0
    do case
      case _wybor2=1;  @ 23,0 clea to 24,79;    loop
      case _wybor2=2
          if _bierny="T".or._bierny="X".or.;
           (!empty(subs(_wersja,87,1)).and.;
           val(subs(_wersja,87,1))>=_priorytet.and.ZLY_MAG(5))
             QKE("Operator nieupowaniony do akceptacji dokumentu !")
             _wybor2:=1; @ 23,0 clea to 24,79;    loop
          else
             ROZKAU->(FBLOK()) ;  exit
          endi
      case _wybor2=0.or._wybor2=3
        if QTN("Skasowanie edytowanego dokumentu ?"); BREAK
        else;  @ 23,0 clea to 24,79; loop
        endi
    endcase
  enddo // ptla edycji pozycji

  CPEDIT ZAKONCZ
  if _nag; loop; endi
  exit
ENDDO // ptla gwna z nagwkiem

*----------------------------------------------------------------- aktualizacja
QPC(1)

sele ROZKAU
set orde to 3
_nr_roz:=NR_ROZ_DO()
_data_roz:=date()

sele RKAU
go top
do while !eof()
  if DO_ZWROTU=0.and.DO_WYPLATY=0; skip; loop; endi

  sele ROZKAU
  appe blan
  repl DATA_ROZ with _data_roz,;
       NR_ROZ with _nr_roz,;
       NR_KON with _nr_kon,;
       NR_MAG with RKAU->NR_MAG,;
       INDEKS with RKAU->INDEKS,;
       CENA_SPR with RKAU->CENA_SPR,;
       ZWROT with RKAU->DO_ZWROTU,;
       WYPLATA with RKAU->DO_WYPLATY,;
       WYROZNIK with RKAU->WYROZNIK,;
       OPERATOR with _operator

  _key:=_nr_kon+RKAU->(INDEKS+NR_MAG+str(CENA_SPR,9,2))+WYROZNIK
  seek _key
  sum WYDANIE-ZWROT,WPLATA-WYPLATA;
      to _saldo_o,_saldo_k;
      for ROZLICZONY=" ";
      while NR_KON+INDEKS+NR_MAG+str(CENA_SPR,9,2)+WYROZNIK==_key

  if _saldo_o=0.and._saldo_k=0
    seek _key
    repl ROZLICZONY with "T" ;
         for ROZLICZONY=" ";
         while NR_KON+INDEKS+NR_MAG+str(CENA_SPR,9,2)+WYROZNIK==_key
  endi

  sele RKAU
  skip
endd

sele ROZKAU
set orde to 1
seek DR(_data_roz)+_nr_roz
copy to (_sc+"ROZKAU_R") while DATA_ROZ==_data_roz.and.NR_ROZ==_nr_roz
clos ROZKAU
clos RKAU

*---------------------------------------------------------- koniec aktualizacji

QPC(0)
*----------------------------------------------------------------------- wydruk

sele 0
_use(_sc+"ROZKAU_R","R!")
set rela to s_i(INDEKS) into TOW
go top
CPDRUK  DEF: "JKAU"               ;
        WERSJA: "V2|V_WKAU()" ;
        WARIANT: 22                ;
        STOPKA : STO_KAU()      ;
        NAGLOWEK : NAG_KAU(_data_roz)

END SEQUENCE
clos data
dele file(_sc+"RKAU.DBF")
dele file(_sc+"ROZKAU_R.DBF")
RETURN NIL

*******************************************************************************
FUNCTION ROZLICZ_OP()
local _r
_r:=WYDANIE-ZWROT-WPLATA+WYPLATA
if fieldpos("DO_ZWROTU")>0
 _r:=_r-DO_ZWROTU-DO_WPLATY+DO_WYPLATY
endi
RETURN _r

*******************************************************************************
FUNCTION AUTO_ROZL()
RETURN WYDANIE=ZWROT+DO_ZWROTU .and. WPLATA+DO_WPLATY=WYPLATA+DO_WYPLATY

*******************************************************************************
FUNCTION NAG_KAU(_data_roz)
local _t:=0

DEFAULT _data_roz to date()

@ prow()+1,0 say padc(alltrim(_pieczat1) ,40)
_t:=_miasto_fir+dtoc(_data_roz)
@ prow(),rmarg-len(_t) say _t

@ prow()+1,0 say padc(alltrim(_pieczat2) ,40)

@ prow()+1,0 say padc(alltrim(_pieczat3) ,40)
_t:="O R Y G I N A   /  K O P I A"
@ prow(),rmarg-len(_t) say _t

if !empty(_pieczat4)
  @ prow()+1,0 say padc(alltrim(_pieczat4) ,40)
endi
if !empty(_pieczat5)
  @ prow()+1,0 say padc(alltrim(_pieczat5) ,40)
endi

if !empty(_bank_fir+_konto_fir)
  if len(_bank_fir+_konto_fir)<39
    @ prow()+1,0 say padc(alltrim(_bank_fir+"  "+_konto_fir) ,40)
  else
    @ prow()+1,0 say padc(alltrim(_bank_fir) ,40)
    @ prow()+1,0 say padc(alltrim(_konto_fir) ,40)
  endi
endi

_t:="DOKUMENT WYDANIA/ZWROTU OPAKOWA  DWZ Nr "+;
                                              _nr_roz+"/"+DE(_data_roz)
@ prow()+2,int((rmarg-len(_t))/2) say  _t

@ prow()+2,0 say "Firma :  "+_nr_kon+"  "+_nazwa_kon
@ prow()+1,0 say "Adres :  "+ltrim(alltrim(_kod)+"  "+;
                                   alltrim(_miasto)+"  "+_adres)
@ prow()+1,0 say ""
RETURN NIL

*******************************************************************************
FUNCTION STO_KAU()
local _t,_k
@ prow()+1, 0 say "Warto opakowa wydanych :   "+;
                               transform(_wart_wyd,_format_war)+" z"
if subs(_wersja,110,1)<>"X"
  @ prow(), 60 say "Warto wpaconej kaucji :    "+;
                               transform(_wart_wpl,_format_war)+" z"
endi

@ prow()+1, 0 say "Warto opakowa zwrconych : "+;
                               transform(_wart_zwr,_format_war)+" z"
if subs(_wersja,110,1)<>"X"
  @ prow(), 60 say "Warto wypaconej kaucji :   "+;
                               transform(_wart_wyp,_format_war)+" z"
endi

@ prow()+1, 0 say  "Saldo wydanych opakowa  :    "+;
                               transform(_wart_wyd-_wart_zwr,_format_war)+" z"
if subs(_wersja,110,1)<>"X"
  @ prow(), 60 say "Saldo wpaconych kaucji :     "+;
                               transform(_wart_wpl-_wart_wyp,_format_war)+" z"
endi

_t:="Sporzdzi :                            Opakowania wyda/przyj :                Potwierdzenie zgodnoci : "
_k:="........................                ..........................                .........................."

@ prow()+2,int((rmarg-len(_t))/2) say _t
@ prow()+2,int((rmarg-len(_t))/2) say _k

RETURN NIL

*******************************************************************************
FUNCTION ZKAU()
local _tex:= '۲  ZESTAWIENIE DOKUMENTW WYDA I ZWROTW OPAKOWA  '
priv _data_do:=date(),_data_od:=date(),_nr_mag:="   ",;
     _wart_wyd:=0,_wart_zwr:=0,_wart_wyp:=0,_wart_wpl:=0,_wart_kre:=0,;
     _nr_kon:=spac(5)

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if empty(_gdzie_fir)
  if !_use("KON","R"); BREAK; endif
  set index to KON_NR,KON_NA,KON_NI,KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi

sele 0
if !_use("TOW","R"); BREAK; endi
set index to TOW_IN,TOW_NA,TOW_GR,TOW_SW

sele 0
if !_use("SL_MAG","R"); BREAK; endi
set index to SL_MAG

@ 1,0 say "Magazyn : " get _nr_mag pict "999";
     when SLGET("SL_MAG","SL_MAG","V1",1,1,{"numer"},,.f.);
     valid (empty(_nr_mag).or.(SZ().and.SL("SL_MAG","SL_MAG","V1",1,1)));
     .and.SLGET()
if !(_data_beg=NIL.or._data_end=NIL)
  _data_od:=_data_beg; _data_do:=_data_end
endi
@ 2,0 say "Okres :             -"
@ 2,11 get _data_od vali _data_od<=date().and.DODATY(_data_od,@_data_do)
@ 2,22 get _data_do  valid _data_do <= date().and._data_do>=_data_od
@ 3,0 say "Odbiorca : "
@ 3,11 get _nr_kon pict "99999";
            when SLGET("KON","KON","V1",1,1,;
           {"numer","nazwa","NIP","miasto i ulica"},,.f.,,,,0);
            valid ((SZ().and.SL("KON","KON","V1",1,1)).or.empty(_nr_kon));
               .and.SLGET();
               .and.Eval( {|| KON->(dbseek(_nr_kon)),;
                        devpos(3,18),devout(subs(KON->NAZWA_KON,1,40)),.t.})
set curs on;  read; set curs off
if lastkey()=K_ESC; BREAK; endi
_data_beg:=_data_od; _data_end:=_data_do


_niero:=Horizmenu(4,0,"Operacje :",{"NIEROZLICZONE","ROZLICZONE","ZAMKNITE","WSZYSTKIE"},1)
if _niero=0; BREAK; endi

QPC(1)

sele 0
if !_use("ROZKAU","R"); BREAK; endi
set index to RKAU_NR,RKAU_DA,RKAU_KP
set orde to 2
dbseek(_data_od,.t.)
if empty(_nr_mag)
  copy to (_sc+"ROZKAU_P") while DATA_ROZ<=_data_do
else
  copy to (_sc+"ROZKAU_P") for NR_MAG==_nr_mag while DATA_ROZ<=_data_do
endi

_use(_sc+"ROZKAU_P","R")
if empty(_nr_kon)
  if _niero=1
     copy to (_sc+"ROZKAU_R") for ROZLICZONY=" "
  elseif _niero=2
     copy to (_sc+"ROZKAU_R") for ROZLICZONY<>" "
  elseif _niero=3
     copy to (_sc+"ROZKAU_R") for ROZLICZONY$"ZF"
  else
     copy to (_sc+"ROZKAU_R")
  endi
else
  if _niero=1
     copy to (_sc+"ROZKAU_R") for ROZLICZONY=" " .and.NR_KON==_nr_kon
  elseif _niero=2
     copy to (_sc+"ROZKAU_R") for ROZLICZONY<>" ".and.NR_KON==_nr_kon
  elseif _niero=3
     copy to (_sc+"ROZKAU_R") for ROZLICZONY$"ZF".and.NR_KON==_nr_kon
  else
     copy to (_sc+"ROZKAU_R") for NR_KON==_nr_kon
  endi
endi


_use(_sc+"ROZKAU_R","E!")
inde on DR(DATA_ROZ)+NR_ROZ to (_sc+"RKAU_N")
inde on NR_MAG+INDEKS+str(CENA_SPR,9,2) to (_sc+"RKAU_M")
inde on NR_KON+INDEKS+NR_MAG+str(CENA_SPR,9,2) to (_sc+"RKAU_P")
set index to (_sc+"RKAU_N") ,(_sc+"RKAU_M") ,(_sc+"RKAU_P")
set rela to NR_KON into KON
set rela to s_i(INDEKS) into TOW additive

sum ZWROT*CENA_SPR,;
    WYDANIE*CENA_SPR,;
    WYPLATA*CENA_SPR,;
    WPLATA*CENA_SPR;
     to _wart_zwr,_wart_wyd,_wart_wyp,_wart_wpl

@ 22,0  say "Warto wyda :   ";
                  +(transform(_wart_wyd,_format_war))+" z"
@ 23,0  say "Warto zwrotw : ";
                  +(transform(_wart_zwr,_format_war))+" z"
if subs(_wersja,110,1)<>"X"
    @ 22,40 say "Wpacone kaucje :  ";
                  +(transform(_wart_wpl,_format_war))+" z"
    @ 23,40 say "Wypacone kaucje : ";
                  +(transform(_wart_wyp,_format_war))+" z"
endi

QPC(0)

_uwaga:="Zestawienie obejmuje dokumenty "+;
  if(_niero=1,"nierozliczone",if(_niero=2,"rozliczone",;
              if(_niero=3,"zamknite","wszystkie")))+"."

go top
CPEDIT  POZ: 5,,21,          ;
        DEF: "JKAU"          ;
        POZWER: "V6|V_WKAU()"         ;
        PION: ,,,            ;
        INDEXY: {"numer","magazyn i indeks","nr kontrahenta"}  ;
        ODTWORZ:.F.
go top

_tyt:="ZESTAWIENIE "+;
  if(_niero=1,"NIEROZLICZONYCH",if(_niero=2,"ROZLICZONYCH",;
              if(_niero=3,"ZAMKNITYCH","WSZYSTKICH")))+;
   " DOKUMENTW RUCHU OPAKOWA"+if(empty(_nr_kon),""," firma "+_nr_kon)+;
   if(empty(_nr_mag),""," mag. "+_nr_mag)+;
   " okres "+dtoc(_data_od)+"-"+dtoc(_data_do)

_uwaga:=""

CPDRUK  DEF: "JKAU"          ;
        WERSJA: "VR"         ;
        TYTUL: _tyt;
        WARIANT: 24          ;
        STOPKA : STO_ZKAU(_uwaga)
@ 24,0

if QTN("Zestawienie zbiorcze ?")
  set orde to 2
  QPC(1)
  total on NR_MAG+INDEKS+str(CENA_SPR,9,2) ;
      fiel WYDANIE,ZWROT,WPLATA,WYPLATA to (_sc+"ROZKAU_T")
  QPC(0)

  _use(_sc+"ROZKAU_T","E!")
  set rela to s_i(INDEKS) into TOW
  go top
  CPEDIT  POZ: 3,,21,          ;
          DEF: "JKAU"          ;
          POZWER: "V7|V_WKAU()" ;
          PION: ,,,            ;
          ODTWORZ:.F.
  go top

  _tyt:="ZESTAWIENIE ZBIORCZE "+;
  if(_niero=1,"NIEROZLICZONYCH",if(_niero=2,"ROZLICZONYCH",;
              if(_niero=3,"ZAMKNITYCH","WSZYSTKICH")))+;
   " DOKUMENTW RUCHU OPAKOWA"+if(empty(_nr_kon),""," firma "+_nr_kon)+;
   if(empty(_nr_mag),""," mag. "+_nr_mag)+;
   " okres "+dtoc(_data_od)+"-"+dtoc(_data_do)


  CPDRUK  DEF: "JKAU"          ;
          WERSJA: "VR"         ;
          TYTUL: "ZBIORCZE ZESTAWIENIE WYDA I ZWROTW OPAKOWA okres "+;
                 dtoc(_data_od)+"-"+dtoc(_data_do)+;
                 if(empty(_nr_mag),""," mag. "+_nr_mag) ;
          WARIANT: 24          ;
          STOPKA : STO_ZKAU(_uwaga)
endi

END SEQUENCE
clos data
dele file(_sc+"ROZKAU_R.DBF")
dele file(_sc+"ROZKAU_T.DBF")
dele file (_sc+"RKAU_N.NTX")
dele file (_sc+"RKAU_M.NTX")
dele file (_sc+"RKAU_P.NTX")
RETURN NIL

*******************************************************************************
FUNCTION STO_ZKAU(_uwaga)
local _t,_k

if !empty(_uwaga)
  @ prow()+1, 0 say "Uwaga : "+_uwaga
endi

@ prow()+2, 0 say "Warto opakowa wydanych :   "+;
                               transform(_wart_wyd,_format_war)+" z"
@ prow()+1, 0 say "Warto opakowa zwrconych : "+;
                               transform(_wart_zwr,_format_war)+" z"
if subs(_wersja,110,1)<>"X"
  @ prow()+1, 0 say "Warto wpaconych kaucji :   "+;
                               transform(_wart_wpl,_format_war)+" z"
  @ prow()+1, 0 say "Warto wypaconych kaucji :  "+;
                               transform(_wart_wyp,_format_war)+" z"
endi

_t:="                                                                Sporzdzi :            "
_k:="                                                                ........................"
@ prow()+2,int((rmarg-len(_t))/2) say _t
@ prow()+2,int((rmarg-len(_t))/2) say _k
@ prow()+1,0 say ""

RETURN NIL

*******************************************************************************
FUNCTION PKAU()                                                           //@//
local _tex:= '۲  PRZEGLDANIE DOKUMENTW OBROTU OPAKOWANIAMI  '
priv _nr_mag:="   ",_nr_kon:="     ",_nr_roz:="     ",_data_roz:=ctod(""),;
     _ep_roz:=subs(dtos(date()),3,2),;
     _wart_wyd:=0,_wart_zwr:=0,_wart_wyp:=0,_wart_wpl:=0

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if empty(_gdzie_fir)
  if !_use("KON","R"); BREAK; endif
  set index to KON_NR,KON_NA,KON_NI,KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi

sele 0
if !_use("TOW","R"); BREAK; endi
set index to TOW_IN,TOW_NA,TOW_GR,TOW_SW

@ 1,0 say  "Odbiorca :"
@ 1,11 get _nr_kon pict "99999";
            when SLGET("KON","KON","V1",1,1,;
           {"numer","nazwa","NIP","miasto i ulica"},,.f.,,,,0);
            valid ((SZ().and.SL("KON","KON","V1",1,1)).or.empty(_nr_kon));
               .and.SLGET();
               .and.Eval( {|| KON->(dbseek(_nr_kon)),;
                        devpos(1,18),devout(subs(KON->NAZWA_KON,1,40)),.t.})
@ 2,0 say  "Rok dok. :" get _ep_roz pict "99" vali SZ().and.!" "$_ep_roz
set curs on;  read; set curs off
if lastkey()=K_ESC; BREAK; endi

sele 0
if !_use("ROZKAU","R"); BREAK; endi
set index to RKAU_NR,RKAU_DA,RKAU_KP

if !empty(_nr_kon)
  QPC(1)
  set orde to 3
  dbseek(_nr_kon)
  copy to (_sc+"ROZKAU_R") while NR_KON==_nr_kon.and.DE(DATA_ROZ)==_ep_roz

  _use(_sc+"ROZKAU_R","E!","ROZKAU")
  index on DR(DATA_ROZ)+NR_ROZ to (_sc+"RKAU_N")
  set rela to NR_KON into KON
  _aind:={"numer"}
  QPC(0)
else
  set filt to DE(DATA_ROZ)=_ep_roz
  set rela to NR_KON into KON
  _aind:={"numer","data","nr_kontrahenta"}
  go top
endi

_nr_roz:="     "
@ 2,18 say "Dokument :" get _nr_roz pict "99999";
     when SLGET("ROZKAU","JKAU","V3",1,1,_aind,,.f.);
     valid SZ().and.EXIST(ER(_ep_roz)+_nr_roz,"ROZKAU",1).and.SLGET()
set curs on;  read; set curs off
if lastkey()=K_ESC.or.empty(_nr_roz); BREAK; endi

QPC(1)
seek ER(_ep_roz)+_nr_roz
if empty(_nr_kon)
  _nr_kon:=NR_KON
  @ 1,11 get _nr_kon pict "99999"
  clear gets
  KON->(dbseek(_nr_kon))
  @ 1,18 say subs(KON->NAZWA_KON,1,40)
endi

copy to (_sc+"ROZKAU_P") while NR_ROZ==_nr_roz.and.DE(DATA_ROZ)=_ep_roz
_use(_sc+"ROZKAU_P","E!")

sum ZWROT*CENA_SPR,;
    WYDANIE*CENA_SPR,;
    WYPLATA*CENA_SPR,;
    WPLATA*CENA_SPR;
     to _wart_zwr,_wart_wyd,_wart_wyp,_wart_wpl

    @ 21,0 say "Warto wydanych opak.:  ";
                                  +(transform(_wart_wyd,_forfak_war))
    @ 22,0 say "Warto przyjtych opak.:";
                                  +(transform(_wart_zwr,_forfak_war))
    @ 23,0 say "Saldo wydanych opakowa :";
                                  +(transform(_wart_wyd-_wart_zwr,_forfak_war))

    if subs(_wersja,110,1)<>"X"
      @ 21,41 say "Wpacona kaucja :        ";
                      +(transform(_wart_wpl,_forfak_war))
      @ 22,41 say "Wypacona kaucja :       ";
                      +(transform(_wart_wyp,_forfak_war))
      @ 23,41 say "Saldo wpaconych kaucji :";
                      +(transform(_wart_wpl-_wart_wyp,_forfak_war))
    endi
QPC(0)

set rela to s_i(INDEKS) into TOW
set rela to NR_KON into KON additive
go top
_data_roz:=DATA_ROZ
_wyr:=WYROZNIK
_nr_kon:=NR_KON
@ 2,37 say "Data : "+dtoc(_data_roz)
@ 2,55 say "Wyrnik : "+_wyr

KON->(dbseek(_nr_kon))
_nazwa_kon:=KON->NAZWA_KON
_miasto:=KON->MIASTO
_kod:=KON->KOD
_adres:=KON->ADRES

go top
CPEDIT  POZ: 3,,20,          ;
        DEF: "JKAU"          ;
        POZWER: "V2|V_WKAU()"         ;
        PION: ,,,            ;
        ODTWORZ:.F.
go top
CPDRUK  DEF: "JKAU"               ;
        WERSJA: "V2|V_WKAU()" ;
        WARIANT: 22                ;
        STOPKA : STO_KAU()      ;
        NAGLOWEK : NAG_KAU(_data_roz)

END SEQUENCE
clos data
dele file(_sc+"ROZKAU_R.DBF")
dele file(_sc+"ROZKAU_P.DBF")
dele file (_sc+"RKAU_N.NTX")
RETURN NIL

*******************************************************************************
FUNCTION RKAU()                                                           //@//
local _tex:=;
      '۲  ROZLICZENIE DOKUMENTW OBROTU OPAKOWANIAMI WEDUG FIRM  '
priv _nr_mag:="   ",_nr_kon:="     ",;
     _wart_wyd:=0,_wart_zwr:=0,_wart_wyp:=0,_wart_wpl:=0,_wart_kre:=0
cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if empty(_gdzie_fir)
  if !_use("KON","R"); BREAK; endif
  set index to KON_NR,KON_NA,KON_NI,KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi

sele 0
if !_use("TOW","R"); BREAK; endi
set index to TOW_IN,TOW_NA,TOW_GR,TOW_SW

@ 1,0 say  "Odbiorca :"
@ 2,0  say "Adres :"
@ 1,11 get _nr_kon pict "99999";
            when SLGET("KON","KON","V1",1,1,;
           {"numer","nazwa","NIP","miasto i ulica"},,.f.,,,,0);
            valid (empty(_nr_kon).or.(SZ().and.SL("KON","KON","V1",1,1)));
               .and.SLGET().and.Eval( {||;
                        KON->(dbseek(_nr_kon)),;
                        devpos(1,18),devout(subs(KON->NAZWA_KON,1,40)),;
                        devpos(2,18),devout(ltrim(alltrim(KON->KOD)+;
                              " "+alltrim(KON->MIASTO)+"  "+KON->ADRES)),.t. })
set curs on;  read; set curs off
if lastkey()=K_ESC; BREAK; endi

DO WHILE .T.

@ 3,0 clea to 24,79
_zbior:=1
_niero:=1
_zbior:=Horizmenu(3,0,"Wykaz :   ",{"ZBIORCZY","SZCZEGOWY","KONIEC"},1)
if _zbior=0.or._zbior=3; BREAK; endi
_niero:=Horizmenu(4,0,"Operacje :",{"NIEROZLICZONE","ROZLICZONE","ZAMKNITE","WSZYSTKIE"},1)
if _niero=0; BREAK; endi

sele select("ROZKAU")
if !_use("ROZKAU","R"); BREAK; endi
set index to RKAU_NR,RKAU_DA,RKAU_KP

QPC(1)

set orde to 3
dbseek(_nr_kon,.t.)
if _niero=1
   copy to (_sc+"ROZKAU_R") while if(empty(_nr_kon),.t.,NR_KON==_nr_kon) ;
                            for ROZLICZONY=" "
elseif _niero=2
   copy to (_sc+"ROZKAU_R") while if(empty(_nr_kon),.t.,NR_KON==_nr_kon) ;
                            for ROZLICZONY<>" "
elseif _niero=3
   copy to (_sc+"ROZKAU_R") while if(empty(_nr_kon),.t.,NR_KON==_nr_kon) ;
                            for ROZLICZONY$"ZF"
else
   copy to (_sc+"ROZKAU_R") while if(empty(_nr_kon),.t.,NR_KON==_nr_kon)
endi

_use(_sc+"ROZKAU_R","E!","ROZKAU")
if _zbior=1
  index on NR_MAG+INDEKS+str(CENA_SPR,9,2) to (_sc+"RKAU_P")
  total on NR_MAG+INDEKS+str(CENA_SPR,9,2) ;
      fiel WYDANIE,ZWROT,WPLATA,WYPLATA to (_sc+"ROZKAU_T")
  _use(_sc+"ROZKAU_T","E!","ROZKAU")
else
  index on DR(DATA_ROZ)+NR_ROZ to (_sc+"RKAU_P")
endi

sum ZWROT*CENA_SPR,;
    WYDANIE*CENA_SPR,;
    WYPLATA*CENA_SPR,;
    WPLATA*CENA_SPR;
     to _wart_zwr,_wart_wyd,_wart_wyp,_wart_wpl

    @ 21,0 say "Warto wydanych opak.:  ";
                                  +(transform(_wart_wyd,_forfak_war))
    @ 22,0 say "Warto przyjtych opak.:";
                                  +(transform(_wart_zwr,_forfak_war))
    @ 23,0 say "Saldo wydanych opakowa :";
                                  +(transform(_wart_wyd-_wart_zwr,_forfak_war))

    if subs(_wersja,110,1)<>"X"
      @ 21,41 say "Wpacone kaucje :        ";
                      +(transform(_wart_wpl,_forfak_war))
      @ 22,41 say "Wypacone kaucje :       ";
                      +(transform(_wart_wyp,_forfak_war))
      @ 23,41 say "Saldo wpaconych kaucji :";
                      +(transform(_wart_wpl-_wart_wyp,_forfak_war))
    endi

QPC(0)

set rela to s_i(INDEKS) into TOW
if !empty(_nr_kon)
  set rela to NR_KON into KON additive
endi

KON->(dbseek(_nr_kon))
_nazwa_kon:=KON->NAZWA_KON
_miasto:=KON->MIASTO
_kod:=KON->KOD
_adres:=KON->ADRES

go top
CPEDIT  POZ: 5,,20,          ;
        DEF: "JKAU"          ;
        POZWER: if(_zbior=1,"V7","V6")+"|V_WKAU()" ;
        PION: ,,,            ;
        ODTWORZ:.F.

go top

_tyt:="ROZLICZENIE "+if(_zbior=1,"ZBIORCZE ","")+;
  if(_niero=1,"NIEROZLICZONYCH",if(_niero=2,"ROZLICZONYCH",;
              if(_niero=3,"ZAMKNITYCH","WSZYSTKICH")))+;
   " DOKUMENTW RUCHU OPAKOWA"+if(empty(_nr_kon),""," firma "+_nr_kon)

CPDRUK  DEF: "JKAU"               ;
        WERSJA: "VR" ;
        TYTUL: _tyt;
        WARIANT: 22                ;
        STOPKA : STO_RKAU(_nr_kon,_nazwa_kon,_miasto,_kod,_adres)

ENDD

END SEQUENCE
clos data
dele file(_sc+"ROZKAU_R.DBF")
dele file(_sc+"ROZKAU_T.DBF")
dele file (_sc+"RKAU_P.NTX")
RETURN NIL

*******************************************************************************
FUNCTION STO_RKAU(_nr_kon,_nazwa_kon,_miasto,_kod,_adres,_nazwa_opa)
local _t,_k

if !(_nr_kon=NIL.or.empty(_nr_kon))
  @ prow()+1,0 say "Firma : "+_nr_kon
  @ prow()+1,0 say "        "+rtrim(_nazwa_kon)+" "+_kod+" "+rtrim(_miasto);
                             +" "+rtrim(_adres)
  @ prow()+1,0 say ""
endi

if !(_nazwa_opa=NIL.or.empty(_nazwa_opa))
  @ prow()+1,0 say "Opakowanie : "+_nazwa_opa
  @ prow()+1,0 say ""
endi

@ prow()+1, 0 say  "Warto opakowa wydanych :   "+;
                               transform(_wart_wyd,_format_war)+" z"
if subs(_wersja,110,1)<>"X"
  @ prow(), 60 say "Warto wpaconych kaucji :   "+;
                               transform(_wart_wpl,_format_war)+" z"
endi

@ prow()+1, 0 say  "Warto opakowa zwrconych : "+;
                               transform(_wart_zwr,_format_war)+" z"
if subs(_wersja,110,1)<>"X"
  @ prow(), 60 say "Warto wypaconych kaucji :  "+;
                               transform(_wart_wyp,_format_war)+" z"
endi

@ prow()+1, 0 say  "Saldo wydanych opakowa  :    "+;
                               transform(_wart_wyd-_wart_zwr,_format_war)+" z"
if subs(_wersja,110,1)<>"X"
  @ prow(), 60 say "Saldo wpaconych kaucji :     "+;
                               transform(_wart_wpl-_wart_wyp,_format_war)+" z"
endi

_t:="                                                                Sporzdzi :            "
_k:="                                                                ........................"
@ prow()+2,int((rmarg-len(_t))/2) say _t
@ prow()+2,int((rmarg-len(_t))/2) say _k
@ prow()+1,0 say ""

RETURN NIL

*******************************************************************************
FUNCTION RKAU2()
local _tex:=;
      '۲  WYKAZ OPAKOWA NIEROZLICZONYCH ',_zbior:=1,;
      _kk:=0,_nazwa_opa:=""
priv _nr_mag:="   ",;
     _wart_wyd:=0,_wart_zwr:=0,_wart_wyp:=0,_wart_wpl:=0,_wart_kre:=0,;
     _indeks_opa:=transform(spac(LENIN),_format_ind)
cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if empty(_gdzie_fir)
  if !_use("KON","R"); BREAK; endif
  set index to KON_NR,KON_NA,KON_NI,KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi

sele 0
if !_use("TOW","R"); BREAK; endi
set index to TOW_IN,TOW_NA,TOW_GR,TOW_SW

@ 1,0 say  "Opakowanie :" get  _indeks_opa pict _format_ind ;
        when SLGET("TOW","TOW","V1",1,1,;
                {"indeks","nazwa","grupa",ORD4()},,.f.) ;
        vali  (_indeks_opa=" ".or.SL("TOW","TOW","V1",1,1)).and.SLGET()
_kk:=col()+3
set curs on;  read; set curs off
if lastkey()=K_ESC; BREAK; endi

TOW->(dbseek(_indeks_opa))
if !_indeks_opa=" "
  _nazwa_opa:=TOW->NAZWA_TOW
  @ 1,_kk say TOW->NAZWA_TOW
endi

sele 0
if !_use("ROZKAU","R"); BREAK; endi
set index to RKAU_NR,RKAU_DA,RKAU_KP

QPC(1)
if _indeks_opa=" "
  copy to (_sc+"ROZKAU_R") for ROZLICZONY=" "
else
  copy to (_sc+"ROZKAU_R") for ROZLICZONY=" ".and._indeks_opa==s_i(INDEKS)
endi

_use(_sc+"ROZKAU_R","E!","ROZKAU")
index on INDEKS+NR_MAG+NR_KON+str(CENA_SPR,9,2) to (_sc+"RKAU_P")
total on INDEKS+NR_MAG+NR_KON+str(CENA_SPR,9,2) ;
      fiel WYDANIE,ZWROT,WPLATA,WYPLATA to (_sc+"ROZKAU_T")
_use(_sc+"ROZKAU_T","E!","ROZKAU")

sum ZWROT*CENA_SPR,;
    WYDANIE*CENA_SPR,;
    WYPLATA*CENA_SPR,;
    WPLATA*CENA_SPR;
     to _wart_zwr,_wart_wyd,_wart_wyp,_wart_wpl

    @ 21,0 say "Warto wydanych opak.:  ";
                                  +(transform(_wart_wyd,_forfak_war))
    @ 22,0 say "Warto przyjtych opak.:";
                                  +(transform(_wart_zwr,_forfak_war))
    @ 23,0 say "Saldo wydanych opakowa :";
                                  +(transform(_wart_wyd-_wart_zwr,_forfak_war))

    if subs(_wersja,110,1)<>"X"
      @ 21,41 say "Wpacone kaucje :        ";
                      +(transform(_wart_wpl,_forfak_war))
      @ 22,41 say "Wypacone kaucje :       ";
                      +(transform(_wart_wyp,_forfak_war))
      @ 23,41 say "Saldo wpaconych kaucji :";
                      +(transform(_wart_wpl-_wart_wyp,_forfak_war))
    endi

QPC(0)

set rela to s_i(INDEKS) into TOW
set rela to NR_KON into KON additive

go top
CPEDIT  POZ: 2,,20,          ;
        DEF: "JKAU"          ;
        POZWER: if(_indeks_opa=" ","V8","V9")+"|V_WKAU()" ;
        POZSLAD: " "+subs(KON->NAZWA_KON,1,40)+"  "+;
                 if(_indeks_opa=" ",subs(TOW->NAZWA_TOW,1,34),"") ;
        PION: ,,,            ;
        ODTWORZ:.F.

go top
CPDRUK  DEF: "JKAU"               ;
        WERSJA: "VR"              ;
        TYTUL: "ZESTAWIENIE OPAKOWA NIEROZLICZONYCH"+;
                 if(_indeks_opa=" ",""," indeks"+_indeks_opa)+;
                 " data "+dtoc(date()) ;
        WARIANT: 22               ;
        STOPKA : STO_RKAU(,,,,,_nazwa_opa)


END SEQUENCE
clos data
dele file(_sc+"ROZKAU_R.DBF")
dele file(_sc+"ROZKAU_T.DBF")
dele file (_sc+"RKAU_P.NTX")
RETURN NIL

*******************************************************************************
FUNCTION NR_ROZ_DO(_rk)
loca _al:=alias(),_re,_or,_nr:="00000"

DEFAULT _rk TO subs(dtos(date()),1,4)

sele ROZKAU
_re:=recn()
_or:=indexord()
set orde to 1
dbseek(_rk+"9999:",.t.)
skip -1
if DR(DATA_ROZ)=_rk
  _nr=trans0(val(NR_ROZ)+1,5)
else
  _nr="00001"
endi
go _re
set orde to _or

sele (_al)
RETURN _nr

*******************************************************************************
FUNCTION V_WKAU()
if ("WPLAT"$EDIT->POLE.or."WYPLA"$EDIT->POLE).and.subs(_wersja,110,1)="X"
  RETURN .f.
endi
RETURN .t.

*******************************************************************************
FUNCTION FAK_KAU()                                                         //@//
local _astru:={},_tio,_tiz,_rto,_ekran,_wart:=0, _err:=.t.
local _cz,_rm,_dd,_rodz_dok,_fl,_jest_poz:=.f.
priv _nr_mag:=spac(3), _mag_kau:=spac(3)

BEGIN SEQUENCE

@ 21,0 clear to 24,79

sele 0
if !_use("TOW","R"); BREAK; endi
set index to TOW_IN

sele 0
if !_use("QSPR_N","R"); BREAK; endif
copy stru to (_sc+"SPR_N_F")
_use(_sc+"SPR_N_F","E!")
appe from (_sc+"SPR_N_R")

if _fak_kau==RODZAJ_DOK+NR_DOK+SERIA_FAK+ROK_DOK
  QKE("Faktura za opakowania bya przekazana do zapisu.")
  BREAK
else
  _fl:=RODZAJ_DOK+NR_DOK+SERIA_FAK+ROK_DOK
endi

repl RABAT with 0, PREMIA with 0,AUTO with "O",;
     NR_WZ with "",ROK_WZ with "", NR_WZ with "",;
     WART_NET_ with 0,WART_NET0 with 0,;
     WART_NET1 with 0,WART_NET2 with 0,WART_NET3 with 0,WART_NET4 with 0,;
     WART_VAT1 with 0,WART_VAT2 with 0,WART_VAT3 with 0,WART_VAT4 with 0,;
     UWAGI with "OPAKOWANIA ZWROTNE DO "+RODZAJ_DOK+" "+NR_DOK+"/"+SERIA_FAK+;
                "/"+DE(DATA_DOK),;
     NR_DOK with "",WART_ZAK with 0, WART_ZAP with 0, WPLATA with 0,;
     DATA_WZ with ctod("")


sele 0
if !_use("SL_MAG","R"); BREAK; endif
set index to SL_MAG

if file("MAG_KAU.MEM")
  restore from MAG_KAU.MEM additive
endi
_nr_mag:=_mag_kau
@ 24,0
@ 24,0 say "Magazyn opakowa : " get _nr_mag pict "@K 999";
           when SLGET("SL_MAG","SL_MAG","V2",1,1,{"magazyn"},,.f.);
           valid SZ().and.SL("SL_MAG","SL_MAG","V2",1,1)
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi
close SL_MAG
@ 24,0

_mag_kau:=_nr_mag                                                    //03.10.02
save to MAG_KAU all like _mag_kau

sele SPR_N_F
repl  NR_MAG with _nr_mag
_rodz_dok:=RODZAJ_DOK

sele 0
if !_use("QSPR_P","R"); BREAK; endif
copy stru to (_sc+"SPR_P_F")
use

sele 0
_use(_sc+"SPR_P_R","E!","POZ")
set rela to s_i(INDEKS) into TOW

sele 0
_use(_sc+"SPR_P_F","E!")

sele 0
_astru:={}
CPClose(FKAU)
dele file (_sc+"FKAU.DBF")
aadd(_astru,{"INDEKS",    "C",LENIN ,0})
aadd(_astru,{"CENA_SPR",  "N",9,  2})
aadd(_astru,{"ILOSC",   "N",10 ,0})
dbcreate (_sc+"FKAU.DBF",_astru)
_use(_sc+"FKAU","E!")
index on s_i(INDEKS) to (_sc+"FKAU_I")

sele POZ
go top
do while .not.eof()
  _rto:=TOW->(recn())
  _tio:=s_i(TOW->INDEKS_O)
  if !_tio==s_i(spac(LENIN))
    if !(FKAU->(dbseek(_tio)))
      FKAU-> (dbappend())
      repl FKAU->INDEKS with TOW->INDEKS_O
      TOW->(dbseek(_tio))
      do case
        case subs(_wersja,14,1)="1"; repl FKAU->CENA_SPR with ;
           iif(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="2"; repl FKAU->CENA_SPR with ;
           iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="3"; repl FKAU->CENA_SPR with ;
           iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
      endc
      TOW->(dbgoto(_rto))
    endi
    repl FKAU->ILOSC with FKAU->ILOSC+POZ->ILOSC
  endi

  _tiz:=s_i(TOW->INDEKS_Z)
  if !_tiz==s_i(spac(LENIN)) .and. TOW->OPAKOWANIE >0
    if !(FKAU->(dbseek(_tiz)))
      FKAU-> (dbappend())
      repl FKAU->INDEKS with TOW->INDEKS_Z
      TOW->(dbseek(_tiz))
      do case
        case subs(_wersja,14,1)="1"; repl FKAU->CENA_SPR with ;
           iif(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="2"; repl FKAU->CENA_SPR with ;
           iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(TOW->VAT)/100))
        case subs(_wersja,14,1)="3"; repl FKAU->CENA_SPR with ;
           iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(TOW->VAT)/100))
      endc
      TOW->(dbgoto(_rto))
    endi
    repl FKAU->ILOSC with FKAU->ILOSC+POZ->ILOSC/max(TOW->OPAKOWANIE,0)
  endi

  sele POZ
  skip
endd
close POZ

// FKAU - zawiera indeksy, ceny, iloci opakowa
// SPR_N_F - nagwek pobrany z faktury oryginalnej
// SPR_P_F - puste pozycje faktury oryginalnej
// TOW - otwarty

sele 0
if !_use("MAG"+_nr_mag,"F","MAG"); BREAK; endi
set inde to ("M"+_nr_mag+"_IP"),("M"+_nr_mag+"_N"),;
            ("M"+_nr_mag+"_IP0"),("M"+_nr_mag+"_N0")
set rela to s_i(INDEKS) into TOW

sele FKAU
go top
do  while !eof()

  _ile:=FKAU->ILOSC
  if _ile<=0; skip; loop; endi

  sele MAG
  dbseek(s_i(FKAU->INDEKS))
  if found(); _rm:=MAG->(recn()); endi

  _cz:=TOW->CENA_ZAK                                                //27.08.02
  _dd:=date()                                                       //27.08.02
  _jest_poz:=.f.
  do while _ile>0.and.s_i(FKAU->INDEKS)==s_i(MAG->INDEKS).and.!eof()
    _cz:=CENA_ZAK
    _dd:=DATA_DOS
    _rm:=MAG->(recn())

    if STAN<=0; skip; loop; endi
    _ro:=if(_ile>STAN,STAN,_ile)

    SPR_P_F->(APPE_BLOK())
    _jest_poz:=.t.
    SPR_P_F->INDEKS:=FKAU->INDEKS
    SPR_P_F->CENA_ZAK:= _cz //CENA_ZAK
    SPR_P_F->DATA_DOS:=_dd  //DATA_DOS
    SPR_P_F->CENA_SPR:=FKAU->CENA_SPR
    SPR_P_F->BONIFIKATA:=FKAU->CENA_SPR
    SPR_P_F->ILOSC:=_ro
    SPR_P_F->ZNAK:=-1
    _ile:=_ile-_ro

    sele MAG
    dbgoto(_rm)
    skip
  endd
  _rf:=FKAU->(recn())

  if _ile>0
    tone(220,1)
    QKE("Uwaga : Brak opakowa "+s_i(FKAU->INDEKS)+" na magazynie "+_nr_mag+" !")

    if !_jest_poz
      SPR_P_F->(APPE_BLOK())
      SPR_P_F->INDEKS:=FKAU->INDEKS
      SPR_P_F->CENA_ZAK:= _cz //CENA_ZAK
      SPR_P_F->DATA_DOS:=_dd  //DATA_DOS
      SPR_P_F->CENA_SPR:=FKAU->CENA_SPR
      SPR_P_F->BONIFIKATA:=FKAU->CENA_SPR
      SPR_P_F->ILOSC:=_ile
      SPR_P_F->ZNAK:=-1
    else
      SPR_P_F->ILOSC:=SPR_P_F->ILOSC+_ile
    endi
  endi

  sele FKAU
  dbgoto(_rf)
  skip
endd

go top
do while !eof()
  if !INDEKS_OK(); BREAK; endi

  sele FKAU
  skip
endd
close FKAU

dele file (_sc+"FKAU.DBF")
dele file (_sc+"FKAU_I.NTX")

_rt=TOW->(recn())

sele SPR_P_F
go top
do while !eof()

  TOW->(dbseek(SPR_P_F->(INDEKS)))

  repl SPR_P_F->VAT with TOW->VAT
  do case
    case _nr_cen_spr="1"
      repl SPR_P_F->CENA_CEN_S with ;
              if(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(SPR_P_F->VAT)/100))
      repl SPR_P_F->CENA_BRU with ;
              if(_ceny_1="B",TOW->CENA_1,TOW->CENA_1*(1+val(SPR_P_F->VAT)/100))
    case _nr_cen_spr="2"
      repl SPR_P_F->CENA_CEN_S with ;
              iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(SPR_P_F->VAT)/100))
      repl SPR_P_F->CENA_BRU with ;
              if(_ceny_2="B",TOW->CENA_2,TOW->CENA_2*(1+val(SPR_P_F->VAT)/100))
    case _nr_cen_spr="3"
      repl SPR_P_F->CENA_CEN_S with ;
              iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(SPR_P_F->VAT)/100))
      repl SPR_P_F->CENA_BRU with ;
              if(_ceny_3="B",TOW->CENA_3,TOW->CENA_3*(1+val(SPR_P_F->VAT)/100))
  endc
  repl  SPR_P_F->CENA_DET  with CENA_BRU

  do case
    case _nr_cen_prz="1"; repl SPR_P_F->CENA_CEN_P with ;
                       iif(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(SPR_P_F->VAT)/100))
    case _nr_cen_prz="2"; repl SPR_P_F->CENA_CEN_P with ;
                       iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(SPR_P_F->VAT)/100))
    case _nr_cen_prz="3"; repl SPR_P_F->CENA_CEN_P with ;
                       iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(SPR_P_F->VAT)/100))
  endc
  repl SPR_P_F->NAZWA_TOW  with TOW->NAZWA_TOW,;
       SPR_P_F->OPIS_TOW   with TOW->OPIS_TOW,;
       SPR_P_F->JM         with TOW->JM,;
       SPR_P_F->SWW        with TOW->SWW,;
       SPR_P_F->GRUPA_TOW  with TOW->GRUPA_TOW,;
       SPR_P_F->USLUGA     with TOW->USLUGA,;
       SPR_P_F->NR_KON     with TOW->NR_KON,;
       SPR_P_F->OPAKOWANIE with max(TOW->OPAKOWANIE,0)

  sele SPR_P_F
  skip
endd
TOW->(dbgoto(_rt))

sele SPR_P_F
repl all RODZAJ_DOK with SPR_N_F->RODZAJ_DOK,;
         DATA_DOK with SPR_N_F->DATA_DOK,;
         ROK_DOK with SPR_N_F->ROK_DOK,;
         SERIA_FAK with SPR_N_F->SERIA_FAK,;
         NR_MAG with SPR_N_F->NR_MAG

sele SPR_P_F
sum zaokr(ILOSC*CENA_ZAK,2),;
      if(VAT$"zw,np", zaokr(ILOSC*CENA_SPR,2),0),;
      if(VAT=" 0", zaokr(ILOSC*CENA_SPR,2),0),;
      if(VAT=_vat1,zaokr(ILOSC*CENA_SPR,2),0),;
      if(VAT=_vat2,zaokr(ILOSC*CENA_SPR,2),0),;
      if(VAT=_vat3,zaokr(ILOSC*CENA_SPR,2),0),;
      if(VAT=_vat4,zaokr(ILOSC*CENA_SPR,2),0),;
      zaokr((BONIFIKATA-CENA_SPR)*ILOSC,2),;
      if(CENA_CEN_S=0,zaokr((BONIFIKATA-CENA_SPR)*ILOSC,2),;
                      zaokr((CENA_CEN_S-CENA_SPR)*ILOSC,2)) ;
    to _wart_zak,_wart_n__,_wart_n_0,_wart_n_1,_wart_n_2,_wart_n_3,_wart_n_4,;
       _wart_b,_wart_k

if "."$_format_ilo
    _wart_zak:=zaokr(_wart_zak,2)
    _wart_n__:=zaokr(_wart_n__,2)
    _wart_n_0:=zaokr(_wart_n_0,2)
    _wart_n_1:=zaokr(_wart_n_1,2)
    _wart_n_2:=zaokr(_wart_n_2,2)
    _wart_n_3:=zaokr(_wart_n_3,2)
    _wart_n_4:=zaokr(_wart_n_4,2)
endi
_wart_v_1:=zaokr(_wart_n_1*val(_vat1)/100,2)
_wart_v_2:=zaokr(_wart_n_2*val(_vat2)/100,2)
_wart_v_3:=zaokr(_wart_n_3*val(_vat3)/100,2)
_wart_v_4:=zaokr(_wart_n_4*val(_vat4)/100,2)
_wart_n_spr:=_wart_n__+_wart_n_0+_wart_n_1+_wart_n_2+_wart_n_3+_wart_n_4
_wart_v_spr:=_wart_v_1+_wart_v_2+_wart_v_3+_wart_v_4

sele SPR_N_F
repl SPR_N_F->WART_ZAK   with _wart_zak,;
     SPR_N_F->WART_NET_  with _wart_n__, SPR_N_F->WART_NET0 with _wart_n_0,;
     SPR_N_F->WART_NET1  with _wart_n_1, SPR_N_F->WART_NET2 with _wart_n_2,;
     SPR_N_F->WART_VAT1  with _wart_v_1, SPR_N_F->WART_VAT2 with _wart_v_2,;
     SPR_N_F->WART_VAT3  with _wart_v_3, SPR_N_F->WART_NET3 with _wart_n_3,;
     SPR_N_F->WART_VAT4  with _wart_v_4, SPR_N_F->WART_NET4 with _wart_n_4,;
     SPR_N_F->BONIFIKATA with _wart_b,   SPR_N_F->RABAT_NET with _wart_k,;
     SPR_N_F->WART_ZAP   with _wart_n_spr+_wart_v_spr

close SPR_N_F
close SPR_P_F

*----------------------------------------------------------------------------

if !subs(_wersja,77,1)$"Bb"
    _zapisal:=.f.
    for i:=0 to 99
      _nr:=trans0(i,2)
      if !file(_sc+"\"+"S"+_rodz_dok+"_NR"+_nr+".DBF").and.;
         !file(_sc+"\"+"S"+_rodz_dok+"_PR"+_nr+".DBF")
        _zapisal:=.t.
        copy file (_sc+"SPR_N_F.DBF");
                           to (_sc+"S"+_rodz_dok+"_NR"+_nr+".DBF")
        copy file (_sc+"SPR_P_F.DBF");
                           to (_sc+"S"+_rodz_dok+"_PR"+_nr+".DBF")

*        copy file (_sc+"FAK_TXT.DBF");
*                           to (_sc+"FAK_TX"+_nr+".DBF")
        dele file (_sc+"FAK_TX"+_nr+".DBF")

        exit
      endi
    next
    if !_zapisal
      QKE(" Nie dokonano zapisu  faktury. ",;
          "Wyczerpany limit zapisw (100).")
    endi
else
    _zapisal:=.f.
    for i:=0 to 999
      _nr:=trans0(i,3)
      if !file("#00\flaga"+_nr).and.;
         !file("#00\"+"S"+_rodz_dok+"_N"+_nr+".DBF").and.;
         !file("#00\"+"S"+_rodz_dok+"_P"+_nr+".DBF")

        _flaga:=fcreate("#00\flaga"+_nr)
        fclose(_flaga)
        _zapisal:=.t.

        copy file (_sc+"SPR_N_F.DBF");
                              to ("#00\"+"S"+_rodz_dok+"_N"+_nr+".DBF")
        copy file (_sc+"SPR_P_F.DBF");
                              to ("#00\"+"S"+_rodz_dok+"_P"+_nr+".DBF")

*          copy file (_sc+"FAK_TXT.DBF");
*                              to ("#00\"+"FAK_T"+_nr+".DBF")
        dele file ("#00\"+"FAK_T"+_nr+".DBF")

        dele file (_sc+"S"+_rodz_dok+"_N_F.DBF")
        dele file (_sc+"S"+_rodz_dok+"_P_F.DBF")
        dele file ("#00\flaga"+_nr)
        exit
      endi
    next
    if !_zapisal
      QKE(" Nie dokonano zapisu  faktury. ",;
          "Wyczerpany limit zapisw (1000).")
    endi
endi

CPClose(SPR_N_F)
CPClose(SPR_P_F)
CPClose(FAK_TXT)

_err:=.f.
END SEQUENCE
close data
if _err
  tone(220,1)
  QKE("Nie utworzono faktury za opakowania !")
else
  QKE("Faktur za opakowania umieszczono w zapisie !")
  _fak_kau:=_fl
endi

RETURN _nr_mag

*******************************************************************************
FUNCTION ZAM_KAU()                                                        //@//
local _tex:=;
    '۲  ZAMKNICIE NIEROZLICZONYCH DOKUMENTW WYDA I ZWROTW  ',;
      _azam:={}
priv _nr_mag:="   ",_nr_kon:="     ",;
     _wart_wyd:=0,_wart_zwr:=0,_wart_wyp:=0,_wart_wpl:=0
cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if empty(_gdzie_fir)
  if !_use("KON","R"); BREAK; endif
  set index to KON_NR,KON_NA,KON_NI,KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi

sele 0
if !_use("TOW","R"); BREAK; endi
set index to TOW_IN,TOW_NA,TOW_GR,TOW_SW

if subs(_wersja,100,1)="O"
 @ 4,0 say "Uwaga : Tylko dokumenty o zerowym saldzie kaucji mog by"
 @ 5,0 say "        zamkniete i przekazane do zafakturowania."
endi

@ 1,0 say  "Odbiorca :"
@ 2,0  say "Adres :"
@ 1,11 get _nr_kon pict "99999";
            when SLGET("KON","KON","V1",1,1,;
           {"numer","nazwa","NIP","miasto i ulica"},,.f.,,,,0);
            valid (SZ().and.SL("KON","KON","V1",1,1));
               .and.SLGET().and.Eval( {||;
                        KON->(dbseek(_nr_kon)),;
                        devpos(1,18),devout(subs(KON->NAZWA_KON,1,40)),;
                        devpos(2,18),devout(ltrim(alltrim(KON->KOD)+;
                              " "+alltrim(KON->MIASTO)+"  "+KON->ADRES)),.t. })
set curs on;  read; set curs off
if lastkey()=K_ESC; BREAK; endi

@ 4,0 clea to 5,79

sele 0
if !_use("ROZKAU","S"); BREAK; endi
set index to RKAU_NR,RKAU_DA,RKAU_KP

QPC(1)

set orde to 3
dbseek(_nr_kon,.t.)
copy to (_sc+"ROZKAU_R") while NR_KON==_nr_kon for ROZLICZONY=" "

sele 0
_use(_sc+"ROZKAU_R","E!")
repl all WYDANIE with WYDANIE*CENA_SPR, ZWROT with ZWROT*CENA_SPR,;
         WPLATA  with WPLATA*CENA_SPR, WYPLATA with WYPLATA*CENA_SPR
index on DR(DATA_ROZ)+NR_ROZ to (_sc+"RKAU_F")
total on DR(DATA_ROZ)+NR_ROZ;
         fiel WYDANIE,ZWROT,WPLATA,WYPLATA to (_sc+"ROZKAU_T")

_use(_sc+"ROZKAU_T","E!")
dele file (_sc+"ROZKAU_R.DBF")
index on DR(DATA_ROZ)+NR_ROZ to (_sc+"RKAU_F")                       //02.10.02
index on WYROZNIK to (_sc+"RKAU_W")
set index to (_sc+"RKAU_W"),(_sc+"RKAU_F")

sum ZWROT,WYDANIE to _wart_zwr,_wart_wyd
@ 21,0 say "Warto wydanych opak.:  ";
                                  +(transform(_wart_wyd,_format_war))
@ 22,0 say "Warto przyjtych opak.:";
                                  +(transform(_wart_zwr,_format_war))
@ 23,0 say "Saldo wydanych opakowa :";
                                  +(transform(_wart_wyd-_wart_zwr,_format_war))
QPC(0)

KON->(dbseek(_nr_kon))
_nazwa_kon:=KON->NAZWA_KON
_miasto:=KON->MIASTO
_kod:=KON->KOD
_adres:=KON->ADRES

go top
@ 3,0 say "Zaznacz dokumenty do zamknicia klawiszem INS :"
CPEDIT  POZ: 4,,20,          ;
        DEF: "SKAU"          ;
        POZWER: "V2|V_WKAU()" ;
        PION: ,,,            ;
        INDEXY: {"wyrnik","numer dokumentu"}    ;
        ODTWORZ:.F.

if len(_zaznaczone)>0
  set filter to ascan(_zaznaczone,recn())>0
else
  QKE("Nie zaznaczono dokumentw do zamknicia !")
  BREAK
endi
if !(QTN("Zamknicie zaznaczonych dokumentw ?").and.HA(_haslo))
  BREAK
endi

QPC(1)

sele ROZKAU
set order to 1

sele ROZKAU_T
go top
do while !eof()
  ROZKAU->(dbseek(ROZKAU_T->(DR(DATA_ROZ)+NR_ROZ)))
  ROZKAU->(dbeval({|| RBLOK(),ROZKAU->ROZLICZONY:="Z",dbunlock()},,;
                  {|| DR(DATA_ROZ)+NR_ROZ==ROZKAU_T->(DR(DATA_ROZ)+NR_ROZ)}))
  sele ROZKAU_T
  skip
endd

QKE("Zamknito zaznaczone dokumenty wyda i zwrotw opakowa.",;
    "  Na nierozliczone opakowania naley wystawi faktury ! ")

END SEQUENCE
clos data
dele file(_sc+"ROZKAU_R.DBF")
dele file(_sc+"ROZKAU_T.DBF")
dele file (_sc+"RKAU_P.NTX")
RETURN NIL

*******************************************************************************
FUNCTION FAK_ZAM()                                                        //@//
local _tex:= '۲  PRZYGOTOWANIE FAKTUR DO ZAMKNITYCH DOKUMENTW WYDA I ZWROTW  '
local _astru:={},_tio,_tiz,_rto,_wart:=0, _err:=.t.
local _cz,_rm,_dd,_rodz_dok,_fl,_nr_cen_spr:=subs(_wersja,14,1)
priv _nr_mag:=spac(3), _mag_kau:=spac(3)
priv _nr_mag:="   ",_nr_kon:="     ",_nr_roz:="     ",_data_roz:=ctod(""),;
     _ep_roz:=subs(dtos(date()),3,2),;
     _wart_wyd:=0,_wart_zwr:=0,_wart_wyp:=0,_wart_wpl:=0,;
     _typ_dok:="-"

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if empty(_gdzie_fir)
  if !_use("KON","R"); BREAK; endif
  set index to KON_NR,KON_NA,KON_NI,KON_AD
else
  if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endif
  set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
               (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
endi

sele 0
if !_use("TOW","R"); BREAK; endi
set index to TOW_IN,TOW_NA,TOW_GR,TOW_SW

@ 1,0 say  "Odbiorca :"
@ 1,11 get _nr_kon pict "99999";
            when SLGET("KON","KON","V1",1,1,;
           {"numer","nazwa","NIP","miasto i ulica"},,.f.,,,,0);
            valid (SZ().and.SL("KON","KON","V1",1,1));
               .and.SLGET();
               .and.Eval( {|| KON->(dbseek(_nr_kon)),;
                        devpos(1,18),devout(subs(KON->NAZWA_KON,1,40)),.t.})
@ 2,0 say  "Rok dok. :" get _ep_roz pict "99" vali SZ().and.!" "$_ep_roz
set curs on;  read; set curs off
if lastkey()=K_ESC; BREAK; endi

sele 0
if !_use("ROZKAU","S"); BREAK; endi
set index to RKAU_NR,RKAU_DA,RKAU_KP

QPC(1)
set orde to 3
dbseek(_nr_kon)
copy to (_sc+"ROZKAU_R") while NR_KON==_nr_kon.and.DE(DATA_ROZ)==_ep_roz;
                         for ROZLICZONY="Z"
set order to 1

sele 0
_use(_sc+"ROZKAU_R","E!")
index on DR(DATA_ROZ)+NR_ROZ to (_sc+"RKAU_N")
set rela to NR_KON into KON
_aind:={"numer"}

QPC(0)

_nr_roz:="     "
@ 2,18 say "Dokument :" get _nr_roz pict "99999";
     when SLGET("ROZKAU_R","JKAU","V3",1,1,_aind,,.f.);
     valid SZ().and.EXIST(ER(_ep_roz)+_nr_roz,"ROZKAU_R",1).and.SLGET()
set curs on;  read; set curs off
if lastkey()=K_ESC.or.empty(_nr_roz); BREAK; endi

QPC(1)
seek ER(_ep_roz)+_nr_roz
copy to (_sc+"ROZKAU_P") while NR_ROZ==_nr_roz.and.DE(DATA_ROZ)=_ep_roz

sele 0
_use(_sc+"ROZKAU_P","E!")

sum ZWROT*CENA_SPR,;
    WYDANIE*CENA_SPR,;
    WYPLATA*CENA_SPR,;
    WPLATA*CENA_SPR;
     to _wart_zwr,_wart_wyd,_wart_wyp,_wart_wpl

    @ 22,0 say "Saldo wydanych opakowa :";
                                  +(transform(_wart_wyd-_wart_zwr,_forfak_war))
    if subs(_wersja,110,1)<>"X"
      @ 22,41 say "Saldo wpaconych kaucji :";
                      +(transform(_wart_wpl-_wart_wyp,_forfak_war))
    endi

QPC(0)

set rela to s_i(INDEKS) into TOW
set rela to NR_KON into KON additive
go top
_data_roz:=DATA_ROZ
_wyr:=WYROZNIK
_nr_kon:=NR_KON
@ 2,37 say "Data : "+dtoc(_data_roz)
@ 2,55 say "Wyrnik : "+_wyr

KON->(dbseek(_nr_kon))
_nazwa_kon:=KON->NAZWA_KON
_miasto:=KON->MIASTO
_kod:=KON->KOD
_adres:=KON->ADRES
_id_kon:=KON->ID_KON

go top
CPEDIT  POZ: 3,,21,          ;
        DEF: "JKAU"          ;
        POZWER: "V2|V_WKAU()"         ;
        PION: ,,,            ;
        ODTWORZ:.F.

/*
go top
CPDRUK  DEF: "JKAU"               ;
        WERSJA: "V2|V_WKAU()" ;
        WARIANT: 22                ;
        STOPKA : STO_KAU()      ;
        NAGLOWEK : NAG_KAU(_data_roz)
*/

@ 23,0 clea to 24,79
if Horizmenu(23,0,"Przygotowanie faktury za nierozliczone opakowania :",;
                  {"TAK","NIE"},2)=2
  BREAK
endi

sele 0
_astru:={}
CPClose(FKAU)
dele file (_sc+"FKAU.DBF")
aadd(_astru,{"INDEKS",    "C",LENIN ,0})
aadd(_astru,{"CENA_SPR",  "N",9,  2})
aadd(_astru,{"WART_SPR",  "N",12, 2})
aadd(_astru,{"ILOSC",   "N",10 ,0})
dbcreate (_sc+"FKAU.DBF",_astru)
_use(_sc+"FKAU","E!")
index on s_i(INDEKS)+str(CENA_SPR,9,2) to (_sc+"FKAU_I")

sele ROZKAU_P
go top
do while !eof()
  if ROZKAU_P->(WYDANIE-ZWROT)<=0; skip; endi

  FKAU->(dbseek(ROZKAU_P->(s_i(INDEKS)+str(CENA_SPR,9,2))))
  if(FKAU->(found()),NIL,(FKAU->(dbappend()),;
                                 FKAU->INDEKS:=ROZKAU_P->INDEKS,;
                                 FKAU->CENA_SPR:=ROZKAU_P->CENA_SPR))
  FKAU->ILOSC+=ROZKAU_P->(WYDANIE-ZWROT)

  sele ROZKAU_P
  skip
endd

sele FKAU
repl all WART_SPR with ILOSC*CENA_SPR
index on INDEKS to (_sc+"FKAU")
total on INDEKS fiel ILOSC,WART_SPR to (_sc+"FKAU_T")

_use(_sc+"FKAU_T","E!","FKAU")
* dele file (_sc+"FKAU.DBF")
dele file (_sc+"FKAU.NTX")
repl all CENA_SPR with WART_SPR/ILOSC

sele 0
if !_use("QSPR_N","R"); BREAK; endif
copy stru to (_sc+"SPR_N_F")
_use(_sc+"SPR_N_F","E!")
appe blan
repl DATA_DOK with date(),NR_KON with _nr_kon,;
     NAZWA_KON with _nazwa_kon,ADRES with _adres,MIASTO with _miasto,;
     ID_KON with _id_kon, RODZAJ_DOK with "FA", ROK_DOK with DR(date()),;
     UWAGI with "WEDUG DWZ "+;
     _nr_roz+"/"+DE(_data_roz)+if(empty(_wyr),""," ("+alltrim(_wyr)+")"),;
     CENNIK_S with _nr_cen_spr, EXPORT with "K"

sele 0
if !_use("SL_MAG","R"); BREAK; endif
set index to SL_MAG

if file("MAG_KAU.MEM")
  restore from MAG_KAU.MEM additive
endi
_nr_mag:=_mag_kau
@ 24,0 say "Magazyn opakowa : " get _nr_mag pict "@K 999";
           when SLGET("SL_MAG","SL_MAG","V2",1,1,{"magazyn"},,.f.);
           valid SZ().and.SL("SL_MAG","SL_MAG","V2",1,1)
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK; endi

_mag_kau:=_nr_mag                                                    //03.10.02
save to MAG_KAU all like _mag_kau

QPC(1)

SL_MAG->(dbseek(_nr_mag))
_seria_fak:=SERIA_FAK
SPR_N_F->SERIA_FAK:=_seria_fak
close SL_MAG
@ 24,0

sele SPR_N_F
repl  NR_MAG with _nr_mag
_rodz_dok:=RODZAJ_DOK

sele 0
if !_use("QSPR_P","R"); BREAK; endif
copy stru to (_sc+"SPR_P_F")
use

sele 0
_use(_sc+"SPR_P_F","E!")

// FKAU - zawiera indeksy, ceny, iloci opakowa
// SPR_N_F - nagwek pobrany z faktury oryginalnej
// SPR_P_F - puste pozycje faktury oryginalnej
// TOW - otwarty

sele 0
if !_use("MAG"+_nr_mag,"F","MAG"); BREAK; endi
set inde to ("M"+_nr_mag+"_IP"),("M"+_nr_mag+"_N"),;
            ("M"+_nr_mag+"_IP0"),("M"+_nr_mag+"_N0")
set rela to s_i(INDEKS) into TOW

sele FKAU
go top
do  while !eof()

  _ile:=FKAU->ILOSC
  if _ile<=0; skip; loop; endi

  sele MAG
  dbseek(s_i(FKAU->INDEKS))
  if found(); _rm:=MAG->(recn()); endi

  do while _ile>0.and.s_i(FKAU->INDEKS)==s_i(MAG->INDEKS).and.!eof()
    _cz:=CENA_ZAK
    _dd:=DATA_DOS
    _rm:=MAG->(recn())

    if STAN<=0; skip; loop; endi
    _ro:=if(_ile>STAN,STAN,_ile)

    SPR_P_F->(APPE_BLOK())
    SPR_P_F->INDEKS:=FKAU->INDEKS
    SPR_P_F->CENA_ZAK:= _cz //CENA_ZAK
    SPR_P_F->DATA_DOS:=_dd  //DATA_DOS
    SPR_P_F->CENA_SPR:=FKAU->CENA_SPR
    SPR_P_F->BONIFIKATA:=FKAU->CENA_SPR
    SPR_P_F->ILOSC:=_ro
    SPR_P_F->ZNAK:=-1
    _ile:=_ile-_ro

    sele MAG
    dbgoto(_rm)
    skip
  endd
  _rf:=FKAU->(recn())
  if _ile>0
    QKE("Brak opakowa na magazynie "+_nr_mag+" !")
    BREAK
  endi

  sele FKAU
  dbgoto(_rf)
  skip
endd

go top
do while !eof()
  if !INDEKS_OK(); BREAK; endi

  sele FKAU
  skip
endd
close FKAU

dele file (_sc+"FKAU.DBF")
dele file (_sc+"FKAU_I.NTX")

_rt=TOW->(recn())

sele SPR_P_F
go top
do while !eof()

  TOW->(dbseek(SPR_P_F->(INDEKS)))

  repl SPR_P_F->VAT with TOW->VAT
  do case
    case _nr_cen_spr="1"
      repl SPR_P_F->CENA_CEN_S with ;
              if(_ceny_1="N",TOW->CENA_1,TOW->CENA_1/(1+val(SPR_P_F->VAT)/100))
      repl SPR_P_F->CENA_BRU with ;
              if(_ceny_1="B",TOW->CENA_1,TOW->CENA_1*(1+val(SPR_P_F->VAT)/100))
    case _nr_cen_spr="2"
      repl SPR_P_F->CENA_CEN_S with ;
              iif(_ceny_2="N",TOW->CENA_2,TOW->CENA_2/(1+val(SPR_P_F->VAT)/100))
      repl SPR_P_F->CENA_BRU with ;
              if(_ceny_2="B",TOW->CENA_2,TOW->CENA_2*(1+val(SPR_P_F->VAT)/100))
    case _nr_cen_spr="3"
      repl SPR_P_F->CENA_CEN_S with ;
              iif(_ceny_3="N",TOW->CENA_3,TOW->CENA_3/(1+val(SPR_P_F->VAT)/100))
      repl SPR_P_F->CENA_BRU with ;
              if(_ceny_3="B",TOW->CENA_3,TOW->CENA_3*(1+val(SPR_P_F->VAT)/100))
  endc
  repl  SPR_P_F->CENA_DET  with CENA_BRU

  repl SPR_P_F->NAZWA_TOW  with TOW->NAZWA_TOW,;
       SPR_P_F->OPIS_TOW   with TOW->OPIS_TOW,;
       SPR_P_F->JM         with TOW->JM,;
       SPR_P_F->SWW        with TOW->SWW,;
       SPR_P_F->GRUPA_TOW  with TOW->GRUPA_TOW,;
       SPR_P_F->USLUGA     with TOW->USLUGA,;
       SPR_P_F->NR_KON     with TOW->NR_KON,;
       SPR_P_F->OPAKOWANIE with max(TOW->OPAKOWANIE,0)

  sele SPR_P_F
  skip
endd
TOW->(dbgoto(_rt))

sele SPR_P_F
repl all RODZAJ_DOK with SPR_N_F->RODZAJ_DOK,;
         DATA_DOK with SPR_N_F->DATA_DOK,;
         ROK_DOK with SPR_N_F->ROK_DOK,;
         SERIA_FAK with SPR_N_F->SERIA_FAK,;
         NR_MAG with SPR_N_F->NR_MAG

sele SPR_P_F
sum zaokr(ILOSC*CENA_ZAK,2),;
      if(VAT$"zw,np", zaokr(ILOSC*CENA_SPR,2),0),;
      if(VAT=" 0", zaokr(ILOSC*CENA_SPR,2),0),;
      if(VAT=_vat1,zaokr(ILOSC*CENA_SPR,2),0),;
      if(VAT=_vat2,zaokr(ILOSC*CENA_SPR,2),0),;
      if(VAT=_vat3,zaokr(ILOSC*CENA_SPR,2),0),;
      if(VAT=_vat4,zaokr(ILOSC*CENA_SPR,2),0),;
      zaokr((BONIFIKATA-CENA_SPR)*ILOSC,2),;
      if(CENA_CEN_S=0,zaokr((BONIFIKATA-CENA_SPR)*ILOSC,2),;
                      zaokr((CENA_CEN_S-CENA_SPR)*ILOSC,2)) ;
    to _wart_zak,_wart_n__,_wart_n_0,_wart_n_1,_wart_n_2,_wart_n_3,_wart_n_4,;
       _wart_b,_wart_k

if "."$_format_ilo
    _wart_zak:=zaokr(_wart_zak,2)
    _wart_n__:=zaokr(_wart_n__,2)
    _wart_n_0:=zaokr(_wart_n_0,2)
    _wart_n_1:=zaokr(_wart_n_1,2)
    _wart_n_2:=zaokr(_wart_n_2,2)
    _wart_n_3:=zaokr(_wart_n_3,2)
    _wart_n_4:=zaokr(_wart_n_4,2)
endi
_wart_v_1:=zaokr(_wart_n_1*val(_vat1)/100,2)
_wart_v_2:=zaokr(_wart_n_2*val(_vat2)/100,2)
_wart_v_3:=zaokr(_wart_n_3*val(_vat3)/100,2)
_wart_v_4:=zaokr(_wart_n_4*val(_vat4)/100,2)
_wart_n_spr:=_wart_n__+_wart_n_0+_wart_n_1+_wart_n_2+_wart_n_3+_wart_n_4
_wart_v_spr:=_wart_v_1+_wart_v_2+_wart_v_3+_wart_v_4

sele SPR_N_F
repl SPR_N_F->WART_ZAK   with _wart_zak,;
     SPR_N_F->WART_NET_  with _wart_n__, SPR_N_F->WART_NET0 with _wart_n_0,;
     SPR_N_F->WART_NET1  with _wart_n_1, SPR_N_F->WART_NET2 with _wart_n_2,;
     SPR_N_F->WART_VAT1  with _wart_v_1, SPR_N_F->WART_VAT2 with _wart_v_2,;
     SPR_N_F->WART_VAT3  with _wart_v_3, SPR_N_F->WART_NET3 with _wart_n_3,;
     SPR_N_F->WART_VAT4  with _wart_v_4, SPR_N_F->WART_NET4 with _wart_n_4,;
     SPR_N_F->BONIFIKATA with _wart_b,   SPR_N_F->RABAT_NET with _wart_k,;
     SPR_N_F->WART_ZAP   with _wart_n_spr+_wart_v_spr

close SPR_N_F
close SPR_P_F

*----------------------------------------------------------------------------

if !subs(_wersja,77,1)$"Bb"
    _zapisal:=.f.
    for i:=0 to 99
      _nr:=trans0(i,2)
      if !file(_sc+"\"+"S"+_rodz_dok+"_NR"+_nr+".DBF").and.;
         !file(_sc+"\"+"S"+_rodz_dok+"_PR"+_nr+".DBF")
        _zapisal:=.t.
        copy file (_sc+"SPR_N_F.DBF");
                           to (_sc+"S"+_rodz_dok+"_NR"+_nr+".DBF")
        copy file (_sc+"SPR_P_F.DBF");
                           to (_sc+"S"+_rodz_dok+"_PR"+_nr+".DBF")

*        copy file (_sc+"FAK_TXT.DBF");
*                           to (_sc+"FAK_TX"+_nr+".DBF")
        dele file (_sc+"FAK_TX"+_nr+".DBF")

        exit
      endi
    next
    if !_zapisal
      QKE(" Nie dokonano zapisu  faktury. ",;
          "Wyczerpany limit zapisw (100).")
    endi
else
    _zapisal:=.f.
    for i:=0 to 999
      _nr:=trans0(i,3)
      if !file("#00\flaga"+_nr).and.;
         !file("#00\"+"S"+_rodz_dok+"_N"+_nr+".DBF").and.;
         !file("#00\"+"S"+_rodz_dok+"_P"+_nr+".DBF")

        _flaga:=fcreate("#00\flaga"+_nr)
        fclose(_flaga)
        _zapisal:=.t.

        copy file (_sc+"SPR_N_F.DBF");
                              to ("#00\"+"S"+_rodz_dok+"_N"+_nr+".DBF")
        copy file (_sc+"SPR_P_F.DBF");
                              to ("#00\"+"S"+_rodz_dok+"_P"+_nr+".DBF")

*          copy file (_sc+"FAK_TXT.DBF");
*                              to ("#00\"+"FAK_T"+_nr+".DBF")
        dele file ("#00\"+"FAK_T"+_nr+".DBF")

        dele file (_sc+"S"+_rodz_dok+"_N_F.DBF")
        dele file (_sc+"S"+_rodz_dok+"_P_F.DBF")
        dele file ("#00\flaga"+_nr)
        exit
      endi
    next
    if !_zapisal
      QKE(" Nie dokonano zapisu  faktury. ",;
          "Wyczerpany limit zapisw (1000).")
    endi
endi

if _zapisal
  ROZKAU->(dbseek(ER(_ep_roz)+_nr_roz))
  ROZKAU->(dbeval({|| RBLOK(),ROZKAU->ROZLICZONY:="F",dbunlock()},,;
                  {|| DR(DATA_ROZ)+NR_ROZ==ER(_ep_roz)+_nr_roz}))
endi

CPClose(SPR_N_F)
CPClose(SPR_P_F)
CPClose(FAK_TXT)

_err:=.f.
@ 24,0

END SEQUENCE
close data
if _err
  tone(220,1)
  QKE("Nie utworzono faktury za opakowania !")
else
  QKE("Faktur za opakowania umieszczono w zapisie !")
endi

RETURN NIL

*******************************************************************************
FUNCTION WEGA_RAP(_nr_info,_saldo_ma)
local _wart_pz_bf:=0,_wart_rek:=0,_wart_mag:=0,;
      _sel:=select(),_rn:=recn()
local _screen:=savescreen(16,1,23,78),;
      _linia:=savescreen(23,0,24,79)

local _lrtow:=0

/* 
   _saldo_ma   - saldo MA wynikajse z faktur dostaw i zapat
   _wart_pz_bf - warto PZ bez faktur wg cen zakupu brutto (magazyn domylny)
   _wart_rek   - warto reklamacji oddanych dostawcy i niezaatwionych wg
                 ostatniej ceny zakupu brutto
   _wart_mag   - warto towaru dostawcy w magazynie domylnym wg cen zakupu 
                 brutto 
*/
    


BEGIN SEQUENCE

// 1. warto reklamacji
  sele 0
  if !_use("TOW","R","TOW_REK"); BREAK; endi
  set index to TOW_IN
  _lrtow:=lastrec()

sele 0
_use("CONFIG","R!")
if fieldpos("RAPORTY")>0 .and. !empty(_scie_rap:=alltrim(RAPORTY)).and.;
   file(_scie_rap+"REK_DOS.DBF")
  if empty(_magazyn)
    QKE("Konieczne okrelenie magazynu domylnego w opji KONFIGURACJA !")
    BREAK
  endi

  QPC(1,"Reklamacje ....")


  if !_use(_scie_rap+"REK_DOS","R"); BREAK; endi
  set index to (_scie_rap+"REK_D_N"),(_scie_rap+"REK_D_D"),;
                 (_scie_rap+"REK_D_Z")
  

  sele REK_DOS
  dbseek(_nr_info)
  do while (NR_KON==_nr_info) .and. !eof()
    if !empty(DATA_OK);skip;loop;endi
    TOW_REK->(dbseek(REK_DOS->(s_i(INDEKS))))
    _wart_rek+=zaokr(REK_DOS->ILOSC*TOW_REK->(CENA_ZAK *(1+val(VAT)/100)),2)
    skip
  enddo
  close REK_DOS
  QPC(0,"Reklamacje ....")
endi   

// 2. warto towaru w magazynie

sele 0
if !_use("MAG"+_magazyn,"R","MAG_RAP");  BREAK; endif
set inde to ("M"+_magazyn+"_IP0")

_astru:={}

// 1. ETAP - ZE SLOWNIKA TOWAROW KOPIUJENY INDEKSY DOSTAWCY

sele 0
aadd(_astru,{"INDEKS"     ,"C",LENIN, 0})
aadd(_astru,{"VAT"        ,"C",2    , 0})
dbcreate ((_sc+"INDEKSY"),_astru)
if !_use(_sc+"INDEKSY","E"); BREAK; endi

_total:=_lrtow
PASEK()
@ 23,0 say "Kopiowanie towarw dostawcy ...."

sele TOW_REK
dbeval({|| INDEKSY->(dbappend()),;
           INDEKSY->INDEKS:=TOW_REK->INDEKS,;
           INDEKSY->VAT   :=TOW_REK->VAT    },;
       {|| PASEK(10) .and. TOW_REK->NR_KON==_nr_info })
PASEK()
@ 23,0


sele INDEKSY
if !eof()
  _total:=lastrec()+2
  PASEK()
  @ 23,0 say "Warto towarw w magazynie ..."
  go top
  do while !eof()
    PASEK(1)
    sele MAG_RAP
    dbseek(INDEKSY->(s_i(INDEKS)))
    dbeval({|| _wart_mag+=MAG_RAP->(STAN*CENA_ZAK*;
                              (1+val(INDEKSY->VAT)/100))},,;
         {||  MAG_RAP->INDEKS==INDEKSY->INDEKS })

    sele INDEKSY
    skip
  enddo
  PASEK()
  @ 23,0
endif

//PASEK()


close INDEKSY
close MAG_RAP
close TOW_REK

// 3. warto PZ bez faktur 

sele 0
if !_use("DOK"+_magazyn+"N","R","DOK_RAP");  BREAK; endif
set inde to ("D"+_magazyn+"N_NR")           //RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK 

_total:=lastrec()
PASEK()
@ 23,0 say "Warto PZ bez faktur ....."
dbseek("PZ"+_magazyn)
dbeval({|| PASEK(1),;
                         _wart_pz_bf+= WART_NET_+WART_NET0+;
                         WART_NET1+WART_NET2+WART_NET3+WART_NET4+;
                         WART_VAT1+WART_VAT2+WART_VAT3+WART_VAT4 },;
       { || nr_kon==_NR_INFO .and. empty(OPIS_ZRO) },;
       { || RODZAJ_DOK=="PZ" .and. NR_MAG==_magazyn }         )
PASEK(1)
close DOK_RAP
@ 23,0
PASEK()

restscreen(23,0,24,79,_linia)

@ 16,1 clear to 23,78 
@ 16,1,23,78 BOX R_GRUBA

@ 17,3 say "Saldo MA dostawcy          :"+transform(_saldo_ma,_format_war)
@ 18,3 say "Warto PZ bez faktur      :"+transform(_wart_pz_bf,_format_war)
@ 19,3 say "Warto towaru w magazynie :"+transform(_wart_mag,_format_war)
@ 20,3 say "----------------------------"
@ 21,3 say "Do wypaty                 :" +transform(_saldo_ma+;
  _wart_pz_bf-_wart_mag,_format_war)
@ 22,3 say "Warto reklamacji         :"+transform(_wart_rek,_format_war)

inkey(0)
restscreen(16,1,23,78,_screen)


END SEQUENCE

CpClose(CONFIG)
CpClose(TOW_REK)

sele (_sel)
if used()
  dbgoto(_rn)
endi
RETURN NIL

*******************************************************************************
FUNCTION WA_ETYK(_naz_info,_pas_info,_indeks_info,_koddost,_sww,_c1,_wadex_gr)
local getlist:={},_astru:={},_sel:=select()

aadd(_astru,{"NAZWA     ","C",40,0})
aadd(_astru,{"KODPASK   ","C",20,0})
aadd(_astru,{"KOD       ","C",20,0})
aadd(_astru,{"KODDOST   ","C",20,0})
aadd(_astru,{"SWW       ","C",16,0})
aadd(_astru,{"GRUPA     ","C",10,0})
aadd(_astru,{"CENA      ","N",10,2})
dbcreate(_sc+"WA_ETYK",_astru)

sele 0
_use(_sc+"WA_ETYK","E!")
append blank
repl NAZWA with _naz_info,;
     KODPASK with str(_pas_info,13),;
     kod WITH _INDEKS_INFO,;
     KODDOST with _koddost,;
     SWW     with _sww,;
     CENA with _c1,;
     GRUPA with _wadex_gr

close WA_ETYK
sele (_sel)
tone(880,1)
QK("Wytworzono plik WA_ETYK.DBF w katalogu "+subs(_sc,1,len(_sc)-1))

RETU NIL

*******************************************************************************
FUNCTION POKAZ_TOW(g,d,_astany,_blo)
local _tk:="",_cena_wal,_naz_tow,_opis_tow,_sww,_jm,_ptu,_gru,_pas_info,;
      _dost,_zb,_i1,_i2,_i3,_stan:=0,_stan_b:=0,_wzak:=0,_mar1,_marcen:=.f.
local _stany:={},_format_mar:="@ZE 999.99"
local _aceny:=array(9,5),_lcen,_i,_pom_cen,_cn1,_pom1
local _colx:=subs(_ekra_blo,at(",",_ekra_blo)+1)
local _kolnetto,_kolbrutto,_kolmarza
local _znacznik:="",_waga_jedn:=0,_pojemnosc:=0
local pomcena, pomilo
local _stan_e:=0,_stan_eb:=0,_len_indeks:=0,_len_ilosc:=0




sele 0
_txt:=.t.
if !_use("TOW_TXT","S")
  _txt:=.f.
else
  set index to TOW_TXT
  if !dbseek (_indeks_info)
    APPE_BLOK()
    repl INDEKS with _indeks_info
  endi
  @ d,4 say " edycja - PgDn "
  @ d,38 say " skopiowanie z innego towaru - Ctrl V "
endi

@ g+14,43 say " poz.mag.- P "

sele TOWARY
_lcen:=len(_cenniki)

@ g+1,27 say  _indeks_info pict _format_ind COLOR _colx
_len_indeks:=len(transform(_indeks_info,_format_ind))
_len_ilosc:=len(transform(1.1,_format_ilo))

TOWARY->(dbseek(s_i(_indeks_info)))


if subs(_wersja,71,1)=="K".and.fieldpos("TYP_KONCES")>0
 _tk:=if( !empty(TYP_KONCES),"Typ konc.: "+TYP_KONCES,"")      //21.11.99
endi
_cena_wal:=TOWARY->CENA_WAL;_clo:=TOWARY->CLO
_naz_tow:=left(TOWARY->NAZWA_TOW,_len_naz)
_opis_tow:=if(_opisy_tow="T",left(TOWARY->OPIS_TOW,_len_opi),"")
_sww:=TOWARY->SWW
_jm:=TOWARY->JM
_ptu:=TOWARY->VAT
_gru:=TOWARY->GRUPA_TOW
_pas_info:=if(subs(_wersja,32,1)=="K",TOWARY->KOD_PAS,0)
_dost:=if(!empty(TOWARY->NR_KON),"Dostawca: "+TOWARY->NR_KON,"")
_znacznik:=TOWARY->USLUGA
_waga_jedn:=TOWARY->WAGA
_pojemnosc:=TOWARY->POJEMNOSC 
for _i:=1 to 9
 if _i<=_lcen
   _aceny[_i,1]:=eval(memvarblock("_ceny_"+str(_i,1)))   //B/N
   _pom_cen:=Eval(fieldblock("CENA_"+str(_i,1)))
   _aceny[_i,2]:=if(_aceny[_i,1]="N",_pom_cen,;         // cena netto
                                     zaokr(_pom_cen/(1+val(_ptu)/100),2))
   _aceny[_i,3]:=if(_aceny[_i,1]="B",_pom_cen,;         // cena brutto
                                     zaokr(_pom_cen*(1+val(_ptu)/100),2))
 else
   _aceny[_i,1]:="N";_aceny[_i,2]:=0;_aceny[_i,3]:=0
 endi
next       
_cn1:=_aceny[1,2]  // dla potrzeb stany

if subs(_wersja,32,1)=="K"
  @ g+2,27 say _pas_info pict repl("9",13) COLOR _colx
endi

close TOWARY


_zb:="MAG"+trans0(val(_mag_info),3)
//_i1:="M"+trans0(val(_mag_info),3)+"_IP0"             // 22.01.06
_i1:="M"+trans0(val(_mag_info),3)+"_IP"             // 15.02.06

sele 0
if !_use(_zb,"R","MAGAZYN");  BREAK; endif
set inde to (_i1)
seek s_i(_indeks_info)
dbeval({|| _stan:=_stan+STAN,;
            _stan_b:=_stan_b+STAN_B,;
           _wzak:=_wzak+zaokr(STAN*CENA_ZAK,2),;
           aadd(_stany,{ DATA_DOS,CENA_ZAK, STAN});
       },,{||s_i(_indeks_info)==s_i(INDEKS)})

close MAGAZYN

_blo:=_stan_b               //12.11.07

for _i:=1 to 9
  if _i<=_lcen
    _aceny[_i,4]:=zaokr(_stan*_aceny[_i,2],2)           //wartosc netto
    if _wzak<=0 .or. _aceny[_i,2]<=0
      _mar1:=9999
    elseif _typ_mar="2"
     _mar1:=(_aceny[_i,4]-_wzak)/_aceny[_i,4]*100
    elseif _typ_mar$" 1"
     _mar1:=(_aceny[_i,4]-_wzak)/_wzak*100
    endi
    if(abs(_mar1)<999,_pom1:=transform(_mar1,_format_mar),_pom1:="  ?   ")
    if !_udocezak;_pom1:="  *   ";endi
    _aceny[_i,5]:=_pom1
  else
    _aceny[_i,4]:=0
    _aceny[_i,5]:=""
  endi
next


//@@@@@@@@@@@@@@@
if _rozchody="1"
  asort(_stany,,,{ |x,y| x[2]<y[2] })   //wg CENA_ZAK
else
  asort(_stany,,,{ |x,y| x[1]>y[1] })     // wg DATA_DOS
endi

@ g+2,3 say "Grupa :   "+_gru

@ g+3,3 say _naz_tow COLOR _colx
@ g+3,col()+2  say padr(_opis_tow +"  "+_sww,73-len(_naz_tow))

@ g+3,65 say _tk  //21.11.99
@ g+1,50  say "Blok.: "
@ g+2,50 say "Stan : "
@ g+1,57 say  transform(_stan_b,_format_ilo) COLOR _colx
@ g+2,57 say  transform(_stan,_format_ilo) COLOR _colx
@ g+2,(cc:=col()+2) say _jm
@ g+1,cc say _jm
@ g+4,3 say "Ceny Netto   Brutto  Mara [%]"

************* pokazanie cen 

_kolnetto:=6
_kolbrutto:=6+len(transform(0,_format_cen))+1
_kolmarza:=_kolbrutto+len(transform(0,_format_cen))+1

for _i:=1 to _lcen
  @ g+4+_i,3 say str(_i,1)

  @ g+4+_i,_kolnetto say transform(_aceny[_i,2],_format_cen) COLOR _colx
  @ g+4+_i,_kolbrutto say  transform(_aceny[_i,3],_format_cen) COLOR _colx
  @ g+4+_i,_kolmarza say  _aceny[_i,5]

next


if _lcen<9
  @ g+4+_lcen+int((9-_lcen)/2+0.1),3 say ;
   "Cenniki "+str(_lcen+1,1)+" - 9 nieuywane"
endi

********************

if _zestawy 

  _zb:="MAG"+trans0(val(_mag_info),3)
  _i1:="M"+trans0(val(_mag_info),3)+"_IP"             // 15.02.06

  sele 0
  if !_use(_zb,"R","MAGAZYN");  BREAK; endif
  set inde to (_i1)

  sele 0
  if ! _use("ZES","R","ZES_INFO");BREAK;endif
  set index to ZES_I,ZES_E

  if dbseek(s_i(_indeks_info))
    _astany:={}
    
    dbeval(;
    {|| MAGAZYN->(dbseek(s_i(ZES_INFO->INDEKS_E))),;
        _stan_e:=0,_stan_eb:=0,_max_ilo:=0,;
        MAGAZYN->(dbeval({|| _stan_e+=MAGAZYN->STAN,;
                             _stan_eb+=MAGAZYN->STAN_B};
        ,,{||MAGAZYN->(s_i(INDEKS))==ZES_INFO->(s_i(INDEKS_E))})),;
        if(ZES_INFO->ILOSC>0,;
          _max_ilo:=INT((_stan_e-_stan_eb)/ZES_INFO->ILOSC),_max_ilo:=0),;
        _max_ilo:=max(0,_max_ilo),;
        aadd(_astany,{s_i(INDEKS_E),transform(_stan_e,_format_ilo),;
      transform(_stan_eb,_format_ilo),_max_ilo})},,;
    {||s_i(INDEKS)==s_i(_indeks_info)})            

    if len(_astany)>=1
      asort(_astany,,,{|a,b| a[4]<=b[4]} )
      aeval(_astany,{|a| a[4]:=transform(a[4],"999")})
      @ g+14,52 say " elementy zestawu  -  P "
      @ g+4,38 clear to g+4,77
      @ g+4,38 say;
       padr("Elem.",_len_indeks)+" "+padr("Stan",_len_ilosc)+" "+;
             padr("Blokada",_len_ilosc)+" "+"Z."
      @ g+5,38 clear to g+13,77

      keyboard(chr(K_ESC))
      abrowse(@_astany,g+5,38,g+9,77)
    endi
    if _txt
      keyboard chr(K_ESC)
      MEMOEDIT(TOW_TXT->TEKST,g+16,3,d-1,76,.f.)
      close TOW_TXT
    endi
    close ZES_INFO
    close MAGAZYN
    RETURN NIL
  endi
  close ZES_INFO
  close MAGAZYN
endi


@ g+4,38 say ;
 "Data zak. Cena netto    Stan   Mara %"
  @ g+5,38 clear to g+13,77

_astany:={}


for _i:=1 to len(_stany)
  

//  @ g+4+_i, 38 say dtoc(_stany[_i,1])
  if _udocezak
    pomcena:= transform(_stany[_i,2],_format_cen)
  else
    pomcena:= "   *"
  endi
    pomilo:=transform(_stany[_i,3],_format_ilo)

// Uwaga ! Wariant wartocowy liczenia mar - nie daje mary dla stanu 0
//         Wariant cenowy po zamianie _stany[_i,3] na 1
/*
  if _stany[_i,3]<=0
     _stany[_i,3]:=1.000   //19.10.96 dla stanu 0 wariant cenowy mary
     _marcen:=.t.
  endif
*/
  _wzak:=zaokr(_stany[_i,3]*_stany[_i,2],2)
  _wcn1:=zaokr(_stany[_i,3]*_cn1,2)
  if _wzak<=0 .or. _wcn1<=0
    _mar1:=9999
  elseif _typ_mar="2"
    _mar1:=(_wcn1-_wzak)/_wcn1*100
  elseif _typ_mar$" 1"
    _mar1:=(_wcn1-_wzak)/_wzak*100
  endi
  if(abs(_mar1)<999,_pom1:=transform(_mar1,_format_mar),_pom1:="   ?  ")
  if !_pom1=="   ?   ".and._marcen
    _pom1+="!"
  else
    _pom1+=" "
  endi
  if !_udocezak;_pom1:="  *   ";endi
//  @ g+4+_i, 71 say _pom1
 _marcen:=.f.
 aadd(_astany,{dtoc(_stany[_i,1]),pomcena,pomilo,_pom1})

next
if len(_astany)>=1
  keyboard(chr(K_ESC))



  abrowse(@_astany,g+5,38,g+9,77)
endi


if _udocezak .and.(_cena_wal>0 .or. _clo>0)
  @ g+10,38 say "Cena walutowa: "+transform(_cena_wal,_format_cen)
  @ g+11,38 say "Co: "+transform(_clo,"@ZE 999.99")+"%"
endif
if !empty(_pojemnosc)
  @ g+11,56 say "Poj."+_jm_poj_tow+": "+;
                left(transform(_pojemnosc,_forpoj_tow),11)
endi

@ g+12,38 say "PTU: "+_ptu+if(_ptu<>"zw","%"," ") COLOR _colx

if !empty(_waga_jedn)
  @ g+12,56 say "Waga"+_jm_wag_tow+": "+;
                left(transform(_waga_jedn,_forwag_tow),12)
endi


@ g+13,38 say _dost
if !empty(_znacznik)
  @ g+13,col()+3 say "Znacznik: "
  @ g+13,col()+1 say _znacznik COLOR _colx
endi


if _txt
  keyboard chr(K_ESC)
  MEMOEDIT(TOW_TXT->TEKST,g+16,3,d-1,76,.f.)

  close TOW_TXT
endi

RETU NIL

*******************************************************************************
FUNCTION POZ_DOKP(_rd,_nm,_rk,_nd)                               //07.10.04
// POZ_DOKP(g,d,RODZAJ_DOK,NR_MAG,ROK_DOK,NR_DOK)
local _lk:=lastkey(),_osele:=select(),getlist:={},_opis_zro:=space(20),;
      _screen,_rn:=recn(),_key
priv _wl:="zl"

if (_lk=Asc("d") .or. _lk=Asc("D")) .and. !empty(_nm) .and. _rd="PZ"

  BEGIN SEQUENCE
  _screen:=savescreen(24,0,24,79)
 _key:=_rd+_nm+_rk+_nd

  sele 0
  if !_use("DOK"+_nm+"N","S","DN_OPIS"); BREAK; endif
  set inde to ("D"+_nm+"N_NR")
  seek _key
  _opis_zro:=OPIS_ZRO

  set(_SET_COLOR,_ekra_blo)
  @ 24,0


  @ 24,0 say  DN_OPIS->(RODZAJ_DOK+"-"+NR_DOK+"/"+NR_MAG+"/"+ROK_DOK)+;
    "  F-ra dost. : " get _opis_zro
  set curs on; read; set curs off
  if lastkey()=K_ESC; BREAK; endif
  if updated()
    DN_OPIS->(RBLOK())
    repl DN_OPIS->OPIS_ZRO with _opis_zro
    repl ZDOK_R->OPIS_ZRO with _opis_zro
//    Eval(fieldwblock("OPIS_ZRO",_osele),_opis_zro)
  endi  

  END SEQUENCE
  CpClose(DN_OPIS)
  restscreen(24,0,24,79,_screen)
  set(_SET_COLOR,_edit_blo)

  sele (_osele)
  dbgoto(_rn)
  CpSwiezyRekord()
endi

if _lk=K_SPACE.and.!empty(_nm)

  BEGIN SEQUENCE

        _key:=_rd+_nm+_rk+_nd

        sele 0
        if !_use("TOW","R","DO_NAZW2"); BREAK; endif
        set inde to TOW_IN

        sele 0
        _astru:={}
        aadd(_astru,{"INDEKS"     ,"C",LENIN, 0})
        aadd(_astru,{"NAZWA_TOW"  ,"C",max(40,_len_naz), 0})
        aadd(_astru,{"OPIS_TOW"   ,"C",max(20,_len_opi), 0})      
        aadd(_astru,{"CENA_ZAK"  ,"N",12, 2})
        aadd(_astru,{"JM"        ,"C", 4, 0})      
        aadd(_astru,{"ILOSC"      ,"N",12, 3})      
        aadd(_astru,{"CENA_SPR"   ,"N",12, 2})      
        dbcreate ((_sc+"POZ_DOKP"),_astru)
        if !_use(_sc+"POZ_DOKP","E"); BREAK; endi
 
        sele 0
        if !_use("DOK"+_nm+"P","R","DO_POZ2"); BREAK; endif
        set inde to ("D"+_nm+"P_NR")
 
        seek _key
        dbeval({|| POZ_DOKP->(dbappend()),;
                   POZ_DOKP->INDEKS:=DO_POZ2->INDEKS,;
                   DO_NAZW2->(dbseek(POZ_DOKP->(s_i(INDEKS)))),;
                   POZ_DOKP->NAZWA_TOW:=DO_NAZW2->NAZWA_TOW,;
                   POZ_DOKP->OPIS_TOW:=DO_NAZW2->OPIS_TOW,;
                   POZ_DOKP->JM:=DO_NAZW2->JM,;
                   POZ_DOKP->CENA_ZAK:=DO_POZ2->CENA_ZAK,;
                   POZ_DOKP->ILOSC:=DO_POZ2->ILOSC,;
                   POZ_DOKP->CENA_SPR:=DO_POZ2->CENA_SPR},,;
                   {|| _key==(RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK)})
 
        sele POZ_DOKP
        close DO_POZ2
        close DO_NAZW2
        go top
        CPEDIT  POZ: 6,2,20,77 ;
                DEF: "SPR_P"                 ;
                POZWER: "V5|V_OPISY_TOW()"                 ;
                KOLOR: _slow_blo  ;
                PION: ,,,                    
 
        clear typeahead
 
  END SEQUENCE
  CPClose(POZ_DOKP)
  CPClose(DO_NAZW2)

  sele (_osele)
endi

RETURN NIL

*******************************************************************************
FUNCTION FAK_INFO(g,d,_rd,_sf,_rf,_nf,_nrk)                          //07.10.04
local _sel:=select(),_ocolor:=SET(_SET_COLOR),_lk:=lastkey()

/*
doda w ZFAK() akcj :

CPEDIT  POZ: 5,,23,               ;
        DEF: "iZFAK"               ;
        POZWER: _wer              ;
        POZSLAD: " "+ RODZAJ_DOK+"-"+NR_DOK+"/"+SERIA_FAK+"/"+ROK_DOK+spac(5)+;
                  subs(KON->NAZWA_KON,1,40)  ;
        PION: ,,,                 ;
        AKCJA: FAK_INFO(0,24,RODZAJ_DOK,SERIA_FAK,subs(ROK_DOK,3,2),NR_DOK,;
                        NR_KON);
        INDEXY: {"Rodzaj i nr dokumentu","Nr kontrahenta","Data dokumentu"}   

i wyczy tone() w POZ_INFO() :

        CPEDIT  POZ: g+5,8,d-1,77 ;
                DEF: "SPR_P"                 ;
                POZWER: "V5|V_OPISY_TOW()"                 ;
                PION: ,,,

        clear typeahead
        * tone(880,0.5)
*/
if _lk=K_ENTER.or._lk=K_SPACE
   set key K_ALT_K to
   set key K_ALT_J to

   BEGIN SEQUENCE

   sele 0
   if !_use("SPR_N","R","INFO_SPR"); BREAK; endi
   apom:={1,2,3,4,5,25,34,36,38,53}                    
   set index to SPR_N_NR

/*
   sele 0
   _use("QNR","R!")
   copy stru to (_sc+"SPR_INFO")
   _use(_sc+"SPR_INFO","E!")
*/

   sele INFO_SPR
   seek _rd+_sf+ep(_rf)+_nf                       
   if !found()
     tone(220,1)
     BREAK
   else
     copy next 1 to (_sc+"SPR_INFO")

     sele 0
    _use(_sc+"SPR_INFO","E!")
   endif

/*
   bwhi:= {|| NR_KON==_nrk }
   bwyk:= {|| POLCOPY(INFO_SPR,SPR_INFO),;
         SPR_INFO->NUMER_FAK :=SPR_INFO->( NR_DOK+"/"+SERIA_FAK+"/"+;
                               right(ROK_DOK,2)  )}                     //10.07.99

   dbeval(bwyk,,bwhi)
*/   

   POZ_INFO(g,d,_rd,_sf,_rf,_nf)

   END SEQUENCE

   sele (_sel)
   CPClose(SPR_INFO)
   CPClose(INFO_SPR)
   set(_SET_COLOR,_ocolor)
   setkey (K_ALT_K ,{|p,l,v| KON_INFO(p,l,v,"o")})
   setkey (K_ALT_J ,{|p,l,v| KON_INFO(p,l,v,"d")})
endi
RETURN NIL

*******************************************************************************
FUNCTION WYDRUKI()                                                   //31.01.06
local _tex:='۲  RAPORT WYDRUKW WIELOKROTNYCH  '
local _data_o,_data_d

cls
@ 0,0 say _tex

if !file("WYDRUKI.DBF")
  QKE("Opcja nieskonfigurowana. Brak pliku WYDRUKI.DBF !")
  RETURN NIL
endi

_data_o:=date(); _data_d=date()
@ 1,0 say "Raport za okres :" get _data_o vali _data_o<=_data_d;
                                               .and.!empty(_data_o)
@ 1,col()+1 say "-" get _data_d vali _data_o<=_data_d;
                                               .and.!empty(_data_d)
set curs on; read; SLGET(); set curs off
if lastkey()=K_ESC; BREAK; endi

sele 0
if !_use("WYDRUKI","S"); BREAK; endi
if !file("WYDRUK_W.NTX")
  INDEX_WYDRUKI()
endi
set index to WYDRUK_W,WYDRUK_D,WYDRUK_C
set order to 3
dbseek(_data_o,.t.)
copy to (_sc+"WYDRUKI") for WYDRUK>0 while DATA<=_data_d
use

sele 0
_use(_sc+"WYDRUKI","E!")
index on dtos(DATA)+GODZINA+DOKUMENT to (_sc+"WYDRUK_C")
index on DOKUMENT+dtos(DATA)+GODZINA to (_sc+"WYDRUK_D")
set index to (_sc+"WYDRUK_C"),(_sc+"WYDRUK_D")
go top

CPEDIT  POZ: 2,,23,               ;
        DEF: "iWYDRUKI"           ;
        POZWER: "V1"              ;
        PION: ,,,                 ;
        INDEXY: {"data","dokument"}      ;
        ODTWORZ:.f.

if len(_zaznaczone)>0
  set filter to ascan(_zaznaczone,recn())>0
endi
go top
CPDRUK  DEF: "WYDRUKI"            ;
        WERSJA: "V1"              ;
        TYTUL: "WYDRUKI WIELOKROTNE "+dtoc(_data_o)+"-"+dtoc(_data_d) ;
        WARIANT: 1         

close data
dele file(_sc+"WYDRUKI.DBF")
dele file(_sc+"WYDRUK_C.NTX")
dele file(_sc+"WYDRUK_D.NTX")
@ 24,0

if HorizMenu(24,0,"Skasowanie danych do "+dtoc(date()-30)+ "? ",;
         {"TAK","NIE"},2)=1.and.HA(_haslo)

   CPClose(WYDRUKI)

   if _use("WYDRUKI","E")
     set index to WYDRUK_W,WYDRUK_D,WYDRUK_C
     QPC(1)
     TONE(880,1)
     dele all for DATA<date()-30
     pack
     QPC(0)
   endi
endi

close data

RETURN NIL

*******************************************************************************
FUNCTION INDEX_WYDRUKI()
if file("WYDRUKI.DBF")

  _use("WYDRUKI","E!")
  if _priorytet=10; @ 23,0 say "WYDRUKI"+spac(12); endi
  inde on DOKUMENT to WYDRUK_D
  inde on DOKUMENT to WYDRUK_W for WYDRUK>0
  inde on DATA to WYDRUK_C for WYDRUK>0
endi
RETURN NIL

*******************************************************************************
FUNCTION T_STAMP
RETURN dtos(date())+charrem(":",TIME())

*******************************************************************************
FUNCTION BLOK_INFO(_mag,_ind,g,d,_jm,_blok)
*---------------------------- informacja o blokadach
local _sele:=select(),;
      _okno:=savescreen(g+3,41,g+6,76)
local _colx:=subs(_ekra_blo,at(",",_ekra_blo)+1),_cc
local _blo_fak:=0   // blokady na fakturach=blokady calkowite-blokady z BLOKADY
local _blo_recz:=0

BEGIN SEQUENCE

sele 0
if !_use("BLOKADY","R","BLO_INFO"); BREAK;endi
set index to BLOK_PO,BLOK_IN,BLOK_NR
set order to 2   //NR_MAG+s_i(INDEKS)
seek (_mag+s_i(_ind))
sum ILOSC to _blo_recz while s_i(INDEKS)==s_i(_ind)
close BLO_INFO

@ g+3,41 clear to g+6,76
@ g+3,41,g+6,76 BOX R_PODW

@ g+4,43  say "Blok. rczne: "
@ g+5,43  say "F-ry w zapis."
@ g+4,57 say  transform(_blo_recz,_format_ilo) COLOR _colx
@ g+5,57 say  transform(_blok-_blo_recz,_format_ilo) COLOR _colx
@ g+4,(cc:=col()+2) say _jm
@ g+5,cc say _jm


inkey(0)
END SEQUENCE
restscreen(g+3,41,g+6,76,_okno)
sele (_sele)
RETURN NIL

*******************************************************************************
FUNCTION ZAPIS()
loca _tex:='۲  ZAPIS DOKUMENTW Z ZADANEGO OKRESU DO KATALOGU  '
loca _kat:=spac(30),getlist:={},apom:={},_i
loca _n,_rd,_nd,_ldoki,_klucz,_pom,i
loca _adoki:={},_typ:="*",_ardok:={}
// loca prevhandler:=errorblock()
priv  _rodz_dok:=spac(26),_nr_mag:=spac(3),_data_od:=date(),_data_do:=date()

cls
@ 0,0 say _tex

BEGIN SEQUENCE

sele 0
if !_use("SL_DOK","R"); BREAK; endi
set index to SL_DOK

if file("POB_DOKU.DBF")

  sele 0
  if _use("POB_DOKU.DBF","R") .and. !empty(SCIEZKA)
    _kat:=padr(alltrim(SCIEZKA),30)
    close POB_DOKU
  endi 
endi

sele 0
if empty(_gdzie_fir)
  if !_use("KON","R"); BREAK; endi
  set index to KON_NR
else
  if !_use(_gdzie_fir+"FIRMY","R","KON"); BREAK; endi
  set index to (_gdzie_fir+"FIRMY_NR")
endi
copy stru to (_sc+"KON_R")

sele 0
if !_use(_sc+"KON_R","E"); BREAK; endi
index on NR_KON to (_sc+"KON_R")

sele 0
if !_use("SL_MAG","R"); BREAK; endi
set index to SL_MAG

@ 1,0 say "Magazyn :  " get _nr_mag pict "999";
      when SLGET("SL_MAG","SL_MAG","V2",1,1,{"nr magazynu"},,.f.,BEZBLOK);
      vali SZ().and.SL("SL_MAG","SL_MAG","V2",1,1).and.SLGET()
@ 2,0 say "Dokumenty :" get _rodz_dok pict "@!";
           when SLGET("SL_DOK","SL_DOK","V2",1001,1,{""},,.f.,BEZBLOK);
           vali DOKI_OK(_rodz_dok,@_adoki,@_typ).and.SLGET()
@ 3,0 say "Okres :    " get _data_od ;
                        vali _data_od <= date().and.DODATY(_data_od,@_data_do)
@ 3,col()+1 say "-" get _data_do;
                        vali _data_do <= date().and._data_do>=_data_od
@ 4,0 say "Katalog :  " get _kat pict "@!";
      vali DIR_EXIST(alltrim(_kat)).or.(right(alltrim(_kat),1)=="\".and.;
           DIR_EXIST(subs(alltrim(_kat),1,len(alltrim(_kat))-1)))
set curs on; read; set curs off
if empty(_rodz_dok).or.empty(_nr_mag).or.lastkey()=K_ESC; BREAK; endi

_k:=alltrim(_kat)
if right(_k,1)<>"\"
   _k+="\"
endi

QPC(1)

sele 0
if !_use("SL_G_TOW","R"); BREAK; endi
copy to (_k+"SL_G_TOW")
close SL_G_TOW

sele 0
if !_use("SL_JM","R"); BREAK; endi
copy to (_k+"SL_JM")
close SL_JM

sele 0
if !_use("TOW","R"); BREAK; endi
set index to TOW_IN
copy to (_k+"TOW")

sele 0
_use("QDOKP","R!")
copy stru to (_sc+"POZ_ROB")
_use(_sc+"POZ_ROB","E!")

sele 0
if !_use("DOK"+_nr_mag+"N","R!","DOKN"); BREAK; endi
set index to ("D"+_nr_mag+"N"+"_NR"), ("D"+_nr_mag+"N"+"_RD")
set order to 2                       // RODZAJ_DOK+NR_MAG+dtos(DATA_DOK)+NR_DOK

sele SL_DOK
go top
do while !eof()
  if !RODZAJ_DOK$_rodz_dok; skip; loop; endi
  _pom1:=RODZAJ_DOK+_nr_mag+dtos(_data_od)
  _pom2:=RODZAJ_DOK+_nr_mag+dtos(_data_do)

  sele DOKN
  dbseek(_pom1,.t.)
  dbeval({|| aadd(_adoki,RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK )},,;
         {|| RODZAJ_DOK+NR_MAG+dtos(DATA_DOK)<=_pom2 })

 sele SL_DOK
 skip
endd

if (_ldoki:=len(_adoki))=0
  QKE("Brak danych do zapisu !")
  BREAK
endi

DOKN->(dbsetorder(1))

sele 0
if !_use("DOK"+_nr_mag+"P","R!","DOKP"); BREAK; endi
set index to ("D"+_nr_mag+"P"+"_NR")
//inde on RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK to (_i1)
for _i:=1 to fcount(); aadd(apom,_i); next

for i:=1 to _ldoki
  _klucz:=_adoki[i]
  dbseek(_adoki[i])
  dbeval({|| POLCOPY(DOKP,POZ_ROB),;
             TOW->(dbseek(DOKP->(s_i(INDEKS)))),;
             DOKN->(dbseek(_klucz)),;
             POZ_ROB->NR_KON:=DOKN->NR_KON,;
             POZ_ROB->NAZWA_TOW:=TOW->NAZWA_TOW,;
             POZ_ROB->JM:=TOW->JM,;
             POZ_ROB->SWW:=TOW->SWW },,;
             {|| RODZAJ_DOK+NR_MAG+ROK_DOK+NR_DOK ==_klucz })
next

clos TOW
clos DOKN

sele KON
apom:={}; for i:=1 to fcount(); aadd(apom,i); next

sele POZ_ROB
index on RODZAJ_DOK+NR_DOK to (_sc+"POZ_ROB")
go top

_rd:=""
_nd:=""
do while DATA_DOK>=_data_od.and.DATA_DOK<=_data_do.and.!eof()

  if !RODZAJ_DOK==_rd.or.!NR_DOK==_nd
    _rd:=RODZAJ_DOK; _nd:=NR_DOK; _re:=recn(); _n:=0
    do while RODZAJ_DOK==_rd.and.NR_DOK==_nd
      _n:=_n+1
      skip
    endd
    go _re
    copy next _n to (_k+_rd+_nd+"."+_nr_mag)

    KON_R->(dbseek(POZ_ROB->NR_KON))
    if !empty(POZ_ROB->NR_KON).and.KON_R->(!found())
      KON->(dbseek(POZ_ROB->NR_KON))
      Eval({|| RECAPPEND(KON,KON_R)})
    endi

    sele POZ_ROB
  endi

  skip
endd

sele KON_R
if lastrec()>0
  copy to (_k+"KON_UPG") fiel NR_KON,GRUPA_KON,ID_KON,NAZWA_KON,;
       NAZWA_KON2,KOD,MIASTO,ADRES,TELEFON,NAZWA_BAN,KONTO_BAN,UWAGI,NAZWA_ODB
endi

QPC(0)
QKE("Zapis wykonano !")

END SEQUENCE
clos data
//errorblock(prevhandler)
dele file (_sc+"POZ_ROB.DBF")
dele file (_sc+"POZ_ROB.NTX")
dele file (_sc+"KON_R.DBF")
dele file (_sc+"KON_R.NTX")
RETU NIL

*******************************************************************************
FUNCTION JAKIE_DOK()
loca _tex:='۲  WYKAZ DOKUMENTW ZAPISANYCH W KATALOGU  ',;
     _pliki,_astru:={},_errblo:=errorblock(),_ka,;
     _kat:=spac(30),getlist:={},apom:={},_data_dok,_wart_zak
priv _dok:="  /     /   "

cls
@ 0,0 say _tex

BEGIN SEQUENCE

if file("POB_DOKU.DBF")

  sele 0
  if _use("POB_DOKU.DBF","R") .and. !empty(SCIEZKA)
    _kat:=padr(alltrim(SCIEZKA),30)
    close POB_DOKU
  endi 
endi

@ 1,0 say "Uwaga : Pozycje dokumentw zapisane na dyskietce mog by pobrane w czasie"
@ 2,0 say "        edycji dokumentu klawiszem CTRL Q przy pustym polu edycyjnym."

@ 3,0 say "Katalog : " get _kat pict "@!" ;
      vali DIR_EXIST(alltrim(_kat)).or.(right(alltrim(_kat),1)=="\".and.;
           DIR_EXIST(subs(alltrim(_kat),1,len(alltrim(_kat))-1)))
set curs on; read; set curs off
if lastkey()=K_ESC; BREAK;endif

_ka:=alltrim(_kat)
if right(_ka,1)<>"\"
  _ka+="\"
endi

QPC(1)

_pliki:=DIRECTORY(_ka+"*.*")
set curs off

sele 0
if file(_ka+"KON_UPG.DBF").and._use(_ka+"KON_UPG","R")
  copy to (_sc+"KON_TMP")

  _use(_sc+"KON_TMP","R")
  index on NR_KON to (_sc+"KON_TMP")
endi

sele 0
CREA_PLIDO()
_use(_sc+"PLIDOK","E!")
inde on NAZWA to (_sc+"PLIDOK_N")
inde on dtos(DATA)+CZAS to (_sc+"PLIDOK_D")
set inde to (_sc+"PLIDOK_N"), (_sc+"PLIDOK_D")

aeval(_pliki,{ |aPrnFile| PLIDOK->(dbappend()),;
          PLIDOK->NAZWA:=aPrnFile[F_NAME],;
          PLIDOK->DATA:=aPrnFile[F_DATE],;
          PLIDOK->CZAS:=aPrnFile[F_TIME],;
          PLIDOK->ROZMIAR:=aPrnFile[F_SIZE],;
          PLIDOK->DOKUMENT:=;
       PLIDOK->(subs(NAZWA,1,2)+"/"+subs(NAZWA,3,5)+"/"+subs(NAZWA,9,3)) })

go top
do while !eof()

  sele 0
  _dbf:=.t.
  BEGIN SEQUENCE
  _data_dok:=ctod("")
  _wart_zak:=0
  errorblock({|e| TESTDBF() })
  if !_use(_ka+PLIDOK->(alltrim(NAZWA)),"R","PLIK_TMP")
     _dbf:=.f.
  else

    if fieldpos("NR_DOK")=0.or.fieldpos("NR_KON")=0.or.;
       fieldpos("ILOSC")=0.or.fieldpos("CENA_ZAK")=0.or.;
       val(subs(PLIDOK->NAZWA,9,3))=0
      _dbf:=.f.
    else
      PLIDOK->NR_KON:=NR_KON
      _data_dok:=DATA_DOK
      sum ILOSC*CENA_ZAK to _wart_zak
    endi
    use
  endi
  END SEQUENCE

  errorblock(_errblo)

  sele PLIDOK
  if !_dbf
     dbdelete()
  else
    if select("KON_TMP")>0
       KON_TMP->(dbseek(PLIDOK->NR_KON)) 
       PLIDOK->NAZWA_KON:=KON_TMP->NAZWA_KON
    endi
    PLIDOK->DATA_DOK:=_data_dok
    PLIDOK->WART_ZAK:=_wart_zak
  endi

  skip
endd

QPC(0)
set(_SET_COLOR,_ekra_blo)
go top
@ 23,0 say "Uwaga : Pliki do skasowania naley zaznaczy klawiszem Ins."

CPEDIT  POZ: 4,,22,               ;
        DEF: "PLIKI"              ;
        POZWER: "V3"              ;
        PION: ,,,                 ;
        INDEXY: {"nazwa","data"}  ;
        EDYCJA: .f.               ;
        ODTWORZ:.f.

if len(_zaznaczone)>0 .and. QTN("Skasowa zaznaczone pliki ?")
  set filter to ascan(_zaznaczone,recn())>0  
  go top
  do while !eof()
    dele file (_ka+PLIDOK->(alltrim(NAZWA)))
    dbdelete()
    skip
  enddo
  set filt to
  
  go top
  @ 23,0
  CPEDIT POZ: 4,,22,               ;
         DEF: "PLIKI"              ;
         POZWER: "V2"              ;
         PION: ,,,                 ;
         INDEXY: {"nazwa","data"}  ;
         EDYCJA: .f.               ;
         ODTWORZ:.f.
endi

go top
CPDRUK  DEF: "PLIKI"                 ;
        WERSJA: "V2"               ;
        TYTUL: "WYKAZ DOKUMETW W KATALOGU "+_ka;
        WARIANT: 13
@ 24,0

if file (_ka+"KON_UPG.DBF")
  if Horizmenu(24,0,"Aktualizacja sownika o nowych kontrahentw ?",{"TAK","NIE"},2)=1;
        .and.HA(_haslo)
  else
    BREAK
  endi

  clos data

  QPC(1)

  sele 0
  if empty(_gdzie_fir)
    if !_use("KON","S"); BREAK; endif
    set index to KON_NR, KON_NA, KON_NI, KON_AD
  else
    if !_use(_gdzie_fir+"FIRMY","S","KON"); BREAK; endif
    set index to (_gdzie_fir+"FIRMY_NR"),(_gdzie_fir+"FIRMY_NA"),;
                 (_gdzie_fir+"FIRMY_NI"),(_gdzie_fir+"FIRMY_AD")
  endi
  copy stru to (_sc+"KON_UPG")

  sele 0
  if !_use(_sc+"KON_UPG","E"); BREAK; endi
  appe from (_ka+"KON_UPG")
  apom:={}; for i:=1 to fcount(); aadd(apom,i); next

  go top
  do while !eof()

    KON->(dbseek(KON_UPG->NR_KON))
    if KON->(!found())
      Eval({|| RECAPPEND(KON_UPG,KON)})
    endi

    sele KON_UPG
    skip
  endd


  QPC(0)
  tone(880,1)
  QKE("Wykonano aktualizacj sownika kontrahentw.")
endi

END SEQUENCE
clos data
dele file (_sc+"KON_UPG.DBF")

RETURN NIL

*******************************************************************************
FUNCTION CEN_INFO()
local getlist:={}, _okno,_cursor:=setcursor(),;
      _osele:=select(),_ocolo:=SET(_SET_COLOR,_ekra_blo),;
      _zb,_i1,_r:=row(),_c:=col(),;
      _out:=.f.,_old_esc:=set(_SET_ESCAPE,.t.),_pom,g,d
local _k,_l   // lewa kolumna ramki
static _cena:=0
_ktory_rekord:=0

if subs(_wersja,32,1)<>"C"
  RETURN NIL
endi

g:=1
d:=23

SHOWTIME()


set key K_SH_F8 to

BEGIN SEQUENCE

_l:=len(transform(space(20),_format_ind))+; //indeks
    _len_naz+;                             // nazwa  
    len(transform(0.00,_format_cen))+;       // cena
    4+;                                     // kulumny browsera
    5                                       // marginesy


_k:=78-_l

_okno:=savescreen(g,_k,d,78)

@ g,_k clea to d,78
@ g,_k,d,78 BOX R_GRUBA

@ g+2,_k+2 say "Cena:" get _cena pict _format_cen
@ g+2,col()+1 say "(+/- 25%)"

set curs on;  read;  set curs off

if lastkey()=K_ESC
  BREAK
endif

sele 0
if !_use("TOW","R","TOW_CEN")
  BREAK
else
  set index to ("TOW_SW")
endif

dbseek(_cena,.t.)

keyboard(repl(chr(K_UP),2)+repl(chr(K_DOWN),2)+if(found(),chr(K_RIGHT),chr(0)))

CPEDIT  POZ: g+3,_k+2,d-1,76              ;
        DEF: "TOW"              ;
        POZWER: "V11"            ;
        POZSLAD: " "+s_i(INDEKS)+" "+subs(NAZWA_TOW,1,40);
        PION: ,,,                 ;
        INDEXY: {}                ;
        WARUNEK: CENA_1<=1.25*_cena .and. CENA_1>=0.75*_cena ;
        GORA: NIL;
        DOL:  NIL;
        AKCJA: PODAJ_REK()        ;
        KOLORUJ:KOLORY_CEN(_cena) ;
        ODTWORZ:.f.

/*        GORA: FilterTop(_cena)    ;
        DOL:  FilterBottom(_cena) ;
*/

if _ktory_rekord>0
 TOW_CEN->(dbgoto(_ktory_rekord))
 keyboard(alltrim(TOW_CEN->INDEKS))
endi

END SEQUENCE

getlist:={};_ktory_rekord:=0
CPClose(TOW_CEN)
set(_SET_ESCAPE,_old_esc)
restscreen(g,_k,d,78,_okno)
if _osele > 0; sele (_osele); endif
setcursor(_cursor)
devpos(_r,_c)
SET(_SET_COLOR,_ocolo)
set key K_SH_F8 to CEN_INFO()
RETU NIL

*******************************************************************************
FUNCTION AKTYWNE1(p)
local _okno
local g:=1,_kl:=3,d,_kp:=60


d:=g+10
_okno:=savescreen(g,_kl,d,_kp)

@ g,_kl clea to d,_kp
@ g,_kl,d,_kp BOX R_GRUBA
@ g+1,_kl+2 say "Aktywne klawisze:"
@ g+2,_kl+2 say "Spacja - faktury/dostawy -> Enter - pozycje"
@ g+3,_kl+2 say "*      - faktury kontrahenta jako odbiorcy  (Alt_K)"
@ g+4,_kl+2 say "*      - raport z dostaw  (Alt_J i ustawiony par.105)"
@ g+5,_kl+2 say "Tab    - zamwienia"
@ g+6,_kl+2 say "Backsp.- ceny towaru dla kontrahenta (tylko Alt_K)" 
@ g+7,_kl+2 say "z/Z    - zaliczki (tylko Alt_K)"
@ g+8,_kl+2 say "r/R    - upusty (tylko Alt_K)"
@ g+9,_kl+2 say "x/X    - saldo wpat i wypat XX (tylko Alt_K)"

inkey(0)
restscreen(g,_kl,d,_kp,_okno)

RETURN NIL


